# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import os

# try/except added for compatibility with python < 3.8
try:
    from unittest import mock
    from unittest.mock import AsyncMock  # pragma: NO COVER
except ImportError:  # pragma: NO COVER
    import mock

from collections.abc import Iterable
import json
import math

from google.api_core import (
    future,
    gapic_v1,
    grpc_helpers,
    grpc_helpers_async,
    operation,
    operations_v1,
    path_template,
)
from google.api_core import client_options
from google.api_core import exceptions as core_exceptions
from google.api_core import operation_async  # type: ignore
import google.auth
from google.auth import credentials as ga_credentials
from google.auth.exceptions import MutualTLSChannelError
from google.cloud.location import locations_pb2
from google.iam.v1 import iam_policy_pb2  # type: ignore
from google.iam.v1 import options_pb2  # type: ignore
from google.iam.v1 import policy_pb2  # type: ignore
from google.longrunning import operations_pb2
from google.oauth2 import service_account
from google.protobuf import any_pb2  # type: ignore
from google.protobuf import duration_pb2  # type: ignore
from google.protobuf import empty_pb2  # type: ignore
from google.protobuf import field_mask_pb2  # type: ignore
from google.protobuf import json_format
from google.protobuf import timestamp_pb2  # type: ignore
from google.rpc import status_pb2  # type: ignore
import grpc
from grpc.experimental import aio
from proto.marshal.rules import wrappers
from proto.marshal.rules.dates import DurationRule, TimestampRule
import pytest
from requests import PreparedRequest, Request, Response
from requests.sessions import Session

from google.cloud.vmmigration_v1.services.vm_migration import (
    VmMigrationAsyncClient,
    VmMigrationClient,
    pagers,
    transports,
)
from google.cloud.vmmigration_v1.types import vmmigration


def client_cert_source_callback():
    return b"cert bytes", b"key bytes"


# If default endpoint is localhost, then default mtls endpoint will be the same.
# This method modifies the default endpoint so the client can produce a different
# mtls endpoint for endpoint testing purposes.
def modify_default_endpoint(client):
    return (
        "foo.googleapis.com"
        if ("localhost" in client.DEFAULT_ENDPOINT)
        else client.DEFAULT_ENDPOINT
    )


def test__get_default_mtls_endpoint():
    api_endpoint = "example.googleapis.com"
    api_mtls_endpoint = "example.mtls.googleapis.com"
    sandbox_endpoint = "example.sandbox.googleapis.com"
    sandbox_mtls_endpoint = "example.mtls.sandbox.googleapis.com"
    non_googleapi = "api.example.com"

    assert VmMigrationClient._get_default_mtls_endpoint(None) is None
    assert (
        VmMigrationClient._get_default_mtls_endpoint(api_endpoint) == api_mtls_endpoint
    )
    assert (
        VmMigrationClient._get_default_mtls_endpoint(api_mtls_endpoint)
        == api_mtls_endpoint
    )
    assert (
        VmMigrationClient._get_default_mtls_endpoint(sandbox_endpoint)
        == sandbox_mtls_endpoint
    )
    assert (
        VmMigrationClient._get_default_mtls_endpoint(sandbox_mtls_endpoint)
        == sandbox_mtls_endpoint
    )
    assert VmMigrationClient._get_default_mtls_endpoint(non_googleapi) == non_googleapi


@pytest.mark.parametrize(
    "client_class,transport_name",
    [
        (VmMigrationClient, "grpc"),
        (VmMigrationAsyncClient, "grpc_asyncio"),
        (VmMigrationClient, "rest"),
    ],
)
def test_vm_migration_client_from_service_account_info(client_class, transport_name):
    creds = ga_credentials.AnonymousCredentials()
    with mock.patch.object(
        service_account.Credentials, "from_service_account_info"
    ) as factory:
        factory.return_value = creds
        info = {"valid": True}
        client = client_class.from_service_account_info(info, transport=transport_name)
        assert client.transport._credentials == creds
        assert isinstance(client, client_class)

        assert client.transport._host == (
            "vmmigration.googleapis.com:443"
            if transport_name in ["grpc", "grpc_asyncio"]
            else "https://vmmigration.googleapis.com"
        )


@pytest.mark.parametrize(
    "transport_class,transport_name",
    [
        (transports.VmMigrationGrpcTransport, "grpc"),
        (transports.VmMigrationGrpcAsyncIOTransport, "grpc_asyncio"),
        (transports.VmMigrationRestTransport, "rest"),
    ],
)
def test_vm_migration_client_service_account_always_use_jwt(
    transport_class, transport_name
):
    with mock.patch.object(
        service_account.Credentials, "with_always_use_jwt_access", create=True
    ) as use_jwt:
        creds = service_account.Credentials(None, None, None)
        transport = transport_class(credentials=creds, always_use_jwt_access=True)
        use_jwt.assert_called_once_with(True)

    with mock.patch.object(
        service_account.Credentials, "with_always_use_jwt_access", create=True
    ) as use_jwt:
        creds = service_account.Credentials(None, None, None)
        transport = transport_class(credentials=creds, always_use_jwt_access=False)
        use_jwt.assert_not_called()


@pytest.mark.parametrize(
    "client_class,transport_name",
    [
        (VmMigrationClient, "grpc"),
        (VmMigrationAsyncClient, "grpc_asyncio"),
        (VmMigrationClient, "rest"),
    ],
)
def test_vm_migration_client_from_service_account_file(client_class, transport_name):
    creds = ga_credentials.AnonymousCredentials()
    with mock.patch.object(
        service_account.Credentials, "from_service_account_file"
    ) as factory:
        factory.return_value = creds
        client = client_class.from_service_account_file(
            "dummy/file/path.json", transport=transport_name
        )
        assert client.transport._credentials == creds
        assert isinstance(client, client_class)

        client = client_class.from_service_account_json(
            "dummy/file/path.json", transport=transport_name
        )
        assert client.transport._credentials == creds
        assert isinstance(client, client_class)

        assert client.transport._host == (
            "vmmigration.googleapis.com:443"
            if transport_name in ["grpc", "grpc_asyncio"]
            else "https://vmmigration.googleapis.com"
        )


def test_vm_migration_client_get_transport_class():
    transport = VmMigrationClient.get_transport_class()
    available_transports = [
        transports.VmMigrationGrpcTransport,
        transports.VmMigrationRestTransport,
    ]
    assert transport in available_transports

    transport = VmMigrationClient.get_transport_class("grpc")
    assert transport == transports.VmMigrationGrpcTransport


@pytest.mark.parametrize(
    "client_class,transport_class,transport_name",
    [
        (VmMigrationClient, transports.VmMigrationGrpcTransport, "grpc"),
        (
            VmMigrationAsyncClient,
            transports.VmMigrationGrpcAsyncIOTransport,
            "grpc_asyncio",
        ),
        (VmMigrationClient, transports.VmMigrationRestTransport, "rest"),
    ],
)
@mock.patch.object(
    VmMigrationClient, "DEFAULT_ENDPOINT", modify_default_endpoint(VmMigrationClient)
)
@mock.patch.object(
    VmMigrationAsyncClient,
    "DEFAULT_ENDPOINT",
    modify_default_endpoint(VmMigrationAsyncClient),
)
def test_vm_migration_client_client_options(
    client_class, transport_class, transport_name
):
    # Check that if channel is provided we won't create a new one.
    with mock.patch.object(VmMigrationClient, "get_transport_class") as gtc:
        transport = transport_class(credentials=ga_credentials.AnonymousCredentials())
        client = client_class(transport=transport)
        gtc.assert_not_called()

    # Check that if channel is provided via str we will create a new one.
    with mock.patch.object(VmMigrationClient, "get_transport_class") as gtc:
        client = client_class(transport=transport_name)
        gtc.assert_called()

    # Check the case api_endpoint is provided.
    options = client_options.ClientOptions(api_endpoint="squid.clam.whelk")
    with mock.patch.object(transport_class, "__init__") as patched:
        patched.return_value = None
        client = client_class(transport=transport_name, client_options=options)
        patched.assert_called_once_with(
            credentials=None,
            credentials_file=None,
            host="squid.clam.whelk",
            scopes=None,
            client_cert_source_for_mtls=None,
            quota_project_id=None,
            client_info=transports.base.DEFAULT_CLIENT_INFO,
            always_use_jwt_access=True,
            api_audience=None,
        )

    # Check the case api_endpoint is not provided and GOOGLE_API_USE_MTLS_ENDPOINT is
    # "never".
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_MTLS_ENDPOINT": "never"}):
        with mock.patch.object(transport_class, "__init__") as patched:
            patched.return_value = None
            client = client_class(transport=transport_name)
            patched.assert_called_once_with(
                credentials=None,
                credentials_file=None,
                host=client.DEFAULT_ENDPOINT,
                scopes=None,
                client_cert_source_for_mtls=None,
                quota_project_id=None,
                client_info=transports.base.DEFAULT_CLIENT_INFO,
                always_use_jwt_access=True,
                api_audience=None,
            )

    # Check the case api_endpoint is not provided and GOOGLE_API_USE_MTLS_ENDPOINT is
    # "always".
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_MTLS_ENDPOINT": "always"}):
        with mock.patch.object(transport_class, "__init__") as patched:
            patched.return_value = None
            client = client_class(transport=transport_name)
            patched.assert_called_once_with(
                credentials=None,
                credentials_file=None,
                host=client.DEFAULT_MTLS_ENDPOINT,
                scopes=None,
                client_cert_source_for_mtls=None,
                quota_project_id=None,
                client_info=transports.base.DEFAULT_CLIENT_INFO,
                always_use_jwt_access=True,
                api_audience=None,
            )

    # Check the case api_endpoint is not provided and GOOGLE_API_USE_MTLS_ENDPOINT has
    # unsupported value.
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_MTLS_ENDPOINT": "Unsupported"}):
        with pytest.raises(MutualTLSChannelError):
            client = client_class(transport=transport_name)

    # Check the case GOOGLE_API_USE_CLIENT_CERTIFICATE has unsupported value.
    with mock.patch.dict(
        os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": "Unsupported"}
    ):
        with pytest.raises(ValueError):
            client = client_class(transport=transport_name)

    # Check the case quota_project_id is provided
    options = client_options.ClientOptions(quota_project_id="octopus")
    with mock.patch.object(transport_class, "__init__") as patched:
        patched.return_value = None
        client = client_class(client_options=options, transport=transport_name)
        patched.assert_called_once_with(
            credentials=None,
            credentials_file=None,
            host=client.DEFAULT_ENDPOINT,
            scopes=None,
            client_cert_source_for_mtls=None,
            quota_project_id="octopus",
            client_info=transports.base.DEFAULT_CLIENT_INFO,
            always_use_jwt_access=True,
            api_audience=None,
        )
    # Check the case api_endpoint is provided
    options = client_options.ClientOptions(
        api_audience="https://language.googleapis.com"
    )
    with mock.patch.object(transport_class, "__init__") as patched:
        patched.return_value = None
        client = client_class(client_options=options, transport=transport_name)
        patched.assert_called_once_with(
            credentials=None,
            credentials_file=None,
            host=client.DEFAULT_ENDPOINT,
            scopes=None,
            client_cert_source_for_mtls=None,
            quota_project_id=None,
            client_info=transports.base.DEFAULT_CLIENT_INFO,
            always_use_jwt_access=True,
            api_audience="https://language.googleapis.com",
        )


@pytest.mark.parametrize(
    "client_class,transport_class,transport_name,use_client_cert_env",
    [
        (VmMigrationClient, transports.VmMigrationGrpcTransport, "grpc", "true"),
        (
            VmMigrationAsyncClient,
            transports.VmMigrationGrpcAsyncIOTransport,
            "grpc_asyncio",
            "true",
        ),
        (VmMigrationClient, transports.VmMigrationGrpcTransport, "grpc", "false"),
        (
            VmMigrationAsyncClient,
            transports.VmMigrationGrpcAsyncIOTransport,
            "grpc_asyncio",
            "false",
        ),
        (VmMigrationClient, transports.VmMigrationRestTransport, "rest", "true"),
        (VmMigrationClient, transports.VmMigrationRestTransport, "rest", "false"),
    ],
)
@mock.patch.object(
    VmMigrationClient, "DEFAULT_ENDPOINT", modify_default_endpoint(VmMigrationClient)
)
@mock.patch.object(
    VmMigrationAsyncClient,
    "DEFAULT_ENDPOINT",
    modify_default_endpoint(VmMigrationAsyncClient),
)
@mock.patch.dict(os.environ, {"GOOGLE_API_USE_MTLS_ENDPOINT": "auto"})
def test_vm_migration_client_mtls_env_auto(
    client_class, transport_class, transport_name, use_client_cert_env
):
    # This tests the endpoint autoswitch behavior. Endpoint is autoswitched to the default
    # mtls endpoint, if GOOGLE_API_USE_CLIENT_CERTIFICATE is "true" and client cert exists.

    # Check the case client_cert_source is provided. Whether client cert is used depends on
    # GOOGLE_API_USE_CLIENT_CERTIFICATE value.
    with mock.patch.dict(
        os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": use_client_cert_env}
    ):
        options = client_options.ClientOptions(
            client_cert_source=client_cert_source_callback
        )
        with mock.patch.object(transport_class, "__init__") as patched:
            patched.return_value = None
            client = client_class(client_options=options, transport=transport_name)

            if use_client_cert_env == "false":
                expected_client_cert_source = None
                expected_host = client.DEFAULT_ENDPOINT
            else:
                expected_client_cert_source = client_cert_source_callback
                expected_host = client.DEFAULT_MTLS_ENDPOINT

            patched.assert_called_once_with(
                credentials=None,
                credentials_file=None,
                host=expected_host,
                scopes=None,
                client_cert_source_for_mtls=expected_client_cert_source,
                quota_project_id=None,
                client_info=transports.base.DEFAULT_CLIENT_INFO,
                always_use_jwt_access=True,
                api_audience=None,
            )

    # Check the case ADC client cert is provided. Whether client cert is used depends on
    # GOOGLE_API_USE_CLIENT_CERTIFICATE value.
    with mock.patch.dict(
        os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": use_client_cert_env}
    ):
        with mock.patch.object(transport_class, "__init__") as patched:
            with mock.patch(
                "google.auth.transport.mtls.has_default_client_cert_source",
                return_value=True,
            ):
                with mock.patch(
                    "google.auth.transport.mtls.default_client_cert_source",
                    return_value=client_cert_source_callback,
                ):
                    if use_client_cert_env == "false":
                        expected_host = client.DEFAULT_ENDPOINT
                        expected_client_cert_source = None
                    else:
                        expected_host = client.DEFAULT_MTLS_ENDPOINT
                        expected_client_cert_source = client_cert_source_callback

                    patched.return_value = None
                    client = client_class(transport=transport_name)
                    patched.assert_called_once_with(
                        credentials=None,
                        credentials_file=None,
                        host=expected_host,
                        scopes=None,
                        client_cert_source_for_mtls=expected_client_cert_source,
                        quota_project_id=None,
                        client_info=transports.base.DEFAULT_CLIENT_INFO,
                        always_use_jwt_access=True,
                        api_audience=None,
                    )

    # Check the case client_cert_source and ADC client cert are not provided.
    with mock.patch.dict(
        os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": use_client_cert_env}
    ):
        with mock.patch.object(transport_class, "__init__") as patched:
            with mock.patch(
                "google.auth.transport.mtls.has_default_client_cert_source",
                return_value=False,
            ):
                patched.return_value = None
                client = client_class(transport=transport_name)
                patched.assert_called_once_with(
                    credentials=None,
                    credentials_file=None,
                    host=client.DEFAULT_ENDPOINT,
                    scopes=None,
                    client_cert_source_for_mtls=None,
                    quota_project_id=None,
                    client_info=transports.base.DEFAULT_CLIENT_INFO,
                    always_use_jwt_access=True,
                    api_audience=None,
                )


@pytest.mark.parametrize("client_class", [VmMigrationClient, VmMigrationAsyncClient])
@mock.patch.object(
    VmMigrationClient, "DEFAULT_ENDPOINT", modify_default_endpoint(VmMigrationClient)
)
@mock.patch.object(
    VmMigrationAsyncClient,
    "DEFAULT_ENDPOINT",
    modify_default_endpoint(VmMigrationAsyncClient),
)
def test_vm_migration_client_get_mtls_endpoint_and_cert_source(client_class):
    mock_client_cert_source = mock.Mock()

    # Test the case GOOGLE_API_USE_CLIENT_CERTIFICATE is "true".
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": "true"}):
        mock_api_endpoint = "foo"
        options = client_options.ClientOptions(
            client_cert_source=mock_client_cert_source, api_endpoint=mock_api_endpoint
        )
        api_endpoint, cert_source = client_class.get_mtls_endpoint_and_cert_source(
            options
        )
        assert api_endpoint == mock_api_endpoint
        assert cert_source == mock_client_cert_source

    # Test the case GOOGLE_API_USE_CLIENT_CERTIFICATE is "false".
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": "false"}):
        mock_client_cert_source = mock.Mock()
        mock_api_endpoint = "foo"
        options = client_options.ClientOptions(
            client_cert_source=mock_client_cert_source, api_endpoint=mock_api_endpoint
        )
        api_endpoint, cert_source = client_class.get_mtls_endpoint_and_cert_source(
            options
        )
        assert api_endpoint == mock_api_endpoint
        assert cert_source is None

    # Test the case GOOGLE_API_USE_MTLS_ENDPOINT is "never".
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_MTLS_ENDPOINT": "never"}):
        api_endpoint, cert_source = client_class.get_mtls_endpoint_and_cert_source()
        assert api_endpoint == client_class.DEFAULT_ENDPOINT
        assert cert_source is None

    # Test the case GOOGLE_API_USE_MTLS_ENDPOINT is "always".
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_MTLS_ENDPOINT": "always"}):
        api_endpoint, cert_source = client_class.get_mtls_endpoint_and_cert_source()
        assert api_endpoint == client_class.DEFAULT_MTLS_ENDPOINT
        assert cert_source is None

    # Test the case GOOGLE_API_USE_MTLS_ENDPOINT is "auto" and default cert doesn't exist.
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": "true"}):
        with mock.patch(
            "google.auth.transport.mtls.has_default_client_cert_source",
            return_value=False,
        ):
            api_endpoint, cert_source = client_class.get_mtls_endpoint_and_cert_source()
            assert api_endpoint == client_class.DEFAULT_ENDPOINT
            assert cert_source is None

    # Test the case GOOGLE_API_USE_MTLS_ENDPOINT is "auto" and default cert exists.
    with mock.patch.dict(os.environ, {"GOOGLE_API_USE_CLIENT_CERTIFICATE": "true"}):
        with mock.patch(
            "google.auth.transport.mtls.has_default_client_cert_source",
            return_value=True,
        ):
            with mock.patch(
                "google.auth.transport.mtls.default_client_cert_source",
                return_value=mock_client_cert_source,
            ):
                (
                    api_endpoint,
                    cert_source,
                ) = client_class.get_mtls_endpoint_and_cert_source()
                assert api_endpoint == client_class.DEFAULT_MTLS_ENDPOINT
                assert cert_source == mock_client_cert_source


@pytest.mark.parametrize(
    "client_class,transport_class,transport_name",
    [
        (VmMigrationClient, transports.VmMigrationGrpcTransport, "grpc"),
        (
            VmMigrationAsyncClient,
            transports.VmMigrationGrpcAsyncIOTransport,
            "grpc_asyncio",
        ),
        (VmMigrationClient, transports.VmMigrationRestTransport, "rest"),
    ],
)
def test_vm_migration_client_client_options_scopes(
    client_class, transport_class, transport_name
):
    # Check the case scopes are provided.
    options = client_options.ClientOptions(
        scopes=["1", "2"],
    )
    with mock.patch.object(transport_class, "__init__") as patched:
        patched.return_value = None
        client = client_class(client_options=options, transport=transport_name)
        patched.assert_called_once_with(
            credentials=None,
            credentials_file=None,
            host=client.DEFAULT_ENDPOINT,
            scopes=["1", "2"],
            client_cert_source_for_mtls=None,
            quota_project_id=None,
            client_info=transports.base.DEFAULT_CLIENT_INFO,
            always_use_jwt_access=True,
            api_audience=None,
        )


@pytest.mark.parametrize(
    "client_class,transport_class,transport_name,grpc_helpers",
    [
        (VmMigrationClient, transports.VmMigrationGrpcTransport, "grpc", grpc_helpers),
        (
            VmMigrationAsyncClient,
            transports.VmMigrationGrpcAsyncIOTransport,
            "grpc_asyncio",
            grpc_helpers_async,
        ),
        (VmMigrationClient, transports.VmMigrationRestTransport, "rest", None),
    ],
)
def test_vm_migration_client_client_options_credentials_file(
    client_class, transport_class, transport_name, grpc_helpers
):
    # Check the case credentials file is provided.
    options = client_options.ClientOptions(credentials_file="credentials.json")

    with mock.patch.object(transport_class, "__init__") as patched:
        patched.return_value = None
        client = client_class(client_options=options, transport=transport_name)
        patched.assert_called_once_with(
            credentials=None,
            credentials_file="credentials.json",
            host=client.DEFAULT_ENDPOINT,
            scopes=None,
            client_cert_source_for_mtls=None,
            quota_project_id=None,
            client_info=transports.base.DEFAULT_CLIENT_INFO,
            always_use_jwt_access=True,
            api_audience=None,
        )


def test_vm_migration_client_client_options_from_dict():
    with mock.patch(
        "google.cloud.vmmigration_v1.services.vm_migration.transports.VmMigrationGrpcTransport.__init__"
    ) as grpc_transport:
        grpc_transport.return_value = None
        client = VmMigrationClient(client_options={"api_endpoint": "squid.clam.whelk"})
        grpc_transport.assert_called_once_with(
            credentials=None,
            credentials_file=None,
            host="squid.clam.whelk",
            scopes=None,
            client_cert_source_for_mtls=None,
            quota_project_id=None,
            client_info=transports.base.DEFAULT_CLIENT_INFO,
            always_use_jwt_access=True,
            api_audience=None,
        )


@pytest.mark.parametrize(
    "client_class,transport_class,transport_name,grpc_helpers",
    [
        (VmMigrationClient, transports.VmMigrationGrpcTransport, "grpc", grpc_helpers),
        (
            VmMigrationAsyncClient,
            transports.VmMigrationGrpcAsyncIOTransport,
            "grpc_asyncio",
            grpc_helpers_async,
        ),
    ],
)
def test_vm_migration_client_create_channel_credentials_file(
    client_class, transport_class, transport_name, grpc_helpers
):
    # Check the case credentials file is provided.
    options = client_options.ClientOptions(credentials_file="credentials.json")

    with mock.patch.object(transport_class, "__init__") as patched:
        patched.return_value = None
        client = client_class(client_options=options, transport=transport_name)
        patched.assert_called_once_with(
            credentials=None,
            credentials_file="credentials.json",
            host=client.DEFAULT_ENDPOINT,
            scopes=None,
            client_cert_source_for_mtls=None,
            quota_project_id=None,
            client_info=transports.base.DEFAULT_CLIENT_INFO,
            always_use_jwt_access=True,
            api_audience=None,
        )

    # test that the credentials from file are saved and used as the credentials.
    with mock.patch.object(
        google.auth, "load_credentials_from_file", autospec=True
    ) as load_creds, mock.patch.object(
        google.auth, "default", autospec=True
    ) as adc, mock.patch.object(
        grpc_helpers, "create_channel"
    ) as create_channel:
        creds = ga_credentials.AnonymousCredentials()
        file_creds = ga_credentials.AnonymousCredentials()
        load_creds.return_value = (file_creds, None)
        adc.return_value = (creds, None)
        client = client_class(client_options=options, transport=transport_name)
        create_channel.assert_called_with(
            "vmmigration.googleapis.com:443",
            credentials=file_creds,
            credentials_file=None,
            quota_project_id=None,
            default_scopes=("https://www.googleapis.com/auth/cloud-platform",),
            scopes=None,
            default_host="vmmigration.googleapis.com",
            ssl_credentials=None,
            options=[
                ("grpc.max_send_message_length", -1),
                ("grpc.max_receive_message_length", -1),
            ],
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListSourcesRequest,
        dict,
    ],
)
def test_list_sources(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListSourcesResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_sources(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListSourcesRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListSourcesPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_sources_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        client.list_sources()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListSourcesRequest()


@pytest.mark.asyncio
async def test_list_sources_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.ListSourcesRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListSourcesResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_sources(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListSourcesRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListSourcesAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_sources_async_from_dict():
    await test_list_sources_async(request_type=dict)


def test_list_sources_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListSourcesRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        call.return_value = vmmigration.ListSourcesResponse()
        client.list_sources(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_sources_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListSourcesRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListSourcesResponse()
        )
        await client.list_sources(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_sources_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListSourcesResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_sources(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_sources_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_sources(
            vmmigration.ListSourcesRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_sources_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListSourcesResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListSourcesResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_sources(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_sources_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_sources(
            vmmigration.ListSourcesRequest(),
            parent="parent_value",
        )


def test_list_sources_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListSourcesResponse(
                sources=[],
                next_page_token="def",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_sources(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.Source) for i in results)


def test_list_sources_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_sources), "__call__") as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListSourcesResponse(
                sources=[],
                next_page_token="def",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_sources(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_sources_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_sources), "__call__", new_callable=mock.AsyncMock
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListSourcesResponse(
                sources=[],
                next_page_token="def",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_sources(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.Source) for i in responses)


@pytest.mark.asyncio
async def test_list_sources_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_sources), "__call__", new_callable=mock.AsyncMock
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListSourcesResponse(
                sources=[],
                next_page_token="def",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_sources(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetSourceRequest,
        dict,
    ],
)
def test_get_source(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.Source(
            name="name_value",
            description="description_value",
            vmware=vmmigration.VmwareSourceDetails(username="username_value"),
        )
        response = client.get_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.Source)
    assert response.name == "name_value"
    assert response.description == "description_value"


def test_get_source_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_source), "__call__") as call:
        client.get_source()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetSourceRequest()


@pytest.mark.asyncio
async def test_get_source_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.GetSourceRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.Source(
                name="name_value",
                description="description_value",
            )
        )
        response = await client.get_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.Source)
    assert response.name == "name_value"
    assert response.description == "description_value"


@pytest.mark.asyncio
async def test_get_source_async_from_dict():
    await test_get_source_async(request_type=dict)


def test_get_source_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetSourceRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_source), "__call__") as call:
        call.return_value = vmmigration.Source()
        client.get_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_source_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetSourceRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_source), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(vmmigration.Source())
        await client.get_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_source_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.Source()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_source(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_source_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_source(
            vmmigration.GetSourceRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_source_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.Source()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(vmmigration.Source())
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_source(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_source_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_source(
            vmmigration.GetSourceRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateSourceRequest,
        dict,
    ],
)
def test_create_source(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_source_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_source), "__call__") as call:
        client.create_source()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateSourceRequest()


@pytest.mark.asyncio
async def test_create_source_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CreateSourceRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_source_async_from_dict():
    await test_create_source_async(request_type=dict)


def test_create_source_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateSourceRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_source), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_source_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateSourceRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_source), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_source_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_source(
            parent="parent_value",
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            source_id="source_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].source
        mock_val = vmmigration.Source(
            vmware=vmmigration.VmwareSourceDetails(username="username_value")
        )
        assert arg == mock_val
        arg = args[0].source_id
        mock_val = "source_id_value"
        assert arg == mock_val


def test_create_source_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_source(
            vmmigration.CreateSourceRequest(),
            parent="parent_value",
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            source_id="source_id_value",
        )


@pytest.mark.asyncio
async def test_create_source_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_source(
            parent="parent_value",
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            source_id="source_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].source
        mock_val = vmmigration.Source(
            vmware=vmmigration.VmwareSourceDetails(username="username_value")
        )
        assert arg == mock_val
        arg = args[0].source_id
        mock_val = "source_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_source_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_source(
            vmmigration.CreateSourceRequest(),
            parent="parent_value",
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            source_id="source_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateSourceRequest,
        dict,
    ],
)
def test_update_source(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.update_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_update_source_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_source), "__call__") as call:
        client.update_source()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateSourceRequest()


@pytest.mark.asyncio
async def test_update_source_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.UpdateSourceRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.update_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_update_source_async_from_dict():
    await test_update_source_async(request_type=dict)


def test_update_source_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateSourceRequest()

    request.source.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_source), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.update_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "source.name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_update_source_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateSourceRequest()

    request.source.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_source), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.update_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "source.name=name_value",
    ) in kw["metadata"]


def test_update_source_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.update_source(
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].source
        mock_val = vmmigration.Source(
            vmware=vmmigration.VmwareSourceDetails(username="username_value")
        )
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


def test_update_source_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_source(
            vmmigration.UpdateSourceRequest(),
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.asyncio
async def test_update_source_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.update_source(
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].source
        mock_val = vmmigration.Source(
            vmware=vmmigration.VmwareSourceDetails(username="username_value")
        )
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


@pytest.mark.asyncio
async def test_update_source_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.update_source(
            vmmigration.UpdateSourceRequest(),
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteSourceRequest,
        dict,
    ],
)
def test_delete_source(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.delete_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_delete_source_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_source), "__call__") as call:
        client.delete_source()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteSourceRequest()


@pytest.mark.asyncio
async def test_delete_source_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.DeleteSourceRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.delete_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteSourceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_delete_source_async_from_dict():
    await test_delete_source_async(request_type=dict)


def test_delete_source_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteSourceRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_source), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.delete_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_delete_source_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteSourceRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_source), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.delete_source(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_delete_source_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.delete_source(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_delete_source_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_source(
            vmmigration.DeleteSourceRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_delete_source_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_source), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.delete_source(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_delete_source_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.delete_source(
            vmmigration.DeleteSourceRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.FetchInventoryRequest,
        dict,
    ],
)
def test_fetch_inventory(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.fetch_inventory), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.FetchInventoryResponse(
            vmware_vms=vmmigration.VmwareVmsDetails(
                details=[vmmigration.VmwareVmDetails(vm_id="vm_id_value")]
            ),
        )
        response = client.fetch_inventory(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.FetchInventoryRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.FetchInventoryResponse)


def test_fetch_inventory_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.fetch_inventory), "__call__") as call:
        client.fetch_inventory()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.FetchInventoryRequest()


@pytest.mark.asyncio
async def test_fetch_inventory_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.FetchInventoryRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.fetch_inventory), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.FetchInventoryResponse()
        )
        response = await client.fetch_inventory(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.FetchInventoryRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.FetchInventoryResponse)


@pytest.mark.asyncio
async def test_fetch_inventory_async_from_dict():
    await test_fetch_inventory_async(request_type=dict)


def test_fetch_inventory_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.FetchInventoryRequest()

    request.source = "source_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.fetch_inventory), "__call__") as call:
        call.return_value = vmmigration.FetchInventoryResponse()
        client.fetch_inventory(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "source=source_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_fetch_inventory_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.FetchInventoryRequest()

    request.source = "source_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.fetch_inventory), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.FetchInventoryResponse()
        )
        await client.fetch_inventory(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "source=source_value",
    ) in kw["metadata"]


def test_fetch_inventory_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.fetch_inventory), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.FetchInventoryResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.fetch_inventory(
            source="source_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].source
        mock_val = "source_value"
        assert arg == mock_val


def test_fetch_inventory_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.fetch_inventory(
            vmmigration.FetchInventoryRequest(),
            source="source_value",
        )


@pytest.mark.asyncio
async def test_fetch_inventory_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.fetch_inventory), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.FetchInventoryResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.FetchInventoryResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.fetch_inventory(
            source="source_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].source
        mock_val = "source_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_fetch_inventory_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.fetch_inventory(
            vmmigration.FetchInventoryRequest(),
            source="source_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListUtilizationReportsRequest,
        dict,
    ],
)
def test_list_utilization_reports(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListUtilizationReportsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_utilization_reports(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListUtilizationReportsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListUtilizationReportsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_utilization_reports_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        client.list_utilization_reports()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListUtilizationReportsRequest()


@pytest.mark.asyncio
async def test_list_utilization_reports_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.ListUtilizationReportsRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListUtilizationReportsResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_utilization_reports(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListUtilizationReportsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListUtilizationReportsAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_utilization_reports_async_from_dict():
    await test_list_utilization_reports_async(request_type=dict)


def test_list_utilization_reports_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListUtilizationReportsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        call.return_value = vmmigration.ListUtilizationReportsResponse()
        client.list_utilization_reports(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_utilization_reports_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListUtilizationReportsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListUtilizationReportsResponse()
        )
        await client.list_utilization_reports(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_utilization_reports_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListUtilizationReportsResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_utilization_reports(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_utilization_reports_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_utilization_reports(
            vmmigration.ListUtilizationReportsRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_utilization_reports_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListUtilizationReportsResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListUtilizationReportsResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_utilization_reports(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_utilization_reports_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_utilization_reports(
            vmmigration.ListUtilizationReportsRequest(),
            parent="parent_value",
        )


def test_list_utilization_reports_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[],
                next_page_token="def",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_utilization_reports(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.UtilizationReport) for i in results)


def test_list_utilization_reports_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[],
                next_page_token="def",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_utilization_reports(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_utilization_reports_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[],
                next_page_token="def",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_utilization_reports(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.UtilizationReport) for i in responses)


@pytest.mark.asyncio
async def test_list_utilization_reports_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_utilization_reports),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[],
                next_page_token="def",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_utilization_reports(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetUtilizationReportRequest,
        dict,
    ],
)
def test_get_utilization_report(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.UtilizationReport(
            name="name_value",
            display_name="display_name_value",
            state=vmmigration.UtilizationReport.State.CREATING,
            time_frame=vmmigration.UtilizationReport.TimeFrame.WEEK,
            vm_count=875,
        )
        response = client.get_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetUtilizationReportRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.UtilizationReport)
    assert response.name == "name_value"
    assert response.display_name == "display_name_value"
    assert response.state == vmmigration.UtilizationReport.State.CREATING
    assert response.time_frame == vmmigration.UtilizationReport.TimeFrame.WEEK
    assert response.vm_count == 875


def test_get_utilization_report_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_utilization_report), "__call__"
    ) as call:
        client.get_utilization_report()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetUtilizationReportRequest()


@pytest.mark.asyncio
async def test_get_utilization_report_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.GetUtilizationReportRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.UtilizationReport(
                name="name_value",
                display_name="display_name_value",
                state=vmmigration.UtilizationReport.State.CREATING,
                time_frame=vmmigration.UtilizationReport.TimeFrame.WEEK,
                vm_count=875,
            )
        )
        response = await client.get_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetUtilizationReportRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.UtilizationReport)
    assert response.name == "name_value"
    assert response.display_name == "display_name_value"
    assert response.state == vmmigration.UtilizationReport.State.CREATING
    assert response.time_frame == vmmigration.UtilizationReport.TimeFrame.WEEK
    assert response.vm_count == 875


@pytest.mark.asyncio
async def test_get_utilization_report_async_from_dict():
    await test_get_utilization_report_async(request_type=dict)


def test_get_utilization_report_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetUtilizationReportRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_utilization_report), "__call__"
    ) as call:
        call.return_value = vmmigration.UtilizationReport()
        client.get_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_utilization_report_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetUtilizationReportRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_utilization_report), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.UtilizationReport()
        )
        await client.get_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_utilization_report_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.UtilizationReport()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_utilization_report(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_utilization_report_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_utilization_report(
            vmmigration.GetUtilizationReportRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_utilization_report_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.UtilizationReport()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.UtilizationReport()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_utilization_report(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_utilization_report_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_utilization_report(
            vmmigration.GetUtilizationReportRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateUtilizationReportRequest,
        dict,
    ],
)
def test_create_utilization_report(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateUtilizationReportRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_utilization_report_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_utilization_report), "__call__"
    ) as call:
        client.create_utilization_report()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateUtilizationReportRequest()


@pytest.mark.asyncio
async def test_create_utilization_report_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.CreateUtilizationReportRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateUtilizationReportRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_utilization_report_async_from_dict():
    await test_create_utilization_report_async(request_type=dict)


def test_create_utilization_report_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateUtilizationReportRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_utilization_report), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_utilization_report_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateUtilizationReportRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_utilization_report), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_utilization_report_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_utilization_report(
            parent="parent_value",
            utilization_report=vmmigration.UtilizationReport(name="name_value"),
            utilization_report_id="utilization_report_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].utilization_report
        mock_val = vmmigration.UtilizationReport(name="name_value")
        assert arg == mock_val
        arg = args[0].utilization_report_id
        mock_val = "utilization_report_id_value"
        assert arg == mock_val


def test_create_utilization_report_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_utilization_report(
            vmmigration.CreateUtilizationReportRequest(),
            parent="parent_value",
            utilization_report=vmmigration.UtilizationReport(name="name_value"),
            utilization_report_id="utilization_report_id_value",
        )


@pytest.mark.asyncio
async def test_create_utilization_report_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_utilization_report(
            parent="parent_value",
            utilization_report=vmmigration.UtilizationReport(name="name_value"),
            utilization_report_id="utilization_report_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].utilization_report
        mock_val = vmmigration.UtilizationReport(name="name_value")
        assert arg == mock_val
        arg = args[0].utilization_report_id
        mock_val = "utilization_report_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_utilization_report_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_utilization_report(
            vmmigration.CreateUtilizationReportRequest(),
            parent="parent_value",
            utilization_report=vmmigration.UtilizationReport(name="name_value"),
            utilization_report_id="utilization_report_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteUtilizationReportRequest,
        dict,
    ],
)
def test_delete_utilization_report(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.delete_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteUtilizationReportRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_delete_utilization_report_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_utilization_report), "__call__"
    ) as call:
        client.delete_utilization_report()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteUtilizationReportRequest()


@pytest.mark.asyncio
async def test_delete_utilization_report_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.DeleteUtilizationReportRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.delete_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteUtilizationReportRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_delete_utilization_report_async_from_dict():
    await test_delete_utilization_report_async(request_type=dict)


def test_delete_utilization_report_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteUtilizationReportRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_utilization_report), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.delete_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_delete_utilization_report_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteUtilizationReportRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_utilization_report), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.delete_utilization_report(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_delete_utilization_report_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.delete_utilization_report(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_delete_utilization_report_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_utilization_report(
            vmmigration.DeleteUtilizationReportRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_delete_utilization_report_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_utilization_report), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.delete_utilization_report(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_delete_utilization_report_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.delete_utilization_report(
            vmmigration.DeleteUtilizationReportRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListDatacenterConnectorsRequest,
        dict,
    ],
)
def test_list_datacenter_connectors(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListDatacenterConnectorsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_datacenter_connectors(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListDatacenterConnectorsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListDatacenterConnectorsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_datacenter_connectors_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        client.list_datacenter_connectors()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListDatacenterConnectorsRequest()


@pytest.mark.asyncio
async def test_list_datacenter_connectors_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.ListDatacenterConnectorsRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListDatacenterConnectorsResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_datacenter_connectors(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListDatacenterConnectorsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListDatacenterConnectorsAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_datacenter_connectors_async_from_dict():
    await test_list_datacenter_connectors_async(request_type=dict)


def test_list_datacenter_connectors_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListDatacenterConnectorsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        call.return_value = vmmigration.ListDatacenterConnectorsResponse()
        client.list_datacenter_connectors(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_datacenter_connectors_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListDatacenterConnectorsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListDatacenterConnectorsResponse()
        )
        await client.list_datacenter_connectors(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_datacenter_connectors_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListDatacenterConnectorsResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_datacenter_connectors(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_datacenter_connectors_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_datacenter_connectors(
            vmmigration.ListDatacenterConnectorsRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_datacenter_connectors_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListDatacenterConnectorsResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListDatacenterConnectorsResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_datacenter_connectors(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_datacenter_connectors_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_datacenter_connectors(
            vmmigration.ListDatacenterConnectorsRequest(),
            parent="parent_value",
        )


def test_list_datacenter_connectors_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[],
                next_page_token="def",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_datacenter_connectors(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.DatacenterConnector) for i in results)


def test_list_datacenter_connectors_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[],
                next_page_token="def",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_datacenter_connectors(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_datacenter_connectors_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[],
                next_page_token="def",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_datacenter_connectors(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.DatacenterConnector) for i in responses)


@pytest.mark.asyncio
async def test_list_datacenter_connectors_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_datacenter_connectors),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[],
                next_page_token="def",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_datacenter_connectors(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetDatacenterConnectorRequest,
        dict,
    ],
)
def test_get_datacenter_connector(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.DatacenterConnector(
            name="name_value",
            registration_id="registration_id_value",
            service_account="service_account_value",
            version="version_value",
            bucket="bucket_value",
            state=vmmigration.DatacenterConnector.State.PENDING,
            appliance_infrastructure_version="appliance_infrastructure_version_value",
            appliance_software_version="appliance_software_version_value",
        )
        response = client.get_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetDatacenterConnectorRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.DatacenterConnector)
    assert response.name == "name_value"
    assert response.registration_id == "registration_id_value"
    assert response.service_account == "service_account_value"
    assert response.version == "version_value"
    assert response.bucket == "bucket_value"
    assert response.state == vmmigration.DatacenterConnector.State.PENDING
    assert (
        response.appliance_infrastructure_version
        == "appliance_infrastructure_version_value"
    )
    assert response.appliance_software_version == "appliance_software_version_value"


def test_get_datacenter_connector_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_datacenter_connector), "__call__"
    ) as call:
        client.get_datacenter_connector()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetDatacenterConnectorRequest()


@pytest.mark.asyncio
async def test_get_datacenter_connector_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.GetDatacenterConnectorRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.DatacenterConnector(
                name="name_value",
                registration_id="registration_id_value",
                service_account="service_account_value",
                version="version_value",
                bucket="bucket_value",
                state=vmmigration.DatacenterConnector.State.PENDING,
                appliance_infrastructure_version="appliance_infrastructure_version_value",
                appliance_software_version="appliance_software_version_value",
            )
        )
        response = await client.get_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetDatacenterConnectorRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.DatacenterConnector)
    assert response.name == "name_value"
    assert response.registration_id == "registration_id_value"
    assert response.service_account == "service_account_value"
    assert response.version == "version_value"
    assert response.bucket == "bucket_value"
    assert response.state == vmmigration.DatacenterConnector.State.PENDING
    assert (
        response.appliance_infrastructure_version
        == "appliance_infrastructure_version_value"
    )
    assert response.appliance_software_version == "appliance_software_version_value"


@pytest.mark.asyncio
async def test_get_datacenter_connector_async_from_dict():
    await test_get_datacenter_connector_async(request_type=dict)


def test_get_datacenter_connector_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetDatacenterConnectorRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_datacenter_connector), "__call__"
    ) as call:
        call.return_value = vmmigration.DatacenterConnector()
        client.get_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_datacenter_connector_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetDatacenterConnectorRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_datacenter_connector), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.DatacenterConnector()
        )
        await client.get_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_datacenter_connector_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.DatacenterConnector()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_datacenter_connector(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_datacenter_connector_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_datacenter_connector(
            vmmigration.GetDatacenterConnectorRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_datacenter_connector_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.DatacenterConnector()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.DatacenterConnector()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_datacenter_connector(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_datacenter_connector_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_datacenter_connector(
            vmmigration.GetDatacenterConnectorRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateDatacenterConnectorRequest,
        dict,
    ],
)
def test_create_datacenter_connector(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateDatacenterConnectorRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_datacenter_connector_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_datacenter_connector), "__call__"
    ) as call:
        client.create_datacenter_connector()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateDatacenterConnectorRequest()


@pytest.mark.asyncio
async def test_create_datacenter_connector_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.CreateDatacenterConnectorRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateDatacenterConnectorRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_datacenter_connector_async_from_dict():
    await test_create_datacenter_connector_async(request_type=dict)


def test_create_datacenter_connector_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateDatacenterConnectorRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_datacenter_connector), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_datacenter_connector_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateDatacenterConnectorRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_datacenter_connector), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_datacenter_connector_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_datacenter_connector(
            parent="parent_value",
            datacenter_connector=vmmigration.DatacenterConnector(
                create_time=timestamp_pb2.Timestamp(seconds=751)
            ),
            datacenter_connector_id="datacenter_connector_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].datacenter_connector
        mock_val = vmmigration.DatacenterConnector(
            create_time=timestamp_pb2.Timestamp(seconds=751)
        )
        assert arg == mock_val
        arg = args[0].datacenter_connector_id
        mock_val = "datacenter_connector_id_value"
        assert arg == mock_val


def test_create_datacenter_connector_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_datacenter_connector(
            vmmigration.CreateDatacenterConnectorRequest(),
            parent="parent_value",
            datacenter_connector=vmmigration.DatacenterConnector(
                create_time=timestamp_pb2.Timestamp(seconds=751)
            ),
            datacenter_connector_id="datacenter_connector_id_value",
        )


@pytest.mark.asyncio
async def test_create_datacenter_connector_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_datacenter_connector(
            parent="parent_value",
            datacenter_connector=vmmigration.DatacenterConnector(
                create_time=timestamp_pb2.Timestamp(seconds=751)
            ),
            datacenter_connector_id="datacenter_connector_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].datacenter_connector
        mock_val = vmmigration.DatacenterConnector(
            create_time=timestamp_pb2.Timestamp(seconds=751)
        )
        assert arg == mock_val
        arg = args[0].datacenter_connector_id
        mock_val = "datacenter_connector_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_datacenter_connector_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_datacenter_connector(
            vmmigration.CreateDatacenterConnectorRequest(),
            parent="parent_value",
            datacenter_connector=vmmigration.DatacenterConnector(
                create_time=timestamp_pb2.Timestamp(seconds=751)
            ),
            datacenter_connector_id="datacenter_connector_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteDatacenterConnectorRequest,
        dict,
    ],
)
def test_delete_datacenter_connector(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.delete_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteDatacenterConnectorRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_delete_datacenter_connector_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_datacenter_connector), "__call__"
    ) as call:
        client.delete_datacenter_connector()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteDatacenterConnectorRequest()


@pytest.mark.asyncio
async def test_delete_datacenter_connector_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.DeleteDatacenterConnectorRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.delete_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteDatacenterConnectorRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_delete_datacenter_connector_async_from_dict():
    await test_delete_datacenter_connector_async(request_type=dict)


def test_delete_datacenter_connector_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteDatacenterConnectorRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_datacenter_connector), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.delete_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_delete_datacenter_connector_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteDatacenterConnectorRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_datacenter_connector), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.delete_datacenter_connector(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_delete_datacenter_connector_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.delete_datacenter_connector(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_delete_datacenter_connector_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_datacenter_connector(
            vmmigration.DeleteDatacenterConnectorRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_delete_datacenter_connector_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_datacenter_connector), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.delete_datacenter_connector(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_delete_datacenter_connector_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.delete_datacenter_connector(
            vmmigration.DeleteDatacenterConnectorRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpgradeApplianceRequest,
        dict,
    ],
)
def test_upgrade_appliance(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.upgrade_appliance), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.upgrade_appliance(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpgradeApplianceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_upgrade_appliance_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.upgrade_appliance), "__call__"
    ) as call:
        client.upgrade_appliance()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpgradeApplianceRequest()


@pytest.mark.asyncio
async def test_upgrade_appliance_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.UpgradeApplianceRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.upgrade_appliance), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.upgrade_appliance(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpgradeApplianceRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_upgrade_appliance_async_from_dict():
    await test_upgrade_appliance_async(request_type=dict)


def test_upgrade_appliance_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpgradeApplianceRequest()

    request.datacenter_connector = "datacenter_connector_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.upgrade_appliance), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.upgrade_appliance(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "datacenter_connector=datacenter_connector_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_upgrade_appliance_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpgradeApplianceRequest()

    request.datacenter_connector = "datacenter_connector_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.upgrade_appliance), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.upgrade_appliance(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "datacenter_connector=datacenter_connector_value",
    ) in kw["metadata"]


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateMigratingVmRequest,
        dict,
    ],
)
def test_create_migrating_vm(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_migrating_vm_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_migrating_vm), "__call__"
    ) as call:
        client.create_migrating_vm()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateMigratingVmRequest()


@pytest.mark.asyncio
async def test_create_migrating_vm_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CreateMigratingVmRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_migrating_vm_async_from_dict():
    await test_create_migrating_vm_async(request_type=dict)


def test_create_migrating_vm_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateMigratingVmRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_migrating_vm), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_migrating_vm_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateMigratingVmRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_migrating_vm), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_migrating_vm_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_migrating_vm(
            parent="parent_value",
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            migrating_vm_id="migrating_vm_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].migrating_vm
        mock_val = vmmigration.MigratingVm(
            compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].migrating_vm_id
        mock_val = "migrating_vm_id_value"
        assert arg == mock_val


def test_create_migrating_vm_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_migrating_vm(
            vmmigration.CreateMigratingVmRequest(),
            parent="parent_value",
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            migrating_vm_id="migrating_vm_id_value",
        )


@pytest.mark.asyncio
async def test_create_migrating_vm_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_migrating_vm(
            parent="parent_value",
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            migrating_vm_id="migrating_vm_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].migrating_vm
        mock_val = vmmigration.MigratingVm(
            compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].migrating_vm_id
        mock_val = "migrating_vm_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_migrating_vm_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_migrating_vm(
            vmmigration.CreateMigratingVmRequest(),
            parent="parent_value",
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            migrating_vm_id="migrating_vm_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListMigratingVmsRequest,
        dict,
    ],
)
def test_list_migrating_vms(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListMigratingVmsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_migrating_vms(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListMigratingVmsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListMigratingVmsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_migrating_vms_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        client.list_migrating_vms()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListMigratingVmsRequest()


@pytest.mark.asyncio
async def test_list_migrating_vms_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.ListMigratingVmsRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListMigratingVmsResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_migrating_vms(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListMigratingVmsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListMigratingVmsAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_migrating_vms_async_from_dict():
    await test_list_migrating_vms_async(request_type=dict)


def test_list_migrating_vms_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListMigratingVmsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        call.return_value = vmmigration.ListMigratingVmsResponse()
        client.list_migrating_vms(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_migrating_vms_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListMigratingVmsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListMigratingVmsResponse()
        )
        await client.list_migrating_vms(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_migrating_vms_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListMigratingVmsResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_migrating_vms(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_migrating_vms_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_migrating_vms(
            vmmigration.ListMigratingVmsRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_migrating_vms_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListMigratingVmsResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListMigratingVmsResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_migrating_vms(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_migrating_vms_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_migrating_vms(
            vmmigration.ListMigratingVmsRequest(),
            parent="parent_value",
        )


def test_list_migrating_vms_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[],
                next_page_token="def",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_migrating_vms(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.MigratingVm) for i in results)


def test_list_migrating_vms_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[],
                next_page_token="def",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_migrating_vms(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_migrating_vms_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[],
                next_page_token="def",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_migrating_vms(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.MigratingVm) for i in responses)


@pytest.mark.asyncio
async def test_list_migrating_vms_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_migrating_vms),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[],
                next_page_token="def",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_migrating_vms(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetMigratingVmRequest,
        dict,
    ],
)
def test_get_migrating_vm(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_migrating_vm), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.MigratingVm(
            name="name_value",
            source_vm_id="source_vm_id_value",
            display_name="display_name_value",
            description="description_value",
            state=vmmigration.MigratingVm.State.PENDING,
            group="group_value",
            compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                vm_name="vm_name_value"
            ),
            aws_source_vm_details=vmmigration.AwsSourceVmDetails(
                firmware=vmmigration.AwsSourceVmDetails.Firmware.EFI
            ),
        )
        response = client.get_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.MigratingVm)
    assert response.name == "name_value"
    assert response.source_vm_id == "source_vm_id_value"
    assert response.display_name == "display_name_value"
    assert response.description == "description_value"
    assert response.state == vmmigration.MigratingVm.State.PENDING
    assert response.group == "group_value"


def test_get_migrating_vm_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_migrating_vm), "__call__") as call:
        client.get_migrating_vm()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetMigratingVmRequest()


@pytest.mark.asyncio
async def test_get_migrating_vm_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.GetMigratingVmRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_migrating_vm), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.MigratingVm(
                name="name_value",
                source_vm_id="source_vm_id_value",
                display_name="display_name_value",
                description="description_value",
                state=vmmigration.MigratingVm.State.PENDING,
                group="group_value",
            )
        )
        response = await client.get_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.MigratingVm)
    assert response.name == "name_value"
    assert response.source_vm_id == "source_vm_id_value"
    assert response.display_name == "display_name_value"
    assert response.description == "description_value"
    assert response.state == vmmigration.MigratingVm.State.PENDING
    assert response.group == "group_value"


@pytest.mark.asyncio
async def test_get_migrating_vm_async_from_dict():
    await test_get_migrating_vm_async(request_type=dict)


def test_get_migrating_vm_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetMigratingVmRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_migrating_vm), "__call__") as call:
        call.return_value = vmmigration.MigratingVm()
        client.get_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_migrating_vm_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetMigratingVmRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_migrating_vm), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.MigratingVm()
        )
        await client.get_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_migrating_vm_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_migrating_vm), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.MigratingVm()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_migrating_vm(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_migrating_vm_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_migrating_vm(
            vmmigration.GetMigratingVmRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_migrating_vm_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_migrating_vm), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.MigratingVm()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.MigratingVm()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_migrating_vm(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_migrating_vm_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_migrating_vm(
            vmmigration.GetMigratingVmRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateMigratingVmRequest,
        dict,
    ],
)
def test_update_migrating_vm(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.update_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_update_migrating_vm_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_migrating_vm), "__call__"
    ) as call:
        client.update_migrating_vm()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateMigratingVmRequest()


@pytest.mark.asyncio
async def test_update_migrating_vm_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.UpdateMigratingVmRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.update_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_update_migrating_vm_async_from_dict():
    await test_update_migrating_vm_async(request_type=dict)


def test_update_migrating_vm_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateMigratingVmRequest()

    request.migrating_vm.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_migrating_vm), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.update_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm.name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_update_migrating_vm_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateMigratingVmRequest()

    request.migrating_vm.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_migrating_vm), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.update_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm.name=name_value",
    ) in kw["metadata"]


def test_update_migrating_vm_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.update_migrating_vm(
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].migrating_vm
        mock_val = vmmigration.MigratingVm(
            compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


def test_update_migrating_vm_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_migrating_vm(
            vmmigration.UpdateMigratingVmRequest(),
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.asyncio
async def test_update_migrating_vm_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.update_migrating_vm(
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].migrating_vm
        mock_val = vmmigration.MigratingVm(
            compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


@pytest.mark.asyncio
async def test_update_migrating_vm_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.update_migrating_vm(
            vmmigration.UpdateMigratingVmRequest(),
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteMigratingVmRequest,
        dict,
    ],
)
def test_delete_migrating_vm(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.delete_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_delete_migrating_vm_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_migrating_vm), "__call__"
    ) as call:
        client.delete_migrating_vm()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteMigratingVmRequest()


@pytest.mark.asyncio
async def test_delete_migrating_vm_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.DeleteMigratingVmRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.delete_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteMigratingVmRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_delete_migrating_vm_async_from_dict():
    await test_delete_migrating_vm_async(request_type=dict)


def test_delete_migrating_vm_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteMigratingVmRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_migrating_vm), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.delete_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_delete_migrating_vm_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteMigratingVmRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_migrating_vm), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.delete_migrating_vm(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_delete_migrating_vm_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.delete_migrating_vm(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_delete_migrating_vm_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_migrating_vm(
            vmmigration.DeleteMigratingVmRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_delete_migrating_vm_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_migrating_vm), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.delete_migrating_vm(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_delete_migrating_vm_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.delete_migrating_vm(
            vmmigration.DeleteMigratingVmRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.StartMigrationRequest,
        dict,
    ],
)
def test_start_migration(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.start_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.start_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.StartMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_start_migration_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.start_migration), "__call__") as call:
        client.start_migration()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.StartMigrationRequest()


@pytest.mark.asyncio
async def test_start_migration_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.StartMigrationRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.start_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.start_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.StartMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_start_migration_async_from_dict():
    await test_start_migration_async(request_type=dict)


def test_start_migration_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.StartMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.start_migration), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.start_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_start_migration_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.StartMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.start_migration), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.start_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


def test_start_migration_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.start_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.start_migration(
            migrating_vm="migrating_vm_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].migrating_vm
        mock_val = "migrating_vm_value"
        assert arg == mock_val


def test_start_migration_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.start_migration(
            vmmigration.StartMigrationRequest(),
            migrating_vm="migrating_vm_value",
        )


@pytest.mark.asyncio
async def test_start_migration_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.start_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.start_migration(
            migrating_vm="migrating_vm_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].migrating_vm
        mock_val = "migrating_vm_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_start_migration_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.start_migration(
            vmmigration.StartMigrationRequest(),
            migrating_vm="migrating_vm_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ResumeMigrationRequest,
        dict,
    ],
)
def test_resume_migration(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.resume_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.resume_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ResumeMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_resume_migration_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.resume_migration), "__call__") as call:
        client.resume_migration()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ResumeMigrationRequest()


@pytest.mark.asyncio
async def test_resume_migration_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.ResumeMigrationRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.resume_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.resume_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ResumeMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_resume_migration_async_from_dict():
    await test_resume_migration_async(request_type=dict)


def test_resume_migration_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ResumeMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.resume_migration), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.resume_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_resume_migration_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ResumeMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.resume_migration), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.resume_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.PauseMigrationRequest,
        dict,
    ],
)
def test_pause_migration(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.pause_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.pause_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.PauseMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_pause_migration_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.pause_migration), "__call__") as call:
        client.pause_migration()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.PauseMigrationRequest()


@pytest.mark.asyncio
async def test_pause_migration_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.PauseMigrationRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.pause_migration), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.pause_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.PauseMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_pause_migration_async_from_dict():
    await test_pause_migration_async(request_type=dict)


def test_pause_migration_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.PauseMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.pause_migration), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.pause_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_pause_migration_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.PauseMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.pause_migration), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.pause_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.FinalizeMigrationRequest,
        dict,
    ],
)
def test_finalize_migration(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.finalize_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.finalize_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.FinalizeMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_finalize_migration_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.finalize_migration), "__call__"
    ) as call:
        client.finalize_migration()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.FinalizeMigrationRequest()


@pytest.mark.asyncio
async def test_finalize_migration_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.FinalizeMigrationRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.finalize_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.finalize_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.FinalizeMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_finalize_migration_async_from_dict():
    await test_finalize_migration_async(request_type=dict)


def test_finalize_migration_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.FinalizeMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.finalize_migration), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.finalize_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_finalize_migration_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.FinalizeMigrationRequest()

    request.migrating_vm = "migrating_vm_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.finalize_migration), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.finalize_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "migrating_vm=migrating_vm_value",
    ) in kw["metadata"]


def test_finalize_migration_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.finalize_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.finalize_migration(
            migrating_vm="migrating_vm_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].migrating_vm
        mock_val = "migrating_vm_value"
        assert arg == mock_val


def test_finalize_migration_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.finalize_migration(
            vmmigration.FinalizeMigrationRequest(),
            migrating_vm="migrating_vm_value",
        )


@pytest.mark.asyncio
async def test_finalize_migration_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.finalize_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.finalize_migration(
            migrating_vm="migrating_vm_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].migrating_vm
        mock_val = "migrating_vm_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_finalize_migration_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.finalize_migration(
            vmmigration.FinalizeMigrationRequest(),
            migrating_vm="migrating_vm_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateCloneJobRequest,
        dict,
    ],
)
def test_create_clone_job(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateCloneJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_clone_job_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_clone_job), "__call__") as call:
        client.create_clone_job()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateCloneJobRequest()


@pytest.mark.asyncio
async def test_create_clone_job_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CreateCloneJobRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateCloneJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_clone_job_async_from_dict():
    await test_create_clone_job_async(request_type=dict)


def test_create_clone_job_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateCloneJobRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_clone_job), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_clone_job_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateCloneJobRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_clone_job), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_clone_job_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_clone_job(
            parent="parent_value",
            clone_job=vmmigration.CloneJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            clone_job_id="clone_job_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].clone_job
        mock_val = vmmigration.CloneJob(
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].clone_job_id
        mock_val = "clone_job_id_value"
        assert arg == mock_val


def test_create_clone_job_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_clone_job(
            vmmigration.CreateCloneJobRequest(),
            parent="parent_value",
            clone_job=vmmigration.CloneJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            clone_job_id="clone_job_id_value",
        )


@pytest.mark.asyncio
async def test_create_clone_job_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_clone_job(
            parent="parent_value",
            clone_job=vmmigration.CloneJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            clone_job_id="clone_job_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].clone_job
        mock_val = vmmigration.CloneJob(
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].clone_job_id
        mock_val = "clone_job_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_clone_job_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_clone_job(
            vmmigration.CreateCloneJobRequest(),
            parent="parent_value",
            clone_job=vmmigration.CloneJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            clone_job_id="clone_job_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CancelCloneJobRequest,
        dict,
    ],
)
def test_cancel_clone_job(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.cancel_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.cancel_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CancelCloneJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_cancel_clone_job_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.cancel_clone_job), "__call__") as call:
        client.cancel_clone_job()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CancelCloneJobRequest()


@pytest.mark.asyncio
async def test_cancel_clone_job_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CancelCloneJobRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.cancel_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.cancel_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CancelCloneJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_cancel_clone_job_async_from_dict():
    await test_cancel_clone_job_async(request_type=dict)


def test_cancel_clone_job_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CancelCloneJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.cancel_clone_job), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.cancel_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_cancel_clone_job_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CancelCloneJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.cancel_clone_job), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.cancel_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_cancel_clone_job_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.cancel_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.cancel_clone_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_cancel_clone_job_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.cancel_clone_job(
            vmmigration.CancelCloneJobRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_cancel_clone_job_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.cancel_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.cancel_clone_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_cancel_clone_job_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.cancel_clone_job(
            vmmigration.CancelCloneJobRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListCloneJobsRequest,
        dict,
    ],
)
def test_list_clone_jobs(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListCloneJobsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_clone_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListCloneJobsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListCloneJobsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_clone_jobs_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        client.list_clone_jobs()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListCloneJobsRequest()


@pytest.mark.asyncio
async def test_list_clone_jobs_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.ListCloneJobsRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListCloneJobsResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_clone_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListCloneJobsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListCloneJobsAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_clone_jobs_async_from_dict():
    await test_list_clone_jobs_async(request_type=dict)


def test_list_clone_jobs_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListCloneJobsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        call.return_value = vmmigration.ListCloneJobsResponse()
        client.list_clone_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_clone_jobs_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListCloneJobsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListCloneJobsResponse()
        )
        await client.list_clone_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_clone_jobs_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListCloneJobsResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_clone_jobs(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_clone_jobs_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_clone_jobs(
            vmmigration.ListCloneJobsRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_clone_jobs_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListCloneJobsResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListCloneJobsResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_clone_jobs(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_clone_jobs_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_clone_jobs(
            vmmigration.ListCloneJobsRequest(),
            parent="parent_value",
        )


def test_list_clone_jobs_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_clone_jobs(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.CloneJob) for i in results)


def test_list_clone_jobs_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_clone_jobs), "__call__") as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_clone_jobs(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_clone_jobs_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_clone_jobs), "__call__", new_callable=mock.AsyncMock
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_clone_jobs(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.CloneJob) for i in responses)


@pytest.mark.asyncio
async def test_list_clone_jobs_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_clone_jobs), "__call__", new_callable=mock.AsyncMock
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_clone_jobs(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetCloneJobRequest,
        dict,
    ],
)
def test_get_clone_job(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.CloneJob(
            name="name_value",
            state=vmmigration.CloneJob.State.PENDING,
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            ),
        )
        response = client.get_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetCloneJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.CloneJob)
    assert response.name == "name_value"
    assert response.state == vmmigration.CloneJob.State.PENDING


def test_get_clone_job_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_clone_job), "__call__") as call:
        client.get_clone_job()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetCloneJobRequest()


@pytest.mark.asyncio
async def test_get_clone_job_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.GetCloneJobRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.CloneJob(
                name="name_value",
                state=vmmigration.CloneJob.State.PENDING,
            )
        )
        response = await client.get_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetCloneJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.CloneJob)
    assert response.name == "name_value"
    assert response.state == vmmigration.CloneJob.State.PENDING


@pytest.mark.asyncio
async def test_get_clone_job_async_from_dict():
    await test_get_clone_job_async(request_type=dict)


def test_get_clone_job_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetCloneJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_clone_job), "__call__") as call:
        call.return_value = vmmigration.CloneJob()
        client.get_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_clone_job_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetCloneJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_clone_job), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.CloneJob()
        )
        await client.get_clone_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_clone_job_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.CloneJob()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_clone_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_clone_job_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_clone_job(
            vmmigration.GetCloneJobRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_clone_job_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_clone_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.CloneJob()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.CloneJob()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_clone_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_clone_job_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_clone_job(
            vmmigration.GetCloneJobRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateCutoverJobRequest,
        dict,
    ],
)
def test_create_cutover_job(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateCutoverJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_cutover_job_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_cutover_job), "__call__"
    ) as call:
        client.create_cutover_job()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateCutoverJobRequest()


@pytest.mark.asyncio
async def test_create_cutover_job_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CreateCutoverJobRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateCutoverJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_cutover_job_async_from_dict():
    await test_create_cutover_job_async(request_type=dict)


def test_create_cutover_job_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateCutoverJobRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_cutover_job), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_cutover_job_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateCutoverJobRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_cutover_job), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_cutover_job_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_cutover_job(
            parent="parent_value",
            cutover_job=vmmigration.CutoverJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            cutover_job_id="cutover_job_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].cutover_job
        mock_val = vmmigration.CutoverJob(
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].cutover_job_id
        mock_val = "cutover_job_id_value"
        assert arg == mock_val


def test_create_cutover_job_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_cutover_job(
            vmmigration.CreateCutoverJobRequest(),
            parent="parent_value",
            cutover_job=vmmigration.CutoverJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            cutover_job_id="cutover_job_id_value",
        )


@pytest.mark.asyncio
async def test_create_cutover_job_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_cutover_job(
            parent="parent_value",
            cutover_job=vmmigration.CutoverJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            cutover_job_id="cutover_job_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].cutover_job
        mock_val = vmmigration.CutoverJob(
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            )
        )
        assert arg == mock_val
        arg = args[0].cutover_job_id
        mock_val = "cutover_job_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_cutover_job_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_cutover_job(
            vmmigration.CreateCutoverJobRequest(),
            parent="parent_value",
            cutover_job=vmmigration.CutoverJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            cutover_job_id="cutover_job_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CancelCutoverJobRequest,
        dict,
    ],
)
def test_cancel_cutover_job(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.cancel_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.cancel_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CancelCutoverJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_cancel_cutover_job_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.cancel_cutover_job), "__call__"
    ) as call:
        client.cancel_cutover_job()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CancelCutoverJobRequest()


@pytest.mark.asyncio
async def test_cancel_cutover_job_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CancelCutoverJobRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.cancel_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.cancel_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CancelCutoverJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_cancel_cutover_job_async_from_dict():
    await test_cancel_cutover_job_async(request_type=dict)


def test_cancel_cutover_job_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CancelCutoverJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.cancel_cutover_job), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.cancel_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_cancel_cutover_job_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CancelCutoverJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.cancel_cutover_job), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.cancel_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_cancel_cutover_job_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.cancel_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.cancel_cutover_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_cancel_cutover_job_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.cancel_cutover_job(
            vmmigration.CancelCutoverJobRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_cancel_cutover_job_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.cancel_cutover_job), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.cancel_cutover_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_cancel_cutover_job_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.cancel_cutover_job(
            vmmigration.CancelCutoverJobRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListCutoverJobsRequest,
        dict,
    ],
)
def test_list_cutover_jobs(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListCutoverJobsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_cutover_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListCutoverJobsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListCutoverJobsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_cutover_jobs_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        client.list_cutover_jobs()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListCutoverJobsRequest()


@pytest.mark.asyncio
async def test_list_cutover_jobs_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.ListCutoverJobsRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListCutoverJobsResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_cutover_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListCutoverJobsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListCutoverJobsAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_cutover_jobs_async_from_dict():
    await test_list_cutover_jobs_async(request_type=dict)


def test_list_cutover_jobs_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListCutoverJobsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        call.return_value = vmmigration.ListCutoverJobsResponse()
        client.list_cutover_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_cutover_jobs_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListCutoverJobsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListCutoverJobsResponse()
        )
        await client.list_cutover_jobs(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_cutover_jobs_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListCutoverJobsResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_cutover_jobs(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_cutover_jobs_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_cutover_jobs(
            vmmigration.ListCutoverJobsRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_cutover_jobs_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListCutoverJobsResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListCutoverJobsResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_cutover_jobs(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_cutover_jobs_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_cutover_jobs(
            vmmigration.ListCutoverJobsRequest(),
            parent="parent_value",
        )


def test_list_cutover_jobs_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_cutover_jobs(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.CutoverJob) for i in results)


def test_list_cutover_jobs_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_cutover_jobs(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_cutover_jobs_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_cutover_jobs(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.CutoverJob) for i in responses)


@pytest.mark.asyncio
async def test_list_cutover_jobs_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_cutover_jobs),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_cutover_jobs(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetCutoverJobRequest,
        dict,
    ],
)
def test_get_cutover_job(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_cutover_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.CutoverJob(
            name="name_value",
            state=vmmigration.CutoverJob.State.PENDING,
            progress_percent=1733,
            state_message="state_message_value",
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            ),
        )
        response = client.get_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetCutoverJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.CutoverJob)
    assert response.name == "name_value"
    assert response.state == vmmigration.CutoverJob.State.PENDING
    assert response.progress_percent == 1733
    assert response.state_message == "state_message_value"


def test_get_cutover_job_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_cutover_job), "__call__") as call:
        client.get_cutover_job()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetCutoverJobRequest()


@pytest.mark.asyncio
async def test_get_cutover_job_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.GetCutoverJobRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_cutover_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.CutoverJob(
                name="name_value",
                state=vmmigration.CutoverJob.State.PENDING,
                progress_percent=1733,
                state_message="state_message_value",
            )
        )
        response = await client.get_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetCutoverJobRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.CutoverJob)
    assert response.name == "name_value"
    assert response.state == vmmigration.CutoverJob.State.PENDING
    assert response.progress_percent == 1733
    assert response.state_message == "state_message_value"


@pytest.mark.asyncio
async def test_get_cutover_job_async_from_dict():
    await test_get_cutover_job_async(request_type=dict)


def test_get_cutover_job_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetCutoverJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_cutover_job), "__call__") as call:
        call.return_value = vmmigration.CutoverJob()
        client.get_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_cutover_job_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetCutoverJobRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_cutover_job), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.CutoverJob()
        )
        await client.get_cutover_job(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_cutover_job_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_cutover_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.CutoverJob()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_cutover_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_cutover_job_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_cutover_job(
            vmmigration.GetCutoverJobRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_cutover_job_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_cutover_job), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.CutoverJob()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.CutoverJob()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_cutover_job(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_cutover_job_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_cutover_job(
            vmmigration.GetCutoverJobRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListGroupsRequest,
        dict,
    ],
)
def test_list_groups(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListGroupsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_groups(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListGroupsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListGroupsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_groups_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        client.list_groups()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListGroupsRequest()


@pytest.mark.asyncio
async def test_list_groups_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.ListGroupsRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListGroupsResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_groups(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListGroupsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListGroupsAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_groups_async_from_dict():
    await test_list_groups_async(request_type=dict)


def test_list_groups_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListGroupsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        call.return_value = vmmigration.ListGroupsResponse()
        client.list_groups(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_groups_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListGroupsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListGroupsResponse()
        )
        await client.list_groups(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_groups_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListGroupsResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_groups(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_groups_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_groups(
            vmmigration.ListGroupsRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_groups_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListGroupsResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListGroupsResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_groups(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_groups_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_groups(
            vmmigration.ListGroupsRequest(),
            parent="parent_value",
        )


def test_list_groups_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListGroupsResponse(
                groups=[],
                next_page_token="def",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_groups(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.Group) for i in results)


def test_list_groups_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.list_groups), "__call__") as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListGroupsResponse(
                groups=[],
                next_page_token="def",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_groups(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_groups_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_groups), "__call__", new_callable=mock.AsyncMock
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListGroupsResponse(
                groups=[],
                next_page_token="def",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_groups(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.Group) for i in responses)


@pytest.mark.asyncio
async def test_list_groups_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_groups), "__call__", new_callable=mock.AsyncMock
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListGroupsResponse(
                groups=[],
                next_page_token="def",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_groups(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetGroupRequest,
        dict,
    ],
)
def test_get_group(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.Group(
            name="name_value",
            description="description_value",
            display_name="display_name_value",
        )
        response = client.get_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.Group)
    assert response.name == "name_value"
    assert response.description == "description_value"
    assert response.display_name == "display_name_value"


def test_get_group_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_group), "__call__") as call:
        client.get_group()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetGroupRequest()


@pytest.mark.asyncio
async def test_get_group_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.GetGroupRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.Group(
                name="name_value",
                description="description_value",
                display_name="display_name_value",
            )
        )
        response = await client.get_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.Group)
    assert response.name == "name_value"
    assert response.description == "description_value"
    assert response.display_name == "display_name_value"


@pytest.mark.asyncio
async def test_get_group_async_from_dict():
    await test_get_group_async(request_type=dict)


def test_get_group_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetGroupRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_group), "__call__") as call:
        call.return_value = vmmigration.Group()
        client.get_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_group_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetGroupRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_group), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(vmmigration.Group())
        await client.get_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_group_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.Group()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_group(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_group_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_group(
            vmmigration.GetGroupRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_group_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.get_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.Group()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(vmmigration.Group())
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_group(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_group_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_group(
            vmmigration.GetGroupRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateGroupRequest,
        dict,
    ],
)
def test_create_group(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_group_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_group), "__call__") as call:
        client.create_group()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateGroupRequest()


@pytest.mark.asyncio
async def test_create_group_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CreateGroupRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_group_async_from_dict():
    await test_create_group_async(request_type=dict)


def test_create_group_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateGroupRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_group), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_group_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateGroupRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_group), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_group_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_group(
            parent="parent_value",
            group=vmmigration.Group(name="name_value"),
            group_id="group_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].group
        mock_val = vmmigration.Group(name="name_value")
        assert arg == mock_val
        arg = args[0].group_id
        mock_val = "group_id_value"
        assert arg == mock_val


def test_create_group_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_group(
            vmmigration.CreateGroupRequest(),
            parent="parent_value",
            group=vmmigration.Group(name="name_value"),
            group_id="group_id_value",
        )


@pytest.mark.asyncio
async def test_create_group_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.create_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_group(
            parent="parent_value",
            group=vmmigration.Group(name="name_value"),
            group_id="group_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].group
        mock_val = vmmigration.Group(name="name_value")
        assert arg == mock_val
        arg = args[0].group_id
        mock_val = "group_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_group_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_group(
            vmmigration.CreateGroupRequest(),
            parent="parent_value",
            group=vmmigration.Group(name="name_value"),
            group_id="group_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateGroupRequest,
        dict,
    ],
)
def test_update_group(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.update_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_update_group_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_group), "__call__") as call:
        client.update_group()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateGroupRequest()


@pytest.mark.asyncio
async def test_update_group_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.UpdateGroupRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.update_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_update_group_async_from_dict():
    await test_update_group_async(request_type=dict)


def test_update_group_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateGroupRequest()

    request.group.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_group), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.update_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "group.name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_update_group_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateGroupRequest()

    request.group.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_group), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.update_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "group.name=name_value",
    ) in kw["metadata"]


def test_update_group_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.update_group(
            group=vmmigration.Group(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].group
        mock_val = vmmigration.Group(name="name_value")
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


def test_update_group_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_group(
            vmmigration.UpdateGroupRequest(),
            group=vmmigration.Group(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.asyncio
async def test_update_group_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.update_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.update_group(
            group=vmmigration.Group(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].group
        mock_val = vmmigration.Group(name="name_value")
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


@pytest.mark.asyncio
async def test_update_group_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.update_group(
            vmmigration.UpdateGroupRequest(),
            group=vmmigration.Group(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteGroupRequest,
        dict,
    ],
)
def test_delete_group(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.delete_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_delete_group_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_group), "__call__") as call:
        client.delete_group()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteGroupRequest()


@pytest.mark.asyncio
async def test_delete_group_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.DeleteGroupRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.delete_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteGroupRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_delete_group_async_from_dict():
    await test_delete_group_async(request_type=dict)


def test_delete_group_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteGroupRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_group), "__call__") as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.delete_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_delete_group_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteGroupRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_group), "__call__") as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.delete_group(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_delete_group_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.delete_group(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_delete_group_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_group(
            vmmigration.DeleteGroupRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_delete_group_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(type(client.transport.delete_group), "__call__") as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.delete_group(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_delete_group_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.delete_group(
            vmmigration.DeleteGroupRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.AddGroupMigrationRequest,
        dict,
    ],
)
def test_add_group_migration(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.add_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.add_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.AddGroupMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_add_group_migration_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.add_group_migration), "__call__"
    ) as call:
        client.add_group_migration()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.AddGroupMigrationRequest()


@pytest.mark.asyncio
async def test_add_group_migration_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.AddGroupMigrationRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.add_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.add_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.AddGroupMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_add_group_migration_async_from_dict():
    await test_add_group_migration_async(request_type=dict)


def test_add_group_migration_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.AddGroupMigrationRequest()

    request.group = "group_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.add_group_migration), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.add_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "group=group_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_add_group_migration_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.AddGroupMigrationRequest()

    request.group = "group_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.add_group_migration), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.add_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "group=group_value",
    ) in kw["metadata"]


def test_add_group_migration_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.add_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.add_group_migration(
            group="group_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].group
        mock_val = "group_value"
        assert arg == mock_val


def test_add_group_migration_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.add_group_migration(
            vmmigration.AddGroupMigrationRequest(),
            group="group_value",
        )


@pytest.mark.asyncio
async def test_add_group_migration_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.add_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.add_group_migration(
            group="group_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].group
        mock_val = "group_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_add_group_migration_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.add_group_migration(
            vmmigration.AddGroupMigrationRequest(),
            group="group_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.RemoveGroupMigrationRequest,
        dict,
    ],
)
def test_remove_group_migration(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.remove_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.remove_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.RemoveGroupMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_remove_group_migration_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.remove_group_migration), "__call__"
    ) as call:
        client.remove_group_migration()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.RemoveGroupMigrationRequest()


@pytest.mark.asyncio
async def test_remove_group_migration_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.RemoveGroupMigrationRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.remove_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.remove_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.RemoveGroupMigrationRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_remove_group_migration_async_from_dict():
    await test_remove_group_migration_async(request_type=dict)


def test_remove_group_migration_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.RemoveGroupMigrationRequest()

    request.group = "group_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.remove_group_migration), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.remove_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "group=group_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_remove_group_migration_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.RemoveGroupMigrationRequest()

    request.group = "group_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.remove_group_migration), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.remove_group_migration(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "group=group_value",
    ) in kw["metadata"]


def test_remove_group_migration_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.remove_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.remove_group_migration(
            group="group_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].group
        mock_val = "group_value"
        assert arg == mock_val


def test_remove_group_migration_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.remove_group_migration(
            vmmigration.RemoveGroupMigrationRequest(),
            group="group_value",
        )


@pytest.mark.asyncio
async def test_remove_group_migration_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.remove_group_migration), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.remove_group_migration(
            group="group_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].group
        mock_val = "group_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_remove_group_migration_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.remove_group_migration(
            vmmigration.RemoveGroupMigrationRequest(),
            group="group_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListTargetProjectsRequest,
        dict,
    ],
)
def test_list_target_projects(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListTargetProjectsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_target_projects(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListTargetProjectsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListTargetProjectsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_target_projects_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        client.list_target_projects()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListTargetProjectsRequest()


@pytest.mark.asyncio
async def test_list_target_projects_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.ListTargetProjectsRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListTargetProjectsResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_target_projects(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListTargetProjectsRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListTargetProjectsAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_target_projects_async_from_dict():
    await test_list_target_projects_async(request_type=dict)


def test_list_target_projects_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListTargetProjectsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        call.return_value = vmmigration.ListTargetProjectsResponse()
        client.list_target_projects(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_target_projects_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListTargetProjectsRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListTargetProjectsResponse()
        )
        await client.list_target_projects(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_target_projects_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListTargetProjectsResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_target_projects(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_target_projects_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_target_projects(
            vmmigration.ListTargetProjectsRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_target_projects_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListTargetProjectsResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListTargetProjectsResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_target_projects(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_target_projects_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_target_projects(
            vmmigration.ListTargetProjectsRequest(),
            parent="parent_value",
        )


def test_list_target_projects_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[],
                next_page_token="def",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_target_projects(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.TargetProject) for i in results)


def test_list_target_projects_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[],
                next_page_token="def",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_target_projects(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_target_projects_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[],
                next_page_token="def",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_target_projects(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.TargetProject) for i in responses)


@pytest.mark.asyncio
async def test_list_target_projects_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_target_projects),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[],
                next_page_token="def",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_target_projects(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetTargetProjectRequest,
        dict,
    ],
)
def test_get_target_project(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.TargetProject(
            name="name_value",
            project="project_value",
            description="description_value",
        )
        response = client.get_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.TargetProject)
    assert response.name == "name_value"
    assert response.project == "project_value"
    assert response.description == "description_value"


def test_get_target_project_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_target_project), "__call__"
    ) as call:
        client.get_target_project()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetTargetProjectRequest()


@pytest.mark.asyncio
async def test_get_target_project_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.GetTargetProjectRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.TargetProject(
                name="name_value",
                project="project_value",
                description="description_value",
            )
        )
        response = await client.get_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.TargetProject)
    assert response.name == "name_value"
    assert response.project == "project_value"
    assert response.description == "description_value"


@pytest.mark.asyncio
async def test_get_target_project_async_from_dict():
    await test_get_target_project_async(request_type=dict)


def test_get_target_project_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetTargetProjectRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_target_project), "__call__"
    ) as call:
        call.return_value = vmmigration.TargetProject()
        client.get_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_target_project_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetTargetProjectRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_target_project), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.TargetProject()
        )
        await client.get_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_target_project_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.TargetProject()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_target_project(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_target_project_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_target_project(
            vmmigration.GetTargetProjectRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_target_project_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.TargetProject()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.TargetProject()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_target_project(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_target_project_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_target_project(
            vmmigration.GetTargetProjectRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateTargetProjectRequest,
        dict,
    ],
)
def test_create_target_project(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.create_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_create_target_project_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_target_project), "__call__"
    ) as call:
        client.create_target_project()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateTargetProjectRequest()


@pytest.mark.asyncio
async def test_create_target_project_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.CreateTargetProjectRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.create_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.CreateTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_create_target_project_async_from_dict():
    await test_create_target_project_async(request_type=dict)


def test_create_target_project_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateTargetProjectRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_target_project), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.create_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_create_target_project_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.CreateTargetProjectRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_target_project), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.create_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_create_target_project_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.create_target_project(
            parent="parent_value",
            target_project=vmmigration.TargetProject(name="name_value"),
            target_project_id="target_project_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].target_project
        mock_val = vmmigration.TargetProject(name="name_value")
        assert arg == mock_val
        arg = args[0].target_project_id
        mock_val = "target_project_id_value"
        assert arg == mock_val


def test_create_target_project_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_target_project(
            vmmigration.CreateTargetProjectRequest(),
            parent="parent_value",
            target_project=vmmigration.TargetProject(name="name_value"),
            target_project_id="target_project_id_value",
        )


@pytest.mark.asyncio
async def test_create_target_project_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.create_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.create_target_project(
            parent="parent_value",
            target_project=vmmigration.TargetProject(name="name_value"),
            target_project_id="target_project_id_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val
        arg = args[0].target_project
        mock_val = vmmigration.TargetProject(name="name_value")
        assert arg == mock_val
        arg = args[0].target_project_id
        mock_val = "target_project_id_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_create_target_project_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.create_target_project(
            vmmigration.CreateTargetProjectRequest(),
            parent="parent_value",
            target_project=vmmigration.TargetProject(name="name_value"),
            target_project_id="target_project_id_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateTargetProjectRequest,
        dict,
    ],
)
def test_update_target_project(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.update_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_update_target_project_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_target_project), "__call__"
    ) as call:
        client.update_target_project()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateTargetProjectRequest()


@pytest.mark.asyncio
async def test_update_target_project_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.UpdateTargetProjectRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.update_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.UpdateTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_update_target_project_async_from_dict():
    await test_update_target_project_async(request_type=dict)


def test_update_target_project_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateTargetProjectRequest()

    request.target_project.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_target_project), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.update_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "target_project.name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_update_target_project_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.UpdateTargetProjectRequest()

    request.target_project.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_target_project), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.update_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "target_project.name=name_value",
    ) in kw["metadata"]


def test_update_target_project_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.update_target_project(
            target_project=vmmigration.TargetProject(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].target_project
        mock_val = vmmigration.TargetProject(name="name_value")
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


def test_update_target_project_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_target_project(
            vmmigration.UpdateTargetProjectRequest(),
            target_project=vmmigration.TargetProject(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.asyncio
async def test_update_target_project_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.update_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.update_target_project(
            target_project=vmmigration.TargetProject(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].target_project
        mock_val = vmmigration.TargetProject(name="name_value")
        assert arg == mock_val
        arg = args[0].update_mask
        mock_val = field_mask_pb2.FieldMask(paths=["paths_value"])
        assert arg == mock_val


@pytest.mark.asyncio
async def test_update_target_project_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.update_target_project(
            vmmigration.UpdateTargetProjectRequest(),
            target_project=vmmigration.TargetProject(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteTargetProjectRequest,
        dict,
    ],
)
def test_delete_target_project(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/spam")
        response = client.delete_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


def test_delete_target_project_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_target_project), "__call__"
    ) as call:
        client.delete_target_project()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteTargetProjectRequest()


@pytest.mark.asyncio
async def test_delete_target_project_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.DeleteTargetProjectRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        response = await client.delete_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.DeleteTargetProjectRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, future.Future)


@pytest.mark.asyncio
async def test_delete_target_project_async_from_dict():
    await test_delete_target_project_async(request_type=dict)


def test_delete_target_project_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteTargetProjectRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_target_project), "__call__"
    ) as call:
        call.return_value = operations_pb2.Operation(name="operations/op")
        client.delete_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_delete_target_project_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.DeleteTargetProjectRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_target_project), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/op")
        )
        await client.delete_target_project(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_delete_target_project_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.delete_target_project(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_delete_target_project_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_target_project(
            vmmigration.DeleteTargetProjectRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_delete_target_project_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.delete_target_project), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = operations_pb2.Operation(name="operations/op")

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            operations_pb2.Operation(name="operations/spam")
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.delete_target_project(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_delete_target_project_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.delete_target_project(
            vmmigration.DeleteTargetProjectRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListReplicationCyclesRequest,
        dict,
    ],
)
def test_list_replication_cycles(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListReplicationCyclesResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )
        response = client.list_replication_cycles(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListReplicationCyclesRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListReplicationCyclesPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_replication_cycles_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        client.list_replication_cycles()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListReplicationCyclesRequest()


@pytest.mark.asyncio
async def test_list_replication_cycles_async(
    transport: str = "grpc_asyncio",
    request_type=vmmigration.ListReplicationCyclesRequest,
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListReplicationCyclesResponse(
                next_page_token="next_page_token_value",
                unreachable=["unreachable_value"],
            )
        )
        response = await client.list_replication_cycles(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.ListReplicationCyclesRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListReplicationCyclesAsyncPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


@pytest.mark.asyncio
async def test_list_replication_cycles_async_from_dict():
    await test_list_replication_cycles_async(request_type=dict)


def test_list_replication_cycles_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListReplicationCyclesRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        call.return_value = vmmigration.ListReplicationCyclesResponse()
        client.list_replication_cycles(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_list_replication_cycles_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.ListReplicationCyclesRequest()

    request.parent = "parent_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListReplicationCyclesResponse()
        )
        await client.list_replication_cycles(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "parent=parent_value",
    ) in kw["metadata"]


def test_list_replication_cycles_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListReplicationCyclesResponse()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.list_replication_cycles(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


def test_list_replication_cycles_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_replication_cycles(
            vmmigration.ListReplicationCyclesRequest(),
            parent="parent_value",
        )


@pytest.mark.asyncio
async def test_list_replication_cycles_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ListReplicationCyclesResponse()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ListReplicationCyclesResponse()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.list_replication_cycles(
            parent="parent_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].parent
        mock_val = "parent_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_list_replication_cycles_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.list_replication_cycles(
            vmmigration.ListReplicationCyclesRequest(),
            parent="parent_value",
        )


def test_list_replication_cycles_pager(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[],
                next_page_token="def",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
            ),
            RuntimeError,
        )

        metadata = ()
        metadata = tuple(metadata) + (
            gapic_v1.routing_header.to_grpc_metadata((("parent", ""),)),
        )
        pager = client.list_replication_cycles(request={})

        assert pager._metadata == metadata

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.ReplicationCycle) for i in results)


def test_list_replication_cycles_pages(transport_name: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials,
        transport=transport_name,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles), "__call__"
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[],
                next_page_token="def",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
            ),
            RuntimeError,
        )
        pages = list(client.list_replication_cycles(request={}).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.asyncio
async def test_list_replication_cycles_async_pager():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[],
                next_page_token="def",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
            ),
            RuntimeError,
        )
        async_pager = await client.list_replication_cycles(
            request={},
        )
        assert async_pager.next_page_token == "abc"
        responses = []
        async for response in async_pager:  # pragma: no branch
            responses.append(response)

        assert len(responses) == 6
        assert all(isinstance(i, vmmigration.ReplicationCycle) for i in responses)


@pytest.mark.asyncio
async def test_list_replication_cycles_async_pages():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials,
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.list_replication_cycles),
        "__call__",
        new_callable=mock.AsyncMock,
    ) as call:
        # Set the response to a series of pages.
        call.side_effect = (
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[],
                next_page_token="def",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListReplicationCyclesResponse(
                replication_cycles=[
                    vmmigration.ReplicationCycle(),
                    vmmigration.ReplicationCycle(),
                ],
            ),
            RuntimeError,
        )
        pages = []
        async for page_ in (
            await client.list_replication_cycles(request={})
        ).pages:  # pragma: no branch
            pages.append(page_)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetReplicationCycleRequest,
        dict,
    ],
)
def test_get_replication_cycle(request_type, transport: str = "grpc"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_replication_cycle), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ReplicationCycle(
            name="name_value",
            cycle_number=1272,
            progress_percent=1733,
            state=vmmigration.ReplicationCycle.State.RUNNING,
        )
        response = client.get_replication_cycle(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetReplicationCycleRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.ReplicationCycle)
    assert response.name == "name_value"
    assert response.cycle_number == 1272
    assert response.progress_percent == 1733
    assert response.state == vmmigration.ReplicationCycle.State.RUNNING


def test_get_replication_cycle_empty_call():
    # This test is a coverage failsafe to make sure that totally empty calls,
    # i.e. request == None and no flattened fields passed, work.
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="grpc",
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_replication_cycle), "__call__"
    ) as call:
        client.get_replication_cycle()
        call.assert_called()
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetReplicationCycleRequest()


@pytest.mark.asyncio
async def test_get_replication_cycle_async(
    transport: str = "grpc_asyncio", request_type=vmmigration.GetReplicationCycleRequest
):
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Everything is optional in proto3 as far as the runtime is concerned,
    # and we are mocking out the actual API, so just send an empty request.
    request = request_type()

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_replication_cycle), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ReplicationCycle(
                name="name_value",
                cycle_number=1272,
                progress_percent=1733,
                state=vmmigration.ReplicationCycle.State.RUNNING,
            )
        )
        response = await client.get_replication_cycle(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == vmmigration.GetReplicationCycleRequest()

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.ReplicationCycle)
    assert response.name == "name_value"
    assert response.cycle_number == 1272
    assert response.progress_percent == 1733
    assert response.state == vmmigration.ReplicationCycle.State.RUNNING


@pytest.mark.asyncio
async def test_get_replication_cycle_async_from_dict():
    await test_get_replication_cycle_async(request_type=dict)


def test_get_replication_cycle_field_headers():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetReplicationCycleRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_replication_cycle), "__call__"
    ) as call:
        call.return_value = vmmigration.ReplicationCycle()
        client.get_replication_cycle(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


@pytest.mark.asyncio
async def test_get_replication_cycle_field_headers_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Any value that is part of the HTTP/1.1 URI should be sent as
    # a field header. Set these to a non-empty value.
    request = vmmigration.GetReplicationCycleRequest()

    request.name = "name_value"

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_replication_cycle), "__call__"
    ) as call:
        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ReplicationCycle()
        )
        await client.get_replication_cycle(request)

        # Establish that the underlying gRPC stub method was called.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        assert args[0] == request

    # Establish that the field header was sent.
    _, _, kw = call.mock_calls[0]
    assert (
        "x-goog-request-params",
        "name=name_value",
    ) in kw["metadata"]


def test_get_replication_cycle_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_replication_cycle), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ReplicationCycle()
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        client.get_replication_cycle(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls) == 1
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


def test_get_replication_cycle_flattened_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_replication_cycle(
            vmmigration.GetReplicationCycleRequest(),
            name="name_value",
        )


@pytest.mark.asyncio
async def test_get_replication_cycle_flattened_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Mock the actual call within the gRPC stub, and fake the request.
    with mock.patch.object(
        type(client.transport.get_replication_cycle), "__call__"
    ) as call:
        # Designate an appropriate return value for the call.
        call.return_value = vmmigration.ReplicationCycle()

        call.return_value = grpc_helpers_async.FakeUnaryUnaryCall(
            vmmigration.ReplicationCycle()
        )
        # Call the method with a truthy value for each flattened field,
        # using the keyword arguments to the method.
        response = await client.get_replication_cycle(
            name="name_value",
        )

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(call.mock_calls)
        _, args, _ = call.mock_calls[0]
        arg = args[0].name
        mock_val = "name_value"
        assert arg == mock_val


@pytest.mark.asyncio
async def test_get_replication_cycle_flattened_error_async():
    client = VmMigrationAsyncClient(
        credentials=ga_credentials.AnonymousCredentials(),
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        await client.get_replication_cycle(
            vmmigration.GetReplicationCycleRequest(),
            name="name_value",
        )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListSourcesRequest,
        dict,
    ],
)
def test_list_sources_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListSourcesResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListSourcesResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_sources(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListSourcesPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_sources_rest_required_fields(request_type=vmmigration.ListSourcesRequest):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_sources._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_sources._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListSourcesResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListSourcesResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_sources(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_sources_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_sources._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_sources_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_sources"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_sources"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListSourcesRequest.pb(vmmigration.ListSourcesRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.ListSourcesResponse.to_json(
            vmmigration.ListSourcesResponse()
        )

        request = vmmigration.ListSourcesRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListSourcesResponse()

        client.list_sources(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_sources_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListSourcesRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_sources(request)


def test_list_sources_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListSourcesResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {"parent": "projects/sample1/locations/sample2"}

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListSourcesResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_sources(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*}/sources" % client.transport._host,
            args[1],
        )


def test_list_sources_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_sources(
            vmmigration.ListSourcesRequest(),
            parent="parent_value",
        )


def test_list_sources_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListSourcesResponse(
                sources=[],
                next_page_token="def",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListSourcesResponse(
                sources=[
                    vmmigration.Source(),
                    vmmigration.Source(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(vmmigration.ListSourcesResponse.to_json(x) for x in response)
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {"parent": "projects/sample1/locations/sample2"}

        pager = client.list_sources(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.Source) for i in results)

        pages = list(client.list_sources(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetSourceRequest,
        dict,
    ],
)
def test_get_source_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.Source(
            name="name_value",
            description="description_value",
            vmware=vmmigration.VmwareSourceDetails(username="username_value"),
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.Source.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_source(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.Source)
    assert response.name == "name_value"
    assert response.description == "description_value"


def test_get_source_rest_required_fields(request_type=vmmigration.GetSourceRequest):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_source._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_source._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.Source()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.Source.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_source(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_source_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_source._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_source_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_source"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_source"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetSourceRequest.pb(vmmigration.GetSourceRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.Source.to_json(vmmigration.Source())

        request = vmmigration.GetSourceRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.Source()

        client.get_source(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_source_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetSourceRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_source(request)


def test_get_source_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.Source()

        # get arguments that satisfy an http rule for this method
        sample_request = {"name": "projects/sample1/locations/sample2/sources/sample3"}

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.Source.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_source(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*}" % client.transport._host,
            args[1],
        )


def test_get_source_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_source(
            vmmigration.GetSourceRequest(),
            name="name_value",
        )


def test_get_source_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateSourceRequest,
        dict,
    ],
)
def test_create_source_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request_init["source"] = {
        "vmware": {
            "username": "username_value",
            "password": "password_value",
            "vcenter_ip": "vcenter_ip_value",
            "thumbprint": "thumbprint_value",
        },
        "aws": {
            "access_key_creds": {
                "access_key_id": "access_key_id_value",
                "secret_access_key": "secret_access_key_value",
            },
            "aws_region": "aws_region_value",
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
            "inventory_tag_list": [{"key": "key_value", "value": "value_value"}],
            "inventory_security_group_names": [
                "inventory_security_group_names_value1",
                "inventory_security_group_names_value2",
            ],
            "migration_resources_user_tags": {},
            "public_ip": "public_ip_value",
        },
        "name": "name_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "labels": {},
        "description": "description_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_source(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_source_rest_required_fields(
    request_type=vmmigration.CreateSourceRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["source_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "sourceId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_source._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "sourceId" in jsonified_request
    assert jsonified_request["sourceId"] == request_init["source_id"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["sourceId"] = "source_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_source._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "request_id",
            "source_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "sourceId" in jsonified_request
    assert jsonified_request["sourceId"] == "source_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_source(request)

            expected_params = [
                (
                    "sourceId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_source_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_source._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "requestId",
                "sourceId",
            )
        )
        & set(
            (
                "parent",
                "sourceId",
                "source",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_source_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_source"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_source"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateSourceRequest.pb(
            vmmigration.CreateSourceRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateSourceRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_source(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_source_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateSourceRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request_init["source"] = {
        "vmware": {
            "username": "username_value",
            "password": "password_value",
            "vcenter_ip": "vcenter_ip_value",
            "thumbprint": "thumbprint_value",
        },
        "aws": {
            "access_key_creds": {
                "access_key_id": "access_key_id_value",
                "secret_access_key": "secret_access_key_value",
            },
            "aws_region": "aws_region_value",
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
            "inventory_tag_list": [{"key": "key_value", "value": "value_value"}],
            "inventory_security_group_names": [
                "inventory_security_group_names_value1",
                "inventory_security_group_names_value2",
            ],
            "migration_resources_user_tags": {},
            "public_ip": "public_ip_value",
        },
        "name": "name_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "labels": {},
        "description": "description_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_source(request)


def test_create_source_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {"parent": "projects/sample1/locations/sample2"}

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            source_id="source_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_source(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*}/sources" % client.transport._host,
            args[1],
        )


def test_create_source_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_source(
            vmmigration.CreateSourceRequest(),
            parent="parent_value",
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            source_id="source_id_value",
        )


def test_create_source_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateSourceRequest,
        dict,
    ],
)
def test_update_source_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "source": {"name": "projects/sample1/locations/sample2/sources/sample3"}
    }
    request_init["source"] = {
        "vmware": {
            "username": "username_value",
            "password": "password_value",
            "vcenter_ip": "vcenter_ip_value",
            "thumbprint": "thumbprint_value",
        },
        "aws": {
            "access_key_creds": {
                "access_key_id": "access_key_id_value",
                "secret_access_key": "secret_access_key_value",
            },
            "aws_region": "aws_region_value",
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
            "inventory_tag_list": [{"key": "key_value", "value": "value_value"}],
            "inventory_security_group_names": [
                "inventory_security_group_names_value1",
                "inventory_security_group_names_value2",
            ],
            "migration_resources_user_tags": {},
            "public_ip": "public_ip_value",
        },
        "name": "projects/sample1/locations/sample2/sources/sample3",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "labels": {},
        "description": "description_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.update_source(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_update_source_rest_required_fields(
    request_type=vmmigration.UpdateSourceRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_source._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_source._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "request_id",
            "update_mask",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "patch",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.update_source(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_update_source_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.update_source._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "requestId",
                "updateMask",
            )
        )
        & set(("source",))
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_update_source_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_update_source"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_update_source"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.UpdateSourceRequest.pb(
            vmmigration.UpdateSourceRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.UpdateSourceRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.update_source(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_update_source_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.UpdateSourceRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "source": {"name": "projects/sample1/locations/sample2/sources/sample3"}
    }
    request_init["source"] = {
        "vmware": {
            "username": "username_value",
            "password": "password_value",
            "vcenter_ip": "vcenter_ip_value",
            "thumbprint": "thumbprint_value",
        },
        "aws": {
            "access_key_creds": {
                "access_key_id": "access_key_id_value",
                "secret_access_key": "secret_access_key_value",
            },
            "aws_region": "aws_region_value",
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
            "inventory_tag_list": [{"key": "key_value", "value": "value_value"}],
            "inventory_security_group_names": [
                "inventory_security_group_names_value1",
                "inventory_security_group_names_value2",
            ],
            "migration_resources_user_tags": {},
            "public_ip": "public_ip_value",
        },
        "name": "projects/sample1/locations/sample2/sources/sample3",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "labels": {},
        "description": "description_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.update_source(request)


def test_update_source_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "source": {"name": "projects/sample1/locations/sample2/sources/sample3"}
        }

        # get truthy value for each flattened field
        mock_args = dict(
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.update_source(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{source.name=projects/*/locations/*/sources/*}"
            % client.transport._host,
            args[1],
        )


def test_update_source_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_source(
            vmmigration.UpdateSourceRequest(),
            source=vmmigration.Source(
                vmware=vmmigration.VmwareSourceDetails(username="username_value")
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


def test_update_source_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteSourceRequest,
        dict,
    ],
)
def test_delete_source_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.delete_source(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_delete_source_rest_required_fields(
    request_type=vmmigration.DeleteSourceRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_source._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_source._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("request_id",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "delete",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.delete_source(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_delete_source_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.delete_source._get_unset_required_fields({})
    assert set(unset_fields) == (set(("requestId",)) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_delete_source_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_delete_source"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_delete_source"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.DeleteSourceRequest.pb(
            vmmigration.DeleteSourceRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.DeleteSourceRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.delete_source(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_delete_source_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.DeleteSourceRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.delete_source(request)


def test_delete_source_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {"name": "projects/sample1/locations/sample2/sources/sample3"}

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.delete_source(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*}" % client.transport._host,
            args[1],
        )


def test_delete_source_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_source(
            vmmigration.DeleteSourceRequest(),
            name="name_value",
        )


def test_delete_source_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.FetchInventoryRequest,
        dict,
    ],
)
def test_fetch_inventory_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"source": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.FetchInventoryResponse(
            vmware_vms=vmmigration.VmwareVmsDetails(
                details=[vmmigration.VmwareVmDetails(vm_id="vm_id_value")]
            ),
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.FetchInventoryResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.fetch_inventory(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.FetchInventoryResponse)


def test_fetch_inventory_rest_required_fields(
    request_type=vmmigration.FetchInventoryRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["source"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).fetch_inventory._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["source"] = "source_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).fetch_inventory._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("force_refresh",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "source" in jsonified_request
    assert jsonified_request["source"] == "source_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.FetchInventoryResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.FetchInventoryResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.fetch_inventory(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_fetch_inventory_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.fetch_inventory._get_unset_required_fields({})
    assert set(unset_fields) == (set(("forceRefresh",)) & set(("source",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_fetch_inventory_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_fetch_inventory"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_fetch_inventory"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.FetchInventoryRequest.pb(
            vmmigration.FetchInventoryRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.FetchInventoryResponse.to_json(
            vmmigration.FetchInventoryResponse()
        )

        request = vmmigration.FetchInventoryRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.FetchInventoryResponse()

        client.fetch_inventory(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_fetch_inventory_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.FetchInventoryRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"source": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.fetch_inventory(request)


def test_fetch_inventory_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.FetchInventoryResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "source": "projects/sample1/locations/sample2/sources/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            source="source_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.FetchInventoryResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.fetch_inventory(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{source=projects/*/locations/*/sources/*}:fetchInventory"
            % client.transport._host,
            args[1],
        )


def test_fetch_inventory_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.fetch_inventory(
            vmmigration.FetchInventoryRequest(),
            source="source_value",
        )


def test_fetch_inventory_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListUtilizationReportsRequest,
        dict,
    ],
)
def test_list_utilization_reports_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListUtilizationReportsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListUtilizationReportsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_utilization_reports(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListUtilizationReportsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_utilization_reports_rest_required_fields(
    request_type=vmmigration.ListUtilizationReportsRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_utilization_reports._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_utilization_reports._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
            "view",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListUtilizationReportsResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListUtilizationReportsResponse.pb(
                return_value
            )
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_utilization_reports(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_utilization_reports_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_utilization_reports._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
                "view",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_utilization_reports_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_utilization_reports"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_utilization_reports"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListUtilizationReportsRequest.pb(
            vmmigration.ListUtilizationReportsRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.ListUtilizationReportsResponse.to_json(
            vmmigration.ListUtilizationReportsResponse()
        )

        request = vmmigration.ListUtilizationReportsRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListUtilizationReportsResponse()

        client.list_utilization_reports(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_utilization_reports_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListUtilizationReportsRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_utilization_reports(request)


def test_list_utilization_reports_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListUtilizationReportsResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListUtilizationReportsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_utilization_reports(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*}/utilizationReports"
            % client.transport._host,
            args[1],
        )


def test_list_utilization_reports_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_utilization_reports(
            vmmigration.ListUtilizationReportsRequest(),
            parent="parent_value",
        )


def test_list_utilization_reports_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[],
                next_page_token="def",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListUtilizationReportsResponse(
                utilization_reports=[
                    vmmigration.UtilizationReport(),
                    vmmigration.UtilizationReport(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(
            vmmigration.ListUtilizationReportsResponse.to_json(x) for x in response
        )
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        pager = client.list_utilization_reports(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.UtilizationReport) for i in results)

        pages = list(client.list_utilization_reports(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetUtilizationReportRequest,
        dict,
    ],
)
def test_get_utilization_report_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/utilizationReports/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.UtilizationReport(
            name="name_value",
            display_name="display_name_value",
            state=vmmigration.UtilizationReport.State.CREATING,
            time_frame=vmmigration.UtilizationReport.TimeFrame.WEEK,
            vm_count=875,
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.UtilizationReport.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_utilization_report(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.UtilizationReport)
    assert response.name == "name_value"
    assert response.display_name == "display_name_value"
    assert response.state == vmmigration.UtilizationReport.State.CREATING
    assert response.time_frame == vmmigration.UtilizationReport.TimeFrame.WEEK
    assert response.vm_count == 875


def test_get_utilization_report_rest_required_fields(
    request_type=vmmigration.GetUtilizationReportRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_utilization_report._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_utilization_report._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("view",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.UtilizationReport()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.UtilizationReport.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_utilization_report(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_utilization_report_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_utilization_report._get_unset_required_fields({})
    assert set(unset_fields) == (set(("view",)) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_utilization_report_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_utilization_report"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_utilization_report"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetUtilizationReportRequest.pb(
            vmmigration.GetUtilizationReportRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.UtilizationReport.to_json(
            vmmigration.UtilizationReport()
        )

        request = vmmigration.GetUtilizationReportRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.UtilizationReport()

        client.get_utilization_report(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_utilization_report_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetUtilizationReportRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/utilizationReports/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_utilization_report(request)


def test_get_utilization_report_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.UtilizationReport()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/utilizationReports/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.UtilizationReport.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_utilization_report(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/utilizationReports/*}"
            % client.transport._host,
            args[1],
        )


def test_get_utilization_report_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_utilization_report(
            vmmigration.GetUtilizationReportRequest(),
            name="name_value",
        )


def test_get_utilization_report_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateUtilizationReportRequest,
        dict,
    ],
)
def test_create_utilization_report_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request_init["utilization_report"] = {
        "name": "name_value",
        "display_name": "display_name_value",
        "state": 1,
        "state_time": {"seconds": 751, "nanos": 543},
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "create_time": {},
        "time_frame": 1,
        "frame_end_time": {},
        "vm_count": 875,
        "vms": [
            {
                "vmware_vm_details": {
                    "vm_id": "vm_id_value",
                    "datacenter_id": "datacenter_id_value",
                    "datacenter_description": "datacenter_description_value",
                    "uuid": "uuid_value",
                    "display_name": "display_name_value",
                    "power_state": 1,
                    "cpu_count": 976,
                    "memory_mb": 967,
                    "disk_count": 1075,
                    "committed_storage_mb": 2120,
                    "guest_description": "guest_description_value",
                    "boot_option": 1,
                },
                "vm_id": "vm_id_value",
                "utilization": {
                    "cpu_max_percent": 1597,
                    "cpu_average_percent": 2002,
                    "memory_max_percent": 1934,
                    "memory_average_percent": 2339,
                    "disk_io_rate_max_kbps": 2209,
                    "disk_io_rate_average_kbps": 2614,
                    "network_throughput_max_kbps": 2935,
                    "network_throughput_average_kbps": 3340,
                },
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_utilization_report(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_utilization_report_rest_required_fields(
    request_type=vmmigration.CreateUtilizationReportRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["utilization_report_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "utilizationReportId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_utilization_report._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "utilizationReportId" in jsonified_request
    assert (
        jsonified_request["utilizationReportId"]
        == request_init["utilization_report_id"]
    )

    jsonified_request["parent"] = "parent_value"
    jsonified_request["utilizationReportId"] = "utilization_report_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_utilization_report._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "request_id",
            "utilization_report_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "utilizationReportId" in jsonified_request
    assert jsonified_request["utilizationReportId"] == "utilization_report_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_utilization_report(request)

            expected_params = [
                (
                    "utilizationReportId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_utilization_report_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_utilization_report._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "requestId",
                "utilizationReportId",
            )
        )
        & set(
            (
                "parent",
                "utilizationReport",
                "utilizationReportId",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_utilization_report_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_utilization_report"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_utilization_report"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateUtilizationReportRequest.pb(
            vmmigration.CreateUtilizationReportRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateUtilizationReportRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_utilization_report(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_utilization_report_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateUtilizationReportRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request_init["utilization_report"] = {
        "name": "name_value",
        "display_name": "display_name_value",
        "state": 1,
        "state_time": {"seconds": 751, "nanos": 543},
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "create_time": {},
        "time_frame": 1,
        "frame_end_time": {},
        "vm_count": 875,
        "vms": [
            {
                "vmware_vm_details": {
                    "vm_id": "vm_id_value",
                    "datacenter_id": "datacenter_id_value",
                    "datacenter_description": "datacenter_description_value",
                    "uuid": "uuid_value",
                    "display_name": "display_name_value",
                    "power_state": 1,
                    "cpu_count": 976,
                    "memory_mb": 967,
                    "disk_count": 1075,
                    "committed_storage_mb": 2120,
                    "guest_description": "guest_description_value",
                    "boot_option": 1,
                },
                "vm_id": "vm_id_value",
                "utilization": {
                    "cpu_max_percent": 1597,
                    "cpu_average_percent": 2002,
                    "memory_max_percent": 1934,
                    "memory_average_percent": 2339,
                    "disk_io_rate_max_kbps": 2209,
                    "disk_io_rate_average_kbps": 2614,
                    "network_throughput_max_kbps": 2935,
                    "network_throughput_average_kbps": 3340,
                },
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_utilization_report(request)


def test_create_utilization_report_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            utilization_report=vmmigration.UtilizationReport(name="name_value"),
            utilization_report_id="utilization_report_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_utilization_report(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*}/utilizationReports"
            % client.transport._host,
            args[1],
        )


def test_create_utilization_report_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_utilization_report(
            vmmigration.CreateUtilizationReportRequest(),
            parent="parent_value",
            utilization_report=vmmigration.UtilizationReport(name="name_value"),
            utilization_report_id="utilization_report_id_value",
        )


def test_create_utilization_report_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteUtilizationReportRequest,
        dict,
    ],
)
def test_delete_utilization_report_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/utilizationReports/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.delete_utilization_report(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_delete_utilization_report_rest_required_fields(
    request_type=vmmigration.DeleteUtilizationReportRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_utilization_report._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_utilization_report._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("request_id",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "delete",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.delete_utilization_report(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_delete_utilization_report_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.delete_utilization_report._get_unset_required_fields({})
    assert set(unset_fields) == (set(("requestId",)) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_delete_utilization_report_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_delete_utilization_report"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_delete_utilization_report"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.DeleteUtilizationReportRequest.pb(
            vmmigration.DeleteUtilizationReportRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.DeleteUtilizationReportRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.delete_utilization_report(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_delete_utilization_report_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.DeleteUtilizationReportRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/utilizationReports/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.delete_utilization_report(request)


def test_delete_utilization_report_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/utilizationReports/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.delete_utilization_report(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/utilizationReports/*}"
            % client.transport._host,
            args[1],
        )


def test_delete_utilization_report_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_utilization_report(
            vmmigration.DeleteUtilizationReportRequest(),
            name="name_value",
        )


def test_delete_utilization_report_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListDatacenterConnectorsRequest,
        dict,
    ],
)
def test_list_datacenter_connectors_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListDatacenterConnectorsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListDatacenterConnectorsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_datacenter_connectors(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListDatacenterConnectorsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_datacenter_connectors_rest_required_fields(
    request_type=vmmigration.ListDatacenterConnectorsRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_datacenter_connectors._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_datacenter_connectors._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListDatacenterConnectorsResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListDatacenterConnectorsResponse.pb(
                return_value
            )
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_datacenter_connectors(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_datacenter_connectors_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_datacenter_connectors._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_datacenter_connectors_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_datacenter_connectors"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_datacenter_connectors"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListDatacenterConnectorsRequest.pb(
            vmmigration.ListDatacenterConnectorsRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = (
            vmmigration.ListDatacenterConnectorsResponse.to_json(
                vmmigration.ListDatacenterConnectorsResponse()
            )
        )

        request = vmmigration.ListDatacenterConnectorsRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListDatacenterConnectorsResponse()

        client.list_datacenter_connectors(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_datacenter_connectors_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListDatacenterConnectorsRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_datacenter_connectors(request)


def test_list_datacenter_connectors_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListDatacenterConnectorsResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListDatacenterConnectorsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_datacenter_connectors(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*}/datacenterConnectors"
            % client.transport._host,
            args[1],
        )


def test_list_datacenter_connectors_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_datacenter_connectors(
            vmmigration.ListDatacenterConnectorsRequest(),
            parent="parent_value",
        )


def test_list_datacenter_connectors_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[],
                next_page_token="def",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListDatacenterConnectorsResponse(
                datacenter_connectors=[
                    vmmigration.DatacenterConnector(),
                    vmmigration.DatacenterConnector(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(
            vmmigration.ListDatacenterConnectorsResponse.to_json(x) for x in response
        )
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        pager = client.list_datacenter_connectors(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.DatacenterConnector) for i in results)

        pages = list(client.list_datacenter_connectors(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetDatacenterConnectorRequest,
        dict,
    ],
)
def test_get_datacenter_connector_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.DatacenterConnector(
            name="name_value",
            registration_id="registration_id_value",
            service_account="service_account_value",
            version="version_value",
            bucket="bucket_value",
            state=vmmigration.DatacenterConnector.State.PENDING,
            appliance_infrastructure_version="appliance_infrastructure_version_value",
            appliance_software_version="appliance_software_version_value",
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.DatacenterConnector.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_datacenter_connector(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.DatacenterConnector)
    assert response.name == "name_value"
    assert response.registration_id == "registration_id_value"
    assert response.service_account == "service_account_value"
    assert response.version == "version_value"
    assert response.bucket == "bucket_value"
    assert response.state == vmmigration.DatacenterConnector.State.PENDING
    assert (
        response.appliance_infrastructure_version
        == "appliance_infrastructure_version_value"
    )
    assert response.appliance_software_version == "appliance_software_version_value"


def test_get_datacenter_connector_rest_required_fields(
    request_type=vmmigration.GetDatacenterConnectorRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_datacenter_connector._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_datacenter_connector._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.DatacenterConnector()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.DatacenterConnector.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_datacenter_connector(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_datacenter_connector_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_datacenter_connector._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_datacenter_connector_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_datacenter_connector"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_datacenter_connector"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetDatacenterConnectorRequest.pb(
            vmmigration.GetDatacenterConnectorRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.DatacenterConnector.to_json(
            vmmigration.DatacenterConnector()
        )

        request = vmmigration.GetDatacenterConnectorRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.DatacenterConnector()

        client.get_datacenter_connector(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_datacenter_connector_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetDatacenterConnectorRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_datacenter_connector(request)


def test_get_datacenter_connector_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.DatacenterConnector()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.DatacenterConnector.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_datacenter_connector(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/datacenterConnectors/*}"
            % client.transport._host,
            args[1],
        )


def test_get_datacenter_connector_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_datacenter_connector(
            vmmigration.GetDatacenterConnectorRequest(),
            name="name_value",
        )


def test_get_datacenter_connector_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateDatacenterConnectorRequest,
        dict,
    ],
)
def test_create_datacenter_connector_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request_init["datacenter_connector"] = {
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "name": "name_value",
        "registration_id": "registration_id_value",
        "service_account": "service_account_value",
        "version": "version_value",
        "bucket": "bucket_value",
        "state": 1,
        "state_time": {},
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "appliance_infrastructure_version": "appliance_infrastructure_version_value",
        "appliance_software_version": "appliance_software_version_value",
        "available_versions": {
            "new_deployable_appliance": {
                "version": "version_value",
                "uri": "uri_value",
                "critical": True,
                "release_notes_uri": "release_notes_uri_value",
            },
            "in_place_update": {},
        },
        "upgrade_status": {
            "version": "version_value",
            "state": 1,
            "error": {},
            "start_time": {},
            "previous_version": "previous_version_value",
        },
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_datacenter_connector(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_datacenter_connector_rest_required_fields(
    request_type=vmmigration.CreateDatacenterConnectorRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["datacenter_connector_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "datacenterConnectorId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_datacenter_connector._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "datacenterConnectorId" in jsonified_request
    assert (
        jsonified_request["datacenterConnectorId"]
        == request_init["datacenter_connector_id"]
    )

    jsonified_request["parent"] = "parent_value"
    jsonified_request["datacenterConnectorId"] = "datacenter_connector_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_datacenter_connector._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "datacenter_connector_id",
            "request_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "datacenterConnectorId" in jsonified_request
    assert jsonified_request["datacenterConnectorId"] == "datacenter_connector_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_datacenter_connector(request)

            expected_params = [
                (
                    "datacenterConnectorId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_datacenter_connector_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_datacenter_connector._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "datacenterConnectorId",
                "requestId",
            )
        )
        & set(
            (
                "parent",
                "datacenterConnectorId",
                "datacenterConnector",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_datacenter_connector_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_datacenter_connector"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_datacenter_connector"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateDatacenterConnectorRequest.pb(
            vmmigration.CreateDatacenterConnectorRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateDatacenterConnectorRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_datacenter_connector(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_datacenter_connector_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateDatacenterConnectorRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request_init["datacenter_connector"] = {
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "name": "name_value",
        "registration_id": "registration_id_value",
        "service_account": "service_account_value",
        "version": "version_value",
        "bucket": "bucket_value",
        "state": 1,
        "state_time": {},
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "appliance_infrastructure_version": "appliance_infrastructure_version_value",
        "appliance_software_version": "appliance_software_version_value",
        "available_versions": {
            "new_deployable_appliance": {
                "version": "version_value",
                "uri": "uri_value",
                "critical": True,
                "release_notes_uri": "release_notes_uri_value",
            },
            "in_place_update": {},
        },
        "upgrade_status": {
            "version": "version_value",
            "state": 1,
            "error": {},
            "start_time": {},
            "previous_version": "previous_version_value",
        },
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_datacenter_connector(request)


def test_create_datacenter_connector_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            datacenter_connector=vmmigration.DatacenterConnector(
                create_time=timestamp_pb2.Timestamp(seconds=751)
            ),
            datacenter_connector_id="datacenter_connector_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_datacenter_connector(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*}/datacenterConnectors"
            % client.transport._host,
            args[1],
        )


def test_create_datacenter_connector_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_datacenter_connector(
            vmmigration.CreateDatacenterConnectorRequest(),
            parent="parent_value",
            datacenter_connector=vmmigration.DatacenterConnector(
                create_time=timestamp_pb2.Timestamp(seconds=751)
            ),
            datacenter_connector_id="datacenter_connector_id_value",
        )


def test_create_datacenter_connector_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteDatacenterConnectorRequest,
        dict,
    ],
)
def test_delete_datacenter_connector_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.delete_datacenter_connector(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_delete_datacenter_connector_rest_required_fields(
    request_type=vmmigration.DeleteDatacenterConnectorRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_datacenter_connector._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_datacenter_connector._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("request_id",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "delete",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.delete_datacenter_connector(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_delete_datacenter_connector_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.delete_datacenter_connector._get_unset_required_fields({})
    assert set(unset_fields) == (set(("requestId",)) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_delete_datacenter_connector_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_delete_datacenter_connector"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_delete_datacenter_connector"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.DeleteDatacenterConnectorRequest.pb(
            vmmigration.DeleteDatacenterConnectorRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.DeleteDatacenterConnectorRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.delete_datacenter_connector(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_delete_datacenter_connector_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.DeleteDatacenterConnectorRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.delete_datacenter_connector(request)


def test_delete_datacenter_connector_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.delete_datacenter_connector(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/datacenterConnectors/*}"
            % client.transport._host,
            args[1],
        )


def test_delete_datacenter_connector_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_datacenter_connector(
            vmmigration.DeleteDatacenterConnectorRequest(),
            name="name_value",
        )


def test_delete_datacenter_connector_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpgradeApplianceRequest,
        dict,
    ],
)
def test_upgrade_appliance_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "datacenter_connector": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.upgrade_appliance(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_upgrade_appliance_rest_required_fields(
    request_type=vmmigration.UpgradeApplianceRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["datacenter_connector"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).upgrade_appliance._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["datacenterConnector"] = "datacenter_connector_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).upgrade_appliance._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "datacenterConnector" in jsonified_request
    assert jsonified_request["datacenterConnector"] == "datacenter_connector_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.upgrade_appliance(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_upgrade_appliance_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.upgrade_appliance._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("datacenterConnector",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_upgrade_appliance_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_upgrade_appliance"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_upgrade_appliance"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.UpgradeApplianceRequest.pb(
            vmmigration.UpgradeApplianceRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.UpgradeApplianceRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.upgrade_appliance(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_upgrade_appliance_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.UpgradeApplianceRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "datacenter_connector": "projects/sample1/locations/sample2/sources/sample3/datacenterConnectors/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.upgrade_appliance(request)


def test_upgrade_appliance_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateMigratingVmRequest,
        dict,
    ],
)
def test_create_migrating_vm_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request_init["migrating_vm"] = {
        "compute_engine_target_defaults": {
            "vm_name": "vm_name_value",
            "target_project": "target_project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "aws_source_vm_details": {"firmware": 1, "committed_storage_bytes": 2464},
        "name": "name_value",
        "source_vm_id": "source_vm_id_value",
        "display_name": "display_name_value",
        "description": "description_value",
        "policy": {
            "idle_duration": {"seconds": 751, "nanos": 543},
            "skip_os_adaptation": True,
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "last_sync": {"last_sync_time": {}},
        "state": 1,
        "state_time": {},
        "current_sync_info": {
            "name": "name_value",
            "cycle_number": 1272,
            "start_time": {},
            "end_time": {},
            "total_pause_duration": {},
            "progress_percent": 1733,
            "steps": [
                {
                    "initializing_replication": {},
                    "replicating": {
                        "total_bytes": 1194,
                        "replicated_bytes": 1699,
                        "last_two_minutes_average_bytes_per_second": 4370,
                        "last_thirty_minutes_average_bytes_per_second": 4700,
                    },
                    "post_processing": {},
                    "start_time": {},
                    "end_time": {},
                }
            ],
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
        },
        "group": "group_value",
        "labels": {},
        "recent_clone_jobs": [
            {
                "compute_engine_target_details": {
                    "vm_name": "vm_name_value",
                    "project": "project_value",
                    "zone": "zone_value",
                    "machine_type_series": "machine_type_series_value",
                    "machine_type": "machine_type_value",
                    "network_tags": ["network_tags_value1", "network_tags_value2"],
                    "network_interfaces": {},
                    "service_account": "service_account_value",
                    "disk_type": 1,
                    "labels": {},
                    "license_type": 1,
                    "applied_license": {},
                    "compute_scheduling": {},
                    "secure_boot": True,
                    "boot_option": 1,
                    "metadata": {},
                    "additional_licenses": [
                        "additional_licenses_value1",
                        "additional_licenses_value2",
                    ],
                    "hostname": "hostname_value",
                },
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "error": {},
                "steps": [
                    {
                        "adapting_os": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
        "error": {},
        "recent_cutover_jobs": [
            {
                "compute_engine_target_details": {},
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "progress_percent": 1733,
                "error": {},
                "state_message": "state_message_value",
                "steps": [
                    {
                        "previous_replication_cycle": {},
                        "shutting_down_source_vm": {},
                        "final_sync": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_migrating_vm(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_migrating_vm_rest_required_fields(
    request_type=vmmigration.CreateMigratingVmRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["migrating_vm_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "migratingVmId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_migrating_vm._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "migratingVmId" in jsonified_request
    assert jsonified_request["migratingVmId"] == request_init["migrating_vm_id"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["migratingVmId"] = "migrating_vm_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_migrating_vm._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "migrating_vm_id",
            "request_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "migratingVmId" in jsonified_request
    assert jsonified_request["migratingVmId"] == "migrating_vm_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_migrating_vm(request)

            expected_params = [
                (
                    "migratingVmId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_migrating_vm_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_migrating_vm._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "migratingVmId",
                "requestId",
            )
        )
        & set(
            (
                "parent",
                "migratingVmId",
                "migratingVm",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_migrating_vm_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_migrating_vm"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_migrating_vm"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateMigratingVmRequest.pb(
            vmmigration.CreateMigratingVmRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateMigratingVmRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_migrating_vm(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_migrating_vm_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateMigratingVmRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request_init["migrating_vm"] = {
        "compute_engine_target_defaults": {
            "vm_name": "vm_name_value",
            "target_project": "target_project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "aws_source_vm_details": {"firmware": 1, "committed_storage_bytes": 2464},
        "name": "name_value",
        "source_vm_id": "source_vm_id_value",
        "display_name": "display_name_value",
        "description": "description_value",
        "policy": {
            "idle_duration": {"seconds": 751, "nanos": 543},
            "skip_os_adaptation": True,
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "last_sync": {"last_sync_time": {}},
        "state": 1,
        "state_time": {},
        "current_sync_info": {
            "name": "name_value",
            "cycle_number": 1272,
            "start_time": {},
            "end_time": {},
            "total_pause_duration": {},
            "progress_percent": 1733,
            "steps": [
                {
                    "initializing_replication": {},
                    "replicating": {
                        "total_bytes": 1194,
                        "replicated_bytes": 1699,
                        "last_two_minutes_average_bytes_per_second": 4370,
                        "last_thirty_minutes_average_bytes_per_second": 4700,
                    },
                    "post_processing": {},
                    "start_time": {},
                    "end_time": {},
                }
            ],
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
        },
        "group": "group_value",
        "labels": {},
        "recent_clone_jobs": [
            {
                "compute_engine_target_details": {
                    "vm_name": "vm_name_value",
                    "project": "project_value",
                    "zone": "zone_value",
                    "machine_type_series": "machine_type_series_value",
                    "machine_type": "machine_type_value",
                    "network_tags": ["network_tags_value1", "network_tags_value2"],
                    "network_interfaces": {},
                    "service_account": "service_account_value",
                    "disk_type": 1,
                    "labels": {},
                    "license_type": 1,
                    "applied_license": {},
                    "compute_scheduling": {},
                    "secure_boot": True,
                    "boot_option": 1,
                    "metadata": {},
                    "additional_licenses": [
                        "additional_licenses_value1",
                        "additional_licenses_value2",
                    ],
                    "hostname": "hostname_value",
                },
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "error": {},
                "steps": [
                    {
                        "adapting_os": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
        "error": {},
        "recent_cutover_jobs": [
            {
                "compute_engine_target_details": {},
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "progress_percent": 1733,
                "error": {},
                "state_message": "state_message_value",
                "steps": [
                    {
                        "previous_replication_cycle": {},
                        "shutting_down_source_vm": {},
                        "final_sync": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_migrating_vm(request)


def test_create_migrating_vm_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            migrating_vm_id="migrating_vm_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_migrating_vm(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*}/migratingVms"
            % client.transport._host,
            args[1],
        )


def test_create_migrating_vm_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_migrating_vm(
            vmmigration.CreateMigratingVmRequest(),
            parent="parent_value",
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            migrating_vm_id="migrating_vm_id_value",
        )


def test_create_migrating_vm_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListMigratingVmsRequest,
        dict,
    ],
)
def test_list_migrating_vms_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListMigratingVmsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListMigratingVmsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_migrating_vms(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListMigratingVmsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_migrating_vms_rest_required_fields(
    request_type=vmmigration.ListMigratingVmsRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_migrating_vms._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_migrating_vms._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
            "view",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListMigratingVmsResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListMigratingVmsResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_migrating_vms(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_migrating_vms_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_migrating_vms._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
                "view",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_migrating_vms_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_migrating_vms"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_migrating_vms"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListMigratingVmsRequest.pb(
            vmmigration.ListMigratingVmsRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.ListMigratingVmsResponse.to_json(
            vmmigration.ListMigratingVmsResponse()
        )

        request = vmmigration.ListMigratingVmsRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListMigratingVmsResponse()

        client.list_migrating_vms(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_migrating_vms_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListMigratingVmsRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2/sources/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_migrating_vms(request)


def test_list_migrating_vms_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListMigratingVmsResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListMigratingVmsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_migrating_vms(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*}/migratingVms"
            % client.transport._host,
            args[1],
        )


def test_list_migrating_vms_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_migrating_vms(
            vmmigration.ListMigratingVmsRequest(),
            parent="parent_value",
        )


def test_list_migrating_vms_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[],
                next_page_token="def",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListMigratingVmsResponse(
                migrating_vms=[
                    vmmigration.MigratingVm(),
                    vmmigration.MigratingVm(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(
            vmmigration.ListMigratingVmsResponse.to_json(x) for x in response
        )
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3"
        }

        pager = client.list_migrating_vms(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.MigratingVm) for i in results)

        pages = list(client.list_migrating_vms(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetMigratingVmRequest,
        dict,
    ],
)
def test_get_migrating_vm_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.MigratingVm(
            name="name_value",
            source_vm_id="source_vm_id_value",
            display_name="display_name_value",
            description="description_value",
            state=vmmigration.MigratingVm.State.PENDING,
            group="group_value",
            compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                vm_name="vm_name_value"
            ),
            aws_source_vm_details=vmmigration.AwsSourceVmDetails(
                firmware=vmmigration.AwsSourceVmDetails.Firmware.EFI
            ),
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.MigratingVm.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_migrating_vm(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.MigratingVm)
    assert response.name == "name_value"
    assert response.source_vm_id == "source_vm_id_value"
    assert response.display_name == "display_name_value"
    assert response.description == "description_value"
    assert response.state == vmmigration.MigratingVm.State.PENDING
    assert response.group == "group_value"


def test_get_migrating_vm_rest_required_fields(
    request_type=vmmigration.GetMigratingVmRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_migrating_vm._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_migrating_vm._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("view",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.MigratingVm()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.MigratingVm.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_migrating_vm(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_migrating_vm_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_migrating_vm._get_unset_required_fields({})
    assert set(unset_fields) == (set(("view",)) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_migrating_vm_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_migrating_vm"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_migrating_vm"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetMigratingVmRequest.pb(
            vmmigration.GetMigratingVmRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.MigratingVm.to_json(
            vmmigration.MigratingVm()
        )

        request = vmmigration.GetMigratingVmRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.MigratingVm()

        client.get_migrating_vm(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_migrating_vm_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetMigratingVmRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_migrating_vm(request)


def test_get_migrating_vm_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.MigratingVm()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.MigratingVm.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_migrating_vm(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/migratingVms/*}"
            % client.transport._host,
            args[1],
        )


def test_get_migrating_vm_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_migrating_vm(
            vmmigration.GetMigratingVmRequest(),
            name="name_value",
        )


def test_get_migrating_vm_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateMigratingVmRequest,
        dict,
    ],
)
def test_update_migrating_vm_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }
    }
    request_init["migrating_vm"] = {
        "compute_engine_target_defaults": {
            "vm_name": "vm_name_value",
            "target_project": "target_project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "aws_source_vm_details": {"firmware": 1, "committed_storage_bytes": 2464},
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4",
        "source_vm_id": "source_vm_id_value",
        "display_name": "display_name_value",
        "description": "description_value",
        "policy": {
            "idle_duration": {"seconds": 751, "nanos": 543},
            "skip_os_adaptation": True,
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "last_sync": {"last_sync_time": {}},
        "state": 1,
        "state_time": {},
        "current_sync_info": {
            "name": "name_value",
            "cycle_number": 1272,
            "start_time": {},
            "end_time": {},
            "total_pause_duration": {},
            "progress_percent": 1733,
            "steps": [
                {
                    "initializing_replication": {},
                    "replicating": {
                        "total_bytes": 1194,
                        "replicated_bytes": 1699,
                        "last_two_minutes_average_bytes_per_second": 4370,
                        "last_thirty_minutes_average_bytes_per_second": 4700,
                    },
                    "post_processing": {},
                    "start_time": {},
                    "end_time": {},
                }
            ],
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
        },
        "group": "group_value",
        "labels": {},
        "recent_clone_jobs": [
            {
                "compute_engine_target_details": {
                    "vm_name": "vm_name_value",
                    "project": "project_value",
                    "zone": "zone_value",
                    "machine_type_series": "machine_type_series_value",
                    "machine_type": "machine_type_value",
                    "network_tags": ["network_tags_value1", "network_tags_value2"],
                    "network_interfaces": {},
                    "service_account": "service_account_value",
                    "disk_type": 1,
                    "labels": {},
                    "license_type": 1,
                    "applied_license": {},
                    "compute_scheduling": {},
                    "secure_boot": True,
                    "boot_option": 1,
                    "metadata": {},
                    "additional_licenses": [
                        "additional_licenses_value1",
                        "additional_licenses_value2",
                    ],
                    "hostname": "hostname_value",
                },
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "error": {},
                "steps": [
                    {
                        "adapting_os": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
        "error": {},
        "recent_cutover_jobs": [
            {
                "compute_engine_target_details": {},
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "progress_percent": 1733,
                "error": {},
                "state_message": "state_message_value",
                "steps": [
                    {
                        "previous_replication_cycle": {},
                        "shutting_down_source_vm": {},
                        "final_sync": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.update_migrating_vm(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_update_migrating_vm_rest_required_fields(
    request_type=vmmigration.UpdateMigratingVmRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_migrating_vm._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_migrating_vm._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "request_id",
            "update_mask",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "patch",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.update_migrating_vm(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_update_migrating_vm_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.update_migrating_vm._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "requestId",
                "updateMask",
            )
        )
        & set(("migratingVm",))
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_update_migrating_vm_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_update_migrating_vm"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_update_migrating_vm"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.UpdateMigratingVmRequest.pb(
            vmmigration.UpdateMigratingVmRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.UpdateMigratingVmRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.update_migrating_vm(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_update_migrating_vm_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.UpdateMigratingVmRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }
    }
    request_init["migrating_vm"] = {
        "compute_engine_target_defaults": {
            "vm_name": "vm_name_value",
            "target_project": "target_project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "aws_source_vm_details": {"firmware": 1, "committed_storage_bytes": 2464},
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4",
        "source_vm_id": "source_vm_id_value",
        "display_name": "display_name_value",
        "description": "description_value",
        "policy": {
            "idle_duration": {"seconds": 751, "nanos": 543},
            "skip_os_adaptation": True,
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "last_sync": {"last_sync_time": {}},
        "state": 1,
        "state_time": {},
        "current_sync_info": {
            "name": "name_value",
            "cycle_number": 1272,
            "start_time": {},
            "end_time": {},
            "total_pause_duration": {},
            "progress_percent": 1733,
            "steps": [
                {
                    "initializing_replication": {},
                    "replicating": {
                        "total_bytes": 1194,
                        "replicated_bytes": 1699,
                        "last_two_minutes_average_bytes_per_second": 4370,
                        "last_thirty_minutes_average_bytes_per_second": 4700,
                    },
                    "post_processing": {},
                    "start_time": {},
                    "end_time": {},
                }
            ],
            "state": 1,
            "error": {
                "code": 411,
                "message": "message_value",
                "details": [
                    {
                        "type_url": "type.googleapis.com/google.protobuf.Duration",
                        "value": b"\x08\x0c\x10\xdb\x07",
                    }
                ],
            },
        },
        "group": "group_value",
        "labels": {},
        "recent_clone_jobs": [
            {
                "compute_engine_target_details": {
                    "vm_name": "vm_name_value",
                    "project": "project_value",
                    "zone": "zone_value",
                    "machine_type_series": "machine_type_series_value",
                    "machine_type": "machine_type_value",
                    "network_tags": ["network_tags_value1", "network_tags_value2"],
                    "network_interfaces": {},
                    "service_account": "service_account_value",
                    "disk_type": 1,
                    "labels": {},
                    "license_type": 1,
                    "applied_license": {},
                    "compute_scheduling": {},
                    "secure_boot": True,
                    "boot_option": 1,
                    "metadata": {},
                    "additional_licenses": [
                        "additional_licenses_value1",
                        "additional_licenses_value2",
                    ],
                    "hostname": "hostname_value",
                },
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "error": {},
                "steps": [
                    {
                        "adapting_os": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
        "error": {},
        "recent_cutover_jobs": [
            {
                "compute_engine_target_details": {},
                "create_time": {},
                "end_time": {},
                "name": "name_value",
                "state": 1,
                "state_time": {},
                "progress_percent": 1733,
                "error": {},
                "state_message": "state_message_value",
                "steps": [
                    {
                        "previous_replication_cycle": {},
                        "shutting_down_source_vm": {},
                        "final_sync": {},
                        "preparing_vm_disks": {},
                        "instantiating_migrated_vm": {},
                        "start_time": {},
                        "end_time": {},
                    }
                ],
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.update_migrating_vm(request)


def test_update_migrating_vm_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "migrating_vm": {
                "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
            }
        }

        # get truthy value for each flattened field
        mock_args = dict(
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.update_migrating_vm(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{migrating_vm.name=projects/*/locations/*/sources/*/migratingVms/*}"
            % client.transport._host,
            args[1],
        )


def test_update_migrating_vm_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_migrating_vm(
            vmmigration.UpdateMigratingVmRequest(),
            migrating_vm=vmmigration.MigratingVm(
                compute_engine_target_defaults=vmmigration.ComputeEngineTargetDefaults(
                    vm_name="vm_name_value"
                )
            ),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


def test_update_migrating_vm_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteMigratingVmRequest,
        dict,
    ],
)
def test_delete_migrating_vm_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.delete_migrating_vm(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_delete_migrating_vm_rest_required_fields(
    request_type=vmmigration.DeleteMigratingVmRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_migrating_vm._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_migrating_vm._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "delete",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.delete_migrating_vm(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_delete_migrating_vm_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.delete_migrating_vm._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_delete_migrating_vm_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_delete_migrating_vm"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_delete_migrating_vm"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.DeleteMigratingVmRequest.pb(
            vmmigration.DeleteMigratingVmRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.DeleteMigratingVmRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.delete_migrating_vm(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_delete_migrating_vm_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.DeleteMigratingVmRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.delete_migrating_vm(request)


def test_delete_migrating_vm_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.delete_migrating_vm(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/migratingVms/*}"
            % client.transport._host,
            args[1],
        )


def test_delete_migrating_vm_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_migrating_vm(
            vmmigration.DeleteMigratingVmRequest(),
            name="name_value",
        )


def test_delete_migrating_vm_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.StartMigrationRequest,
        dict,
    ],
)
def test_start_migration_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.start_migration(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_start_migration_rest_required_fields(
    request_type=vmmigration.StartMigrationRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["migrating_vm"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).start_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["migratingVm"] = "migrating_vm_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).start_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "migratingVm" in jsonified_request
    assert jsonified_request["migratingVm"] == "migrating_vm_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.start_migration(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_start_migration_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.start_migration._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("migratingVm",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_start_migration_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_start_migration"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_start_migration"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.StartMigrationRequest.pb(
            vmmigration.StartMigrationRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.StartMigrationRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.start_migration(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_start_migration_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.StartMigrationRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.start_migration(request)


def test_start_migration_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            migrating_vm="migrating_vm_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.start_migration(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{migrating_vm=projects/*/locations/*/sources/*/migratingVms/*}:startMigration"
            % client.transport._host,
            args[1],
        )


def test_start_migration_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.start_migration(
            vmmigration.StartMigrationRequest(),
            migrating_vm="migrating_vm_value",
        )


def test_start_migration_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ResumeMigrationRequest,
        dict,
    ],
)
def test_resume_migration_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.resume_migration(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_resume_migration_rest_required_fields(
    request_type=vmmigration.ResumeMigrationRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["migrating_vm"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).resume_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["migratingVm"] = "migrating_vm_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).resume_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "migratingVm" in jsonified_request
    assert jsonified_request["migratingVm"] == "migrating_vm_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.resume_migration(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_resume_migration_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.resume_migration._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("migratingVm",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_resume_migration_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_resume_migration"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_resume_migration"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ResumeMigrationRequest.pb(
            vmmigration.ResumeMigrationRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.ResumeMigrationRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.resume_migration(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_resume_migration_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ResumeMigrationRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.resume_migration(request)


def test_resume_migration_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.PauseMigrationRequest,
        dict,
    ],
)
def test_pause_migration_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.pause_migration(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_pause_migration_rest_required_fields(
    request_type=vmmigration.PauseMigrationRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["migrating_vm"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).pause_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["migratingVm"] = "migrating_vm_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).pause_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "migratingVm" in jsonified_request
    assert jsonified_request["migratingVm"] == "migrating_vm_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.pause_migration(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_pause_migration_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.pause_migration._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("migratingVm",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_pause_migration_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_pause_migration"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_pause_migration"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.PauseMigrationRequest.pb(
            vmmigration.PauseMigrationRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.PauseMigrationRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.pause_migration(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_pause_migration_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.PauseMigrationRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.pause_migration(request)


def test_pause_migration_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.FinalizeMigrationRequest,
        dict,
    ],
)
def test_finalize_migration_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.finalize_migration(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_finalize_migration_rest_required_fields(
    request_type=vmmigration.FinalizeMigrationRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["migrating_vm"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).finalize_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["migratingVm"] = "migrating_vm_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).finalize_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "migratingVm" in jsonified_request
    assert jsonified_request["migratingVm"] == "migrating_vm_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.finalize_migration(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_finalize_migration_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.finalize_migration._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("migratingVm",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_finalize_migration_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_finalize_migration"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_finalize_migration"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.FinalizeMigrationRequest.pb(
            vmmigration.FinalizeMigrationRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.FinalizeMigrationRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.finalize_migration(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_finalize_migration_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.FinalizeMigrationRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.finalize_migration(request)


def test_finalize_migration_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "migrating_vm": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            migrating_vm="migrating_vm_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.finalize_migration(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{migrating_vm=projects/*/locations/*/sources/*/migratingVms/*}:finalizeMigration"
            % client.transport._host,
            args[1],
        )


def test_finalize_migration_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.finalize_migration(
            vmmigration.FinalizeMigrationRequest(),
            migrating_vm="migrating_vm_value",
        )


def test_finalize_migration_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateCloneJobRequest,
        dict,
    ],
)
def test_create_clone_job_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request_init["clone_job"] = {
        "compute_engine_target_details": {
            "vm_name": "vm_name_value",
            "project": "project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "end_time": {},
        "name": "name_value",
        "state": 1,
        "state_time": {},
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "steps": [
            {
                "adapting_os": {},
                "preparing_vm_disks": {},
                "instantiating_migrated_vm": {},
                "start_time": {},
                "end_time": {},
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_clone_job(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_clone_job_rest_required_fields(
    request_type=vmmigration.CreateCloneJobRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["clone_job_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "cloneJobId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_clone_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "cloneJobId" in jsonified_request
    assert jsonified_request["cloneJobId"] == request_init["clone_job_id"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["cloneJobId"] = "clone_job_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_clone_job._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "clone_job_id",
            "request_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "cloneJobId" in jsonified_request
    assert jsonified_request["cloneJobId"] == "clone_job_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_clone_job(request)

            expected_params = [
                (
                    "cloneJobId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_clone_job_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_clone_job._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "cloneJobId",
                "requestId",
            )
        )
        & set(
            (
                "parent",
                "cloneJobId",
                "cloneJob",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_clone_job_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_clone_job"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_clone_job"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateCloneJobRequest.pb(
            vmmigration.CreateCloneJobRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateCloneJobRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_clone_job(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_clone_job_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateCloneJobRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request_init["clone_job"] = {
        "compute_engine_target_details": {
            "vm_name": "vm_name_value",
            "project": "project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "end_time": {},
        "name": "name_value",
        "state": 1,
        "state_time": {},
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "steps": [
            {
                "adapting_os": {},
                "preparing_vm_disks": {},
                "instantiating_migrated_vm": {},
                "start_time": {},
                "end_time": {},
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_clone_job(request)


def test_create_clone_job_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            clone_job=vmmigration.CloneJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            clone_job_id="clone_job_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_clone_job(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*/migratingVms/*}/cloneJobs"
            % client.transport._host,
            args[1],
        )


def test_create_clone_job_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_clone_job(
            vmmigration.CreateCloneJobRequest(),
            parent="parent_value",
            clone_job=vmmigration.CloneJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            clone_job_id="clone_job_id_value",
        )


def test_create_clone_job_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CancelCloneJobRequest,
        dict,
    ],
)
def test_cancel_clone_job_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cloneJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.cancel_clone_job(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_cancel_clone_job_rest_required_fields(
    request_type=vmmigration.CancelCloneJobRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).cancel_clone_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).cancel_clone_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.cancel_clone_job(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_cancel_clone_job_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.cancel_clone_job._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_cancel_clone_job_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_cancel_clone_job"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_cancel_clone_job"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CancelCloneJobRequest.pb(
            vmmigration.CancelCloneJobRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CancelCloneJobRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.cancel_clone_job(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_cancel_clone_job_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CancelCloneJobRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cloneJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.cancel_clone_job(request)


def test_cancel_clone_job_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cloneJobs/sample5"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.cancel_clone_job(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/migratingVms/*/cloneJobs/*}:cancel"
            % client.transport._host,
            args[1],
        )


def test_cancel_clone_job_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.cancel_clone_job(
            vmmigration.CancelCloneJobRequest(),
            name="name_value",
        )


def test_cancel_clone_job_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListCloneJobsRequest,
        dict,
    ],
)
def test_list_clone_jobs_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListCloneJobsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListCloneJobsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_clone_jobs(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListCloneJobsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_clone_jobs_rest_required_fields(
    request_type=vmmigration.ListCloneJobsRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_clone_jobs._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_clone_jobs._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListCloneJobsResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListCloneJobsResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_clone_jobs(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_clone_jobs_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_clone_jobs._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_clone_jobs_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_clone_jobs"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_clone_jobs"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListCloneJobsRequest.pb(
            vmmigration.ListCloneJobsRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.ListCloneJobsResponse.to_json(
            vmmigration.ListCloneJobsResponse()
        )

        request = vmmigration.ListCloneJobsRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListCloneJobsResponse()

        client.list_clone_jobs(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_clone_jobs_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListCloneJobsRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_clone_jobs(request)


def test_list_clone_jobs_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListCloneJobsResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListCloneJobsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_clone_jobs(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*/migratingVms/*}/cloneJobs"
            % client.transport._host,
            args[1],
        )


def test_list_clone_jobs_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_clone_jobs(
            vmmigration.ListCloneJobsRequest(),
            parent="parent_value",
        )


def test_list_clone_jobs_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCloneJobsResponse(
                clone_jobs=[
                    vmmigration.CloneJob(),
                    vmmigration.CloneJob(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(vmmigration.ListCloneJobsResponse.to_json(x) for x in response)
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        pager = client.list_clone_jobs(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.CloneJob) for i in results)

        pages = list(client.list_clone_jobs(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetCloneJobRequest,
        dict,
    ],
)
def test_get_clone_job_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cloneJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.CloneJob(
            name="name_value",
            state=vmmigration.CloneJob.State.PENDING,
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            ),
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.CloneJob.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_clone_job(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.CloneJob)
    assert response.name == "name_value"
    assert response.state == vmmigration.CloneJob.State.PENDING


def test_get_clone_job_rest_required_fields(
    request_type=vmmigration.GetCloneJobRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_clone_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_clone_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.CloneJob()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.CloneJob.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_clone_job(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_clone_job_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_clone_job._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_clone_job_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_clone_job"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_clone_job"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetCloneJobRequest.pb(vmmigration.GetCloneJobRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.CloneJob.to_json(vmmigration.CloneJob())

        request = vmmigration.GetCloneJobRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.CloneJob()

        client.get_clone_job(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_clone_job_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetCloneJobRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cloneJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_clone_job(request)


def test_get_clone_job_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.CloneJob()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cloneJobs/sample5"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.CloneJob.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_clone_job(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/migratingVms/*/cloneJobs/*}"
            % client.transport._host,
            args[1],
        )


def test_get_clone_job_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_clone_job(
            vmmigration.GetCloneJobRequest(),
            name="name_value",
        )


def test_get_clone_job_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateCutoverJobRequest,
        dict,
    ],
)
def test_create_cutover_job_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request_init["cutover_job"] = {
        "compute_engine_target_details": {
            "vm_name": "vm_name_value",
            "project": "project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "end_time": {},
        "name": "name_value",
        "state": 1,
        "state_time": {},
        "progress_percent": 1733,
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "state_message": "state_message_value",
        "steps": [
            {
                "previous_replication_cycle": {
                    "name": "name_value",
                    "cycle_number": 1272,
                    "start_time": {},
                    "end_time": {},
                    "total_pause_duration": {"seconds": 751, "nanos": 543},
                    "progress_percent": 1733,
                    "steps": [
                        {
                            "initializing_replication": {},
                            "replicating": {
                                "total_bytes": 1194,
                                "replicated_bytes": 1699,
                                "last_two_minutes_average_bytes_per_second": 4370,
                                "last_thirty_minutes_average_bytes_per_second": 4700,
                            },
                            "post_processing": {},
                            "start_time": {},
                            "end_time": {},
                        }
                    ],
                    "state": 1,
                    "error": {},
                },
                "shutting_down_source_vm": {},
                "final_sync": {},
                "preparing_vm_disks": {},
                "instantiating_migrated_vm": {},
                "start_time": {},
                "end_time": {},
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_cutover_job(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_cutover_job_rest_required_fields(
    request_type=vmmigration.CreateCutoverJobRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["cutover_job_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "cutoverJobId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_cutover_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "cutoverJobId" in jsonified_request
    assert jsonified_request["cutoverJobId"] == request_init["cutover_job_id"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["cutoverJobId"] = "cutover_job_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_cutover_job._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "cutover_job_id",
            "request_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "cutoverJobId" in jsonified_request
    assert jsonified_request["cutoverJobId"] == "cutover_job_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_cutover_job(request)

            expected_params = [
                (
                    "cutoverJobId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_cutover_job_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_cutover_job._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "cutoverJobId",
                "requestId",
            )
        )
        & set(
            (
                "parent",
                "cutoverJobId",
                "cutoverJob",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_cutover_job_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_cutover_job"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_cutover_job"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateCutoverJobRequest.pb(
            vmmigration.CreateCutoverJobRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateCutoverJobRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_cutover_job(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_cutover_job_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateCutoverJobRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request_init["cutover_job"] = {
        "compute_engine_target_details": {
            "vm_name": "vm_name_value",
            "project": "project_value",
            "zone": "zone_value",
            "machine_type_series": "machine_type_series_value",
            "machine_type": "machine_type_value",
            "network_tags": ["network_tags_value1", "network_tags_value2"],
            "network_interfaces": [
                {
                    "network": "network_value",
                    "subnetwork": "subnetwork_value",
                    "internal_ip": "internal_ip_value",
                    "external_ip": "external_ip_value",
                }
            ],
            "service_account": "service_account_value",
            "disk_type": 1,
            "labels": {},
            "license_type": 1,
            "applied_license": {"type_": 1, "os_license": "os_license_value"},
            "compute_scheduling": {
                "on_host_maintenance": 1,
                "restart_type": 1,
                "node_affinities": [
                    {
                        "key": "key_value",
                        "operator": 1,
                        "values": ["values_value1", "values_value2"],
                    }
                ],
                "min_node_cpus": 1379,
            },
            "secure_boot": True,
            "boot_option": 1,
            "metadata": {},
            "additional_licenses": [
                "additional_licenses_value1",
                "additional_licenses_value2",
            ],
            "hostname": "hostname_value",
        },
        "create_time": {"seconds": 751, "nanos": 543},
        "end_time": {},
        "name": "name_value",
        "state": 1,
        "state_time": {},
        "progress_percent": 1733,
        "error": {
            "code": 411,
            "message": "message_value",
            "details": [
                {
                    "type_url": "type.googleapis.com/google.protobuf.Duration",
                    "value": b"\x08\x0c\x10\xdb\x07",
                }
            ],
        },
        "state_message": "state_message_value",
        "steps": [
            {
                "previous_replication_cycle": {
                    "name": "name_value",
                    "cycle_number": 1272,
                    "start_time": {},
                    "end_time": {},
                    "total_pause_duration": {"seconds": 751, "nanos": 543},
                    "progress_percent": 1733,
                    "steps": [
                        {
                            "initializing_replication": {},
                            "replicating": {
                                "total_bytes": 1194,
                                "replicated_bytes": 1699,
                                "last_two_minutes_average_bytes_per_second": 4370,
                                "last_thirty_minutes_average_bytes_per_second": 4700,
                            },
                            "post_processing": {},
                            "start_time": {},
                            "end_time": {},
                        }
                    ],
                    "state": 1,
                    "error": {},
                },
                "shutting_down_source_vm": {},
                "final_sync": {},
                "preparing_vm_disks": {},
                "instantiating_migrated_vm": {},
                "start_time": {},
                "end_time": {},
            }
        ],
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_cutover_job(request)


def test_create_cutover_job_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            cutover_job=vmmigration.CutoverJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            cutover_job_id="cutover_job_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_cutover_job(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*/migratingVms/*}/cutoverJobs"
            % client.transport._host,
            args[1],
        )


def test_create_cutover_job_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_cutover_job(
            vmmigration.CreateCutoverJobRequest(),
            parent="parent_value",
            cutover_job=vmmigration.CutoverJob(
                compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                    vm_name="vm_name_value"
                )
            ),
            cutover_job_id="cutover_job_id_value",
        )


def test_create_cutover_job_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CancelCutoverJobRequest,
        dict,
    ],
)
def test_cancel_cutover_job_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cutoverJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.cancel_cutover_job(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_cancel_cutover_job_rest_required_fields(
    request_type=vmmigration.CancelCutoverJobRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).cancel_cutover_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).cancel_cutover_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.cancel_cutover_job(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_cancel_cutover_job_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.cancel_cutover_job._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_cancel_cutover_job_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_cancel_cutover_job"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_cancel_cutover_job"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CancelCutoverJobRequest.pb(
            vmmigration.CancelCutoverJobRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CancelCutoverJobRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.cancel_cutover_job(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_cancel_cutover_job_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CancelCutoverJobRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cutoverJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.cancel_cutover_job(request)


def test_cancel_cutover_job_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cutoverJobs/sample5"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.cancel_cutover_job(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/migratingVms/*/cutoverJobs/*}:cancel"
            % client.transport._host,
            args[1],
        )


def test_cancel_cutover_job_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.cancel_cutover_job(
            vmmigration.CancelCutoverJobRequest(),
            name="name_value",
        )


def test_cancel_cutover_job_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListCutoverJobsRequest,
        dict,
    ],
)
def test_list_cutover_jobs_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListCutoverJobsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListCutoverJobsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_cutover_jobs(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListCutoverJobsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_cutover_jobs_rest_required_fields(
    request_type=vmmigration.ListCutoverJobsRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_cutover_jobs._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_cutover_jobs._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListCutoverJobsResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListCutoverJobsResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_cutover_jobs(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_cutover_jobs_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_cutover_jobs._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_cutover_jobs_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_cutover_jobs"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_cutover_jobs"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListCutoverJobsRequest.pb(
            vmmigration.ListCutoverJobsRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.ListCutoverJobsResponse.to_json(
            vmmigration.ListCutoverJobsResponse()
        )

        request = vmmigration.ListCutoverJobsRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListCutoverJobsResponse()

        client.list_cutover_jobs(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_cutover_jobs_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListCutoverJobsRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_cutover_jobs(request)


def test_list_cutover_jobs_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListCutoverJobsResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListCutoverJobsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_cutover_jobs(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*/sources/*/migratingVms/*}/cutoverJobs"
            % client.transport._host,
            args[1],
        )


def test_list_cutover_jobs_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_cutover_jobs(
            vmmigration.ListCutoverJobsRequest(),
            parent="parent_value",
        )


def test_list_cutover_jobs_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[],
                next_page_token="def",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListCutoverJobsResponse(
                cutover_jobs=[
                    vmmigration.CutoverJob(),
                    vmmigration.CutoverJob(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(
            vmmigration.ListCutoverJobsResponse.to_json(x) for x in response
        )
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {
            "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
        }

        pager = client.list_cutover_jobs(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.CutoverJob) for i in results)

        pages = list(client.list_cutover_jobs(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetCutoverJobRequest,
        dict,
    ],
)
def test_get_cutover_job_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cutoverJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.CutoverJob(
            name="name_value",
            state=vmmigration.CutoverJob.State.PENDING,
            progress_percent=1733,
            state_message="state_message_value",
            compute_engine_target_details=vmmigration.ComputeEngineTargetDetails(
                vm_name="vm_name_value"
            ),
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.CutoverJob.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_cutover_job(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.CutoverJob)
    assert response.name == "name_value"
    assert response.state == vmmigration.CutoverJob.State.PENDING
    assert response.progress_percent == 1733
    assert response.state_message == "state_message_value"


def test_get_cutover_job_rest_required_fields(
    request_type=vmmigration.GetCutoverJobRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_cutover_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_cutover_job._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.CutoverJob()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.CutoverJob.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_cutover_job(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_cutover_job_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_cutover_job._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_cutover_job_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_cutover_job"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_cutover_job"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetCutoverJobRequest.pb(
            vmmigration.GetCutoverJobRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.CutoverJob.to_json(
            vmmigration.CutoverJob()
        )

        request = vmmigration.GetCutoverJobRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.CutoverJob()

        client.get_cutover_job(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_cutover_job_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetCutoverJobRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cutoverJobs/sample5"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_cutover_job(request)


def test_get_cutover_job_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.CutoverJob()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4/cutoverJobs/sample5"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.CutoverJob.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_cutover_job(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/sources/*/migratingVms/*/cutoverJobs/*}"
            % client.transport._host,
            args[1],
        )


def test_get_cutover_job_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_cutover_job(
            vmmigration.GetCutoverJobRequest(),
            name="name_value",
        )


def test_get_cutover_job_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListGroupsRequest,
        dict,
    ],
)
def test_list_groups_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListGroupsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListGroupsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_groups(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListGroupsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_groups_rest_required_fields(request_type=vmmigration.ListGroupsRequest):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_groups._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_groups._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListGroupsResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListGroupsResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_groups(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_groups_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_groups._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_groups_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_groups"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_groups"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListGroupsRequest.pb(vmmigration.ListGroupsRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.ListGroupsResponse.to_json(
            vmmigration.ListGroupsResponse()
        )

        request = vmmigration.ListGroupsRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListGroupsResponse()

        client.list_groups(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_groups_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListGroupsRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_groups(request)


def test_list_groups_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListGroupsResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {"parent": "projects/sample1/locations/sample2"}

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListGroupsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_groups(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*}/groups" % client.transport._host,
            args[1],
        )


def test_list_groups_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_groups(
            vmmigration.ListGroupsRequest(),
            parent="parent_value",
        )


def test_list_groups_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListGroupsResponse(
                groups=[],
                next_page_token="def",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListGroupsResponse(
                groups=[
                    vmmigration.Group(),
                    vmmigration.Group(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(vmmigration.ListGroupsResponse.to_json(x) for x in response)
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {"parent": "projects/sample1/locations/sample2"}

        pager = client.list_groups(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.Group) for i in results)

        pages = list(client.list_groups(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetGroupRequest,
        dict,
    ],
)
def test_get_group_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.Group(
            name="name_value",
            description="description_value",
            display_name="display_name_value",
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.Group.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_group(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.Group)
    assert response.name == "name_value"
    assert response.description == "description_value"
    assert response.display_name == "display_name_value"


def test_get_group_rest_required_fields(request_type=vmmigration.GetGroupRequest):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_group._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_group._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.Group()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.Group.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_group(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_group_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_group._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_group_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_group"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_group"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetGroupRequest.pb(vmmigration.GetGroupRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.Group.to_json(vmmigration.Group())

        request = vmmigration.GetGroupRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.Group()

        client.get_group(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_group_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetGroupRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_group(request)


def test_get_group_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.Group()

        # get arguments that satisfy an http rule for this method
        sample_request = {"name": "projects/sample1/locations/sample2/groups/sample3"}

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.Group.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_group(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/groups/*}" % client.transport._host,
            args[1],
        )


def test_get_group_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_group(
            vmmigration.GetGroupRequest(),
            name="name_value",
        )


def test_get_group_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateGroupRequest,
        dict,
    ],
)
def test_create_group_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request_init["group"] = {
        "name": "name_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "description": "description_value",
        "display_name": "display_name_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_group(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_group_rest_required_fields(request_type=vmmigration.CreateGroupRequest):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["group_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "groupId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_group._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "groupId" in jsonified_request
    assert jsonified_request["groupId"] == request_init["group_id"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["groupId"] = "group_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_group._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "group_id",
            "request_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "groupId" in jsonified_request
    assert jsonified_request["groupId"] == "group_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_group(request)

            expected_params = [
                (
                    "groupId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_group_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_group._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "groupId",
                "requestId",
            )
        )
        & set(
            (
                "parent",
                "groupId",
                "group",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_group_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_group"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_group"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateGroupRequest.pb(vmmigration.CreateGroupRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateGroupRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_group(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_group_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateGroupRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request_init["group"] = {
        "name": "name_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "description": "description_value",
        "display_name": "display_name_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_group(request)


def test_create_group_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {"parent": "projects/sample1/locations/sample2"}

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            group=vmmigration.Group(name="name_value"),
            group_id="group_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_group(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*}/groups" % client.transport._host,
            args[1],
        )


def test_create_group_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_group(
            vmmigration.CreateGroupRequest(),
            parent="parent_value",
            group=vmmigration.Group(name="name_value"),
            group_id="group_id_value",
        )


def test_create_group_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateGroupRequest,
        dict,
    ],
)
def test_update_group_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "group": {"name": "projects/sample1/locations/sample2/groups/sample3"}
    }
    request_init["group"] = {
        "name": "projects/sample1/locations/sample2/groups/sample3",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "description": "description_value",
        "display_name": "display_name_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.update_group(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_update_group_rest_required_fields(request_type=vmmigration.UpdateGroupRequest):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_group._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_group._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "request_id",
            "update_mask",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "patch",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.update_group(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_update_group_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.update_group._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "requestId",
                "updateMask",
            )
        )
        & set(("group",))
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_update_group_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_update_group"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_update_group"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.UpdateGroupRequest.pb(vmmigration.UpdateGroupRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.UpdateGroupRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.update_group(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_update_group_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.UpdateGroupRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "group": {"name": "projects/sample1/locations/sample2/groups/sample3"}
    }
    request_init["group"] = {
        "name": "projects/sample1/locations/sample2/groups/sample3",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
        "description": "description_value",
        "display_name": "display_name_value",
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.update_group(request)


def test_update_group_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "group": {"name": "projects/sample1/locations/sample2/groups/sample3"}
        }

        # get truthy value for each flattened field
        mock_args = dict(
            group=vmmigration.Group(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.update_group(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{group.name=projects/*/locations/*/groups/*}"
            % client.transport._host,
            args[1],
        )


def test_update_group_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_group(
            vmmigration.UpdateGroupRequest(),
            group=vmmigration.Group(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


def test_update_group_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteGroupRequest,
        dict,
    ],
)
def test_delete_group_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.delete_group(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_delete_group_rest_required_fields(request_type=vmmigration.DeleteGroupRequest):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_group._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_group._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("request_id",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "delete",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.delete_group(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_delete_group_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.delete_group._get_unset_required_fields({})
    assert set(unset_fields) == (set(("requestId",)) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_delete_group_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_delete_group"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_delete_group"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.DeleteGroupRequest.pb(vmmigration.DeleteGroupRequest())
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.DeleteGroupRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.delete_group(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_delete_group_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.DeleteGroupRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.delete_group(request)


def test_delete_group_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {"name": "projects/sample1/locations/sample2/groups/sample3"}

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.delete_group(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/groups/*}" % client.transport._host,
            args[1],
        )


def test_delete_group_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_group(
            vmmigration.DeleteGroupRequest(),
            name="name_value",
        )


def test_delete_group_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.AddGroupMigrationRequest,
        dict,
    ],
)
def test_add_group_migration_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"group": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.add_group_migration(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_add_group_migration_rest_required_fields(
    request_type=vmmigration.AddGroupMigrationRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["group"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).add_group_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["group"] = "group_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).add_group_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "group" in jsonified_request
    assert jsonified_request["group"] == "group_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.add_group_migration(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_add_group_migration_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.add_group_migration._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("group",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_add_group_migration_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_add_group_migration"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_add_group_migration"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.AddGroupMigrationRequest.pb(
            vmmigration.AddGroupMigrationRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.AddGroupMigrationRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.add_group_migration(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_add_group_migration_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.AddGroupMigrationRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"group": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.add_group_migration(request)


def test_add_group_migration_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {"group": "projects/sample1/locations/sample2/groups/sample3"}

        # get truthy value for each flattened field
        mock_args = dict(
            group="group_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.add_group_migration(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{group=projects/*/locations/*/groups/*}:addGroupMigration"
            % client.transport._host,
            args[1],
        )


def test_add_group_migration_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.add_group_migration(
            vmmigration.AddGroupMigrationRequest(),
            group="group_value",
        )


def test_add_group_migration_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.RemoveGroupMigrationRequest,
        dict,
    ],
)
def test_remove_group_migration_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"group": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.remove_group_migration(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_remove_group_migration_rest_required_fields(
    request_type=vmmigration.RemoveGroupMigrationRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["group"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).remove_group_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["group"] = "group_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).remove_group_migration._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "group" in jsonified_request
    assert jsonified_request["group"] == "group_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.remove_group_migration(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_remove_group_migration_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.remove_group_migration._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("group",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_remove_group_migration_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_remove_group_migration"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_remove_group_migration"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.RemoveGroupMigrationRequest.pb(
            vmmigration.RemoveGroupMigrationRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.RemoveGroupMigrationRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.remove_group_migration(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_remove_group_migration_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.RemoveGroupMigrationRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"group": "projects/sample1/locations/sample2/groups/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.remove_group_migration(request)


def test_remove_group_migration_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {"group": "projects/sample1/locations/sample2/groups/sample3"}

        # get truthy value for each flattened field
        mock_args = dict(
            group="group_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.remove_group_migration(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{group=projects/*/locations/*/groups/*}:removeGroupMigration"
            % client.transport._host,
            args[1],
        )


def test_remove_group_migration_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.remove_group_migration(
            vmmigration.RemoveGroupMigrationRequest(),
            group="group_value",
        )


def test_remove_group_migration_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListTargetProjectsRequest,
        dict,
    ],
)
def test_list_target_projects_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListTargetProjectsResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListTargetProjectsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_target_projects(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListTargetProjectsPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_target_projects_rest_required_fields(
    request_type=vmmigration.ListTargetProjectsRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_target_projects._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_target_projects._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListTargetProjectsResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListTargetProjectsResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_target_projects(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_target_projects_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.list_target_projects._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "filter",
                "orderBy",
                "pageSize",
                "pageToken",
            )
        )
        & set(
            (
                "parent",
                "pageToken",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_list_target_projects_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_list_target_projects"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_list_target_projects"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.ListTargetProjectsRequest.pb(
            vmmigration.ListTargetProjectsRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.ListTargetProjectsResponse.to_json(
            vmmigration.ListTargetProjectsResponse()
        )

        request = vmmigration.ListTargetProjectsRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.ListTargetProjectsResponse()

        client.list_target_projects(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_list_target_projects_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.ListTargetProjectsRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.list_target_projects(request)


def test_list_target_projects_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListTargetProjectsResponse()

        # get arguments that satisfy an http rule for this method
        sample_request = {"parent": "projects/sample1/locations/sample2"}

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListTargetProjectsResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.list_target_projects(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*}/targetProjects"
            % client.transport._host,
            args[1],
        )


def test_list_target_projects_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.list_target_projects(
            vmmigration.ListTargetProjectsRequest(),
            parent="parent_value",
        )


def test_list_target_projects_rest_pager(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # TODO(kbandes): remove this mock unless there's a good reason for it.
        # with mock.patch.object(path_template, 'transcode') as transcode:
        # Set the response as a series of pages
        response = (
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
                next_page_token="abc",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[],
                next_page_token="def",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                ],
                next_page_token="ghi",
            ),
            vmmigration.ListTargetProjectsResponse(
                target_projects=[
                    vmmigration.TargetProject(),
                    vmmigration.TargetProject(),
                ],
            ),
        )
        # Two responses for two calls
        response = response + response

        # Wrap the values into proper Response objs
        response = tuple(
            vmmigration.ListTargetProjectsResponse.to_json(x) for x in response
        )
        return_values = tuple(Response() for i in response)
        for return_val, response_val in zip(return_values, response):
            return_val._content = response_val.encode("UTF-8")
            return_val.status_code = 200
        req.side_effect = return_values

        sample_request = {"parent": "projects/sample1/locations/sample2"}

        pager = client.list_target_projects(request=sample_request)

        results = list(pager)
        assert len(results) == 6
        assert all(isinstance(i, vmmigration.TargetProject) for i in results)

        pages = list(client.list_target_projects(request=sample_request).pages)
        for page_, token in zip(pages, ["abc", "def", "ghi", ""]):
            assert page_.raw_page.next_page_token == token


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.GetTargetProjectRequest,
        dict,
    ],
)
def test_get_target_project_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/targetProjects/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.TargetProject(
            name="name_value",
            project="project_value",
            description="description_value",
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.TargetProject.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.get_target_project(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, vmmigration.TargetProject)
    assert response.name == "name_value"
    assert response.project == "project_value"
    assert response.description == "description_value"


def test_get_target_project_rest_required_fields(
    request_type=vmmigration.GetTargetProjectRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_target_project._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).get_target_project._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.TargetProject()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.TargetProject.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.get_target_project(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_get_target_project_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.get_target_project._get_unset_required_fields({})
    assert set(unset_fields) == (set(()) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_get_target_project_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_get_target_project"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_get_target_project"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.GetTargetProjectRequest.pb(
            vmmigration.GetTargetProjectRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = vmmigration.TargetProject.to_json(
            vmmigration.TargetProject()
        )

        request = vmmigration.GetTargetProjectRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = vmmigration.TargetProject()

        client.get_target_project(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_get_target_project_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.GetTargetProjectRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/targetProjects/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.get_target_project(request)


def test_get_target_project_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.TargetProject()

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/targetProjects/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.TargetProject.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.get_target_project(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/targetProjects/*}"
            % client.transport._host,
            args[1],
        )


def test_get_target_project_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.get_target_project(
            vmmigration.GetTargetProjectRequest(),
            name="name_value",
        )


def test_get_target_project_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.CreateTargetProjectRequest,
        dict,
    ],
)
def test_create_target_project_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request_init["target_project"] = {
        "name": "name_value",
        "project": "project_value",
        "description": "description_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.create_target_project(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_create_target_project_rest_required_fields(
    request_type=vmmigration.CreateTargetProjectRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["target_project_id"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "targetProjectId" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_target_project._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "targetProjectId" in jsonified_request
    assert jsonified_request["targetProjectId"] == request_init["target_project_id"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["targetProjectId"] = "target_project_id_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).create_target_project._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "request_id",
            "target_project_id",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "targetProjectId" in jsonified_request
    assert jsonified_request["targetProjectId"] == "target_project_id_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "post",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.create_target_project(request)

            expected_params = [
                (
                    "targetProjectId",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_create_target_project_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.create_target_project._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "requestId",
                "targetProjectId",
            )
        )
        & set(
            (
                "parent",
                "targetProjectId",
                "targetProject",
            )
        )
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_create_target_project_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_create_target_project"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_create_target_project"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.CreateTargetProjectRequest.pb(
            vmmigration.CreateTargetProjectRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.CreateTargetProjectRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.create_target_project(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_create_target_project_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.CreateTargetProjectRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"parent": "projects/sample1/locations/sample2"}
    request_init["target_project"] = {
        "name": "name_value",
        "project": "project_value",
        "description": "description_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.create_target_project(request)


def test_create_target_project_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {"parent": "projects/sample1/locations/sample2"}

        # get truthy value for each flattened field
        mock_args = dict(
            parent="parent_value",
            target_project=vmmigration.TargetProject(name="name_value"),
            target_project_id="target_project_id_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.create_target_project(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{parent=projects/*/locations/*}/targetProjects"
            % client.transport._host,
            args[1],
        )


def test_create_target_project_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.create_target_project(
            vmmigration.CreateTargetProjectRequest(),
            parent="parent_value",
            target_project=vmmigration.TargetProject(name="name_value"),
            target_project_id="target_project_id_value",
        )


def test_create_target_project_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.UpdateTargetProjectRequest,
        dict,
    ],
)
def test_update_target_project_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "target_project": {
            "name": "projects/sample1/locations/sample2/targetProjects/sample3"
        }
    }
    request_init["target_project"] = {
        "name": "projects/sample1/locations/sample2/targetProjects/sample3",
        "project": "project_value",
        "description": "description_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.update_target_project(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_update_target_project_rest_required_fields(
    request_type=vmmigration.UpdateTargetProjectRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_target_project._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).update_target_project._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "request_id",
            "update_mask",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "patch",
                "query_params": pb_request,
            }
            transcode_result["body"] = pb_request
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.update_target_project(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_update_target_project_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.update_target_project._get_unset_required_fields({})
    assert set(unset_fields) == (
        set(
            (
                "requestId",
                "updateMask",
            )
        )
        & set(("targetProject",))
    )


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_update_target_project_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_update_target_project"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_update_target_project"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.UpdateTargetProjectRequest.pb(
            vmmigration.UpdateTargetProjectRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.UpdateTargetProjectRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.update_target_project(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_update_target_project_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.UpdateTargetProjectRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {
        "target_project": {
            "name": "projects/sample1/locations/sample2/targetProjects/sample3"
        }
    }
    request_init["target_project"] = {
        "name": "projects/sample1/locations/sample2/targetProjects/sample3",
        "project": "project_value",
        "description": "description_value",
        "create_time": {"seconds": 751, "nanos": 543},
        "update_time": {},
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.update_target_project(request)


def test_update_target_project_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "target_project": {
                "name": "projects/sample1/locations/sample2/targetProjects/sample3"
            }
        }

        # get truthy value for each flattened field
        mock_args = dict(
            target_project=vmmigration.TargetProject(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.update_target_project(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{target_project.name=projects/*/locations/*/targetProjects/*}"
            % client.transport._host,
            args[1],
        )


def test_update_target_project_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.update_target_project(
            vmmigration.UpdateTargetProjectRequest(),
            target_project=vmmigration.TargetProject(name="name_value"),
            update_mask=field_mask_pb2.FieldMask(paths=["paths_value"]),
        )


def test_update_target_project_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.DeleteTargetProjectRequest,
        dict,
    ],
)
def test_delete_target_project_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/targetProjects/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.delete_target_project(request)

    # Establish that the response is the type that we expect.
    assert response.operation.name == "operations/spam"


def test_delete_target_project_rest_required_fields(
    request_type=vmmigration.DeleteTargetProjectRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["name"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_target_project._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present

    jsonified_request["name"] = "name_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).delete_target_project._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(("request_id",))
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "name" in jsonified_request
    assert jsonified_request["name"] == "name_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = operations_pb2.Operation(name="operations/spam")
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "delete",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200
            json_return_value = json_format.MessageToJson(return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.delete_target_project(request)

            expected_params = [("$alt", "json;enum-encoding=int")]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_delete_target_project_rest_unset_required_fields():
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials
    )

    unset_fields = transport.delete_target_project._get_unset_required_fields({})
    assert set(unset_fields) == (set(("requestId",)) & set(("name",)))


@pytest.mark.parametrize("null_interceptor", [True, False])
def test_delete_target_project_rest_interceptors(null_interceptor):
    transport = transports.VmMigrationRestTransport(
        credentials=ga_credentials.AnonymousCredentials(),
        interceptor=None
        if null_interceptor
        else transports.VmMigrationRestInterceptor(),
    )
    client = VmMigrationClient(transport=transport)
    with mock.patch.object(
        type(client.transport._session), "request"
    ) as req, mock.patch.object(
        path_template, "transcode"
    ) as transcode, mock.patch.object(
        operation.Operation, "_set_result_from_operation"
    ), mock.patch.object(
        transports.VmMigrationRestInterceptor, "post_delete_target_project"
    ) as post, mock.patch.object(
        transports.VmMigrationRestInterceptor, "pre_delete_target_project"
    ) as pre:
        pre.assert_not_called()
        post.assert_not_called()
        pb_message = vmmigration.DeleteTargetProjectRequest.pb(
            vmmigration.DeleteTargetProjectRequest()
        )
        transcode.return_value = {
            "method": "post",
            "uri": "my_uri",
            "body": pb_message,
            "query_params": pb_message,
        }

        req.return_value = Response()
        req.return_value.status_code = 200
        req.return_value.request = PreparedRequest()
        req.return_value._content = json_format.MessageToJson(
            operations_pb2.Operation()
        )

        request = vmmigration.DeleteTargetProjectRequest()
        metadata = [
            ("key", "val"),
            ("cephalopod", "squid"),
        ]
        pre.return_value = request, metadata
        post.return_value = operations_pb2.Operation()

        client.delete_target_project(
            request,
            metadata=[
                ("key", "val"),
                ("cephalopod", "squid"),
            ],
        )

        pre.assert_called_once()
        post.assert_called_once()


def test_delete_target_project_rest_bad_request(
    transport: str = "rest", request_type=vmmigration.DeleteTargetProjectRequest
):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # send a request that will satisfy transcoding
    request_init = {"name": "projects/sample1/locations/sample2/targetProjects/sample3"}
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a BadRequest error.
    with mock.patch.object(Session, "request") as req, pytest.raises(
        core_exceptions.BadRequest
    ):
        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 400
        response_value.request = Request()
        req.return_value = response_value
        client.delete_target_project(request)


def test_delete_target_project_rest_flattened():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = operations_pb2.Operation(name="operations/spam")

        # get arguments that satisfy an http rule for this method
        sample_request = {
            "name": "projects/sample1/locations/sample2/targetProjects/sample3"
        }

        # get truthy value for each flattened field
        mock_args = dict(
            name="name_value",
        )
        mock_args.update(sample_request)

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        json_return_value = json_format.MessageToJson(return_value)
        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value

        client.delete_target_project(**mock_args)

        # Establish that the underlying call was made with the expected
        # request object values.
        assert len(req.mock_calls) == 1
        _, args, _ = req.mock_calls[0]
        assert path_template.validate(
            "%s/v1/{name=projects/*/locations/*/targetProjects/*}"
            % client.transport._host,
            args[1],
        )


def test_delete_target_project_rest_flattened_error(transport: str = "rest"):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport=transport,
    )

    # Attempting to call a method with both a request object and flattened
    # fields is an error.
    with pytest.raises(ValueError):
        client.delete_target_project(
            vmmigration.DeleteTargetProjectRequest(),
            name="name_value",
        )


def test_delete_target_project_rest_error():
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(), transport="rest"
    )


@pytest.mark.parametrize(
    "request_type",
    [
        vmmigration.ListReplicationCyclesRequest,
        dict,
    ],
)
def test_list_replication_cycles_rest(request_type):
    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )

    # send a request that will satisfy transcoding
    request_init = {
        "parent": "projects/sample1/locations/sample2/sources/sample3/migratingVms/sample4"
    }
    request = request_type(**request_init)

    # Mock the http request call within the method and fake a response.
    with mock.patch.object(type(client.transport._session), "request") as req:
        # Designate an appropriate value for the returned response.
        return_value = vmmigration.ListReplicationCyclesResponse(
            next_page_token="next_page_token_value",
            unreachable=["unreachable_value"],
        )

        # Wrap the value into a proper Response obj
        response_value = Response()
        response_value.status_code = 200
        pb_return_value = vmmigration.ListReplicationCyclesResponse.pb(return_value)
        json_return_value = json_format.MessageToJson(pb_return_value)

        response_value._content = json_return_value.encode("UTF-8")
        req.return_value = response_value
        response = client.list_replication_cycles(request)

    # Establish that the response is the type that we expect.
    assert isinstance(response, pagers.ListReplicationCyclesPager)
    assert response.next_page_token == "next_page_token_value"
    assert response.unreachable == ["unreachable_value"]


def test_list_replication_cycles_rest_required_fields(
    request_type=vmmigration.ListReplicationCyclesRequest,
):
    transport_class = transports.VmMigrationRestTransport

    request_init = {}
    request_init["parent"] = ""
    request_init["page_token"] = ""
    request = request_type(**request_init)
    pb_request = request_type.pb(request)
    jsonified_request = json.loads(
        json_format.MessageToJson(
            pb_request,
            including_default_value_fields=False,
            use_integers_for_enums=False,
        )
    )

    # verify fields with default values are dropped
    assert "pageToken" not in jsonified_request

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_replication_cycles._get_unset_required_fields(jsonified_request)
    jsonified_request.update(unset_fields)

    # verify required fields with default values are now present
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == request_init["page_token"]

    jsonified_request["parent"] = "parent_value"
    jsonified_request["pageToken"] = "page_token_value"

    unset_fields = transport_class(
        credentials=ga_credentials.AnonymousCredentials()
    ).list_replication_cycles._get_unset_required_fields(jsonified_request)
    # Check that path parameters and body parameters are not mixing in.
    assert not set(unset_fields) - set(
        (
            "filter",
            "order_by",
            "page_size",
            "page_token",
        )
    )
    jsonified_request.update(unset_fields)

    # verify required fields with non-default values are left alone
    assert "parent" in jsonified_request
    assert jsonified_request["parent"] == "parent_value"
    assert "pageToken" in jsonified_request
    assert jsonified_request["pageToken"] == "page_token_value"

    client = VmMigrationClient(
        credentials=ga_credentials.AnonymousCredentials(),
        transport="rest",
    )
    request = request_type(**request_init)

    # Designate an appropriate value for the returned response.
    return_value = vmmigration.ListReplicationCyclesResponse()
    # Mock the http request call within the method and fake a response.
    with mock.patch.object(Session, "request") as req:
        # We need to mock transcode() because providing default values
        # for required fields will fail the real version if the http_options
        # expect actual values for those fields.
        with mock.patch.object(path_template, "transcode") as transcode:
            # A uri without fields and an empty body will force all the
            # request fields to show up in the query_params.
            pb_request = request_type.pb(request)
            transcode_result = {
                "uri": "v1/sample_method",
                "method": "get",
                "query_params": pb_request,
            }
            transcode.return_value = transcode_result

            response_value = Response()
            response_value.status_code = 200

            pb_return_value = vmmigration.ListReplicationCyclesResponse.pb(return_value)
            json_return_value = json_format.MessageToJson(pb_return_value)

            response_value._content = json_return_value.encode("UTF-8")
            req.return_value = response_value

            response = client.list_replication_cycles(request)

            expected_params = [
                (
                    "pageToken",
                    "",
                ),
                ("$alt", "json;enum-encoding=int"),
            ]
            actual_params = req.call_args.kwargs["params"]
            assert expected_params == actual_params


def test_list_repli