# Novra S400 Receiver

The Novra S400 is a standalone receiver, which receives a satellite signal and
outputs IP packets to one or multiple hosts listening to it in the local
network. Hence, you will need to configure both the S400 and the host(s).

<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-refresh-toc -->
**Table of Contents**

- [Novra S400](#novra-s400)
    - [Connections](#connections)
    - [Network Connection](#network-connection)
    - [Software Requirements](#software-requirements)
    - [Receiver and Host Configuration](#receiver-and-host-configuration)
    - [Monitoring](#monitoring)
    - [Next Steps](#next-steps)
    - [Further Information](#further-information)
        - [Dual-satellite Setup](#dual-satellite-setup)
        - [S400 configuration via the web UI](#s400-configuration-via-the-web-ui)

<!-- markdown-toc end -->

## Connections

The Novra S400 can be connected as follows:

![Novra S400 receiver connections](img/standalone_connections.png?raw=true
"Novra S400 receiver connections")

- Connect the LNB directly to interface RF1 of the S400 using a coaxial cable
  (an RG6 cable is recommended).
- Connect the S400's LAN1 interface to your computer or network.

## Network Connection

Next, make sure the S400 receiver is reachable by the host.

First, configure your host's network interface to the same subnet as the
S400. By default, the S400 is configured with IP address `192.168.1.2` on
interface LAN1 and `192.168.2.2` on LAN2. Hence, if you connect to LAN1, make
sure your host's network interface has IP address `192.168.1.x`, where "x" could
be any number higher than 2. For example, you could configure your host's
network interface with IP address 192.168.1.3.

After that, open the browser and access `192.168.1.2` (or `192.168.2.2` if
connected to LAN 2). The web management console should open up successfully.

## Software Requirements

Next, install all software pre-requisites on your host. Run:

```
blocksat-cli deps install
```

> Note: this command supports the `apt`, `dnf` and `yum` package managers.

## Receiver and Host Configuration

Now, configure the S400 receiver and the host by running:

```
sudo blocksat-cli standalone cfg
```

This command configures the signal parameters on the S400 receiver and network
settings on the host. If you would like to review the changes that will be made
to the host before applying them, first run the command as a non-root user:

```
blocksat-cli standalone cfg
```

Also, if you would like to apply the receiver configurations manually, refer to
the instructions for [configuration via the web
UI](#s400-configuration-via-the-web-ui).

> Note: the above commands assume the S400 has IP address `192.168.1.2` (the
> default address). You can specify another address on all `blocksat-cli
> standalone` commands by running with option `--addr [address]`.

## Monitoring

Finally, you can monitor your receiver by running:

```
blocksat-cli standalone monitor
```

## Next Steps

At this point, if your dish is already correctly pointed, you should be able to
start receiving data on Bitcoin Satellite. Please follow the [instructions for
Bitcoin Satellite configuration](bitcoin.md). If your antenna is not aligned
yet, please follow the [antenna alignment guide](antenna-pointing.md).

## Further Information

### Dual-satellite Setup

On a dual-satellite setup, you need to configure the two RF interfaces of the
S400. After configuring the first interface as [instructed
earlier](#receiver-and-host-configuration), configure the second by running:

```
sudo blocksat-cli --cfg rx2 standalone --demod 2 cfg --rx-only
```

Refer to further information on the [dual-satellite setup](dual-satellite.md)
guide.

### S400 configuration via the web UI

1. Open the browser and access the IP address of the S400. By default, the
   address is `192.168.1.2` if connected to LAN 1 or `192.168.2.2` if connected
   to LAN 2.

2. Log in as admin on the top right of the page.
- Default password: "password"

3. Check the signal parameters that apply to your setup. Run the following
   command and use the results in the next step.

```
blocksat-cli cfg show
```

4. Go to `Interfaces > RF1` and configure as follows:

- DVB Mode: "DVB-S2"

Next, configure the LNB parameters at the bottom of the page:

- LNB Power On: Enable.
- L.O. Frequency: your LNB's local oscillator (LO) frequency in MHz.
- Polarization: the signal polarization (horizontal or vertical).
- Band (Tone): "Low/Off" by default. Set to "High/On" only when using a
  Universal LNB and receiving in [Ku High Band](frequency.md) (when receiving
  from Galaxy 18 or Eutelsat 113).
- Long Line Compensation: Disabled.

After that, configure the DVB Signal Parameters:

- Carrier Freq.: frequency in MHz of the [satellite covering your
  location](frequency.md).
- LBand: leave it with the auto-filled value.<sup>*</sup>
- Symbol Rate: 1.0 MBaud.
- MODCOD: AUTO.
- Gold Code: 0.
- Input Stream ID: 0.

> <sup>*</sup> The L-band frequency is automatically defined once you inform
> both the **L.O. Frequency** and the **Carrier Freq**.

Then, click **Apply**.

5. Verify that the S400 is locked.

- Check the "RF 1 Lock" indicator at the top of the page or the status LED in
  the S400's front panel. It should be green (locked) if your antenna is already
  pointed correctly. If not, you can work on the antenna pointing afterward.

6. Go to Services > RF1:

Scroll to "Manage MPE/ULE PIDs":

- Enter 32 on "New PID" and click "Add".
- Apply.

** Optional configurations:

- If you prefer to use another IP address on LAN1 or LAN2, go to
  Interfaces > Data (LAN1) or Interfaces > M&C (LAN2) and configure
  the IP addresses. Note LAN 1 is the interface that will deliver the
  data packets received over satellite, whereas LAN2 is optional and
  exclusively for management.
- If configuring the second RF interface on the S400 for a [dual-satellite
  setup](dual-satellite.md), on *step 2*, go to `Interfaces > RF2` instead of
  `RF1`. Correspondingly, on step 3, check the "RF 2 Lock" indicator, and on
  step 4, go to `Services > RF2`.

---

Prev: [Receiver Setup](receiver.md) - Next: [Bitcoin Satellite](bitcoin.md) or [Antenna Pointing](antenna-pointing.md)
