/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.Arena;
import org.capnproto.BuilderArena;
import org.capnproto.SegmentReader;

public final class SegmentBuilder
extends SegmentReader {
    public static final int FAILED_ALLOCATION = -1;
    public int pos = 0;
    public int id = 0;

    public SegmentBuilder(ByteBuffer byteBuffer, Arena arena) {
        super(byteBuffer, arena);
    }

    private final int capacity() {
        this.buffer.rewind();
        return this.buffer.remaining() / 8;
    }

    public final int currentSize() {
        return this.pos;
    }

    public final int allocate(int n2) {
        assert (n2 >= 0) : "tried to allocate a negative number of words";
        if (n2 > this.capacity() - this.currentSize()) {
            return -1;
        }
        int n3 = this.pos;
        this.pos += n2;
        return n3;
    }

    public final BuilderArena getArena() {
        return (BuilderArena)this.arena;
    }

    public final boolean isWritable() {
        return true;
    }

    public final void put(int n2, long l2) {
        this.buffer.putLong(n2 * 8, l2);
    }
}

