/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class EigenEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap;
    private final double[] projectionEigenVec;

    public EigenEncoder(String columnName, int targetIndex, String[] domainValues, double[] projectionEigenVec) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        this.domainMap = new HashMap<String, Integer>();
        for (int j2 = 0; j2 < domainValues.length; ++j2) {
            this.domainMap.put(domainValues[j2], j2);
        }
        this.projectionEigenVec = projectionEigenVec;
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer levelIndex = this.domainMap.get(levelName);
        if (levelIndex == null) {
            return false;
        }
        rawData[this.targetIndex] = (float)this.projectionEigenVec[levelIndex];
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        rawData[this.targetIndex] = Double.NaN;
    }
}

