"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schedule = exports.ResourceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const cdk = require("aws-cdk-lib");
class ResourceBase extends cdk.Resource {
}
exports.ResourceBase = ResourceBase;
_a = JSII_RTTI_SYMBOL_1;
ResourceBase[_a] = { fqn: "cdk-data-zone.ResourceBase", version: "0.0.0" };
class Schedule {
    static fromCron(options) {
        function fallback(x, def) {
            return x ?? def;
        }
        const minute = fallback(options.minute, '*');
        const hour = fallback(options.hour, '*');
        const month = fallback(options.month, '*');
        const year = fallback(options.year, '*');
        // Weekday defaults to '?' if not supplied. If it is supplied, day must become '?'
        const day = fallback(options.day, options.weekDay !== undefined ? '?' : '*');
        const weekDay = fallback(options.weekDay, '?');
        const expressionString = `cron(${minute} ${hour} ${day} ${month} ${weekDay} ${year})`;
        return new Schedule(expressionString, options.timeZone);
    }
    constructor(expression, timezone) {
        this.expression = expression;
        this.timezone = timezone;
    }
}
exports.Schedule = Schedule;
_b = JSII_RTTI_SYMBOL_1;
Schedule[_b] = { fqn: "cdk-data-zone.Schedule", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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