import * as cdk from 'aws-cdk-lib';
import * as datazone from 'aws-cdk-lib/aws-datazone';
export interface IResource extends cdk.IResource {
    /**
     * The timestamp of when the data source was created.
     *
     * @cloudformationAttribute CreatedAt
     * @attribute
     */
    readonly createdAt: string;
    /**
     * The timestamp of when the data source was updated.
     *
     * @cloudformationAttribute UpdatedAt
     * @attribute
     */
    readonly updatedAt: string;
}
export declare abstract class ResourceBase extends cdk.Resource {
    /**
     * The timestamp of when the data source was created.
     *
     * @cloudformationAttribute CreatedAt
     * @attribute
     */
    readonly abstract createdAt: string;
    /**
     * The timestamp of when the data source was updated.
     *
     * @cloudformationAttribute UpdatedAt
     * @attribute
     */
    readonly abstract updatedAt: string;
}
export interface CronOptions {
    /**
     * The minute to run this rule at
     *
     * @default - Every minute
     */
    readonly minute?: string;
    /**
     * The hour to run this rule at
     *
     * @default - Every hour
     */
    readonly hour?: string;
    /**
     * The day of the month to run this rule at
     *
     * @default - Every day of the month
     */
    readonly day?: string;
    /**
     * The month to run this rule at
     *
     * @default - Every month
     */
    readonly month?: string;
    /**
     * The year to run this rule at
     *
     * @default - Every year
     */
    readonly year?: string;
    /**
     * The day of the week to run this rule at
     *
     * @default - Any day of the week
     */
    readonly weekDay?: string;
    readonly timeZone?: string;
}
export declare class Schedule {
    readonly expression: string;
    readonly timezone?: string | undefined;
    static fromCron(options: CronOptions): Schedule;
    private constructor();
}
export interface IDataSourceConfiguration {
    readonly filterType: string;
    readonly configuration: datazone.CfnDataSource.DataSourceConfigurationInputProperty;
}
