"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Glossary = exports.GlossaryBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResource = require("aws-cdk-lib/custom-resources");
const glossary_term_1 = require("./glossary-term");
const IS_GLOSSARY = Symbol.for('amazon-datazone.Glossary');
const GLOSSARY_CUSTOM_RESOURCE = 'glossary-custom-resource';
class GlossaryBase extends cdk.Resource {
}
exports.GlossaryBase = GlossaryBase;
_a = JSII_RTTI_SYMBOL_1;
GlossaryBase[_a] = { fqn: "cdk-data-zone.GlossaryBase", version: "0.0.0" };
class Glossary extends GlossaryBase {
    constructor(scope, id, props) {
        super(scope, id);
        this.project = props.project;
        const stack = cdk.Stack.of(scope);
        this.customResourceProvider = stack.node.tryFindChild(GLOSSARY_CUSTOM_RESOURCE) ?? this.createGlossaryProvider(stack);
        const resource = new cdk.CustomResource(this, 'glossary', {
            serviceToken: this.customResourceProvider.serviceToken,
            properties: {
                DomainIdentifier: props.project.projectDomainId,
                OwningProjectIdentifier: props.project.projectId,
                GlossaryName: props.name,
                GlossaryDescription: props.description,
            },
        });
        this.glossaryId = resource.getAttString('GlossaryId');
        if (props.terms) {
            this.addGlossaryTerms(props.terms);
        }
        Object.defineProperty(this, IS_GLOSSARY, { value: true });
    }
    createGlossaryProvider(stack) {
        const functionName = cdk.Names.uniqueId(stack) + '-glossary';
        const lambdaFunction = new lambda.Function(stack, GLOSSARY_CUSTOM_RESOURCE + 'Lambda', {
            functionName,
            runtime: lambda.Runtime.PYTHON_3_12,
            code: lambda.Code.fromAsset(path.resolve(__dirname, '../assets/glossaries')),
            handler: 'main.handler',
            memorySize: 1024,
            timeout: cdk.Duration.minutes(5),
            tracing: lambda.Tracing.ACTIVE,
            currentVersionOptions: {
                removalPolicy: cdk.RemovalPolicy.DESTROY,
            },
            role: this.project.managementRole,
        });
        lambdaFunction.node.addDependency(this.project.membership);
        this.project.managementRole.assumeRolePolicy?.addStatements(new iam.PolicyStatement({
            principals: [new iam.ServicePrincipal('lambda.amazonaws.com')],
            actions: ['sts:AssumeRole'],
            conditions: {
                ArnLike: {
                    'aws:SourceArn': `arn:aws:lambda:${stack.region}:${stack.account}:function:${functionName}`,
                },
            },
        }));
        const provider = new customResource.Provider(stack, GLOSSARY_CUSTOM_RESOURCE, {
            onEventHandler: lambdaFunction,
        });
        return provider;
    }
    addGlossaryTerms(terms) {
        return terms.map(term => new glossary_term_1.GlossaryTerm(this, `${this.node.id}#${term.name}`, {
            ...term,
            glossary: this,
        }));
    }
}
exports.Glossary = Glossary;
_b = JSII_RTTI_SYMBOL_1;
Glossary[_b] = { fqn: "cdk-data-zone.Glossary", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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