import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { GlossaryTerm } from './glossary-term';
import { Project } from './project';
export interface GlossaryTermOptions {
    readonly name: string;
    readonly description?: string;
    readonly shortDescription?: string;
    readonly longDescription?: string;
    readonly enabled?: boolean;
}
export interface GlossaryProps {
    readonly project: Project;
    readonly name: string;
    readonly description: string;
    readonly terms?: GlossaryTermOptions[];
}
export interface IGlossary extends cdk.IResource {
    /**
       * @attribute
       */
    readonly glossaryId: string;
    readonly project: Project;
    addGlossaryTerms(terms: GlossaryTermOptions[]): GlossaryTerm[];
}
export declare abstract class GlossaryBase extends cdk.Resource implements IGlossary {
    /**
       * @attribute
       */
    readonly abstract glossaryId: string;
    readonly abstract project: Project;
    abstract addGlossaryTerms(terms: GlossaryTermOptions[]): GlossaryTerm[];
}
export declare class Glossary extends GlossaryBase {
    private customResourceProvider;
    /**
       * @attribute
       */
    readonly glossaryId: string;
    readonly project: Project;
    constructor(scope: Construct, id: string, props: GlossaryProps);
    private createGlossaryProvider;
    addGlossaryTerms(terms: GlossaryTermOptions[]): GlossaryTerm[];
}
