"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlossaryTerm = exports.GlossaryTermBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResource = require("aws-cdk-lib/custom-resources");
const IS_GLOSSARY_TERM = Symbol.for('amazon-datazone.GlossaryTerm');
const GLOSSARY_TERM_CUSTOM_RESOURCE = 'glossary-term-custom-resource';
class GlossaryTermBase extends cdk.Resource {
}
exports.GlossaryTermBase = GlossaryTermBase;
_a = JSII_RTTI_SYMBOL_1;
GlossaryTermBase[_a] = { fqn: "cdk-data-zone.GlossaryTermBase", version: "0.0.0" };
class GlossaryTerm extends GlossaryTermBase {
    constructor(scope, id, props) {
        super(scope, id);
        this.project = props.glossary.project;
        this.glossary = props.glossary;
        const stack = cdk.Stack.of(scope);
        this.customResourceProvider = stack.node.tryFindChild(GLOSSARY_TERM_CUSTOM_RESOURCE)
            ?? this.createGlossaryTermProvider(stack);
        const resource = new cdk.CustomResource(this, 'glossaryterm', {
            serviceToken: this.customResourceProvider.serviceToken,
            properties: {
                DomainIdentifier: props.glossary.project.projectDomainId,
                GlossaryIdentifier: this.glossary.glossaryId,
                Name: props.name,
                ShortDescription: props.shortDescription,
                LongDescription: props.longDescription,
                TermRelations: {},
                Status: props.enabled ?? true ? 'ENABLED' : 'DISABLED',
            },
        });
        this.glossaryTermId = resource.getAttString('GlossaryTermId');
        Object.defineProperty(this, IS_GLOSSARY_TERM, { value: true });
    }
    createGlossaryTermProvider(stack) {
        const functionName = cdk.Names.uniqueId(stack) + '-glossary-terms';
        const lambdaFunction = new lambda.Function(stack, GLOSSARY_TERM_CUSTOM_RESOURCE + 'Lambda', {
            functionName,
            runtime: lambda.Runtime.PYTHON_3_12,
            code: lambda.Code.fromAsset(path.resolve(__dirname, '../assets/glossary-terms')),
            handler: 'main.handler',
            memorySize: 1024,
            timeout: cdk.Duration.minutes(5),
            tracing: lambda.Tracing.ACTIVE,
            currentVersionOptions: {
                removalPolicy: cdk.RemovalPolicy.DESTROY,
            },
            role: this.project.managementRole,
        });
        this.project.managementRole.assumeRolePolicy?.addStatements(new iam.PolicyStatement({
            principals: [new iam.ServicePrincipal('lambda.amazonaws.com')],
            actions: ['sts:AssumeRole'],
            conditions: {
                ArnLike: {
                    'aws:SourceArn': `arn:aws:lambda:${stack.region}:${stack.account}:function:${functionName}`,
                },
            },
        }));
        lambdaFunction.node.addDependency(this.project.membership);
        const provider = new customResource.Provider(stack, GLOSSARY_TERM_CUSTOM_RESOURCE, {
            onEventHandler: lambdaFunction,
        });
        return provider;
    }
}
exports.GlossaryTerm = GlossaryTerm;
_b = JSII_RTTI_SYMBOL_1;
GlossaryTerm[_b] = { fqn: "cdk-data-zone.GlossaryTerm", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2xvc3NhcnktdGVybS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9nbG9zc2FyeS10ZXJtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEscUVBQXFFO0FBQ3JFLHNDQUFzQztBQUV0Qyw2QkFBNkI7QUFDN0IsbUNBQW1DO0FBQ25DLDJDQUEyQztBQUMzQyxpREFBaUQ7QUFDakQsK0RBQStEO0FBTS9ELE1BQU0sZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0FBQ3BFLE1BQU0sNkJBQTZCLEdBQUcsK0JBQStCLENBQUM7QUEwQnRFLE1BQXNCLGdCQUFpQixTQUFRLEdBQUcsQ0FBQyxRQUFROztBQUEzRCw0Q0FPQzs7O0FBRUQsTUFBYSxZQUFhLFNBQVEsZ0JBQWdCO0lBYWhELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBd0I7UUFDaEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDO1FBQ3RDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUUvQixNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUVsQyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsNkJBQTZCLENBQTRCO2VBQ3hHLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUU5QyxNQUFNLFFBQVEsR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRTtZQUM1RCxZQUFZLEVBQUUsSUFBSSxDQUFDLHNCQUFzQixDQUFDLFlBQVk7WUFDdEQsVUFBVSxFQUFFO2dCQUNWLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLGVBQWU7Z0JBQ3hELGtCQUFrQixFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVTtnQkFDNUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO2dCQUNoQixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO2dCQUN4QyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7Z0JBQ3RDLGFBQWEsRUFBRSxFQUFFO2dCQUNqQixNQUFNLEVBQUUsS0FBSyxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsVUFBVTthQUN2RDtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxjQUFjLEdBQUcsUUFBUSxDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBRTlELE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFLEVBQUUsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7SUFDakUsQ0FBQztJQUVPLDBCQUEwQixDQUFDLEtBQWdCO1FBRWpELE1BQU0sWUFBWSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxHQUFHLGlCQUFpQixDQUFDO1FBRW5FLE1BQU0sY0FBYyxHQUFHLElBQUksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsNkJBQTZCLEdBQUcsUUFBUSxFQUFFO1lBQzFGLFlBQVk7WUFDWixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO1lBQ25DLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsRUFBRSwwQkFBMEIsQ0FBQyxDQUFDO1lBQ2hGLE9BQU8sRUFBRSxjQUFjO1lBQ3ZCLFVBQVUsRUFBRSxJQUFJO1lBQ2hCLE9BQU8sRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDaEMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTTtZQUM5QixxQkFBcUIsRUFBRTtnQkFDckIsYUFBYSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsT0FBTzthQUN6QztZQUNELElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWM7U0FDbEMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLEVBQUUsYUFBYSxDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUNsRixVQUFVLEVBQUUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1lBQzlELE9BQU8sRUFBRSxDQUFDLGdCQUFnQixDQUFDO1lBQzNCLFVBQVUsRUFBRTtnQkFDVixPQUFPLEVBQUU7b0JBQ1AsZUFBZSxFQUFFLGtCQUFrQixLQUFLLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxPQUFPLGFBQWEsWUFBWSxFQUFFO2lCQUM1RjthQUNGO1NBQ0YsQ0FBQyxDQUFDLENBQUM7UUFFSixjQUFjLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBRTNELE1BQU0sUUFBUSxHQUFHLElBQUksY0FBYyxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsNkJBQTZCLEVBQUU7WUFDakYsY0FBYyxFQUFFLGNBQWM7U0FDL0IsQ0FBQyxDQUFDO1FBRUgsT0FBTyxRQUFRLENBQUM7SUFDbEIsQ0FBQzs7QUE3RUgsb0NBOEVDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuXG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIGN1c3RvbVJlc291cmNlIGZyb20gJ2F3cy1jZGstbGliL2N1c3RvbS1yZXNvdXJjZXMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBJR2xvc3NhcnkgfSBmcm9tICcuL2dsb3NzYXJ5JztcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tICcuL3Byb2plY3QnO1xuXG5cbmNvbnN0IElTX0dMT1NTQVJZX1RFUk0gPSBTeW1ib2wuZm9yKCdhbWF6b24tZGF0YXpvbmUuR2xvc3NhcnlUZXJtJyk7XG5jb25zdCBHTE9TU0FSWV9URVJNX0NVU1RPTV9SRVNPVVJDRSA9ICdnbG9zc2FyeS10ZXJtLWN1c3RvbS1yZXNvdXJjZSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgR2xvc3NhcnlUZXJtUHJvcHMge1xuXG4gIHJlYWRvbmx5IGdsb3NzYXJ5OiBJR2xvc3Nhcnk7XG5cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IHNob3J0RGVzY3JpcHRpb24/OiBzdHJpbmc7XG5cbiAgcmVhZG9ubHkgbG9uZ0Rlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IGVuYWJsZWQ/OiBib29sZWFuO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIElHbG9zc2FyeVRlcm0gZXh0ZW5kcyBjZGsuSVJlc291cmNlIHtcblxuICAvKipcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IGdsb3NzYXJ5VGVybUlkOiBzdHJpbmc7XG5cbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEdsb3NzYXJ5VGVybUJhc2UgZXh0ZW5kcyBjZGsuUmVzb3VyY2UgaW1wbGVtZW50cyBJR2xvc3NhcnlUZXJtIHtcblxuICAvKipcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IGFic3RyYWN0IGdsb3NzYXJ5VGVybUlkOiBzdHJpbmc7XG5cbn1cblxuZXhwb3J0IGNsYXNzIEdsb3NzYXJ5VGVybSBleHRlbmRzIEdsb3NzYXJ5VGVybUJhc2Uge1xuXG4gIHByaXZhdGUgY3VzdG9tUmVzb3VyY2VQcm92aWRlcjogY3VzdG9tUmVzb3VyY2UuUHJvdmlkZXI7XG5cbiAgLyoqXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBnbG9zc2FyeVRlcm1JZDogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IHByb2plY3Q6IFByb2plY3Q7XG5cbiAgcmVhZG9ubHkgZ2xvc3Nhcnk6IElHbG9zc2FyeTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogR2xvc3NhcnlUZXJtUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5wcm9qZWN0ID0gcHJvcHMuZ2xvc3NhcnkucHJvamVjdDtcbiAgICB0aGlzLmdsb3NzYXJ5ID0gcHJvcHMuZ2xvc3Nhcnk7XG5cbiAgICBjb25zdCBzdGFjayA9IGNkay5TdGFjay5vZihzY29wZSk7XG5cbiAgICB0aGlzLmN1c3RvbVJlc291cmNlUHJvdmlkZXIgPSBzdGFjay5ub2RlLnRyeUZpbmRDaGlsZChHTE9TU0FSWV9URVJNX0NVU1RPTV9SRVNPVVJDRSkgYXMgY3VzdG9tUmVzb3VyY2UuUHJvdmlkZXJcbiAgICAgICAgPz8gdGhpcy5jcmVhdGVHbG9zc2FyeVRlcm1Qcm92aWRlcihzdGFjayk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBjZGsuQ3VzdG9tUmVzb3VyY2UodGhpcywgJ2dsb3NzYXJ5dGVybScsIHtcbiAgICAgIHNlcnZpY2VUb2tlbjogdGhpcy5jdXN0b21SZXNvdXJjZVByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgRG9tYWluSWRlbnRpZmllcjogcHJvcHMuZ2xvc3NhcnkucHJvamVjdC5wcm9qZWN0RG9tYWluSWQsXG4gICAgICAgIEdsb3NzYXJ5SWRlbnRpZmllcjogdGhpcy5nbG9zc2FyeS5nbG9zc2FyeUlkLFxuICAgICAgICBOYW1lOiBwcm9wcy5uYW1lLFxuICAgICAgICBTaG9ydERlc2NyaXB0aW9uOiBwcm9wcy5zaG9ydERlc2NyaXB0aW9uLFxuICAgICAgICBMb25nRGVzY3JpcHRpb246IHByb3BzLmxvbmdEZXNjcmlwdGlvbixcbiAgICAgICAgVGVybVJlbGF0aW9uczoge30sXG4gICAgICAgIFN0YXR1czogcHJvcHMuZW5hYmxlZCA/PyB0cnVlID8gJ0VOQUJMRUQnIDogJ0RJU0FCTEVEJyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLmdsb3NzYXJ5VGVybUlkID0gcmVzb3VyY2UuZ2V0QXR0U3RyaW5nKCdHbG9zc2FyeVRlcm1JZCcpO1xuXG4gICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRoaXMsIElTX0dMT1NTQVJZX1RFUk0sIHsgdmFsdWU6IHRydWUgfSk7XG4gIH1cblxuICBwcml2YXRlIGNyZWF0ZUdsb3NzYXJ5VGVybVByb3ZpZGVyKHN0YWNrOiBjZGsuU3RhY2spIHtcblxuICAgIGNvbnN0IGZ1bmN0aW9uTmFtZSA9IGNkay5OYW1lcy51bmlxdWVJZChzdGFjaykgKyAnLWdsb3NzYXJ5LXRlcm1zJztcblxuICAgIGNvbnN0IGxhbWJkYUZ1bmN0aW9uID0gbmV3IGxhbWJkYS5GdW5jdGlvbihzdGFjaywgR0xPU1NBUllfVEVSTV9DVVNUT01fUkVTT1VSQ0UgKyAnTGFtYmRhJywge1xuICAgICAgZnVuY3Rpb25OYW1lLFxuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfMTIsXG4gICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQocGF0aC5yZXNvbHZlKF9fZGlybmFtZSwgJy4uL2Fzc2V0cy9nbG9zc2FyeS10ZXJtcycpKSxcbiAgICAgIGhhbmRsZXI6ICdtYWluLmhhbmRsZXInLFxuICAgICAgbWVtb3J5U2l6ZTogMTAyNCxcbiAgICAgIHRpbWVvdXQ6IGNkay5EdXJhdGlvbi5taW51dGVzKDUpLFxuICAgICAgdHJhY2luZzogbGFtYmRhLlRyYWNpbmcuQUNUSVZFLFxuICAgICAgY3VycmVudFZlcnNpb25PcHRpb25zOiB7XG4gICAgICAgIHJlbW92YWxQb2xpY3k6IGNkay5SZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gICAgICB9LFxuICAgICAgcm9sZTogdGhpcy5wcm9qZWN0Lm1hbmFnZW1lbnRSb2xlLFxuICAgIH0pO1xuXG4gICAgdGhpcy5wcm9qZWN0Lm1hbmFnZW1lbnRSb2xlLmFzc3VtZVJvbGVQb2xpY3k/LmFkZFN0YXRlbWVudHMobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgcHJpbmNpcGFsczogW25ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnbGFtYmRhLmFtYXpvbmF3cy5jb20nKV0sXG4gICAgICBhY3Rpb25zOiBbJ3N0czpBc3N1bWVSb2xlJ10sXG4gICAgICBjb25kaXRpb25zOiB7XG4gICAgICAgIEFybkxpa2U6IHtcbiAgICAgICAgICAnYXdzOlNvdXJjZUFybic6IGBhcm46YXdzOmxhbWJkYToke3N0YWNrLnJlZ2lvbn06JHtzdGFjay5hY2NvdW50fTpmdW5jdGlvbjoke2Z1bmN0aW9uTmFtZX1gLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9KSk7XG5cbiAgICBsYW1iZGFGdW5jdGlvbi5ub2RlLmFkZERlcGVuZGVuY3kodGhpcy5wcm9qZWN0Lm1lbWJlcnNoaXApO1xuXG4gICAgY29uc3QgcHJvdmlkZXIgPSBuZXcgY3VzdG9tUmVzb3VyY2UuUHJvdmlkZXIoc3RhY2ssIEdMT1NTQVJZX1RFUk1fQ1VTVE9NX1JFU09VUkNFLCB7XG4gICAgICBvbkV2ZW50SGFuZGxlcjogbGFtYmRhRnVuY3Rpb24sXG4gICAgfSk7XG5cbiAgICByZXR1cm4gcHJvdmlkZXI7XG4gIH1cbn0iXX0=