import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IGlossary } from './glossary';
import { Project } from './project';
export interface GlossaryTermProps {
    readonly glossary: IGlossary;
    readonly name: string;
    readonly description?: string;
    readonly shortDescription?: string;
    readonly longDescription?: string;
    readonly enabled?: boolean;
}
export interface IGlossaryTerm extends cdk.IResource {
    /**
       * @attribute
       */
    readonly glossaryTermId: string;
}
export declare abstract class GlossaryTermBase extends cdk.Resource implements IGlossaryTerm {
    /**
       * @attribute
       */
    readonly abstract glossaryTermId: string;
}
export declare class GlossaryTerm extends GlossaryTermBase {
    private customResourceProvider;
    /**
       * @attribute
       */
    readonly glossaryTermId: string;
    readonly project: Project;
    readonly glossary: IGlossary;
    constructor(scope: Construct, id: string, props: GlossaryTermProps);
    private createGlossaryTermProvider;
}
