"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormMetadata = exports.FormMetadataBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResource = require("aws-cdk-lib/custom-resources");
const IS_FORM_METADATA = Symbol.for('amazon-datazone.FormMetadata');
const FORM_METADATA_CUSTOM_RESOURCE = 'form-custom-resource';
class FormMetadataBase extends cdk.Resource {
}
exports.FormMetadataBase = FormMetadataBase;
_a = JSII_RTTI_SYMBOL_1;
FormMetadataBase[_a] = { fqn: "cdk-data-zone.FormMetadataBase", version: "0.0.0" };
class FormMetadata extends FormMetadataBase {
    constructor(scope, id, props) {
        super(scope, id);
        this.project = props.project;
        const stack = cdk.Stack.of(scope);
        this.customResourceProvider = stack.node.tryFindChild(FORM_METADATA_CUSTOM_RESOURCE)
            ?? this.createFormMetadataProvider(stack);
        const resource = new cdk.CustomResource(this, 'form-metadata', {
            serviceToken: this.customResourceProvider.serviceToken,
            properties: {
                DomainIdentifier: props.project.projectDomainId,
                ProjectIdentifier: props.project.projectId,
                FormName: props.name,
                FormDescription: props.description,
                FormModelSmithy: props.smithyModel,
            },
        });
        this.formName = resource.getAttString('Name');
        this.formRevision = resource.getAttString('Revision');
        Object.defineProperty(this, IS_FORM_METADATA, { value: true });
    }
    createFormMetadataProvider(stack) {
        const functionName = cdk.Names.uniqueId(stack) + '-form';
        const lambdaFunction = new lambda.Function(stack, FORM_METADATA_CUSTOM_RESOURCE + 'Lambda', {
            functionName,
            runtime: lambda.Runtime.PYTHON_3_12,
            code: lambda.Code.fromAsset(path.resolve(__dirname, '../assets/form')),
            handler: 'main.handler',
            memorySize: 1024,
            timeout: cdk.Duration.minutes(5),
            tracing: lambda.Tracing.ACTIVE,
            currentVersionOptions: {
                removalPolicy: cdk.RemovalPolicy.DESTROY,
            },
            role: this.project.managementRole,
        });
        lambdaFunction.node.addDependency(this.project.membership);
        this.project.managementRole.assumeRolePolicy?.addStatements(new iam.PolicyStatement({
            principals: [new iam.ServicePrincipal('lambda.amazonaws.com')],
            actions: ['sts:AssumeRole'],
            conditions: {
                ArnLike: {
                    'aws:SourceArn': `arn:aws:lambda:${stack.region}:${stack.account}:function:${functionName}`,
                },
            },
        }));
        const provider = new customResource.Provider(stack, FORM_METADATA_CUSTOM_RESOURCE, {
            onEventHandler: lambdaFunction,
        });
        return provider;
    }
}
exports.FormMetadata = FormMetadata;
_b = JSII_RTTI_SYMBOL_1;
FormMetadata[_b] = { fqn: "cdk-data-zone.FormMetadata", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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