import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { Project } from './project';
export interface FormMetadataProps {
    readonly project: Project;
    readonly name: string;
    readonly description?: string;
    readonly smithyModel?: string;
}
export interface IFormMetadata extends cdk.IResource {
    /**
       * @attribute
       */
    readonly formName: string;
    /**
       * @attribute
       */
    readonly formRevision: string;
}
export declare abstract class FormMetadataBase extends cdk.Resource implements IFormMetadata {
    /**
       * @attribute
       */
    readonly abstract formName: string;
    /**
       * @attribute
       */
    readonly abstract formRevision: string;
}
export declare class FormMetadata extends FormMetadataBase {
    private customResourceProvider;
    /**
       * @attribute
       */
    readonly formName: string;
    /**
       * @attribute
       */
    readonly formRevision: string;
    readonly project: Project;
    constructor(scope: Construct, id: string, props: FormMetadataProps);
    private createFormMetadataProvider;
}
