"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Environment = exports.EnvironmentBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const cdk = require("aws-cdk-lib");
const datazone = require("aws-cdk-lib/aws-datazone");
const data_source_1 = require("./data-source");
const resource_1 = require("./resource");
const IS_ENVIRONMENT = Symbol.for('amazon-datazone.Environment');
class EnvironmentBase extends resource_1.ResourceBase {
    addDataSource(name, options) {
        return new data_source_1.DataSource(this, name, {
            ...options,
            project: this.project,
            environment: this,
            name: name,
        });
    }
}
exports.EnvironmentBase = EnvironmentBase;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentBase[_a] = { fqn: "cdk-data-zone.EnvironmentBase", version: "0.0.0" };
class Environment extends EnvironmentBase {
    constructor(scope, id, props) {
        super(scope, id);
        // check if domain name is 64 characters or less
        if (!cdk.Token.isUnresolved(props.name) && props.name.length > 64) {
            throw new Error('Project name must be 64 characters or less');
        }
        const resource = new datazone.CfnEnvironment(this, 'Resource', {
            domainIdentifier: props.project.projectDomainId,
            projectIdentifier: props.project.projectId,
            name: props.name,
            description: props.description,
            environmentProfileIdentifier: props.environmentProfile.environmentProfileId,
            environmentAccountIdentifier: props.environmentProfile.awsAccountId,
            environmentAccountRegion: props.environmentProfile.awsAccountRegion,
            environmentRoleArn: props.environmentRole?.roleArn,
            glossaryTerms: props.glossaryTerms,
            userParameters: props.userParameters,
        });
        this.createdAt = resource.attrCreatedAt;
        this.createdBy = resource.attrCreatedBy;
        this.project = props.project;
        this.environmentBlueprintId = resource.attrEnvironmentBlueprintId;
        this.updatedAt = resource.attrUpdatedAt;
        this.environmentId = resource.attrId;
        this.status = resource.attrStatus;
        this.name = props.name;
        this.provider = resource.attrProvider;
        this.environmentProfile = props.environmentProfile;
        this.domainId = resource.attrDomainId;
        this.awsAccountId = resource.attrAwsAccountId;
        this.awsAccountRegion = resource.attrAwsAccountRegion;
        Object.defineProperty(this, IS_ENVIRONMENT, { value: true });
    }
}
exports.Environment = Environment;
_b = JSII_RTTI_SYMBOL_1;
Environment[_b] = { fqn: "cdk-data-zone.Environment", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW52aXJvbm1lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZW52aXJvbm1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxxRUFBcUU7QUFDckUsc0NBQXNDO0FBRXRDLG1DQUFtQztBQUNuQyxxREFBcUQ7QUFHckQsK0NBQTJDO0FBRzNDLHlDQUF5RjtBQUV6RixNQUFNLGNBQWMsR0FBRyxNQUFNLENBQUMsR0FBRyxDQUFDLDZCQUE2QixDQUFDLENBQUM7QUFxSWpFLE1BQXNCLGVBQWdCLFNBQVEsdUJBQVk7SUF1RXhELGFBQWEsQ0FBQyxJQUFZLEVBQUUsT0FBMEI7UUFDcEQsT0FBTyxJQUFJLHdCQUFVLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRTtZQUNoQyxHQUFHLE9BQU87WUFDVixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsV0FBVyxFQUFFLElBQUk7WUFDakIsSUFBSSxFQUFFLElBQUk7U0FDWCxDQUFDLENBQUM7SUFDTCxDQUFDOztBQTlFSCwwQ0ErRUM7OztBQUVELE1BQWEsV0FBWSxTQUFRLGVBQWU7SUFzRjlDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixnREFBZ0Q7UUFDaEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxLQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxFQUFFLEVBQUUsQ0FBQztZQUNsRSxNQUFNLElBQUksS0FBSyxDQUFDLDRDQUE0QyxDQUFDLENBQUM7UUFDaEUsQ0FBQztRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksUUFBUSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzdELGdCQUFnQixFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBZTtZQUMvQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVM7WUFDMUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5Qiw0QkFBNEIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CO1lBQzNFLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZO1lBQ25FLHdCQUF3QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0I7WUFDbkUsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGVBQWUsRUFBRSxPQUFPO1lBQ2xELGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7U0FDckMsQ0FBQyxDQUFDO1FBR0gsSUFBSSxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDO1FBQ3hDLElBQUksQ0FBQyxTQUFTLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQztRQUN4QyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFFBQVEsQ0FBQywwQkFBMEIsQ0FBQztRQUNsRSxJQUFJLENBQUMsU0FBUyxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUM7UUFDeEMsSUFBSSxDQUFDLGFBQWEsR0FBRyxRQUFRLENBQUMsTUFBTSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxNQUFNLEdBQUcsUUFBUSxDQUFDLFVBQVUsQ0FBQztRQUNsQyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUMsWUFBWSxDQUFDO1FBQ3RDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7UUFDbkQsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUMsWUFBWSxDQUFDO1FBQ3RDLElBQUksQ0FBQyxZQUFZLEdBQUcsUUFBUSxDQUFDLGdCQUFnQixDQUFDO1FBQzlDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxRQUFRLENBQUMsb0JBQW9CLENBQUM7UUFFdEQsTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFLEVBQUUsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7SUFDL0QsQ0FBQzs7QUEzSEgsa0NBNEhDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuXG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgZGF0YXpvbmUgZnJvbSAnYXdzLWNkay1saWIvYXdzLWRhdGF6b25lJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgRGF0YVNvdXJjZSB9IGZyb20gJy4vZGF0YS1zb3VyY2UnO1xuaW1wb3J0IHsgSUVudmlyb25tZW50UHJvZmlsZSB9IGZyb20gJy4vZW52aXJvbm1lbnQtcHJvZmlsZSc7XG5pbXBvcnQgeyBJUHJvamVjdCB9IGZyb20gJy4vcHJvamVjdCc7XG5pbXBvcnQgeyBJRGF0YVNvdXJjZUNvbmZpZ3VyYXRpb24sIElSZXNvdXJjZSwgUmVzb3VyY2VCYXNlLCBTY2hlZHVsZSB9IGZyb20gJy4vcmVzb3VyY2UnO1xuXG5jb25zdCBJU19FTlZJUk9OTUVOVCA9IFN5bWJvbC5mb3IoJ2FtYXpvbi1kYXRhem9uZS5FbnZpcm9ubWVudCcpO1xuXG5leHBvcnQgaW50ZXJmYWNlIEVudmlyb25tZW50UHJvcHMge1xuICAvKipcbiAgICAgKiBUaGUgZGVzY3JpcHRpb24gb2YgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhem9uZS1lbnZpcm9ubWVudC5odG1sI2Nmbi1kYXRhem9uZS1lbnZpcm9ubWVudC1kZXNjcmlwdGlvblxuICAgICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIGVudmlyb25tZW50IHByb2ZpbGUgdGhhdCBpcyB1c2VkIHRvIGNyZWF0ZSB0aGlzIEFtYXpvbiAgZW52aXJvbm1lbnQuXG4gICAgICpcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGF6b25lLWVudmlyb25tZW50Lmh0bWwjY2ZuLWRhdGF6b25lLWVudmlyb25tZW50LWVudmlyb25tZW50cHJvZmlsZWlkZW50aWZpZXJcbiAgICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRQcm9maWxlOiBJRW52aXJvbm1lbnRQcm9maWxlO1xuICAvKipcbiAgICAgKiBUaGUgQVJOIG9mIHRoZSBlbnZpcm9ubWVudCByb2xlLlxuICAgICAqXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhem9uZS1lbnZpcm9ubWVudC5odG1sI2Nmbi1kYXRhem9uZS1lbnZpcm9ubWVudC1lbnZpcm9ubWVudHJvbGVhcm5cbiAgICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRSb2xlPzogaWFtLlJvbGU7XG4gIC8qKlxuICAgICAqIFRoZSBnbG9zc2FyeSB0ZXJtcyB0aGF0IGNhbiBiZSB1c2VkIGluIHRoaXMgQW1hem9uICBlbnZpcm9ubWVudC5cbiAgICAgKlxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXpvbmUtZW52aXJvbm1lbnQuaHRtbCNjZm4tZGF0YXpvbmUtZW52aXJvbm1lbnQtZ2xvc3Nhcnl0ZXJtc1xuICAgICAqL1xuICByZWFkb25seSBnbG9zc2FyeVRlcm1zPzogQXJyYXk8c3RyaW5nPjtcbiAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIEFtYXpvbiAgZW52aXJvbm1lbnQuXG4gICAgICpcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGF6b25lLWVudmlyb25tZW50Lmh0bWwjY2ZuLWRhdGF6b25lLWVudmlyb25tZW50LW5hbWVcbiAgICAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAvKipcbiAgICAgKiBUaGUgaWRlbnRpZmllciBvZiB0aGUgQW1hem9uICBwcm9qZWN0IGluIHdoaWNoIHRoaXMgZW52aXJvbm1lbnQgaXMgY3JlYXRlZC5cbiAgICAgKlxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXpvbmUtZW52aXJvbm1lbnQuaHRtbCNjZm4tZGF0YXpvbmUtZW52aXJvbm1lbnQtcHJvamVjdGlkZW50aWZpZXJcbiAgICAgKi9cbiAgcmVhZG9ubHkgcHJvamVjdDogSVByb2plY3Q7XG4gIC8qKlxuICAgICAqIFRoZSB1c2VyIHBhcmFtZXRlcnMgb2YgdGhpcyBBbWF6b24gIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhem9uZS1lbnZpcm9ubWVudC5odG1sI2Nmbi1kYXRhem9uZS1lbnZpcm9ubWVudC11c2VycGFyYW1ldGVyc1xuICAgICAqL1xuICByZWFkb25seSB1c2VyUGFyYW1ldGVycz86IEFycmF5PGRhdGF6b25lLkNmbkVudmlyb25tZW50LkVudmlyb25tZW50UGFyYW1ldGVyUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERhdGFTb3VyY2VPcHRpb25zIHtcbiAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW47XG5cbiAgcmVhZG9ubHkgcHVibGlzaE9uSW1wb3J0PzogYm9vbGVhbjtcblxuICByZWFkb25seSByZWNvbW1lbmRhdGlvbj86IGJvb2xlYW47XG5cbiAgcmVhZG9ubHkgc2NoZWR1bGU/OiBTY2hlZHVsZTtcblxuICByZWFkb25seSBjb25maWd1cmF0aW9uOiBJRGF0YVNvdXJjZUNvbmZpZ3VyYXRpb247XG5cbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSUVudmlyb25tZW50IGV4dGVuZHMgSVJlc291cmNlIHtcbiAgLyoqXG4gKiBUaGUgaWRlbnRpZmllciBvZiB0aGUgQVdTIGFjY291bnQgaW4gd2hpY2ggYW4gZW52aXJvbm1lbnQgZXhpc3RzLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBd3NBY2NvdW50SWRcbiAqIEBhdHRyaWJ1dGVcbiAqL1xuICByZWFkb25seSBhd3NBY2NvdW50SWQ6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIEFXUyBSZWdpb24gaW4gd2hpY2ggYW4gZW52aXJvbm1lbnQgZXhpc3RzLlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEF3c0FjY291bnRSZWdpb25cbiAgICAgKi9cbiAgcmVhZG9ubHkgYXdzQWNjb3VudFJlZ2lvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFRoZSBBbWF6b24gIHVzZXIgd2hvIGNyZWF0ZWQgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIENyZWF0ZWRCeVxuICAgICAqIEBhdHRyaWJ1dGVcbiAgICAgKi9cbiAgcmVhZG9ubHkgY3JlYXRlZEJ5OiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBpZGVudGlmaWVyIG9mIHRoZSBBbWF6b24gIGRvbWFpbiBpbiB3aGljaCB0aGUgZW52aXJvbm1lbnQgZXhpc3RzLlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIERvbWFpbklkXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBkb21haW5JZDogc3RyaW5nO1xuICAvKipcbiAgICAgKiBUaGUgaWRlbnRpZmllciBvZiBhIGJsdWVwcmludCB3aXRoIHdoaWNoIGFuIGVudmlyb25tZW50IHByb2ZpbGUgaXMgY3JlYXRlZC5cbiAgICAgKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBFbnZpcm9ubWVudEJsdWVwcmludElkXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBlbnZpcm9ubWVudEJsdWVwcmludElkOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBpZGVudGlmaWVyIG9mIHRoZSBlbnZpcm9ubWVudCBwcm9maWxlIHdpdGggd2hpY2ggdGhlIGVudmlyb25tZW50IHdhcyBjcmVhdGVkLlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEVudmlyb25tZW50UHJvZmlsZUlkXG4gICAgICovXG4gIHJlYWRvbmx5IGVudmlyb25tZW50UHJvZmlsZTogSUVudmlyb25tZW50UHJvZmlsZTtcbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIElkXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBlbnZpcm9ubWVudElkOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBpZGVudGlmaWVyIG9mIHRoZSBwcm9qZWN0IGluIHdoaWNoIHRoZSBlbnZpcm9ubWVudCBleGlzdHMuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgUHJvamVjdElkXG4gICAgICovXG4gIHJlYWRvbmx5IHByb2plY3Q6IElQcm9qZWN0O1xuICAvKipcbiAgICAgKiBUaGUgcHJvdmlkZXIgb2YgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIFByb3ZpZGVyXG4gICAgICovXG4gIHJlYWRvbmx5IHByb3ZpZGVyOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBzdGF0dXMgb2YgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIFN0YXR1c1xuICAgICAqIEBhdHRyaWJ1dGVcbiAgICAgKi9cbiAgcmVhZG9ubHkgc3RhdHVzOiBzdHJpbmc7XG5cbiAgYWRkRGF0YVNvdXJjZShuYW1lOiBzdHJpbmcsIG9wdGlvbnM6IERhdGFTb3VyY2VPcHRpb25zKTogRGF0YVNvdXJjZTtcbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEVudmlyb25tZW50QmFzZSBleHRlbmRzIFJlc291cmNlQmFzZSBpbXBsZW1lbnRzIElFbnZpcm9ubWVudCB7XG5cbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIEFXUyBhY2NvdW50IGluIHdoaWNoIGFuIGVudmlyb25tZW50IGV4aXN0cy5cbiAgICAgKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBd3NBY2NvdW50SWRcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IGFic3RyYWN0IGF3c0FjY291bnRJZDogc3RyaW5nO1xuICAvKipcbiAgICAgKiBUaGUgQVdTIFJlZ2lvbiBpbiB3aGljaCBhbiBlbnZpcm9ubWVudCBleGlzdHMuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQXdzQWNjb3VudFJlZ2lvblxuICAgICAqL1xuICByZWFkb25seSBhYnN0cmFjdCBhd3NBY2NvdW50UmVnaW9uOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBBbWF6b24gIHVzZXIgd2hvIGNyZWF0ZWQgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIENyZWF0ZWRCeVxuICAgICAqIEBhdHRyaWJ1dGVcbiAgICAgKi9cbiAgcmVhZG9ubHkgYWJzdHJhY3QgY3JlYXRlZEJ5OiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBpZGVudGlmaWVyIG9mIHRoZSBBbWF6b24gIGRvbWFpbiBpbiB3aGljaCB0aGUgZW52aXJvbm1lbnQgZXhpc3RzLlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIERvbWFpbklkXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBhYnN0cmFjdCBkb21haW5JZDogc3RyaW5nO1xuICAvKipcbiAgICAgKiBUaGUgaWRlbnRpZmllciBvZiBhIGJsdWVwcmludCB3aXRoIHdoaWNoIGFuIGVudmlyb25tZW50IHByb2ZpbGUgaXMgY3JlYXRlZC5cbiAgICAgKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBFbnZpcm9ubWVudEJsdWVwcmludElkXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBhYnN0cmFjdCBlbnZpcm9ubWVudEJsdWVwcmludElkOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBpZGVudGlmaWVyIG9mIHRoZSBlbnZpcm9ubWVudCBwcm9maWxlIHdpdGggd2hpY2ggdGhlIGVudmlyb25tZW50IHdhcyBjcmVhdGVkLlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEVudmlyb25tZW50UHJvZmlsZUlkXG4gICAgICovXG4gIHJlYWRvbmx5IGFic3RyYWN0IGVudmlyb25tZW50UHJvZmlsZTogSUVudmlyb25tZW50UHJvZmlsZTtcbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIElkXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBhYnN0cmFjdCBlbnZpcm9ubWVudElkOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBpZGVudGlmaWVyIG9mIHRoZSBwcm9qZWN0IGluIHdoaWNoIHRoZSBlbnZpcm9ubWVudCBleGlzdHMuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgUHJvamVjdElkXG4gICAgICovXG4gIHJlYWRvbmx5IGFic3RyYWN0IHByb2plY3Q6IElQcm9qZWN0O1xuICAvKipcbiAgICAgKiBUaGUgcHJvdmlkZXIgb2YgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIFByb3ZpZGVyXG4gICAgICovXG4gIHJlYWRvbmx5IGFic3RyYWN0IHByb3ZpZGVyOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBzdGF0dXMgb2YgdGhlIGVudmlyb25tZW50LlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIFN0YXR1c1xuICAgICAqIEBhdHRyaWJ1dGVcbiAgICAgKi9cbiAgcmVhZG9ubHkgYWJzdHJhY3Qgc3RhdHVzOiBzdHJpbmc7XG5cbiAgcmVhZG9ubHkgYWJzdHJhY3QgbmFtZTogc3RyaW5nO1xuXG4gIGFkZERhdGFTb3VyY2UobmFtZTogc3RyaW5nLCBvcHRpb25zOiBEYXRhU291cmNlT3B0aW9ucyk6IERhdGFTb3VyY2Uge1xuICAgIHJldHVybiBuZXcgRGF0YVNvdXJjZSh0aGlzLCBuYW1lLCB7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgcHJvamVjdDogdGhpcy5wcm9qZWN0LFxuICAgICAgZW52aXJvbm1lbnQ6IHRoaXMsXG4gICAgICBuYW1lOiBuYW1lLFxuICAgIH0pO1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBFbnZpcm9ubWVudCBleHRlbmRzIEVudmlyb25tZW50QmFzZSB7XG5cbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIEFXUyBhY2NvdW50IGluIHdoaWNoIGFuIGVudmlyb25tZW50IGV4aXN0cy5cbiAgICAgKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBd3NBY2NvdW50SWRcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IGF3c0FjY291bnRJZDogc3RyaW5nO1xuICAvKipcbiAgICAgKiBUaGUgQVdTIFJlZ2lvbiBpbiB3aGljaCBhbiBlbnZpcm9ubWVudCBleGlzdHMuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQXdzQWNjb3VudFJlZ2lvblxuICAgICAqL1xuICByZWFkb25seSBhd3NBY2NvdW50UmVnaW9uOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSB0aW1lc3RhbXAgb2Ygd2hlbiB0aGUgZW52aXJvbm1lbnQgd2FzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQ3JlYXRlZEF0XG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBjcmVhdGVkQXQ6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIEFtYXpvbiAgdXNlciB3aG8gY3JlYXRlZCB0aGUgZW52aXJvbm1lbnQuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQ3JlYXRlZEJ5XG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBjcmVhdGVkQnk6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIEFtYXpvbiAgZG9tYWluIGluIHdoaWNoIHRoZSBlbnZpcm9ubWVudCBleGlzdHMuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgRG9tYWluSWRcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IGRvbWFpbklkOiBzdHJpbmc7XG4gIC8qKlxuICAgICAqIFRoZSBpZGVudGlmaWVyIG9mIGEgYmx1ZXByaW50IHdpdGggd2hpY2ggYW4gZW52aXJvbm1lbnQgcHJvZmlsZSBpcyBjcmVhdGVkLlxuICAgICAqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEVudmlyb25tZW50Qmx1ZXByaW50SWRcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IGVudmlyb25tZW50Qmx1ZXByaW50SWQ6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIGVudmlyb25tZW50IHByb2ZpbGUgd2l0aCB3aGljaCB0aGUgZW52aXJvbm1lbnQgd2FzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgRW52aXJvbm1lbnRQcm9maWxlSWRcbiAgICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRQcm9maWxlOiBJRW52aXJvbm1lbnRQcm9maWxlO1xuICAvKipcbiAgICAgKiBUaGUgaWRlbnRpZmllciBvZiB0aGUgZW52aXJvbm1lbnQuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgSWRcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IGVudmlyb25tZW50SWQ6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIHByb2plY3QgaW4gd2hpY2ggdGhlIGVudmlyb25tZW50IGV4aXN0cy5cbiAgICAgKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBQcm9qZWN0SWRcbiAgICAgKi9cbiAgcmVhZG9ubHkgcHJvamVjdDogSVByb2plY3Q7XG4gIC8qKlxuICAgICAqIFRoZSBwcm92aWRlciBvZiB0aGUgZW52aXJvbm1lbnQuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgUHJvdmlkZXJcbiAgICAgKi9cbiAgcmVhZG9ubHkgcHJvdmlkZXI6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIHN0YXR1cyBvZiB0aGUgZW52aXJvbm1lbnQuXG4gICAgICpcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgU3RhdHVzXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICByZWFkb25seSBzdGF0dXM6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIHRpbWVzdGFtcCBvZiB3aGVuIHRoZSBlbnZpcm9ubWVudCB3YXMgdXBkYXRlZC5cbiAgICAgKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBVcGRhdGVkQXRcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gIHJlYWRvbmx5IHVwZGF0ZWRBdDogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFbnZpcm9ubWVudFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIC8vIGNoZWNrIGlmIGRvbWFpbiBuYW1lIGlzIDY0IGNoYXJhY3RlcnMgb3IgbGVzc1xuICAgIGlmICghY2RrLlRva2VuLmlzVW5yZXNvbHZlZChwcm9wcy5uYW1lKSAmJiBwcm9wcy5uYW1lLmxlbmd0aCA+IDY0KSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1Byb2plY3QgbmFtZSBtdXN0IGJlIDY0IGNoYXJhY3RlcnMgb3IgbGVzcycpO1xuICAgIH1cblxuICAgIGNvbnN0IHJlc291cmNlID0gbmV3IGRhdGF6b25lLkNmbkVudmlyb25tZW50KHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGRvbWFpbklkZW50aWZpZXI6IHByb3BzLnByb2plY3QucHJvamVjdERvbWFpbklkLFxuICAgICAgcHJvamVjdElkZW50aWZpZXI6IHByb3BzLnByb2plY3QucHJvamVjdElkLFxuICAgICAgbmFtZTogcHJvcHMubmFtZSxcbiAgICAgIGRlc2NyaXB0aW9uOiBwcm9wcy5kZXNjcmlwdGlvbixcbiAgICAgIGVudmlyb25tZW50UHJvZmlsZUlkZW50aWZpZXI6IHByb3BzLmVudmlyb25tZW50UHJvZmlsZS5lbnZpcm9ubWVudFByb2ZpbGVJZCxcbiAgICAgIGVudmlyb25tZW50QWNjb3VudElkZW50aWZpZXI6IHByb3BzLmVudmlyb25tZW50UHJvZmlsZS5hd3NBY2NvdW50SWQsXG4gICAgICBlbnZpcm9ubWVudEFjY291bnRSZWdpb246IHByb3BzLmVudmlyb25tZW50UHJvZmlsZS5hd3NBY2NvdW50UmVnaW9uLFxuICAgICAgZW52aXJvbm1lbnRSb2xlQXJuOiBwcm9wcy5lbnZpcm9ubWVudFJvbGU/LnJvbGVBcm4sXG4gICAgICBnbG9zc2FyeVRlcm1zOiBwcm9wcy5nbG9zc2FyeVRlcm1zLFxuICAgICAgdXNlclBhcmFtZXRlcnM6IHByb3BzLnVzZXJQYXJhbWV0ZXJzLFxuICAgIH0pO1xuXG5cbiAgICB0aGlzLmNyZWF0ZWRBdCA9IHJlc291cmNlLmF0dHJDcmVhdGVkQXQ7XG4gICAgdGhpcy5jcmVhdGVkQnkgPSByZXNvdXJjZS5hdHRyQ3JlYXRlZEJ5O1xuICAgIHRoaXMucHJvamVjdCA9IHByb3BzLnByb2plY3Q7XG4gICAgdGhpcy5lbnZpcm9ubWVudEJsdWVwcmludElkID0gcmVzb3VyY2UuYXR0ckVudmlyb25tZW50Qmx1ZXByaW50SWQ7XG4gICAgdGhpcy51cGRhdGVkQXQgPSByZXNvdXJjZS5hdHRyVXBkYXRlZEF0O1xuICAgIHRoaXMuZW52aXJvbm1lbnRJZCA9IHJlc291cmNlLmF0dHJJZDtcbiAgICB0aGlzLnN0YXR1cyA9IHJlc291cmNlLmF0dHJTdGF0dXM7XG4gICAgdGhpcy5uYW1lID0gcHJvcHMubmFtZTtcbiAgICB0aGlzLnByb3ZpZGVyID0gcmVzb3VyY2UuYXR0clByb3ZpZGVyO1xuICAgIHRoaXMuZW52aXJvbm1lbnRQcm9maWxlID0gcHJvcHMuZW52aXJvbm1lbnRQcm9maWxlO1xuICAgIHRoaXMuZG9tYWluSWQgPSByZXNvdXJjZS5hdHRyRG9tYWluSWQ7XG4gICAgdGhpcy5hd3NBY2NvdW50SWQgPSByZXNvdXJjZS5hdHRyQXdzQWNjb3VudElkO1xuICAgIHRoaXMuYXdzQWNjb3VudFJlZ2lvbiA9IHJlc291cmNlLmF0dHJBd3NBY2NvdW50UmVnaW9uO1xuXG4gICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRoaXMsIElTX0VOVklST05NRU5ULCB7IHZhbHVlOiB0cnVlIH0pO1xuICB9XG59Il19