"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentProfile = exports.EnvironmentProfileBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const cdk = require("aws-cdk-lib");
const datazone = require("aws-cdk-lib/aws-datazone");
const environment_1 = require("./environment");
const resource_1 = require("./resource");
const IS_ENVIRONMENT_PROFILE = Symbol.for('amazon-datazone.EnvironmentProfile');
class EnvironmentProfileBase extends resource_1.ResourceBase {
    addEnvironment(id, options) {
        return new environment_1.Environment(this.project, id, {
            ...options,
            name: options.name ?? id,
            environmentProfile: this,
            project: this.project,
        });
    }
}
exports.EnvironmentProfileBase = EnvironmentProfileBase;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentProfileBase[_a] = { fqn: "cdk-data-zone.EnvironmentProfileBase", version: "0.0.0" };
class EnvironmentProfile extends EnvironmentProfileBase {
    constructor(scope, id, props) {
        super(scope, id);
        // check if domain name is 64 characters or less
        if (!cdk.Token.isUnresolved(props.name) && props.name.length > 64) {
            throw new Error('Project name must be 64 characters or less');
        }
        this.awsAccountId = props.awsAccountId ?? cdk.Stack.of(this).account;
        this.awsAccountRegion = props.awsAccountRegion ?? cdk.Stack.of(this).region;
        this.description = props.description;
        const resource = new datazone.CfnEnvironmentProfile(this, 'Resource', {
            domainIdentifier: props.project.projectDomainId,
            projectIdentifier: props.project.projectId,
            name: props.name,
            description: props.description,
            environmentBlueprintIdentifier: props.blueprint.blueprintId,
            awsAccountId: this.awsAccountId,
            awsAccountRegion: this.awsAccountRegion,
            userParameters: props.userParameters,
        });
        this.name = props.name;
        this.createdAt = resource.attrCreatedAt;
        this.createdBy = resource.attrCreatedBy;
        this.project = props.project;
        this.environmentBlueprintId = resource.attrEnvironmentBlueprintId;
        this.updatedAt = resource.attrUpdatedAt;
        this.environmentProfileId = resource.attrId;
        Object.defineProperty(this, IS_ENVIRONMENT_PROFILE, { value: true });
    }
}
exports.EnvironmentProfile = EnvironmentProfile;
_b = JSII_RTTI_SYMBOL_1;
EnvironmentProfile[_b] = { fqn: "cdk-data-zone.EnvironmentProfile", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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