import * as cdk from 'aws-cdk-lib';
import * as datazone from 'aws-cdk-lib/aws-datazone';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { IBlueprint } from './blueprint';
import { Environment } from './environment';
import { IProject } from './project';
import { IResource, ResourceBase } from './resource';
export interface EnvironmentOptions {
    /**
       * The description of the environment.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-description
       */
    readonly description?: string;
    /**
       * The ARN of the environment role.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-environmentrolearn
       */
    readonly environmentRole?: iam.Role;
    /**
       * The glossary terms that can be used in this Amazon  environment.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-glossaryterms
       */
    readonly glossaryTerms?: Array<string>;
    /**
       * The name of the Amazon  environment.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-name
       */
    readonly name?: string;
    /**
       * The user parameters of this Amazon  environment.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environment.html#cfn-datazone-environment-userparameters
       */
    readonly userParameters?: Array<datazone.CfnEnvironment.EnvironmentParameterProperty | cdk.IResolvable> | cdk.IResolvable;
}
export interface EnvironmentProfileProps {
    /**
       * The identifier of an AWS account in which an environment profile exists.
       *
       * @default the  Domain account
       *
       */
    readonly awsAccountId?: string;
    /**
       * The AWS Region in which an environment profile exists.
       *
       * @default the  Domain region
       */
    readonly awsAccountRegion?: string;
    /**
       * The description of the environment profile.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-description
       * @attribute
       */
    readonly description?: string;
    /**
       * The identifier of a blueprint with which an environment profile is created.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-environmentblueprintidentifier
       */
    readonly blueprint: IBlueprint;
    /**
       * The name of the environment profile.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-name
       */
    readonly name: string;
    /**
       * The identifier of a project in which an environment profile exists.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-projectidentifier
       */
    readonly project: IProject;
    /**
       * The user parameters of this Amazon  environment profile.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-userparameters
       */
    readonly userParameters?: Array<datazone.CfnEnvironmentProfile.EnvironmentParameterProperty | cdk.IResolvable> | cdk.IResolvable;
}
export interface IEnvironmentProfile extends IResource {
    readonly awsAccountId: string;
    readonly awsAccountRegion: string;
    readonly name: string;
    readonly description?: string;
    /**
       * The Amazon  user who created the environment profile.
       *
       * @attribute
       */
    readonly createdBy: string;
    /**
       * The identifier of a blueprint with which an environment profile is created.
       *
       * @attribute
       */
    readonly environmentBlueprintId: string;
    /**
       * The identifier of the environment profile.
       *
       * @attribute Id
       */
    readonly environmentProfileId: string;
    /**
       * The identifier of a project in which an environment profile exists.
       *
       * @cloudformationAttribute ProjectId
       */
    readonly project: IProject;
    addEnvironment(id: string, options: EnvironmentOptions): Environment;
}
export declare abstract class EnvironmentProfileBase extends ResourceBase implements IEnvironmentProfile {
    readonly abstract awsAccountId: string;
    readonly abstract awsAccountRegion: string;
    readonly abstract name: string;
    readonly abstract description?: string;
    /**
       * The Amazon  user who created the environment profile.
       *
       * @attribute
       */
    readonly abstract createdBy: string;
    /**
       * The identifier of a blueprint with which an environment profile is created.
       *
       * @attribute
       */
    readonly abstract environmentBlueprintId: string;
    /**
       * The identifier of the environment profile.
       *
       * @attribute Id
       */
    readonly abstract environmentProfileId: string;
    /**
       * The identifier of a project in which an environment profile exists.
       *
       * @cloudformationAttribute ProjectId
       */
    readonly abstract project: IProject;
    addEnvironment(id: string, options: EnvironmentOptions): Environment;
}
export declare class EnvironmentProfile extends EnvironmentProfileBase {
    readonly awsAccountId: string;
    readonly awsAccountRegion: string;
    readonly name: string;
    readonly description?: string;
    /**
       * The timestamp of when an environment profile was created.
       *
       * @attribute
       */
    readonly createdAt: string;
    /**
       * The Amazon  user who created the environment profile.
       *
       * @attribute
       */
    readonly createdBy: string;
    /**
       * The identifier of a blueprint with which an environment profile is created.
       *
       * @attribute
       */
    readonly environmentBlueprintId: string;
    /**
       * The identifier of the environment profile.
       *
       * @attribute Id
       */
    readonly environmentProfileId: string;
    /**
       * The identifier of a project in which an environment profile exists.
       *
       * @cloudformationAttribute ProjectId
       */
    readonly project: IProject;
    /**
       * The timestamp of when the environment profile was updated.
       *
       * @attribute
       */
    readonly updatedAt: string;
    constructor(scope: Construct, id: string, props: EnvironmentProfileProps);
}
