import * as iam from 'aws-cdk-lib/aws-iam';
import * as kms from 'aws-cdk-lib/aws-kms';
import { Construct } from 'constructs';
import { Blueprint } from './blueprint';
import { Forms, Glossaries, Project } from './project';
import { IResource, ResourceBase } from './resource';
export declare enum SingleSignOnType {
    IAM_IDC = "IAM_IDC",
    DISABLED = "DISABLED"
}
export declare enum AssignmentType {
    AUTOMATIC = "AUTOMATIC",
    MANUAL = "MANUAL"
}
export interface SingleSignOn {
    readonly ssoType: SingleSignOnType;
    readonly userAssignment?: AssignmentType;
}
export interface DomainProps {
    /**
       * The description of the Amazon DataZone domain.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-domain.html#cfn-datazone-domain-description
       */
    readonly description?: string;
    /**
       * The domain execution role that is created when an Amazon DataZone domain is created.
       *
       * The domain execution role is created in the AWS account that houses the Amazon DataZone domain.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-domain.html#cfn-datazone-domain-domainexecutionrole
       */
    readonly domainExecutionRole?: iam.Role;
    /**
       * The identifier of the AWS Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-domain.html#cfn-datazone-domain-kmskeyidentifier
       */
    readonly encryptionKey?: kms.IKey;
    /**
       * The name of the Amazon DataZone domain.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-domain.html#cfn-datazone-domain-name
       */
    readonly name: string;
    /**
       * The single sign-on details in Amazon DataZone.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-domain.html#cfn-datazone-domain-singlesignon
       */
    readonly singleSignOn?: SingleSignOn;
    /**
       * The tags specified for the Amazon DataZone domain.
       *
       * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-domain.html#cfn-datazone-domain-tags
       */
    readonly tags?: string[];
}
export interface BlueprintOptions {
    readonly enabledRegions?: string[];
    readonly manageAccessRole?: iam.Role;
    readonly provisioningRole?: iam.Role;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly regionalParameters?: {
        [key: string]: {
            [key: string]: string;
        };
    };
}
export interface ProjectOptions {
    /**
     * The description of a project.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-description
     */
    readonly description?: string;
    /**
     * The glossary terms that can be used in this Amazon  project.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-glossaryterms
     */
    readonly glossaryTerms?: Array<string>;
    /**
     * The name of a project.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-name
     */
    readonly name: string;
    readonly managementRole?: iam.Role;
    readonly forms?: Forms;
    readonly glossaries?: Glossaries;
}
export interface IDomain extends IResource {
    /**
       * @attribute
       */
    readonly domainId: string;
    /**
       * @attribute
       */
    readonly domainArn: string;
    /**
       * @attribute
       */
    readonly portalUrl: string;
    /**
       * @attribute
       */
    readonly managedAccount: string;
    /**
       * @attribute
       */
    readonly status: string;
    addSingleSignOn(singleSignOn: SingleSignOn): void;
    enableBlueprint(blueprintIdentifier: string, options?: BlueprintOptions): Blueprint;
    createProject(id: string, options: ProjectOptions): Project;
}
export declare abstract class DomainBase extends ResourceBase implements IDomain {
    /**
       * @attribute
       */
    readonly abstract domainId: string;
    /**
       * @attribute
       */
    readonly abstract domainArn: string;
    /**
       * @attribute
       */
    readonly abstract portalUrl: string;
    /**
       * @attribute
       */
    readonly abstract managedAccount: string;
    /**
       * @attribute
       */
    readonly abstract status: string;
    abstract addSingleSignOn(singleSignOn: SingleSignOn): void;
    enableBlueprint(blueprintIdentifier: string, options?: BlueprintOptions): Blueprint;
    createProject(id: string, options: ProjectOptions): Project;
}
export declare class Domain extends DomainBase {
    readonly name: string;
    readonly description?: string;
    readonly encryptionKey: kms.IKey;
    readonly domainExecutionRole: iam.Role;
    private _singleSignOn?;
    readonly domainId: string;
    readonly createdAt: string;
    readonly updatedAt: string;
    readonly domainArn: string;
    readonly portalUrl: string;
    readonly managedAccount: string;
    readonly status: string;
    constructor(scope: Construct, id: string, props: DomainProps);
    addSingleSignOn(singleSignOn: SingleSignOn): void;
    private createEncryptionKey;
    private createDomainExecutionRole;
    private createSingleSignOn;
}
