import * as cdk from 'aws-cdk-lib';
import * as datazone from 'aws-cdk-lib/aws-datazone';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as secrets from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { IEnvironment } from './environment';
import { IProject } from './project';
import { ResourceBase, IResource, Schedule, IDataSourceConfiguration } from './resource';
export interface FilterExpression {
    readonly expression: string;
    readonly filterType?: 'INCLUDE' | 'EXCLUDE';
}
export interface FilterConfiguration {
    readonly databaseName: string;
    readonly filterExpressions?: FilterExpression[];
    readonly schemaName?: string;
}
export interface SourceOptions {
    readonly dataAccessRole?: iam.Role;
    readonly filterConfigurations: FilterConfiguration[];
}
export interface GlueOptions extends SourceOptions {
    readonly autoImportDataQualityResult?: boolean;
}
export interface RedshiftOptions extends SourceOptions {
    readonly name: string;
    readonly redshiftType: 'CLUSTER' | 'WORKGROUP';
    readonly credentials: secrets.Secret;
}
export declare abstract class DataSourceConfigurationBase implements IDataSourceConfiguration {
    static fromGlue(options: GlueOptions): IDataSourceConfiguration;
    static fromRedshift(options: RedshiftOptions): IDataSourceConfiguration;
    readonly abstract filterType: string;
    readonly abstract configuration: datazone.CfnDataSource.DataSourceConfigurationInputProperty;
}
export interface DataSourceProps {
    readonly project: IProject;
    readonly environment: IEnvironment;
    readonly name: string;
    readonly enabled?: boolean;
    readonly publishOnImport?: boolean;
    readonly recommendation?: boolean;
    readonly schedule?: Schedule;
    readonly configuration: IDataSourceConfiguration;
    readonly description?: string;
}
export interface IDataSource extends IResource {
    /**
     * The ID of the environment in which the data source exists.
     *
     * @cloudformationAttribute EnvironmentId
     * @attribute
     */
    readonly environment: IEnvironment;
    /**
     * The identifier of the data source run.
     *
     * @cloudformationAttribute Id
     * @attribute
     */
    readonly dataSourceId: string;
    /**
     * The count of the assets created during the last data source run.
     *
     * @cloudformationAttribute LastRunAssetCount
     * @attribute
     */
    readonly lastRunAssetCount: cdk.IResolvable;
    /**
     * The timestamp of when the data source run was last performed.
     *
     * @cloudformationAttribute LastRunAt
     * @attribute
     */
    readonly lastRunAt: string;
    /**
     * The status of the last data source run.
     *
     * @cloudformationAttribute LastRunStatus
     * @attribute
     */
    readonly lastRunStatus: string;
    /**
     * The project ID included in the data source run activity.
     *
     * @cloudformationAttribute ProjectId
     * @attribute
     */
    readonly project: IProject;
    /**
     * The status of the data source.
     *
     * @cloudformationAttribute Status
     * @attribute
     */
    readonly status: string;
}
export declare abstract class DataSourceBase extends ResourceBase implements IDataSource {
    /**
     * The identifier of the data source run.
     *
     * @cloudformationAttribute Id
     * @attribute
     */
    readonly abstract dataSourceId: string;
    /**
     * The ID of the environment in which the data source exists.
     *
     * @cloudformationAttribute EnvironmentId
     * @attribute
     */
    readonly abstract environment: IEnvironment;
    /**
     * The count of the assets created during the last data source run.
     *
     * @cloudformationAttribute LastRunAssetCount
     * @attribute
     */
    readonly abstract lastRunAssetCount: cdk.IResolvable;
    /**
     * The timestamp of when the data source run was last performed.
     *
     * @cloudformationAttribute LastRunAt
     * @attribute
     */
    readonly abstract lastRunAt: string;
    /**
     * The status of the last data source run.
     *
     * @cloudformationAttribute LastRunStatus
     * @attribute
     */
    readonly abstract lastRunStatus: string;
    /**
     * The project ID included in the data source run activity.
     *
     * @cloudformationAttribute ProjectId
     * @attribute
     */
    readonly abstract project: IProject;
    /**
     * The status of the data source.
     *
     * @cloudformationAttribute Status
     * @attribute
     */
    readonly abstract status: string;
}
export declare class DataSource extends DataSourceBase {
    /**
     * The timestamp of when the data source was created.
     *
     * @cloudformationAttribute CreatedAt
     * @attribute
     */
    readonly createdAt: string;
    /**
     * The ID of the environment in which the data source exists.
     *
     * @cloudformationAttribute EnvironmentId
     * @attribute
     */
    readonly environment: IEnvironment;
    /**
     * The identifier of the data source run.
     *
     * @cloudformationAttribute Id
     * @attribute
     */
    readonly dataSourceId: string;
    /**
     * The count of the assets created during the last data source run.
     *
     * @cloudformationAttribute LastRunAssetCount
     * @attribute
     */
    readonly lastRunAssetCount: cdk.IResolvable;
    /**
     * The timestamp of when the data source run was last performed.
     *
     * @cloudformationAttribute LastRunAt
     * @attribute
     */
    readonly lastRunAt: string;
    /**
     * The status of the last data source run.
     *
     * @cloudformationAttribute LastRunStatus
     * @attribute
     */
    readonly lastRunStatus: string;
    /**
     * The project ID included in the data source run activity.
     *
     * @cloudformationAttribute ProjectId
     * @attribute
     */
    readonly project: IProject;
    /**
     * The status of the data source.
     *
     * @cloudformationAttribute Status
     * @attribute
     */
    readonly status: string;
    /**
     * The timestamp of when the data source was updated.
     *
     * @cloudformationAttribute UpdatedAt
     * @attribute
     */
    readonly updatedAt: string;
    readonly name: string;
    readonly enabled: boolean;
    readonly publishOnImport: boolean;
    readonly recommendation: boolean;
    readonly schedule?: Schedule;
    readonly filterType: string;
    readonly description?: string;
    constructor(scope: Construct, id: string, props: DataSourceProps);
}
