"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Blueprint = exports.BlueprintBase = exports.BlueprintEnvironmentIdentifiers = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const cdk = require("aws-cdk-lib");
const datazone = require("aws-cdk-lib/aws-datazone");
const iam = require("aws-cdk-lib/aws-iam");
const resource_1 = require("./resource");
const IS_BLUEPRINT = Symbol.for('amazon-datazone.Blueprint');
class BlueprintEnvironmentIdentifiers {
}
exports.BlueprintEnvironmentIdentifiers = BlueprintEnvironmentIdentifiers;
_a = JSII_RTTI_SYMBOL_1;
BlueprintEnvironmentIdentifiers[_a] = { fqn: "cdk-data-zone.BlueprintEnvironmentIdentifiers", version: "0.0.0" };
BlueprintEnvironmentIdentifiers.DEFAULT_DATA_WAREHOUSE = 'DefaultDataWarehouse';
BlueprintEnvironmentIdentifiers.DEFAULT_DATA_LAKE = 'DefaultDataLake';
class BlueprintBase extends resource_1.ResourceBase {
}
exports.BlueprintBase = BlueprintBase;
_b = JSII_RTTI_SYMBOL_1;
BlueprintBase[_b] = { fqn: "cdk-data-zone.BlueprintBase", version: "0.0.0" };
class Blueprint extends BlueprintBase {
    constructor(scope, id, props) {
        super(scope, id);
        this.domainId = props.domain.domainId;
        this.region = cdk.Stack.of(this).region;
        this.account = cdk.Stack.of(this).account;
        this.enabledRegions = props.enabledRegions || [this.region];
        this.environmentBlueprintIdentifier = props.environmentBlueprintIdentifier;
        this.manageAccessRole = props.manageAccessRole || this.createManagementAccessRole();
        this.provisioningRole = props.provisioningRole || this.createProvisioningRole();
        this._regionalParameters = { ...(props.regionalParameters || {}) };
        this._regionalParameters[this.region] = {
            ...(this._regionalParameters[this.region] ?
                this._regionalParameters[this.region] : {}),
            ...(props.parameters || {}),
        };
        const resource = new datazone.CfnEnvironmentBlueprintConfiguration(this, 'DataLakeBlueprint', {
            domainIdentifier: this.domainId,
            enabledRegions: this.enabledRegions,
            environmentBlueprintIdentifier: this.environmentBlueprintIdentifier,
            manageAccessRoleArn: this.manageAccessRole.roleArn,
            provisioningRoleArn: this.provisioningRole.roleArn,
            regionalParameters: cdk.Lazy.any({
                produce: () => Object.keys(this._regionalParameters).map(region => ({
                    region: region,
                    parameters: cdk.Lazy.any({
                        produce: () => this._regionalParameters[region],
                    }),
                })),
            }),
        });
        this.blueprintId = resource.attrEnvironmentBlueprintId;
        this.createdAt = resource.attrCreatedAt;
        this.updatedAt = resource.attrUpdatedAt;
        Object.defineProperty(this, IS_BLUEPRINT, { value: true });
    }
    addParameters(region, parameters) {
        this._regionalParameters[region] = { ...(this._regionalParameters[region] || {}), ...parameters };
    }
    createManagementAccessRole() {
        return new iam.Role(this, 'DataZoneManagementAccessRole', {
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal('datazone.amazonaws.com'), new iam.ServicePrincipal('cloudformation.amazonaws.com')),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonDataZoneGlueManageAccessRolePolicy'),
            ],
        });
    }
    createProvisioningRole() {
        return new iam.Role(this, 'DataZoneProvisioningRole', {
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal('datazone.amazonaws.com').withConditions({
                StringEquals: {
                    'aws:SourceAccount': this.account,
                },
            }), new iam.ServicePrincipal('cloudformation.amazonaws.com').withConditions({
                StringEquals: {
                    'aws:SourceAccount': this.account,
                },
            })),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonDataZoneRedshiftGlueProvisioningPolicy'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSGlueConsoleFullAccess'),
            ],
        });
    }
}
exports.Blueprint = Blueprint;
_c = JSII_RTTI_SYMBOL_1;
Blueprint[_c] = { fqn: "cdk-data-zone.Blueprint", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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