import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { IDomain } from './domain';
import { ResourceBase, IResource } from './resource';
export declare class BlueprintEnvironmentIdentifiers {
    static readonly DEFAULT_DATA_WAREHOUSE: string;
    static readonly DEFAULT_DATA_LAKE: string;
}
export interface BlueprintProps {
    readonly domain: IDomain;
    readonly environmentBlueprintIdentifier: string;
    readonly enabledRegions?: string[];
    readonly manageAccessRole?: iam.Role;
    readonly provisioningRole?: iam.Role;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly regionalParameters?: {
        [key: string]: {
            [key: string]: string;
        };
    };
}
export interface IBlueprint extends IResource {
    /**
       * @attribute
       */
    readonly blueprintId: string;
    addParameters(region: string, parameters: {
        [key: string]: string;
    }): void;
}
export declare abstract class BlueprintBase extends ResourceBase implements IBlueprint {
    /**
       * @attribute
       */
    readonly abstract blueprintId: string;
    abstract addParameters(region: string, parameters: {
        [key: string]: string;
    }): void;
}
export declare class Blueprint extends BlueprintBase {
    private region;
    private account;
    readonly domainId: string;
    readonly enabledRegions: string[];
    readonly environmentBlueprintIdentifier: string;
    readonly manageAccessRole: iam.Role;
    readonly provisioningRole: iam.Role;
    private _regionalParameters;
    readonly blueprintId: string;
    readonly createdAt: string;
    readonly updatedAt: string;
    constructor(scope: Construct, id: string, props: BlueprintProps);
    addParameters(region: string, parameters: {
        [key: string]: string;
    }): void;
    private createManagementAccessRole;
    private createProvisioningRole;
}
