import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "cdk-data-zone",
    "version": "0.0.0",
    "description": "AWS DataZone L2 Construct library",
    "license": "Apache-2.0",
    "url": "https://github.com/cdklabs/cdk-data-zone.git",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services<aws-cdk-dev@amazon.com>",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/cdklabs/cdk-data-zone.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "cdk_data_zone",
        "cdk_data_zone._jsii"
    ],
    "package_data": {
        "cdk_data_zone._jsii": [
            "cdk-data-zone@0.0.0.jsii.tgz"
        ],
        "cdk_data_zone": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.8",
    "install_requires": [
        "aws-cdk-lib>=2.160.0, <3.0.0",
        "constructs>=10.0.46, <11.0.0",
        "jsii>=1.103.1, <2.0.0",
        "publication>=0.0.3",
        "typeguard>=2.13.3,<5.0.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Typing :: Typed",
        "Development Status :: 4 - Beta",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
