#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.add_rule_input import AddRuleInput


# fmt: off
QUERY: List[str] = ["""
mutation addRule($input: AddRuleInput!) {
  addRule(input: $input) {
    id
    name
		gracePeriod
		ruleType {id}
		eventTypeName
		specificProblem
		additionalInfo
		status
		eventSeverity{id}
		threshold{id}

  }
}
"""
]


class addRule:
    @dataclass(frozen=True)
    class addRuleData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Rule(DataClassJsonMixin):
            @dataclass(frozen=True)
            class RuleType(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class EventSeverity(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class Threshold(DataClassJsonMixin):
                id: str

            id: str
            name: str
            gracePeriod: Optional[int]
            ruleType: RuleType
            eventTypeName: Optional[str]
            specificProblem: Optional[str]
            additionalInfo: Optional[str]
            status: bool
            eventSeverity: EventSeverity
            threshold: Threshold

        addRule: Rule

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: AddRuleInput) -> addRuleData.Rule:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addRuleData.from_dict(response_text)
        return res.addRule

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: AddRuleInput) -> addRuleData.Rule:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addRuleData.from_dict(response_text)
        return res.addRule
