# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-05-19 19:02
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import sortedm2m.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ChineseWord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('english_word', models.CharField(help_text=b'English version of the word.', max_length=64)),
                ('pinyin_word', models.CharField(blank=True, default=b'', help_text=b'Hanyu Pinyin representation of the word.', max_length=64)),
                ('chinese_word', models.CharField(blank=True, default=b'', help_text=b'Simplified Chinese representation of the word.', max_length=64)),
            ],
            options={
                'ordering': ['english_word'],
            },
        ),
        migrations.CreateModel(
            name='FortuneCookie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('fortune', models.CharField(help_text=b'Confucious say...', max_length=255)),
                ('chinese_word', models.ForeignKey(blank=True, default=None, help_text=b'Learn Chinese.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='fortune_cookies', to='fortunecookie.ChineseWord')),
            ],
            options={
                'ordering': ['fortune'],
            },
        ),
        migrations.CreateModel(
            name='LuckyNumber',
            fields=[
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('number', models.IntegerField(help_text=b'The lucky number.', primary_key=True, serialize=False)),
            ],
            options={
                'ordering': ['number'],
            },
        ),
        migrations.AddField(
            model_name='fortunecookie',
            name='lucky_numbers',
            field=sortedm2m.fields.SortedManyToManyField(help_text=b'Lucky numbers.', related_name='fortune_cookies', to='fortunecookie.LuckyNumber'),
        ),
        migrations.AlterUniqueTogether(
            name='chineseword',
            unique_together=set([('english_word', 'pinyin_word')]),
        ),
    ]
