# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fossology']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.22.0', 'tenacity>=6.0.0']

setup_kwargs = {
    'name': 'fossology',
    'version': '1.0.0',
    'description': 'A library to automate Fossology from Python scripts',
    'long_description': '|License| |PyPI Version| |Python Version| |Static Checks| |Fossology Tests| |Coverage|\n\n.. |License| image:: https://img.shields.io/badge/license-MIT-blue.svg\n   :target: https://github.com/deveaud-m/fossology-python/LICENSE.md\n\n.. |PyPI Version| image:: https://badge.fury.io/py/fossology.svg\n   :target: https://pypi.org/project/fossology\n\n.. |Python Version| image:: https://img.shields.io/badge/python-3.7%2C3.8%2C3.9-blue?logo=python\n   :target: https://www.python.org/doc/versions/\n\n.. |Static Checks| image:: https://github.com/deveaud-m/fossology-python/workflows/Static%20Checks/badge.svg\n   :target: https://github.com/deveaud-m/fossology-python/actions?query=workflow%3A%22Static+Checks%22\n   \n.. |Fossology Tests| image:: https://github.com/deveaud-m/fossology-python/workflows/Fossology%20Tests/badge.svg\n   :target: https://github.com/deveaud-m/fossology-python/actions?query=workflow%3A%22Fossology+Tests%22\n\n.. |Coverage| image:: https://codecov.io/gh/fossology/fossology-python/branch/master/graph/badge.svg\n   :target: https://codecov.io/gh/fossology/fossology-python\n\nA simple wrapper for the Fossology REST API.\n\nSee `the OpenAPI specification <https://raw.githubusercontent.com/fossology/fossology/master/src/www/ui/api/documentation/openapi.yaml>`_ used to implement this library.\n\n   Compatible with API version 1.1.1\n\nDocumentation\n=============\n\nSee `fossology-python on Github Pages <https://fossology.github.io/fossology-python>`_.\n\nUsage\n=====\n\nInstallation\n------------\n\n   This project is available as `Python package on PyPi.org <https://pypi.org/project/fossology/>`_.\n\n-  Install fossology and required dependencies:\n\n   .. code:: shell\n\n      pip install fossology requests\n\nUsing the API\n-------------\n\n-  Get a REST API token either from the Fossology server under "User->Edit user account" or generate a token using the method available in this library:\n\n   .. code:: Python\n\n      from fossology import fossology_token\n      from fossology.obj import TokenScope\n\n      FOSSOLOGY_SERVER = "https://fossology.example.com/"\n      FOSSOLOGY_USER = "fossy"\n      FOSSOLOGY_PASSWORD = "fossy"\n      TOKEN_NAME = "fossy_token"\n\n      token = fossology_token(\n            FOSSOLOGY_SERVER,\n            FOSSOLOGY_USER,\n            FOSSOLOGY_PASSWORD,\n            TOKEN_NAME,\n            TokenScope.WRITE\n      )\n\n-  Start using the API:\n\n   .. code:: python\n\n      from fossology import Fossology\n\n      foss = Fossology(\n            FOSSOLOGY_SERVER,\n            token,\n            FOSSOLOGY_USER\n      )\n\n\nContribute\n==========\n\nDevelop\n-------\n\n-  All contributions in form of bug reports, feature requests or merge requests!\n\n-  Use proper\n   `docstrings <https://realpython.com/documenting-python-code/>`__ to\n   document functions and classes\n\n-  Extend the testsuite **poetry run pytest** with the new functions/classes\n\n-  The **documentation website** can automatically be generated by the `Sphinx autodoc\n   extension <http://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html>`_\n\n\nBuild\n-----\n\n- You can build the PyPi package using `poetry <https://poetry.eustace.io/>`_:\n\n  .. code:: shell\n\n    poetry build\n\n- Build documentation (the generated static site must be pushed to the **gh-pages** branch):\n\n  .. code:: shell\n\n     git clone -b gh-pages git@github.com:fossology/fossology-python.git docs/\n     poetry run sphinx-build docs-source docs/\n     cd docs/\n     # Create a new branch to be merged into gh-pages and commit your changes\n\n- Cleanup builds:\n\n  .. code:: shell\n\n     rm -r dist/ docs/\n\nTag\n----\n\nEach new release gets a new tag with important information about the changes added to the new release:\n\n.. code:: shell\n\n   git tag -a vx.x.x -m "New major/minor/patch release x.x.x"\n   git push origin vx.x.x\n\nAdd required information in the corresponding `release in the Github project <https://github.com/fossology/fossology-python/releases>`_.\n\n\nTest\n----\n\nThe testsuite available in this project expects a running Fossology instance under the hostname **fossology** with the default admin user "fossy".\n\n- Use the latest Fossology container from `Docker hub <https://hub.docker.com/r/fossology/fossology>`_:\n\n  .. code:: shell\n\n    docker pull fossology/fossology\n    docker run --name fossology -p 80:80 fossology/fossology\n\n- Start the complete test suite or a specific test case (and generate coverage report):\n\n  .. code:: shell\n\n     poetry run coverage run --source=fossology -m pytest\n     poetry run coverage report -m\n     poetry run coverage html\n',
    'author': 'Marion Deveaud',
    'author_email': 'marion.deveaud@siemens.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fossology/fossology-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
