"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var LifecycleLabel;
(function (LifecycleLabel) {
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
const DEFAULT_NODE_SELECTOR = { lifecycle: LifecycleLabel.SPOT };
function spotInterruptHandler(nodeSelector = DEFAULT_NODE_SELECTOR) {
    return [
        {
            kind: "ClusterRole",
            apiVersion: "rbac.authorization.k8s.io/v1",
            metadata: {
                name: "node-termination-handler",
                namespace: "default"
            },
            rules: [
                {
                    apiGroups: [
                        "apps"
                    ],
                    resources: [
                        "daemonsets"
                    ],
                    verbs: [
                        "get",
                        "delete"
                    ]
                },
                {
                    apiGroups: [
                        ""
                    ],
                    resources: [
                        "*"
                    ],
                    verbs: [
                        "*"
                    ]
                },
                {
                    apiGroups: [
                        "rbac.authorization.k8s.io"
                    ],
                    resources: [
                        "*"
                    ],
                    verbs: [
                        "*"
                    ]
                },
                {
                    apiGroups: [
                        "apiextensions.k8s.io"
                    ],
                    resources: [
                        "customresourcedefinitions"
                    ],
                    verbs: [
                        "get",
                        "list",
                        "watch",
                        "create",
                        "delete"
                    ]
                }
            ]
        },
        {
            apiVersion: "v1",
            kind: "ServiceAccount",
            metadata: {
                name: "node-termination-handler"
            }
        },
        {
            kind: "ClusterRoleBinding",
            apiVersion: "rbac.authorization.k8s.io/v1",
            metadata: {
                name: "node-termination-handler",
                namespace: "default"
            },
            subjects: [
                {
                    kind: "ServiceAccount",
                    name: "node-termination-handler",
                    namespace: "default"
                }
            ],
            roleRef: {
                kind: "ClusterRole",
                name: "node-termination-handler",
                apiGroup: "rbac.authorization.k8s.io"
            }
        },
        {
            apiVersion: "apps/v1beta2",
            kind: "DaemonSet",
            metadata: {
                name: "node-termination-handler",
                namespace: "default"
            },
            spec: {
                selector: {
                    matchLabels: {
                        app: "node-termination-handler"
                    }
                },
                template: {
                    metadata: {
                        labels: {
                            app: "node-termination-handler"
                        }
                    },
                    spec: {
                        serviceAccountName: "node-termination-handler",
                        containers: [
                            {
                                name: "node-termination-handler",
                                image: "amazon/aws-node-termination-handler:v1.0.0",
                                imagePullPolicy: "Always",
                                env: [
                                    {
                                        name: "NODE_NAME",
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: "spec.nodeName"
                                            }
                                        }
                                    },
                                    {
                                        name: "POD_NAME",
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: "metadata.name"
                                            }
                                        }
                                    },
                                    {
                                        name: "NAMESPACE",
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: "metadata.namespace"
                                            }
                                        }
                                    },
                                    {
                                        name: "SPOT_POD_IP",
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: "status.podIP"
                                            }
                                        }
                                    }
                                ],
                                resources: {
                                    requests: {
                                        memory: "64Mi",
                                        cpu: "50m"
                                    },
                                    limits: {
                                        memory: "128Mi",
                                        cpu: "100m"
                                    }
                                }
                            }
                        ],
                        nodeSelector
                    }
                }
            }
        }
    ];
}
exports.spotInterruptHandler = spotInterruptHandler;
//# sourceMappingURL=data:application/json;base64,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