import { NestedStack } from '@aws-cdk/aws-cloudformation';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
import * as cr from '@aws-cdk/custom-resources';
export declare class KubectlProvider extends NestedStack {
    /**
     * Creates a stack-singleton resource provider nested stack.
     */
    static getOrCreate(scope: Construct): KubectlProvider;
    /**
     * The custom resource provider.
     */
    readonly provider: cr.Provider;
    /**
     * The IAM role used to execute this provider.
     */
    readonly role: iam.IRole;
    private constructor();
}
