"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props = {}) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType, (_a !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE))
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName, (_c !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'))), (_d = props.defaultProfile, (_d !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ]
        })));
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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