# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/retraitement_erfs-fpr/modules/inflate_and_noise.ipynb (unless otherwise specified).

__all__ = [
    "config",
    "total_annuel_salaires",
    "projection_salaires",
    "inflation_idc",
    "inflation_insee",
    "revalorisation_retraite",
    "reval_chomage",
    "inflation_economique",
    "nb_foyers_par_annee",
    "projection_foyers",
    "calib_initiale_ff",
    "inflation_foyers",
    "bruitage",
]

# Cell
import numpy as np
from leximpact_socio_fisca_simu_etat.config import Configuration
from sklearn.linear_model import LinearRegression

from .toolbase import individus_to_foyers_fiscaux

config = Configuration(project_folder="leximpact-prepare-data")

# Cell

# Données d'input
# Source : https://www.impots.gouv.fr/portail/statistiques > Impot des Particuliers > Par région > National.xls
#   > Traitements et salaires > Montant
# NB: on garde un historique https://cloud.leximpact.dev/index.php/f/13618
total_annuel_salaires = {
    "2004": 505_413_219_971,
    "2005": 521_074_208_677,
    "2006": 535_224_289_868,
    "2007": 555_718_533_592,
    "2008": 576_696_329_635,
    "2009": 598_350_414_779,
    "2010": 603_748_075_702,
    "2011": 621_113_771_549,
    "2012": 638_494_009_748,
    "2013": 651_235_711_284,
    "2014": 664_720_821_400,
    "2015": 674_188_954_200,
    "2016": 683_665_874_000,
    "2017": 695_665_787_000,
    "2018": 713_523_524_000,
    "2019": 738_077_177_000,
    "2020": 743_185_656_000,
}

# Cell

# Regression linéaire pour estimer les salaires des années futures
def projection_salaires(yearf):
    salaires_annuels = total_annuel_salaires.copy()

    last_known = int(list(total_annuel_salaires.keys())[-1])
    print(
        "Attention, les années au-dessus de ",
        last_known,
        " sont estimées par régression linéaire",
    )

    # Linear Regression
    # X = np.array([int(i) for i in range(len(inflation_sal.values()))]).reshape(-1, 1)
    X = np.array([int(i) for i in total_annuel_salaires.keys()]).reshape(-1, 1)
    Y = np.array([float(i) for i in total_annuel_salaires.values()]).reshape(-1, 1)

    model = LinearRegression().fit(X, Y)
    for year in range(last_known + 1, yearf + 1):
        to_predict = np.array(year).reshape(-1, 1)
        prediction = model.predict(to_predict)[0][0]
        salaires_annuels[str(year)] = prediction

    return salaires_annuels


# Cell

# Création de la liste des taux d'inflation (en %)
# Données issues du PLF - 'Chiffres clés' (=inflation hors tabac = prix à la consommation)
inflation_idc = {
    "2017": 1.0,
    "2018": 1.6,
    "2019": 0.9,
    "2020": 0.2,
    "2021": 1.4,
    "2022": 1.5,  # Estimation PLF 2022
    "2023": 1.5,  # Estimation PLFSS 2022
    "2024": 1.6,  # Estimation PLFSS 2022
    "2025": 1.8,  # Estimation PLFSS 2022
}

# Cell

# Pour info, pas utilisé dans ce code:
# Création de la liste des taux d'inflation (en %)
# Source: https://www.insee.fr/fr/statistiques/2122401#tableau-figure1
inflation_insee = {
    "2009": 0.1,
    "2010": 1.5,
    "2011": 2.0,
    "2012": 2.0,
    "2013": 0.9,
    "2014": 0.5,
    "2015": 0.0,
    "2016": 0.2,
    "2017": 1.0,
    "2018": 1.8,
    "2019": 1.1,
    "2020": 0.5,
    "2021": 0.85,  # Estimation à partir du PLFSS 2021
}

# Cell

# Création de la liste des taux d'inflation (en %)
# Source : https://www.ipp.eu/baremes-ipp/regimes-de-retraites/0/0/reval_p/
# On ne traite que le cas du régime général privé
revalorisation_retraite = {
    "2015": 0.1,
    "2016": 0.0,
    "2017": 0.8,
    "2018": 0.0,
    "2019": 0.3,
    "2020": 0.3,
    "2021": 0.4,
}

# Cell


# Création de la liste des taux d'inflation (en %)
# Source : https://www.ipp.eu/baremes-ipp/chomage/allocations_assurance_chomage/sr_alloc/
reval_chomage = {
    "2017": 0.65,
    "2018": 0.7,
    "2019": 0.7,
    "2020": 0.4,
    "2021": 0.6,  # https://www.service-public.fr/particuliers/actualites/A15021
}

# Cell


def inflation_economique(inputfile, to_inflate, startp, endp):

    """
    On distingue différents types d'inflation:
        - l'inflation observée des salaires
        - l'inflation économique, dite inflation de l'indice des prix à la consommation (IDC)
        - l'inflation des retraites, liée à l'augmentation des points de retraite
    """

    final = inputfile.copy()
    print("Colonnes qui subissent l'inflation : ", to_inflate)

    # 1 - DONNEES
    # 1.1- CALCUL DE L'INFLATION TYPE "SALARIAL"
    cols_type_salarial = [
        "pensions_alimentaires_percues",
        "rag",
        "ric",
        "rnc",
        "salaire_de_base",
        "taxe_habitation",
        "rfr",
        "salaire_imposable",
    ]

    adjrate_sal = 1
    total_annuel_salaires_proj = projection_salaires(endp)
    # Calcul du taux d'inflation
    annees_connues = list(total_annuel_salaires_proj.keys())
    annees_connues.remove(annees_connues[0])  # On supprime l'année 1
    inflation_sal_proj = {}
    for year in annees_connues:
        inflation_sal_proj[year] = (
            total_annuel_salaires_proj[year]
            / total_annuel_salaires_proj[str(int(year) - 1)]
        )
    # Calcul du taux d'ajustement
    for year in range(startp + 1, endp + 1):
        adjrate_sal = adjrate_sal * inflation_sal_proj[str(year)]

    # 1.2 - INFLATION ECONOMIQUE
    cols_type_idc = [
        "f4ba",
        "loyer",
        "revenus_capitaux_prelevement_bareme",
        "revenus_capitaux_prelevement_liberatoire",
        "revenus_capitaux_prelevement_forfaitaire_unique_ir",
    ]

    # Calcul du taux d'inflation economique sur plusieurs années
    adjrate_eco = 1
    for year in range(startp, endp):
        rateinfla = inflation_idc[str(year)]
        adjrate_eco = adjrate_eco * (1 + rateinfla / 100)  # Car on a les données en %
    print("Taux d'ajustement economique : ", adjrate_eco)

    # 1.3 REVALORISATION DES RETRAITES
    cols_retraite = ["retraite_brute", "pre_retraite"]

    # Calcul du taux d'inflation des retraites sur plusieurs années
    adjrate_ret = 1
    for year in range(startp, endp):
        print(year)
        rateinfla = revalorisation_retraite[str(year)]
        adjrate_ret = adjrate_ret * (1 + rateinfla / 100)  # Car on a les données en %
    print("Taux d'ajustement de revalorisation des retraites: ", adjrate_ret)

    # 1.4 REVALORISATION DU CHOMAGE
    cols_chomage = ["chomage_brut"]

    # Calcul du taux d'inflation du chomage sur plusieurs années
    adjrate_chom = 1
    for year in range(startp, endp):
        rateinfla = reval_chomage[str(year)]
        adjrate_chom = adjrate_chom * (1 + rateinfla / 100)  # Car on a les données en %
    print("Taux d'ajustement de revalorisation du chômage: ", adjrate_chom)

    # 2 - ON INFLATE
    for col in to_inflate:
        # 2.1 - Type 'salarial'
        if col in cols_type_salarial:
            adjrate = adjrate_sal
        # 2.2 - Type IDC
        elif col in cols_type_idc:
            adjrate = adjrate_eco
        # 2.3 - Type retraite
        elif col in cols_retraite:
            adjrate = adjrate_ret
        # 2.4 - Type chomage
        elif col in cols_chomage:
            adjrate = adjrate_chom

        # Inflation de la colonne
        print("Taux d'ajustement de ", col, " : ", adjrate)
        print("Somme de ", col, " avant inflation ", (final[col] * final["wprm"]).sum())
        final[col] = final[col] * adjrate
        print("Somme de ", col, " apres inflation ", (final[col] * final["wprm"]).sum())

    return final


# Cell

"""
Nombre de foyers fiscaux
Source: https://www.impots.gouv.fr/portail/statistiques
> Impôts des particuliers
    > Impôt sur le revenu par région, département ou commune
        > National 2013
            > Excel 2013 : Nombre total foyers fiscaux en 2012
"""

nb_foyers_par_annee = {
    "2011": 36_389_256,
    "2012": 36_720_036,
    "2013": 37_119_219,
    "2014": 37_429_459,
    "2015": 37_683_595,
    "2016": 37_889_181,
    "2017": 38_332_977,
    "2018": 38_549_926,
    "2019": 39_331_689,
}

# Cell

# Regression linéaire pour estimer le nombre de foyers des années futures
def projection_foyers(yearf):
    nb_foyers = nb_foyers_par_annee.copy()

    last_known = int(list(nb_foyers.keys())[-1])
    print(
        "Attention, les années au-dessus de ",
        last_known,
        " sont estimées par régression linéaire",
    )

    # Linear Regression
    X = np.array([int(i) for i in nb_foyers_par_annee.keys()]).reshape(-1, 1)
    Y = np.array([float(i) for i in nb_foyers_par_annee.values()]).reshape(-1, 1)

    model = LinearRegression().fit(X, Y)
    for year in range(last_known + 1, yearf + 1):
        to_predict = np.array(year).reshape(-1, 1)
        prediction = model.predict(to_predict)[0][0]
        nb_foyers[str(year)] = prediction

    return nb_foyers


# Cell


def calib_initiale_ff(erfs_ind, year_init):
    # TODO : ici on pourrait envisager de faire un calage sur marges (en sortant la distribution en nb de gens de POTE)

    # Nombre de foyers fiscaux dans la base
    erfs_ff = individus_to_foyers_fiscaux(erfs_ind)
    total_ff = erfs_ff["wprm"].sum()

    # Nombre véritable de foyers fiscaux l'année de la base
    nb_foyers_proj = projection_foyers(int(year_init))
    wanted_ff = nb_foyers_proj[str(year_init)]
    print(
        "On recalibre la base initiale sur la valeur connue de foyers fiscaux en ",
        year_init,
        " c'est-à-dire: ",
        wanted_ff,
        "foyers",
    )

    # Facteur de correction
    init_ff = wanted_ff / total_ff

    # On actualise les poids
    erfs_ind["wprm"] = erfs_ind["wprm"] * init_ff

    return erfs_ind


# Cell

# NB: Pour éviter une réintégration compliquée de la modification des poids de la base en ff vers la base individus,
# la fonction produit les deux bases en même temps


def inflation_foyers(erfs_ind, year_start, year_end):

    final_ff = individus_to_foyers_fiscaux(erfs_ind).copy()
    final_ind = erfs_ind.copy()

    nb_foyers_proj = projection_foyers(year_end)

    # Inflation du nombre de foyers fiscaux
    InflaFF = nb_foyers_proj[str(year_end)] / (final_ff["wprm"].sum())
    print("Taux d'inflation ff: ", InflaFF)
    print("Objectif de foyers fiscaux ", nb_foyers_proj[str(year_end)])

    # Inflation des poids des 2 bases
    print("Nb de foyers fiscaux avant inflation : ", final_ff["wprm"].sum())
    final_ff["wprm"] = final_ff["wprm"] * InflaFF
    final_ind["wprm"] = final_ind["wprm"] * InflaFF
    print("Nb de foyers fiscaux après inflation : ", final_ff["wprm"].sum())

    return final_ff, final_ind


# Cell


def bruitage(erfs):
    # Liste des variables à bruiter
    to_noise = [
        "chomage_brut",
        "pensions_alimentaires_percues",
        "rag",
        "ric",
        "rnc",
        "salaire_de_base",
        "f4ba",
        "loyer",
        "taxe_habitation",
        "retraite_brute",
    ]
    # On utilise une loi normale / gaussienne d'écart-type sigma
    sigma = 0.02

    # Bruitage
    for var_noised in to_noise:
        if var_noised in erfs.columns:
            print(f"On bruite:  {var_noised}")
            sig = erfs[var_noised]
            noise = np.random.lognormal(-sigma * sigma / 2, sigma, [len(erfs)])
            adjed = sig * noise
            print(
                "Somme avant bruitage : ",
                sum(sig),
                "\n Moyenne de la loi gaussienne : ",
                sum(noise) / len(noise),
                "\n Somme bruitée : ",
                sum(adjed),
            )
            erfs[var_noised] = adjed

    return erfs
