"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnProjectIpAccessList = exports.toJson_ApiKeyDefinition = exports.toJson_AccessListDefinition = exports.toJson_CfnProjectIpAccessListProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnProjectIpAccessListProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnProjectIpAccessListProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccessList': obj.accessList?.map(y => toJson_AccessListDefinition(y)),
        'ApiKeys': toJson_ApiKeyDefinition(obj.apiKeys),
        'ProjectId': obj.projectId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnProjectIpAccessListProps = toJson_CfnProjectIpAccessListProps;
/**
 * Converts an object of type 'AccessListDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AccessListDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AwsSecurityGroup': obj.awsSecurityGroup,
        'CIDRBlock': obj.cidrBlock,
        'Comment': obj.comment,
        'IPAddress': obj.ipAddress,
        'ProjectId': obj.projectId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AccessListDefinition = toJson_AccessListDefinition;
/**
 * Converts an object of type 'ApiKeyDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ApiKeyDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'PrivateKey': obj.privateKey,
        'PublicKey': obj.publicKey,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ApiKeyDefinition = toJson_ApiKeyDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `MongoDB::Atlas::ProjectIpAccessList`
 *
 * @cloudformationResource MongoDB::Atlas::ProjectIpAccessList
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
class CfnProjectIpAccessList extends cdk.CfnResource {
    /**
     * Create a new `MongoDB::Atlas::ProjectIpAccessList`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnProjectIpAccessList.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnProjectIpAccessListProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrTotalCount = cdk.Token.asNumber(this.getAtt('TotalCount'));
    }
}
exports.CfnProjectIpAccessList = CfnProjectIpAccessList;
_a = JSII_RTTI_SYMBOL_1;
CfnProjectIpAccessList[_a] = { fqn: "@cdk-cloudformation/mongodb-atlas-projectipaccesslist.CfnProjectIpAccessList", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnProjectIpAccessList.CFN_RESOURCE_TYPE_NAME = "MongoDB::Atlas::ProjectIpAccessList";
//# sourceMappingURL=data:application/json;base64,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