import argparse
import nrresqml
from time import perf_counter


parser = argparse.ArgumentParser(prog='python -m nrresqml', description='Convert Delft3D output to ResQml')
parser.add_argument(
    'delft3d_file', metavar='<delft-3d-file>', help='Input file generated by Delft3D'
)
parser.add_argument(
    'resqml_directory', metavar='<resqml_directory>', help='Destination directory for the ResQml output'
)

args = parser.parse_args()
t0 = perf_counter()
nrresqml.convert_delft3d_to_resqml(args.delft3d_file, args.resqml_directory)
t1 = perf_counter()
print(f'Conversion completed in {t1 - t0} s')
