"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwapUsageMomiton = void 0;
const cdk = require("@aws-cdk/core");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// Reference: https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheMetrics.WhichShouldIMonitor.html#metrics-swap-usage
class SwapUsageMomiton {
    static setup(scope, cacheClusterId) {
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-SwapUsage', {
            alarmName: `ElasticCacheSwapUsageAlarm[${cacheClusterId}]`,
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'SwapUsage',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'max',
            }),
            threshold: 52430000,
            period: cdk.Duration.minutes(1),
            evaluationPeriods: 1,
            alarmDescription: 'The maximum value of the swapUsage within one minute is higher than 50MB.',
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.SwapUsageMomiton = SwapUsageMomiton;
//# sourceMappingURL=data:application/json;base64,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