#!/usr/bin/env python3
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
'''
Create MRS Job with attributes
'''
import openstack

openstack.enable_logging(True)
conn = openstack.connect(cloud='otc')

attrs = {
    "name": "my-mapreduce-job",
    "mains": [],
    "libs": [
        "092b628b-26a3-4571-9ba4-f8d000df8877"
    ],
    "is_protected": False,
    "interface": [],
    "is_public": False,
    "type": "MapReduce",
    "description": "This is the Map Reduce job template"
}

job = conn.mrs.create_job(**attrs)
print(job)
