# logrun

A package for experiment logging in Python.

Features include:

- Stores relevant source code (only what is necessary) with the experiments automatically;
- Easily fetch the experiments that generated a given file;
- Easily fetch the experiments that were generated by a given script;
- Shouldn't use tons of storage;
- Everything runs locally -- no possibly-sketchy third-party will be getting aceess to your code and experiments.

## Example usage

The following example trains a model and registers an experiment that outputed the file `trained_model.pth`:

```python
from logrun.utils.general import outpath
import pickle


...  # your experiment, yada yada yada
model = ...
...  # your experiment, yada yada yada

model.save(outpath("trained_model.pth"))
```

Note that you only needed to import the module and use the `outpath` function here. Everything else is neatly encapsulated in the `logrun.internals` module.

## Documentation

The documentation is available at [https://dccsillag.github.io/logrun/logrun/](https://dccsillag.github.io/logrun/logrun/).

To generate it manually, use [`pdoc3`](https://pdoc3.github.io/pdoc/):

```sh
pdoc --html logrun -o docs
```
