"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import temporalio.api.common.v1.message_pb2
import temporalio.api.failure.v1.message_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class ActivityExecutionResult(google.protobuf.message.Message):
    """*
    Used to report activity completions to core
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPLETED_FIELD_NUMBER: builtins.int
    FAILED_FIELD_NUMBER: builtins.int
    CANCELLED_FIELD_NUMBER: builtins.int
    WILL_COMPLETE_ASYNC_FIELD_NUMBER: builtins.int
    @property
    def completed(self) -> global___Success: ...
    @property
    def failed(self) -> global___Failure: ...
    @property
    def cancelled(self) -> global___Cancellation: ...
    @property
    def will_complete_async(self) -> global___WillCompleteAsync: ...
    def __init__(
        self,
        *,
        completed: global___Success | None = ...,
        failed: global___Failure | None = ...,
        cancelled: global___Cancellation | None = ...,
        will_complete_async: global___WillCompleteAsync | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "cancelled",
            b"cancelled",
            "completed",
            b"completed",
            "failed",
            b"failed",
            "status",
            b"status",
            "will_complete_async",
            b"will_complete_async",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cancelled",
            b"cancelled",
            "completed",
            b"completed",
            "failed",
            b"failed",
            "status",
            b"status",
            "will_complete_async",
            b"will_complete_async",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["status", b"status"]
    ) -> (
        typing_extensions.Literal[
            "completed", "failed", "cancelled", "will_complete_async"
        ]
        | None
    ): ...

global___ActivityExecutionResult = ActivityExecutionResult

class ActivityResolution(google.protobuf.message.Message):
    """Used to report activity resolutions to lang. IE: This is what the activities are resolved with
    in the workflow.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPLETED_FIELD_NUMBER: builtins.int
    FAILED_FIELD_NUMBER: builtins.int
    CANCELLED_FIELD_NUMBER: builtins.int
    BACKOFF_FIELD_NUMBER: builtins.int
    @property
    def completed(self) -> global___Success: ...
    @property
    def failed(self) -> global___Failure: ...
    @property
    def cancelled(self) -> global___Cancellation: ...
    @property
    def backoff(self) -> global___DoBackoff: ...
    def __init__(
        self,
        *,
        completed: global___Success | None = ...,
        failed: global___Failure | None = ...,
        cancelled: global___Cancellation | None = ...,
        backoff: global___DoBackoff | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "backoff",
            b"backoff",
            "cancelled",
            b"cancelled",
            "completed",
            b"completed",
            "failed",
            b"failed",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "backoff",
            b"backoff",
            "cancelled",
            b"cancelled",
            "completed",
            b"completed",
            "failed",
            b"failed",
            "status",
            b"status",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["status", b"status"]
    ) -> (
        typing_extensions.Literal["completed", "failed", "cancelled", "backoff"] | None
    ): ...

global___ActivityResolution = ActivityResolution

class Success(google.protobuf.message.Message):
    """* Used to report successful completion either when executing or resolving"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
    def __init__(
        self,
        *,
        result: temporalio.api.common.v1.message_pb2.Payload | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> None: ...

global___Success = Success

class Failure(google.protobuf.message.Message):
    """* Used to report activity failure either when executing or resolving"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILURE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    def __init__(
        self,
        *,
        failure: temporalio.api.failure.v1.message_pb2.Failure | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> None: ...

global___Failure = Failure

class Cancellation(google.protobuf.message.Message):
    """*
    Used to report cancellation from both Core and Lang.
    When Lang reports a cancelled activity, it must put a CancelledFailure in the failure field.
    When Core reports a cancelled activity, it must put an ActivityFailure with CancelledFailure
    as the cause in the failure field.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILURE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    def __init__(
        self,
        *,
        failure: temporalio.api.failure.v1.message_pb2.Failure | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> None: ...

global___Cancellation = Cancellation

class WillCompleteAsync(google.protobuf.message.Message):
    """*
    Used in ActivityExecutionResult to notify Core that this Activity will complete asynchronously.
    Core will forget about this Activity and free up resources used to track this Activity.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___WillCompleteAsync = WillCompleteAsync

class DoBackoff(google.protobuf.message.Message):
    """*
    Issued when a local activity needs to retry but also wants to back off more than would be
    reasonable to WFT heartbeat for. Lang is expected to schedule a timer for the duration
    and then start a local activity of the same type & same inputs with the provided attempt number
    after the timer has elapsed.

    This exists because Core does not have a concept of starting commands by itself, they originate
    from lang. So expecting lang to start the timer / next pass of the activity fits more smoothly.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTEMPT_FIELD_NUMBER: builtins.int
    BACKOFF_DURATION_FIELD_NUMBER: builtins.int
    ORIGINAL_SCHEDULE_TIME_FIELD_NUMBER: builtins.int
    attempt: builtins.int
    """The attempt number that lang should provide when scheduling the retry. If the LA failed
    on attempt 4 and we told lang to back off with a timer, this number will be 5.
    """
    @property
    def backoff_duration(self) -> google.protobuf.duration_pb2.Duration: ...
    @property
    def original_schedule_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time the first attempt of this local activity was scheduled. Must be passed with attempt
        to the retry LA.
        """
    def __init__(
        self,
        *,
        attempt: builtins.int = ...,
        backoff_duration: google.protobuf.duration_pb2.Duration | None = ...,
        original_schedule_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "backoff_duration",
            b"backoff_duration",
            "original_schedule_time",
            b"original_schedule_time",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "attempt",
            b"attempt",
            "backoff_duration",
            b"backoff_duration",
            "original_schedule_time",
            b"original_schedule_time",
        ],
    ) -> None: ...

global___DoBackoff = DoBackoff
