"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Repository = exports.RepositoryProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cr_generated_1 = require("./cr.generated");
Object.defineProperty(exports, "RepositoryProperty", { enumerable: true, get: function () { return cr_generated_1.RosRepository; } });
/**
 * A ROS resource type:  `ALIYUN::CR::Repository`
 */
class Repository extends ros.Resource {
    /**
     * Create a new `ALIYUN::CR::Repository`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRepository = new cr_generated_1.RosRepository(this, id, {
            tagImmutability: props.tagImmutability,
            repoNamespace: props.repoNamespace,
            repoType: props.repoType,
            instanceId: props.instanceId,
            repoName: props.repoName,
            summary: props.summary,
            detail: props.detail,
            repoSource: props.repoSource,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRepository;
        this.attrInstanceId = rosRepository.attrInstanceId;
        this.attrRepoId = rosRepository.attrRepoId;
        this.attrRepoName = rosRepository.attrRepoName;
        this.attrRepoNamespace = rosRepository.attrRepoNamespace;
        this.attrRepoType = rosRepository.attrRepoType;
    }
}
exports.Repository = Repository;
//# sourceMappingURL=data:application/json;base64,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