# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProxyLBACMEArgs', 'ProxyLBACME']

@pulumi.input_type
class ProxyLBACMEArgs:
    def __init__(__self__, *,
                 accept_tos: pulumi.Input[bool],
                 common_name: pulumi.Input[str],
                 proxylb_id: pulumi.Input[str],
                 subject_alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_delay_sec: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ProxyLBACME resource.
        :param pulumi.Input[bool] accept_tos: The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be set `true` explicitly. Changing this forces a new resource to be created.
        :param pulumi.Input[str] common_name: The FQDN used by ACME. This must set resolvable value. Changing this forces a new resource to be created.
        :param pulumi.Input[str] proxylb_id: The id of the ProxyLB that set ACME settings to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alt_names: The Subject alternative names used by ACME. Changing this forces a new resource to be created.
        :param pulumi.Input[int] update_delay_sec: The wait time in seconds. This typically used for waiting for a DNS propagation. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "accept_tos", accept_tos)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "proxylb_id", proxylb_id)
        if subject_alt_names is not None:
            pulumi.set(__self__, "subject_alt_names", subject_alt_names)
        if update_delay_sec is not None:
            pulumi.set(__self__, "update_delay_sec", update_delay_sec)

    @property
    @pulumi.getter(name="acceptTos")
    def accept_tos(self) -> pulumi.Input[bool]:
        """
        The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be set `true` explicitly. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accept_tos")

    @accept_tos.setter
    def accept_tos(self, value: pulumi.Input[bool]):
        pulumi.set(self, "accept_tos", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[str]:
        """
        The FQDN used by ACME. This must set resolvable value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="proxylbId")
    def proxylb_id(self) -> pulumi.Input[str]:
        """
        The id of the ProxyLB that set ACME settings to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proxylb_id")

    @proxylb_id.setter
    def proxylb_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "proxylb_id", value)

    @property
    @pulumi.getter(name="subjectAltNames")
    def subject_alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Subject alternative names used by ACME. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject_alt_names")

    @subject_alt_names.setter
    def subject_alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alt_names", value)

    @property
    @pulumi.getter(name="updateDelaySec")
    def update_delay_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The wait time in seconds. This typically used for waiting for a DNS propagation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "update_delay_sec")

    @update_delay_sec.setter
    def update_delay_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "update_delay_sec", value)


@pulumi.input_type
class _ProxyLBACMEState:
    def __init__(__self__, *,
                 accept_tos: Optional[pulumi.Input[bool]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateArgs']]]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 proxylb_id: Optional[pulumi.Input[str]] = None,
                 subject_alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_delay_sec: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ProxyLBACME resources.
        :param pulumi.Input[bool] accept_tos: The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be set `true` explicitly. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateArgs']]] certificates: A list of `certificate` blocks as defined below.
        :param pulumi.Input[str] common_name: The FQDN used by ACME. This must set resolvable value. Changing this forces a new resource to be created.
        :param pulumi.Input[str] proxylb_id: The id of the ProxyLB that set ACME settings to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alt_names: The Subject alternative names used by ACME. Changing this forces a new resource to be created.
        :param pulumi.Input[int] update_delay_sec: The wait time in seconds. This typically used for waiting for a DNS propagation. Changing this forces a new resource to be created.
        """
        if accept_tos is not None:
            pulumi.set(__self__, "accept_tos", accept_tos)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if proxylb_id is not None:
            pulumi.set(__self__, "proxylb_id", proxylb_id)
        if subject_alt_names is not None:
            pulumi.set(__self__, "subject_alt_names", subject_alt_names)
        if update_delay_sec is not None:
            pulumi.set(__self__, "update_delay_sec", update_delay_sec)

    @property
    @pulumi.getter(name="acceptTos")
    def accept_tos(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be set `true` explicitly. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accept_tos")

    @accept_tos.setter
    def accept_tos(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accept_tos", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateArgs']]]]:
        """
        A list of `certificate` blocks as defined below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN used by ACME. This must set resolvable value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="proxylbId")
    def proxylb_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the ProxyLB that set ACME settings to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proxylb_id")

    @proxylb_id.setter
    def proxylb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxylb_id", value)

    @property
    @pulumi.getter(name="subjectAltNames")
    def subject_alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Subject alternative names used by ACME. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject_alt_names")

    @subject_alt_names.setter
    def subject_alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alt_names", value)

    @property
    @pulumi.getter(name="updateDelaySec")
    def update_delay_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The wait time in seconds. This typically used for waiting for a DNS propagation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "update_delay_sec")

    @update_delay_sec.setter
    def update_delay_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "update_delay_sec", value)


class ProxyLBACME(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_tos: Optional[pulumi.Input[bool]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 proxylb_id: Optional[pulumi.Input[str]] = None,
                 subject_alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_delay_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a SakuraCloud ProxyLB ACME Setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar_proxy_lbacme = sakuracloud.ProxyLBACME("foobarProxyLBACME",
            proxylb_id=sakuracloud_proxylb["foobar"]["id"],
            accept_tos=True,
            common_name="www.example.com",
            subject_alt_names=["www1.example.com"],
            update_delay_sec=120)
        foobar_proxy_lb = sakuracloud.get_proxy_lb(filter=sakuracloud.GetProxyLBFilterArgs(
            names=["foobar"],
        ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accept_tos: The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be set `true` explicitly. Changing this forces a new resource to be created.
        :param pulumi.Input[str] common_name: The FQDN used by ACME. This must set resolvable value. Changing this forces a new resource to be created.
        :param pulumi.Input[str] proxylb_id: The id of the ProxyLB that set ACME settings to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alt_names: The Subject alternative names used by ACME. Changing this forces a new resource to be created.
        :param pulumi.Input[int] update_delay_sec: The wait time in seconds. This typically used for waiting for a DNS propagation. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProxyLBACMEArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SakuraCloud ProxyLB ACME Setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar_proxy_lbacme = sakuracloud.ProxyLBACME("foobarProxyLBACME",
            proxylb_id=sakuracloud_proxylb["foobar"]["id"],
            accept_tos=True,
            common_name="www.example.com",
            subject_alt_names=["www1.example.com"],
            update_delay_sec=120)
        foobar_proxy_lb = sakuracloud.get_proxy_lb(filter=sakuracloud.GetProxyLBFilterArgs(
            names=["foobar"],
        ))
        ```

        :param str resource_name: The name of the resource.
        :param ProxyLBACMEArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProxyLBACMEArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_tos: Optional[pulumi.Input[bool]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 proxylb_id: Optional[pulumi.Input[str]] = None,
                 subject_alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_delay_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProxyLBACMEArgs.__new__(ProxyLBACMEArgs)

            if accept_tos is None and not opts.urn:
                raise TypeError("Missing required property 'accept_tos'")
            __props__.__dict__["accept_tos"] = accept_tos
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            if proxylb_id is None and not opts.urn:
                raise TypeError("Missing required property 'proxylb_id'")
            __props__.__dict__["proxylb_id"] = proxylb_id
            __props__.__dict__["subject_alt_names"] = subject_alt_names
            __props__.__dict__["update_delay_sec"] = update_delay_sec
            __props__.__dict__["certificates"] = None
        super(ProxyLBACME, __self__).__init__(
            'sakuracloud:index/proxyLBACME:ProxyLBACME',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_tos: Optional[pulumi.Input[bool]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBACMECertificateArgs']]]]] = None,
            common_name: Optional[pulumi.Input[str]] = None,
            proxylb_id: Optional[pulumi.Input[str]] = None,
            subject_alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            update_delay_sec: Optional[pulumi.Input[int]] = None) -> 'ProxyLBACME':
        """
        Get an existing ProxyLBACME resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accept_tos: The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be set `true` explicitly. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBACMECertificateArgs']]]] certificates: A list of `certificate` blocks as defined below.
        :param pulumi.Input[str] common_name: The FQDN used by ACME. This must set resolvable value. Changing this forces a new resource to be created.
        :param pulumi.Input[str] proxylb_id: The id of the ProxyLB that set ACME settings to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alt_names: The Subject alternative names used by ACME. Changing this forces a new resource to be created.
        :param pulumi.Input[int] update_delay_sec: The wait time in seconds. This typically used for waiting for a DNS propagation. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProxyLBACMEState.__new__(_ProxyLBACMEState)

        __props__.__dict__["accept_tos"] = accept_tos
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["proxylb_id"] = proxylb_id
        __props__.__dict__["subject_alt_names"] = subject_alt_names
        __props__.__dict__["update_delay_sec"] = update_delay_sec
        return ProxyLBACME(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptTos")
    def accept_tos(self) -> pulumi.Output[bool]:
        """
        The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be set `true` explicitly. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accept_tos")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence['outputs.ProxyLBACMECertificate']]:
        """
        A list of `certificate` blocks as defined below.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[str]:
        """
        The FQDN used by ACME. This must set resolvable value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="proxylbId")
    def proxylb_id(self) -> pulumi.Output[str]:
        """
        The id of the ProxyLB that set ACME settings to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proxylb_id")

    @property
    @pulumi.getter(name="subjectAltNames")
    def subject_alt_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Subject alternative names used by ACME. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject_alt_names")

    @property
    @pulumi.getter(name="updateDelaySec")
    def update_delay_sec(self) -> pulumi.Output[Optional[int]]:
        """
        The wait time in seconds. This typically used for waiting for a DNS propagation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "update_delay_sec")

