# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IPv4PtrArgs', 'IPv4Ptr']

@pulumi.input_type
class IPv4PtrArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 ip_address: pulumi.Input[str],
                 retry_interval: Optional[pulumi.Input[int]] = None,
                 retry_max: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IPv4Ptr resource.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN.
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set.
        :param pulumi.Input[int] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        :param pulumi.Input[int] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip_address", ip_address)
        if retry_interval is not None:
            pulumi.set(__self__, "retry_interval", retry_interval)
        if retry_max is not None:
            pulumi.set(__self__, "retry_max", retry_max)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        The value of the PTR record. This must be FQDN.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address to which the PTR record is set.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        """
        return pulumi.get(self, "retry_interval")

    @retry_interval.setter
    def retry_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_interval", value)

    @property
    @pulumi.getter(name="retryMax")
    def retry_max(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        """
        return pulumi.get(self, "retry_max")

    @retry_max.setter
    def retry_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_max", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _IPv4PtrState:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 retry_interval: Optional[pulumi.Input[int]] = None,
                 retry_max: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IPv4Ptr resources.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN.
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set.
        :param pulumi.Input[int] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        :param pulumi.Input[int] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if retry_interval is not None:
            pulumi.set(__self__, "retry_interval", retry_interval)
        if retry_max is not None:
            pulumi.set(__self__, "retry_max", retry_max)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the PTR record. This must be FQDN.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address to which the PTR record is set.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        """
        return pulumi.get(self, "retry_interval")

    @retry_interval.setter
    def retry_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_interval", value)

    @property
    @pulumi.getter(name="retryMax")
    def retry_max(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        """
        return pulumi.get(self, "retry_max")

    @retry_max.setter
    def retry_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_max", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class IPv4Ptr(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 retry_interval: Optional[pulumi.Input[int]] = None,
                 retry_max: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a SakuraCloud IPv4 PTR.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        server = sakuracloud.Server("server", network_interfaces=[sakuracloud.ServerNetworkInterfaceArgs(
            upstream="shared",
        )])
        foobar = sakuracloud.IPv4Ptr("foobar",
            ip_address=server.ip_address,
            hostname="www.example.com",
            retry_max=30,
            retry_interval=10)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN.
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set.
        :param pulumi.Input[int] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        :param pulumi.Input[int] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IPv4PtrArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SakuraCloud IPv4 PTR.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        server = sakuracloud.Server("server", network_interfaces=[sakuracloud.ServerNetworkInterfaceArgs(
            upstream="shared",
        )])
        foobar = sakuracloud.IPv4Ptr("foobar",
            ip_address=server.ip_address,
            hostname="www.example.com",
            retry_max=30,
            retry_interval=10)
        ```

        :param str resource_name: The name of the resource.
        :param IPv4PtrArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IPv4PtrArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 retry_interval: Optional[pulumi.Input[int]] = None,
                 retry_max: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IPv4PtrArgs.__new__(IPv4PtrArgs)

            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["retry_interval"] = retry_interval
            __props__.__dict__["retry_max"] = retry_max
            __props__.__dict__["zone"] = zone
        super(IPv4Ptr, __self__).__init__(
            'sakuracloud:index/iPv4Ptr:IPv4Ptr',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            retry_interval: Optional[pulumi.Input[int]] = None,
            retry_max: Optional[pulumi.Input[int]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'IPv4Ptr':
        """
        Get an existing IPv4Ptr resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN.
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set.
        :param pulumi.Input[int] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        :param pulumi.Input[int] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IPv4PtrState.__new__(_IPv4PtrState)

        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["retry_interval"] = retry_interval
        __props__.__dict__["retry_max"] = retry_max
        __props__.__dict__["zone"] = zone
        return IPv4Ptr(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The value of the PTR record. This must be FQDN.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address to which the PTR record is set.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        """
        return pulumi.get(self, "retry_interval")

    @property
    @pulumi.getter(name="retryMax")
    def retry_max(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        """
        return pulumi.get(self, "retry_max")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

