# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPacketFilterResult',
    'AwaitableGetPacketFilterResult',
    'get_packet_filter',
    'get_packet_filter_output',
]

@pulumi.output_type
class GetPacketFilterResult:
    """
    A collection of values returned by getPacketFilter.
    """
    def __init__(__self__, description=None, expressions=None, filter=None, id=None, name=None, zone=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expressions and not isinstance(expressions, list):
            raise TypeError("Expected argument 'expressions' to be a list")
        pulumi.set(__self__, "expressions", expressions)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the expression.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expressions(self) -> Sequence['outputs.GetPacketFilterExpressionResult']:
        """
        One or more `expression` blocks as defined below.
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetPacketFilterFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the PacketFilter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetPacketFilterResult(GetPacketFilterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPacketFilterResult(
            description=self.description,
            expressions=self.expressions,
            filter=self.filter,
            id=self.id,
            name=self.name,
            zone=self.zone)


def get_packet_filter(filter: Optional[pulumi.InputType['GetPacketFilterFilterArgs']] = None,
                      zone: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPacketFilterResult:
    """
    Get information about an existing Packet Filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_packet_filter(filter=sakuracloud.GetPacketFilterFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetPacketFilterFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the PacketFilter is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getPacketFilter:getPacketFilter', __args__, opts=opts, typ=GetPacketFilterResult).value

    return AwaitableGetPacketFilterResult(
        description=__ret__.description,
        expressions=__ret__.expressions,
        filter=__ret__.filter,
        id=__ret__.id,
        name=__ret__.name,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_packet_filter)
def get_packet_filter_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetPacketFilterFilterArgs']]]] = None,
                             zone: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPacketFilterResult]:
    """
    Get information about an existing Packet Filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_packet_filter(filter=sakuracloud.GetPacketFilterFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetPacketFilterFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the PacketFilter is in (e.g. `is1a`, `tk1a`).
    """
    ...
