# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseResult',
    'AwaitableGetDatabaseResult',
    'get_database',
    'get_database_output',
]

@pulumi.output_type
class GetDatabaseResult:
    """
    A collection of values returned by getDatabase.
    """
    def __init__(__self__, backups=None, database_type=None, description=None, filter=None, icon_id=None, id=None, name=None, network_interfaces=None, parameters=None, password=None, plan=None, replica_password=None, replica_user=None, tags=None, username=None, zone=None):
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_interfaces and not isinstance(network_interfaces, list):
            raise TypeError("Expected argument 'network_interfaces' to be a list")
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if replica_password and not isinstance(replica_password, str):
            raise TypeError("Expected argument 'replica_password' to be a str")
        pulumi.set(__self__, "replica_password", replica_password)
        if replica_user and not isinstance(replica_user, str):
            raise TypeError("Expected argument 'replica_user' to be a str")
        pulumi.set(__self__, "replica_user", replica_user)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.GetDatabaseBackupResult']:
        """
        A list of `backup` blocks as defined below.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> str:
        """
        The type of the database. This will be one of [`mariadb`/`postgres`].
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Database.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetDatabaseFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the Database.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetDatabaseNetworkInterfaceResult']:
        """
        A list of `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, str]:
        """
        The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password of default user on the database.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        The plan name of the Database. This will be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`].
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="replicaPassword")
    def replica_password(self) -> str:
        """
        The password of user that processing a replication.
        """
        return pulumi.get(self, "replica_password")

    @property
    @pulumi.getter(name="replicaUser")
    def replica_user(self) -> str:
        """
        The name of user that processing a replication.
        """
        return pulumi.get(self, "replica_user")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the Database.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The name of default user on the database.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetDatabaseResult(GetDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseResult(
            backups=self.backups,
            database_type=self.database_type,
            description=self.description,
            filter=self.filter,
            icon_id=self.icon_id,
            id=self.id,
            name=self.name,
            network_interfaces=self.network_interfaces,
            parameters=self.parameters,
            password=self.password,
            plan=self.plan,
            replica_password=self.replica_password,
            replica_user=self.replica_user,
            tags=self.tags,
            username=self.username,
            zone=self.zone)


def get_database(filter: Optional[pulumi.InputType['GetDatabaseFilterArgs']] = None,
                 zone: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseResult:
    """
    Get information about an existing Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_database(filter=sakuracloud.GetDatabaseFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetDatabaseFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Database is in (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult).value

    return AwaitableGetDatabaseResult(
        backups=__ret__.backups,
        database_type=__ret__.database_type,
        description=__ret__.description,
        filter=__ret__.filter,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        name=__ret__.name,
        network_interfaces=__ret__.network_interfaces,
        parameters=__ret__.parameters,
        password=__ret__.password,
        plan=__ret__.plan,
        replica_password=__ret__.replica_password,
        replica_user=__ret__.replica_user,
        tags=__ret__.tags,
        username=__ret__.username,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_database)
def get_database_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetDatabaseFilterArgs']]]] = None,
                        zone: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseResult]:
    """
    Get information about an existing Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_database(filter=sakuracloud.GetDatabaseFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetDatabaseFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Database is in (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
    """
    ...
