.. -*- rst -*-

Supported features and limitations
----------------------------------

General:
 * DryRun option is not supported.
 * Some exceptions are not exactly the same as reported by AWS.

+----------+------------------------------------------+-----------------+----------------------------------------+
| AWS      |        Command                           | Functionality   | Limitations                            |
| Component|                                          | group           |                                        |
+==========+==========================================+=================+========================================+
|          | **bold** - supported, normal - supported |                 |                                        |
|          | with limitations, *italic* -not supported|                 |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *AcceptVpcPeeringConnection*             | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | **AllocateAddress**                      | addresses       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *AllocateHosts*                          | dedicated hosts | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *AssignIpv6Addresses*                    | network         | not supported                          |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | AssignPrivateIpAddresses                 | network         | allowReassignment parameter            |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | **AssociateAddress**                     | addresses       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **AssociateDhcpOptions**                 | DHCP options    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **AssociateRouteTable**                  | routes          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *AssociateSubnetCidrBlock*               | subnets         | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *AssociateVpcCidrBlock*                  | VPC             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *AttachClassicLinkVpc*                   | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **AttachInternetGateway**                | internet        |                                        |
|          |                                          | gateways        |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **AttachNetworkInterface**               | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, EBS | **AttachVolume**                         | volumes         |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **AttachVpnGateway**                     | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | AuthorizeSecurityGroupEgress             | security groups | EC2 classic way to pass cidr, protocol,|
|          |                                          |                 | sourceGroup, ports parameters          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | AuthorizeSecurityGroupIngress            | security groups | EC2 classic way to pass cidr, protocol,|
|          |                                          |                 | sourceGroup, ports parameters          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *BundleInstance*                         | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CancelBundleTask*                       | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CancelConversionTask*                   | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CancelExportTask*                       | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CancelImportTask*                       | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CancelReservedInstancesListing*         | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CancelSpotFleetRequests*                | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CancelSpotInstanceRequests*             | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ConfirmProductInstance*                 | product codes   | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *CopyImage*                              | image           | not supported                          |
|          |                                          | provisioning    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *CopySnapshot*                           | snapshots,s3    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | CreateCustomerGateway                    | VPC gateways    | BGP dynamic routing                    |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **CreateDhcpOptions**                    | DHCP options    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CreateEgressOnlyInternetGateway*        | VPC gateways    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CreateFlowLogs*                         | infrastructural | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | CreateImage                              | images          | blockDeviceMapping parameter           |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CreateInstanceExportTask*               | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **CreateInternetGateway**                | VPC gateways    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **CreateKeyPair**                        | key pairs       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CreateNatGateway*                       | NAT gateways    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *CreateNetworkAcl*                       | ACL             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *CreateNetworkAclEntry*                  | ACL             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **CreateNetworkInterface**               | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CreatePlacementGroup*                   | clusters        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CreateReservedInstancesListing*         | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | CreateRoute                              | routes          | vpcPeeringConnection parameter         |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **CreateRouteTable**                     | routes          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | **CreateSecurityGroup**                  | security groups |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **CreateSnapshot**                       | snapshots       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *CreateSpotDatafeedSubscription*         | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | CreateSubnet                             | subnets         | availabilityZone parameter             |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **CreateTags**                           | tags            |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | CreateVolume                             | volumes         | iops, encrypted, kmsKeyId parameters   |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **CreateVpc**                            | VPC             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *CreateVpcEndpoint*                      | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *CreateVpcPeeringConnection*             | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | CreateVpnConnection                      | VPN             | BGP dynamic routing                    |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **CreateVpnConnectionRoute**             | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | CreateVpnGateway                         | VPN             | BGP dynamic routing                    |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteCustomerGateway**                | VPC gateways    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteDhcpOptions**                    | DHCP options    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DeleteEgressOnlyInternetGateway*        | VPC gateways    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DeleteFlowLogs*                         | infrastructural | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteInternetGateway**                | VPC gateways    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **DeleteKeyPair**                        | key pairs       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DeleteNatGateway*                       | NAT gateways    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DeleteNetworkAcl*                       | ACL             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DeleteNetworkAclEntry*                  | ACL             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteNetworkInterface**               | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | *DeletePlacementGroup*                   | clusters        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteRoute**                          | routes          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteRouteTable**                     | routes          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | **DeleteSecurityGroup**                  | security groups |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **DeleteSnapshot**                       | snapshots       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DeleteSpotDatafeedSubscription*         | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteSubnet**                         | subnets         |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **DeleteTags**                           | tags            |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **DeleteVolume**                         | volumes         |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteVpc**                            | VPC             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DeleteVpcEndpoints*                     | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DeleteVpcPeeringConnection*             | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteVpnConnection**                  | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteVpnConnectionRoute**             | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DeleteVpnGateway**                     | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **DeregisterImage**                      | images          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | DescribeAccountAttributes                | infrastructural | vpc-max-security-groups-per-interface, |
|          |                                          |                 | max-elastic-ips,                       |
|          |                                          |                 | vpc-max-elastic-ips attributes         |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | **DescribeAddresses**                    | addresses       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **DescribeAvailabilityZones**            | availability    |                                        |
|          |                                          | zones           |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeBundleTasks*                    | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeClassicLinkInstances*           | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeConversionTasks*                | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeCustomerGateways**             | gateways        |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeDhcpOptions**                  | DHCP options    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeEgressOnlyInternetGateways*     | VPC gateways    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeExportTasks*                    | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeFlowLogs*                       | infrastructural | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeHosts*                          | dedicated hosts | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeIdentityIdFormat*               | resource IDs    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeIdFormat*                       | resource IDs    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | DescribeImageAttribute                   | images          | productCodes, sriovNetSupport          |
|          |                                          |                 | attributes                             |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **DescribeImages**                       | images          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeImportImageTasks*               | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeImportSnapshotTasks*            | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | DescribeInstanceAttribute                | instances       | same limitations as for                |
|          |                                          |                 | ModifyInstanceAttribute                |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2,     | **DescribeInstances**                    | instances       |                                        |
| EBS, VPC |                                          |                 |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeInstanceStatus*                 | monitoring      | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeInternetGateways**             | gateways        |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **DescribeKeyPairs**                     | key pairs       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeMovingAddresses*                | infrastructural | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeNatGateways*                    | NAT gateways    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeNetworkAcls*                    | ACL             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeNetworkInterfaceAttribute**    | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeNetworkInterfaces**            | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | *DescribePlacementGroups*                | clusters        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribePrefixLists*                    | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | DescribeRegions                          | availability    | RegionNameparameter                    |
|          |                                          | zones           |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeReservedInstances*              | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeReservedInstancesListings*      | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeReservedInstancesModifications* | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeReservedInstancesOfferings*     | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeRouteTables**                  | routes          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeScheduledInstanceAvailability*  | scheduled       | not supported                          |
|          |                                          | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeScheduledInstances*             | scheduled       | not supported                          |
|          |                                          | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeSecurityGroupReferences*        | security groups | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | DescribeSecurityGroups                   | security groups | cidr, protocol, port, sourceGroup      |
|          |                                          |                 | parameters                             |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *DescribeSnapshotAttribute*              | snapshots       | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **DescribeSnapshots**                    | snapshots       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeSpotDatafeedSubscription*       | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeSpotFleetInstances*             | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeSpotFleetRequestHistory*        | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeSpotFleetRequests*              | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeSpotInstanceRequests*           | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeSpotPriceHistory*               | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeStaleSecurityGroups*            | security groups | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeSubnets**                      | subnets         |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **DescribeTags**                         | tags            |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *DescribeVolumeAttribute*                | volumes         | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **DescribeVolumes**                      | volumes         |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeVolumeStatus*                   | monitoring      | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeVpcAttribute*                   | VPC             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeVpcClassicLink*                 | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DescribeVpcClassicLinkDnsSupport*       | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeVpcEndpoints*                   | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeVpcEndpointServices*            | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DescribeVpcPeeringConnections*          | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeVpcs**                         | VPC             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeVpnConnections**               | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DescribeVpnGateways**                  | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DetachClassicLinkVpc*                   | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DetachInternetGateway**                | VPC             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DetachNetworkInterface**               | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, EBS | DetachVolume                             | volumes         | instance_id, device, force parameters  |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DetachVpnGateway**                     | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DisableVgwRoutePropagation**           | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *DisableVpcClassicLink*                  | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DisableVpcClassicLinkDnsSupport*        | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | **DisassociateAddress**                  | addresses       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **DisassociateRouteTable**               | routes          |                                        |
|          | *DisassociateSubnetCidrBlock*            | subnets         | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *DisassociateVpcCidrBlock*               | VPC             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **EnableVgwRoutePropagation**            | VPN             |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *EnableVolumeIO*                         | monitoring      | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *EnableVpcClassicLink*                   | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *EnableVpcClassicLinkDnsSupport*         | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **GetConsoleOutput**                     | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *GetConsoleScreenshot*                   | instances       | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **GetPasswordData**                      | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ImportImage*                            | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ImportInstance*                         | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **ImportKeyPair**                        | keypairs        |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ImportSnapshot*                         | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ImportVolume*                           | tasks,s3        | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ModifyHosts*                            | dedicated hosts | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ModifyIdentityIdFormat*                 | resource IDs    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ModifyIdFormat*                         | resource IDs    | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | ModifyImageAttribute                     | images          | productCodes attribute                 |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | ModifyInstanceAttribute                  | instances       | only disableApiTermination,            |
|          |                                          |                 | sourceDestCheck,instanceType supported |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ModifyInstancePlacement*                | dedicated hosts | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **ModifyNetworkInterfaceAttribute**      | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ModifyReservedInstances*                | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *ModifySnapshotAttribute*                | snapshots       | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ModifySpotFleetRequest*                 | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *ModifySubnetAttribute*                  | subnets         | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *ModifyVolumeAttribute*                  | volumes         | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *ModifyVpcAttribute*                     | VPC             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *ModifyVpcEndpoint*                      | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ModifyVpcPeeringConnectionOptions*      | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *MonitorInstances*                       | monitoring      | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *MoveAddressToVpc*                       | infrastructural | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *PurchaseReservedInstancesOffering*      | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *PurchaseScheduledInstances*             | scheduled       | not supported                          |
|          |                                          | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **RebootInstances**                      | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | RegisterImage                            | images          | virtualizationType, sriovNetSupport    |
|          |                                          |                 | parameters                             |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *RejectVpcPeeringConnection*             | cross-VPC       | not supported                          |
|          |                                          | connectivity    |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | **ReleaseAddress**                       | addresses       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ReleaseHosts*                           | dedicated hosts | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *ReplaceNetworkAclAssociation*           | ACL             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *ReplaceNetworkAclEntry*                 | ACL             | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **ReplaceRoute**                         | routes          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **ReplaceRouteTableAssociation**         | routes          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *ReportInstanceStatus*                   | monitoring      | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *RequestSpotFleet*                       | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *RequestSpotInstances*                   | market          | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | **ResetImageAttribute**                  | images          |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | ResetInstanceAttribute                   | instances       | same limitations as for                |
|          |                                          |                 | ModifyInstanceAttribute                |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **ResetNetworkInterfaceAttribute**       | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EBS      | *ResetSnapshotAttribute*                 | snapshots       | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | *RestoreAddressToClassic*                | infrastructural | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | RevokeSecurityGroupEgress                | security groups | EC2 classic way to pass cidr, protocol,|
|          |                                          |                 | sourceGroup, ports parameters          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2, VPC | RevokeSecurityGroupIngress               | security groups | EC2 classic way to pass cidr, protocol,|
|          |                                          |                 | sourceGroup, ports parameters          |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2,     | RunInstances                             | instances       | placement, block_device_mapping partial|
| VPC, EBS |                                          |                 | support, monitoring,                   |
|          |                                          |                 | iamInstanceProfile, ebsOptimized,      |
|          |                                          |                 | shutdownInitiatedInstanceBehavior      |
|          |                                          |                 | parameters                             |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *RunScheduledInstances*                  | scheduled       | not supported                          |
|          |                                          | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **StartInstances**                       | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **StopInstances**                        | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| EC2      | **TerminateInstances**                   | instances       |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *UnassignIpv6Addresses*                  | network         | not supported                          |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
| VPC      | **UnassignPrivateIpAddresses**           | network         |                                        |
|          |                                          | interfaces      |                                        |
+----------+------------------------------------------+-----------------+----------------------------------------+
|          | *UnmonitorInstances*                     | monitoring      | not supported                          |
+----------+------------------------------------------+-----------------+----------------------------------------+
