from enum import Enum


class ErrorCode(str, Enum):
    ### GENERIC
    GENERIC_ERROR = "GENERIC_ERROR"

    #### COMMON
    INVALID_REQUEST = "INVALID_REQUEST"
    INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR"
    DATA_NOT_FOUND = "DATA_NOT_FOUND"

    #### AUTH
    COMPANY_NOT_FOUND = "COMPANY_NOT_FOUND"
    AUTH_INVALID_CREDENTIALS = "AUTH_INVALID_CREDENTIALS"
    AUTH_EMAIL_ALREADY_EXISTS = "AUTH_EMAIL_ALREADY_EXISTS"
    AUTH_EMAIL_VERIFICATION_PENDING = "AUTH_EMAIL_VERIFICATION_PENDING"
    AUTH_RECORD_NOT_FOUND = "AUTH_RECORD_NOT_FOUND"
    AUTH_INVALID_TOKEN = "AUTH_INVALID_TOKEN"
    AUTH_OTP_EXPIRED = "AUTH_OTP_EXPIRED"
    AUTH_OTP_INVALID = "AUTH_OTP_INVALID"
    AUTH_OTP_TOO_MANY_ATTEMPTS = "AUTH_OTP_TOO_MANY_ATTEMPTS"
    AUTH_ACCOUNT_DEACTIVE = "AUTH_ACCOUNT_DEACTIVE"
    # PASSWORD
    AUTH_PASSWORD_INVALID = "AUTH_PASSWORD_INVALID"
    AUTH_PASSWORD_WEAK = "AUTH_PASSWORD_WEAK"
    AUTH_PASSWORD_SHORT = "AUTH_PASSWORD_SHORT"
    AUTH_PASSWORD_MISMATCH = "AUTH_PASSWORD_MISMATCH"

    AUTH_WRONG_COMPANY = "AUTH_WRONG_COMPANY"

    #### SSO
    AUTH_SSO_NOT_CONFIGURED = "AUTH_SSO_NOT_CONFIGURED"
    AUTH_SSO_OUTSIDE_DOMAIN = "AUTH_SSO_OUTSIDE_DOMAIN"

    ## CONNECT
    CALL_ROOM_NO_MEMBERS = "CALL_ROOM_NO_MEMBERS"
    NO_SUB_SPACE_FOUND = "NO_SUB_SPACE_FOUND"
    SPACE_ROLE_NOT_FOUND = "SPACE_ROLE_NOT_FOUND"

    # FEED

    # COMPANY

    # EMPLOYEE
    EMPLOYEE_NOT_FOUND = "EMPLOYEE_NOT_FOUND"

    # SURVEY
    SURVEY_NOT_FOUND = "SURVEY_NOT_FOUND"
    INVALID_SOURCE = "INVALID_SOURCE"
    SURVEY_QUESTIONS_NOT_FOUND = "SURVEY_QUESTIONS_NOT_FOUND"
    TEMPLATE_NAME_ALREADY_EXITS = "TEMPLATE_NAME_ALREADY_EXITS"
    SURVEY_TEMPLATE_NOT_FOUND = "SURVEY_TEMPLATE_NOT_FOUND"
    SURVEY_QUEST_UPT_SUB_EXITS = "SURVEY_QUEST_UPT_SUB_EXITS"

    # CONTEST
    CONTEST_NOT_FOUND = "CONTEST_NOT_FOUND"
    BADGE_NOT_FOUND = "BADGE_NOT_FOUND"

    # SHOP
    CRITERIA_TYPE_NOT_FOUND = "CRITERIA_TYPE_NOT_FOUND"

    # NOTIFICATION

    # REPORT
    START_AND_END_DATE_REQUIRED = "START_AND_END_DATE_REQUIRED"
    INVALID_INTERVAL = "INVALID_INTERVAL"

    # RECOGNITION
    NOT_ENOUGH_POINTS = "NOT_ENOUGH_POINTS"
    NO_RECOGNITION_TYPE_FOUND = "NO_RECOGNITION_TYPE_FOUND"

    # POLL
    POLL_NOT_FOUND = "POLL_NOT_FOUND"
    NO_POLL_BY_EMPLOYEE = "NO_POLL_BY_EMPLOYEE"

    # OCCASION
    CRITERIA_SEARCH_TYPE_INVALID = "CRITERIA_SEARCH_TYPE_INVALID"
    CRITERIA_INVALID = "CRITERIA_INVALID"
    OCCASION_TYPE_INVALID = "OCCASION_TYPE_INVALID"

    # MANAGE
    CODE_MISSING_IN_REQUEST = "CODE_MISSING_IN_REQUEST"
    STATE_MISSING_IN_REQUEST = "STATE_MISSING_IN_REQUEST"
    INVALID_ROLE_ID = "INVALID_ROLE_ID"
    INVALID_SELECTION_FIELD = "INVALID_SELECTION_FIELD"
    INVALID_ACTION = "INVALID_ACTION"
    INVALID_ACTION_ID = "INVALID_ACTION_ID"
    GROUP_ALREADY_EXIST = "GROUP_ALREADY_EXIST"
    ROLE_ALREADY_EXIST = "ROLE_ALREADY_EXIST"
    NO_PERMISSION = "NO_PERMISSION"
    NO_FINCH_ACCESS_KEY = "NO_FINCH_ACCESS_KEY"
    FINCH_REAUTH_FAIL = "FINCH_REAUTH_FAIL"
    CONNECTION_NOT_FOUND = "CONNECTION_NOT_FOUND"
    INVALID_CREDENTIALS = "INVALID_CREDENTIALS"

    # CALANDER
    CALANDER_EVENT_NOT_FOUND = "CALANDER_EVENT_NOT_FOUND"

    # CALL
    NO_CALL_ROOM_FOUND = "NO_CALL_ROOM_FOUND"
    SPACE_NOT_FOUND = "SPACE_NOT_FOUND"

    # CELEB
    POST_ID_MISSING = "POST_ID_MISSING"
    RECOGNITION_GROUP_NOT_FOUND = "RECOGNITION_GROUP_NOT_FOUND"
    COMMUNITY_NOT_FOUND = "COMMUNITY_NOT_FOUND"
    ADMIN_NOT_FOUND = "ADMIN_NOT_FOUND"

    # STORY
    STORIES_NOT_FOUND = "STORIES_NOT_FOUND"
    STORY_EMPLOYEES_NOT_FOUND = "STORY_EMPLOYEES_NOT_FOUND"

    # CONFIG
    DEPARTMENT_NOT_FOUND = "DEPARTMENT_NOT_FOUND"
    INVALID_CONFIG_SETTING = "INVALID_CONFIG_SETTING"

    # CAMPAIGN

    CAMPAIGN_INSERT_ERROR = "CAMPAIGN_INSERT_ERROR"
    CAMPAIGN_NOT_FOUND = "CAMPAIGN_NOT_FOUND"
    CAMPAIGNS_NOT_FOUND = "CAMPAIGNS_NOT_FOUND"
