# MIT License
#
# Copyright (c) 2021 Looker Data Sciences, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#

# 320 API models: 239 Spec, 0 Request, 60 Write, 21 Enum


# NOTE: Do not edit this file generated by Looker SDK Codegen for API 4.0
import datetime
import enum
from typing import Any, MutableMapping, Optional, Sequence

try:
    from typing import ForwardRef  # type: ignore
except ImportError:
    from typing import _ForwardRef as ForwardRef  # type: ignore

import attr

from looker_sdk.rtl import model
from looker_sdk.rtl import serialize as sr

EXPLICIT_NULL = model.EXPLICIT_NULL  # type: ignore
DelimSequence = model.DelimSequence


@attr.s(auto_attribs=True, init=False)
class AccessToken(model.Model):
    """
    Attributes:
        access_token: Access Token used for API calls
        token_type: Type of Token
        expires_in: Number of seconds before the token expires
        refresh_token: Refresh token which can be used to obtain a new access token
    """

    access_token: Optional[str] = None
    token_type: Optional[str] = None
    expires_in: Optional[int] = None
    refresh_token: Optional[str] = None

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        token_type: Optional[str] = None,
        expires_in: Optional[int] = None,
        refresh_token: Optional[str] = None
    ):
        self.access_token = access_token
        self.token_type = token_type
        self.expires_in = expires_in
        self.refresh_token = refresh_token


@attr.s(auto_attribs=True, init=False)
class Alert(model.Model):
    """
    Attributes:
        comparison_type: This property informs the check what kind of comparison we are performing. Only certain condition types are valid for time series alerts. For details, refer to [Setting Alert Conditions](https://docs.looker.com/sharing-and-publishing/creating-alerts#setting_alert_conditions) Valid values are: "EQUAL_TO", "GREATER_THAN", "GREATER_THAN_OR_EQUAL_TO", "LESS_THAN", "LESS_THAN_OR_EQUAL_TO", "INCREASES_BY", "DECREASES_BY", "CHANGES_BY".
        cron: Vixie-Style crontab specification when to run. At minumum, it has to be longer than 15 minute intervals
        destinations: Array of destinations to send alerts to. Must be the same type of destination. Example `[{ "destination_type": "EMAIL", "email_address": "test@test.com" }]`
        field:
        owner_id: User id of alert owner
        threshold: Value of the alert threshold
        applied_dashboard_filters: Filters coming from the dashboard that are applied. Example `[{ "filter_title": "Name", "field_name": "distribution_centers.name", "filter_value": "Los Angeles CA" }]`
        custom_title: An optional, user-defined title for the alert
        dashboard_element_id: ID of the dashboard element associated with the alert. Refer to [dashboard_element()](#!/Dashboard/DashboardElement)
        description: An optional description for the alert. This supplements the title
        followed: Whether or not the user follows this alert.
        followable: Whether or not the alert is followable
        id: ID of the alert
        is_disabled: Whether or not the alert is disabled
        disabled_reason: Reason for disabling alert
        is_public: Whether or not the alert is public
        investigative_content_type: The type of the investigative content Valid values are: "dashboard".
        investigative_content_id: The ID of the investigative content. For dashboards, this will be the dashboard ID
        investigative_content_title: The title of the investigative content.
        lookml_dashboard_id: ID of the LookML dashboard associated with the alert
        lookml_link_id: ID of the LookML dashboard element associated with the alert
        owner_display_name: Alert owner's display name
        time_series_condition_state:
    """

    comparison_type: "ComparisonType"
    cron: str
    destinations: Sequence["AlertDestination"]
    field: "AlertField"
    owner_id: str
    threshold: float
    applied_dashboard_filters: Optional[Sequence["AlertAppliedDashboardFilter"]] = None
    custom_title: Optional[str] = None
    dashboard_element_id: Optional[str] = None
    description: Optional[str] = None
    followed: Optional[bool] = None
    followable: Optional[bool] = None
    id: Optional[str] = None
    is_disabled: Optional[bool] = None
    disabled_reason: Optional[str] = None
    is_public: Optional[bool] = None
    investigative_content_type: Optional["InvestigativeContentType"] = None
    investigative_content_id: Optional[str] = None
    investigative_content_title: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    lookml_link_id: Optional[str] = None
    owner_display_name: Optional[str] = None
    time_series_condition_state: Optional["AlertConditionState"] = None
    __annotations__ = {
        "comparison_type": ForwardRef("ComparisonType"),
        "cron": str,
        "destinations": Sequence["AlertDestination"],
        "field": ForwardRef("AlertField"),
        "owner_id": str,
        "threshold": float,
        "applied_dashboard_filters": Optional[Sequence["AlertAppliedDashboardFilter"]],
        "custom_title": Optional[str],
        "dashboard_element_id": Optional[str],
        "description": Optional[str],
        "followed": Optional[bool],
        "followable": Optional[bool],
        "id": Optional[str],
        "is_disabled": Optional[bool],
        "disabled_reason": Optional[str],
        "is_public": Optional[bool],
        "investigative_content_type": Optional["InvestigativeContentType"],
        "investigative_content_id": Optional[str],
        "investigative_content_title": Optional[str],
        "lookml_dashboard_id": Optional[str],
        "lookml_link_id": Optional[str],
        "owner_display_name": Optional[str],
        "time_series_condition_state": Optional["AlertConditionState"],
    }

    def __init__(
        self,
        *,
        comparison_type: "ComparisonType",
        cron: str,
        destinations: Sequence["AlertDestination"],
        field: "AlertField",
        owner_id: str,
        threshold: float,
        applied_dashboard_filters: Optional[
            Sequence["AlertAppliedDashboardFilter"]
        ] = None,
        custom_title: Optional[str] = None,
        dashboard_element_id: Optional[str] = None,
        description: Optional[str] = None,
        followed: Optional[bool] = None,
        followable: Optional[bool] = None,
        id: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        disabled_reason: Optional[str] = None,
        is_public: Optional[bool] = None,
        investigative_content_type: Optional["InvestigativeContentType"] = None,
        investigative_content_id: Optional[str] = None,
        investigative_content_title: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        lookml_link_id: Optional[str] = None,
        owner_display_name: Optional[str] = None,
        time_series_condition_state: Optional["AlertConditionState"] = None
    ):
        self.comparison_type = comparison_type
        self.cron = cron
        self.destinations = destinations
        self.field = field
        self.owner_id = owner_id
        self.threshold = threshold
        self.applied_dashboard_filters = applied_dashboard_filters
        self.custom_title = custom_title
        self.dashboard_element_id = dashboard_element_id
        self.description = description
        self.followed = followed
        self.followable = followable
        self.id = id
        self.is_disabled = is_disabled
        self.disabled_reason = disabled_reason
        self.is_public = is_public
        self.investigative_content_type = investigative_content_type
        self.investigative_content_id = investigative_content_id
        self.investigative_content_title = investigative_content_title
        self.lookml_dashboard_id = lookml_dashboard_id
        self.lookml_link_id = lookml_link_id
        self.owner_display_name = owner_display_name
        self.time_series_condition_state = time_series_condition_state


@attr.s(auto_attribs=True, init=False)
class AlertAppliedDashboardFilter(model.Model):
    """
    Attributes:
        filter_title: Field Title. Refer to `DashboardFilter.title` in [DashboardFilter](#!/types/DashboardFilter). Example `Name`
        field_name: Field Name. Refer to `DashboardFilter.dimension` in [DashboardFilter](#!/types/DashboardFilter). Example `distribution_centers.name`
        filter_value: Field Value. [Filter Expressions](https://docs.looker.com/reference/filter-expressions). Example `Los Angeles CA`
        filter_description: Human Readable Filter Description. This may be null or auto-generated. Example `is Los Angeles CA`
    """

    filter_title: str
    field_name: str
    filter_value: str
    filter_description: Optional[str] = None

    def __init__(
        self,
        *,
        filter_title: str,
        field_name: str,
        filter_value: str,
        filter_description: Optional[str] = None
    ):
        self.filter_title = filter_title
        self.field_name = field_name
        self.filter_value = filter_value
        self.filter_description = filter_description


@attr.s(auto_attribs=True, init=False)
class AlertConditionState(model.Model):
    """
    Attributes:
        previous_time_series_id: (Write-Only) The second latest time string the alert has seen.
        latest_time_series_id: (Write-Only) Latest time string the alert has seen.
    """

    previous_time_series_id: Optional[str] = None
    latest_time_series_id: Optional[str] = None

    def __init__(
        self,
        *,
        previous_time_series_id: Optional[str] = None,
        latest_time_series_id: Optional[str] = None
    ):
        self.previous_time_series_id = previous_time_series_id
        self.latest_time_series_id = latest_time_series_id


@attr.s(auto_attribs=True, init=False)
class AlertDestination(model.Model):
    """
    Attributes:
        destination_type: Type of destination that the alert will be sent to Valid values are: "EMAIL", "ACTION_HUB".
        email_address: Email address for the 'email' type
        action_hub_integration_id: Action hub integration id for the 'action_hub' type. [Integration](#!/types/Integration)
        action_hub_form_params_json: Action hub form params json for the 'action_hub' type [IntegrationParam](#!/types/IntegrationParam)
    """

    destination_type: "DestinationType"
    email_address: Optional[str] = None
    action_hub_integration_id: Optional[str] = None
    action_hub_form_params_json: Optional[str] = None
    __annotations__ = {
        "destination_type": ForwardRef("DestinationType"),
        "email_address": Optional[str],
        "action_hub_integration_id": Optional[str],
        "action_hub_form_params_json": Optional[str],
    }

    def __init__(
        self,
        *,
        destination_type: "DestinationType",
        email_address: Optional[str] = None,
        action_hub_integration_id: Optional[str] = None,
        action_hub_form_params_json: Optional[str] = None
    ):
        self.destination_type = destination_type
        self.email_address = email_address
        self.action_hub_integration_id = action_hub_integration_id
        self.action_hub_form_params_json = action_hub_form_params_json


@attr.s(auto_attribs=True, init=False)
class AlertField(model.Model):
    """
    Attributes:
        title: Field's title. Usually auto-generated to reflect field name and its filters
        name: Field's name. Has the format `<view>.<field>` Refer to [docs](https://docs.looker.com/sharing-and-publishing/creating-alerts) for more details
        filter: (Optional / Advance Use) List of fields filter. This further restricts the alert to certain dashboard element's field values. This can be used on top of dashboard filters `applied_dashboard_filters`. To keep thing simple, it's suggested to just use dashboard filters. Example: `{ 'title': '12 Number on Hand', 'name': 'inventory_items.number_on_hand', 'filter': [{ 'field_name': 'inventory_items.id', 'field_value': 12, 'filter_value': null }] }`
    """

    title: str
    name: str
    filter: Optional[Sequence["AlertFieldFilter"]] = None

    def __init__(
        self,
        *,
        title: str,
        name: str,
        filter: Optional[Sequence["AlertFieldFilter"]] = None
    ):
        self.title = title
        self.name = name
        self.filter = filter


@attr.s(auto_attribs=True, init=False)
class AlertFieldFilter(model.Model):
    """
    Attributes:
        field_name: Field Name. Has format `<view>.<field>`
        field_value: Field Value. Depends on the type of field - numeric or string. For [location](https://docs.looker.com/reference/field-reference/dimension-type-reference#location) type, it's a list of floats. Example `[1.0, 56.0]`
        filter_value: Filter Value. Usually null except for [location](https://docs.looker.com/reference/field-reference/dimension-type-reference#location) type. It'll be a string of lat,long ie `'1.0,56.0'`
    """

    field_name: str
    field_value: Any
    filter_value: Optional[str] = None

    def __init__(
        self, *, field_name: str, field_value: Any, filter_value: Optional[str] = None
    ):
        self.field_name = field_name
        self.field_value = field_value
        self.filter_value = filter_value


@attr.s(auto_attribs=True, init=False)
class AlertNotifications(model.Model):
    """
    Attributes:
        notification_id: ID of the notification
        alert_condition_id: ID of the alert
        user_id: ID of the user
        is_read: Read state of the notification
        field_value: The value of the field on which the alert condition is set
        threshold_value: The value of the threshold which triggers the alert notification
        ran_at: The time at which the alert query ran
        alert:
    """

    notification_id: Optional[str] = None
    alert_condition_id: Optional[str] = None
    user_id: Optional[str] = None
    is_read: Optional[bool] = None
    field_value: Optional[float] = None
    threshold_value: Optional[float] = None
    ran_at: Optional[str] = None
    alert: Optional["MobilePayload"] = None

    def __init__(
        self,
        *,
        notification_id: Optional[str] = None,
        alert_condition_id: Optional[str] = None,
        user_id: Optional[str] = None,
        is_read: Optional[bool] = None,
        field_value: Optional[float] = None,
        threshold_value: Optional[float] = None,
        ran_at: Optional[str] = None,
        alert: Optional["MobilePayload"] = None
    ):
        self.notification_id = notification_id
        self.alert_condition_id = alert_condition_id
        self.user_id = user_id
        self.is_read = is_read
        self.field_value = field_value
        self.threshold_value = threshold_value
        self.ran_at = ran_at
        self.alert = alert


@attr.s(auto_attribs=True, init=False)
class AlertPatch(model.Model):
    """
    Attributes:
        owner_id: New owner ID of the alert
        is_disabled: Set alert enabled or disabled
        disabled_reason: The reason this alert is disabled
        is_public: Set alert public or private
        threshold: New threshold value
    """

    owner_id: Optional[str] = None
    is_disabled: Optional[bool] = None
    disabled_reason: Optional[str] = None
    is_public: Optional[bool] = None
    threshold: Optional[float] = None

    def __init__(
        self,
        *,
        owner_id: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        disabled_reason: Optional[str] = None,
        is_public: Optional[bool] = None,
        threshold: Optional[float] = None
    ):
        self.owner_id = owner_id
        self.is_disabled = is_disabled
        self.disabled_reason = disabled_reason
        self.is_public = is_public
        self.threshold = threshold


class Align(enum.Enum):
    """
    The appropriate horizontal text alignment the values of this field should be displayed in. Valid values are: "left", "right". (Enum defined in LookmlModelExploreField)

    """

    left = "left"
    right = "right"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
Align.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class ApiSession(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        workspace_id: The id of active workspace for this session
        sudo_user_id: The id of the actual user in the case when this session represents one user sudo'ing as another
    """

    can: Optional[MutableMapping[str, bool]] = None
    workspace_id: Optional[str] = None
    sudo_user_id: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        workspace_id: Optional[str] = None,
        sudo_user_id: Optional[str] = None
    ):
        self.can = can
        self.workspace_id = workspace_id
        self.sudo_user_id = sudo_user_id


@attr.s(auto_attribs=True, init=False)
class ApiVersion(model.Model):
    """
    Attributes:
        looker_release_version: Current Looker release version number
        current_version:
        supported_versions: Array of versions supported by this Looker instance
        api_server_url: API server base url
        web_server_url: Web server base url
    """

    looker_release_version: Optional[str] = None
    current_version: Optional["ApiVersionElement"] = None
    supported_versions: Optional[Sequence["ApiVersionElement"]] = None
    api_server_url: Optional[str] = None
    web_server_url: Optional[str] = None

    def __init__(
        self,
        *,
        looker_release_version: Optional[str] = None,
        current_version: Optional["ApiVersionElement"] = None,
        supported_versions: Optional[Sequence["ApiVersionElement"]] = None,
        api_server_url: Optional[str] = None,
        web_server_url: Optional[str] = None
    ):
        self.looker_release_version = looker_release_version
        self.current_version = current_version
        self.supported_versions = supported_versions
        self.api_server_url = api_server_url
        self.web_server_url = web_server_url


@attr.s(auto_attribs=True, init=False)
class ApiVersionElement(model.Model):
    """
    Attributes:
        version: Version number as it appears in '/api/xxx/' urls
        full_version: Full version number including minor version
        status: Status of this version
        swagger_url: Url for swagger.json for this version
    """

    version: Optional[str] = None
    full_version: Optional[str] = None
    status: Optional[str] = None
    swagger_url: Optional[str] = None

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        full_version: Optional[str] = None,
        status: Optional[str] = None,
        swagger_url: Optional[str] = None
    ):
        self.version = version
        self.full_version = full_version
        self.status = status
        self.swagger_url = swagger_url


@attr.s(auto_attribs=True, init=False)
class BackupConfiguration(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        type: Type of backup: looker-s3 or custom-s3
        custom_s3_bucket: Name of bucket for custom-s3 backups
        custom_s3_bucket_region: Name of region where the bucket is located
        custom_s3_key: (Write-Only) AWS S3 key used for custom-s3 backups
        custom_s3_secret: (Write-Only) AWS S3 secret used for custom-s3 backups
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    type: Optional[str] = None
    custom_s3_bucket: Optional[str] = None
    custom_s3_bucket_region: Optional[str] = None
    custom_s3_key: Optional[str] = None
    custom_s3_secret: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        type: Optional[str] = None,
        custom_s3_bucket: Optional[str] = None,
        custom_s3_bucket_region: Optional[str] = None,
        custom_s3_key: Optional[str] = None,
        custom_s3_secret: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.type = type
        self.custom_s3_bucket = custom_s3_bucket
        self.custom_s3_bucket_region = custom_s3_bucket_region
        self.custom_s3_key = custom_s3_key
        self.custom_s3_secret = custom_s3_secret
        self.url = url


@attr.s(auto_attribs=True, init=False)
class Board(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_metadata_id: Id of associated content_metadata record
        created_at: Date of board creation
        deleted_at: Date of board deletion
        description: Description of the board
        board_sections: Sections of the board
        id: Unique Id
        section_order: ids of the board sections in the order they should be displayed
        title: Title of the board
        updated_at: Date of last board update
        user_id: User id of board creator
        primary_homepage: Whether the board is the primary homepage or not
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_metadata_id: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    deleted_at: Optional[datetime.datetime] = None
    description: Optional[str] = None
    board_sections: Optional[Sequence["BoardSection"]] = None
    id: Optional[str] = None
    section_order: Optional[Sequence[str]] = None
    title: Optional[str] = None
    updated_at: Optional[datetime.datetime] = None
    user_id: Optional[str] = None
    primary_homepage: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_metadata_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        deleted_at: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        board_sections: Optional[Sequence["BoardSection"]] = None,
        id: Optional[str] = None,
        section_order: Optional[Sequence[str]] = None,
        title: Optional[str] = None,
        updated_at: Optional[datetime.datetime] = None,
        user_id: Optional[str] = None,
        primary_homepage: Optional[bool] = None
    ):
        self.can = can
        self.content_metadata_id = content_metadata_id
        self.created_at = created_at
        self.deleted_at = deleted_at
        self.description = description
        self.board_sections = board_sections
        self.id = id
        self.section_order = section_order
        self.title = title
        self.updated_at = updated_at
        self.user_id = user_id
        self.primary_homepage = primary_homepage


@attr.s(auto_attribs=True, init=False)
class BoardItem(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_created_by: Name of user who created the content this item is based on
        content_favorite_id: Content favorite id associated with the item this content is based on
        content_metadata_id: Content metadata id associated with the item this content is based on
        content_updated_at: Last time the content that this item is based on was updated
        custom_description: Custom description entered by the user, if present
        custom_title: Custom title entered by the user, if present
        custom_url: Custom url entered by the user, if present
        dashboard_id: Dashboard to base this item on
        description: The actual description for display
        favorite_count: Number of times content has been favorited, if present
        board_section_id: Associated Board Section
        id: Unique Id
        image_url: The actual image_url for display
        location: The container folder name of the content
        look_id: Look to base this item on
        lookml_dashboard_id: LookML Dashboard to base this item on
        order: An arbitrary integer representing the sort order within the section
        title: The actual title for display
        url: Relative url for the associated content
        use_custom_description: Whether the custom description should be used instead of the content description, if the item is associated with content
        use_custom_title: Whether the custom title should be used instead of the content title, if the item is associated with content
        use_custom_url: Whether the custom url should be used instead of the content url, if the item is associated with content
        view_count: Number of times content has been viewed, if present
        custom_image_data_base64: (Write-Only) base64 encoded image data
        custom_image_url: Custom image_url entered by the user, if present
        use_custom_image: Whether the custom image should be used instead of the content image, if the item is associated with content
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_created_by: Optional[str] = None
    content_favorite_id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    content_updated_at: Optional[str] = None
    custom_description: Optional[str] = None
    custom_title: Optional[str] = None
    custom_url: Optional[str] = None
    dashboard_id: Optional[str] = None
    description: Optional[str] = None
    favorite_count: Optional[int] = None
    board_section_id: Optional[str] = None
    id: Optional[str] = None
    image_url: Optional[str] = None
    location: Optional[str] = None
    look_id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    order: Optional[int] = None
    title: Optional[str] = None
    url: Optional[str] = None
    use_custom_description: Optional[bool] = None
    use_custom_title: Optional[bool] = None
    use_custom_url: Optional[bool] = None
    view_count: Optional[int] = None
    custom_image_data_base64: Optional[str] = None
    custom_image_url: Optional[str] = None
    use_custom_image: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_created_by: Optional[str] = None,
        content_favorite_id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        content_updated_at: Optional[str] = None,
        custom_description: Optional[str] = None,
        custom_title: Optional[str] = None,
        custom_url: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        description: Optional[str] = None,
        favorite_count: Optional[int] = None,
        board_section_id: Optional[str] = None,
        id: Optional[str] = None,
        image_url: Optional[str] = None,
        location: Optional[str] = None,
        look_id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        order: Optional[int] = None,
        title: Optional[str] = None,
        url: Optional[str] = None,
        use_custom_description: Optional[bool] = None,
        use_custom_title: Optional[bool] = None,
        use_custom_url: Optional[bool] = None,
        view_count: Optional[int] = None,
        custom_image_data_base64: Optional[str] = None,
        custom_image_url: Optional[str] = None,
        use_custom_image: Optional[bool] = None
    ):
        self.can = can
        self.content_created_by = content_created_by
        self.content_favorite_id = content_favorite_id
        self.content_metadata_id = content_metadata_id
        self.content_updated_at = content_updated_at
        self.custom_description = custom_description
        self.custom_title = custom_title
        self.custom_url = custom_url
        self.dashboard_id = dashboard_id
        self.description = description
        self.favorite_count = favorite_count
        self.board_section_id = board_section_id
        self.id = id
        self.image_url = image_url
        self.location = location
        self.look_id = look_id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.order = order
        self.title = title
        self.url = url
        self.use_custom_description = use_custom_description
        self.use_custom_title = use_custom_title
        self.use_custom_url = use_custom_url
        self.view_count = view_count
        self.custom_image_data_base64 = custom_image_data_base64
        self.custom_image_url = custom_image_url
        self.use_custom_image = use_custom_image


@attr.s(auto_attribs=True, init=False)
class BoardSection(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Time at which this section was created.
        deleted_at: Time at which this section was deleted.
        description: Description of the content found in this section.
        board_id: Id reference to parent board
        board_items: Items in the board section
        id: Unique Id
        item_order: ids of the board items in the order they should be displayed
        visible_item_order: ids of the homepage items the user can see in the order they should be displayed
        title: Name of row
        updated_at: Time at which this section was last updated.
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[datetime.datetime] = None
    deleted_at: Optional[datetime.datetime] = None
    description: Optional[str] = None
    board_id: Optional[str] = None
    board_items: Optional[Sequence["BoardItem"]] = None
    id: Optional[str] = None
    item_order: Optional[Sequence[str]] = None
    visible_item_order: Optional[Sequence[str]] = None
    title: Optional[str] = None
    updated_at: Optional[datetime.datetime] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[datetime.datetime] = None,
        deleted_at: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        board_id: Optional[str] = None,
        board_items: Optional[Sequence["BoardItem"]] = None,
        id: Optional[str] = None,
        item_order: Optional[Sequence[str]] = None,
        visible_item_order: Optional[Sequence[str]] = None,
        title: Optional[str] = None,
        updated_at: Optional[datetime.datetime] = None
    ):
        self.can = can
        self.created_at = created_at
        self.deleted_at = deleted_at
        self.description = description
        self.board_id = board_id
        self.board_items = board_items
        self.id = id
        self.item_order = item_order
        self.visible_item_order = visible_item_order
        self.title = title
        self.updated_at = updated_at


class Category(enum.Enum):
    """
    Field category Valid values are: "parameter", "filter", "measure", "dimension". (Enum defined in LookmlModelExploreField)

    """

    parameter = "parameter"
    filter = "filter"
    measure = "measure"
    dimension = "dimension"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
Category.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class ColorCollection(model.Model):
    """
    Attributes:
        id: Unique Id
        label: Label of color collection
        categoricalPalettes: Array of categorical palette definitions
        sequentialPalettes: Array of discrete palette definitions
        divergingPalettes: Array of diverging palette definitions
    """

    id: Optional[str] = None
    label: Optional[str] = None
    categoricalPalettes: Optional[Sequence["DiscretePalette"]] = None
    sequentialPalettes: Optional[Sequence["ContinuousPalette"]] = None
    divergingPalettes: Optional[Sequence["ContinuousPalette"]] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        label: Optional[str] = None,
        categoricalPalettes: Optional[Sequence["DiscretePalette"]] = None,
        sequentialPalettes: Optional[Sequence["ContinuousPalette"]] = None,
        divergingPalettes: Optional[Sequence["ContinuousPalette"]] = None
    ):
        self.id = id
        self.label = label
        self.categoricalPalettes = categoricalPalettes
        self.sequentialPalettes = sequentialPalettes
        self.divergingPalettes = divergingPalettes


@attr.s(auto_attribs=True, init=False)
class ColorStop(model.Model):
    """
    Attributes:
        color: CSS color string
        offset: Offset in continuous palette (0 to 100)
    """

    color: Optional[str] = None
    offset: Optional[int] = None

    def __init__(self, *, color: Optional[str] = None, offset: Optional[int] = None):
        self.color = color
        self.offset = offset


@attr.s(auto_attribs=True, init=False)
class ColumnSearch(model.Model):
    """
    Attributes:
        schema_name: Name of schema containing the table
        table_name: Name of table containing the column
        column_name: Name of column
        data_type: Column data type
    """

    schema_name: Optional[str] = None
    table_name: Optional[str] = None
    column_name: Optional[str] = None
    data_type: Optional[str] = None

    def __init__(
        self,
        *,
        schema_name: Optional[str] = None,
        table_name: Optional[str] = None,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None
    ):
        self.schema_name = schema_name
        self.table_name = table_name
        self.column_name = column_name
        self.data_type = data_type


class ComparisonType(enum.Enum):
    """
    This property informs the check what kind of comparison we are performing. Only certain condition types are valid for time series alerts. For details, refer to [Setting Alert Conditions](https://docs.looker.com/sharing-and-publishing/creating-alerts#setting_alert_conditions) Valid values are: "EQUAL_TO", "GREATER_THAN", "GREATER_THAN_OR_EQUAL_TO", "LESS_THAN", "LESS_THAN_OR_EQUAL_TO", "INCREASES_BY", "DECREASES_BY", "CHANGES_BY". (Enum defined in Alert)

    """

    EQUAL_TO = "EQUAL_TO"
    GREATER_THAN = "GREATER_THAN"
    GREATER_THAN_OR_EQUAL_TO = "GREATER_THAN_OR_EQUAL_TO"
    LESS_THAN = "LESS_THAN"
    LESS_THAN_OR_EQUAL_TO = "LESS_THAN_OR_EQUAL_TO"
    INCREASES_BY = "INCREASES_BY"
    DECREASES_BY = "DECREASES_BY"
    CHANGES_BY = "CHANGES_BY"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
ComparisonType.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class ConnectionFeatures(model.Model):
    """
    Attributes:
        dialect_name: Name of the dialect for this connection
        cost_estimate: True for cost estimating support
        multiple_databases: True for multiple database support
        column_search: True for cost estimating support
        persistent_table_indexes: True for secondary index support
        persistent_derived_tables: True for persistent derived table support
        turtles: True for turtles support
        percentile: True for percentile support
        distinct_percentile: True for distinct percentile support
        stable_views: True for stable views support
        milliseconds: True for millisecond support
        microseconds: True for microsecond support
        subtotals: True for subtotal support
        location: True for geographic location support
        timezone: True for timezone conversion in query support
        connection_pooling: True for connection pooling support
    """

    dialect_name: Optional[str] = None
    cost_estimate: Optional[bool] = None
    multiple_databases: Optional[bool] = None
    column_search: Optional[bool] = None
    persistent_table_indexes: Optional[bool] = None
    persistent_derived_tables: Optional[bool] = None
    turtles: Optional[bool] = None
    percentile: Optional[bool] = None
    distinct_percentile: Optional[bool] = None
    stable_views: Optional[bool] = None
    milliseconds: Optional[bool] = None
    microseconds: Optional[bool] = None
    subtotals: Optional[bool] = None
    location: Optional[bool] = None
    timezone: Optional[bool] = None
    connection_pooling: Optional[bool] = None

    def __init__(
        self,
        *,
        dialect_name: Optional[str] = None,
        cost_estimate: Optional[bool] = None,
        multiple_databases: Optional[bool] = None,
        column_search: Optional[bool] = None,
        persistent_table_indexes: Optional[bool] = None,
        persistent_derived_tables: Optional[bool] = None,
        turtles: Optional[bool] = None,
        percentile: Optional[bool] = None,
        distinct_percentile: Optional[bool] = None,
        stable_views: Optional[bool] = None,
        milliseconds: Optional[bool] = None,
        microseconds: Optional[bool] = None,
        subtotals: Optional[bool] = None,
        location: Optional[bool] = None,
        timezone: Optional[bool] = None,
        connection_pooling: Optional[bool] = None
    ):
        self.dialect_name = dialect_name
        self.cost_estimate = cost_estimate
        self.multiple_databases = multiple_databases
        self.column_search = column_search
        self.persistent_table_indexes = persistent_table_indexes
        self.persistent_derived_tables = persistent_derived_tables
        self.turtles = turtles
        self.percentile = percentile
        self.distinct_percentile = distinct_percentile
        self.stable_views = stable_views
        self.milliseconds = milliseconds
        self.microseconds = microseconds
        self.subtotals = subtotals
        self.location = location
        self.timezone = timezone
        self.connection_pooling = connection_pooling


@attr.s(auto_attribs=True, init=False)
class ContentFavorite(model.Model):
    """
    Attributes:
        id: Unique Id
        user_id: User Id which owns this ContentFavorite
        content_metadata_id: Content Metadata Id associated with this ContentFavorite
        look_id: Id of a look
        dashboard_id: Id of a dashboard
        look:
        dashboard:
        board_id: Id of a board
    """

    id: Optional[str] = None
    user_id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    look_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    look: Optional["LookBasic"] = None
    dashboard: Optional["DashboardBase"] = None
    board_id: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        user_id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        look_id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        look: Optional["LookBasic"] = None,
        dashboard: Optional["DashboardBase"] = None,
        board_id: Optional[str] = None
    ):
        self.id = id
        self.user_id = user_id
        self.content_metadata_id = content_metadata_id
        self.look_id = look_id
        self.dashboard_id = dashboard_id
        self.look = look
        self.dashboard = dashboard
        self.board_id = board_id


@attr.s(auto_attribs=True, init=False)
class ContentMeta(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        name: Name or title of underlying content
        parent_id: Id of Parent Content
        dashboard_id: Id of associated dashboard when content_type is "dashboard"
        look_id: Id of associated look when content_type is "look"
        folder_id: Id of associated folder when content_type is "space"
        content_type: Content Type ("dashboard", "look", or "folder")
        inherits: Whether content inherits its access levels from parent
        inheriting_id: Id of Inherited Content
        slug: Content Slug
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    name: Optional[str] = None
    parent_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    look_id: Optional[str] = None
    folder_id: Optional[str] = None
    content_type: Optional[str] = None
    inherits: Optional[bool] = None
    inheriting_id: Optional[str] = None
    slug: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        parent_id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        look_id: Optional[str] = None,
        folder_id: Optional[str] = None,
        content_type: Optional[str] = None,
        inherits: Optional[bool] = None,
        inheriting_id: Optional[str] = None,
        slug: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.name = name
        self.parent_id = parent_id
        self.dashboard_id = dashboard_id
        self.look_id = look_id
        self.folder_id = folder_id
        self.content_type = content_type
        self.inherits = inherits
        self.inheriting_id = inheriting_id
        self.slug = slug


@attr.s(auto_attribs=True, init=False)
class ContentMetaGroupUser(model.Model):
    """
    WARNING: no writeable properties found for POST, PUT, or PATCH

    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        content_metadata_id: Id of associated Content Metadata
        permission_type: Type of permission: "view" or "edit" Valid values are: "view", "edit".
        group_id: ID of associated group
        user_id: ID of associated user
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    permission_type: Optional["PermissionType"] = None
    group_id: Optional[str] = None
    user_id: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        permission_type: Optional["PermissionType"] = None,
        group_id: Optional[str] = None,
        user_id: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.content_metadata_id = content_metadata_id
        self.permission_type = permission_type
        self.group_id = group_id
        self.user_id = user_id


@attr.s(auto_attribs=True, init=False)
class ContentValidation(model.Model):
    """
    Attributes:
        content_with_errors: A list of content errors
        computation_time: Duration of content validation in seconds
        total_looks_validated: The number of looks validated
        total_dashboard_elements_validated: The number of dashboard elements validated
        total_dashboard_filters_validated: The number of dashboard filters validated
        total_scheduled_plans_validated: The number of scheduled plans validated
        total_alerts_validated: The number of alerts validated
        total_explores_validated: The number of explores used across all content validated
    """

    content_with_errors: Optional[Sequence["ContentValidatorError"]] = None
    computation_time: Optional[float] = None
    total_looks_validated: Optional[int] = None
    total_dashboard_elements_validated: Optional[int] = None
    total_dashboard_filters_validated: Optional[int] = None
    total_scheduled_plans_validated: Optional[int] = None
    total_alerts_validated: Optional[int] = None
    total_explores_validated: Optional[int] = None

    def __init__(
        self,
        *,
        content_with_errors: Optional[Sequence["ContentValidatorError"]] = None,
        computation_time: Optional[float] = None,
        total_looks_validated: Optional[int] = None,
        total_dashboard_elements_validated: Optional[int] = None,
        total_dashboard_filters_validated: Optional[int] = None,
        total_scheduled_plans_validated: Optional[int] = None,
        total_alerts_validated: Optional[int] = None,
        total_explores_validated: Optional[int] = None
    ):
        self.content_with_errors = content_with_errors
        self.computation_time = computation_time
        self.total_looks_validated = total_looks_validated
        self.total_dashboard_elements_validated = total_dashboard_elements_validated
        self.total_dashboard_filters_validated = total_dashboard_filters_validated
        self.total_scheduled_plans_validated = total_scheduled_plans_validated
        self.total_alerts_validated = total_alerts_validated
        self.total_explores_validated = total_explores_validated


@attr.s(auto_attribs=True, init=False)
class ContentValidationAlert(model.Model):
    """
    Attributes:
        id: ID of the alert
        lookml_dashboard_id: ID of the LookML dashboard associated with the alert
        lookml_link_id: ID of the LookML dashboard element associated with the alert
        custom_title: An optional, user-defined title for the alert
    """

    id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    lookml_link_id: Optional[str] = None
    custom_title: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        lookml_link_id: Optional[str] = None,
        custom_title: Optional[str] = None
    ):
        self.id = id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.lookml_link_id = lookml_link_id
        self.custom_title = custom_title


@attr.s(auto_attribs=True, init=False)
class ContentValidationDashboard(model.Model):
    """
    Attributes:
        description: Description
        id: Unique Id
        folder:
        title: Dashboard Title
        url: Relative URL of the dashboard
    """

    description: Optional[str] = None
    id: Optional[str] = None
    folder: Optional["ContentValidationFolder"] = None
    title: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        id: Optional[str] = None,
        folder: Optional["ContentValidationFolder"] = None,
        title: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.description = description
        self.id = id
        self.folder = folder
        self.title = title
        self.url = url


@attr.s(auto_attribs=True, init=False)
class ContentValidationDashboardElement(model.Model):
    """
    Attributes:
        body_text: Text tile body text
        dashboard_id: Id of Dashboard
        id: Unique Id
        look_id: Id Of Look
        note_display: Note Display
        note_state: Note State
        note_text: Note Text
        note_text_as_html: Note Text as Html
        query_id: Id Of Query
        subtitle_text: Text tile subtitle text
        title: Title of dashboard element
        title_hidden: Whether title is hidden
        title_text: Text tile title
        type: Type
        rich_content_json: JSON with all the properties required for rich editor and buttons elements
    """

    body_text: Optional[str] = None
    dashboard_id: Optional[str] = None
    id: Optional[str] = None
    look_id: Optional[str] = None
    note_display: Optional[str] = None
    note_state: Optional[str] = None
    note_text: Optional[str] = None
    note_text_as_html: Optional[str] = None
    query_id: Optional[str] = None
    subtitle_text: Optional[str] = None
    title: Optional[str] = None
    title_hidden: Optional[bool] = None
    title_text: Optional[str] = None
    type: Optional[str] = None
    rich_content_json: Optional[str] = None

    def __init__(
        self,
        *,
        body_text: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        id: Optional[str] = None,
        look_id: Optional[str] = None,
        note_display: Optional[str] = None,
        note_state: Optional[str] = None,
        note_text: Optional[str] = None,
        note_text_as_html: Optional[str] = None,
        query_id: Optional[str] = None,
        subtitle_text: Optional[str] = None,
        title: Optional[str] = None,
        title_hidden: Optional[bool] = None,
        title_text: Optional[str] = None,
        type: Optional[str] = None,
        rich_content_json: Optional[str] = None
    ):
        self.body_text = body_text
        self.dashboard_id = dashboard_id
        self.id = id
        self.look_id = look_id
        self.note_display = note_display
        self.note_state = note_state
        self.note_text = note_text
        self.note_text_as_html = note_text_as_html
        self.query_id = query_id
        self.subtitle_text = subtitle_text
        self.title = title
        self.title_hidden = title_hidden
        self.title_text = title_text
        self.type = type
        self.rich_content_json = rich_content_json


@attr.s(auto_attribs=True, init=False)
class ContentValidationDashboardFilter(model.Model):
    """
    Attributes:
        id: Unique Id
        dashboard_id: Id of Dashboard
        name: Name of filter
        title: Title of filter
        type: Type of filter: one of date, number, string, or field
        default_value: Default value of filter
        model: Model of filter (required if type = field)
        explore: Explore of filter (required if type = field)
        dimension: Dimension of filter (required if type = field)
    """

    id: Optional[str] = None
    dashboard_id: Optional[str] = None
    name: Optional[str] = None
    title: Optional[str] = None
    type: Optional[str] = None
    default_value: Optional[str] = None
    model: Optional[str] = None
    explore: Optional[str] = None
    dimension: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        name: Optional[str] = None,
        title: Optional[str] = None,
        type: Optional[str] = None,
        default_value: Optional[str] = None,
        model: Optional[str] = None,
        explore: Optional[str] = None,
        dimension: Optional[str] = None
    ):
        self.id = id
        self.dashboard_id = dashboard_id
        self.name = name
        self.title = title
        self.type = type
        self.default_value = default_value
        self.model = model
        self.explore = explore
        self.dimension = dimension


@attr.s(auto_attribs=True, init=False)
class ContentValidationError(model.Model):
    """
    Attributes:
        message: Error message
        field_name: Name of the field involved in the error
        model_name: Name of the model involved in the error
        explore_name: Name of the explore involved in the error
        removable: Whether this validation error is removable
    """

    message: Optional[str] = None
    field_name: Optional[str] = None
    model_name: Optional[str] = None
    explore_name: Optional[str] = None
    removable: Optional[bool] = None

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        field_name: Optional[str] = None,
        model_name: Optional[str] = None,
        explore_name: Optional[str] = None,
        removable: Optional[bool] = None
    ):
        self.message = message
        self.field_name = field_name
        self.model_name = model_name
        self.explore_name = explore_name
        self.removable = removable


@attr.s(auto_attribs=True, init=False)
class ContentValidationFolder(model.Model):
    """
    Attributes:
        name: Unique Name
        id: Unique Id
    """

    name: str
    id: Optional[str] = None

    def __init__(self, *, name: str, id: Optional[str] = None):
        self.name = name
        self.id = id


@attr.s(auto_attribs=True, init=False)
class ContentValidationLook(model.Model):
    """
    Attributes:
        id: Unique Id
        title: Look Title
        short_url: Short Url
        folder:
    """

    id: Optional[str] = None
    title: Optional[str] = None
    short_url: Optional[str] = None
    folder: Optional["ContentValidationFolder"] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[str] = None,
        short_url: Optional[str] = None,
        folder: Optional["ContentValidationFolder"] = None
    ):
        self.id = id
        self.title = title
        self.short_url = short_url
        self.folder = folder


@attr.s(auto_attribs=True, init=False)
class ContentValidationLookMLDashboard(model.Model):
    """
    Attributes:
        id: ID of the LookML Dashboard
        title: Title of the LookML Dashboard
        space_id: ID of Space
    """

    id: Optional[str] = None
    title: Optional[str] = None
    space_id: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[str] = None,
        space_id: Optional[str] = None
    ):
        self.id = id
        self.title = title
        self.space_id = space_id


@attr.s(auto_attribs=True, init=False)
class ContentValidationLookMLDashboardElement(model.Model):
    """
    Attributes:
        lookml_link_id: Link ID of the LookML Dashboard Element
        title: Title of the LookML Dashboard Element
    """

    lookml_link_id: Optional[str] = None
    title: Optional[str] = None

    def __init__(
        self, *, lookml_link_id: Optional[str] = None, title: Optional[str] = None
    ):
        self.lookml_link_id = lookml_link_id
        self.title = title


@attr.s(auto_attribs=True, init=False)
class ContentValidationScheduledPlan(model.Model):
    """
    Attributes:
        name: Name of this scheduled plan
        look_id: Id of a look
        id: Unique Id
    """

    name: Optional[str] = None
    look_id: Optional[str] = None
    id: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        look_id: Optional[str] = None,
        id: Optional[str] = None
    ):
        self.name = name
        self.look_id = look_id
        self.id = id


@attr.s(auto_attribs=True, init=False)
class ContentValidatorError(model.Model):
    """
    Attributes:
        look:
        dashboard:
        dashboard_element:
        dashboard_filter:
        scheduled_plan:
        alert:
        lookml_dashboard:
        lookml_dashboard_element:
        errors: A list of errors found for this piece of content
        id: An id unique to this piece of content for this validation run
    """

    look: Optional["ContentValidationLook"] = None
    dashboard: Optional["ContentValidationDashboard"] = None
    dashboard_element: Optional["ContentValidationDashboardElement"] = None
    dashboard_filter: Optional["ContentValidationDashboardFilter"] = None
    scheduled_plan: Optional["ContentValidationScheduledPlan"] = None
    alert: Optional["ContentValidationAlert"] = None
    lookml_dashboard: Optional["ContentValidationLookMLDashboard"] = None
    lookml_dashboard_element: Optional["ContentValidationLookMLDashboardElement"] = None
    errors: Optional[Sequence["ContentValidationError"]] = None
    id: Optional[str] = None

    def __init__(
        self,
        *,
        look: Optional["ContentValidationLook"] = None,
        dashboard: Optional["ContentValidationDashboard"] = None,
        dashboard_element: Optional["ContentValidationDashboardElement"] = None,
        dashboard_filter: Optional["ContentValidationDashboardFilter"] = None,
        scheduled_plan: Optional["ContentValidationScheduledPlan"] = None,
        alert: Optional["ContentValidationAlert"] = None,
        lookml_dashboard: Optional["ContentValidationLookMLDashboard"] = None,
        lookml_dashboard_element: Optional[
            "ContentValidationLookMLDashboardElement"
        ] = None,
        errors: Optional[Sequence["ContentValidationError"]] = None,
        id: Optional[str] = None
    ):
        self.look = look
        self.dashboard = dashboard
        self.dashboard_element = dashboard_element
        self.dashboard_filter = dashboard_filter
        self.scheduled_plan = scheduled_plan
        self.alert = alert
        self.lookml_dashboard = lookml_dashboard
        self.lookml_dashboard_element = lookml_dashboard_element
        self.errors = errors
        self.id = id


@attr.s(auto_attribs=True, init=False)
class ContentView(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        look_id: Id of viewed Look
        dashboard_id: Id of the viewed Dashboard
        title: Name or title of underlying content
        content_metadata_id: Content metadata id of the Look or Dashboard
        user_id: Id of user content was viewed by
        group_id: Id of group content was viewed by
        view_count: Number of times piece of content was viewed
        favorite_count: Number of times piece of content was favorited
        last_viewed_at: Date the piece of content was last viewed
        start_of_week_date: Week start date for the view and favorite count during that given week
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    look_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    title: Optional[str] = None
    content_metadata_id: Optional[str] = None
    user_id: Optional[str] = None
    group_id: Optional[str] = None
    view_count: Optional[int] = None
    favorite_count: Optional[int] = None
    last_viewed_at: Optional[str] = None
    start_of_week_date: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        look_id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        title: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        user_id: Optional[str] = None,
        group_id: Optional[str] = None,
        view_count: Optional[int] = None,
        favorite_count: Optional[int] = None,
        last_viewed_at: Optional[str] = None,
        start_of_week_date: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.look_id = look_id
        self.dashboard_id = dashboard_id
        self.title = title
        self.content_metadata_id = content_metadata_id
        self.user_id = user_id
        self.group_id = group_id
        self.view_count = view_count
        self.favorite_count = favorite_count
        self.last_viewed_at = last_viewed_at
        self.start_of_week_date = start_of_week_date


@attr.s(auto_attribs=True, init=False)
class ContinuousPalette(model.Model):
    """
    Attributes:
        id: Unique identity string
        label: Label for palette
        type: Type of palette
        stops: Array of ColorStops in the palette
    """

    id: Optional[str] = None
    label: Optional[str] = None
    type: Optional[str] = None
    stops: Optional[Sequence["ColorStop"]] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        label: Optional[str] = None,
        type: Optional[str] = None,
        stops: Optional[Sequence["ColorStop"]] = None
    ):
        self.id = id
        self.label = label
        self.type = type
        self.stops = stops


@attr.s(auto_attribs=True, init=False)
class CostEstimate(model.Model):
    """
    Attributes:
        cost: Cost of SQL statement
        cache_hit: Does the result come from the cache?
        cost_unit: Cost measurement size
        message: Human-friendly message
    """

    cost: Optional[int] = None
    cache_hit: Optional[bool] = None
    cost_unit: Optional[str] = None
    message: Optional[str] = None

    def __init__(
        self,
        *,
        cost: Optional[int] = None,
        cache_hit: Optional[bool] = None,
        cost_unit: Optional[str] = None,
        message: Optional[str] = None
    ):
        self.cost = cost
        self.cache_hit = cache_hit
        self.cost_unit = cost_unit
        self.message = message


@attr.s(auto_attribs=True, init=False)
class CreateCostEstimate(model.Model):
    """
    WARNING: no writeable properties found for POST, PUT, or PATCH

    Attributes:
        sql: SQL statement to estimate
    """

    sql: Optional[str] = None

    def __init__(self, *, sql: Optional[str] = None):
        self.sql = sql


@attr.s(auto_attribs=True, init=False)
class CreateCredentialsApi3(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        client_id: API key client_id
        created_at: Timestamp for the creation of this credential
        is_disabled: Has this credential been disabled?
        type: Short name for the type of this kind of credential
        client_secret: API key client_secret
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    client_id: Optional[str] = None
    created_at: Optional[str] = None
    is_disabled: Optional[bool] = None
    type: Optional[str] = None
    client_secret: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        client_id: Optional[str] = None,
        created_at: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        type: Optional[str] = None,
        client_secret: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.client_id = client_id
        self.created_at = created_at
        self.is_disabled = is_disabled
        self.type = type
        self.client_secret = client_secret
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CreateDashboardFilter(model.Model):
    """
    Attributes:
        dashboard_id: Id of Dashboard
        name: Name of filter
        title: Title of filter
        type: Type of filter: one of date, number, string, or field
        id: Unique Id
        default_value: Default value of filter
        model: Model of filter (required if type = field)
        explore: Explore of filter (required if type = field)
        dimension: Dimension of filter (required if type = field)
        field: Field information
        row: Display order of this filter relative to other filters
        listens_to_filters: Array of listeners for faceted filters
        allow_multiple_values: Whether the filter allows multiple filter values (deprecated in the latest version of dashboards)
        required: Whether the filter requires a value to run the dashboard
        ui_config: The visual configuration for this filter. Used to set up how the UI for this filter should appear.
    """

    dashboard_id: str
    name: str
    title: str
    type: str
    id: Optional[str] = None
    default_value: Optional[str] = None
    model: Optional[str] = None
    explore: Optional[str] = None
    dimension: Optional[str] = None
    field: Optional[MutableMapping[str, Any]] = None
    row: Optional[int] = None
    listens_to_filters: Optional[Sequence[str]] = None
    allow_multiple_values: Optional[bool] = None
    required: Optional[bool] = None
    ui_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        dashboard_id: str,
        name: str,
        title: str,
        type: str,
        id: Optional[str] = None,
        default_value: Optional[str] = None,
        model: Optional[str] = None,
        explore: Optional[str] = None,
        dimension: Optional[str] = None,
        field: Optional[MutableMapping[str, Any]] = None,
        row: Optional[int] = None,
        listens_to_filters: Optional[Sequence[str]] = None,
        allow_multiple_values: Optional[bool] = None,
        required: Optional[bool] = None,
        ui_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.dashboard_id = dashboard_id
        self.name = name
        self.title = title
        self.type = type
        self.id = id
        self.default_value = default_value
        self.model = model
        self.explore = explore
        self.dimension = dimension
        self.field = field
        self.row = row
        self.listens_to_filters = listens_to_filters
        self.allow_multiple_values = allow_multiple_values
        self.required = required
        self.ui_config = ui_config


@attr.s(auto_attribs=True, init=False)
class CreateDashboardRenderTask(model.Model):
    """
    Attributes:
        dashboard_filters: Filter values to apply to the dashboard queries, in URL query format
        dashboard_style: Dashboard layout style: single_column or tiled
    """

    dashboard_filters: Optional[str] = None
    dashboard_style: Optional[str] = None

    def __init__(
        self,
        *,
        dashboard_filters: Optional[str] = None,
        dashboard_style: Optional[str] = None
    ):
        self.dashboard_filters = dashboard_filters
        self.dashboard_style = dashboard_style


@attr.s(auto_attribs=True, init=False)
class CreateEmbedUserRequest(model.Model):
    """
    Attributes:
        external_user_id:
    """

    external_user_id: str

    def __init__(self, *, external_user_id: str):
        self.external_user_id = external_user_id


@attr.s(auto_attribs=True, init=False)
class CreateFolder(model.Model):
    """
    Attributes:
        name: Unique Name
        parent_id: Id of Parent. If the parent id is null, this is a root-level entry
    """

    name: str
    parent_id: str

    def __init__(self, *, name: str, parent_id: str):
        self.name = name
        self.parent_id = parent_id


@attr.s(auto_attribs=True, init=False)
class CreateOAuthApplicationUserStateRequest(model.Model):
    """
    Attributes:
        user_id:
        oauth_application_id:
        access_token:
        access_token_expires_at:
        refresh_token:
        refresh_token_expires_at:
    """

    user_id: str
    oauth_application_id: str
    access_token: str
    access_token_expires_at: datetime.datetime
    refresh_token: Optional[str] = None
    refresh_token_expires_at: Optional[datetime.datetime] = None

    def __init__(
        self,
        *,
        user_id: str,
        oauth_application_id: str,
        access_token: str,
        access_token_expires_at: datetime.datetime,
        refresh_token: Optional[str] = None,
        refresh_token_expires_at: Optional[datetime.datetime] = None
    ):
        self.user_id = user_id
        self.oauth_application_id = oauth_application_id
        self.access_token = access_token
        self.access_token_expires_at = access_token_expires_at
        self.refresh_token = refresh_token
        self.refresh_token_expires_at = refresh_token_expires_at


@attr.s(auto_attribs=True, init=False)
class CreateOAuthApplicationUserStateResponse(model.Model):
    """
    Attributes:
        user_id: User Id
        oauth_application_id: OAuth Application ID
    """

    user_id: str
    oauth_application_id: str

    def __init__(self, *, user_id: str, oauth_application_id: str):
        self.user_id = user_id
        self.oauth_application_id = oauth_application_id


@attr.s(auto_attribs=True, init=False)
class CreateQueryTask(model.Model):
    """
    Attributes:
        query_id: Id of query to run
        result_format: Desired async query result format. Valid values are: "inline_json", "json", "json_detail", "json_fe", "csv", "html", "md", "txt", "xlsx", "gsxml".
        can: Operations the current user is able to perform on this object
        source: Source of query task
        deferred: Create the task but defer execution
        look_id: Id of look associated with query.
        dashboard_id: Id of dashboard associated with query.
    """

    query_id: str
    result_format: "ResultFormat"
    can: Optional[MutableMapping[str, bool]] = None
    source: Optional[str] = None
    deferred: Optional[bool] = None
    look_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    __annotations__ = {
        "query_id": str,
        "result_format": ForwardRef("ResultFormat"),
        "can": Optional[MutableMapping[str, bool]],
        "source": Optional[str],
        "deferred": Optional[bool],
        "look_id": Optional[str],
        "dashboard_id": Optional[str],
    }

    def __init__(
        self,
        *,
        query_id: str,
        result_format: "ResultFormat",
        can: Optional[MutableMapping[str, bool]] = None,
        source: Optional[str] = None,
        deferred: Optional[bool] = None,
        look_id: Optional[str] = None,
        dashboard_id: Optional[str] = None
    ):
        self.query_id = query_id
        self.result_format = result_format
        self.can = can
        self.source = source
        self.deferred = deferred
        self.look_id = look_id
        self.dashboard_id = dashboard_id


@attr.s(auto_attribs=True, init=False)
class CredentialsApi3(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        client_id: API key client_id
        created_at: Timestamp for the creation of this credential
        is_disabled: Has this credential been disabled?
        type: Short name for the type of this kind of credential
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    client_id: Optional[str] = None
    created_at: Optional[str] = None
    is_disabled: Optional[bool] = None
    type: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        client_id: Optional[str] = None,
        created_at: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        type: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.client_id = client_id
        self.created_at = created_at
        self.is_disabled = is_disabled
        self.type = type
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CredentialsEmail(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        email: EMail address used for user login
        forced_password_reset_at_next_login: Force the user to change their password upon their next login
        is_disabled: Has this credential been disabled?
        logged_in_at: Timestamp for most recent login using credential
        password_reset_url: Url with one-time use secret token that the user can use to reset password
        type: Short name for the type of this kind of credential
        url: Link to get this item
        user_url: Link to get this user
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    email: Optional[str] = None
    forced_password_reset_at_next_login: Optional[bool] = None
    is_disabled: Optional[bool] = None
    logged_in_at: Optional[str] = None
    password_reset_url: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None
    user_url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        email: Optional[str] = None,
        forced_password_reset_at_next_login: Optional[bool] = None,
        is_disabled: Optional[bool] = None,
        logged_in_at: Optional[str] = None,
        password_reset_url: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None,
        user_url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.email = email
        self.forced_password_reset_at_next_login = forced_password_reset_at_next_login
        self.is_disabled = is_disabled
        self.logged_in_at = logged_in_at
        self.password_reset_url = password_reset_url
        self.type = type
        self.url = url
        self.user_url = user_url


@attr.s(auto_attribs=True, init=False)
class CredentialsEmailSearch(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        email: EMail address used for user login
        forced_password_reset_at_next_login: Force the user to change their password upon their next login
        is_disabled: Has this credential been disabled?
        logged_in_at: Timestamp for most recent login using credential
        password_reset_url: Url with one-time use secret token that the user can use to reset password
        type: Short name for the type of this kind of credential
        url: Link to get this item
        user_url: Link to get this user
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    email: Optional[str] = None
    forced_password_reset_at_next_login: Optional[bool] = None
    is_disabled: Optional[bool] = None
    logged_in_at: Optional[str] = None
    password_reset_url: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None
    user_url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        email: Optional[str] = None,
        forced_password_reset_at_next_login: Optional[bool] = None,
        is_disabled: Optional[bool] = None,
        logged_in_at: Optional[str] = None,
        password_reset_url: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None,
        user_url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.email = email
        self.forced_password_reset_at_next_login = forced_password_reset_at_next_login
        self.is_disabled = is_disabled
        self.logged_in_at = logged_in_at
        self.password_reset_url = password_reset_url
        self.type = type
        self.url = url
        self.user_url = user_url


@attr.s(auto_attribs=True, init=False)
class CredentialsEmbed(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        external_group_id: Embedder's id for a group to which this user was added during the most recent login
        external_user_id: Embedder's unique id for the user
        id: Unique Id
        is_disabled: Has this credential been disabled?
        logged_in_at: Timestamp for most recent login using credential
        type: Short name for the type of this kind of credential
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    external_group_id: Optional[str] = None
    external_user_id: Optional[str] = None
    id: Optional[str] = None
    is_disabled: Optional[bool] = None
    logged_in_at: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        external_group_id: Optional[str] = None,
        external_user_id: Optional[str] = None,
        id: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        logged_in_at: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.external_group_id = external_group_id
        self.external_user_id = external_user_id
        self.id = id
        self.is_disabled = is_disabled
        self.logged_in_at = logged_in_at
        self.type = type
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CredentialsGoogle(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        domain: Google domain
        email: EMail address
        google_user_id: Google's Unique ID for this user
        is_disabled: Has this credential been disabled?
        logged_in_at: Timestamp for most recent login using credential
        type: Short name for the type of this kind of credential
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    domain: Optional[str] = None
    email: Optional[str] = None
    google_user_id: Optional[str] = None
    is_disabled: Optional[bool] = None
    logged_in_at: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        domain: Optional[str] = None,
        email: Optional[str] = None,
        google_user_id: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        logged_in_at: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.domain = domain
        self.email = email
        self.google_user_id = google_user_id
        self.is_disabled = is_disabled
        self.logged_in_at = logged_in_at
        self.type = type
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CredentialsLDAP(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        email: EMail address
        is_disabled: Has this credential been disabled?
        ldap_dn: LDAP Distinguished name for this user (as-of the last login)
        ldap_id: LDAP Unique ID for this user
        logged_in_at: Timestamp for most recent login using credential
        type: Short name for the type of this kind of credential
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    email: Optional[str] = None
    is_disabled: Optional[bool] = None
    ldap_dn: Optional[str] = None
    ldap_id: Optional[str] = None
    logged_in_at: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        email: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        ldap_dn: Optional[str] = None,
        ldap_id: Optional[str] = None,
        logged_in_at: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.email = email
        self.is_disabled = is_disabled
        self.ldap_dn = ldap_dn
        self.ldap_id = ldap_id
        self.logged_in_at = logged_in_at
        self.type = type
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CredentialsLookerOpenid(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        email: EMail address used for user login
        is_disabled: Has this credential been disabled?
        logged_in_at: Timestamp for most recent login using credential
        logged_in_ip: IP address of client for most recent login using credential
        type: Short name for the type of this kind of credential
        url: Link to get this item
        user_url: Link to get this user
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    email: Optional[str] = None
    is_disabled: Optional[bool] = None
    logged_in_at: Optional[str] = None
    logged_in_ip: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None
    user_url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        email: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        logged_in_at: Optional[str] = None,
        logged_in_ip: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None,
        user_url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.email = email
        self.is_disabled = is_disabled
        self.logged_in_at = logged_in_at
        self.logged_in_ip = logged_in_ip
        self.type = type
        self.url = url
        self.user_url = user_url


@attr.s(auto_attribs=True, init=False)
class CredentialsOIDC(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        email: EMail address
        is_disabled: Has this credential been disabled?
        logged_in_at: Timestamp for most recent login using credential
        oidc_user_id: OIDC OP's Unique ID for this user
        type: Short name for the type of this kind of credential
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    email: Optional[str] = None
    is_disabled: Optional[bool] = None
    logged_in_at: Optional[str] = None
    oidc_user_id: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        email: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        logged_in_at: Optional[str] = None,
        oidc_user_id: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.email = email
        self.is_disabled = is_disabled
        self.logged_in_at = logged_in_at
        self.oidc_user_id = oidc_user_id
        self.type = type
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CredentialsSaml(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        email: EMail address
        is_disabled: Has this credential been disabled?
        logged_in_at: Timestamp for most recent login using credential
        saml_user_id: Saml IdP's Unique ID for this user
        type: Short name for the type of this kind of credential
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    email: Optional[str] = None
    is_disabled: Optional[bool] = None
    logged_in_at: Optional[str] = None
    saml_user_id: Optional[str] = None
    type: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        email: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        logged_in_at: Optional[str] = None,
        saml_user_id: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.email = email
        self.is_disabled = is_disabled
        self.logged_in_at = logged_in_at
        self.saml_user_id = saml_user_id
        self.type = type
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CredentialsTotp(model.Model):
    """
    WARNING: no writeable properties found for POST, PUT, or PATCH

    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Timestamp for the creation of this credential
        is_disabled: Has this credential been disabled?
        type: Short name for the type of this kind of credential
        verified: User has verified
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    is_disabled: Optional[bool] = None
    type: Optional[str] = None
    verified: Optional[bool] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        type: Optional[str] = None,
        verified: Optional[bool] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.created_at = created_at
        self.is_disabled = is_disabled
        self.type = type
        self.verified = verified
        self.url = url


@attr.s(auto_attribs=True, init=False)
class CustomWelcomeEmail(model.Model):
    """
    Attributes:
        enabled: If true, custom email content will replace the default body of welcome emails
        content: The HTML to use as custom content for welcome emails. Script elements and other potentially dangerous markup will be removed.
        subject: The text to appear in the email subject line. Only available with a whitelabel license and whitelabel_configuration.advanced_custom_welcome_email enabled.
        header: The text to appear in the header line of the email body. Only available with a whitelabel license and whitelabel_configuration.advanced_custom_welcome_email enabled.
    """

    enabled: Optional[bool] = None
    content: Optional[str] = None
    subject: Optional[str] = None
    header: Optional[str] = None

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        content: Optional[str] = None,
        subject: Optional[str] = None,
        header: Optional[str] = None
    ):
        self.enabled = enabled
        self.content = content
        self.subject = subject
        self.header = header


@attr.s(auto_attribs=True, init=False)
class Dashboard(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_favorite_id: Content Favorite Id
        content_metadata_id: Id of content metadata
        description: Description
        hidden: Is Hidden
        id: Unique Id
        model:
        query_timezone: Timezone in which the Dashboard will run by default.
        readonly: Is Read-only
        refresh_interval: Refresh Interval, as a time duration phrase like "2 hours 30 minutes". A number with no time units will be interpreted as whole seconds.
        refresh_interval_to_i: Refresh Interval in milliseconds
        folder:
        title: Dashboard Title
        user_id: Id of User
        slug: Content Metadata Slug
        preferred_viewer: The preferred route for viewing this dashboard (ie: dashboards or dashboards-next)
        alert_sync_with_dashboard_filter_enabled: Enables alerts to keep in sync with dashboard filter changes
        background_color: Background color
        created_at: Time that the Dashboard was created.
        crossfilter_enabled: Enables crossfiltering in dashboards - only available in dashboards-next (beta)
        dashboard_elements: Elements
        dashboard_filters: Filters
        dashboard_layouts: Layouts
        deleted: Whether or not a dashboard is 'soft' deleted.
        deleted_at: Time that the Dashboard was 'soft' deleted.
        deleter_id: Id of User that 'soft' deleted the dashboard.
        edit_uri: Relative path of URI of LookML file to edit the dashboard (LookML dashboard only).
        favorite_count: Number of times favorited
        filters_bar_collapsed: Sets the default state of the filters bar to collapsed or open
        filters_location_top: Sets the default state of the filters location to top(true) or right(false)
        last_accessed_at: Time the dashboard was last accessed
        last_viewed_at: Time last viewed in the Looker web UI
        updated_at: Time that the Dashboard was most recently updated.
        last_updater_id: Id of User that most recently updated the dashboard.
        last_updater_name: Name of User that most recently updated the dashboard.
        user_name: Name of User that created the dashboard.
        load_configuration: configuration option that governs how dashboard loading will happen.
        lookml_link_id: Links this dashboard to a particular LookML dashboard such that calling a **sync** operation on that LookML dashboard will update this dashboard to match.
        show_filters_bar: Show filters bar.  **Security Note:** This property only affects the *cosmetic* appearance of the dashboard, not a user's ability to access data. Hiding the filters bar does **NOT** prevent users from changing filters by other means. For information on how to set up secure data access control policies, see [Control User Access to Data](https://docs.looker.com/r/api/control-access)
        show_title: Show title
        folder_id: Id of folder
        text_tile_text_color: Color of text on text tiles
        tile_background_color: Tile background color
        tile_text_color: Tile text color
        title_color: Title color
        view_count: Number of times viewed in the Looker web UI
        appearance:
        url: Relative URL of the dashboard
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_favorite_id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    description: Optional[str] = None
    hidden: Optional[bool] = None
    id: Optional[str] = None
    model: Optional["LookModel"] = None
    query_timezone: Optional[str] = None
    readonly: Optional[bool] = None
    refresh_interval: Optional[str] = None
    refresh_interval_to_i: Optional[int] = None
    folder: Optional["FolderBase"] = None
    title: Optional[str] = None
    user_id: Optional[str] = None
    slug: Optional[str] = None
    preferred_viewer: Optional[str] = None
    alert_sync_with_dashboard_filter_enabled: Optional[bool] = None
    background_color: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    crossfilter_enabled: Optional[bool] = None
    dashboard_elements: Optional[Sequence["DashboardElement"]] = None
    dashboard_filters: Optional[Sequence["DashboardFilter"]] = None
    dashboard_layouts: Optional[Sequence["DashboardLayout"]] = None
    deleted: Optional[bool] = None
    deleted_at: Optional[datetime.datetime] = None
    deleter_id: Optional[str] = None
    edit_uri: Optional[str] = None
    favorite_count: Optional[int] = None
    filters_bar_collapsed: Optional[bool] = None
    filters_location_top: Optional[bool] = None
    last_accessed_at: Optional[datetime.datetime] = None
    last_viewed_at: Optional[datetime.datetime] = None
    updated_at: Optional[datetime.datetime] = None
    last_updater_id: Optional[str] = None
    last_updater_name: Optional[str] = None
    user_name: Optional[str] = None
    load_configuration: Optional[str] = None
    lookml_link_id: Optional[str] = None
    show_filters_bar: Optional[bool] = None
    show_title: Optional[bool] = None
    folder_id: Optional[str] = None
    text_tile_text_color: Optional[str] = None
    tile_background_color: Optional[str] = None
    tile_text_color: Optional[str] = None
    title_color: Optional[str] = None
    view_count: Optional[int] = None
    appearance: Optional["DashboardAppearance"] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_favorite_id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        description: Optional[str] = None,
        hidden: Optional[bool] = None,
        id: Optional[str] = None,
        model: Optional["LookModel"] = None,
        query_timezone: Optional[str] = None,
        readonly: Optional[bool] = None,
        refresh_interval: Optional[str] = None,
        refresh_interval_to_i: Optional[int] = None,
        folder: Optional["FolderBase"] = None,
        title: Optional[str] = None,
        user_id: Optional[str] = None,
        slug: Optional[str] = None,
        preferred_viewer: Optional[str] = None,
        alert_sync_with_dashboard_filter_enabled: Optional[bool] = None,
        background_color: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        crossfilter_enabled: Optional[bool] = None,
        dashboard_elements: Optional[Sequence["DashboardElement"]] = None,
        dashboard_filters: Optional[Sequence["DashboardFilter"]] = None,
        dashboard_layouts: Optional[Sequence["DashboardLayout"]] = None,
        deleted: Optional[bool] = None,
        deleted_at: Optional[datetime.datetime] = None,
        deleter_id: Optional[str] = None,
        edit_uri: Optional[str] = None,
        favorite_count: Optional[int] = None,
        filters_bar_collapsed: Optional[bool] = None,
        filters_location_top: Optional[bool] = None,
        last_accessed_at: Optional[datetime.datetime] = None,
        last_viewed_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        last_updater_id: Optional[str] = None,
        last_updater_name: Optional[str] = None,
        user_name: Optional[str] = None,
        load_configuration: Optional[str] = None,
        lookml_link_id: Optional[str] = None,
        show_filters_bar: Optional[bool] = None,
        show_title: Optional[bool] = None,
        folder_id: Optional[str] = None,
        text_tile_text_color: Optional[str] = None,
        tile_background_color: Optional[str] = None,
        tile_text_color: Optional[str] = None,
        title_color: Optional[str] = None,
        view_count: Optional[int] = None,
        appearance: Optional["DashboardAppearance"] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.content_favorite_id = content_favorite_id
        self.content_metadata_id = content_metadata_id
        self.description = description
        self.hidden = hidden
        self.id = id
        self.model = model
        self.query_timezone = query_timezone
        self.readonly = readonly
        self.refresh_interval = refresh_interval
        self.refresh_interval_to_i = refresh_interval_to_i
        self.folder = folder
        self.title = title
        self.user_id = user_id
        self.slug = slug
        self.preferred_viewer = preferred_viewer
        self.alert_sync_with_dashboard_filter_enabled = (
            alert_sync_with_dashboard_filter_enabled
        )
        self.background_color = background_color
        self.created_at = created_at
        self.crossfilter_enabled = crossfilter_enabled
        self.dashboard_elements = dashboard_elements
        self.dashboard_filters = dashboard_filters
        self.dashboard_layouts = dashboard_layouts
        self.deleted = deleted
        self.deleted_at = deleted_at
        self.deleter_id = deleter_id
        self.edit_uri = edit_uri
        self.favorite_count = favorite_count
        self.filters_bar_collapsed = filters_bar_collapsed
        self.filters_location_top = filters_location_top
        self.last_accessed_at = last_accessed_at
        self.last_viewed_at = last_viewed_at
        self.updated_at = updated_at
        self.last_updater_id = last_updater_id
        self.last_updater_name = last_updater_name
        self.user_name = user_name
        self.load_configuration = load_configuration
        self.lookml_link_id = lookml_link_id
        self.show_filters_bar = show_filters_bar
        self.show_title = show_title
        self.folder_id = folder_id
        self.text_tile_text_color = text_tile_text_color
        self.tile_background_color = tile_background_color
        self.tile_text_color = tile_text_color
        self.title_color = title_color
        self.view_count = view_count
        self.appearance = appearance
        self.url = url


@attr.s(auto_attribs=True, init=False)
class DashboardAggregateTableLookml(model.Model):
    """
    Attributes:
        dashboard_id: Dashboard Id
        aggregate_table_lookml: Aggregate Table LookML
    """

    dashboard_id: Optional[str] = None
    aggregate_table_lookml: Optional[str] = None

    def __init__(
        self,
        *,
        dashboard_id: Optional[str] = None,
        aggregate_table_lookml: Optional[str] = None
    ):
        self.dashboard_id = dashboard_id
        self.aggregate_table_lookml = aggregate_table_lookml


@attr.s(auto_attribs=True, init=False)
class DashboardAppearance(model.Model):
    """
    Attributes:
        page_side_margins: Page margin (side) width
        page_background_color: Background color for the dashboard
        tile_title_alignment: Title alignment on dashboard tiles
        tile_space_between: Space between tiles
        tile_background_color: Background color for tiles
        tile_shadow: Tile shadow on/off
        key_color: Key color
    """

    page_side_margins: Optional[int] = None
    page_background_color: Optional[str] = None
    tile_title_alignment: Optional[str] = None
    tile_space_between: Optional[int] = None
    tile_background_color: Optional[str] = None
    tile_shadow: Optional[bool] = None
    key_color: Optional[str] = None

    def __init__(
        self,
        *,
        page_side_margins: Optional[int] = None,
        page_background_color: Optional[str] = None,
        tile_title_alignment: Optional[str] = None,
        tile_space_between: Optional[int] = None,
        tile_background_color: Optional[str] = None,
        tile_shadow: Optional[bool] = None,
        key_color: Optional[str] = None
    ):
        self.page_side_margins = page_side_margins
        self.page_background_color = page_background_color
        self.tile_title_alignment = tile_title_alignment
        self.tile_space_between = tile_space_between
        self.tile_background_color = tile_background_color
        self.tile_shadow = tile_shadow
        self.key_color = key_color


@attr.s(auto_attribs=True, init=False)
class DashboardBase(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_favorite_id: Content Favorite Id
        content_metadata_id: Id of content metadata
        description: Description
        hidden: Is Hidden
        id: Unique Id
        model:
        query_timezone: Timezone in which the Dashboard will run by default.
        readonly: Is Read-only
        refresh_interval: Refresh Interval, as a time duration phrase like "2 hours 30 minutes". A number with no time units will be interpreted as whole seconds.
        refresh_interval_to_i: Refresh Interval in milliseconds
        folder:
        title: Dashboard Title
        user_id: Id of User
        slug: Content Metadata Slug
        preferred_viewer: The preferred route for viewing this dashboard (ie: dashboards or dashboards-next)
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_favorite_id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    description: Optional[str] = None
    hidden: Optional[bool] = None
    id: Optional[str] = None
    model: Optional["LookModel"] = None
    query_timezone: Optional[str] = None
    readonly: Optional[bool] = None
    refresh_interval: Optional[str] = None
    refresh_interval_to_i: Optional[int] = None
    folder: Optional["FolderBase"] = None
    title: Optional[str] = None
    user_id: Optional[str] = None
    slug: Optional[str] = None
    preferred_viewer: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_favorite_id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        description: Optional[str] = None,
        hidden: Optional[bool] = None,
        id: Optional[str] = None,
        model: Optional["LookModel"] = None,
        query_timezone: Optional[str] = None,
        readonly: Optional[bool] = None,
        refresh_interval: Optional[str] = None,
        refresh_interval_to_i: Optional[int] = None,
        folder: Optional["FolderBase"] = None,
        title: Optional[str] = None,
        user_id: Optional[str] = None,
        slug: Optional[str] = None,
        preferred_viewer: Optional[str] = None
    ):
        self.can = can
        self.content_favorite_id = content_favorite_id
        self.content_metadata_id = content_metadata_id
        self.description = description
        self.hidden = hidden
        self.id = id
        self.model = model
        self.query_timezone = query_timezone
        self.readonly = readonly
        self.refresh_interval = refresh_interval
        self.refresh_interval_to_i = refresh_interval_to_i
        self.folder = folder
        self.title = title
        self.user_id = user_id
        self.slug = slug
        self.preferred_viewer = preferred_viewer


@attr.s(auto_attribs=True, init=False)
class DashboardElement(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        body_text: Text tile body text
        body_text_as_html: Text tile body text as Html
        dashboard_id: Id of Dashboard
        edit_uri: Relative path of URI of LookML file to edit the dashboard element (LookML dashboard only).
        id: Unique Id
        look:
        look_id: Id Of Look
        lookml_link_id: LookML link ID
        merge_result_id: ID of merge result
        note_display: Note Display
        note_state: Note State
        note_text: Note Text
        note_text_as_html: Note Text as Html
        query:
        query_id: Id Of Query
        refresh_interval: Refresh Interval
        refresh_interval_to_i: Refresh Interval as integer
        result_maker:
        result_maker_id: ID of the ResultMakerLookup entry.
        subtitle_text: Text tile subtitle text
        title: Title of dashboard element
        title_hidden: Whether title is hidden
        title_text: Text tile title
        type: Type
        alert_count: Count of Alerts associated to a dashboard element
        rich_content_json: JSON with all the properties required for rich editor and buttons elements
        title_text_as_html: Text tile title text as Html
        subtitle_text_as_html: Text tile subtitle text as Html
        extension_id: Extension ID
    """

    can: Optional[MutableMapping[str, bool]] = None
    body_text: Optional[str] = None
    body_text_as_html: Optional[str] = None
    dashboard_id: Optional[str] = None
    edit_uri: Optional[str] = None
    id: Optional[str] = None
    look: Optional["LookWithQuery"] = None
    look_id: Optional[str] = None
    lookml_link_id: Optional[str] = None
    merge_result_id: Optional[str] = None
    note_display: Optional[str] = None
    note_state: Optional[str] = None
    note_text: Optional[str] = None
    note_text_as_html: Optional[str] = None
    query: Optional["Query"] = None
    query_id: Optional[str] = None
    refresh_interval: Optional[str] = None
    refresh_interval_to_i: Optional[int] = None
    result_maker: Optional["ResultMakerWithIdVisConfigAndDynamicFields"] = None
    result_maker_id: Optional[str] = None
    subtitle_text: Optional[str] = None
    title: Optional[str] = None
    title_hidden: Optional[bool] = None
    title_text: Optional[str] = None
    type: Optional[str] = None
    alert_count: Optional[int] = None
    rich_content_json: Optional[str] = None
    title_text_as_html: Optional[str] = None
    subtitle_text_as_html: Optional[str] = None
    extension_id: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        body_text: Optional[str] = None,
        body_text_as_html: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        edit_uri: Optional[str] = None,
        id: Optional[str] = None,
        look: Optional["LookWithQuery"] = None,
        look_id: Optional[str] = None,
        lookml_link_id: Optional[str] = None,
        merge_result_id: Optional[str] = None,
        note_display: Optional[str] = None,
        note_state: Optional[str] = None,
        note_text: Optional[str] = None,
        note_text_as_html: Optional[str] = None,
        query: Optional["Query"] = None,
        query_id: Optional[str] = None,
        refresh_interval: Optional[str] = None,
        refresh_interval_to_i: Optional[int] = None,
        result_maker: Optional["ResultMakerWithIdVisConfigAndDynamicFields"] = None,
        result_maker_id: Optional[str] = None,
        subtitle_text: Optional[str] = None,
        title: Optional[str] = None,
        title_hidden: Optional[bool] = None,
        title_text: Optional[str] = None,
        type: Optional[str] = None,
        alert_count: Optional[int] = None,
        rich_content_json: Optional[str] = None,
        title_text_as_html: Optional[str] = None,
        subtitle_text_as_html: Optional[str] = None,
        extension_id: Optional[str] = None
    ):
        self.can = can
        self.body_text = body_text
        self.body_text_as_html = body_text_as_html
        self.dashboard_id = dashboard_id
        self.edit_uri = edit_uri
        self.id = id
        self.look = look
        self.look_id = look_id
        self.lookml_link_id = lookml_link_id
        self.merge_result_id = merge_result_id
        self.note_display = note_display
        self.note_state = note_state
        self.note_text = note_text
        self.note_text_as_html = note_text_as_html
        self.query = query
        self.query_id = query_id
        self.refresh_interval = refresh_interval
        self.refresh_interval_to_i = refresh_interval_to_i
        self.result_maker = result_maker
        self.result_maker_id = result_maker_id
        self.subtitle_text = subtitle_text
        self.title = title
        self.title_hidden = title_hidden
        self.title_text = title_text
        self.type = type
        self.alert_count = alert_count
        self.rich_content_json = rich_content_json
        self.title_text_as_html = title_text_as_html
        self.subtitle_text_as_html = subtitle_text_as_html
        self.extension_id = extension_id


@attr.s(auto_attribs=True, init=False)
class DashboardFilter(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        dashboard_id: Id of Dashboard
        name: Name of filter
        title: Title of filter
        type: Type of filter: one of date, number, string, or field
        default_value: Default value of filter
        model: Model of filter (required if type = field)
        explore: Explore of filter (required if type = field)
        dimension: Dimension of filter (required if type = field)
        field: Field information
        row: Display order of this filter relative to other filters
        listens_to_filters: Array of listeners for faceted filters
        allow_multiple_values: Whether the filter allows multiple filter values (deprecated in the latest version of dashboards)
        required: Whether the filter requires a value to run the dashboard
        ui_config: The visual configuration for this filter. Used to set up how the UI for this filter should appear.
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    dashboard_id: Optional[str] = None
    name: Optional[str] = None
    title: Optional[str] = None
    type: Optional[str] = None
    default_value: Optional[str] = None
    model: Optional[str] = None
    explore: Optional[str] = None
    dimension: Optional[str] = None
    field: Optional[MutableMapping[str, Any]] = None
    row: Optional[int] = None
    listens_to_filters: Optional[Sequence[str]] = None
    allow_multiple_values: Optional[bool] = None
    required: Optional[bool] = None
    ui_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        name: Optional[str] = None,
        title: Optional[str] = None,
        type: Optional[str] = None,
        default_value: Optional[str] = None,
        model: Optional[str] = None,
        explore: Optional[str] = None,
        dimension: Optional[str] = None,
        field: Optional[MutableMapping[str, Any]] = None,
        row: Optional[int] = None,
        listens_to_filters: Optional[Sequence[str]] = None,
        allow_multiple_values: Optional[bool] = None,
        required: Optional[bool] = None,
        ui_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.can = can
        self.id = id
        self.dashboard_id = dashboard_id
        self.name = name
        self.title = title
        self.type = type
        self.default_value = default_value
        self.model = model
        self.explore = explore
        self.dimension = dimension
        self.field = field
        self.row = row
        self.listens_to_filters = listens_to_filters
        self.allow_multiple_values = allow_multiple_values
        self.required = required
        self.ui_config = ui_config


@attr.s(auto_attribs=True, init=False)
class DashboardLayout(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        dashboard_id: Id of Dashboard
        type: Type
        active: Is Active
        column_width: Column Width
        width: Width
        deleted: Whether or not the dashboard layout is deleted.
        dashboard_title: Title extracted from the dashboard this layout represents.
        dashboard_layout_components: Components
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    dashboard_id: Optional[str] = None
    type: Optional[str] = None
    active: Optional[bool] = None
    column_width: Optional[int] = None
    width: Optional[int] = None
    deleted: Optional[bool] = None
    dashboard_title: Optional[str] = None
    dashboard_layout_components: Optional[Sequence["DashboardLayoutComponent"]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        type: Optional[str] = None,
        active: Optional[bool] = None,
        column_width: Optional[int] = None,
        width: Optional[int] = None,
        deleted: Optional[bool] = None,
        dashboard_title: Optional[str] = None,
        dashboard_layout_components: Optional[
            Sequence["DashboardLayoutComponent"]
        ] = None
    ):
        self.can = can
        self.id = id
        self.dashboard_id = dashboard_id
        self.type = type
        self.active = active
        self.column_width = column_width
        self.width = width
        self.deleted = deleted
        self.dashboard_title = dashboard_title
        self.dashboard_layout_components = dashboard_layout_components


@attr.s(auto_attribs=True, init=False)
class DashboardLayoutComponent(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        dashboard_layout_id: Id of Dashboard Layout
        dashboard_element_id: Id Of Dashboard Element
        row: Row
        column: Column
        width: Width
        height: Height
        deleted: Whether or not the dashboard layout component is deleted
        element_title: Dashboard element title, extracted from the Dashboard Element.
        element_title_hidden: Whether or not the dashboard element title is displayed.
        vis_type: Visualization type, extracted from a query's vis_config
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    dashboard_layout_id: Optional[str] = None
    dashboard_element_id: Optional[str] = None
    row: Optional[int] = None
    column: Optional[int] = None
    width: Optional[int] = None
    height: Optional[int] = None
    deleted: Optional[bool] = None
    element_title: Optional[str] = None
    element_title_hidden: Optional[bool] = None
    vis_type: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        dashboard_layout_id: Optional[str] = None,
        dashboard_element_id: Optional[str] = None,
        row: Optional[int] = None,
        column: Optional[int] = None,
        width: Optional[int] = None,
        height: Optional[int] = None,
        deleted: Optional[bool] = None,
        element_title: Optional[str] = None,
        element_title_hidden: Optional[bool] = None,
        vis_type: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.dashboard_layout_id = dashboard_layout_id
        self.dashboard_element_id = dashboard_element_id
        self.row = row
        self.column = column
        self.width = width
        self.height = height
        self.deleted = deleted
        self.element_title = element_title
        self.element_title_hidden = element_title_hidden
        self.vis_type = vis_type


@attr.s(auto_attribs=True, init=False)
class DashboardLookml(model.Model):
    """
    Attributes:
        dashboard_id: Id of Dashboard
        folder_id: (Write-Only) Id of the folder
        lookml: lookml of UDD
    """

    dashboard_id: Optional[str] = None
    folder_id: Optional[str] = None
    lookml: Optional[str] = None

    def __init__(
        self,
        *,
        dashboard_id: Optional[str] = None,
        folder_id: Optional[str] = None,
        lookml: Optional[str] = None
    ):
        self.dashboard_id = dashboard_id
        self.folder_id = folder_id
        self.lookml = lookml


@attr.s(auto_attribs=True, init=False)
class DataActionForm(model.Model):
    """
    Attributes:
        state:
        fields: Array of form fields.
    """

    state: Optional["DataActionUserState"] = None
    fields: Optional[Sequence["DataActionFormField"]] = None

    def __init__(
        self,
        *,
        state: Optional["DataActionUserState"] = None,
        fields: Optional[Sequence["DataActionFormField"]] = None
    ):
        self.state = state
        self.fields = fields


@attr.s(auto_attribs=True, init=False)
class DataActionFormField(model.Model):
    """
    Attributes:
        name: Name
        label: Human-readable label
        description: Description of field
        type: Type of field.
        default: Default value of the field.
        oauth_url: The URL for an oauth link, if type is 'oauth_link'.
        interactive: Whether or not a field supports interactive forms.
        required: Whether or not the field is required. This is a user-interface hint. A user interface displaying this form should not submit it without a value for this field. The action server must also perform this validation.
        options: If the form type is 'select', a list of options to be selected from.
    """

    name: Optional[str] = None
    label: Optional[str] = None
    description: Optional[str] = None
    type: Optional[str] = None
    default: Optional[str] = None
    oauth_url: Optional[str] = None
    interactive: Optional[bool] = None
    required: Optional[bool] = None
    options: Optional[Sequence["DataActionFormSelectOption"]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        label: Optional[str] = None,
        description: Optional[str] = None,
        type: Optional[str] = None,
        default: Optional[str] = None,
        oauth_url: Optional[str] = None,
        interactive: Optional[bool] = None,
        required: Optional[bool] = None,
        options: Optional[Sequence["DataActionFormSelectOption"]] = None
    ):
        self.name = name
        self.label = label
        self.description = description
        self.type = type
        self.default = default
        self.oauth_url = oauth_url
        self.interactive = interactive
        self.required = required
        self.options = options


@attr.s(auto_attribs=True, init=False)
class DataActionFormSelectOption(model.Model):
    """
    Attributes:
        name: Name
        label: Human-readable label
    """

    name: Optional[str] = None
    label: Optional[str] = None

    def __init__(self, *, name: Optional[str] = None, label: Optional[str] = None):
        self.name = name
        self.label = label


@attr.s(auto_attribs=True, init=False)
class DataActionRequest(model.Model):
    """
    Attributes:
        action: The JSON describing the data action. This JSON should be considered opaque and should be passed through unmodified from the query result it came from.
        form_values: User input for any form values the data action might use.
    """

    action: Optional[MutableMapping[str, Any]] = None
    form_values: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        action: Optional[MutableMapping[str, Any]] = None,
        form_values: Optional[MutableMapping[str, Any]] = None
    ):
        self.action = action
        self.form_values = form_values


@attr.s(auto_attribs=True, init=False)
class DataActionResponse(model.Model):
    """
    Attributes:
        webhook_id: ID of the webhook event that sent this data action. In some error conditions, this may be null.
        success: Whether the data action was successful.
        refresh_query: When true, indicates that the client should refresh (rerun) the source query because the data may have been changed by the action.
        validation_errors:
        message: Optional message returned by the data action server describing the state of the action that took place. This can be used to implement custom failure messages. If a failure is related to a particular form field, the server should send back a validation error instead. The Looker web UI does not currently display any message if the action indicates 'success', but may do so in the future.
    """

    webhook_id: Optional[str] = None
    success: Optional[bool] = None
    refresh_query: Optional[bool] = None
    validation_errors: Optional["ValidationError"] = None
    message: Optional[str] = None

    def __init__(
        self,
        *,
        webhook_id: Optional[str] = None,
        success: Optional[bool] = None,
        refresh_query: Optional[bool] = None,
        validation_errors: Optional["ValidationError"] = None,
        message: Optional[str] = None
    ):
        self.webhook_id = webhook_id
        self.success = success
        self.refresh_query = refresh_query
        self.validation_errors = validation_errors
        self.message = message


@attr.s(auto_attribs=True, init=False)
class DataActionUserState(model.Model):
    """
    Attributes:
        data: User state data
        refresh_time: Time in seconds until the state needs to be refreshed
    """

    data: Optional[str] = None
    refresh_time: Optional[int] = None

    def __init__(
        self, *, data: Optional[str] = None, refresh_time: Optional[int] = None
    ):
        self.data = data
        self.refresh_time = refresh_time


@attr.s(auto_attribs=True, init=False)
class Datagroup(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: UNIX timestamp at which this entry was created.
        id: Unique ID of the datagroup
        model_name: Name of the model containing the datagroup. Unique when combined with name.
        name: Name of the datagroup. Unique when combined with model_name.
        stale_before: UNIX timestamp before which cache entries are considered stale. Cannot be in the future.
        trigger_check_at: UNIX timestamp at which this entry trigger was last checked.
        trigger_error: The message returned with the error of the last trigger check.
        trigger_value: The value of the trigger when last checked.
        triggered_at: UNIX timestamp at which this entry became triggered. Cannot be in the future.
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[int] = None
    id: Optional[str] = None
    model_name: Optional[str] = None
    name: Optional[str] = None
    stale_before: Optional[int] = None
    trigger_check_at: Optional[int] = None
    trigger_error: Optional[str] = None
    trigger_value: Optional[str] = None
    triggered_at: Optional[int] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[int] = None,
        id: Optional[str] = None,
        model_name: Optional[str] = None,
        name: Optional[str] = None,
        stale_before: Optional[int] = None,
        trigger_check_at: Optional[int] = None,
        trigger_error: Optional[str] = None,
        trigger_value: Optional[str] = None,
        triggered_at: Optional[int] = None
    ):
        self.can = can
        self.created_at = created_at
        self.id = id
        self.model_name = model_name
        self.name = name
        self.stale_before = stale_before
        self.trigger_check_at = trigger_check_at
        self.trigger_error = trigger_error
        self.trigger_value = trigger_value
        self.triggered_at = triggered_at


@attr.s(auto_attribs=True, init=False)
class DBConnection(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        name: Name of the connection. Also used as the unique identifier
        dialect:
        snippets: SQL Runner snippets for this connection
        pdts_enabled: True if PDTs are enabled on this connection
        host: Host name/address of server
        port: Port number on server
        username: Username for server authentication
        password: (Write-Only) Password for server authentication
        uses_oauth: Whether the connection uses OAuth for authentication.
        certificate: (Write-Only) Base64 encoded Certificate body for server authentication (when appropriate for dialect).
        file_type: (Write-Only) Certificate keyfile type - .json or .p12
        database: Database name
        db_timezone: Time zone of database
        query_timezone: Timezone to use in queries
        schema: Scheme name
        max_connections: Maximum number of concurrent connection to use
        max_billing_gigabytes: Maximum size of query in GBs (BigQuery only, can be a user_attribute name)
        ssl: Use SSL/TLS when connecting to server
        verify_ssl: Verify the SSL
        tmp_db_name: Name of temporary database (if used)
        jdbc_additional_params: Additional params to add to JDBC connection string
        pool_timeout: Connection Pool Timeout, in seconds
        dialect_name: (Read/Write) SQL Dialect name
        supports_data_studio_link: Database connection has the ability to support open data studio from explore
        created_at: Creation date for this connection
        user_id: Id of user who last modified this connection configuration
        example: Is this an example connection?
        user_db_credentials: (Limited access feature) Are per user db credentials enabled. Enabling will remove previously set username and password
        user_attribute_fields: Fields whose values map to user attribute names
        maintenance_cron: Cron string specifying when maintenance such as PDT trigger checks and drops should be performed
        last_regen_at: Unix timestamp at start of last completed PDT trigger check process
        last_reap_at: Unix timestamp at start of last completed PDT reap process
        sql_runner_precache_tables: Precache tables in the SQL Runner
        sql_writing_with_info_schema: Fetch Information Schema For SQL Writing
        after_connect_statements: SQL statements (semicolon separated) to issue after connecting to the database. Requires `custom_after_connect_statements` license feature
        pdt_context_override:
        managed: Is this connection created and managed by Looker
        tunnel_id: The Id of the ssh tunnel this connection uses
        pdt_concurrency: Maximum number of threads to use to build PDTs in parallel
        disable_context_comment: When disable_context_comment is true comment will not be added to SQL
        oauth_application_id: An External OAuth Application to use for authenticating to the database
        always_retry_failed_builds: When true, error PDTs will be retried every regenerator cycle
        cost_estimate_enabled: When true, query cost estimate will be displayed in explore.
        pdt_api_control_enabled: PDT builds on this connection can be kicked off and cancelled via API.
    """

    can: Optional[MutableMapping[str, bool]] = None
    name: Optional[str] = None
    dialect: Optional["Dialect"] = None
    snippets: Optional[Sequence["Snippet"]] = None
    pdts_enabled: Optional[bool] = None
    host: Optional[str] = None
    port: Optional[str] = None
    username: Optional[str] = None
    password: Optional[str] = None
    uses_oauth: Optional[bool] = None
    certificate: Optional[str] = None
    file_type: Optional[str] = None
    database: Optional[str] = None
    db_timezone: Optional[str] = None
    query_timezone: Optional[str] = None
    schema: Optional[str] = None
    max_connections: Optional[int] = None
    max_billing_gigabytes: Optional[str] = None
    ssl: Optional[bool] = None
    verify_ssl: Optional[bool] = None
    tmp_db_name: Optional[str] = None
    jdbc_additional_params: Optional[str] = None
    pool_timeout: Optional[int] = None
    dialect_name: Optional[str] = None
    supports_data_studio_link: Optional[bool] = None
    created_at: Optional[str] = None
    user_id: Optional[str] = None
    example: Optional[bool] = None
    user_db_credentials: Optional[bool] = None
    user_attribute_fields: Optional[Sequence[str]] = None
    maintenance_cron: Optional[str] = None
    last_regen_at: Optional[str] = None
    last_reap_at: Optional[str] = None
    sql_runner_precache_tables: Optional[bool] = None
    sql_writing_with_info_schema: Optional[bool] = None
    after_connect_statements: Optional[str] = None
    pdt_context_override: Optional["DBConnectionOverride"] = None
    managed: Optional[bool] = None
    tunnel_id: Optional[str] = None
    pdt_concurrency: Optional[int] = None
    disable_context_comment: Optional[bool] = None
    oauth_application_id: Optional[str] = None
    always_retry_failed_builds: Optional[bool] = None
    cost_estimate_enabled: Optional[bool] = None
    pdt_api_control_enabled: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        name: Optional[str] = None,
        dialect: Optional["Dialect"] = None,
        snippets: Optional[Sequence["Snippet"]] = None,
        pdts_enabled: Optional[bool] = None,
        host: Optional[str] = None,
        port: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        uses_oauth: Optional[bool] = None,
        certificate: Optional[str] = None,
        file_type: Optional[str] = None,
        database: Optional[str] = None,
        db_timezone: Optional[str] = None,
        query_timezone: Optional[str] = None,
        schema: Optional[str] = None,
        max_connections: Optional[int] = None,
        max_billing_gigabytes: Optional[str] = None,
        ssl: Optional[bool] = None,
        verify_ssl: Optional[bool] = None,
        tmp_db_name: Optional[str] = None,
        jdbc_additional_params: Optional[str] = None,
        pool_timeout: Optional[int] = None,
        dialect_name: Optional[str] = None,
        supports_data_studio_link: Optional[bool] = None,
        created_at: Optional[str] = None,
        user_id: Optional[str] = None,
        example: Optional[bool] = None,
        user_db_credentials: Optional[bool] = None,
        user_attribute_fields: Optional[Sequence[str]] = None,
        maintenance_cron: Optional[str] = None,
        last_regen_at: Optional[str] = None,
        last_reap_at: Optional[str] = None,
        sql_runner_precache_tables: Optional[bool] = None,
        sql_writing_with_info_schema: Optional[bool] = None,
        after_connect_statements: Optional[str] = None,
        pdt_context_override: Optional["DBConnectionOverride"] = None,
        managed: Optional[bool] = None,
        tunnel_id: Optional[str] = None,
        pdt_concurrency: Optional[int] = None,
        disable_context_comment: Optional[bool] = None,
        oauth_application_id: Optional[str] = None,
        always_retry_failed_builds: Optional[bool] = None,
        cost_estimate_enabled: Optional[bool] = None,
        pdt_api_control_enabled: Optional[bool] = None
    ):
        self.can = can
        self.name = name
        self.dialect = dialect
        self.snippets = snippets
        self.pdts_enabled = pdts_enabled
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.uses_oauth = uses_oauth
        self.certificate = certificate
        self.file_type = file_type
        self.database = database
        self.db_timezone = db_timezone
        self.query_timezone = query_timezone
        self.schema = schema
        self.max_connections = max_connections
        self.max_billing_gigabytes = max_billing_gigabytes
        self.ssl = ssl
        self.verify_ssl = verify_ssl
        self.tmp_db_name = tmp_db_name
        self.jdbc_additional_params = jdbc_additional_params
        self.pool_timeout = pool_timeout
        self.dialect_name = dialect_name
        self.supports_data_studio_link = supports_data_studio_link
        self.created_at = created_at
        self.user_id = user_id
        self.example = example
        self.user_db_credentials = user_db_credentials
        self.user_attribute_fields = user_attribute_fields
        self.maintenance_cron = maintenance_cron
        self.last_regen_at = last_regen_at
        self.last_reap_at = last_reap_at
        self.sql_runner_precache_tables = sql_runner_precache_tables
        self.sql_writing_with_info_schema = sql_writing_with_info_schema
        self.after_connect_statements = after_connect_statements
        self.pdt_context_override = pdt_context_override
        self.managed = managed
        self.tunnel_id = tunnel_id
        self.pdt_concurrency = pdt_concurrency
        self.disable_context_comment = disable_context_comment
        self.oauth_application_id = oauth_application_id
        self.always_retry_failed_builds = always_retry_failed_builds
        self.cost_estimate_enabled = cost_estimate_enabled
        self.pdt_api_control_enabled = pdt_api_control_enabled


@attr.s(auto_attribs=True, init=False)
class DBConnectionBase(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        name: Name of the connection. Also used as the unique identifier
        dialect:
        snippets: SQL Runner snippets for this connection
        pdts_enabled: True if PDTs are enabled on this connection
    """

    can: Optional[MutableMapping[str, bool]] = None
    name: Optional[str] = None
    dialect: Optional["Dialect"] = None
    snippets: Optional[Sequence["Snippet"]] = None
    pdts_enabled: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        name: Optional[str] = None,
        dialect: Optional["Dialect"] = None,
        snippets: Optional[Sequence["Snippet"]] = None,
        pdts_enabled: Optional[bool] = None
    ):
        self.can = can
        self.name = name
        self.dialect = dialect
        self.snippets = snippets
        self.pdts_enabled = pdts_enabled


@attr.s(auto_attribs=True, init=False)
class DBConnectionOverride(model.Model):
    """
    Attributes:
        context: Context in which to override (`pdt` is the only allowed value)
        host: Host name/address of server
        port: Port number on server
        username: Username for server authentication
        password: (Write-Only) Password for server authentication
        has_password: Whether or not the password is overridden in this context
        certificate: (Write-Only) Base64 encoded Certificate body for server authentication (when appropriate for dialect).
        file_type: (Write-Only) Certificate keyfile type - .json or .p12
        database: Database name
        schema: Scheme name
        jdbc_additional_params: Additional params to add to JDBC connection string
        after_connect_statements: SQL statements (semicolon separated) to issue after connecting to the database. Requires `custom_after_connect_statements` license feature
    """

    context: Optional[str] = None
    host: Optional[str] = None
    port: Optional[str] = None
    username: Optional[str] = None
    password: Optional[str] = None
    has_password: Optional[bool] = None
    certificate: Optional[str] = None
    file_type: Optional[str] = None
    database: Optional[str] = None
    schema: Optional[str] = None
    jdbc_additional_params: Optional[str] = None
    after_connect_statements: Optional[str] = None

    def __init__(
        self,
        *,
        context: Optional[str] = None,
        host: Optional[str] = None,
        port: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        has_password: Optional[bool] = None,
        certificate: Optional[str] = None,
        file_type: Optional[str] = None,
        database: Optional[str] = None,
        schema: Optional[str] = None,
        jdbc_additional_params: Optional[str] = None,
        after_connect_statements: Optional[str] = None
    ):
        self.context = context
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.has_password = has_password
        self.certificate = certificate
        self.file_type = file_type
        self.database = database
        self.schema = schema
        self.jdbc_additional_params = jdbc_additional_params
        self.after_connect_statements = after_connect_statements


@attr.s(auto_attribs=True, init=False)
class DBConnectionTestResult(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        connection_string: JDBC connection string. (only populated in the 'connect' test)
        message: Result message of test
        name: Name of test
        status: Result code of test
    """

    can: Optional[MutableMapping[str, bool]] = None
    connection_string: Optional[str] = None
    message: Optional[str] = None
    name: Optional[str] = None
    status: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        connection_string: Optional[str] = None,
        message: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[str] = None
    ):
        self.can = can
        self.connection_string = connection_string
        self.message = message
        self.name = name
        self.status = status


@attr.s(auto_attribs=True, init=False)
class DelegateOauthTest(model.Model):
    """
    Attributes:
        name: Delegate Oauth Connection Name
        installation_target_id: The ID of the installation target. For Slack, this would be workspace id.
        installation_id: Installation ID
        success: Whether or not the test was successful
    """

    name: Optional[str] = None
    installation_target_id: Optional[str] = None
    installation_id: Optional[str] = None
    success: Optional[bool] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        installation_target_id: Optional[str] = None,
        installation_id: Optional[str] = None,
        success: Optional[bool] = None
    ):
        self.name = name
        self.installation_target_id = installation_target_id
        self.installation_id = installation_id
        self.success = success


@attr.s(auto_attribs=True, init=False)
class DependencyGraph(model.Model):
    """
    Attributes:
        graph_text: The graph structure in the dot language that can be rendered into an image.
    """

    graph_text: Optional[str] = None

    def __init__(self, *, graph_text: Optional[str] = None):
        self.graph_text = graph_text


class DependencyStatus(enum.Enum):
    """
    Status of the dependencies in your project. Valid values are: "lock_optional", "lock_required", "lock_error", "install_none". (Enum defined in ProjectWorkspace)

    """

    lock_optional = "lock_optional"
    lock_required = "lock_required"
    lock_error = "lock_error"
    install_none = "install_none"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
DependencyStatus.__new__ = model.safe_enum__new__  # type: ignore


class DestinationType(enum.Enum):
    """
    Type of destination that the alert will be sent to Valid values are: "EMAIL", "ACTION_HUB". (Enum defined in AlertDestination)

    """

    EMAIL = "EMAIL"
    ACTION_HUB = "ACTION_HUB"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
DestinationType.__new__ = model.safe_enum__new__  # type: ignore


class DeviceType(enum.Enum):
    """
    Specifies type of device. Valid values are: "android", "ios". (Enum defined in MobileToken)

    """

    android = "android"
    ios = "ios"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
DeviceType.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class Dialect(model.Model):
    """
    Attributes:
        name: The name of the dialect
        label: The human-readable label of the connection
        supports_cost_estimate: Whether the dialect supports query cost estimates
        cost_estimate_style: How the dialect handles cost estimation
        persistent_table_indexes: PDT index columns
        persistent_table_sortkeys: PDT sortkey columns
        persistent_table_distkey: PDT distkey column
        supports_streaming: Suports streaming results
        automatically_run_sql_runner_snippets: Should SQL Runner snippets automatically be run
        connection_tests: Array of names of the tests that can be run on a connection using this dialect
        supports_inducer: Is supported with the inducer (i.e. generate from sql)
        supports_multiple_databases: Can multiple databases be accessed from a connection using this dialect
        supports_persistent_derived_tables: Whether the dialect supports allowing Looker to build persistent derived tables
        has_ssl_support: Does the database have client SSL support settable through the JDBC string explicitly?
    """

    name: Optional[str] = None
    label: Optional[str] = None
    supports_cost_estimate: Optional[bool] = None
    cost_estimate_style: Optional[str] = None
    persistent_table_indexes: Optional[str] = None
    persistent_table_sortkeys: Optional[str] = None
    persistent_table_distkey: Optional[str] = None
    supports_streaming: Optional[bool] = None
    automatically_run_sql_runner_snippets: Optional[bool] = None
    connection_tests: Optional[Sequence[str]] = None
    supports_inducer: Optional[bool] = None
    supports_multiple_databases: Optional[bool] = None
    supports_persistent_derived_tables: Optional[bool] = None
    has_ssl_support: Optional[bool] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        label: Optional[str] = None,
        supports_cost_estimate: Optional[bool] = None,
        cost_estimate_style: Optional[str] = None,
        persistent_table_indexes: Optional[str] = None,
        persistent_table_sortkeys: Optional[str] = None,
        persistent_table_distkey: Optional[str] = None,
        supports_streaming: Optional[bool] = None,
        automatically_run_sql_runner_snippets: Optional[bool] = None,
        connection_tests: Optional[Sequence[str]] = None,
        supports_inducer: Optional[bool] = None,
        supports_multiple_databases: Optional[bool] = None,
        supports_persistent_derived_tables: Optional[bool] = None,
        has_ssl_support: Optional[bool] = None
    ):
        self.name = name
        self.label = label
        self.supports_cost_estimate = supports_cost_estimate
        self.cost_estimate_style = cost_estimate_style
        self.persistent_table_indexes = persistent_table_indexes
        self.persistent_table_sortkeys = persistent_table_sortkeys
        self.persistent_table_distkey = persistent_table_distkey
        self.supports_streaming = supports_streaming
        self.automatically_run_sql_runner_snippets = (
            automatically_run_sql_runner_snippets
        )
        self.connection_tests = connection_tests
        self.supports_inducer = supports_inducer
        self.supports_multiple_databases = supports_multiple_databases
        self.supports_persistent_derived_tables = supports_persistent_derived_tables
        self.has_ssl_support = has_ssl_support


@attr.s(auto_attribs=True, init=False)
class DialectInfo(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        default_max_connections: Default number max connections
        default_port: Default port number
        installed: Is the supporting driver installed
        label: The human-readable label of the connection
        label_for_database_equivalent: What the dialect calls the equivalent of a normal SQL table
        name: The name of the dialect
        supported_options:
    """

    can: Optional[MutableMapping[str, bool]] = None
    default_max_connections: Optional[str] = None
    default_port: Optional[str] = None
    installed: Optional[bool] = None
    label: Optional[str] = None
    label_for_database_equivalent: Optional[str] = None
    name: Optional[str] = None
    supported_options: Optional["DialectInfoOptions"] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        default_max_connections: Optional[str] = None,
        default_port: Optional[str] = None,
        installed: Optional[bool] = None,
        label: Optional[str] = None,
        label_for_database_equivalent: Optional[str] = None,
        name: Optional[str] = None,
        supported_options: Optional["DialectInfoOptions"] = None
    ):
        self.can = can
        self.default_max_connections = default_max_connections
        self.default_port = default_port
        self.installed = installed
        self.label = label
        self.label_for_database_equivalent = label_for_database_equivalent
        self.name = name
        self.supported_options = supported_options


@attr.s(auto_attribs=True, init=False)
class DialectInfoOptions(model.Model):
    """
    Attributes:
        additional_params: Has additional params support
        auth: Has auth support
        host: Has host support
        oauth_credentials: Has support for a service account
        project_name: Has project name support
        schema: Has schema support
        ssl: Has SSL support
        timezone: Has timezone support
        tmp_table: Has tmp table support
        username_required: Username is required
    """

    additional_params: Optional[bool] = None
    auth: Optional[bool] = None
    host: Optional[bool] = None
    oauth_credentials: Optional[bool] = None
    project_name: Optional[bool] = None
    schema: Optional[bool] = None
    ssl: Optional[bool] = None
    timezone: Optional[bool] = None
    tmp_table: Optional[bool] = None
    username_required: Optional[bool] = None

    def __init__(
        self,
        *,
        additional_params: Optional[bool] = None,
        auth: Optional[bool] = None,
        host: Optional[bool] = None,
        oauth_credentials: Optional[bool] = None,
        project_name: Optional[bool] = None,
        schema: Optional[bool] = None,
        ssl: Optional[bool] = None,
        timezone: Optional[bool] = None,
        tmp_table: Optional[bool] = None,
        username_required: Optional[bool] = None
    ):
        self.additional_params = additional_params
        self.auth = auth
        self.host = host
        self.oauth_credentials = oauth_credentials
        self.project_name = project_name
        self.schema = schema
        self.ssl = ssl
        self.timezone = timezone
        self.tmp_table = tmp_table
        self.username_required = username_required


@attr.s(auto_attribs=True, init=False)
class DigestEmails(model.Model):
    """
    Attributes:
        is_enabled: Whether or not digest emails are enabled
    """

    is_enabled: Optional[bool] = None

    def __init__(self, *, is_enabled: Optional[bool] = None):
        self.is_enabled = is_enabled


@attr.s(auto_attribs=True, init=False)
class DigestEmailSend(model.Model):
    """
    Attributes:
        configuration_delivered: True if content was successfully generated and delivered
    """

    configuration_delivered: Optional[bool] = None

    def __init__(self, *, configuration_delivered: Optional[bool] = None):
        self.configuration_delivered = configuration_delivered


@attr.s(auto_attribs=True, init=False)
class DiscretePalette(model.Model):
    """
    Attributes:
        id: Unique identity string
        label: Label for palette
        type: Type of palette
        colors: Array of colors in the palette
    """

    id: Optional[str] = None
    label: Optional[str] = None
    type: Optional[str] = None
    colors: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        label: Optional[str] = None,
        type: Optional[str] = None,
        colors: Optional[Sequence[str]] = None
    ):
        self.id = id
        self.label = label
        self.type = type
        self.colors = colors


@attr.s(auto_attribs=True, init=False)
class EgressIpAddresses(model.Model):
    """
    Attributes:
        egress_ip_addresses: Egress IP addresses
    """

    egress_ip_addresses: Optional[Sequence[str]] = None

    def __init__(self, *, egress_ip_addresses: Optional[Sequence[str]] = None):
        self.egress_ip_addresses = egress_ip_addresses


@attr.s(auto_attribs=True, init=False)
class EmbedCookielessSessionAcquire(model.Model):
    """
    Attributes:
        session_length: Number of seconds the SSO embed session will be valid after the embed session is started. Defaults to 300 seconds. Maximum session length accepted is 2592000 seconds (30 days).
        force_logout_login: When true, the embed session will purge any residual Looker login state (such as in browser cookies) before creating a new login state with the given embed user info. Defaults to true.
        external_user_id: A value from an external system that uniquely identifies the embed user. Since the user_ids of Looker embed users may change with every embed session, external_user_id provides a way to assign a known, stable user identifier across multiple embed sessions.
        first_name: First name of the embed user. Defaults to 'Embed' if not specified
        last_name: Last name of the embed user. Defaults to 'User' if not specified
        user_timezone: Sets the user timezone for the embed user session, if the User Specific Timezones setting is enabled in the Looker admin settings. A value of `null` forces the embed user to use the Looker Application Default Timezone. You MUST omit this property from the request if the User Specific Timezones setting is disabled. Timezone values are validated against the IANA Timezone standard and can be seen in the Application Time Zone dropdown list on the Looker General Settings admin page.
        permissions: List of Looker permission names to grant to the embed user. Requested permissions will be filtered to permissions allowed for embed sessions.
        models: List of model names that the embed user may access
        group_ids: List of Looker group ids in which to enroll the embed user
        external_group_id: A unique value identifying an embed-exclusive group. Multiple embed users using the same `external_group_id` value will be able to share Looker content with each other. Content and embed users associated with the `external_group_id` will not be accessible to normal Looker users or embed users not associated with this `external_group_id`.
        user_attributes: A dictionary of name-value pairs associating a Looker user attribute name with a value.
        session_reference_token: Token referencing the embed session and is used to generate new authentication, navigation and api tokens.
    """

    session_length: Optional[int] = None
    force_logout_login: Optional[bool] = None
    external_user_id: Optional[str] = None
    first_name: Optional[str] = None
    last_name: Optional[str] = None
    user_timezone: Optional[str] = None
    permissions: Optional[Sequence[str]] = None
    models: Optional[Sequence[str]] = None
    group_ids: Optional[Sequence[str]] = None
    external_group_id: Optional[str] = None
    user_attributes: Optional[MutableMapping[str, Any]] = None
    session_reference_token: Optional[str] = None

    def __init__(
        self,
        *,
        session_length: Optional[int] = None,
        force_logout_login: Optional[bool] = None,
        external_user_id: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        user_timezone: Optional[str] = None,
        permissions: Optional[Sequence[str]] = None,
        models: Optional[Sequence[str]] = None,
        group_ids: Optional[Sequence[str]] = None,
        external_group_id: Optional[str] = None,
        user_attributes: Optional[MutableMapping[str, Any]] = None,
        session_reference_token: Optional[str] = None
    ):
        self.session_length = session_length
        self.force_logout_login = force_logout_login
        self.external_user_id = external_user_id
        self.first_name = first_name
        self.last_name = last_name
        self.user_timezone = user_timezone
        self.permissions = permissions
        self.models = models
        self.group_ids = group_ids
        self.external_group_id = external_group_id
        self.user_attributes = user_attributes
        self.session_reference_token = session_reference_token


@attr.s(auto_attribs=True, init=False)
class EmbedCookielessSessionAcquireResponse(model.Model):
    """
    Attributes:
        authentication_token: One time token used to create or to attach to an embedded session in the Looker application server.
        authentication_token_ttl: Authentication token time to live in seconds.
        navigation_token: Token used to load and navigate between Looker pages.
        navigation_token_ttl: Navigation token time to live in seconds.
        api_token: Token to used to call Looker APIs.
        api_token_ttl: Api token time to live in seconds.
        session_reference_token: Token referencing the actual embed session. It is used to generate new api, navigation and authentication tokens. api and navigation tokens are short lived and must be refreshed regularly. A new authentication token must be acquired for each IFRAME that is created. The session_reference_token should be kept secure, ideally in the embed hosts application server.
        session_reference_token_ttl: Session reference token time to live in seconds. Note that this is the same as actual session.
    """

    authentication_token: Optional[str] = None
    authentication_token_ttl: Optional[int] = None
    navigation_token: Optional[str] = None
    navigation_token_ttl: Optional[int] = None
    api_token: Optional[str] = None
    api_token_ttl: Optional[int] = None
    session_reference_token: Optional[str] = None
    session_reference_token_ttl: Optional[int] = None

    def __init__(
        self,
        *,
        authentication_token: Optional[str] = None,
        authentication_token_ttl: Optional[int] = None,
        navigation_token: Optional[str] = None,
        navigation_token_ttl: Optional[int] = None,
        api_token: Optional[str] = None,
        api_token_ttl: Optional[int] = None,
        session_reference_token: Optional[str] = None,
        session_reference_token_ttl: Optional[int] = None
    ):
        self.authentication_token = authentication_token
        self.authentication_token_ttl = authentication_token_ttl
        self.navigation_token = navigation_token
        self.navigation_token_ttl = navigation_token_ttl
        self.api_token = api_token
        self.api_token_ttl = api_token_ttl
        self.session_reference_token = session_reference_token
        self.session_reference_token_ttl = session_reference_token_ttl


@attr.s(auto_attribs=True, init=False)
class EmbedCookielessSessionGenerateTokens(model.Model):
    """
    Attributes:
        session_reference_token: Token referencing the embed session and is used to generate new authentication, navigation and api tokens.
        navigation_token: Token used to load and navigate between Looker pages.
        api_token: Token to used to call Looker APIs.
    """

    session_reference_token: str
    navigation_token: Optional[str] = None
    api_token: Optional[str] = None

    def __init__(
        self,
        *,
        session_reference_token: str,
        navigation_token: Optional[str] = None,
        api_token: Optional[str] = None
    ):
        self.session_reference_token = session_reference_token
        self.navigation_token = navigation_token
        self.api_token = api_token


@attr.s(auto_attribs=True, init=False)
class EmbedCookielessSessionGenerateTokensResponse(model.Model):
    """
    Attributes:
        session_reference_token: Token referencing the embed session and is used to generate new authentication, navigation and api tokens.
        navigation_token: Token used to load and navigate between Looker pages.
        navigation_token_ttl: Navigation token time to live in seconds.
        api_token: Token to used to call Looker APIs.
        api_token_ttl: Api token time to live in seconds.
        session_reference_token_ttl: Session reference token time to live in seconds. Note that this is the same as actual session.
    """

    session_reference_token: str
    navigation_token: Optional[str] = None
    navigation_token_ttl: Optional[int] = None
    api_token: Optional[str] = None
    api_token_ttl: Optional[int] = None
    session_reference_token_ttl: Optional[int] = None

    def __init__(
        self,
        *,
        session_reference_token: str,
        navigation_token: Optional[str] = None,
        navigation_token_ttl: Optional[int] = None,
        api_token: Optional[str] = None,
        api_token_ttl: Optional[int] = None,
        session_reference_token_ttl: Optional[int] = None
    ):
        self.session_reference_token = session_reference_token
        self.navigation_token = navigation_token
        self.navigation_token_ttl = navigation_token_ttl
        self.api_token = api_token
        self.api_token_ttl = api_token_ttl
        self.session_reference_token_ttl = session_reference_token_ttl


@attr.s(auto_attribs=True, init=False)
class EmbedParams(model.Model):
    """
    Attributes:
        target_url: The complete URL of the Looker UI page to display in the embed context. For example, to display the dashboard with id 34, `target_url` would look like: `https://mycompany.looker.com:9999/dashboards/34`. `target_uri` MUST contain a scheme (HTTPS), domain name, and URL path. Port must be included if it is required to reach the Looker server from browser clients. If the Looker instance is behind a load balancer or other proxy, `target_uri` must be the public-facing domain name and port required to reach the Looker instance, not the actual internal network machine name of the Looker instance.
        session_length: Number of seconds the SSO embed session will be valid after the embed session is started. Defaults to 300 seconds. Maximum session length accepted is 2592000 seconds (30 days).
        force_logout_login: When true, the embed session will purge any residual Looker login state (such as in browser cookies) before creating a new login state with the given embed user info. Defaults to true.
    """

    target_url: str
    session_length: Optional[int] = None
    force_logout_login: Optional[bool] = None

    def __init__(
        self,
        *,
        target_url: str,
        session_length: Optional[int] = None,
        force_logout_login: Optional[bool] = None
    ):
        self.target_url = target_url
        self.session_length = session_length
        self.force_logout_login = force_logout_login


@attr.s(auto_attribs=True, init=False)
class EmbedSecret(model.Model):
    """
    Attributes:
        algorithm: Signing algorithm to use with this secret. Either `hmac/sha-256`(default) or `hmac/sha-1`
        created_at: When secret was created
        enabled: Is this secret currently enabled
        id: Unique Id
        secret: Secret for use with SSO embedding
        user_id: Id of user who created this secret
    """

    algorithm: Optional[str] = None
    created_at: Optional[str] = None
    enabled: Optional[bool] = None
    id: Optional[str] = None
    secret: Optional[str] = None
    user_id: Optional[str] = None

    def __init__(
        self,
        *,
        algorithm: Optional[str] = None,
        created_at: Optional[str] = None,
        enabled: Optional[bool] = None,
        id: Optional[str] = None,
        secret: Optional[str] = None,
        user_id: Optional[str] = None
    ):
        self.algorithm = algorithm
        self.created_at = created_at
        self.enabled = enabled
        self.id = id
        self.secret = secret
        self.user_id = user_id


@attr.s(auto_attribs=True, init=False)
class EmbedSsoParams(model.Model):
    """
    Attributes:
        target_url: The complete URL of the Looker UI page to display in the embed context. For example, to display the dashboard with id 34, `target_url` would look like: `https://mycompany.looker.com:9999/dashboards/34`. `target_uri` MUST contain a scheme (HTTPS), domain name, and URL path. Port must be included if it is required to reach the Looker server from browser clients. If the Looker instance is behind a load balancer or other proxy, `target_uri` must be the public-facing domain name and port required to reach the Looker instance, not the actual internal network machine name of the Looker instance.
        session_length: Number of seconds the SSO embed session will be valid after the embed session is started. Defaults to 300 seconds. Maximum session length accepted is 2592000 seconds (30 days).
        force_logout_login: When true, the embed session will purge any residual Looker login state (such as in browser cookies) before creating a new login state with the given embed user info. Defaults to true.
        external_user_id: A value from an external system that uniquely identifies the embed user. Since the user_ids of Looker embed users may change with every embed session, external_user_id provides a way to assign a known, stable user identifier across multiple embed sessions.
        first_name: First name of the embed user. Defaults to 'Embed' if not specified
        last_name: Last name of the embed user. Defaults to 'User' if not specified
        user_timezone: Sets the user timezone for the embed user session, if the User Specific Timezones setting is enabled in the Looker admin settings. A value of `null` forces the embed user to use the Looker Application Default Timezone. You MUST omit this property from the request if the User Specific Timezones setting is disabled. Timezone values are validated against the IANA Timezone standard and can be seen in the Application Time Zone dropdown list on the Looker General Settings admin page.
        permissions: List of Looker permission names to grant to the embed user. Requested permissions will be filtered to permissions allowed for embed sessions.
        models: List of model names that the embed user may access
        group_ids: List of Looker group ids in which to enroll the embed user
        external_group_id: A unique value identifying an embed-exclusive group. Multiple embed users using the same `external_group_id` value will be able to share Looker content with each other. Content and embed users associated with the `external_group_id` will not be accessible to normal Looker users or embed users not associated with this `external_group_id`.
        user_attributes: A dictionary of name-value pairs associating a Looker user attribute name with a value.
        secret_id: Id of the embed secret to use to sign this SSO url. If specified, the value must be an id of a valid (active) secret defined in the Looker instance. If not specified, the URL will be signed with the newest active embed secret defined in the Looker instance.
    """

    target_url: str
    session_length: Optional[int] = None
    force_logout_login: Optional[bool] = None
    external_user_id: Optional[str] = None
    first_name: Optional[str] = None
    last_name: Optional[str] = None
    user_timezone: Optional[str] = None
    permissions: Optional[Sequence[str]] = None
    models: Optional[Sequence[str]] = None
    group_ids: Optional[Sequence[str]] = None
    external_group_id: Optional[str] = None
    user_attributes: Optional[MutableMapping[str, Any]] = None
    secret_id: Optional[str] = None

    def __init__(
        self,
        *,
        target_url: str,
        session_length: Optional[int] = None,
        force_logout_login: Optional[bool] = None,
        external_user_id: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        user_timezone: Optional[str] = None,
        permissions: Optional[Sequence[str]] = None,
        models: Optional[Sequence[str]] = None,
        group_ids: Optional[Sequence[str]] = None,
        external_group_id: Optional[str] = None,
        user_attributes: Optional[MutableMapping[str, Any]] = None,
        secret_id: Optional[str] = None
    ):
        self.target_url = target_url
        self.session_length = session_length
        self.force_logout_login = force_logout_login
        self.external_user_id = external_user_id
        self.first_name = first_name
        self.last_name = last_name
        self.user_timezone = user_timezone
        self.permissions = permissions
        self.models = models
        self.group_ids = group_ids
        self.external_group_id = external_group_id
        self.user_attributes = user_attributes
        self.secret_id = secret_id


@attr.s(auto_attribs=True, init=False)
class EmbedUrlResponse(model.Model):
    """
    Attributes:
        url: The embed URL. Any modification to this string will make the URL unusable.
    """

    url: Optional[str] = None

    def __init__(self, *, url: Optional[str] = None):
        self.url = url


@attr.s(auto_attribs=True, init=False)
class Error(model.Model):
    """
    Attributes:
        message: Error details
        documentation_url: Documentation link
    """

    message: str
    documentation_url: str

    def __init__(self, *, message: str, documentation_url: str):
        self.message = message
        self.documentation_url = documentation_url


@attr.s(auto_attribs=True, init=False)
class ExternalOauthApplication(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: ID of this OAuth Application
        name: The name of this application.  For Snowflake connections, this should be the name of the host database.
        client_id: The OAuth Client ID for this application
        client_secret: (Write-Only) The OAuth Client Secret for this application
        dialect_name: The database dialect for this application.
        created_at: Creation time for this application
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    name: Optional[str] = None
    client_id: Optional[str] = None
    client_secret: Optional[str] = None
    dialect_name: Optional[str] = None
    created_at: Optional[datetime.datetime] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        dialect_name: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None
    ):
        self.can = can
        self.id = id
        self.name = name
        self.client_id = client_id
        self.client_secret = client_secret
        self.dialect_name = dialect_name
        self.created_at = created_at


class FillStyle(enum.Enum):
    """
    The style of dimension fill that is possible for this field. Null if no dimension fill is possible. Valid values are: "enumeration", "range". (Enum defined in LookmlModelExploreField)

    """

    enumeration = "enumeration"
    range = "range"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
FillStyle.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class Folder(model.Model):
    """
    Attributes:
        name: Unique Name
        parent_id: Id of Parent. If the parent id is null, this is a root-level entry
        id: Unique Id
        content_metadata_id: Id of content metadata
        created_at: Time the space was created
        creator_id: User Id of Creator
        child_count: Children Count
        external_id: Embedder's Id if this folder was autogenerated as an embedding shared folder via 'external_group_id' in an SSO embed login
        is_embed: Folder is an embed folder
        is_embed_shared_root: Folder is the root embed shared folder
        is_embed_users_root: Folder is the root embed users folder
        is_personal: Folder is a user's personal folder
        is_personal_descendant: Folder is descendant of a user's personal folder
        is_shared_root: Folder is the root shared folder
        is_users_root: Folder is the root user folder
        can: Operations the current user is able to perform on this object
        dashboards: Dashboards
        looks: Looks
    """

    name: str
    parent_id: Optional[str] = None
    id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    creator_id: Optional[str] = None
    child_count: Optional[int] = None
    external_id: Optional[str] = None
    is_embed: Optional[bool] = None
    is_embed_shared_root: Optional[bool] = None
    is_embed_users_root: Optional[bool] = None
    is_personal: Optional[bool] = None
    is_personal_descendant: Optional[bool] = None
    is_shared_root: Optional[bool] = None
    is_users_root: Optional[bool] = None
    can: Optional[MutableMapping[str, bool]] = None
    dashboards: Optional[Sequence["DashboardBase"]] = None
    looks: Optional[Sequence["LookWithDashboards"]] = None

    def __init__(
        self,
        *,
        name: str,
        parent_id: Optional[str] = None,
        id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        creator_id: Optional[str] = None,
        child_count: Optional[int] = None,
        external_id: Optional[str] = None,
        is_embed: Optional[bool] = None,
        is_embed_shared_root: Optional[bool] = None,
        is_embed_users_root: Optional[bool] = None,
        is_personal: Optional[bool] = None,
        is_personal_descendant: Optional[bool] = None,
        is_shared_root: Optional[bool] = None,
        is_users_root: Optional[bool] = None,
        can: Optional[MutableMapping[str, bool]] = None,
        dashboards: Optional[Sequence["DashboardBase"]] = None,
        looks: Optional[Sequence["LookWithDashboards"]] = None
    ):
        self.name = name
        self.parent_id = parent_id
        self.id = id
        self.content_metadata_id = content_metadata_id
        self.created_at = created_at
        self.creator_id = creator_id
        self.child_count = child_count
        self.external_id = external_id
        self.is_embed = is_embed
        self.is_embed_shared_root = is_embed_shared_root
        self.is_embed_users_root = is_embed_users_root
        self.is_personal = is_personal
        self.is_personal_descendant = is_personal_descendant
        self.is_shared_root = is_shared_root
        self.is_users_root = is_users_root
        self.can = can
        self.dashboards = dashboards
        self.looks = looks


@attr.s(auto_attribs=True, init=False)
class FolderBase(model.Model):
    """
    Attributes:
        name: Unique Name
        parent_id: Id of Parent. If the parent id is null, this is a root-level entry
        id: Unique Id
        content_metadata_id: Id of content metadata
        created_at: Time the folder was created
        creator_id: User Id of Creator
        child_count: Children Count
        external_id: Embedder's Id if this folder was autogenerated as an embedding shared folder via 'external_group_id' in an SSO embed login
        is_embed: Folder is an embed folder
        is_embed_shared_root: Folder is the root embed shared folder
        is_embed_users_root: Folder is the root embed users folder
        is_personal: Folder is a user's personal folder
        is_personal_descendant: Folder is descendant of a user's personal folder
        is_shared_root: Folder is the root shared folder
        is_users_root: Folder is the root user folder
        can: Operations the current user is able to perform on this object
    """

    name: str
    parent_id: Optional[str] = None
    id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    creator_id: Optional[str] = None
    child_count: Optional[int] = None
    external_id: Optional[str] = None
    is_embed: Optional[bool] = None
    is_embed_shared_root: Optional[bool] = None
    is_embed_users_root: Optional[bool] = None
    is_personal: Optional[bool] = None
    is_personal_descendant: Optional[bool] = None
    is_shared_root: Optional[bool] = None
    is_users_root: Optional[bool] = None
    can: Optional[MutableMapping[str, bool]] = None

    def __init__(
        self,
        *,
        name: str,
        parent_id: Optional[str] = None,
        id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        creator_id: Optional[str] = None,
        child_count: Optional[int] = None,
        external_id: Optional[str] = None,
        is_embed: Optional[bool] = None,
        is_embed_shared_root: Optional[bool] = None,
        is_embed_users_root: Optional[bool] = None,
        is_personal: Optional[bool] = None,
        is_personal_descendant: Optional[bool] = None,
        is_shared_root: Optional[bool] = None,
        is_users_root: Optional[bool] = None,
        can: Optional[MutableMapping[str, bool]] = None
    ):
        self.name = name
        self.parent_id = parent_id
        self.id = id
        self.content_metadata_id = content_metadata_id
        self.created_at = created_at
        self.creator_id = creator_id
        self.child_count = child_count
        self.external_id = external_id
        self.is_embed = is_embed
        self.is_embed_shared_root = is_embed_shared_root
        self.is_embed_users_root = is_embed_users_root
        self.is_personal = is_personal
        self.is_personal_descendant = is_personal_descendant
        self.is_shared_root = is_shared_root
        self.is_users_root = is_users_root
        self.can = can


class Format(enum.Enum):
    """
    Specifies the data format of the region information. Valid values are: "topojson", "vector_tile_region". (Enum defined in LookmlModelExploreFieldMapLayer)

    """

    topojson = "topojson"
    vector_tile_region = "vector_tile_region"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
Format.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class GitBranch(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        name: The short name on the local. Updating `name` results in `git checkout <new_name>`
        remote: The name of the remote
        remote_name: The short name on the remote
        error: Name of error
        message: Message describing an error if present
        owner_name: Name of the owner of a personal branch
        readonly: Whether or not this branch is readonly
        personal: Whether or not this branch is a personal branch - readonly for all developers except the owner
        is_local: Whether or not a local ref exists for the branch
        is_remote: Whether or not a remote ref exists for the branch
        is_production: Whether or not this is the production branch
        ahead_count: Number of commits the local branch is ahead of the remote
        behind_count: Number of commits the local branch is behind the remote
        commit_at: UNIX timestamp at which this branch was last committed.
        ref: The resolved ref of this branch. Updating `ref` results in `git reset --hard <new_ref>``.
        remote_ref: The resolved ref of this branch remote.
    """

    can: Optional[MutableMapping[str, bool]] = None
    name: Optional[str] = None
    remote: Optional[str] = None
    remote_name: Optional[str] = None
    error: Optional[str] = None
    message: Optional[str] = None
    owner_name: Optional[str] = None
    readonly: Optional[bool] = None
    personal: Optional[bool] = None
    is_local: Optional[bool] = None
    is_remote: Optional[bool] = None
    is_production: Optional[bool] = None
    ahead_count: Optional[int] = None
    behind_count: Optional[int] = None
    commit_at: Optional[int] = None
    ref: Optional[str] = None
    remote_ref: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        name: Optional[str] = None,
        remote: Optional[str] = None,
        remote_name: Optional[str] = None,
        error: Optional[str] = None,
        message: Optional[str] = None,
        owner_name: Optional[str] = None,
        readonly: Optional[bool] = None,
        personal: Optional[bool] = None,
        is_local: Optional[bool] = None,
        is_remote: Optional[bool] = None,
        is_production: Optional[bool] = None,
        ahead_count: Optional[int] = None,
        behind_count: Optional[int] = None,
        commit_at: Optional[int] = None,
        ref: Optional[str] = None,
        remote_ref: Optional[str] = None
    ):
        self.can = can
        self.name = name
        self.remote = remote
        self.remote_name = remote_name
        self.error = error
        self.message = message
        self.owner_name = owner_name
        self.readonly = readonly
        self.personal = personal
        self.is_local = is_local
        self.is_remote = is_remote
        self.is_production = is_production
        self.ahead_count = ahead_count
        self.behind_count = behind_count
        self.commit_at = commit_at
        self.ref = ref
        self.remote_ref = remote_ref


@attr.s(auto_attribs=True, init=False)
class GitConnectionTest(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        description: Human readable string describing the test
        id: A short string, uniquely naming this test
    """

    can: Optional[MutableMapping[str, bool]] = None
    description: Optional[str] = None
    id: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        description: Optional[str] = None,
        id: Optional[str] = None
    ):
        self.can = can
        self.description = description
        self.id = id


@attr.s(auto_attribs=True, init=False)
class GitConnectionTestResult(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: A short string, uniquely naming this test
        message: Additional data from the test
        status: Either 'pass' or 'fail'
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    message: Optional[str] = None
    status: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        message: Optional[str] = None,
        status: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.message = message
        self.status = status


@attr.s(auto_attribs=True, init=False)
class GitStatus(model.Model):
    """
    Attributes:
        action: Git action: add, delete, etc
        conflict: When true, changes to the local file conflict with the remote repository
        revertable: When true, the file can be reverted to an earlier state
        text: Git description of the action
    """

    action: Optional[str] = None
    conflict: Optional[bool] = None
    revertable: Optional[bool] = None
    text: Optional[str] = None

    def __init__(
        self,
        *,
        action: Optional[str] = None,
        conflict: Optional[bool] = None,
        revertable: Optional[bool] = None,
        text: Optional[str] = None
    ):
        self.action = action
        self.conflict = conflict
        self.revertable = revertable
        self.text = text


@attr.s(auto_attribs=True, init=False)
class Group(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        can_add_to_content_metadata: Group can be used in content access controls
        contains_current_user: Currently logged in user is group member
        external_group_id: External Id group if embed group
        externally_managed: Group membership controlled outside of Looker
        id: Unique Id
        include_by_default: New users are added to this group by default
        name: Name of group
        user_count: Number of users included in this group
    """

    can: Optional[MutableMapping[str, bool]] = None
    can_add_to_content_metadata: Optional[bool] = None
    contains_current_user: Optional[bool] = None
    external_group_id: Optional[str] = None
    externally_managed: Optional[bool] = None
    id: Optional[str] = None
    include_by_default: Optional[bool] = None
    name: Optional[str] = None
    user_count: Optional[int] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        can_add_to_content_metadata: Optional[bool] = None,
        contains_current_user: Optional[bool] = None,
        external_group_id: Optional[str] = None,
        externally_managed: Optional[bool] = None,
        id: Optional[str] = None,
        include_by_default: Optional[bool] = None,
        name: Optional[str] = None,
        user_count: Optional[int] = None
    ):
        self.can = can
        self.can_add_to_content_metadata = can_add_to_content_metadata
        self.contains_current_user = contains_current_user
        self.external_group_id = external_group_id
        self.externally_managed = externally_managed
        self.id = id
        self.include_by_default = include_by_default
        self.name = name
        self.user_count = user_count


@attr.s(auto_attribs=True, init=False)
class GroupHierarchy(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        can_add_to_content_metadata: Group can be used in content access controls
        contains_current_user: Currently logged in user is group member
        external_group_id: External Id group if embed group
        externally_managed: Group membership controlled outside of Looker
        id: Unique Id
        include_by_default: New users are added to this group by default
        name: Name of group
        user_count: Number of users included in this group
        parent_group_ids: IDs of parents of this group
        role_ids: Role IDs assigned to group
    """

    can: Optional[MutableMapping[str, bool]] = None
    can_add_to_content_metadata: Optional[bool] = None
    contains_current_user: Optional[bool] = None
    external_group_id: Optional[str] = None
    externally_managed: Optional[bool] = None
    id: Optional[str] = None
    include_by_default: Optional[bool] = None
    name: Optional[str] = None
    user_count: Optional[int] = None
    parent_group_ids: Optional[Sequence[str]] = None
    role_ids: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        can_add_to_content_metadata: Optional[bool] = None,
        contains_current_user: Optional[bool] = None,
        external_group_id: Optional[str] = None,
        externally_managed: Optional[bool] = None,
        id: Optional[str] = None,
        include_by_default: Optional[bool] = None,
        name: Optional[str] = None,
        user_count: Optional[int] = None,
        parent_group_ids: Optional[Sequence[str]] = None,
        role_ids: Optional[Sequence[str]] = None
    ):
        self.can = can
        self.can_add_to_content_metadata = can_add_to_content_metadata
        self.contains_current_user = contains_current_user
        self.external_group_id = external_group_id
        self.externally_managed = externally_managed
        self.id = id
        self.include_by_default = include_by_default
        self.name = name
        self.user_count = user_count
        self.parent_group_ids = parent_group_ids
        self.role_ids = role_ids


@attr.s(auto_attribs=True, init=False)
class GroupIdForGroupInclusion(model.Model):
    """
    WARNING: no writeable properties found for POST, PUT, or PATCH

    Attributes:
        group_id: Id of group
    """

    group_id: Optional[str] = None

    def __init__(self, *, group_id: Optional[str] = None):
        self.group_id = group_id


@attr.s(auto_attribs=True, init=False)
class GroupIdForGroupUserInclusion(model.Model):
    """
    WARNING: no writeable properties found for POST, PUT, or PATCH

    Attributes:
        user_id: Id of user
    """

    user_id: Optional[str] = None

    def __init__(self, *, user_id: Optional[str] = None):
        self.user_id = user_id


@attr.s(auto_attribs=True, init=False)
class GroupSearch(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        can_add_to_content_metadata: Group can be used in content access controls
        contains_current_user: Currently logged in user is group member
        external_group_id: External Id group if embed group
        externally_managed: Group membership controlled outside of Looker
        id: Unique Id
        include_by_default: New users are added to this group by default
        name: Name of group
        user_count: Number of users included in this group
        roles: Roles assigned to group
    """

    can: Optional[MutableMapping[str, bool]] = None
    can_add_to_content_metadata: Optional[bool] = None
    contains_current_user: Optional[bool] = None
    external_group_id: Optional[str] = None
    externally_managed: Optional[bool] = None
    id: Optional[str] = None
    include_by_default: Optional[bool] = None
    name: Optional[str] = None
    user_count: Optional[int] = None
    roles: Optional[Sequence["Role"]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        can_add_to_content_metadata: Optional[bool] = None,
        contains_current_user: Optional[bool] = None,
        external_group_id: Optional[str] = None,
        externally_managed: Optional[bool] = None,
        id: Optional[str] = None,
        include_by_default: Optional[bool] = None,
        name: Optional[str] = None,
        user_count: Optional[int] = None,
        roles: Optional[Sequence["Role"]] = None
    ):
        self.can = can
        self.can_add_to_content_metadata = can_add_to_content_metadata
        self.contains_current_user = contains_current_user
        self.external_group_id = external_group_id
        self.externally_managed = externally_managed
        self.id = id
        self.include_by_default = include_by_default
        self.name = name
        self.user_count = user_count
        self.roles = roles


@attr.s(auto_attribs=True, init=False)
class HomepageItem(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_created_by: Name of user who created the content this item is based on
        content_favorite_id: Content favorite id associated with the item this content is based on
        content_metadata_id: Content metadata id associated with the item this content is based on
        content_updated_at: Last time the content that this item is based on was updated
        custom_description: Custom description entered by the user, if present
        custom_image_data_base64: (Write-Only) base64 encoded image data
        custom_image_url: Custom image_url entered by the user, if present
        custom_title: Custom title entered by the user, if present
        custom_url: Custom url entered by the user, if present
        dashboard_id: Dashboard to base this item on
        description: The actual description for display
        favorite_count: Number of times content has been favorited, if present
        homepage_section_id: Associated Homepage Section
        id: Unique Id
        image_url: The actual image_url for display
        location: The container folder name of the content
        look_id: Look to base this item on
        lookml_dashboard_id: LookML Dashboard to base this item on
        order: An arbitrary integer representing the sort order within the section
        section_fetch_time: Number of seconds it took to fetch the section this item is in
        title: The actual title for display
        url: The actual url for display
        use_custom_description: Whether the custom description should be used instead of the content description, if the item is associated with content
        use_custom_image: Whether the custom image should be used instead of the content image, if the item is associated with content
        use_custom_title: Whether the custom title should be used instead of the content title, if the item is associated with content
        use_custom_url: Whether the custom url should be used instead of the content url, if the item is associated with content
        view_count: Number of times content has been viewed, if present
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_created_by: Optional[str] = None
    content_favorite_id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    content_updated_at: Optional[str] = None
    custom_description: Optional[str] = None
    custom_image_data_base64: Optional[str] = None
    custom_image_url: Optional[str] = None
    custom_title: Optional[str] = None
    custom_url: Optional[str] = None
    dashboard_id: Optional[str] = None
    description: Optional[str] = None
    favorite_count: Optional[int] = None
    homepage_section_id: Optional[str] = None
    id: Optional[str] = None
    image_url: Optional[str] = None
    location: Optional[str] = None
    look_id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    order: Optional[int] = None
    section_fetch_time: Optional[float] = None
    title: Optional[str] = None
    url: Optional[str] = None
    use_custom_description: Optional[bool] = None
    use_custom_image: Optional[bool] = None
    use_custom_title: Optional[bool] = None
    use_custom_url: Optional[bool] = None
    view_count: Optional[int] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_created_by: Optional[str] = None,
        content_favorite_id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        content_updated_at: Optional[str] = None,
        custom_description: Optional[str] = None,
        custom_image_data_base64: Optional[str] = None,
        custom_image_url: Optional[str] = None,
        custom_title: Optional[str] = None,
        custom_url: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        description: Optional[str] = None,
        favorite_count: Optional[int] = None,
        homepage_section_id: Optional[str] = None,
        id: Optional[str] = None,
        image_url: Optional[str] = None,
        location: Optional[str] = None,
        look_id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        order: Optional[int] = None,
        section_fetch_time: Optional[float] = None,
        title: Optional[str] = None,
        url: Optional[str] = None,
        use_custom_description: Optional[bool] = None,
        use_custom_image: Optional[bool] = None,
        use_custom_title: Optional[bool] = None,
        use_custom_url: Optional[bool] = None,
        view_count: Optional[int] = None
    ):
        self.can = can
        self.content_created_by = content_created_by
        self.content_favorite_id = content_favorite_id
        self.content_metadata_id = content_metadata_id
        self.content_updated_at = content_updated_at
        self.custom_description = custom_description
        self.custom_image_data_base64 = custom_image_data_base64
        self.custom_image_url = custom_image_url
        self.custom_title = custom_title
        self.custom_url = custom_url
        self.dashboard_id = dashboard_id
        self.description = description
        self.favorite_count = favorite_count
        self.homepage_section_id = homepage_section_id
        self.id = id
        self.image_url = image_url
        self.location = location
        self.look_id = look_id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.order = order
        self.section_fetch_time = section_fetch_time
        self.title = title
        self.url = url
        self.use_custom_description = use_custom_description
        self.use_custom_image = use_custom_image
        self.use_custom_title = use_custom_title
        self.use_custom_url = use_custom_url
        self.view_count = view_count


@attr.s(auto_attribs=True, init=False)
class HomepageSection(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Time at which this section was created.
        deleted_at: Time at which this section was deleted.
        detail_url: A URL pointing to a page showing further information about the content in the section.
        homepage_id: Id reference to parent homepage
        homepage_items: Items in the homepage section
        id: Unique Id
        is_header: Is this a header section (has no items)
        item_order: ids of the homepage items in the order they should be displayed
        title: Name of row
        updated_at: Time at which this section was last updated.
        description: Description of the content found in this section.
        visible_item_order: ids of the homepage items the user can see in the order they should be displayed
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[datetime.datetime] = None
    deleted_at: Optional[datetime.datetime] = None
    detail_url: Optional[str] = None
    homepage_id: Optional[str] = None
    homepage_items: Optional[Sequence["HomepageItem"]] = None
    id: Optional[str] = None
    is_header: Optional[bool] = None
    item_order: Optional[Sequence[str]] = None
    title: Optional[str] = None
    updated_at: Optional[datetime.datetime] = None
    description: Optional[str] = None
    visible_item_order: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[datetime.datetime] = None,
        deleted_at: Optional[datetime.datetime] = None,
        detail_url: Optional[str] = None,
        homepage_id: Optional[str] = None,
        homepage_items: Optional[Sequence["HomepageItem"]] = None,
        id: Optional[str] = None,
        is_header: Optional[bool] = None,
        item_order: Optional[Sequence[str]] = None,
        title: Optional[str] = None,
        updated_at: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        visible_item_order: Optional[Sequence[str]] = None
    ):
        self.can = can
        self.created_at = created_at
        self.deleted_at = deleted_at
        self.detail_url = detail_url
        self.homepage_id = homepage_id
        self.homepage_items = homepage_items
        self.id = id
        self.is_header = is_header
        self.item_order = item_order
        self.title = title
        self.updated_at = updated_at
        self.description = description
        self.visible_item_order = visible_item_order


@attr.s(auto_attribs=True, init=False)
class ImportedProject(model.Model):
    """
    Attributes:
        name: Dependency name
        url: Url for a remote dependency
        ref: Ref for a remote dependency
        is_remote: Flag signifying if a dependency is remote or local
    """

    name: Optional[str] = None
    url: Optional[str] = None
    ref: Optional[str] = None
    is_remote: Optional[bool] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        url: Optional[str] = None,
        ref: Optional[str] = None,
        is_remote: Optional[bool] = None
    ):
        self.name = name
        self.url = url
        self.ref = ref
        self.is_remote = is_remote


@attr.s(auto_attribs=True, init=False)
class Integration(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: ID of the integration.
        integration_hub_id: ID of the integration hub.
        label: Label for the integration.
        description: Description of the integration.
        enabled: Whether the integration is available to users.
        params: Array of params for the integration.
        supported_formats: A list of data formats the integration supports. If unspecified, the default is all data formats. Valid values are: "txt", "csv", "inline_json", "json", "json_label", "json_detail", "json_detail_lite_stream", "xlsx", "html", "wysiwyg_pdf", "assembled_pdf", "wysiwyg_png", "csv_zip".
        supported_action_types: A list of action types the integration supports. Valid values are: "cell", "query", "dashboard", "none".
        supported_formattings: A list of formatting options the integration supports. If unspecified, defaults to all formats. Valid values are: "formatted", "unformatted".
        supported_visualization_formattings: A list of visualization formatting options the integration supports. If unspecified, defaults to all formats. Valid values are: "apply", "noapply".
        supported_download_settings: A list of all the download mechanisms the integration supports. The order of values is not significant: Looker will select the most appropriate supported download mechanism for a given query. The integration must ensure it can handle any of the mechanisms it claims to support. If unspecified, this defaults to all download setting values. Valid values are: "push", "url".
        icon_url: URL to an icon for the integration.
        uses_oauth: Whether the integration uses oauth.
        required_fields: A list of descriptions of required fields that this integration is compatible with. If there are multiple entries in this list, the integration requires more than one field. If unspecified, no fields will be required.
        delegate_oauth: Whether the integration uses delegate oauth, which allows federation between an integration installation scope specific entity (like org, group, and team, etc.) and Looker.
        installed_delegate_oauth_targets: Whether the integration is available to users.
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    integration_hub_id: Optional[str] = None
    label: Optional[str] = None
    description: Optional[str] = None
    enabled: Optional[bool] = None
    params: Optional[Sequence["IntegrationParam"]] = None
    supported_formats: Optional[Sequence["SupportedFormats"]] = None
    supported_action_types: Optional[Sequence["SupportedActionTypes"]] = None
    supported_formattings: Optional[Sequence["SupportedFormattings"]] = None
    supported_visualization_formattings: Optional[
        Sequence["SupportedVisualizationFormattings"]
    ] = None
    supported_download_settings: Optional[Sequence["SupportedDownloadSettings"]] = None
    icon_url: Optional[str] = None
    uses_oauth: Optional[bool] = None
    required_fields: Optional[Sequence["IntegrationRequiredField"]] = None
    delegate_oauth: Optional[bool] = None
    installed_delegate_oauth_targets: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        integration_hub_id: Optional[str] = None,
        label: Optional[str] = None,
        description: Optional[str] = None,
        enabled: Optional[bool] = None,
        params: Optional[Sequence["IntegrationParam"]] = None,
        supported_formats: Optional[Sequence["SupportedFormats"]] = None,
        supported_action_types: Optional[Sequence["SupportedActionTypes"]] = None,
        supported_formattings: Optional[Sequence["SupportedFormattings"]] = None,
        supported_visualization_formattings: Optional[
            Sequence["SupportedVisualizationFormattings"]
        ] = None,
        supported_download_settings: Optional[
            Sequence["SupportedDownloadSettings"]
        ] = None,
        icon_url: Optional[str] = None,
        uses_oauth: Optional[bool] = None,
        required_fields: Optional[Sequence["IntegrationRequiredField"]] = None,
        delegate_oauth: Optional[bool] = None,
        installed_delegate_oauth_targets: Optional[Sequence[str]] = None
    ):
        self.can = can
        self.id = id
        self.integration_hub_id = integration_hub_id
        self.label = label
        self.description = description
        self.enabled = enabled
        self.params = params
        self.supported_formats = supported_formats
        self.supported_action_types = supported_action_types
        self.supported_formattings = supported_formattings
        self.supported_visualization_formattings = supported_visualization_formattings
        self.supported_download_settings = supported_download_settings
        self.icon_url = icon_url
        self.uses_oauth = uses_oauth
        self.required_fields = required_fields
        self.delegate_oauth = delegate_oauth
        self.installed_delegate_oauth_targets = installed_delegate_oauth_targets


@attr.s(auto_attribs=True, init=False)
class IntegrationHub(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: ID of the hub.
        url: URL of the hub.
        label: Label of the hub.
        official: Whether this hub is a first-party integration hub operated by Looker.
        fetch_error_message: An error message, present if the integration hub metadata could not be fetched. If this is present, the integration hub is unusable.
        authorization_token: (Write-Only) An authorization key that will be sent to the integration hub on every request.
        has_authorization_token: Whether the authorization_token is set for the hub.
        legal_agreement_signed: Whether the legal agreement message has been signed by the user. This only matters if legal_agreement_required is true.
        legal_agreement_required: Whether the legal terms for the integration hub are required before use.
        legal_agreement_text: The legal agreement text for this integration hub.
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    url: Optional[str] = None
    label: Optional[str] = None
    official: Optional[bool] = None
    fetch_error_message: Optional[str] = None
    authorization_token: Optional[str] = None
    has_authorization_token: Optional[bool] = None
    legal_agreement_signed: Optional[bool] = None
    legal_agreement_required: Optional[bool] = None
    legal_agreement_text: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        url: Optional[str] = None,
        label: Optional[str] = None,
        official: Optional[bool] = None,
        fetch_error_message: Optional[str] = None,
        authorization_token: Optional[str] = None,
        has_authorization_token: Optional[bool] = None,
        legal_agreement_signed: Optional[bool] = None,
        legal_agreement_required: Optional[bool] = None,
        legal_agreement_text: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.url = url
        self.label = label
        self.official = official
        self.fetch_error_message = fetch_error_message
        self.authorization_token = authorization_token
        self.has_authorization_token = has_authorization_token
        self.legal_agreement_signed = legal_agreement_signed
        self.legal_agreement_required = legal_agreement_required
        self.legal_agreement_text = legal_agreement_text


@attr.s(auto_attribs=True, init=False)
class IntegrationParam(model.Model):
    """
    Attributes:
        name: Name of the parameter.
        label: Label of the parameter.
        description: Short description of the parameter.
        required: Whether the parameter is required to be set to use the destination. If unspecified, this defaults to false.
        has_value: Whether the parameter has a value set.
        value: The current value of the parameter. Always null if the value is sensitive. When writing, null values will be ignored. Set the value to an empty string to clear it.
        user_attribute_name: When present, the param's value comes from this user attribute instead of the 'value' parameter. Set to null to use the 'value'.
        sensitive: Whether the parameter contains sensitive data like API credentials. If unspecified, this defaults to true.
        per_user: When true, this parameter must be assigned to a user attribute in the admin panel (instead of a constant value), and that value may be updated by the user as part of the integration flow.
        delegate_oauth_url: When present, the param represents the oauth url the user will be taken to.
    """

    name: Optional[str] = None
    label: Optional[str] = None
    description: Optional[str] = None
    required: Optional[bool] = None
    has_value: Optional[bool] = None
    value: Optional[str] = None
    user_attribute_name: Optional[str] = None
    sensitive: Optional[bool] = None
    per_user: Optional[bool] = None
    delegate_oauth_url: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        label: Optional[str] = None,
        description: Optional[str] = None,
        required: Optional[bool] = None,
        has_value: Optional[bool] = None,
        value: Optional[str] = None,
        user_attribute_name: Optional[str] = None,
        sensitive: Optional[bool] = None,
        per_user: Optional[bool] = None,
        delegate_oauth_url: Optional[str] = None
    ):
        self.name = name
        self.label = label
        self.description = description
        self.required = required
        self.has_value = has_value
        self.value = value
        self.user_attribute_name = user_attribute_name
        self.sensitive = sensitive
        self.per_user = per_user
        self.delegate_oauth_url = delegate_oauth_url


@attr.s(auto_attribs=True, init=False)
class IntegrationRequiredField(model.Model):
    """
    Attributes:
        tag: Matches a field that has this tag.
        any_tag: If present, supercedes 'tag' and matches a field that has any of the provided tags.
        all_tags: If present, supercedes 'tag' and matches a field that has all of the provided tags.
    """

    tag: Optional[str] = None
    any_tag: Optional[Sequence[str]] = None
    all_tags: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        tag: Optional[str] = None,
        any_tag: Optional[Sequence[str]] = None,
        all_tags: Optional[Sequence[str]] = None
    ):
        self.tag = tag
        self.any_tag = any_tag
        self.all_tags = all_tags


@attr.s(auto_attribs=True, init=False)
class IntegrationTestResult(model.Model):
    """
    Attributes:
        success: Whether or not the test was successful
        message: A message representing the results of the test.
        delegate_oauth_result: An array of connection test result for delegate oauth actions.
    """

    success: Optional[bool] = None
    message: Optional[str] = None
    delegate_oauth_result: Optional[Sequence["DelegateOauthTest"]] = None

    def __init__(
        self,
        *,
        success: Optional[bool] = None,
        message: Optional[str] = None,
        delegate_oauth_result: Optional[Sequence["DelegateOauthTest"]] = None
    ):
        self.success = success
        self.message = message
        self.delegate_oauth_result = delegate_oauth_result


@attr.s(auto_attribs=True, init=False)
class InternalHelpResources(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        enabled: If true and internal help resources content is not blank then the link for internal help resources will be shown in the help menu and the content displayed within Looker
    """

    can: Optional[MutableMapping[str, bool]] = None
    enabled: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        enabled: Optional[bool] = None
    ):
        self.can = can
        self.enabled = enabled


@attr.s(auto_attribs=True, init=False)
class InternalHelpResourcesContent(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        organization_name: Text to display in the help menu item which will display the internal help resources
        markdown_content: Content to be displayed in the internal help resources page/modal
    """

    can: Optional[MutableMapping[str, bool]] = None
    organization_name: Optional[str] = None
    markdown_content: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        organization_name: Optional[str] = None,
        markdown_content: Optional[str] = None
    ):
        self.can = can
        self.organization_name = organization_name
        self.markdown_content = markdown_content


class InvestigativeContentType(enum.Enum):
    """
    The type of the investigative content Valid values are: "dashboard". (Enum defined in Alert)

    """

    dashboard = "dashboard"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
InvestigativeContentType.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class LDAPConfig(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        alternate_email_login_allowed: Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.
        auth_password: (Write-Only)  Password for the LDAP account used to access the LDAP server
        auth_requires_role: Users will not be allowed to login at all unless a role for them is found in LDAP if set to true
        auth_username: Distinguished name of LDAP account used to access the LDAP server
        connection_host: LDAP server hostname
        connection_port: LDAP host port
        connection_tls: Use Transport Layer Security
        connection_tls_no_verify: Do not verify peer when using TLS
        default_new_user_group_ids: (Write-Only)  Array of ids of groups that will be applied to new users the first time they login via LDAP
        default_new_user_groups: (Read-only) Groups that will be applied to new users the first time they login via LDAP
        default_new_user_role_ids: (Write-Only)  Array of ids of roles that will be applied to new users the first time they login via LDAP
        default_new_user_roles: (Read-only) Roles that will be applied to new users the first time they login via LDAP
        enabled: Enable/Disable LDAP authentication for the server
        force_no_page: Don't attempt to do LDAP search result paging (RFC 2696) even if the LDAP server claims to support it.
        groups: (Read-only) Array of mappings between LDAP Groups and Looker Roles
        groups_base_dn: Base dn for finding groups in LDAP searches
        groups_finder_type: Identifier for a strategy for how Looker will search for groups in the LDAP server
        groups_member_attribute: LDAP Group attribute that signifies the members of the groups. Most commonly 'member'
        groups_objectclasses: Optional comma-separated list of supported LDAP objectclass for groups when doing groups searches
        groups_user_attribute: LDAP Group attribute that signifies the user in a group. Most commonly 'dn'
        groups_with_role_ids: (Read/Write) Array of mappings between LDAP Groups and arrays of Looker Role ids
        has_auth_password: (Read-only) Has the password been set for the LDAP account used to access the LDAP server
        merge_new_users_by_email: Merge first-time ldap login to existing user account by email addresses. When a user logs in for the first time via ldap this option will connect this user into their existing account by finding the account with a matching email address. Otherwise a new user account will be created for the user.
        modified_at: When this config was last modified
        modified_by: User id of user who last modified this config
        set_roles_from_groups: Set user roles in Looker based on groups from LDAP
        test_ldap_password: (Write-Only)  Test LDAP user password. For ldap tests only.
        test_ldap_user: (Write-Only)  Test LDAP user login id. For ldap tests only.
        user_attribute_map_email: Name of user record attributes used to indicate email address field
        user_attribute_map_first_name: Name of user record attributes used to indicate first name
        user_attribute_map_last_name: Name of user record attributes used to indicate last name
        user_attribute_map_ldap_id: Name of user record attributes used to indicate unique record id
        user_attributes: (Read-only) Array of mappings between LDAP User Attributes and Looker User Attributes
        user_attributes_with_ids: (Read/Write) Array of mappings between LDAP User Attributes and arrays of Looker User Attribute ids
        user_bind_base_dn: Distinguished name of LDAP node used as the base for user searches
        user_custom_filter: (Optional) Custom RFC-2254 filter clause for use in finding user during login. Combined via 'and' with the other generated filter clauses.
        user_id_attribute_names: Name(s) of user record attributes used for matching user login id (comma separated list)
        user_objectclass: (Optional) Name of user record objectclass used for finding user during login id
        allow_normal_group_membership: Allow LDAP auth'd users to be members of non-reflected Looker groups. If 'false', user will be removed from non-reflected groups on login.
        allow_roles_from_normal_groups: LDAP auth'd users will be able to inherit roles from non-reflected Looker groups.
        allow_direct_roles: Allows roles to be directly assigned to LDAP auth'd users.
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    alternate_email_login_allowed: Optional[bool] = None
    auth_password: Optional[str] = None
    auth_requires_role: Optional[bool] = None
    auth_username: Optional[str] = None
    connection_host: Optional[str] = None
    connection_port: Optional[str] = None
    connection_tls: Optional[bool] = None
    connection_tls_no_verify: Optional[bool] = None
    default_new_user_group_ids: Optional[Sequence[str]] = None
    default_new_user_groups: Optional[Sequence["Group"]] = None
    default_new_user_role_ids: Optional[Sequence[str]] = None
    default_new_user_roles: Optional[Sequence["Role"]] = None
    enabled: Optional[bool] = None
    force_no_page: Optional[bool] = None
    groups: Optional[Sequence["LDAPGroupRead"]] = None
    groups_base_dn: Optional[str] = None
    groups_finder_type: Optional[str] = None
    groups_member_attribute: Optional[str] = None
    groups_objectclasses: Optional[str] = None
    groups_user_attribute: Optional[str] = None
    groups_with_role_ids: Optional[Sequence["LDAPGroupWrite"]] = None
    has_auth_password: Optional[bool] = None
    merge_new_users_by_email: Optional[bool] = None
    modified_at: Optional[str] = None
    modified_by: Optional[str] = None
    set_roles_from_groups: Optional[bool] = None
    test_ldap_password: Optional[str] = None
    test_ldap_user: Optional[str] = None
    user_attribute_map_email: Optional[str] = None
    user_attribute_map_first_name: Optional[str] = None
    user_attribute_map_last_name: Optional[str] = None
    user_attribute_map_ldap_id: Optional[str] = None
    user_attributes: Optional[Sequence["LDAPUserAttributeRead"]] = None
    user_attributes_with_ids: Optional[Sequence["LDAPUserAttributeWrite"]] = None
    user_bind_base_dn: Optional[str] = None
    user_custom_filter: Optional[str] = None
    user_id_attribute_names: Optional[str] = None
    user_objectclass: Optional[str] = None
    allow_normal_group_membership: Optional[bool] = None
    allow_roles_from_normal_groups: Optional[bool] = None
    allow_direct_roles: Optional[bool] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        alternate_email_login_allowed: Optional[bool] = None,
        auth_password: Optional[str] = None,
        auth_requires_role: Optional[bool] = None,
        auth_username: Optional[str] = None,
        connection_host: Optional[str] = None,
        connection_port: Optional[str] = None,
        connection_tls: Optional[bool] = None,
        connection_tls_no_verify: Optional[bool] = None,
        default_new_user_group_ids: Optional[Sequence[str]] = None,
        default_new_user_groups: Optional[Sequence["Group"]] = None,
        default_new_user_role_ids: Optional[Sequence[str]] = None,
        default_new_user_roles: Optional[Sequence["Role"]] = None,
        enabled: Optional[bool] = None,
        force_no_page: Optional[bool] = None,
        groups: Optional[Sequence["LDAPGroupRead"]] = None,
        groups_base_dn: Optional[str] = None,
        groups_finder_type: Optional[str] = None,
        groups_member_attribute: Optional[str] = None,
        groups_objectclasses: Optional[str] = None,
        groups_user_attribute: Optional[str] = None,
        groups_with_role_ids: Optional[Sequence["LDAPGroupWrite"]] = None,
        has_auth_password: Optional[bool] = None,
        merge_new_users_by_email: Optional[bool] = None,
        modified_at: Optional[str] = None,
        modified_by: Optional[str] = None,
        set_roles_from_groups: Optional[bool] = None,
        test_ldap_password: Optional[str] = None,
        test_ldap_user: Optional[str] = None,
        user_attribute_map_email: Optional[str] = None,
        user_attribute_map_first_name: Optional[str] = None,
        user_attribute_map_last_name: Optional[str] = None,
        user_attribute_map_ldap_id: Optional[str] = None,
        user_attributes: Optional[Sequence["LDAPUserAttributeRead"]] = None,
        user_attributes_with_ids: Optional[Sequence["LDAPUserAttributeWrite"]] = None,
        user_bind_base_dn: Optional[str] = None,
        user_custom_filter: Optional[str] = None,
        user_id_attribute_names: Optional[str] = None,
        user_objectclass: Optional[str] = None,
        allow_normal_group_membership: Optional[bool] = None,
        allow_roles_from_normal_groups: Optional[bool] = None,
        allow_direct_roles: Optional[bool] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.alternate_email_login_allowed = alternate_email_login_allowed
        self.auth_password = auth_password
        self.auth_requires_role = auth_requires_role
        self.auth_username = auth_username
        self.connection_host = connection_host
        self.connection_port = connection_port
        self.connection_tls = connection_tls
        self.connection_tls_no_verify = connection_tls_no_verify
        self.default_new_user_group_ids = default_new_user_group_ids
        self.default_new_user_groups = default_new_user_groups
        self.default_new_user_role_ids = default_new_user_role_ids
        self.default_new_user_roles = default_new_user_roles
        self.enabled = enabled
        self.force_no_page = force_no_page
        self.groups = groups
        self.groups_base_dn = groups_base_dn
        self.groups_finder_type = groups_finder_type
        self.groups_member_attribute = groups_member_attribute
        self.groups_objectclasses = groups_objectclasses
        self.groups_user_attribute = groups_user_attribute
        self.groups_with_role_ids = groups_with_role_ids
        self.has_auth_password = has_auth_password
        self.merge_new_users_by_email = merge_new_users_by_email
        self.modified_at = modified_at
        self.modified_by = modified_by
        self.set_roles_from_groups = set_roles_from_groups
        self.test_ldap_password = test_ldap_password
        self.test_ldap_user = test_ldap_user
        self.user_attribute_map_email = user_attribute_map_email
        self.user_attribute_map_first_name = user_attribute_map_first_name
        self.user_attribute_map_last_name = user_attribute_map_last_name
        self.user_attribute_map_ldap_id = user_attribute_map_ldap_id
        self.user_attributes = user_attributes
        self.user_attributes_with_ids = user_attributes_with_ids
        self.user_bind_base_dn = user_bind_base_dn
        self.user_custom_filter = user_custom_filter
        self.user_id_attribute_names = user_id_attribute_names
        self.user_objectclass = user_objectclass
        self.allow_normal_group_membership = allow_normal_group_membership
        self.allow_roles_from_normal_groups = allow_roles_from_normal_groups
        self.allow_direct_roles = allow_direct_roles
        self.url = url


@attr.s(auto_attribs=True, init=False)
class LDAPConfigTestIssue(model.Model):
    """
    Attributes:
        severity: Severity of the issue. Error or Warning
        message: Message describing the issue
    """

    severity: Optional[str] = None
    message: Optional[str] = None

    def __init__(
        self, *, severity: Optional[str] = None, message: Optional[str] = None
    ):
        self.severity = severity
        self.message = message


@attr.s(auto_attribs=True, init=False)
class LDAPConfigTestResult(model.Model):
    """
    Attributes:
        details: Additional details for error cases
        issues: Array of issues/considerations about the result
        message: Short human readable test about the result
        status: Test status code: always 'success' or 'error'
        trace: A more detailed trace of incremental results during auth tests
        user:
        url: Link to ldap config
    """

    details: Optional[str] = None
    issues: Optional[Sequence["LDAPConfigTestIssue"]] = None
    message: Optional[str] = None
    status: Optional[str] = None
    trace: Optional[str] = None
    user: Optional["LDAPUser"] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        details: Optional[str] = None,
        issues: Optional[Sequence["LDAPConfigTestIssue"]] = None,
        message: Optional[str] = None,
        status: Optional[str] = None,
        trace: Optional[str] = None,
        user: Optional["LDAPUser"] = None,
        url: Optional[str] = None
    ):
        self.details = details
        self.issues = issues
        self.message = message
        self.status = status
        self.trace = trace
        self.user = user
        self.url = url


@attr.s(auto_attribs=True, init=False)
class LDAPGroupRead(model.Model):
    """
    Attributes:
        id: Unique Id
        looker_group_id: Unique Id of group in Looker
        looker_group_name: Name of group in Looker
        name: Name of group in LDAP
        roles: Looker Roles
        url: Link to ldap config
    """

    id: Optional[str] = None
    looker_group_id: Optional[str] = None
    looker_group_name: Optional[str] = None
    name: Optional[str] = None
    roles: Optional[Sequence["Role"]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        looker_group_id: Optional[str] = None,
        looker_group_name: Optional[str] = None,
        name: Optional[str] = None,
        roles: Optional[Sequence["Role"]] = None,
        url: Optional[str] = None
    ):
        self.id = id
        self.looker_group_id = looker_group_id
        self.looker_group_name = looker_group_name
        self.name = name
        self.roles = roles
        self.url = url


@attr.s(auto_attribs=True, init=False)
class LDAPGroupWrite(model.Model):
    """
    Attributes:
        id: Unique Id
        looker_group_id: Unique Id of group in Looker
        looker_group_name: Name of group in Looker
        name: Name of group in LDAP
        role_ids: Looker Role Ids
        url: Link to ldap config
    """

    id: Optional[str] = None
    looker_group_id: Optional[str] = None
    looker_group_name: Optional[str] = None
    name: Optional[str] = None
    role_ids: Optional[Sequence[str]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        looker_group_id: Optional[str] = None,
        looker_group_name: Optional[str] = None,
        name: Optional[str] = None,
        role_ids: Optional[Sequence[str]] = None,
        url: Optional[str] = None
    ):
        self.id = id
        self.looker_group_id = looker_group_id
        self.looker_group_name = looker_group_name
        self.name = name
        self.role_ids = role_ids
        self.url = url


@attr.s(auto_attribs=True, init=False)
class LDAPUser(model.Model):
    """
    Attributes:
        all_emails: Array of user's email addresses and aliases for use in migration
        attributes: Dictionary of user's attributes (name/value)
        email: Primary email address
        first_name: First name
        groups: Array of user's groups (group names only)
        last_name: Last Name
        ldap_dn: LDAP's distinguished name for the user record
        ldap_id: LDAP's Unique ID for the user
        roles: Array of user's roles (role names only)
        url: Link to ldap config
    """

    all_emails: Optional[Sequence[str]] = None
    attributes: Optional[MutableMapping[str, Any]] = None
    email: Optional[str] = None
    first_name: Optional[str] = None
    groups: Optional[Sequence[str]] = None
    last_name: Optional[str] = None
    ldap_dn: Optional[str] = None
    ldap_id: Optional[str] = None
    roles: Optional[Sequence[str]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        all_emails: Optional[Sequence[str]] = None,
        attributes: Optional[MutableMapping[str, Any]] = None,
        email: Optional[str] = None,
        first_name: Optional[str] = None,
        groups: Optional[Sequence[str]] = None,
        last_name: Optional[str] = None,
        ldap_dn: Optional[str] = None,
        ldap_id: Optional[str] = None,
        roles: Optional[Sequence[str]] = None,
        url: Optional[str] = None
    ):
        self.all_emails = all_emails
        self.attributes = attributes
        self.email = email
        self.first_name = first_name
        self.groups = groups
        self.last_name = last_name
        self.ldap_dn = ldap_dn
        self.ldap_id = ldap_id
        self.roles = roles
        self.url = url


@attr.s(auto_attribs=True, init=False)
class LDAPUserAttributeRead(model.Model):
    """
    Attributes:
        name: Name of User Attribute in LDAP
        required: Required to be in LDAP assertion for login to be allowed to succeed
        user_attributes: Looker User Attributes
        url: Link to ldap config
    """

    name: Optional[str] = None
    required: Optional[bool] = None
    user_attributes: Optional[Sequence["UserAttribute"]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        required: Optional[bool] = None,
        user_attributes: Optional[Sequence["UserAttribute"]] = None,
        url: Optional[str] = None
    ):
        self.name = name
        self.required = required
        self.user_attributes = user_attributes
        self.url = url


@attr.s(auto_attribs=True, init=False)
class LDAPUserAttributeWrite(model.Model):
    """
    Attributes:
        name: Name of User Attribute in LDAP
        required: Required to be in LDAP assertion for login to be allowed to succeed
        user_attribute_ids: Looker User Attribute Ids
        url: Link to ldap config
    """

    name: Optional[str] = None
    required: Optional[bool] = None
    user_attribute_ids: Optional[Sequence[str]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        required: Optional[bool] = None,
        user_attribute_ids: Optional[Sequence[str]] = None,
        url: Optional[str] = None
    ):
        self.name = name
        self.required = required
        self.user_attribute_ids = user_attribute_ids
        self.url = url


@attr.s(auto_attribs=True, init=False)
class LegacyFeature(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        name: Name
        description: Description
        enabled_locally: Whether this feature has been enabled by a user
        enabled: Whether this feature is currently enabled
        disallowed_as_of_version: Looker version where this feature became a legacy feature
        disable_on_upgrade_to_version: Looker version where this feature will be automatically disabled
        end_of_life_version: Future Looker version where this feature will be removed
        documentation_url: URL for documentation about this feature
        approximate_disable_date: Approximate date that this feature will be automatically disabled.
        approximate_end_of_life_date: Approximate date that this feature will be removed.
        has_disabled_on_upgrade: Whether this legacy feature may have been automatically disabled when upgrading to the current version.
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    enabled_locally: Optional[bool] = None
    enabled: Optional[bool] = None
    disallowed_as_of_version: Optional[str] = None
    disable_on_upgrade_to_version: Optional[str] = None
    end_of_life_version: Optional[str] = None
    documentation_url: Optional[str] = None
    approximate_disable_date: Optional[datetime.datetime] = None
    approximate_end_of_life_date: Optional[datetime.datetime] = None
    has_disabled_on_upgrade: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        enabled_locally: Optional[bool] = None,
        enabled: Optional[bool] = None,
        disallowed_as_of_version: Optional[str] = None,
        disable_on_upgrade_to_version: Optional[str] = None,
        end_of_life_version: Optional[str] = None,
        documentation_url: Optional[str] = None,
        approximate_disable_date: Optional[datetime.datetime] = None,
        approximate_end_of_life_date: Optional[datetime.datetime] = None,
        has_disabled_on_upgrade: Optional[bool] = None
    ):
        self.can = can
        self.id = id
        self.name = name
        self.description = description
        self.enabled_locally = enabled_locally
        self.enabled = enabled
        self.disallowed_as_of_version = disallowed_as_of_version
        self.disable_on_upgrade_to_version = disable_on_upgrade_to_version
        self.end_of_life_version = end_of_life_version
        self.documentation_url = documentation_url
        self.approximate_disable_date = approximate_disable_date
        self.approximate_end_of_life_date = approximate_end_of_life_date
        self.has_disabled_on_upgrade = has_disabled_on_upgrade


@attr.s(auto_attribs=True, init=False)
class Locale(model.Model):
    """
    Attributes:
        code: Code for Locale
        native_name: Name of Locale in its own language
        english_name: Name of Locale in English
    """

    code: Optional[str] = None
    native_name: Optional[str] = None
    english_name: Optional[str] = None

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        native_name: Optional[str] = None,
        english_name: Optional[str] = None
    ):
        self.code = code
        self.native_name = native_name
        self.english_name = english_name


@attr.s(auto_attribs=True, init=False)
class LocalizationSettings(model.Model):
    """
    Attributes:
        default_locale: Default locale for localization
        localization_level: Localization level - strict or permissive
    """

    default_locale: Optional[str] = None
    localization_level: Optional[str] = None

    def __init__(
        self,
        *,
        default_locale: Optional[str] = None,
        localization_level: Optional[str] = None
    ):
        self.default_locale = default_locale
        self.localization_level = localization_level


@attr.s(auto_attribs=True, init=False)
class Look(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_metadata_id: Id of content metadata
        id: Unique Id
        title: Look Title
        user_id: User Id
        content_favorite_id: Content Favorite Id
        created_at: Time that the Look was created.
        deleted: Whether or not a look is 'soft' deleted.
        deleted_at: Time that the Look was deleted.
        deleter_id: Id of User that deleted the look.
        description: Description
        embed_url: Embed Url
        excel_file_url: Excel File Url
        favorite_count: Number of times favorited
        google_spreadsheet_formula: Google Spreadsheet Formula
        image_embed_url: Image Embed Url
        is_run_on_load: auto-run query when Look viewed
        last_accessed_at: Time that the Look was last accessed by any user
        last_updater_id: Id of User that last updated the look.
        last_viewed_at: Time last viewed in the Looker web UI
        model:
        public: Is Public
        public_slug: Public Slug
        public_url: Public Url
        query_id: Query Id
        short_url: Short Url
        folder:
        folder_id: Folder Id
        updated_at: Time that the Look was updated.
        view_count: Number of times viewed in the Looker web UI
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_metadata_id: Optional[str] = None
    id: Optional[str] = None
    title: Optional[str] = None
    user_id: Optional[str] = None
    content_favorite_id: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    deleted: Optional[bool] = None
    deleted_at: Optional[datetime.datetime] = None
    deleter_id: Optional[str] = None
    description: Optional[str] = None
    embed_url: Optional[str] = None
    excel_file_url: Optional[str] = None
    favorite_count: Optional[int] = None
    google_spreadsheet_formula: Optional[str] = None
    image_embed_url: Optional[str] = None
    is_run_on_load: Optional[bool] = None
    last_accessed_at: Optional[datetime.datetime] = None
    last_updater_id: Optional[str] = None
    last_viewed_at: Optional[datetime.datetime] = None
    model: Optional["LookModel"] = None
    public: Optional[bool] = None
    public_slug: Optional[str] = None
    public_url: Optional[str] = None
    query_id: Optional[str] = None
    short_url: Optional[str] = None
    folder: Optional["FolderBase"] = None
    folder_id: Optional[str] = None
    updated_at: Optional[datetime.datetime] = None
    view_count: Optional[int] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_metadata_id: Optional[str] = None,
        id: Optional[str] = None,
        title: Optional[str] = None,
        user_id: Optional[str] = None,
        content_favorite_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        deleted: Optional[bool] = None,
        deleted_at: Optional[datetime.datetime] = None,
        deleter_id: Optional[str] = None,
        description: Optional[str] = None,
        embed_url: Optional[str] = None,
        excel_file_url: Optional[str] = None,
        favorite_count: Optional[int] = None,
        google_spreadsheet_formula: Optional[str] = None,
        image_embed_url: Optional[str] = None,
        is_run_on_load: Optional[bool] = None,
        last_accessed_at: Optional[datetime.datetime] = None,
        last_updater_id: Optional[str] = None,
        last_viewed_at: Optional[datetime.datetime] = None,
        model: Optional["LookModel"] = None,
        public: Optional[bool] = None,
        public_slug: Optional[str] = None,
        public_url: Optional[str] = None,
        query_id: Optional[str] = None,
        short_url: Optional[str] = None,
        folder: Optional["FolderBase"] = None,
        folder_id: Optional[str] = None,
        updated_at: Optional[datetime.datetime] = None,
        view_count: Optional[int] = None
    ):
        self.can = can
        self.content_metadata_id = content_metadata_id
        self.id = id
        self.title = title
        self.user_id = user_id
        self.content_favorite_id = content_favorite_id
        self.created_at = created_at
        self.deleted = deleted
        self.deleted_at = deleted_at
        self.deleter_id = deleter_id
        self.description = description
        self.embed_url = embed_url
        self.excel_file_url = excel_file_url
        self.favorite_count = favorite_count
        self.google_spreadsheet_formula = google_spreadsheet_formula
        self.image_embed_url = image_embed_url
        self.is_run_on_load = is_run_on_load
        self.last_accessed_at = last_accessed_at
        self.last_updater_id = last_updater_id
        self.last_viewed_at = last_viewed_at
        self.model = model
        self.public = public
        self.public_slug = public_slug
        self.public_url = public_url
        self.query_id = query_id
        self.short_url = short_url
        self.folder = folder
        self.folder_id = folder_id
        self.updated_at = updated_at
        self.view_count = view_count


@attr.s(auto_attribs=True, init=False)
class LookBasic(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_metadata_id: Id of content metadata
        id: Unique Id
        title: Look Title
        user_id: User Id
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_metadata_id: Optional[str] = None
    id: Optional[str] = None
    title: Optional[str] = None
    user_id: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_metadata_id: Optional[str] = None,
        id: Optional[str] = None,
        title: Optional[str] = None,
        user_id: Optional[str] = None
    ):
        self.can = can
        self.content_metadata_id = content_metadata_id
        self.id = id
        self.title = title
        self.user_id = user_id


@attr.s(auto_attribs=True, init=False)
class LookmlModel(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        allowed_db_connection_names: Array of names of connections this model is allowed to use
        explores: Array of explores (if has_content)
        has_content: Does this model declaration have have lookml content?
        label: UI-friendly name for this model
        name: Name of the model. Also used as the unique identifier
        project_name: Name of project containing the model
        unlimited_db_connections: Is this model allowed to use all current and future connections
    """

    can: Optional[MutableMapping[str, bool]] = None
    allowed_db_connection_names: Optional[Sequence[str]] = None
    explores: Optional[Sequence["LookmlModelNavExplore"]] = None
    has_content: Optional[bool] = None
    label: Optional[str] = None
    name: Optional[str] = None
    project_name: Optional[str] = None
    unlimited_db_connections: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        allowed_db_connection_names: Optional[Sequence[str]] = None,
        explores: Optional[Sequence["LookmlModelNavExplore"]] = None,
        has_content: Optional[bool] = None,
        label: Optional[str] = None,
        name: Optional[str] = None,
        project_name: Optional[str] = None,
        unlimited_db_connections: Optional[bool] = None
    ):
        self.can = can
        self.allowed_db_connection_names = allowed_db_connection_names
        self.explores = explores
        self.has_content = has_content
        self.label = label
        self.name = name
        self.project_name = project_name
        self.unlimited_db_connections = unlimited_db_connections


@attr.s(auto_attribs=True, init=False)
class LookmlModelExplore(model.Model):
    """
    Attributes:
        id: Fully qualified explore name (model name plus explore name)
        name: Explore name
        description: Description
        label: Label
        title: Explore title
        scopes: Scopes
        can_total: Can Total
        can_develop: Can Develop LookML
        can_see_lookml: Can See LookML
        lookml_link: A URL linking to the definition of this explore in the LookML IDE.
        can_save: Can Save
        can_explain: Can Explain
        can_pivot_in_db: Can pivot in the DB
        can_subtotal: Can use subtotals
        has_timezone_support: Has timezone support
        supports_cost_estimate: Cost estimates supported
        connection_name: Connection name
        null_sort_treatment: How nulls are sorted, possible values are "low", "high", "first" and "last"
        files: List of model source files
        source_file: Primary source_file file
        project_name: Name of project
        model_name: Name of model
        view_name: Name of view
        hidden: Is hidden
        sql_table_name: A sql_table_name expression that defines what sql table the view/explore maps onto. Example: "prod_orders2 AS orders" in a view named orders.
        access_filter_fields: (DEPRECATED) Array of access filter field names
        access_filters: Access filters
        aliases: Aliases
        always_filter: Always filter
        conditionally_filter: Conditionally filter
        index_fields: Array of index fields
        sets: Sets
        tags: An array of arbitrary string tags provided in the model for this explore.
        errors: Errors
        fields:
        joins: Views joined into this explore
        group_label: Label used to group explores in the navigation menus
        supported_measure_types: An array of items describing which custom measure types are supported for creating a custom measure 'based_on' each possible dimension type.
        always_join: An array of joins that will always be included in the SQL for this explore, even if the user has not selected a field from the joined view.
    """

    id: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    label: Optional[str] = None
    title: Optional[str] = None
    scopes: Optional[Sequence[str]] = None
    can_total: Optional[bool] = None
    can_develop: Optional[bool] = None
    can_see_lookml: Optional[bool] = None
    lookml_link: Optional[str] = None
    can_save: Optional[bool] = None
    can_explain: Optional[bool] = None
    can_pivot_in_db: Optional[bool] = None
    can_subtotal: Optional[bool] = None
    has_timezone_support: Optional[bool] = None
    supports_cost_estimate: Optional[bool] = None
    connection_name: Optional[str] = None
    null_sort_treatment: Optional[str] = None
    files: Optional[Sequence[str]] = None
    source_file: Optional[str] = None
    project_name: Optional[str] = None
    model_name: Optional[str] = None
    view_name: Optional[str] = None
    hidden: Optional[bool] = None
    sql_table_name: Optional[str] = None
    access_filter_fields: Optional[Sequence[str]] = None
    access_filters: Optional[Sequence["LookmlModelExploreAccessFilter"]] = None
    aliases: Optional[Sequence["LookmlModelExploreAlias"]] = None
    always_filter: Optional[Sequence["LookmlModelExploreAlwaysFilter"]] = None
    conditionally_filter: Optional[
        Sequence["LookmlModelExploreConditionallyFilter"]
    ] = None
    index_fields: Optional[Sequence[str]] = None
    sets: Optional[Sequence["LookmlModelExploreSet"]] = None
    tags: Optional[Sequence[str]] = None
    errors: Optional[Sequence["LookmlModelExploreError"]] = None
    fields: Optional["LookmlModelExploreFieldset"] = None
    joins: Optional[Sequence["LookmlModelExploreJoins"]] = None
    group_label: Optional[str] = None
    supported_measure_types: Optional[
        Sequence["LookmlModelExploreSupportedMeasureType"]
    ] = None
    always_join: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        label: Optional[str] = None,
        title: Optional[str] = None,
        scopes: Optional[Sequence[str]] = None,
        can_total: Optional[bool] = None,
        can_develop: Optional[bool] = None,
        can_see_lookml: Optional[bool] = None,
        lookml_link: Optional[str] = None,
        can_save: Optional[bool] = None,
        can_explain: Optional[bool] = None,
        can_pivot_in_db: Optional[bool] = None,
        can_subtotal: Optional[bool] = None,
        has_timezone_support: Optional[bool] = None,
        supports_cost_estimate: Optional[bool] = None,
        connection_name: Optional[str] = None,
        null_sort_treatment: Optional[str] = None,
        files: Optional[Sequence[str]] = None,
        source_file: Optional[str] = None,
        project_name: Optional[str] = None,
        model_name: Optional[str] = None,
        view_name: Optional[str] = None,
        hidden: Optional[bool] = None,
        sql_table_name: Optional[str] = None,
        access_filter_fields: Optional[Sequence[str]] = None,
        access_filters: Optional[Sequence["LookmlModelExploreAccessFilter"]] = None,
        aliases: Optional[Sequence["LookmlModelExploreAlias"]] = None,
        always_filter: Optional[Sequence["LookmlModelExploreAlwaysFilter"]] = None,
        conditionally_filter: Optional[
            Sequence["LookmlModelExploreConditionallyFilter"]
        ] = None,
        index_fields: Optional[Sequence[str]] = None,
        sets: Optional[Sequence["LookmlModelExploreSet"]] = None,
        tags: Optional[Sequence[str]] = None,
        errors: Optional[Sequence["LookmlModelExploreError"]] = None,
        fields: Optional["LookmlModelExploreFieldset"] = None,
        joins: Optional[Sequence["LookmlModelExploreJoins"]] = None,
        group_label: Optional[str] = None,
        supported_measure_types: Optional[
            Sequence["LookmlModelExploreSupportedMeasureType"]
        ] = None,
        always_join: Optional[Sequence[str]] = None
    ):
        self.id = id
        self.name = name
        self.description = description
        self.label = label
        self.title = title
        self.scopes = scopes
        self.can_total = can_total
        self.can_develop = can_develop
        self.can_see_lookml = can_see_lookml
        self.lookml_link = lookml_link
        self.can_save = can_save
        self.can_explain = can_explain
        self.can_pivot_in_db = can_pivot_in_db
        self.can_subtotal = can_subtotal
        self.has_timezone_support = has_timezone_support
        self.supports_cost_estimate = supports_cost_estimate
        self.connection_name = connection_name
        self.null_sort_treatment = null_sort_treatment
        self.files = files
        self.source_file = source_file
        self.project_name = project_name
        self.model_name = model_name
        self.view_name = view_name
        self.hidden = hidden
        self.sql_table_name = sql_table_name
        self.access_filter_fields = access_filter_fields
        self.access_filters = access_filters
        self.aliases = aliases
        self.always_filter = always_filter
        self.conditionally_filter = conditionally_filter
        self.index_fields = index_fields
        self.sets = sets
        self.tags = tags
        self.errors = errors
        self.fields = fields
        self.joins = joins
        self.group_label = group_label
        self.supported_measure_types = supported_measure_types
        self.always_join = always_join


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreAccessFilter(model.Model):
    """
    Attributes:
        field: Field to be filtered
        user_attribute: User attribute name
    """

    field: Optional[str] = None
    user_attribute: Optional[str] = None

    def __init__(
        self, *, field: Optional[str] = None, user_attribute: Optional[str] = None
    ):
        self.field = field
        self.user_attribute = user_attribute


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreAlias(model.Model):
    """
    Attributes:
        name: Name
        value: Value
    """

    name: Optional[str] = None
    value: Optional[str] = None

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None):
        self.name = name
        self.value = value


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreAlwaysFilter(model.Model):
    """
    Attributes:
        name: Name
        value: Value
    """

    name: Optional[str] = None
    value: Optional[str] = None

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None):
        self.name = name
        self.value = value


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreConditionallyFilter(model.Model):
    """
    Attributes:
        name: Name
        value: Value
    """

    name: Optional[str] = None
    value: Optional[str] = None

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None):
        self.name = name
        self.value = value


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreError(model.Model):
    """
    Attributes:
        message: Error Message
        details: Details
        error_pos: Error source location
        field_error: Is this a field error
    """

    message: Optional[str] = None
    details: Optional[Any] = None
    error_pos: Optional[str] = None
    field_error: Optional[bool] = None

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        details: Optional[Any] = None,
        error_pos: Optional[str] = None,
        field_error: Optional[bool] = None
    ):
        self.message = message
        self.details = details
        self.error_pos = error_pos
        self.field_error = field_error


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreField(model.Model):
    """
    Attributes:
        align: The appropriate horizontal text alignment the values of this field should be displayed in. Valid values are: "left", "right".
        can_filter: Whether it's possible to filter on this field.
        category: Field category Valid values are: "parameter", "filter", "measure", "dimension".
        default_filter_value: The default value that this field uses when filtering. Null if there is no default value.
        description: Description
        dimension_group: Dimension group if this field is part of a dimension group. If not, this will be null.
        enumerations: An array enumerating all the possible values that this field can contain. When null, there is no limit to the set of possible values this field can contain.
        error: An error message indicating a problem with the definition of this field. If there are no errors, this will be null.
        field_group_label: A label creating a grouping of fields. All fields with this label should be presented together when displayed in a UI.
        field_group_variant: When presented in a field group via field_group_label, a shorter name of the field to be displayed in that context.
        fill_style: The style of dimension fill that is possible for this field. Null if no dimension fill is possible. Valid values are: "enumeration", "range".
        fiscal_month_offset: An offset (in months) from the calendar start month to the fiscal start month defined in the LookML model this field belongs to.
        has_allowed_values: Whether this field has a set of allowed_values specified in LookML.
        hidden: Whether this field should be hidden from the user interface.
        is_filter: Whether this field is a filter.
        is_fiscal: Whether this field represents a fiscal time value.
        is_numeric: Whether this field is of a type that represents a numeric value.
        is_timeframe: Whether this field is of a type that represents a time value.
        can_time_filter: Whether this field can be time filtered.
        time_interval:
        label: Fully-qualified human-readable label of the field.
        label_from_parameter: The name of the parameter that will provide a parameterized label for this field, if available in the current context.
        label_short: The human-readable label of the field, without the view label.
        lookml_link: A URL linking to the definition of this field in the LookML IDE.
        map_layer:
        measure: Whether this field is a measure.
        name: Fully-qualified name of the field.
        strict_value_format: If yes, the field will not be localized with the user attribute number_format. Defaults to no
        parameter: Whether this field is a parameter.
        permanent: Whether this field can be removed from a query.
        primary_key: Whether or not the field represents a primary key.
        project_name: The name of the project this field is defined in.
        requires_refresh_on_sort: When true, it's not possible to re-sort this field's values without re-running the SQL query, due to database logic that affects the sort.
        scope: The LookML scope this field belongs to. The scope is typically the field's view.
        sortable: Whether this field can be sorted.
        source_file: The path portion of source_file_path.
        source_file_path: The fully-qualified path of the project file this field is defined in.
        sql: SQL expression as defined in the LookML model. The SQL syntax shown here is a representation intended for auditability, and is not neccessarily an exact match for what will ultimately be run in the database. It may contain special LookML syntax or annotations that are not valid SQL. This will be null if the current user does not have the see_lookml permission for the field's model.
        sql_case: An array of conditions and values that make up a SQL Case expression, as defined in the LookML model. The SQL syntax shown here is a representation intended for auditability, and is not neccessarily an exact match for what will ultimately be run in the database. It may contain special LookML syntax or annotations that are not valid SQL. This will be null if the current user does not have the see_lookml permission for the field's model.
        filters: Array of filter conditions defined for the measure in LookML.
        suggest_dimension: The name of the dimension to base suggest queries from.
        suggest_explore: The name of the explore to base suggest queries from.
        suggestable: Whether or not suggestions are possible for this field.
        suggestions: If available, a list of suggestions for this field. For most fields, a suggest query is a more appropriate way to get an up-to-date list of suggestions. Or use enumerations to list all the possible values.
        tags: An array of arbitrary string tags provided in the model for this field.
        type: The LookML type of the field.
        user_attribute_filter_types: An array of user attribute types that are allowed to be used in filters on this field. Valid values are: "advanced_filter_string", "advanced_filter_number", "advanced_filter_datetime", "string", "number", "datetime", "relative_url", "yesno", "zipcode".
        value_format: If specified, the LookML value format string for formatting values of this field.
        view: The name of the view this field belongs to.
        view_label: The human-readable label of the view the field belongs to.
        dynamic: Whether this field was specified in "dynamic_fields" and is not part of the model.
        week_start_day: The name of the starting day of the week. Valid values are: "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday".
        times_used: The number of times this field has been used in queries
        original_view: The name of the view this field is defined in. This will be different than "view" when the view has been joined via a different name using the "from" parameter.
    """

    align: Optional["Align"] = None
    can_filter: Optional[bool] = None
    category: Optional["Category"] = None
    default_filter_value: Optional[str] = None
    description: Optional[str] = None
    dimension_group: Optional[str] = None
    enumerations: Optional[Sequence["LookmlModelExploreFieldEnumeration"]] = None
    error: Optional[str] = None
    field_group_label: Optional[str] = None
    field_group_variant: Optional[str] = None
    fill_style: Optional["FillStyle"] = None
    fiscal_month_offset: Optional[int] = None
    has_allowed_values: Optional[bool] = None
    hidden: Optional[bool] = None
    is_filter: Optional[bool] = None
    is_fiscal: Optional[bool] = None
    is_numeric: Optional[bool] = None
    is_timeframe: Optional[bool] = None
    can_time_filter: Optional[bool] = None
    time_interval: Optional["LookmlModelExploreFieldTimeInterval"] = None
    label: Optional[str] = None
    label_from_parameter: Optional[str] = None
    label_short: Optional[str] = None
    lookml_link: Optional[str] = None
    map_layer: Optional["LookmlModelExploreFieldMapLayer"] = None
    measure: Optional[bool] = None
    name: Optional[str] = None
    strict_value_format: Optional[bool] = None
    parameter: Optional[bool] = None
    permanent: Optional[bool] = None
    primary_key: Optional[bool] = None
    project_name: Optional[str] = None
    requires_refresh_on_sort: Optional[bool] = None
    scope: Optional[str] = None
    sortable: Optional[bool] = None
    source_file: Optional[str] = None
    source_file_path: Optional[str] = None
    sql: Optional[str] = None
    sql_case: Optional[Sequence["LookmlModelExploreFieldSqlCase"]] = None
    filters: Optional[Sequence["LookmlModelExploreFieldMeasureFilters"]] = None
    suggest_dimension: Optional[str] = None
    suggest_explore: Optional[str] = None
    suggestable: Optional[bool] = None
    suggestions: Optional[Sequence[str]] = None
    tags: Optional[Sequence[str]] = None
    type: Optional[str] = None
    user_attribute_filter_types: Optional[Sequence["UserAttributeFilterTypes"]] = None
    value_format: Optional[str] = None
    view: Optional[str] = None
    view_label: Optional[str] = None
    dynamic: Optional[bool] = None
    week_start_day: Optional["WeekStartDay"] = None
    times_used: Optional[int] = None
    original_view: Optional[str] = None

    def __init__(
        self,
        *,
        align: Optional["Align"] = None,
        can_filter: Optional[bool] = None,
        category: Optional["Category"] = None,
        default_filter_value: Optional[str] = None,
        description: Optional[str] = None,
        dimension_group: Optional[str] = None,
        enumerations: Optional[Sequence["LookmlModelExploreFieldEnumeration"]] = None,
        error: Optional[str] = None,
        field_group_label: Optional[str] = None,
        field_group_variant: Optional[str] = None,
        fill_style: Optional["FillStyle"] = None,
        fiscal_month_offset: Optional[int] = None,
        has_allowed_values: Optional[bool] = None,
        hidden: Optional[bool] = None,
        is_filter: Optional[bool] = None,
        is_fiscal: Optional[bool] = None,
        is_numeric: Optional[bool] = None,
        is_timeframe: Optional[bool] = None,
        can_time_filter: Optional[bool] = None,
        time_interval: Optional["LookmlModelExploreFieldTimeInterval"] = None,
        label: Optional[str] = None,
        label_from_parameter: Optional[str] = None,
        label_short: Optional[str] = None,
        lookml_link: Optional[str] = None,
        map_layer: Optional["LookmlModelExploreFieldMapLayer"] = None,
        measure: Optional[bool] = None,
        name: Optional[str] = None,
        strict_value_format: Optional[bool] = None,
        parameter: Optional[bool] = None,
        permanent: Optional[bool] = None,
        primary_key: Optional[bool] = None,
        project_name: Optional[str] = None,
        requires_refresh_on_sort: Optional[bool] = None,
        scope: Optional[str] = None,
        sortable: Optional[bool] = None,
        source_file: Optional[str] = None,
        source_file_path: Optional[str] = None,
        sql: Optional[str] = None,
        sql_case: Optional[Sequence["LookmlModelExploreFieldSqlCase"]] = None,
        filters: Optional[Sequence["LookmlModelExploreFieldMeasureFilters"]] = None,
        suggest_dimension: Optional[str] = None,
        suggest_explore: Optional[str] = None,
        suggestable: Optional[bool] = None,
        suggestions: Optional[Sequence[str]] = None,
        tags: Optional[Sequence[str]] = None,
        type: Optional[str] = None,
        user_attribute_filter_types: Optional[
            Sequence["UserAttributeFilterTypes"]
        ] = None,
        value_format: Optional[str] = None,
        view: Optional[str] = None,
        view_label: Optional[str] = None,
        dynamic: Optional[bool] = None,
        week_start_day: Optional["WeekStartDay"] = None,
        times_used: Optional[int] = None,
        original_view: Optional[str] = None
    ):
        self.align = align
        self.can_filter = can_filter
        self.category = category
        self.default_filter_value = default_filter_value
        self.description = description
        self.dimension_group = dimension_group
        self.enumerations = enumerations
        self.error = error
        self.field_group_label = field_group_label
        self.field_group_variant = field_group_variant
        self.fill_style = fill_style
        self.fiscal_month_offset = fiscal_month_offset
        self.has_allowed_values = has_allowed_values
        self.hidden = hidden
        self.is_filter = is_filter
        self.is_fiscal = is_fiscal
        self.is_numeric = is_numeric
        self.is_timeframe = is_timeframe
        self.can_time_filter = can_time_filter
        self.time_interval = time_interval
        self.label = label
        self.label_from_parameter = label_from_parameter
        self.label_short = label_short
        self.lookml_link = lookml_link
        self.map_layer = map_layer
        self.measure = measure
        self.name = name
        self.strict_value_format = strict_value_format
        self.parameter = parameter
        self.permanent = permanent
        self.primary_key = primary_key
        self.project_name = project_name
        self.requires_refresh_on_sort = requires_refresh_on_sort
        self.scope = scope
        self.sortable = sortable
        self.source_file = source_file
        self.source_file_path = source_file_path
        self.sql = sql
        self.sql_case = sql_case
        self.filters = filters
        self.suggest_dimension = suggest_dimension
        self.suggest_explore = suggest_explore
        self.suggestable = suggestable
        self.suggestions = suggestions
        self.tags = tags
        self.type = type
        self.user_attribute_filter_types = user_attribute_filter_types
        self.value_format = value_format
        self.view = view
        self.view_label = view_label
        self.dynamic = dynamic
        self.week_start_day = week_start_day
        self.times_used = times_used
        self.original_view = original_view


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreFieldEnumeration(model.Model):
    """
    Attributes:
        label: Label
        value: Value
    """

    label: Optional[str] = None
    value: Optional[Any] = None

    def __init__(self, *, label: Optional[str] = None, value: Optional[Any] = None):
        self.label = label
        self.value = value


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreFieldMapLayer(model.Model):
    """
    Attributes:
        url: URL to the map layer resource.
        name: Name of the map layer, as defined in LookML.
        feature_key: Specifies the name of the TopoJSON object that the map layer references. If not specified, use the first object..
        property_key: Selects which property from the TopoJSON data to plot against. TopoJSON supports arbitrary metadata for each region. When null, the first matching property should be used.
        property_label_key: Which property from the TopoJSON data to use to label the region. When null, property_key should be used.
        projection: The preferred geographic projection of the map layer when displayed in a visualization that supports multiple geographic projections.
        format: Specifies the data format of the region information. Valid values are: "topojson", "vector_tile_region".
        extents_json_url: Specifies the URL to a JSON file that defines the geographic extents of each region available in the map layer. This data is used to automatically center the map on the available data for visualization purposes. The JSON file must be a JSON object where the keys are the mapping value of the feature (as specified by property_key) and the values are arrays of four numbers representing the west longitude, south latitude, east longitude, and north latitude extents of the region. The object must include a key for every possible value of property_key.
        max_zoom_level: The minimum zoom level that the map layer may be displayed at, for visualizations that support zooming.
        min_zoom_level: The maximum zoom level that the map layer may be displayed at, for visualizations that support zooming.
    """

    url: Optional[str] = None
    name: Optional[str] = None
    feature_key: Optional[str] = None
    property_key: Optional[str] = None
    property_label_key: Optional[str] = None
    projection: Optional[str] = None
    format: Optional["Format"] = None
    extents_json_url: Optional[str] = None
    max_zoom_level: Optional[int] = None
    min_zoom_level: Optional[int] = None

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        name: Optional[str] = None,
        feature_key: Optional[str] = None,
        property_key: Optional[str] = None,
        property_label_key: Optional[str] = None,
        projection: Optional[str] = None,
        format: Optional["Format"] = None,
        extents_json_url: Optional[str] = None,
        max_zoom_level: Optional[int] = None,
        min_zoom_level: Optional[int] = None
    ):
        self.url = url
        self.name = name
        self.feature_key = feature_key
        self.property_key = property_key
        self.property_label_key = property_label_key
        self.projection = projection
        self.format = format
        self.extents_json_url = extents_json_url
        self.max_zoom_level = max_zoom_level
        self.min_zoom_level = min_zoom_level


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreFieldMeasureFilters(model.Model):
    """
    Attributes:
        field: Filter field name
        condition: Filter condition value
    """

    field: Optional[str] = None
    condition: Optional[str] = None

    def __init__(self, *, field: Optional[str] = None, condition: Optional[str] = None):
        self.field = field
        self.condition = condition


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreFieldset(model.Model):
    """
    Attributes:
        dimensions: Array of dimensions
        measures: Array of measures
        filters: Array of filters
        parameters: Array of parameters
    """

    dimensions: Optional[Sequence["LookmlModelExploreField"]] = None
    measures: Optional[Sequence["LookmlModelExploreField"]] = None
    filters: Optional[Sequence["LookmlModelExploreField"]] = None
    parameters: Optional[Sequence["LookmlModelExploreField"]] = None

    def __init__(
        self,
        *,
        dimensions: Optional[Sequence["LookmlModelExploreField"]] = None,
        measures: Optional[Sequence["LookmlModelExploreField"]] = None,
        filters: Optional[Sequence["LookmlModelExploreField"]] = None,
        parameters: Optional[Sequence["LookmlModelExploreField"]] = None
    ):
        self.dimensions = dimensions
        self.measures = measures
        self.filters = filters
        self.parameters = parameters


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreFieldSqlCase(model.Model):
    """
    Attributes:
        value: SQL Case label value
        condition: SQL Case condition expression
    """

    value: Optional[str] = None
    condition: Optional[str] = None

    def __init__(self, *, value: Optional[str] = None, condition: Optional[str] = None):
        self.value = value
        self.condition = condition


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreFieldTimeInterval(model.Model):
    """
    Attributes:
        name: The type of time interval this field represents a grouping of. Valid values are: "day", "hour", "minute", "second", "millisecond", "microsecond", "week", "month", "quarter", "year".
        count: The number of intervals this field represents a grouping of.
    """

    name: Optional["Name"] = None
    count: Optional[int] = None

    def __init__(self, *, name: Optional["Name"] = None, count: Optional[int] = None):
        self.name = name
        self.count = count


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreJoins(model.Model):
    """
    Attributes:
        name: Name of this join (and name of the view to join)
        dependent_fields: Fields referenced by the join
        fields: Fields of the joined view to pull into this explore
        foreign_key: Name of the dimension in this explore whose value is in the primary key of the joined view
        from_: Name of view to join
        outer_only: Specifies whether all queries must use an outer join
        relationship: many_to_one, one_to_one, one_to_many, many_to_many
        required_joins: Names of joins that must always be included in SQL queries
        sql_foreign_key: SQL expression that produces a foreign key
        sql_on: SQL ON expression describing the join condition
        sql_table_name: SQL table name to join
        type: The join type: left_outer, full_outer, inner, or cross
        view_label: Label to display in UI selectors
    """

    name: Optional[str] = None
    dependent_fields: Optional[Sequence[str]] = None
    fields: Optional[Sequence[str]] = None
    foreign_key: Optional[str] = None
    from_: Optional[str] = None
    outer_only: Optional[bool] = None
    relationship: Optional[str] = None
    required_joins: Optional[Sequence[str]] = None
    sql_foreign_key: Optional[str] = None
    sql_on: Optional[str] = None
    sql_table_name: Optional[str] = None
    type: Optional[str] = None
    view_label: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        dependent_fields: Optional[Sequence[str]] = None,
        fields: Optional[Sequence[str]] = None,
        foreign_key: Optional[str] = None,
        from_: Optional[str] = None,
        outer_only: Optional[bool] = None,
        relationship: Optional[str] = None,
        required_joins: Optional[Sequence[str]] = None,
        sql_foreign_key: Optional[str] = None,
        sql_on: Optional[str] = None,
        sql_table_name: Optional[str] = None,
        type: Optional[str] = None,
        view_label: Optional[str] = None
    ):
        self.name = name
        self.dependent_fields = dependent_fields
        self.fields = fields
        self.foreign_key = foreign_key
        self.from_ = from_
        self.outer_only = outer_only
        self.relationship = relationship
        self.required_joins = required_joins
        self.sql_foreign_key = sql_foreign_key
        self.sql_on = sql_on
        self.sql_table_name = sql_table_name
        self.type = type
        self.view_label = view_label


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreSet(model.Model):
    """
    Attributes:
        name: Name
        value: Value set
    """

    name: Optional[str] = None
    value: Optional[Sequence[str]] = None

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[Sequence[str]] = None
    ):
        self.name = name
        self.value = value


@attr.s(auto_attribs=True, init=False)
class LookmlModelExploreSupportedMeasureType(model.Model):
    """
    Attributes:
        dimension_type:
        measure_types:
    """

    dimension_type: Optional[str] = None
    measure_types: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        dimension_type: Optional[str] = None,
        measure_types: Optional[Sequence[str]] = None
    ):
        self.dimension_type = dimension_type
        self.measure_types = measure_types


@attr.s(auto_attribs=True, init=False)
class LookmlModelNavExplore(model.Model):
    """
    Attributes:
        name: Name of the explore
        description: Description for the explore
        label: Label for the explore
        hidden: Is this explore marked as hidden
        group_label: Label used to group explores in the navigation menus
    """

    name: Optional[str] = None
    description: Optional[str] = None
    label: Optional[str] = None
    hidden: Optional[bool] = None
    group_label: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        label: Optional[str] = None,
        hidden: Optional[bool] = None,
        group_label: Optional[str] = None
    ):
        self.name = name
        self.description = description
        self.label = label
        self.hidden = hidden
        self.group_label = group_label


@attr.s(auto_attribs=True, init=False)
class LookmlTest(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        model_name: Name of model containing this test.
        name: Name of this test.
        explore_name: Name of the explore this test runs a query against
        query_url_params: The url parameters that can be used to reproduce this test's query on an explore.
        file: Name of the LookML file containing this test.
        line: Line number of this test in LookML.
    """

    can: Optional[MutableMapping[str, bool]] = None
    model_name: Optional[str] = None
    name: Optional[str] = None
    explore_name: Optional[str] = None
    query_url_params: Optional[str] = None
    file: Optional[str] = None
    line: Optional[int] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        model_name: Optional[str] = None,
        name: Optional[str] = None,
        explore_name: Optional[str] = None,
        query_url_params: Optional[str] = None,
        file: Optional[str] = None,
        line: Optional[int] = None
    ):
        self.can = can
        self.model_name = model_name
        self.name = name
        self.explore_name = explore_name
        self.query_url_params = query_url_params
        self.file = file
        self.line = line


@attr.s(auto_attribs=True, init=False)
class LookmlTestResult(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        model_name: Name of model containing this test.
        test_name: Name of this test.
        assertions_count: Number of assertions in this test
        assertions_failed: Number of assertions passed in this test
        errors: A list of any errors encountered by the test.
        warnings: A list of any warnings encountered by the test.
        success: True if this test passsed without errors.
    """

    can: Optional[MutableMapping[str, bool]] = None
    model_name: Optional[str] = None
    test_name: Optional[str] = None
    assertions_count: Optional[int] = None
    assertions_failed: Optional[int] = None
    errors: Optional[Sequence["ProjectError"]] = None
    warnings: Optional[Sequence["ProjectError"]] = None
    success: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        model_name: Optional[str] = None,
        test_name: Optional[str] = None,
        assertions_count: Optional[int] = None,
        assertions_failed: Optional[int] = None,
        errors: Optional[Sequence["ProjectError"]] = None,
        warnings: Optional[Sequence["ProjectError"]] = None,
        success: Optional[bool] = None
    ):
        self.can = can
        self.model_name = model_name
        self.test_name = test_name
        self.assertions_count = assertions_count
        self.assertions_failed = assertions_failed
        self.errors = errors
        self.warnings = warnings
        self.success = success


@attr.s(auto_attribs=True, init=False)
class LookModel(model.Model):
    """
    Attributes:
        id: Model Id
        label: Model Label
    """

    id: Optional[str] = None
    label: Optional[str] = None

    def __init__(self, *, id: Optional[str] = None, label: Optional[str] = None):
        self.id = id
        self.label = label


@attr.s(auto_attribs=True, init=False)
class LookWithDashboards(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_metadata_id: Id of content metadata
        id: Unique Id
        title: Look Title
        user_id: User Id
        content_favorite_id: Content Favorite Id
        created_at: Time that the Look was created.
        deleted: Whether or not a look is 'soft' deleted.
        deleted_at: Time that the Look was deleted.
        deleter_id: Id of User that deleted the look.
        description: Description
        embed_url: Embed Url
        excel_file_url: Excel File Url
        favorite_count: Number of times favorited
        google_spreadsheet_formula: Google Spreadsheet Formula
        image_embed_url: Image Embed Url
        is_run_on_load: auto-run query when Look viewed
        last_accessed_at: Time that the Look was last accessed by any user
        last_updater_id: Id of User that last updated the look.
        last_viewed_at: Time last viewed in the Looker web UI
        model:
        public: Is Public
        public_slug: Public Slug
        public_url: Public Url
        query_id: Query Id
        short_url: Short Url
        folder:
        folder_id: Folder Id
        updated_at: Time that the Look was updated.
        view_count: Number of times viewed in the Looker web UI
        dashboards: Dashboards
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_metadata_id: Optional[str] = None
    id: Optional[str] = None
    title: Optional[str] = None
    user_id: Optional[str] = None
    content_favorite_id: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    deleted: Optional[bool] = None
    deleted_at: Optional[datetime.datetime] = None
    deleter_id: Optional[str] = None
    description: Optional[str] = None
    embed_url: Optional[str] = None
    excel_file_url: Optional[str] = None
    favorite_count: Optional[int] = None
    google_spreadsheet_formula: Optional[str] = None
    image_embed_url: Optional[str] = None
    is_run_on_load: Optional[bool] = None
    last_accessed_at: Optional[datetime.datetime] = None
    last_updater_id: Optional[str] = None
    last_viewed_at: Optional[datetime.datetime] = None
    model: Optional["LookModel"] = None
    public: Optional[bool] = None
    public_slug: Optional[str] = None
    public_url: Optional[str] = None
    query_id: Optional[str] = None
    short_url: Optional[str] = None
    folder: Optional["FolderBase"] = None
    folder_id: Optional[str] = None
    updated_at: Optional[datetime.datetime] = None
    view_count: Optional[int] = None
    dashboards: Optional[Sequence["DashboardBase"]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_metadata_id: Optional[str] = None,
        id: Optional[str] = None,
        title: Optional[str] = None,
        user_id: Optional[str] = None,
        content_favorite_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        deleted: Optional[bool] = None,
        deleted_at: Optional[datetime.datetime] = None,
        deleter_id: Optional[str] = None,
        description: Optional[str] = None,
        embed_url: Optional[str] = None,
        excel_file_url: Optional[str] = None,
        favorite_count: Optional[int] = None,
        google_spreadsheet_formula: Optional[str] = None,
        image_embed_url: Optional[str] = None,
        is_run_on_load: Optional[bool] = None,
        last_accessed_at: Optional[datetime.datetime] = None,
        last_updater_id: Optional[str] = None,
        last_viewed_at: Optional[datetime.datetime] = None,
        model: Optional["LookModel"] = None,
        public: Optional[bool] = None,
        public_slug: Optional[str] = None,
        public_url: Optional[str] = None,
        query_id: Optional[str] = None,
        short_url: Optional[str] = None,
        folder: Optional["FolderBase"] = None,
        folder_id: Optional[str] = None,
        updated_at: Optional[datetime.datetime] = None,
        view_count: Optional[int] = None,
        dashboards: Optional[Sequence["DashboardBase"]] = None
    ):
        self.can = can
        self.content_metadata_id = content_metadata_id
        self.id = id
        self.title = title
        self.user_id = user_id
        self.content_favorite_id = content_favorite_id
        self.created_at = created_at
        self.deleted = deleted
        self.deleted_at = deleted_at
        self.deleter_id = deleter_id
        self.description = description
        self.embed_url = embed_url
        self.excel_file_url = excel_file_url
        self.favorite_count = favorite_count
        self.google_spreadsheet_formula = google_spreadsheet_formula
        self.image_embed_url = image_embed_url
        self.is_run_on_load = is_run_on_load
        self.last_accessed_at = last_accessed_at
        self.last_updater_id = last_updater_id
        self.last_viewed_at = last_viewed_at
        self.model = model
        self.public = public
        self.public_slug = public_slug
        self.public_url = public_url
        self.query_id = query_id
        self.short_url = short_url
        self.folder = folder
        self.folder_id = folder_id
        self.updated_at = updated_at
        self.view_count = view_count
        self.dashboards = dashboards


@attr.s(auto_attribs=True, init=False)
class LookWithQuery(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        content_metadata_id: Id of content metadata
        id: Unique Id
        title: Look Title
        user_id: User Id
        content_favorite_id: Content Favorite Id
        created_at: Time that the Look was created.
        deleted: Whether or not a look is 'soft' deleted.
        deleted_at: Time that the Look was deleted.
        deleter_id: Id of User that deleted the look.
        description: Description
        embed_url: Embed Url
        excel_file_url: Excel File Url
        favorite_count: Number of times favorited
        google_spreadsheet_formula: Google Spreadsheet Formula
        image_embed_url: Image Embed Url
        is_run_on_load: auto-run query when Look viewed
        last_accessed_at: Time that the Look was last accessed by any user
        last_updater_id: Id of User that last updated the look.
        last_viewed_at: Time last viewed in the Looker web UI
        model:
        public: Is Public
        public_slug: Public Slug
        public_url: Public Url
        query_id: Query Id
        short_url: Short Url
        folder:
        folder_id: Folder Id
        updated_at: Time that the Look was updated.
        view_count: Number of times viewed in the Looker web UI
        query:
        url: Url
    """

    can: Optional[MutableMapping[str, bool]] = None
    content_metadata_id: Optional[str] = None
    id: Optional[str] = None
    title: Optional[str] = None
    user_id: Optional[str] = None
    content_favorite_id: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    deleted: Optional[bool] = None
    deleted_at: Optional[datetime.datetime] = None
    deleter_id: Optional[str] = None
    description: Optional[str] = None
    embed_url: Optional[str] = None
    excel_file_url: Optional[str] = None
    favorite_count: Optional[int] = None
    google_spreadsheet_formula: Optional[str] = None
    image_embed_url: Optional[str] = None
    is_run_on_load: Optional[bool] = None
    last_accessed_at: Optional[datetime.datetime] = None
    last_updater_id: Optional[str] = None
    last_viewed_at: Optional[datetime.datetime] = None
    model: Optional["LookModel"] = None
    public: Optional[bool] = None
    public_slug: Optional[str] = None
    public_url: Optional[str] = None
    query_id: Optional[str] = None
    short_url: Optional[str] = None
    folder: Optional["FolderBase"] = None
    folder_id: Optional[str] = None
    updated_at: Optional[datetime.datetime] = None
    view_count: Optional[int] = None
    query: Optional["Query"] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        content_metadata_id: Optional[str] = None,
        id: Optional[str] = None,
        title: Optional[str] = None,
        user_id: Optional[str] = None,
        content_favorite_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        deleted: Optional[bool] = None,
        deleted_at: Optional[datetime.datetime] = None,
        deleter_id: Optional[str] = None,
        description: Optional[str] = None,
        embed_url: Optional[str] = None,
        excel_file_url: Optional[str] = None,
        favorite_count: Optional[int] = None,
        google_spreadsheet_formula: Optional[str] = None,
        image_embed_url: Optional[str] = None,
        is_run_on_load: Optional[bool] = None,
        last_accessed_at: Optional[datetime.datetime] = None,
        last_updater_id: Optional[str] = None,
        last_viewed_at: Optional[datetime.datetime] = None,
        model: Optional["LookModel"] = None,
        public: Optional[bool] = None,
        public_slug: Optional[str] = None,
        public_url: Optional[str] = None,
        query_id: Optional[str] = None,
        short_url: Optional[str] = None,
        folder: Optional["FolderBase"] = None,
        folder_id: Optional[str] = None,
        updated_at: Optional[datetime.datetime] = None,
        view_count: Optional[int] = None,
        query: Optional["Query"] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.content_metadata_id = content_metadata_id
        self.id = id
        self.title = title
        self.user_id = user_id
        self.content_favorite_id = content_favorite_id
        self.created_at = created_at
        self.deleted = deleted
        self.deleted_at = deleted_at
        self.deleter_id = deleter_id
        self.description = description
        self.embed_url = embed_url
        self.excel_file_url = excel_file_url
        self.favorite_count = favorite_count
        self.google_spreadsheet_formula = google_spreadsheet_formula
        self.image_embed_url = image_embed_url
        self.is_run_on_load = is_run_on_load
        self.last_accessed_at = last_accessed_at
        self.last_updater_id = last_updater_id
        self.last_viewed_at = last_viewed_at
        self.model = model
        self.public = public
        self.public_slug = public_slug
        self.public_url = public_url
        self.query_id = query_id
        self.short_url = short_url
        self.folder = folder
        self.folder_id = folder_id
        self.updated_at = updated_at
        self.view_count = view_count
        self.query = query
        self.url = url


@attr.s(auto_attribs=True, init=False)
class Manifest(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        name: Manifest project name
        imports: Imports for a project
        localization_settings:
    """

    can: Optional[MutableMapping[str, bool]] = None
    name: Optional[str] = None
    imports: Optional[Sequence["ImportedProject"]] = None
    localization_settings: Optional["LocalizationSettings"] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        name: Optional[str] = None,
        imports: Optional[Sequence["ImportedProject"]] = None,
        localization_settings: Optional["LocalizationSettings"] = None
    ):
        self.can = can
        self.name = name
        self.imports = imports
        self.localization_settings = localization_settings


@attr.s(auto_attribs=True, init=False)
class MaterializePDT(model.Model):
    """
    Attributes:
        materialization_id: The ID of the enqueued materialization task
        resp_text: Detailed response in text format
    """

    materialization_id: Optional[str] = None
    resp_text: Optional[str] = None

    def __init__(
        self,
        *,
        materialization_id: Optional[str] = None,
        resp_text: Optional[str] = None
    ):
        self.materialization_id = materialization_id
        self.resp_text = resp_text


@attr.s(auto_attribs=True, init=False)
class MergeFields(model.Model):
    """
    Attributes:
        field_name: Field name to map onto in the merged results
        source_field_name: Field name from the source query
    """

    field_name: Optional[str] = None
    source_field_name: Optional[str] = None

    def __init__(
        self,
        *,
        field_name: Optional[str] = None,
        source_field_name: Optional[str] = None
    ):
        self.field_name = field_name
        self.source_field_name = source_field_name


@attr.s(auto_attribs=True, init=False)
class MergeQuery(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        column_limit: Column Limit
        dynamic_fields: Dynamic Fields
        id: Unique Id
        pivots: Pivots
        result_maker_id: Unique to get results
        sorts: Sorts
        source_queries: Source Queries defining the results to be merged.
        total: Total
        vis_config: Visualization Config
    """

    can: Optional[MutableMapping[str, bool]] = None
    column_limit: Optional[str] = None
    dynamic_fields: Optional[str] = None
    id: Optional[str] = None
    pivots: Optional[Sequence[str]] = None
    result_maker_id: Optional[str] = None
    sorts: Optional[Sequence[str]] = None
    source_queries: Optional[Sequence["MergeQuerySourceQuery"]] = None
    total: Optional[bool] = None
    vis_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        column_limit: Optional[str] = None,
        dynamic_fields: Optional[str] = None,
        id: Optional[str] = None,
        pivots: Optional[Sequence[str]] = None,
        result_maker_id: Optional[str] = None,
        sorts: Optional[Sequence[str]] = None,
        source_queries: Optional[Sequence["MergeQuerySourceQuery"]] = None,
        total: Optional[bool] = None,
        vis_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.can = can
        self.column_limit = column_limit
        self.dynamic_fields = dynamic_fields
        self.id = id
        self.pivots = pivots
        self.result_maker_id = result_maker_id
        self.sorts = sorts
        self.source_queries = source_queries
        self.total = total
        self.vis_config = vis_config


@attr.s(auto_attribs=True, init=False)
class MergeQuerySourceQuery(model.Model):
    """
    Attributes:
        merge_fields: An array defining which fields of the source query are mapped onto fields of the merge query
        name: Display name
        query_id: Id of the query to merge
    """

    merge_fields: Optional[Sequence["MergeFields"]] = None
    name: Optional[str] = None
    query_id: Optional[str] = None

    def __init__(
        self,
        *,
        merge_fields: Optional[Sequence["MergeFields"]] = None,
        name: Optional[str] = None,
        query_id: Optional[str] = None
    ):
        self.merge_fields = merge_fields
        self.name = name
        self.query_id = query_id


@attr.s(auto_attribs=True, init=False)
class MobileFeatureFlags(model.Model):
    """
    Attributes:
        feature_flag_name: Specifies the name of feature flag.
        feature_flag_state: Specifies the state of feature flag
    """

    feature_flag_name: Optional[str] = None
    feature_flag_state: Optional[bool] = None

    def __init__(
        self,
        *,
        feature_flag_name: Optional[str] = None,
        feature_flag_state: Optional[bool] = None
    ):
        self.feature_flag_name = feature_flag_name
        self.feature_flag_state = feature_flag_state


@attr.s(auto_attribs=True, init=False)
class MobilePayload(model.Model):
    """
    Attributes:
        alert_id: ID of the alert
        title: Title of the alert
        investigative_content_id: ID of the investigative content
        dashboard_name: Name of the dashboard on which the alert has been set
        dashboard_id: ID of the dashboard on which the alert has been set
        query_slug: Slug of the query which runs the alert queries.
    """

    alert_id: str
    title: Optional[str] = None
    investigative_content_id: Optional[str] = None
    dashboard_name: Optional[str] = None
    dashboard_id: Optional[str] = None
    query_slug: Optional[str] = None

    def __init__(
        self,
        *,
        alert_id: str,
        title: Optional[str] = None,
        investigative_content_id: Optional[str] = None,
        dashboard_name: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        query_slug: Optional[str] = None
    ):
        self.alert_id = alert_id
        self.title = title
        self.investigative_content_id = investigative_content_id
        self.dashboard_name = dashboard_name
        self.dashboard_id = dashboard_id
        self.query_slug = query_slug


@attr.s(auto_attribs=True, init=False)
class MobileSettings(model.Model):
    """
    Attributes:
        mobile_force_authentication: Specifies whether the force authentication option is enabled for mobile
        mobile_app_integration: Specifies whether mobile access for this instance is enabled.
        mobile_feature_flags: Specifies feature flag and state relevant to mobile.
    """

    mobile_force_authentication: Optional[bool] = None
    mobile_app_integration: Optional[bool] = None
    mobile_feature_flags: Optional[Sequence["MobileFeatureFlags"]] = None

    def __init__(
        self,
        *,
        mobile_force_authentication: Optional[bool] = None,
        mobile_app_integration: Optional[bool] = None,
        mobile_feature_flags: Optional[Sequence["MobileFeatureFlags"]] = None
    ):
        self.mobile_force_authentication = mobile_force_authentication
        self.mobile_app_integration = mobile_app_integration
        self.mobile_feature_flags = mobile_feature_flags


@attr.s(auto_attribs=True, init=False)
class MobileToken(model.Model):
    """
    Attributes:
        device_token: Specifies the device token
        device_type: Specifies type of device. Valid values are: "android", "ios".
        id: Unique ID.
    """

    device_token: str
    device_type: "DeviceType"
    id: Optional[str] = None
    __annotations__ = {
        "device_token": str,
        "device_type": ForwardRef("DeviceType"),
        "id": Optional[str],
    }

    def __init__(
        self, *, device_token: str, device_type: "DeviceType", id: Optional[str] = None
    ):
        self.device_token = device_token
        self.device_type = device_type
        self.id = id


@attr.s(auto_attribs=True, init=False)
class Model(model.Model):
    """
    Attributes:
        connection:
        name:
        value_formats: Array of named value formats
    """

    connection: Optional[str] = None
    name: Optional[str] = None
    value_formats: Optional[Sequence["ModelNamedValueFormats"]] = None

    def __init__(
        self,
        *,
        connection: Optional[str] = None,
        name: Optional[str] = None,
        value_formats: Optional[Sequence["ModelNamedValueFormats"]] = None
    ):
        self.connection = connection
        self.name = name
        self.value_formats = value_formats


@attr.s(auto_attribs=True, init=False)
class ModelFieldSuggestions(model.Model):
    """
    Attributes:
        suggestions: List of suggestions
        error: Error message
        from_cache: True if result came from the cache
        hit_limit: True if this was a hit limit
        used_calcite_materialization: True if calcite was used
    """

    suggestions: Optional[Sequence[str]] = None
    error: Optional[str] = None
    from_cache: Optional[bool] = None
    hit_limit: Optional[bool] = None
    used_calcite_materialization: Optional[bool] = None

    def __init__(
        self,
        *,
        suggestions: Optional[Sequence[str]] = None,
        error: Optional[str] = None,
        from_cache: Optional[bool] = None,
        hit_limit: Optional[bool] = None,
        used_calcite_materialization: Optional[bool] = None
    ):
        self.suggestions = suggestions
        self.error = error
        self.from_cache = from_cache
        self.hit_limit = hit_limit
        self.used_calcite_materialization = used_calcite_materialization


@attr.s(auto_attribs=True, init=False)
class ModelNamedValueFormats(model.Model):
    """
    Attributes:
        format_string:
        label:
        name:
        strict_value_format:
    """

    format_string: Optional[str] = None
    label: Optional[str] = None
    name: Optional[str] = None
    strict_value_format: Optional[bool] = None

    def __init__(
        self,
        *,
        format_string: Optional[str] = None,
        label: Optional[str] = None,
        name: Optional[str] = None,
        strict_value_format: Optional[bool] = None
    ):
        self.format_string = format_string
        self.label = label
        self.name = name
        self.strict_value_format = strict_value_format


@attr.s(auto_attribs=True, init=False)
class ModelSet(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        all_access:
        built_in:
        id: Unique Id
        models:
        name: Name of ModelSet
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    all_access: Optional[bool] = None
    built_in: Optional[bool] = None
    id: Optional[str] = None
    models: Optional[Sequence[str]] = None
    name: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        all_access: Optional[bool] = None,
        built_in: Optional[bool] = None,
        id: Optional[str] = None,
        models: Optional[Sequence[str]] = None,
        name: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.all_access = all_access
        self.built_in = built_in
        self.id = id
        self.models = models
        self.name = name
        self.url = url


@attr.s(auto_attribs=True, init=False)
class ModelsNotValidated(model.Model):
    """
    Attributes:
        name: Model name
        project_file_id: Project file
    """

    name: Optional[str] = None
    project_file_id: Optional[str] = None

    def __init__(
        self, *, name: Optional[str] = None, project_file_id: Optional[str] = None
    ):
        self.name = name
        self.project_file_id = project_file_id


class Name(enum.Enum):
    """
    The type of time interval this field represents a grouping of. Valid values are: "day", "hour", "minute", "second", "millisecond", "microsecond", "week", "month", "quarter", "year". (Enum defined in LookmlModelExploreFieldTimeInterval)

    """

    day = "day"
    hour = "hour"
    minute = "minute"
    second = "second"
    millisecond = "millisecond"
    microsecond = "microsecond"
    week = "week"
    month = "month"
    quarter = "quarter"
    year = "year"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
Name.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class OauthClientApp(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        client_guid: The globally unique id of this application
        redirect_uri: The uri with which this application will receive an auth code by browser redirect.
        display_name: The application's display name
        description: A description of the application that will be displayed to users
        enabled: When enabled is true, OAuth2 and API requests will be accepted from this app. When false, all requests from this app will be refused. Setting disabled invalidates existing tokens.
        group_id: If set, only Looker users who are members of this group can use this web app with Looker. If group_id is not set, any Looker user may use this app to access this Looker instance
        tokens_invalid_before: All auth codes, access tokens, and refresh tokens issued for this application prior to this date-time for ALL USERS will be invalid.
        activated_users: All users who have been activated to use this app
    """

    can: Optional[MutableMapping[str, bool]] = None
    client_guid: Optional[str] = None
    redirect_uri: Optional[str] = None
    display_name: Optional[str] = None
    description: Optional[str] = None
    enabled: Optional[bool] = None
    group_id: Optional[str] = None
    tokens_invalid_before: Optional[datetime.datetime] = None
    activated_users: Optional[Sequence["UserPublic"]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        client_guid: Optional[str] = None,
        redirect_uri: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        enabled: Optional[bool] = None,
        group_id: Optional[str] = None,
        tokens_invalid_before: Optional[datetime.datetime] = None,
        activated_users: Optional[Sequence["UserPublic"]] = None
    ):
        self.can = can
        self.client_guid = client_guid
        self.redirect_uri = redirect_uri
        self.display_name = display_name
        self.description = description
        self.enabled = enabled
        self.group_id = group_id
        self.tokens_invalid_before = tokens_invalid_before
        self.activated_users = activated_users


@attr.s(auto_attribs=True, init=False)
class OIDCConfig(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        alternate_email_login_allowed: Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.
        audience: OpenID Provider Audience
        auth_requires_role: Users will not be allowed to login at all unless a role for them is found in OIDC if set to true
        authorization_endpoint: OpenID Provider Authorization Url
        default_new_user_group_ids: (Write-Only) Array of ids of groups that will be applied to new users the first time they login via OIDC
        default_new_user_groups: (Read-only) Groups that will be applied to new users the first time they login via OIDC
        default_new_user_role_ids: (Write-Only) Array of ids of roles that will be applied to new users the first time they login via OIDC
        default_new_user_roles: (Read-only) Roles that will be applied to new users the first time they login via OIDC
        enabled: Enable/Disable OIDC authentication for the server
        groups: (Read-only) Array of mappings between OIDC Groups and Looker Roles
        groups_attribute: Name of user record attributes used to indicate groups. Used when 'groups_finder_type' is set to 'grouped_attribute_values'
        groups_with_role_ids: (Read/Write) Array of mappings between OIDC Groups and arrays of Looker Role ids
        identifier: Relying Party Identifier (provided by OpenID Provider)
        issuer: OpenID Provider Issuer
        modified_at: When this config was last modified
        modified_by: User id of user who last modified this config
        new_user_migration_types: Merge first-time oidc login to existing user account by email addresses. When a user logs in for the first time via oidc this option will connect this user into their existing account by finding the account with a matching email address by testing the given types of credentials for existing users. Otherwise a new user account will be created for the user. This list (if provided) must be a comma separated list of string like 'email,ldap,google'
        scopes: Array of scopes to request.
        secret: (Write-Only) Relying Party Secret (provided by OpenID Provider)
        set_roles_from_groups: Set user roles in Looker based on groups from OIDC
        test_slug: Slug to identify configurations that are created in order to run a OIDC config test
        token_endpoint: OpenID Provider Token Url
        user_attribute_map_email: Name of user record attributes used to indicate email address field
        user_attribute_map_first_name: Name of user record attributes used to indicate first name
        user_attribute_map_last_name: Name of user record attributes used to indicate last name
        user_attributes: (Read-only) Array of mappings between OIDC User Attributes and Looker User Attributes
        user_attributes_with_ids: (Read/Write) Array of mappings between OIDC User Attributes and arrays of Looker User Attribute ids
        userinfo_endpoint: OpenID Provider User Information Url
        allow_normal_group_membership: Allow OIDC auth'd users to be members of non-reflected Looker groups. If 'false', user will be removed from non-reflected groups on login.
        allow_roles_from_normal_groups: OIDC auth'd users will inherit roles from non-reflected Looker groups.
        allow_direct_roles: Allows roles to be directly assigned to OIDC auth'd users.
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    alternate_email_login_allowed: Optional[bool] = None
    audience: Optional[str] = None
    auth_requires_role: Optional[bool] = None
    authorization_endpoint: Optional[str] = None
    default_new_user_group_ids: Optional[Sequence[str]] = None
    default_new_user_groups: Optional[Sequence["Group"]] = None
    default_new_user_role_ids: Optional[Sequence[str]] = None
    default_new_user_roles: Optional[Sequence["Role"]] = None
    enabled: Optional[bool] = None
    groups: Optional[Sequence["OIDCGroupRead"]] = None
    groups_attribute: Optional[str] = None
    groups_with_role_ids: Optional[Sequence["OIDCGroupWrite"]] = None
    identifier: Optional[str] = None
    issuer: Optional[str] = None
    modified_at: Optional[datetime.datetime] = None
    modified_by: Optional[str] = None
    new_user_migration_types: Optional[str] = None
    scopes: Optional[Sequence[str]] = None
    secret: Optional[str] = None
    set_roles_from_groups: Optional[bool] = None
    test_slug: Optional[str] = None
    token_endpoint: Optional[str] = None
    user_attribute_map_email: Optional[str] = None
    user_attribute_map_first_name: Optional[str] = None
    user_attribute_map_last_name: Optional[str] = None
    user_attributes: Optional[Sequence["OIDCUserAttributeRead"]] = None
    user_attributes_with_ids: Optional[Sequence["OIDCUserAttributeWrite"]] = None
    userinfo_endpoint: Optional[str] = None
    allow_normal_group_membership: Optional[bool] = None
    allow_roles_from_normal_groups: Optional[bool] = None
    allow_direct_roles: Optional[bool] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        alternate_email_login_allowed: Optional[bool] = None,
        audience: Optional[str] = None,
        auth_requires_role: Optional[bool] = None,
        authorization_endpoint: Optional[str] = None,
        default_new_user_group_ids: Optional[Sequence[str]] = None,
        default_new_user_groups: Optional[Sequence["Group"]] = None,
        default_new_user_role_ids: Optional[Sequence[str]] = None,
        default_new_user_roles: Optional[Sequence["Role"]] = None,
        enabled: Optional[bool] = None,
        groups: Optional[Sequence["OIDCGroupRead"]] = None,
        groups_attribute: Optional[str] = None,
        groups_with_role_ids: Optional[Sequence["OIDCGroupWrite"]] = None,
        identifier: Optional[str] = None,
        issuer: Optional[str] = None,
        modified_at: Optional[datetime.datetime] = None,
        modified_by: Optional[str] = None,
        new_user_migration_types: Optional[str] = None,
        scopes: Optional[Sequence[str]] = None,
        secret: Optional[str] = None,
        set_roles_from_groups: Optional[bool] = None,
        test_slug: Optional[str] = None,
        token_endpoint: Optional[str] = None,
        user_attribute_map_email: Optional[str] = None,
        user_attribute_map_first_name: Optional[str] = None,
        user_attribute_map_last_name: Optional[str] = None,
        user_attributes: Optional[Sequence["OIDCUserAttributeRead"]] = None,
        user_attributes_with_ids: Optional[Sequence["OIDCUserAttributeWrite"]] = None,
        userinfo_endpoint: Optional[str] = None,
        allow_normal_group_membership: Optional[bool] = None,
        allow_roles_from_normal_groups: Optional[bool] = None,
        allow_direct_roles: Optional[bool] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.alternate_email_login_allowed = alternate_email_login_allowed
        self.audience = audience
        self.auth_requires_role = auth_requires_role
        self.authorization_endpoint = authorization_endpoint
        self.default_new_user_group_ids = default_new_user_group_ids
        self.default_new_user_groups = default_new_user_groups
        self.default_new_user_role_ids = default_new_user_role_ids
        self.default_new_user_roles = default_new_user_roles
        self.enabled = enabled
        self.groups = groups
        self.groups_attribute = groups_attribute
        self.groups_with_role_ids = groups_with_role_ids
        self.identifier = identifier
        self.issuer = issuer
        self.modified_at = modified_at
        self.modified_by = modified_by
        self.new_user_migration_types = new_user_migration_types
        self.scopes = scopes
        self.secret = secret
        self.set_roles_from_groups = set_roles_from_groups
        self.test_slug = test_slug
        self.token_endpoint = token_endpoint
        self.user_attribute_map_email = user_attribute_map_email
        self.user_attribute_map_first_name = user_attribute_map_first_name
        self.user_attribute_map_last_name = user_attribute_map_last_name
        self.user_attributes = user_attributes
        self.user_attributes_with_ids = user_attributes_with_ids
        self.userinfo_endpoint = userinfo_endpoint
        self.allow_normal_group_membership = allow_normal_group_membership
        self.allow_roles_from_normal_groups = allow_roles_from_normal_groups
        self.allow_direct_roles = allow_direct_roles
        self.url = url


@attr.s(auto_attribs=True, init=False)
class OIDCGroupRead(model.Model):
    """
    Attributes:
        id: Unique Id
        looker_group_id: Unique Id of group in Looker
        looker_group_name: Name of group in Looker
        name: Name of group in OIDC
        roles: Looker Roles
    """

    id: Optional[str] = None
    looker_group_id: Optional[str] = None
    looker_group_name: Optional[str] = None
    name: Optional[str] = None
    roles: Optional[Sequence["Role"]] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        looker_group_id: Optional[str] = None,
        looker_group_name: Optional[str] = None,
        name: Optional[str] = None,
        roles: Optional[Sequence["Role"]] = None
    ):
        self.id = id
        self.looker_group_id = looker_group_id
        self.looker_group_name = looker_group_name
        self.name = name
        self.roles = roles


@attr.s(auto_attribs=True, init=False)
class OIDCGroupWrite(model.Model):
    """
    Attributes:
        id: Unique Id
        looker_group_id: Unique Id of group in Looker
        looker_group_name: Name of group in Looker
        name: Name of group in OIDC
        role_ids: Looker Role Ids
    """

    id: Optional[str] = None
    looker_group_id: Optional[str] = None
    looker_group_name: Optional[str] = None
    name: Optional[str] = None
    role_ids: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        looker_group_id: Optional[str] = None,
        looker_group_name: Optional[str] = None,
        name: Optional[str] = None,
        role_ids: Optional[Sequence[str]] = None
    ):
        self.id = id
        self.looker_group_id = looker_group_id
        self.looker_group_name = looker_group_name
        self.name = name
        self.role_ids = role_ids


@attr.s(auto_attribs=True, init=False)
class OIDCUserAttributeRead(model.Model):
    """
    Attributes:
        name: Name of User Attribute in OIDC
        required: Required to be in OIDC assertion for login to be allowed to succeed
        user_attributes: Looker User Attributes
    """

    name: Optional[str] = None
    required: Optional[bool] = None
    user_attributes: Optional[Sequence["UserAttribute"]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        required: Optional[bool] = None,
        user_attributes: Optional[Sequence["UserAttribute"]] = None
    ):
        self.name = name
        self.required = required
        self.user_attributes = user_attributes


@attr.s(auto_attribs=True, init=False)
class OIDCUserAttributeWrite(model.Model):
    """
    Attributes:
        name: Name of User Attribute in OIDC
        required: Required to be in OIDC assertion for login to be allowed to succeed
        user_attribute_ids: Looker User Attribute Ids
    """

    name: Optional[str] = None
    required: Optional[bool] = None
    user_attribute_ids: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        required: Optional[bool] = None,
        user_attribute_ids: Optional[Sequence[str]] = None
    ):
        self.name = name
        self.required = required
        self.user_attribute_ids = user_attribute_ids


@attr.s(auto_attribs=True, init=False)
class PasswordConfig(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        min_length: Minimum number of characters required for a new password.  Must be between 7 and 100
        require_numeric: Require at least one numeric character
        require_upperlower: Require at least one uppercase and one lowercase letter
        require_special: Require at least one special character
    """

    can: Optional[MutableMapping[str, bool]] = None
    min_length: Optional[int] = None
    require_numeric: Optional[bool] = None
    require_upperlower: Optional[bool] = None
    require_special: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        min_length: Optional[int] = None,
        require_numeric: Optional[bool] = None,
        require_upperlower: Optional[bool] = None,
        require_special: Optional[bool] = None
    ):
        self.can = can
        self.min_length = min_length
        self.require_numeric = require_numeric
        self.require_upperlower = require_upperlower
        self.require_special = require_special


@attr.s(auto_attribs=True, init=False)
class Permission(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        permission: Permission symbol
        parent: Dependency parent symbol
        description: Description
    """

    can: Optional[MutableMapping[str, bool]] = None
    permission: Optional[str] = None
    parent: Optional[str] = None
    description: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        permission: Optional[str] = None,
        parent: Optional[str] = None,
        description: Optional[str] = None
    ):
        self.can = can
        self.permission = permission
        self.parent = parent
        self.description = description


@attr.s(auto_attribs=True, init=False)
class PermissionSet(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        all_access:
        built_in:
        id: Unique Id
        name: Name of PermissionSet
        permissions:
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    all_access: Optional[bool] = None
    built_in: Optional[bool] = None
    id: Optional[str] = None
    name: Optional[str] = None
    permissions: Optional[Sequence[str]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        all_access: Optional[bool] = None,
        built_in: Optional[bool] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        permissions: Optional[Sequence[str]] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.all_access = all_access
        self.built_in = built_in
        self.id = id
        self.name = name
        self.permissions = permissions
        self.url = url


class PermissionType(enum.Enum):
    """
    Type of permission: "view" or "edit" Valid values are: "view", "edit". (Enum defined in ContentMetaGroupUser)

    """

    view = "view"
    edit = "edit"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
PermissionType.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class PrivatelabelConfiguration(model.Model):
    """
    Attributes:
        logo_file: Customer logo image. Expected base64 encoded data (write-only)
        logo_url: Logo image url (read-only)
        favicon_file: Custom favicon image. Expected base64 encoded data (write-only)
        favicon_url: Favicon image url (read-only)
        default_title: Default page title
        show_help_menu: Boolean to toggle showing help menus
        show_docs: Boolean to toggle showing docs
        show_email_sub_options: Boolean to toggle showing email subscription options.
        allow_looker_mentions: Boolean to toggle mentions of Looker in emails
        allow_looker_links: Boolean to toggle links to Looker in emails
        custom_welcome_email_advanced: Allow subject line and email heading customization in customized emails”
        setup_mentions: Remove the word Looker from appearing in the account setup page
        alerts_logo: Remove Looker logo from Alerts
        alerts_links: Remove Looker links from Alerts
        folders_mentions: Remove Looker mentions in home folder page when you don’t have any items saved
    """

    logo_file: Optional[str] = None
    logo_url: Optional[str] = None
    favicon_file: Optional[str] = None
    favicon_url: Optional[str] = None
    default_title: Optional[str] = None
    show_help_menu: Optional[bool] = None
    show_docs: Optional[bool] = None
    show_email_sub_options: Optional[bool] = None
    allow_looker_mentions: Optional[bool] = None
    allow_looker_links: Optional[bool] = None
    custom_welcome_email_advanced: Optional[bool] = None
    setup_mentions: Optional[bool] = None
    alerts_logo: Optional[bool] = None
    alerts_links: Optional[bool] = None
    folders_mentions: Optional[bool] = None

    def __init__(
        self,
        *,
        logo_file: Optional[str] = None,
        logo_url: Optional[str] = None,
        favicon_file: Optional[str] = None,
        favicon_url: Optional[str] = None,
        default_title: Optional[str] = None,
        show_help_menu: Optional[bool] = None,
        show_docs: Optional[bool] = None,
        show_email_sub_options: Optional[bool] = None,
        allow_looker_mentions: Optional[bool] = None,
        allow_looker_links: Optional[bool] = None,
        custom_welcome_email_advanced: Optional[bool] = None,
        setup_mentions: Optional[bool] = None,
        alerts_logo: Optional[bool] = None,
        alerts_links: Optional[bool] = None,
        folders_mentions: Optional[bool] = None
    ):
        self.logo_file = logo_file
        self.logo_url = logo_url
        self.favicon_file = favicon_file
        self.favicon_url = favicon_url
        self.default_title = default_title
        self.show_help_menu = show_help_menu
        self.show_docs = show_docs
        self.show_email_sub_options = show_email_sub_options
        self.allow_looker_mentions = allow_looker_mentions
        self.allow_looker_links = allow_looker_links
        self.custom_welcome_email_advanced = custom_welcome_email_advanced
        self.setup_mentions = setup_mentions
        self.alerts_logo = alerts_logo
        self.alerts_links = alerts_links
        self.folders_mentions = folders_mentions


@attr.s(auto_attribs=True, init=False)
class Project(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Project Id
        name: Project display name
        uses_git: If true the project is configured with a git repository
        git_remote_url: Git remote repository url
        git_username: Git username for HTTPS authentication. (For production only, if using user attributes.)
        git_password: (Write-Only) Git password for HTTPS authentication. (For production only, if using user attributes.)
        git_production_branch_name: Git production branch name. Defaults to master. Supported only in Looker 21.0 and higher.
        use_git_cookie_auth: If true, the project uses a git cookie for authentication.
        git_username_user_attribute: User attribute name for username in per-user HTTPS authentication.
        git_password_user_attribute: User attribute name for password in per-user HTTPS authentication.
        git_service_name: Name of the git service provider
        git_application_server_http_port: Port that HTTP(S) application server is running on (for PRs, file browsing, etc.)
        git_application_server_http_scheme: Scheme that is running on application server (for PRs, file browsing, etc.)
        deploy_secret: (Write-Only) Optional secret token with which to authenticate requests to the webhook deploy endpoint. If not set, endpoint is unauthenticated.
        unset_deploy_secret: (Write-Only) When true, unsets the deploy secret to allow unauthenticated access to the webhook deploy endpoint.
        pull_request_mode: The git pull request policy for this project. Valid values are: "off", "links", "recommended", "required".
        validation_required: Validation policy: If true, the project must pass validation checks before project changes can be committed to the git repository
        git_release_mgmt_enabled: If true, advanced git release management is enabled for this project
        allow_warnings: Validation policy: If true, the project can be committed with warnings when `validation_required` is true. (`allow_warnings` does nothing if `validation_required` is false).
        is_example: If true the project is an example project and cannot be modified
        dependency_status: Status of dependencies in your manifest & lockfile
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    name: Optional[str] = None
    uses_git: Optional[bool] = None
    git_remote_url: Optional[str] = None
    git_username: Optional[str] = None
    git_password: Optional[str] = None
    git_production_branch_name: Optional[str] = None
    use_git_cookie_auth: Optional[bool] = None
    git_username_user_attribute: Optional[str] = None
    git_password_user_attribute: Optional[str] = None
    git_service_name: Optional[str] = None
    git_application_server_http_port: Optional[int] = None
    git_application_server_http_scheme: Optional[str] = None
    deploy_secret: Optional[str] = None
    unset_deploy_secret: Optional[bool] = None
    pull_request_mode: Optional["PullRequestMode"] = None
    validation_required: Optional[bool] = None
    git_release_mgmt_enabled: Optional[bool] = None
    allow_warnings: Optional[bool] = None
    is_example: Optional[bool] = None
    dependency_status: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        uses_git: Optional[bool] = None,
        git_remote_url: Optional[str] = None,
        git_username: Optional[str] = None,
        git_password: Optional[str] = None,
        git_production_branch_name: Optional[str] = None,
        use_git_cookie_auth: Optional[bool] = None,
        git_username_user_attribute: Optional[str] = None,
        git_password_user_attribute: Optional[str] = None,
        git_service_name: Optional[str] = None,
        git_application_server_http_port: Optional[int] = None,
        git_application_server_http_scheme: Optional[str] = None,
        deploy_secret: Optional[str] = None,
        unset_deploy_secret: Optional[bool] = None,
        pull_request_mode: Optional["PullRequestMode"] = None,
        validation_required: Optional[bool] = None,
        git_release_mgmt_enabled: Optional[bool] = None,
        allow_warnings: Optional[bool] = None,
        is_example: Optional[bool] = None,
        dependency_status: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.name = name
        self.uses_git = uses_git
        self.git_remote_url = git_remote_url
        self.git_username = git_username
        self.git_password = git_password
        self.git_production_branch_name = git_production_branch_name
        self.use_git_cookie_auth = use_git_cookie_auth
        self.git_username_user_attribute = git_username_user_attribute
        self.git_password_user_attribute = git_password_user_attribute
        self.git_service_name = git_service_name
        self.git_application_server_http_port = git_application_server_http_port
        self.git_application_server_http_scheme = git_application_server_http_scheme
        self.deploy_secret = deploy_secret
        self.unset_deploy_secret = unset_deploy_secret
        self.pull_request_mode = pull_request_mode
        self.validation_required = validation_required
        self.git_release_mgmt_enabled = git_release_mgmt_enabled
        self.allow_warnings = allow_warnings
        self.is_example = is_example
        self.dependency_status = dependency_status


@attr.s(auto_attribs=True, init=False)
class ProjectError(model.Model):
    """
    Attributes:
        code: A stable token that uniquely identifies this class of error, ignoring parameter values. Error message text may vary due to parameters or localization, but error codes do not. For example, a "File not found" error will have the same error code regardless of the filename in question or the user's display language
        severity: Severity: fatal, error, warning, info, success
        kind: Error classification: syntax, deprecation, model_configuration, etc
        message: Error message which may contain information such as dashboard or model names that may be considered sensitive in some use cases. Avoid storing or sending this message outside of Looker
        field_name: The field associated with this error
        file_path: Name of the file containing this error
        line_number: Line number in the file of this error
        model_id: The model associated with this error
        explore: The explore associated with this error
        help_url: A link to Looker documentation about this error
        params: Error parameters
        sanitized_message: A version of the error message that does not contain potentially sensitive information. Suitable for situations in which messages are stored or sent to consumers outside of Looker, such as external logs. Sanitized messages will display "(?)" where sensitive information would appear in the corresponding non-sanitized message
    """

    code: Optional[str] = None
    severity: Optional[str] = None
    kind: Optional[str] = None
    message: Optional[str] = None
    field_name: Optional[str] = None
    file_path: Optional[str] = None
    line_number: Optional[int] = None
    model_id: Optional[str] = None
    explore: Optional[str] = None
    help_url: Optional[str] = None
    params: Optional[MutableMapping[str, Any]] = None
    sanitized_message: Optional[str] = None

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        severity: Optional[str] = None,
        kind: Optional[str] = None,
        message: Optional[str] = None,
        field_name: Optional[str] = None,
        file_path: Optional[str] = None,
        line_number: Optional[int] = None,
        model_id: Optional[str] = None,
        explore: Optional[str] = None,
        help_url: Optional[str] = None,
        params: Optional[MutableMapping[str, Any]] = None,
        sanitized_message: Optional[str] = None
    ):
        self.code = code
        self.severity = severity
        self.kind = kind
        self.message = message
        self.field_name = field_name
        self.file_path = file_path
        self.line_number = line_number
        self.model_id = model_id
        self.explore = explore
        self.help_url = help_url
        self.params = params
        self.sanitized_message = sanitized_message


@attr.s(auto_attribs=True, init=False)
class ProjectFile(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: An opaque token uniquely identifying a file within a project. Avoid parsing or decomposing the text of this token. This token is stable within a Looker release but may change between Looker releases
        path: Path, file name, and extension of the file relative to the project root directory
        title: Display name
        type: File type: model, view, etc
        extension: The extension of the file: .view.lkml, .model.lkml, etc
        mime_type: File mime type
        editable: State of editability for the file.
        git_status:
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    path: Optional[str] = None
    title: Optional[str] = None
    type: Optional[str] = None
    extension: Optional[str] = None
    mime_type: Optional[str] = None
    editable: Optional[bool] = None
    git_status: Optional["GitStatus"] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        path: Optional[str] = None,
        title: Optional[str] = None,
        type: Optional[str] = None,
        extension: Optional[str] = None,
        mime_type: Optional[str] = None,
        editable: Optional[bool] = None,
        git_status: Optional["GitStatus"] = None
    ):
        self.can = can
        self.id = id
        self.path = path
        self.title = title
        self.type = type
        self.extension = extension
        self.mime_type = mime_type
        self.editable = editable
        self.git_status = git_status


@attr.s(auto_attribs=True, init=False)
class ProjectValidation(model.Model):
    """
    Attributes:
        errors: A list of project errors
        project_digest: A hash value computed from the project's current state
        models_not_validated: A list of models which were not fully validated
        computation_time: Duration of project validation in seconds
    """

    errors: Optional[Sequence["ProjectError"]] = None
    project_digest: Optional[str] = None
    models_not_validated: Optional[Sequence["ModelsNotValidated"]] = None
    computation_time: Optional[float] = None

    def __init__(
        self,
        *,
        errors: Optional[Sequence["ProjectError"]] = None,
        project_digest: Optional[str] = None,
        models_not_validated: Optional[Sequence["ModelsNotValidated"]] = None,
        computation_time: Optional[float] = None
    ):
        self.errors = errors
        self.project_digest = project_digest
        self.models_not_validated = models_not_validated
        self.computation_time = computation_time


@attr.s(auto_attribs=True, init=False)
class ProjectValidationCache(model.Model):
    """
    Attributes:
        errors: A list of project errors
        project_digest: A hash value computed from the project's current state
        models_not_validated: A list of models which were not fully validated
        computation_time: Duration of project validation in seconds
        stale: If true, the cached project validation results are no longer accurate because the project has changed since the cached results were calculated
    """

    errors: Optional[Sequence["ProjectError"]] = None
    project_digest: Optional[str] = None
    models_not_validated: Optional[Sequence["ModelsNotValidated"]] = None
    computation_time: Optional[float] = None
    stale: Optional[bool] = None

    def __init__(
        self,
        *,
        errors: Optional[Sequence["ProjectError"]] = None,
        project_digest: Optional[str] = None,
        models_not_validated: Optional[Sequence["ModelsNotValidated"]] = None,
        computation_time: Optional[float] = None,
        stale: Optional[bool] = None
    ):
        self.errors = errors
        self.project_digest = project_digest
        self.models_not_validated = models_not_validated
        self.computation_time = computation_time
        self.stale = stale


@attr.s(auto_attribs=True, init=False)
class ProjectWorkspace(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        project_id: The id of the project
        workspace_id: The id of the local workspace containing the project files
        git_status: The status of the local git directory
        git_head: Git head revision name
        dependency_status: Status of the dependencies in your project. Valid values are: "lock_optional", "lock_required", "lock_error", "install_none".
        git_branch:
        lookml_type: The lookml syntax used by all files in this project
    """

    can: Optional[MutableMapping[str, bool]] = None
    project_id: Optional[str] = None
    workspace_id: Optional[str] = None
    git_status: Optional[str] = None
    git_head: Optional[str] = None
    dependency_status: Optional["DependencyStatus"] = None
    git_branch: Optional["GitBranch"] = None
    lookml_type: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        project_id: Optional[str] = None,
        workspace_id: Optional[str] = None,
        git_status: Optional[str] = None,
        git_head: Optional[str] = None,
        dependency_status: Optional["DependencyStatus"] = None,
        git_branch: Optional["GitBranch"] = None,
        lookml_type: Optional[str] = None
    ):
        self.can = can
        self.project_id = project_id
        self.workspace_id = workspace_id
        self.git_status = git_status
        self.git_head = git_head
        self.dependency_status = dependency_status
        self.git_branch = git_branch
        self.lookml_type = lookml_type


class PullRequestMode(enum.Enum):
    """
    The git pull request policy for this project. Valid values are: "off", "links", "recommended", "required". (Enum defined in Project)

    """

    off = "off"
    links = "links"
    recommended = "recommended"
    required = "required"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
PullRequestMode.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class Query(model.Model):
    """
    Attributes:
        model: Model
        view: Explore Name
        can: Operations the current user is able to perform on this object
        id: Unique Id
        fields: Fields
        pivots: Pivots
        fill_fields: Fill Fields
        filters: Filters
        filter_expression: Filter Expression
        sorts: Sorting for the query results. Use the format `["view.field", ...]` to sort on fields in ascending order. Use the format `["view.field desc", ...]` to sort on fields in descending order. Use `["__UNSORTED__"]` (2 underscores before and after) to disable sorting entirely. Empty sorts `[]` will trigger a default sort.
        limit: Limit
        column_limit: Column Limit
        total: Total
        row_total: Raw Total
        subtotals: Fields on which to run subtotals
        vis_config: Visualization configuration properties. These properties are typically opaque and differ based on the type of visualization used. There is no specified set of allowed keys. The values can be any type supported by JSON. A "type" key with a string value is often present, and is used by Looker to determine which visualization to present. Visualizations ignore unknown vis_config properties.
        filter_config: The filter_config represents the state of the filter UI on the explore page for a given query. When running a query via the Looker UI, this parameter takes precedence over "filters". When creating a query or modifying an existing query, "filter_config" should be set to null. Setting it to any other value could cause unexpected filtering behavior. The format should be considered opaque.
        visible_ui_sections: Visible UI Sections
        slug: Slug
        dynamic_fields: Dynamic Fields
        client_id: Client Id: used to generate shortened explore URLs. If set by client, must be a unique 22 character alphanumeric string. Otherwise one will be generated.
        share_url: Share Url
        expanded_share_url: Expanded Share Url
        url: Expanded Url
        query_timezone: Query Timezone
        has_table_calculations: Has Table Calculations
    """

    model: str
    view: str
    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    fields: Optional[Sequence[str]] = None
    pivots: Optional[Sequence[str]] = None
    fill_fields: Optional[Sequence[str]] = None
    filters: Optional[MutableMapping[str, Any]] = None
    filter_expression: Optional[str] = None
    sorts: Optional[Sequence[str]] = None
    limit: Optional[str] = None
    column_limit: Optional[str] = None
    total: Optional[bool] = None
    row_total: Optional[str] = None
    subtotals: Optional[Sequence[str]] = None
    vis_config: Optional[MutableMapping[str, Any]] = None
    filter_config: Optional[MutableMapping[str, Any]] = None
    visible_ui_sections: Optional[str] = None
    slug: Optional[str] = None
    dynamic_fields: Optional[str] = None
    client_id: Optional[str] = None
    share_url: Optional[str] = None
    expanded_share_url: Optional[str] = None
    url: Optional[str] = None
    query_timezone: Optional[str] = None
    has_table_calculations: Optional[bool] = None

    def __init__(
        self,
        *,
        model: str,
        view: str,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        fields: Optional[Sequence[str]] = None,
        pivots: Optional[Sequence[str]] = None,
        fill_fields: Optional[Sequence[str]] = None,
        filters: Optional[MutableMapping[str, Any]] = None,
        filter_expression: Optional[str] = None,
        sorts: Optional[Sequence[str]] = None,
        limit: Optional[str] = None,
        column_limit: Optional[str] = None,
        total: Optional[bool] = None,
        row_total: Optional[str] = None,
        subtotals: Optional[Sequence[str]] = None,
        vis_config: Optional[MutableMapping[str, Any]] = None,
        filter_config: Optional[MutableMapping[str, Any]] = None,
        visible_ui_sections: Optional[str] = None,
        slug: Optional[str] = None,
        dynamic_fields: Optional[str] = None,
        client_id: Optional[str] = None,
        share_url: Optional[str] = None,
        expanded_share_url: Optional[str] = None,
        url: Optional[str] = None,
        query_timezone: Optional[str] = None,
        has_table_calculations: Optional[bool] = None
    ):
        self.model = model
        self.view = view
        self.can = can
        self.id = id
        self.fields = fields
        self.pivots = pivots
        self.fill_fields = fill_fields
        self.filters = filters
        self.filter_expression = filter_expression
        self.sorts = sorts
        self.limit = limit
        self.column_limit = column_limit
        self.total = total
        self.row_total = row_total
        self.subtotals = subtotals
        self.vis_config = vis_config
        self.filter_config = filter_config
        self.visible_ui_sections = visible_ui_sections
        self.slug = slug
        self.dynamic_fields = dynamic_fields
        self.client_id = client_id
        self.share_url = share_url
        self.expanded_share_url = expanded_share_url
        self.url = url
        self.query_timezone = query_timezone
        self.has_table_calculations = has_table_calculations


@attr.s(auto_attribs=True, init=False)
class QueryTask(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        query_id: Id of query
        query:
        generate_links: whether or not to generate links in the query response.
        force_production: Use production models to run query (even is user is in dev mode).
        path_prefix: Prefix to use for drill links.
        cache: Whether or not to use the cache
        server_table_calcs: Whether or not to run table calculations on the server
        cache_only: Retrieve any results from cache even if the results have expired.
        cache_key: cache key used to cache query.
        status: Status of query task.
        source: Source of query task.
        runtime: Runtime of prior queries.
        rebuild_pdts: Rebuild PDTS used in query.
        result_source: Source of the results of the query.
        look_id: Id of look associated with query.
        dashboard_id: Id of dashboard associated with query.
        result_format: The data format of the query results.
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    query_id: Optional[str] = None
    query: Optional["Query"] = None
    generate_links: Optional[bool] = None
    force_production: Optional[bool] = None
    path_prefix: Optional[str] = None
    cache: Optional[bool] = None
    server_table_calcs: Optional[bool] = None
    cache_only: Optional[bool] = None
    cache_key: Optional[str] = None
    status: Optional[str] = None
    source: Optional[str] = None
    runtime: Optional[float] = None
    rebuild_pdts: Optional[bool] = None
    result_source: Optional[str] = None
    look_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    result_format: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        query_id: Optional[str] = None,
        query: Optional["Query"] = None,
        generate_links: Optional[bool] = None,
        force_production: Optional[bool] = None,
        path_prefix: Optional[str] = None,
        cache: Optional[bool] = None,
        server_table_calcs: Optional[bool] = None,
        cache_only: Optional[bool] = None,
        cache_key: Optional[str] = None,
        status: Optional[str] = None,
        source: Optional[str] = None,
        runtime: Optional[float] = None,
        rebuild_pdts: Optional[bool] = None,
        result_source: Optional[str] = None,
        look_id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        result_format: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.query_id = query_id
        self.query = query
        self.generate_links = generate_links
        self.force_production = force_production
        self.path_prefix = path_prefix
        self.cache = cache
        self.server_table_calcs = server_table_calcs
        self.cache_only = cache_only
        self.cache_key = cache_key
        self.status = status
        self.source = source
        self.runtime = runtime
        self.rebuild_pdts = rebuild_pdts
        self.result_source = result_source
        self.look_id = look_id
        self.dashboard_id = dashboard_id
        self.result_format = result_format


@attr.s(auto_attribs=True, init=False)
class RenderTask(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        created_at: Date/Time render task was created
        dashboard_filters: Filter values to apply to the dashboard queries, in URL query format
        dashboard_id: Id of dashboard to render
        dashboard_style: Dashboard layout style: single_column or tiled
        finalized_at: Date/Time render task was completed
        height: Output height in pixels. Flowed layouts may ignore this value.
        id: Id of this render task
        look_id: Id of look to render
        lookml_dashboard_id: Id of lookml dashboard to render
        query_id: Id of query to render
        dashboard_element_id: Id of dashboard element to render: UDD dashboard element would be numeric and LookML dashboard element would be model_name::dashboard_title::lookml_link_id
        query_runtime: Number of seconds elapsed running queries
        render_runtime: Number of seconds elapsed rendering data
        result_format: Output format: pdf, png, or jpg
        runtime: Total seconds elapsed for render task
        status: Render task status: enqueued_for_query, querying, enqueued_for_render, rendering, success, failure
        status_detail: Additional information about the current status
        user_id: The user account permissions in which the render task will execute
        width: Output width in pixels
    """

    can: Optional[MutableMapping[str, bool]] = None
    created_at: Optional[str] = None
    dashboard_filters: Optional[str] = None
    dashboard_id: Optional[str] = None
    dashboard_style: Optional[str] = None
    finalized_at: Optional[str] = None
    height: Optional[int] = None
    id: Optional[str] = None
    look_id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    query_id: Optional[str] = None
    dashboard_element_id: Optional[str] = None
    query_runtime: Optional[float] = None
    render_runtime: Optional[float] = None
    result_format: Optional[str] = None
    runtime: Optional[float] = None
    status: Optional[str] = None
    status_detail: Optional[str] = None
    user_id: Optional[str] = None
    width: Optional[int] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        created_at: Optional[str] = None,
        dashboard_filters: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        dashboard_style: Optional[str] = None,
        finalized_at: Optional[str] = None,
        height: Optional[int] = None,
        id: Optional[str] = None,
        look_id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        query_id: Optional[str] = None,
        dashboard_element_id: Optional[str] = None,
        query_runtime: Optional[float] = None,
        render_runtime: Optional[float] = None,
        result_format: Optional[str] = None,
        runtime: Optional[float] = None,
        status: Optional[str] = None,
        status_detail: Optional[str] = None,
        user_id: Optional[str] = None,
        width: Optional[int] = None
    ):
        self.can = can
        self.created_at = created_at
        self.dashboard_filters = dashboard_filters
        self.dashboard_id = dashboard_id
        self.dashboard_style = dashboard_style
        self.finalized_at = finalized_at
        self.height = height
        self.id = id
        self.look_id = look_id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.query_id = query_id
        self.dashboard_element_id = dashboard_element_id
        self.query_runtime = query_runtime
        self.render_runtime = render_runtime
        self.result_format = result_format
        self.runtime = runtime
        self.status = status
        self.status_detail = status_detail
        self.user_id = user_id
        self.width = width


@attr.s(auto_attribs=True, init=False)
class RepositoryCredential(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        root_project_id: Root project Id
        remote_url: Git remote repository url
        git_username: Git username for HTTPS authentication.
        git_password: (Write-Only) Git password for HTTPS authentication.
        ssh_public_key: Public deploy key for SSH authentication.
        is_configured: Whether the credentials have been configured for the Git Repository.
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    root_project_id: Optional[str] = None
    remote_url: Optional[str] = None
    git_username: Optional[str] = None
    git_password: Optional[str] = None
    ssh_public_key: Optional[str] = None
    is_configured: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        root_project_id: Optional[str] = None,
        remote_url: Optional[str] = None,
        git_username: Optional[str] = None,
        git_password: Optional[str] = None,
        ssh_public_key: Optional[str] = None,
        is_configured: Optional[bool] = None
    ):
        self.can = can
        self.id = id
        self.root_project_id = root_project_id
        self.remote_url = remote_url
        self.git_username = git_username
        self.git_password = git_password
        self.ssh_public_key = ssh_public_key
        self.is_configured = is_configured


class ResultFormat(enum.Enum):
    """
    Desired async query result format. Valid values are: "inline_json", "json", "json_detail", "json_fe", "csv", "html", "md", "txt", "xlsx", "gsxml". (Enum defined in CreateQueryTask)

    """

    inline_json = "inline_json"
    json = "json"
    json_detail = "json_detail"
    json_fe = "json_fe"
    csv = "csv"
    html = "html"
    md = "md"
    txt = "txt"
    xlsx = "xlsx"
    gsxml = "gsxml"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
ResultFormat.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class ResultMakerFilterables(model.Model):
    """
    Attributes:
        model: The model this filterable comes from (used for field suggestions).
        view: The view this filterable comes from (used for field suggestions).
        name: The name of the filterable thing (Query or Merged Results).
        listen: array of dashboard_filter_name: and field: objects.
    """

    model: Optional[str] = None
    view: Optional[str] = None
    name: Optional[str] = None
    listen: Optional[Sequence["ResultMakerFilterablesListen"]] = None

    def __init__(
        self,
        *,
        model: Optional[str] = None,
        view: Optional[str] = None,
        name: Optional[str] = None,
        listen: Optional[Sequence["ResultMakerFilterablesListen"]] = None
    ):
        self.model = model
        self.view = view
        self.name = name
        self.listen = listen


@attr.s(auto_attribs=True, init=False)
class ResultMakerFilterablesListen(model.Model):
    """
    Attributes:
        dashboard_filter_name: The name of a dashboard filter to listen to.
        field: The name of the field in the filterable to filter with the value of the dashboard filter.
    """

    dashboard_filter_name: Optional[str] = None
    field: Optional[str] = None

    def __init__(
        self,
        *,
        dashboard_filter_name: Optional[str] = None,
        field: Optional[str] = None
    ):
        self.dashboard_filter_name = dashboard_filter_name
        self.field = field


@attr.s(auto_attribs=True, init=False)
class ResultMakerWithIdVisConfigAndDynamicFields(model.Model):
    """
    Attributes:
        id: Unique Id.
        dynamic_fields: JSON string of dynamic field information.
        filterables: array of items that can be filtered and information about them.
        sorts: Sorts of the constituent Look, Query, or Merge Query
        merge_result_id: ID of merge result if this is a merge_result.
        total: Total of the constituent Look, Query, or Merge Query
        query_id: ID of query if this is a query.
        sql_query_id: ID of SQL Query if this is a SQL Runner Query
        query:
        vis_config: Vis config of the constituent Query, or Merge Query.
    """

    id: Optional[str] = None
    dynamic_fields: Optional[str] = None
    filterables: Optional[Sequence["ResultMakerFilterables"]] = None
    sorts: Optional[Sequence[str]] = None
    merge_result_id: Optional[str] = None
    total: Optional[bool] = None
    query_id: Optional[str] = None
    sql_query_id: Optional[str] = None
    query: Optional["Query"] = None
    vis_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        dynamic_fields: Optional[str] = None,
        filterables: Optional[Sequence["ResultMakerFilterables"]] = None,
        sorts: Optional[Sequence[str]] = None,
        merge_result_id: Optional[str] = None,
        total: Optional[bool] = None,
        query_id: Optional[str] = None,
        sql_query_id: Optional[str] = None,
        query: Optional["Query"] = None,
        vis_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.id = id
        self.dynamic_fields = dynamic_fields
        self.filterables = filterables
        self.sorts = sorts
        self.merge_result_id = merge_result_id
        self.total = total
        self.query_id = query_id
        self.sql_query_id = sql_query_id
        self.query = query
        self.vis_config = vis_config


@attr.s(auto_attribs=True, init=False)
class Role(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        name: Name of Role
        permission_set:
        permission_set_id: (Write-Only) Id of permission set
        model_set:
        model_set_id: (Write-Only) Id of model set
        url: Link to get this item
        users_url: Link to get list of users with this role
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    name: Optional[str] = None
    permission_set: Optional["PermissionSet"] = None
    permission_set_id: Optional[str] = None
    model_set: Optional["ModelSet"] = None
    model_set_id: Optional[str] = None
    url: Optional[str] = None
    users_url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        permission_set: Optional["PermissionSet"] = None,
        permission_set_id: Optional[str] = None,
        model_set: Optional["ModelSet"] = None,
        model_set_id: Optional[str] = None,
        url: Optional[str] = None,
        users_url: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.name = name
        self.permission_set = permission_set
        self.permission_set_id = permission_set_id
        self.model_set = model_set
        self.model_set_id = model_set_id
        self.url = url
        self.users_url = users_url


@attr.s(auto_attribs=True, init=False)
class RoleSearch(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        name: Name of Role
        permission_set:
        permission_set_id: (Write-Only) Id of permission set
        model_set:
        model_set_id: (Write-Only) Id of model set
        user_count: Count of users with this role
        url: Link to get this item
        users_url: Link to get list of users with this role
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    name: Optional[str] = None
    permission_set: Optional["PermissionSet"] = None
    permission_set_id: Optional[str] = None
    model_set: Optional["ModelSet"] = None
    model_set_id: Optional[str] = None
    user_count: Optional[int] = None
    url: Optional[str] = None
    users_url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        permission_set: Optional["PermissionSet"] = None,
        permission_set_id: Optional[str] = None,
        model_set: Optional["ModelSet"] = None,
        model_set_id: Optional[str] = None,
        user_count: Optional[int] = None,
        url: Optional[str] = None,
        users_url: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.name = name
        self.permission_set = permission_set
        self.permission_set_id = permission_set_id
        self.model_set = model_set
        self.model_set_id = model_set_id
        self.user_count = user_count
        self.url = url
        self.users_url = users_url


@attr.s(auto_attribs=True, init=False)
class RunningQueries(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        user:
        query:
        sql_query:
        look:
        created_at: Date/Time Query was initiated
        completed_at: Date/Time Query was completed
        query_id: Query Id
        source: Source (look, dashboard, queryrunner, explore, etc.)
        node_id: Node Id
        slug: Slug
        query_task_id: ID of a Query Task
        cache_key: Cache Key
        connection_name: Connection
        dialect: Dialect
        connection_id: Connection ID
        message: Additional Information(Error message or verbose status)
        status: Status description
        runtime: Number of seconds elapsed running the Query
        sql: SQL text of the query as run
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    user: Optional["UserPublic"] = None
    query: Optional["Query"] = None
    sql_query: Optional["SqlQuery"] = None
    look: Optional["LookBasic"] = None
    created_at: Optional[str] = None
    completed_at: Optional[str] = None
    query_id: Optional[str] = None
    source: Optional[str] = None
    node_id: Optional[str] = None
    slug: Optional[str] = None
    query_task_id: Optional[str] = None
    cache_key: Optional[str] = None
    connection_name: Optional[str] = None
    dialect: Optional[str] = None
    connection_id: Optional[str] = None
    message: Optional[str] = None
    status: Optional[str] = None
    runtime: Optional[float] = None
    sql: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        user: Optional["UserPublic"] = None,
        query: Optional["Query"] = None,
        sql_query: Optional["SqlQuery"] = None,
        look: Optional["LookBasic"] = None,
        created_at: Optional[str] = None,
        completed_at: Optional[str] = None,
        query_id: Optional[str] = None,
        source: Optional[str] = None,
        node_id: Optional[str] = None,
        slug: Optional[str] = None,
        query_task_id: Optional[str] = None,
        cache_key: Optional[str] = None,
        connection_name: Optional[str] = None,
        dialect: Optional[str] = None,
        connection_id: Optional[str] = None,
        message: Optional[str] = None,
        status: Optional[str] = None,
        runtime: Optional[float] = None,
        sql: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.user = user
        self.query = query
        self.sql_query = sql_query
        self.look = look
        self.created_at = created_at
        self.completed_at = completed_at
        self.query_id = query_id
        self.source = source
        self.node_id = node_id
        self.slug = slug
        self.query_task_id = query_task_id
        self.cache_key = cache_key
        self.connection_name = connection_name
        self.dialect = dialect
        self.connection_id = connection_id
        self.message = message
        self.status = status
        self.runtime = runtime
        self.sql = sql


@attr.s(auto_attribs=True, init=False)
class SamlConfig(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        enabled: Enable/Disable Saml authentication for the server
        idp_cert: Identity Provider Certificate (provided by IdP)
        idp_url: Identity Provider Url (provided by IdP)
        idp_issuer: Identity Provider Issuer (provided by IdP)
        idp_audience: Identity Provider Audience (set in IdP config). Optional in Looker. Set this only if you want Looker to validate the audience value returned by the IdP.
        allowed_clock_drift: Count of seconds of clock drift to allow when validating timestamps of assertions.
        user_attribute_map_email: Name of user record attributes used to indicate email address field
        user_attribute_map_first_name: Name of user record attributes used to indicate first name
        user_attribute_map_last_name: Name of user record attributes used to indicate last name
        new_user_migration_types: Merge first-time saml login to existing user account by email addresses. When a user logs in for the first time via saml this option will connect this user into their existing account by finding the account with a matching email address by testing the given types of credentials for existing users. Otherwise a new user account will be created for the user. This list (if provided) must be a comma separated list of string like 'email,ldap,google'
        alternate_email_login_allowed: Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.
        test_slug: Slug to identify configurations that are created in order to run a Saml config test
        modified_at: When this config was last modified
        modified_by: User id of user who last modified this config
        default_new_user_roles: (Read-only) Roles that will be applied to new users the first time they login via Saml
        default_new_user_groups: (Read-only) Groups that will be applied to new users the first time they login via Saml
        default_new_user_role_ids: (Write-Only) Array of ids of roles that will be applied to new users the first time they login via Saml
        default_new_user_group_ids: (Write-Only) Array of ids of groups that will be applied to new users the first time they login via Saml
        set_roles_from_groups: Set user roles in Looker based on groups from Saml
        groups_attribute: Name of user record attributes used to indicate groups. Used when 'groups_finder_type' is set to 'grouped_attribute_values'
        groups: (Read-only) Array of mappings between Saml Groups and Looker Roles
        groups_with_role_ids: (Read/Write) Array of mappings between Saml Groups and arrays of Looker Role ids
        auth_requires_role: Users will not be allowed to login at all unless a role for them is found in Saml if set to true
        user_attributes: (Read-only) Array of mappings between Saml User Attributes and Looker User Attributes
        user_attributes_with_ids: (Read/Write) Array of mappings between Saml User Attributes and arrays of Looker User Attribute ids
        groups_finder_type: Identifier for a strategy for how Looker will find groups in the SAML response. One of ['grouped_attribute_values', 'individual_attributes']
        groups_member_value: Value for group attribute used to indicate membership. Used when 'groups_finder_type' is set to 'individual_attributes'
        bypass_login_page: Bypass the login page when user authentication is required. Redirect to IdP immediately instead.
        allow_normal_group_membership: Allow SAML auth'd users to be members of non-reflected Looker groups. If 'false', user will be removed from non-reflected groups on login.
        allow_roles_from_normal_groups: SAML auth'd users will inherit roles from non-reflected Looker groups.
        allow_direct_roles: Allows roles to be directly assigned to SAML auth'd users.
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    enabled: Optional[bool] = None
    idp_cert: Optional[str] = None
    idp_url: Optional[str] = None
    idp_issuer: Optional[str] = None
    idp_audience: Optional[str] = None
    allowed_clock_drift: Optional[int] = None
    user_attribute_map_email: Optional[str] = None
    user_attribute_map_first_name: Optional[str] = None
    user_attribute_map_last_name: Optional[str] = None
    new_user_migration_types: Optional[str] = None
    alternate_email_login_allowed: Optional[bool] = None
    test_slug: Optional[str] = None
    modified_at: Optional[str] = None
    modified_by: Optional[str] = None
    default_new_user_roles: Optional[Sequence["Role"]] = None
    default_new_user_groups: Optional[Sequence["Group"]] = None
    default_new_user_role_ids: Optional[Sequence[str]] = None
    default_new_user_group_ids: Optional[Sequence[str]] = None
    set_roles_from_groups: Optional[bool] = None
    groups_attribute: Optional[str] = None
    groups: Optional[Sequence["SamlGroupRead"]] = None
    groups_with_role_ids: Optional[Sequence["SamlGroupWrite"]] = None
    auth_requires_role: Optional[bool] = None
    user_attributes: Optional[Sequence["SamlUserAttributeRead"]] = None
    user_attributes_with_ids: Optional[Sequence["SamlUserAttributeWrite"]] = None
    groups_finder_type: Optional[str] = None
    groups_member_value: Optional[str] = None
    bypass_login_page: Optional[bool] = None
    allow_normal_group_membership: Optional[bool] = None
    allow_roles_from_normal_groups: Optional[bool] = None
    allow_direct_roles: Optional[bool] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        enabled: Optional[bool] = None,
        idp_cert: Optional[str] = None,
        idp_url: Optional[str] = None,
        idp_issuer: Optional[str] = None,
        idp_audience: Optional[str] = None,
        allowed_clock_drift: Optional[int] = None,
        user_attribute_map_email: Optional[str] = None,
        user_attribute_map_first_name: Optional[str] = None,
        user_attribute_map_last_name: Optional[str] = None,
        new_user_migration_types: Optional[str] = None,
        alternate_email_login_allowed: Optional[bool] = None,
        test_slug: Optional[str] = None,
        modified_at: Optional[str] = None,
        modified_by: Optional[str] = None,
        default_new_user_roles: Optional[Sequence["Role"]] = None,
        default_new_user_groups: Optional[Sequence["Group"]] = None,
        default_new_user_role_ids: Optional[Sequence[str]] = None,
        default_new_user_group_ids: Optional[Sequence[str]] = None,
        set_roles_from_groups: Optional[bool] = None,
        groups_attribute: Optional[str] = None,
        groups: Optional[Sequence["SamlGroupRead"]] = None,
        groups_with_role_ids: Optional[Sequence["SamlGroupWrite"]] = None,
        auth_requires_role: Optional[bool] = None,
        user_attributes: Optional[Sequence["SamlUserAttributeRead"]] = None,
        user_attributes_with_ids: Optional[Sequence["SamlUserAttributeWrite"]] = None,
        groups_finder_type: Optional[str] = None,
        groups_member_value: Optional[str] = None,
        bypass_login_page: Optional[bool] = None,
        allow_normal_group_membership: Optional[bool] = None,
        allow_roles_from_normal_groups: Optional[bool] = None,
        allow_direct_roles: Optional[bool] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.enabled = enabled
        self.idp_cert = idp_cert
        self.idp_url = idp_url
        self.idp_issuer = idp_issuer
        self.idp_audience = idp_audience
        self.allowed_clock_drift = allowed_clock_drift
        self.user_attribute_map_email = user_attribute_map_email
        self.user_attribute_map_first_name = user_attribute_map_first_name
        self.user_attribute_map_last_name = user_attribute_map_last_name
        self.new_user_migration_types = new_user_migration_types
        self.alternate_email_login_allowed = alternate_email_login_allowed
        self.test_slug = test_slug
        self.modified_at = modified_at
        self.modified_by = modified_by
        self.default_new_user_roles = default_new_user_roles
        self.default_new_user_groups = default_new_user_groups
        self.default_new_user_role_ids = default_new_user_role_ids
        self.default_new_user_group_ids = default_new_user_group_ids
        self.set_roles_from_groups = set_roles_from_groups
        self.groups_attribute = groups_attribute
        self.groups = groups
        self.groups_with_role_ids = groups_with_role_ids
        self.auth_requires_role = auth_requires_role
        self.user_attributes = user_attributes
        self.user_attributes_with_ids = user_attributes_with_ids
        self.groups_finder_type = groups_finder_type
        self.groups_member_value = groups_member_value
        self.bypass_login_page = bypass_login_page
        self.allow_normal_group_membership = allow_normal_group_membership
        self.allow_roles_from_normal_groups = allow_roles_from_normal_groups
        self.allow_direct_roles = allow_direct_roles
        self.url = url


@attr.s(auto_attribs=True, init=False)
class SamlGroupRead(model.Model):
    """
    Attributes:
        id: Unique Id
        looker_group_id: Unique Id of group in Looker
        looker_group_name: Name of group in Looker
        name: Name of group in Saml
        roles: Looker Roles
        url: Link to saml config
    """

    id: Optional[str] = None
    looker_group_id: Optional[str] = None
    looker_group_name: Optional[str] = None
    name: Optional[str] = None
    roles: Optional[Sequence["Role"]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        looker_group_id: Optional[str] = None,
        looker_group_name: Optional[str] = None,
        name: Optional[str] = None,
        roles: Optional[Sequence["Role"]] = None,
        url: Optional[str] = None
    ):
        self.id = id
        self.looker_group_id = looker_group_id
        self.looker_group_name = looker_group_name
        self.name = name
        self.roles = roles
        self.url = url


@attr.s(auto_attribs=True, init=False)
class SamlGroupWrite(model.Model):
    """
    Attributes:
        id: Unique Id
        looker_group_id: Unique Id of group in Looker
        looker_group_name: Name of group in Looker
        name: Name of group in Saml
        role_ids: Looker Role Ids
        url: Link to saml config
    """

    id: Optional[str] = None
    looker_group_id: Optional[str] = None
    looker_group_name: Optional[str] = None
    name: Optional[str] = None
    role_ids: Optional[Sequence[str]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        looker_group_id: Optional[str] = None,
        looker_group_name: Optional[str] = None,
        name: Optional[str] = None,
        role_ids: Optional[Sequence[str]] = None,
        url: Optional[str] = None
    ):
        self.id = id
        self.looker_group_id = looker_group_id
        self.looker_group_name = looker_group_name
        self.name = name
        self.role_ids = role_ids
        self.url = url


@attr.s(auto_attribs=True, init=False)
class SamlMetadataParseResult(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        idp_issuer: Identify Provider Issuer
        idp_url: Identify Provider Url
        idp_cert: Identify Provider Certificate
    """

    can: Optional[MutableMapping[str, bool]] = None
    idp_issuer: Optional[str] = None
    idp_url: Optional[str] = None
    idp_cert: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        idp_issuer: Optional[str] = None,
        idp_url: Optional[str] = None,
        idp_cert: Optional[str] = None
    ):
        self.can = can
        self.idp_issuer = idp_issuer
        self.idp_url = idp_url
        self.idp_cert = idp_cert


@attr.s(auto_attribs=True, init=False)
class SamlUserAttributeRead(model.Model):
    """
    Attributes:
        name: Name of User Attribute in Saml
        required: Required to be in Saml assertion for login to be allowed to succeed
        user_attributes: Looker User Attributes
        url: Link to saml config
    """

    name: Optional[str] = None
    required: Optional[bool] = None
    user_attributes: Optional[Sequence["UserAttribute"]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        required: Optional[bool] = None,
        user_attributes: Optional[Sequence["UserAttribute"]] = None,
        url: Optional[str] = None
    ):
        self.name = name
        self.required = required
        self.user_attributes = user_attributes
        self.url = url


@attr.s(auto_attribs=True, init=False)
class SamlUserAttributeWrite(model.Model):
    """
    Attributes:
        name: Name of User Attribute in Saml
        required: Required to be in Saml assertion for login to be allowed to succeed
        user_attribute_ids: Looker User Attribute Ids
        url: Link to saml config
    """

    name: Optional[str] = None
    required: Optional[bool] = None
    user_attribute_ids: Optional[Sequence[str]] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        required: Optional[bool] = None,
        user_attribute_ids: Optional[Sequence[str]] = None,
        url: Optional[str] = None
    ):
        self.name = name
        self.required = required
        self.user_attribute_ids = user_attribute_ids
        self.url = url


@attr.s(auto_attribs=True, init=False)
class ScheduledPlan(model.Model):
    """
    Attributes:
        name: Name of this scheduled plan
        user_id: User Id which owns this scheduled plan
        run_as_recipient: Whether schedule is run as recipient (only applicable for email recipients)
        enabled: Whether the ScheduledPlan is enabled
        look_id: Id of a look
        dashboard_id: Id of a dashboard
        lookml_dashboard_id: Id of a LookML dashboard
        filters_string: Query string to run look or dashboard with
        dashboard_filters: (DEPRECATED) Alias for filters_string field
        require_results: Delivery should occur if running the dashboard or look returns results
        require_no_results: Delivery should occur if the dashboard look does not return results
        require_change: Delivery should occur if data have changed since the last run
        send_all_results: Will run an unlimited query and send all results.
        crontab: Vixie-Style crontab specification when to run
        datagroup: Name of a datagroup; if specified will run when datagroup triggered (can't be used with cron string)
        timezone: Timezone for interpreting the specified crontab (default is Looker instance timezone)
        query_id: Query id
        scheduled_plan_destination: Scheduled plan destinations
        run_once: Whether the plan in question should only be run once (usually for testing)
        include_links: Whether links back to Looker should be included in this ScheduledPlan
        pdf_paper_size: The size of paper the PDF should be formatted to fit. Valid values are: "letter", "legal", "tabloid", "a0", "a1", "a2", "a3", "a4", "a5".
        pdf_landscape: Whether the PDF should be formatted for landscape orientation
        embed: Whether this schedule is in an embed context or not
        color_theme: Color scheme of the dashboard if applicable
        long_tables: Whether or not to expand table vis to full length
        inline_table_width: The pixel width at which we render the inline table visualizations
        id: Unique Id
        created_at: Date and time when ScheduledPlan was created
        updated_at: Date and time when ScheduledPlan was last updated
        title: Title
        user:
        next_run_at: When the ScheduledPlan will next run (null if running once)
        last_run_at: When the ScheduledPlan was last run
        can: Operations the current user is able to perform on this object
    """

    name: Optional[str] = None
    user_id: Optional[str] = None
    run_as_recipient: Optional[bool] = None
    enabled: Optional[bool] = None
    look_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    filters_string: Optional[str] = None
    dashboard_filters: Optional[str] = None
    require_results: Optional[bool] = None
    require_no_results: Optional[bool] = None
    require_change: Optional[bool] = None
    send_all_results: Optional[bool] = None
    crontab: Optional[str] = None
    datagroup: Optional[str] = None
    timezone: Optional[str] = None
    query_id: Optional[str] = None
    scheduled_plan_destination: Optional[Sequence["ScheduledPlanDestination"]] = None
    run_once: Optional[bool] = None
    include_links: Optional[bool] = None
    pdf_paper_size: Optional[str] = None
    pdf_landscape: Optional[bool] = None
    embed: Optional[bool] = None
    color_theme: Optional[str] = None
    long_tables: Optional[bool] = None
    inline_table_width: Optional[int] = None
    id: Optional[str] = None
    created_at: Optional[datetime.datetime] = None
    updated_at: Optional[datetime.datetime] = None
    title: Optional[str] = None
    user: Optional["UserPublic"] = None
    next_run_at: Optional[datetime.datetime] = None
    last_run_at: Optional[datetime.datetime] = None
    can: Optional[MutableMapping[str, bool]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        user_id: Optional[str] = None,
        run_as_recipient: Optional[bool] = None,
        enabled: Optional[bool] = None,
        look_id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        filters_string: Optional[str] = None,
        dashboard_filters: Optional[str] = None,
        require_results: Optional[bool] = None,
        require_no_results: Optional[bool] = None,
        require_change: Optional[bool] = None,
        send_all_results: Optional[bool] = None,
        crontab: Optional[str] = None,
        datagroup: Optional[str] = None,
        timezone: Optional[str] = None,
        query_id: Optional[str] = None,
        scheduled_plan_destination: Optional[
            Sequence["ScheduledPlanDestination"]
        ] = None,
        run_once: Optional[bool] = None,
        include_links: Optional[bool] = None,
        pdf_paper_size: Optional[str] = None,
        pdf_landscape: Optional[bool] = None,
        embed: Optional[bool] = None,
        color_theme: Optional[str] = None,
        long_tables: Optional[bool] = None,
        inline_table_width: Optional[int] = None,
        id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        title: Optional[str] = None,
        user: Optional["UserPublic"] = None,
        next_run_at: Optional[datetime.datetime] = None,
        last_run_at: Optional[datetime.datetime] = None,
        can: Optional[MutableMapping[str, bool]] = None
    ):
        self.name = name
        self.user_id = user_id
        self.run_as_recipient = run_as_recipient
        self.enabled = enabled
        self.look_id = look_id
        self.dashboard_id = dashboard_id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.filters_string = filters_string
        self.dashboard_filters = dashboard_filters
        self.require_results = require_results
        self.require_no_results = require_no_results
        self.require_change = require_change
        self.send_all_results = send_all_results
        self.crontab = crontab
        self.datagroup = datagroup
        self.timezone = timezone
        self.query_id = query_id
        self.scheduled_plan_destination = scheduled_plan_destination
        self.run_once = run_once
        self.include_links = include_links
        self.pdf_paper_size = pdf_paper_size
        self.pdf_landscape = pdf_landscape
        self.embed = embed
        self.color_theme = color_theme
        self.long_tables = long_tables
        self.inline_table_width = inline_table_width
        self.id = id
        self.created_at = created_at
        self.updated_at = updated_at
        self.title = title
        self.user = user
        self.next_run_at = next_run_at
        self.last_run_at = last_run_at
        self.can = can


@attr.s(auto_attribs=True, init=False)
class ScheduledPlanDestination(model.Model):
    """
    Attributes:
        id: Unique Id
        scheduled_plan_id: Id of a scheduled plan you own
        format: The data format to send to the given destination. Supported formats vary by destination, but include: "txt", "csv", "inline_json", "json", "json_detail", "xlsx", "html", "wysiwyg_pdf", "assembled_pdf", "wysiwyg_png"
        apply_formatting: Are values formatted? (containing currency symbols, digit separators, etc.
        apply_vis: Whether visualization options are applied to the results.
        address: Address for recipient. For email e.g. 'user@example.com'. For webhooks e.g. 'https://domain/path'. For Amazon S3 e.g. 's3://bucket-name/path/'. For SFTP e.g. 'sftp://host-name/path/'.
        looker_recipient: Whether the recipient is a Looker user on the current instance (only applicable for email recipients)
        type: Type of the address ('email', 'webhook', 's3', or 'sftp')
        parameters: JSON object containing parameters for external scheduling. For Amazon S3, this requires keys and values for access_key_id and region. For SFTP, this requires a key and value for username.
        secret_parameters: (Write-Only) JSON object containing secret parameters for external scheduling. For Amazon S3, this requires a key and value for secret_access_key. For SFTP, this requires a key and value for password.
        message: Optional message to be included in scheduled emails
    """

    id: Optional[str] = None
    scheduled_plan_id: Optional[str] = None
    format: Optional[str] = None
    apply_formatting: Optional[bool] = None
    apply_vis: Optional[bool] = None
    address: Optional[str] = None
    looker_recipient: Optional[bool] = None
    type: Optional[str] = None
    parameters: Optional[str] = None
    secret_parameters: Optional[str] = None
    message: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        scheduled_plan_id: Optional[str] = None,
        format: Optional[str] = None,
        apply_formatting: Optional[bool] = None,
        apply_vis: Optional[bool] = None,
        address: Optional[str] = None,
        looker_recipient: Optional[bool] = None,
        type: Optional[str] = None,
        parameters: Optional[str] = None,
        secret_parameters: Optional[str] = None,
        message: Optional[str] = None
    ):
        self.id = id
        self.scheduled_plan_id = scheduled_plan_id
        self.format = format
        self.apply_formatting = apply_formatting
        self.apply_vis = apply_vis
        self.address = address
        self.looker_recipient = looker_recipient
        self.type = type
        self.parameters = parameters
        self.secret_parameters = secret_parameters
        self.message = message


@attr.s(auto_attribs=True, init=False)
class Schema(model.Model):
    """
    Attributes:
        name: Schema name
        is_default: True if this is the default schema
    """

    name: Optional[str] = None
    is_default: Optional[bool] = None

    def __init__(
        self, *, name: Optional[str] = None, is_default: Optional[bool] = None
    ):
        self.name = name
        self.is_default = is_default


@attr.s(auto_attribs=True, init=False)
class SchemaColumn(model.Model):
    """
    Attributes:
        name: Schema item name
        sql_escaped_name: Full name of item
        schema_name: Name of schema
        data_type_database: SQL dialect data type
        data_type: Data type
        data_type_looker: Looker data type
        description: SQL data type
        column_size: Column data size
        snippets: SQL Runner snippets for this connection
    """

    name: Optional[str] = None
    sql_escaped_name: Optional[str] = None
    schema_name: Optional[str] = None
    data_type_database: Optional[str] = None
    data_type: Optional[str] = None
    data_type_looker: Optional[str] = None
    description: Optional[str] = None
    column_size: Optional[int] = None
    snippets: Optional[Sequence["Snippet"]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        sql_escaped_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        data_type_database: Optional[str] = None,
        data_type: Optional[str] = None,
        data_type_looker: Optional[str] = None,
        description: Optional[str] = None,
        column_size: Optional[int] = None,
        snippets: Optional[Sequence["Snippet"]] = None
    ):
        self.name = name
        self.sql_escaped_name = sql_escaped_name
        self.schema_name = schema_name
        self.data_type_database = data_type_database
        self.data_type = data_type
        self.data_type_looker = data_type_looker
        self.description = description
        self.column_size = column_size
        self.snippets = snippets


@attr.s(auto_attribs=True, init=False)
class SchemaColumns(model.Model):
    """
    Attributes:
        name: Schema item name
        sql_escaped_name: Full name of item
        schema_name: Name of schema
        columns: Columns for this schema
    """

    name: Optional[str] = None
    sql_escaped_name: Optional[str] = None
    schema_name: Optional[str] = None
    columns: Optional[Sequence["SchemaColumn"]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        sql_escaped_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        columns: Optional[Sequence["SchemaColumn"]] = None
    ):
        self.name = name
        self.sql_escaped_name = sql_escaped_name
        self.schema_name = schema_name
        self.columns = columns


@attr.s(auto_attribs=True, init=False)
class SchemaTable(model.Model):
    """
    Attributes:
        name: Schema item name
        sql_escaped_name: Full name of item
        schema_name: Name of schema
        rows: Number of data rows
        external: External reference???
        snippets: SQL Runner snippets for connection
    """

    name: Optional[str] = None
    sql_escaped_name: Optional[str] = None
    schema_name: Optional[str] = None
    rows: Optional[int] = None
    external: Optional[str] = None
    snippets: Optional[Sequence["Snippet"]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        sql_escaped_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        rows: Optional[int] = None,
        external: Optional[str] = None,
        snippets: Optional[Sequence["Snippet"]] = None
    ):
        self.name = name
        self.sql_escaped_name = sql_escaped_name
        self.schema_name = schema_name
        self.rows = rows
        self.external = external
        self.snippets = snippets


@attr.s(auto_attribs=True, init=False)
class SchemaTables(model.Model):
    """
    Attributes:
        name: Schema name
        is_default: True if this is the default schema
        tables: Tables for this schema
        table_limit_hit: True if the table limit was hit while retrieving tables in this schema
    """

    name: Optional[str] = None
    is_default: Optional[bool] = None
    tables: Optional[Sequence["SchemaTable"]] = None
    table_limit_hit: Optional[bool] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_default: Optional[bool] = None,
        tables: Optional[Sequence["SchemaTable"]] = None,
        table_limit_hit: Optional[bool] = None
    ):
        self.name = name
        self.is_default = is_default
        self.tables = tables
        self.table_limit_hit = table_limit_hit


@attr.s(auto_attribs=True, init=False)
class Session(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        ip_address: IP address of user when this session was initiated
        browser: User's browser type
        operating_system: User's Operating System
        city: City component of user location (derived from IP address)
        state: State component of user location (derived from IP address)
        country: Country component of user location (derived from IP address)
        credentials_type: Type of credentials used for logging in this session
        extended_at: Time when this session was last extended by the user
        extended_count: Number of times this session was extended
        sudo_user_id: Actual user in the case when this session represents one user sudo'ing as another
        created_at: Time when this session was initiated
        expires_at: Time when this session will expire
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    ip_address: Optional[str] = None
    browser: Optional[str] = None
    operating_system: Optional[str] = None
    city: Optional[str] = None
    state: Optional[str] = None
    country: Optional[str] = None
    credentials_type: Optional[str] = None
    extended_at: Optional[str] = None
    extended_count: Optional[int] = None
    sudo_user_id: Optional[str] = None
    created_at: Optional[str] = None
    expires_at: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        ip_address: Optional[str] = None,
        browser: Optional[str] = None,
        operating_system: Optional[str] = None,
        city: Optional[str] = None,
        state: Optional[str] = None,
        country: Optional[str] = None,
        credentials_type: Optional[str] = None,
        extended_at: Optional[str] = None,
        extended_count: Optional[int] = None,
        sudo_user_id: Optional[str] = None,
        created_at: Optional[str] = None,
        expires_at: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.ip_address = ip_address
        self.browser = browser
        self.operating_system = operating_system
        self.city = city
        self.state = state
        self.country = country
        self.credentials_type = credentials_type
        self.extended_at = extended_at
        self.extended_count = extended_count
        self.sudo_user_id = sudo_user_id
        self.created_at = created_at
        self.expires_at = expires_at
        self.url = url


@attr.s(auto_attribs=True, init=False)
class SessionConfig(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        allow_persistent_sessions: Allow users to have persistent sessions when they login
        session_minutes: Number of minutes for user sessions.  Must be between 5 and 43200
        unlimited_sessions_per_user: Allow users to have an unbounded number of concurrent sessions (otherwise, users will be limited to only one session at a time).
        use_inactivity_based_logout: Enforce session logout for sessions that are inactive for 15 minutes.
        track_session_location: Track location of session when user logs in.
    """

    can: Optional[MutableMapping[str, bool]] = None
    allow_persistent_sessions: Optional[bool] = None
    session_minutes: Optional[int] = None
    unlimited_sessions_per_user: Optional[bool] = None
    use_inactivity_based_logout: Optional[bool] = None
    track_session_location: Optional[bool] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        allow_persistent_sessions: Optional[bool] = None,
        session_minutes: Optional[int] = None,
        unlimited_sessions_per_user: Optional[bool] = None,
        use_inactivity_based_logout: Optional[bool] = None,
        track_session_location: Optional[bool] = None
    ):
        self.can = can
        self.allow_persistent_sessions = allow_persistent_sessions
        self.session_minutes = session_minutes
        self.unlimited_sessions_per_user = unlimited_sessions_per_user
        self.use_inactivity_based_logout = use_inactivity_based_logout
        self.track_session_location = track_session_location


@attr.s(auto_attribs=True, init=False)
class Setting(model.Model):
    """
    Attributes:
        extension_framework_enabled: Toggle extension framework on or off
        extension_load_url_enabled: (DEPRECATED) Toggle extension extension load url on or off. Do not use. This is temporary setting that will eventually become a noop and subsequently deleted.
        marketplace_auto_install_enabled: Toggle marketplace auto install on or off. Note that auto install only runs if marketplace is enabled.
        marketplace_enabled: Toggle marketplace on or off
        privatelabel_configuration:
        custom_welcome_email:
        onboarding_enabled: Toggle onboarding on or off
    """

    extension_framework_enabled: Optional[bool] = None
    extension_load_url_enabled: Optional[bool] = None
    marketplace_auto_install_enabled: Optional[bool] = None
    marketplace_enabled: Optional[bool] = None
    privatelabel_configuration: Optional["PrivatelabelConfiguration"] = None
    custom_welcome_email: Optional["CustomWelcomeEmail"] = None
    onboarding_enabled: Optional[bool] = None

    def __init__(
        self,
        *,
        extension_framework_enabled: Optional[bool] = None,
        extension_load_url_enabled: Optional[bool] = None,
        marketplace_auto_install_enabled: Optional[bool] = None,
        marketplace_enabled: Optional[bool] = None,
        privatelabel_configuration: Optional["PrivatelabelConfiguration"] = None,
        custom_welcome_email: Optional["CustomWelcomeEmail"] = None,
        onboarding_enabled: Optional[bool] = None
    ):
        self.extension_framework_enabled = extension_framework_enabled
        self.extension_load_url_enabled = extension_load_url_enabled
        self.marketplace_auto_install_enabled = marketplace_auto_install_enabled
        self.marketplace_enabled = marketplace_enabled
        self.privatelabel_configuration = privatelabel_configuration
        self.custom_welcome_email = custom_welcome_email
        self.onboarding_enabled = onboarding_enabled


@attr.s(auto_attribs=True, init=False)
class SmtpNodeStatus(model.Model):
    """
    Attributes:
        is_valid: SMTP status of node
        message: Error message for node
        hostname: Host name of node
    """

    is_valid: Optional[bool] = None
    message: Optional[str] = None
    hostname: Optional[str] = None

    def __init__(
        self,
        *,
        is_valid: Optional[bool] = None,
        message: Optional[str] = None,
        hostname: Optional[str] = None
    ):
        self.is_valid = is_valid
        self.message = message
        self.hostname = hostname


@attr.s(auto_attribs=True, init=False)
class SmtpSettings(model.Model):
    """
    Attributes:
        address: SMTP Server url
        from_: From e-mail address
        user_name: User name
        password: Password
        port: SMTP Server's port
        enable_starttls_auto: Is TLS encryption enabled?
        ssl_version: TLS version selected Valid values are: "TLSv1_1", "SSLv23", "TLSv1_2".
    """

    address: Optional[str] = None
    from_: Optional[str] = None
    user_name: Optional[str] = None
    password: Optional[str] = None
    port: Optional[int] = None
    enable_starttls_auto: Optional[bool] = None
    ssl_version: Optional["SslVersion"] = None

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        from_: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        port: Optional[int] = None,
        enable_starttls_auto: Optional[bool] = None,
        ssl_version: Optional["SslVersion"] = None
    ):
        self.address = address
        self.from_ = from_
        self.user_name = user_name
        self.password = password
        self.port = port
        self.enable_starttls_auto = enable_starttls_auto
        self.ssl_version = ssl_version


@attr.s(auto_attribs=True, init=False)
class SmtpStatus(model.Model):
    """
    Attributes:
        is_valid: Overall SMTP status of cluster
        node_count: Total number of nodes in cluster
        node_status: array of each node's status containing is_valid, message, hostname
    """

    is_valid: Optional[bool] = None
    node_count: Optional[int] = None
    node_status: Optional[Sequence["SmtpNodeStatus"]] = None

    def __init__(
        self,
        *,
        is_valid: Optional[bool] = None,
        node_count: Optional[int] = None,
        node_status: Optional[Sequence["SmtpNodeStatus"]] = None
    ):
        self.is_valid = is_valid
        self.node_count = node_count
        self.node_status = node_status


@attr.s(auto_attribs=True, init=False)
class Snippet(model.Model):
    """
    Attributes:
        name: Name of the snippet
        label: Label of the snippet
        sql: SQL text of the snippet
    """

    name: Optional[str] = None
    label: Optional[str] = None
    sql: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        label: Optional[str] = None,
        sql: Optional[str] = None
    ):
        self.name = name
        self.label = label
        self.sql = sql


@attr.s(auto_attribs=True, init=False)
class SqlQuery(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        slug: The identifier of the SQL query
        last_runtime: Number of seconds this query took to run the most recent time it was run
        run_count: Number of times this query has been run
        browser_limit: Maximum number of rows this query will display on the SQL Runner page
        sql: SQL query text
        last_run_at: The most recent time this query was run
        connection:
        model_name: Model name this query uses
        creator:
        explore_url: Explore page URL for this SQL query
        plaintext: Should this query be rendered as plain text
        vis_config: Visualization configuration properties. These properties are typically opaque and differ based on the type of visualization used. There is no specified set of allowed keys. The values can be any type supported by JSON. A "type" key with a string value is often present, and is used by Looker to determine which visualization to present. Visualizations ignore unknown vis_config properties.
        result_maker_id: ID of the ResultMakerLookup entry.
    """

    can: Optional[MutableMapping[str, bool]] = None
    slug: Optional[str] = None
    last_runtime: Optional[float] = None
    run_count: Optional[int] = None
    browser_limit: Optional[int] = None
    sql: Optional[str] = None
    last_run_at: Optional[str] = None
    connection: Optional["DBConnectionBase"] = None
    model_name: Optional[str] = None
    creator: Optional["UserPublic"] = None
    explore_url: Optional[str] = None
    plaintext: Optional[bool] = None
    vis_config: Optional[MutableMapping[str, Any]] = None
    result_maker_id: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        slug: Optional[str] = None,
        last_runtime: Optional[float] = None,
        run_count: Optional[int] = None,
        browser_limit: Optional[int] = None,
        sql: Optional[str] = None,
        last_run_at: Optional[str] = None,
        connection: Optional["DBConnectionBase"] = None,
        model_name: Optional[str] = None,
        creator: Optional["UserPublic"] = None,
        explore_url: Optional[str] = None,
        plaintext: Optional[bool] = None,
        vis_config: Optional[MutableMapping[str, Any]] = None,
        result_maker_id: Optional[str] = None
    ):
        self.can = can
        self.slug = slug
        self.last_runtime = last_runtime
        self.run_count = run_count
        self.browser_limit = browser_limit
        self.sql = sql
        self.last_run_at = last_run_at
        self.connection = connection
        self.model_name = model_name
        self.creator = creator
        self.explore_url = explore_url
        self.plaintext = plaintext
        self.vis_config = vis_config
        self.result_maker_id = result_maker_id


@attr.s(auto_attribs=True, init=False)
class SqlQueryCreate(model.Model):
    """
    Attributes:
        connection_name: Name of the db connection on which to run this query
        connection_id: (DEPRECATED) Use `connection_name` instead
        model_name: Name of LookML Model (this or `connection_id` required)
        sql: SQL query
        vis_config: Visualization configuration properties. These properties are typically opaque and differ based on the type of visualization used. There is no specified set of allowed keys. The values can be any type supported by JSON. A "type" key with a string value is often present, and is used by Looker to determine which visualization to present. Visualizations ignore unknown vis_config properties.
    """

    connection_name: Optional[str] = None
    connection_id: Optional[str] = None
    model_name: Optional[str] = None
    sql: Optional[str] = None
    vis_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        connection_name: Optional[str] = None,
        connection_id: Optional[str] = None,
        model_name: Optional[str] = None,
        sql: Optional[str] = None,
        vis_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.connection_name = connection_name
        self.connection_id = connection_id
        self.model_name = model_name
        self.sql = sql
        self.vis_config = vis_config


@attr.s(auto_attribs=True, init=False)
class SshPublicKey(model.Model):
    """
    Attributes:
        public_key: The SSH public key created for this instance
    """

    public_key: Optional[str] = None

    def __init__(self, *, public_key: Optional[str] = None):
        self.public_key = public_key


@attr.s(auto_attribs=True, init=False)
class SshServer(model.Model):
    """
    Attributes:
        ssh_server_id: A unique id used to identify this SSH Server
        ssh_server_name: The name to identify this SSH Server
        ssh_server_host: The hostname or ip address of the SSH Server
        ssh_server_port: The port to connect to on the SSH Server
        ssh_server_user: The username used to connect to the SSH Server
        finger_print: The md5 fingerprint used to identify the SSH Server
        sha_finger_print: The SHA fingerprint used to identify the SSH Server
        public_key: The SSH public key created for this instance
        status: The current connection status to this SSH Server
    """

    ssh_server_id: Optional[str] = None
    ssh_server_name: Optional[str] = None
    ssh_server_host: Optional[str] = None
    ssh_server_port: Optional[int] = None
    ssh_server_user: Optional[str] = None
    finger_print: Optional[str] = None
    sha_finger_print: Optional[str] = None
    public_key: Optional[str] = None
    status: Optional[str] = None

    def __init__(
        self,
        *,
        ssh_server_id: Optional[str] = None,
        ssh_server_name: Optional[str] = None,
        ssh_server_host: Optional[str] = None,
        ssh_server_port: Optional[int] = None,
        ssh_server_user: Optional[str] = None,
        finger_print: Optional[str] = None,
        sha_finger_print: Optional[str] = None,
        public_key: Optional[str] = None,
        status: Optional[str] = None
    ):
        self.ssh_server_id = ssh_server_id
        self.ssh_server_name = ssh_server_name
        self.ssh_server_host = ssh_server_host
        self.ssh_server_port = ssh_server_port
        self.ssh_server_user = ssh_server_user
        self.finger_print = finger_print
        self.sha_finger_print = sha_finger_print
        self.public_key = public_key
        self.status = status


@attr.s(auto_attribs=True, init=False)
class SshTunnel(model.Model):
    """
    Attributes:
        tunnel_id: Unique ID for the tunnel
        ssh_server_id: SSH Server ID
        ssh_server_name: SSH Server name
        ssh_server_host: SSH Server Hostname or IP Address
        ssh_server_port: SSH Server port
        ssh_server_user: Username used to connect to the SSH Server
        last_attempt: Time of last connect attempt
        local_host_port: Localhost Port used by the Looker instance to connect to the remote DB
        database_host: Hostname or IP Address of the Database Server
        database_port: Port that the Database Server is listening on
        status: Current connection status for this Tunnel
    """

    tunnel_id: Optional[str] = None
    ssh_server_id: Optional[str] = None
    ssh_server_name: Optional[str] = None
    ssh_server_host: Optional[str] = None
    ssh_server_port: Optional[int] = None
    ssh_server_user: Optional[str] = None
    last_attempt: Optional[str] = None
    local_host_port: Optional[int] = None
    database_host: Optional[str] = None
    database_port: Optional[int] = None
    status: Optional[str] = None

    def __init__(
        self,
        *,
        tunnel_id: Optional[str] = None,
        ssh_server_id: Optional[str] = None,
        ssh_server_name: Optional[str] = None,
        ssh_server_host: Optional[str] = None,
        ssh_server_port: Optional[int] = None,
        ssh_server_user: Optional[str] = None,
        last_attempt: Optional[str] = None,
        local_host_port: Optional[int] = None,
        database_host: Optional[str] = None,
        database_port: Optional[int] = None,
        status: Optional[str] = None
    ):
        self.tunnel_id = tunnel_id
        self.ssh_server_id = ssh_server_id
        self.ssh_server_name = ssh_server_name
        self.ssh_server_host = ssh_server_host
        self.ssh_server_port = ssh_server_port
        self.ssh_server_user = ssh_server_user
        self.last_attempt = last_attempt
        self.local_host_port = local_host_port
        self.database_host = database_host
        self.database_port = database_port
        self.status = status


class SslVersion(enum.Enum):
    """
    TLS version selected Valid values are: "TLSv1_1", "SSLv23", "TLSv1_2". (Enum defined in SmtpSettings)

    """

    TLSv1_1 = "TLSv1_1"
    SSLv23 = "SSLv23"
    TLSv1_2 = "TLSv1_2"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
SslVersion.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class SupportAccessAddEntries(model.Model):
    """
    Attributes:
        emails: An array of emails to add to the Allowlist
        reason: Reason for adding emails to the Allowlist
    """

    emails: Optional[Sequence[str]] = None
    reason: Optional[str] = None

    def __init__(
        self, *, emails: Optional[Sequence[str]] = None, reason: Optional[str] = None
    ):
        self.emails = emails
        self.reason = reason


@attr.s(auto_attribs=True, init=False)
class SupportAccessAllowlistEntry(model.Model):
    """
    Attributes:
        id: Unique ID
        email: Email address
        full_name: Full name of allowlisted user
        reason: Reason the Email is included in the Allowlist
        created_date: Date the Email was added to the Allowlist
    """

    id: Optional[str] = None
    email: Optional[str] = None
    full_name: Optional[str] = None
    reason: Optional[str] = None
    created_date: Optional[datetime.datetime] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        email: Optional[str] = None,
        full_name: Optional[str] = None,
        reason: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None
    ):
        self.id = id
        self.email = email
        self.full_name = full_name
        self.reason = reason
        self.created_date = created_date


@attr.s(auto_attribs=True, init=False)
class SupportAccessEnable(model.Model):
    """
    Attributes:
        duration_in_seconds: Duration Support Access will remain enabled
    """

    duration_in_seconds: int

    def __init__(self, *, duration_in_seconds: int):
        self.duration_in_seconds = duration_in_seconds


@attr.s(auto_attribs=True, init=False)
class SupportAccessStatus(model.Model):
    """
    Attributes:
        open: Whether or not Support Access is open
        open_until: Time that Support Access will expire
    """

    open: Optional[bool] = None
    open_until: Optional[datetime.datetime] = None

    def __init__(
        self,
        *,
        open: Optional[bool] = None,
        open_until: Optional[datetime.datetime] = None
    ):
        self.open = open
        self.open_until = open_until


class SupportedActionTypes(enum.Enum):
    """
    A list of action types the integration supports. Valid values are: "cell", "query", "dashboard", "none". (Enum defined in Integration)

    """

    cell = "cell"
    query = "query"
    dashboard = "dashboard"
    none = "none"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
SupportedActionTypes.__new__ = model.safe_enum__new__  # type: ignore


class SupportedDownloadSettings(enum.Enum):
    """
    A list of all the download mechanisms the integration supports. The order of values is not significant: Looker will select the most appropriate supported download mechanism for a given query. The integration must ensure it can handle any of the mechanisms it claims to support. If unspecified, this defaults to all download setting values. Valid values are: "push", "url". (Enum defined in Integration)

    """

    push = "push"
    url = "url"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
SupportedDownloadSettings.__new__ = model.safe_enum__new__  # type: ignore


class SupportedFormats(enum.Enum):
    """
    A list of data formats the integration supports. If unspecified, the default is all data formats. Valid values are: "txt", "csv", "inline_json", "json", "json_label", "json_detail", "json_detail_lite_stream", "xlsx", "html", "wysiwyg_pdf", "assembled_pdf", "wysiwyg_png", "csv_zip". (Enum defined in Integration)

    """

    txt = "txt"
    csv = "csv"
    inline_json = "inline_json"
    json = "json"
    json_label = "json_label"
    json_detail = "json_detail"
    json_detail_lite_stream = "json_detail_lite_stream"
    xlsx = "xlsx"
    html = "html"
    wysiwyg_pdf = "wysiwyg_pdf"
    assembled_pdf = "assembled_pdf"
    wysiwyg_png = "wysiwyg_png"
    csv_zip = "csv_zip"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
SupportedFormats.__new__ = model.safe_enum__new__  # type: ignore


class SupportedFormattings(enum.Enum):
    """
    A list of formatting options the integration supports. If unspecified, defaults to all formats. Valid values are: "formatted", "unformatted". (Enum defined in Integration)

    """

    formatted = "formatted"
    unformatted = "unformatted"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
SupportedFormattings.__new__ = model.safe_enum__new__  # type: ignore


class SupportedVisualizationFormattings(enum.Enum):
    """
    A list of visualization formatting options the integration supports. If unspecified, defaults to all formats. Valid values are: "apply", "noapply". (Enum defined in Integration)

    """

    apply = "apply"
    noapply = "noapply"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
SupportedVisualizationFormattings.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class Theme(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        begin_at: Timestamp for when this theme becomes active. Null=always
        end_at: Timestamp for when this theme expires. Null=never
        id: Unique Id
        name: Name of theme. Can only be alphanumeric and underscores.
        settings:
    """

    can: Optional[MutableMapping[str, bool]] = None
    begin_at: Optional[datetime.datetime] = None
    end_at: Optional[datetime.datetime] = None
    id: Optional[str] = None
    name: Optional[str] = None
    settings: Optional["ThemeSettings"] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        begin_at: Optional[datetime.datetime] = None,
        end_at: Optional[datetime.datetime] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        settings: Optional["ThemeSettings"] = None
    ):
        self.can = can
        self.begin_at = begin_at
        self.end_at = end_at
        self.id = id
        self.name = name
        self.settings = settings


@attr.s(auto_attribs=True, init=False)
class ThemeSettings(model.Model):
    """
    Attributes:
        background_color: Default background color
        base_font_size: Base font size for scaling fonts (only supported by legacy dashboards)
        color_collection_id: Optional. ID of color collection to use with the theme. Use an empty string for none.
        font_color: Default font color
        font_family: Primary font family
        font_source: Source specification for font
        info_button_color: Info button color
        primary_button_color: Primary button color
        show_filters_bar: Toggle to show filters. Defaults to true.
        show_title: Toggle to show the title. Defaults to true.
        text_tile_text_color: Text color for text tiles
        tile_background_color: Background color for tiles
        tile_text_color: Text color for tiles
        title_color: Color for titles
        warn_button_color: Warning button color
        tile_title_alignment: The text alignment of tile titles (New Dashboards)
        tile_shadow: Toggles the tile shadow (not supported)
    """

    background_color: Optional[str] = None
    base_font_size: Optional[str] = None
    color_collection_id: Optional[str] = None
    font_color: Optional[str] = None
    font_family: Optional[str] = None
    font_source: Optional[str] = None
    info_button_color: Optional[str] = None
    primary_button_color: Optional[str] = None
    show_filters_bar: Optional[bool] = None
    show_title: Optional[bool] = None
    text_tile_text_color: Optional[str] = None
    tile_background_color: Optional[str] = None
    tile_text_color: Optional[str] = None
    title_color: Optional[str] = None
    warn_button_color: Optional[str] = None
    tile_title_alignment: Optional[str] = None
    tile_shadow: Optional[bool] = None

    def __init__(
        self,
        *,
        background_color: Optional[str] = None,
        base_font_size: Optional[str] = None,
        color_collection_id: Optional[str] = None,
        font_color: Optional[str] = None,
        font_family: Optional[str] = None,
        font_source: Optional[str] = None,
        info_button_color: Optional[str] = None,
        primary_button_color: Optional[str] = None,
        show_filters_bar: Optional[bool] = None,
        show_title: Optional[bool] = None,
        text_tile_text_color: Optional[str] = None,
        tile_background_color: Optional[str] = None,
        tile_text_color: Optional[str] = None,
        title_color: Optional[str] = None,
        warn_button_color: Optional[str] = None,
        tile_title_alignment: Optional[str] = None,
        tile_shadow: Optional[bool] = None
    ):
        self.background_color = background_color
        self.base_font_size = base_font_size
        self.color_collection_id = color_collection_id
        self.font_color = font_color
        self.font_family = font_family
        self.font_source = font_source
        self.info_button_color = info_button_color
        self.primary_button_color = primary_button_color
        self.show_filters_bar = show_filters_bar
        self.show_title = show_title
        self.text_tile_text_color = text_tile_text_color
        self.tile_background_color = tile_background_color
        self.tile_text_color = tile_text_color
        self.title_color = title_color
        self.warn_button_color = warn_button_color
        self.tile_title_alignment = tile_title_alignment
        self.tile_shadow = tile_shadow


@attr.s(auto_attribs=True, init=False)
class Timezone(model.Model):
    """
    Attributes:
        value: Timezone
        label: Description of timezone
        group: Timezone group (e.g Common, Other, etc.)
    """

    value: Optional[str] = None
    label: Optional[str] = None
    group: Optional[str] = None

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        label: Optional[str] = None,
        group: Optional[str] = None
    ):
        self.value = value
        self.label = label
        self.group = group


@attr.s(auto_attribs=True, init=False)
class UpdateFolder(model.Model):
    """
    Attributes:
        name: Unique Name
        parent_id: Id of Parent. If the parent id is null, this is a root-level entry
    """

    name: Optional[str] = None
    parent_id: Optional[str] = None

    def __init__(self, *, name: Optional[str] = None, parent_id: Optional[str] = None):
        self.name = name
        self.parent_id = parent_id


@attr.s(auto_attribs=True, init=False)
class User(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        avatar_url: URL for the avatar image (may be generic)
        avatar_url_without_sizing: URL for the avatar image (may be generic), does not specify size
        credentials_api3: API 3 credentials
        credentials_email:
        credentials_embed: Embed credentials
        credentials_google:
        credentials_ldap:
        credentials_looker_openid:
        credentials_oidc:
        credentials_saml:
        credentials_totp:
        display_name: Full name for display (available only if both first_name and last_name are set)
        email: EMail address
        embed_group_space_id: (DEPRECATED) (Embed only) ID of user's group space based on the external_group_id optionally specified during embed user login
        first_name: First name
        group_ids: Array of ids of the groups for this user
        home_folder_id: ID string for user's home folder
        id: Unique Id
        is_disabled: Account has been disabled
        last_name: Last name
        locale: User's preferred locale. User locale takes precedence over Looker's system-wide default locale. Locale determines language of display strings and date and numeric formatting in API responses. Locale string must be a 2 letter language code or a combination of language code and region code: 'en' or 'en-US', for example.
        looker_versions: Array of strings representing the Looker versions that this user has used (this only goes back as far as '3.54.0')
        models_dir_validated: User's dev workspace has been checked for presence of applicable production projects
        personal_folder_id: ID of user's personal folder
        presumed_looker_employee: User is identified as an employee of Looker
        role_ids: Array of ids of the roles for this user
        sessions: Active sessions
        ui_state: Per user dictionary of undocumented state information owned by the Looker UI.
        verified_looker_employee: User is identified as an employee of Looker who has been verified via Looker corporate authentication
        roles_externally_managed: User's roles are managed by an external directory like SAML or LDAP and can not be changed directly.
        allow_direct_roles: User can be directly assigned a role.
        allow_normal_group_membership: User can be a direct member of a normal Looker group.
        allow_roles_from_normal_groups: User can inherit roles from a normal Looker group.
        embed_group_folder_id: (Embed only) ID of user's group folder based on the external_group_id optionally specified during embed user login
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    avatar_url: Optional[str] = None
    avatar_url_without_sizing: Optional[str] = None
    credentials_api3: Optional[Sequence["CredentialsApi3"]] = None
    credentials_email: Optional["CredentialsEmail"] = None
    credentials_embed: Optional[Sequence["CredentialsEmbed"]] = None
    credentials_google: Optional["CredentialsGoogle"] = None
    credentials_ldap: Optional["CredentialsLDAP"] = None
    credentials_looker_openid: Optional["CredentialsLookerOpenid"] = None
    credentials_oidc: Optional["CredentialsOIDC"] = None
    credentials_saml: Optional["CredentialsSaml"] = None
    credentials_totp: Optional["CredentialsTotp"] = None
    display_name: Optional[str] = None
    email: Optional[str] = None
    embed_group_space_id: Optional[str] = None
    first_name: Optional[str] = None
    group_ids: Optional[Sequence[str]] = None
    home_folder_id: Optional[str] = None
    id: Optional[str] = None
    is_disabled: Optional[bool] = None
    last_name: Optional[str] = None
    locale: Optional[str] = None
    looker_versions: Optional[Sequence[str]] = None
    models_dir_validated: Optional[bool] = None
    personal_folder_id: Optional[str] = None
    presumed_looker_employee: Optional[bool] = None
    role_ids: Optional[Sequence[str]] = None
    sessions: Optional[Sequence["Session"]] = None
    ui_state: Optional[MutableMapping[str, Any]] = None
    verified_looker_employee: Optional[bool] = None
    roles_externally_managed: Optional[bool] = None
    allow_direct_roles: Optional[bool] = None
    allow_normal_group_membership: Optional[bool] = None
    allow_roles_from_normal_groups: Optional[bool] = None
    embed_group_folder_id: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        avatar_url: Optional[str] = None,
        avatar_url_without_sizing: Optional[str] = None,
        credentials_api3: Optional[Sequence["CredentialsApi3"]] = None,
        credentials_email: Optional["CredentialsEmail"] = None,
        credentials_embed: Optional[Sequence["CredentialsEmbed"]] = None,
        credentials_google: Optional["CredentialsGoogle"] = None,
        credentials_ldap: Optional["CredentialsLDAP"] = None,
        credentials_looker_openid: Optional["CredentialsLookerOpenid"] = None,
        credentials_oidc: Optional["CredentialsOIDC"] = None,
        credentials_saml: Optional["CredentialsSaml"] = None,
        credentials_totp: Optional["CredentialsTotp"] = None,
        display_name: Optional[str] = None,
        email: Optional[str] = None,
        embed_group_space_id: Optional[str] = None,
        first_name: Optional[str] = None,
        group_ids: Optional[Sequence[str]] = None,
        home_folder_id: Optional[str] = None,
        id: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        last_name: Optional[str] = None,
        locale: Optional[str] = None,
        looker_versions: Optional[Sequence[str]] = None,
        models_dir_validated: Optional[bool] = None,
        personal_folder_id: Optional[str] = None,
        presumed_looker_employee: Optional[bool] = None,
        role_ids: Optional[Sequence[str]] = None,
        sessions: Optional[Sequence["Session"]] = None,
        ui_state: Optional[MutableMapping[str, Any]] = None,
        verified_looker_employee: Optional[bool] = None,
        roles_externally_managed: Optional[bool] = None,
        allow_direct_roles: Optional[bool] = None,
        allow_normal_group_membership: Optional[bool] = None,
        allow_roles_from_normal_groups: Optional[bool] = None,
        embed_group_folder_id: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.avatar_url = avatar_url
        self.avatar_url_without_sizing = avatar_url_without_sizing
        self.credentials_api3 = credentials_api3
        self.credentials_email = credentials_email
        self.credentials_embed = credentials_embed
        self.credentials_google = credentials_google
        self.credentials_ldap = credentials_ldap
        self.credentials_looker_openid = credentials_looker_openid
        self.credentials_oidc = credentials_oidc
        self.credentials_saml = credentials_saml
        self.credentials_totp = credentials_totp
        self.display_name = display_name
        self.email = email
        self.embed_group_space_id = embed_group_space_id
        self.first_name = first_name
        self.group_ids = group_ids
        self.home_folder_id = home_folder_id
        self.id = id
        self.is_disabled = is_disabled
        self.last_name = last_name
        self.locale = locale
        self.looker_versions = looker_versions
        self.models_dir_validated = models_dir_validated
        self.personal_folder_id = personal_folder_id
        self.presumed_looker_employee = presumed_looker_employee
        self.role_ids = role_ids
        self.sessions = sessions
        self.ui_state = ui_state
        self.verified_looker_employee = verified_looker_employee
        self.roles_externally_managed = roles_externally_managed
        self.allow_direct_roles = allow_direct_roles
        self.allow_normal_group_membership = allow_normal_group_membership
        self.allow_roles_from_normal_groups = allow_roles_from_normal_groups
        self.embed_group_folder_id = embed_group_folder_id
        self.url = url


@attr.s(auto_attribs=True, init=False)
class UserAttribute(model.Model):
    """
    Attributes:
        name: Name of user attribute
        label: Human-friendly label for user attribute
        type: Type of user attribute ("string", "number", "datetime", "yesno", "zipcode")
        can: Operations the current user is able to perform on this object
        id: Unique Id
        default_value: Default value for when no value is set on the user
        is_system: Attribute is a system default
        is_permanent: Attribute is permanent and cannot be deleted
        value_is_hidden: If true, users will not be able to view values of this attribute
        user_can_view: Non-admin users can see the values of their attributes and use them in filters
        user_can_edit: Users can change the value of this attribute for themselves
        hidden_value_domain_whitelist: Destinations to which a hidden attribute may be sent. Once set, cannot be edited.
    """

    name: str
    label: str
    type: str
    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    default_value: Optional[str] = None
    is_system: Optional[bool] = None
    is_permanent: Optional[bool] = None
    value_is_hidden: Optional[bool] = None
    user_can_view: Optional[bool] = None
    user_can_edit: Optional[bool] = None
    hidden_value_domain_whitelist: Optional[str] = None

    def __init__(
        self,
        *,
        name: str,
        label: str,
        type: str,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        default_value: Optional[str] = None,
        is_system: Optional[bool] = None,
        is_permanent: Optional[bool] = None,
        value_is_hidden: Optional[bool] = None,
        user_can_view: Optional[bool] = None,
        user_can_edit: Optional[bool] = None,
        hidden_value_domain_whitelist: Optional[str] = None
    ):
        self.name = name
        self.label = label
        self.type = type
        self.can = can
        self.id = id
        self.default_value = default_value
        self.is_system = is_system
        self.is_permanent = is_permanent
        self.value_is_hidden = value_is_hidden
        self.user_can_view = user_can_view
        self.user_can_edit = user_can_edit
        self.hidden_value_domain_whitelist = hidden_value_domain_whitelist


class UserAttributeFilterTypes(enum.Enum):
    """
    An array of user attribute types that are allowed to be used in filters on this field. Valid values are: "advanced_filter_string", "advanced_filter_number", "advanced_filter_datetime", "string", "number", "datetime", "relative_url", "yesno", "zipcode". (Enum defined in LookmlModelExploreField)

    """

    advanced_filter_string = "advanced_filter_string"
    advanced_filter_number = "advanced_filter_number"
    advanced_filter_datetime = "advanced_filter_datetime"
    string = "string"
    number = "number"
    datetime = "datetime"
    relative_url = "relative_url"
    yesno = "yesno"
    zipcode = "zipcode"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
UserAttributeFilterTypes.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class UserAttributeGroupValue(model.Model):
    """
    WARNING: no writeable properties found for POST, PUT, or PATCH

    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id of this group-attribute relation
        group_id: Id of group
        user_attribute_id: Id of user attribute
        value_is_hidden: If true, the "value" field will be null, because the attribute settings block access to this value
        rank: Precedence for resolving value for user
        value: Value of user attribute for group
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    group_id: Optional[str] = None
    user_attribute_id: Optional[str] = None
    value_is_hidden: Optional[bool] = None
    rank: Optional[int] = None
    value: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        group_id: Optional[str] = None,
        user_attribute_id: Optional[str] = None,
        value_is_hidden: Optional[bool] = None,
        rank: Optional[int] = None,
        value: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.group_id = group_id
        self.user_attribute_id = user_attribute_id
        self.value_is_hidden = value_is_hidden
        self.rank = rank
        self.value = value


@attr.s(auto_attribs=True, init=False)
class UserAttributeWithValue(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        name: Name of user attribute
        label: Human-friendly label for user attribute
        rank: Precedence for setting value on user (lowest wins)
        value: Value of attribute for user
        user_id: Id of User
        user_can_edit: Can the user set this value
        value_is_hidden: If true, the "value" field will be null, because the attribute settings block access to this value
        user_attribute_id: Id of User Attribute
        source: How user got this value for this attribute
        hidden_value_domain_whitelist: If this user attribute is hidden, whitelist of destinations to which it may be sent.
    """

    can: Optional[MutableMapping[str, bool]] = None
    name: Optional[str] = None
    label: Optional[str] = None
    rank: Optional[int] = None
    value: Optional[str] = None
    user_id: Optional[str] = None
    user_can_edit: Optional[bool] = None
    value_is_hidden: Optional[bool] = None
    user_attribute_id: Optional[str] = None
    source: Optional[str] = None
    hidden_value_domain_whitelist: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        name: Optional[str] = None,
        label: Optional[str] = None,
        rank: Optional[int] = None,
        value: Optional[str] = None,
        user_id: Optional[str] = None,
        user_can_edit: Optional[bool] = None,
        value_is_hidden: Optional[bool] = None,
        user_attribute_id: Optional[str] = None,
        source: Optional[str] = None,
        hidden_value_domain_whitelist: Optional[str] = None
    ):
        self.can = can
        self.name = name
        self.label = label
        self.rank = rank
        self.value = value
        self.user_id = user_id
        self.user_can_edit = user_can_edit
        self.value_is_hidden = value_is_hidden
        self.user_attribute_id = user_attribute_id
        self.source = source
        self.hidden_value_domain_whitelist = hidden_value_domain_whitelist


@attr.s(auto_attribs=True, init=False)
class UserEmailOnly(model.Model):
    """
    Attributes:
        email: Email Address
    """

    email: str

    def __init__(self, *, email: str):
        self.email = email


@attr.s(auto_attribs=True, init=False)
class UserLoginLockout(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        key: Hash of user's client id
        auth_type: Authentication method for login failures
        ip: IP address of most recent failed attempt
        user_id: User ID
        remote_id: Remote ID of user if using LDAP
        full_name: User's name
        email: Email address associated with the user's account
        fail_count: Number of failures that triggered the lockout
        lockout_at: Time when lockout was triggered
    """

    can: Optional[MutableMapping[str, bool]] = None
    key: Optional[str] = None
    auth_type: Optional[str] = None
    ip: Optional[str] = None
    user_id: Optional[str] = None
    remote_id: Optional[str] = None
    full_name: Optional[str] = None
    email: Optional[str] = None
    fail_count: Optional[int] = None
    lockout_at: Optional[datetime.datetime] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        key: Optional[str] = None,
        auth_type: Optional[str] = None,
        ip: Optional[str] = None,
        user_id: Optional[str] = None,
        remote_id: Optional[str] = None,
        full_name: Optional[str] = None,
        email: Optional[str] = None,
        fail_count: Optional[int] = None,
        lockout_at: Optional[datetime.datetime] = None
    ):
        self.can = can
        self.key = key
        self.auth_type = auth_type
        self.ip = ip
        self.user_id = user_id
        self.remote_id = remote_id
        self.full_name = full_name
        self.email = email
        self.fail_count = fail_count
        self.lockout_at = lockout_at


@attr.s(auto_attribs=True, init=False)
class UserPublic(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: Unique Id
        first_name: First Name
        last_name: Last Name
        display_name: Full name for display (available only if both first_name and last_name are set)
        avatar_url: URL for the avatar image (may be generic)
        url: Link to get this item
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    first_name: Optional[str] = None
    last_name: Optional[str] = None
    display_name: Optional[str] = None
    avatar_url: Optional[str] = None
    url: Optional[str] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        display_name: Optional[str] = None,
        avatar_url: Optional[str] = None,
        url: Optional[str] = None
    ):
        self.can = can
        self.id = id
        self.first_name = first_name
        self.last_name = last_name
        self.display_name = display_name
        self.avatar_url = avatar_url
        self.url = url


@attr.s(auto_attribs=True, init=False)
class ValidationError(model.Model):
    """
    Attributes:
        message: Error details
        documentation_url: Documentation link
        errors: Error detail array
    """

    message: str
    documentation_url: str
    errors: Optional[Sequence["ValidationErrorDetail"]] = None

    def __init__(
        self,
        *,
        message: str,
        documentation_url: str,
        errors: Optional[Sequence["ValidationErrorDetail"]] = None
    ):
        self.message = message
        self.documentation_url = documentation_url
        self.errors = errors


@attr.s(auto_attribs=True, init=False)
class ValidationErrorDetail(model.Model):
    """
    Attributes:
        documentation_url: Documentation link
        field: Field with error
        code: Error code
        message: Error info message
    """

    documentation_url: str
    field: Optional[str] = None
    code: Optional[str] = None
    message: Optional[str] = None

    def __init__(
        self,
        *,
        documentation_url: str,
        field: Optional[str] = None,
        code: Optional[str] = None,
        message: Optional[str] = None
    ):
        self.documentation_url = documentation_url
        self.field = field
        self.code = code
        self.message = message


class WeekStartDay(enum.Enum):
    """
    The name of the starting day of the week. Valid values are: "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday". (Enum defined in LookmlModelExploreField)

    """

    monday = "monday"
    tuesday = "tuesday"
    wednesday = "wednesday"
    thursday = "thursday"
    friday = "friday"
    saturday = "saturday"
    sunday = "sunday"
    invalid_api_enum_value = "invalid_api_enum_value"


# https://github.com/python/mypy/issues/2427
WeekStartDay.__new__ = model.safe_enum__new__  # type: ignore


@attr.s(auto_attribs=True, init=False)
class WelcomeEmailTest(model.Model):
    """
    Attributes:
        content: The content that would be sent in the body of a custom welcome email
        subject: The subject that would be sent for the custom welcome email
        header: The header that would be sent in the body of a custom welcome email
    """

    content: Optional[str] = None
    subject: Optional[str] = None
    header: Optional[str] = None

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        subject: Optional[str] = None,
        header: Optional[str] = None
    ):
        self.content = content
        self.subject = subject
        self.header = header


@attr.s(auto_attribs=True, init=False)
class WhitelabelConfiguration(model.Model):
    """
    Attributes:
        id: Unique Id
        logo_file: Customer logo image. Expected base64 encoded data (write-only)
        logo_url: Logo image url (read-only)
        favicon_file: Custom favicon image. Expected base64 encoded data (write-only)
        favicon_url: Favicon image url (read-only)
        default_title: Default page title
        show_help_menu: Boolean to toggle showing help menus
        show_docs: Boolean to toggle showing docs
        show_email_sub_options: Boolean to toggle showing email subscription options.
        allow_looker_mentions: Boolean to toggle mentions of Looker in emails
        allow_looker_links: Boolean to toggle links to Looker in emails
        custom_welcome_email_advanced: Allow subject line and email heading customization in customized emails”
        setup_mentions: Remove the word Looker from appearing in the account setup page
        alerts_logo: Remove Looker logo from Alerts
        alerts_links: Remove Looker links from Alerts
        folders_mentions: Remove Looker mentions in home folder page when you don’t have any items saved
    """

    id: Optional[str] = None
    logo_file: Optional[str] = None
    logo_url: Optional[str] = None
    favicon_file: Optional[str] = None
    favicon_url: Optional[str] = None
    default_title: Optional[str] = None
    show_help_menu: Optional[bool] = None
    show_docs: Optional[bool] = None
    show_email_sub_options: Optional[bool] = None
    allow_looker_mentions: Optional[bool] = None
    allow_looker_links: Optional[bool] = None
    custom_welcome_email_advanced: Optional[bool] = None
    setup_mentions: Optional[bool] = None
    alerts_logo: Optional[bool] = None
    alerts_links: Optional[bool] = None
    folders_mentions: Optional[bool] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        logo_file: Optional[str] = None,
        logo_url: Optional[str] = None,
        favicon_file: Optional[str] = None,
        favicon_url: Optional[str] = None,
        default_title: Optional[str] = None,
        show_help_menu: Optional[bool] = None,
        show_docs: Optional[bool] = None,
        show_email_sub_options: Optional[bool] = None,
        allow_looker_mentions: Optional[bool] = None,
        allow_looker_links: Optional[bool] = None,
        custom_welcome_email_advanced: Optional[bool] = None,
        setup_mentions: Optional[bool] = None,
        alerts_logo: Optional[bool] = None,
        alerts_links: Optional[bool] = None,
        folders_mentions: Optional[bool] = None
    ):
        self.id = id
        self.logo_file = logo_file
        self.logo_url = logo_url
        self.favicon_file = favicon_file
        self.favicon_url = favicon_url
        self.default_title = default_title
        self.show_help_menu = show_help_menu
        self.show_docs = show_docs
        self.show_email_sub_options = show_email_sub_options
        self.allow_looker_mentions = allow_looker_mentions
        self.allow_looker_links = allow_looker_links
        self.custom_welcome_email_advanced = custom_welcome_email_advanced
        self.setup_mentions = setup_mentions
        self.alerts_logo = alerts_logo
        self.alerts_links = alerts_links
        self.folders_mentions = folders_mentions


@attr.s(auto_attribs=True, init=False)
class Workspace(model.Model):
    """
    Attributes:
        can: Operations the current user is able to perform on this object
        id: The unique id of this user workspace. Predefined workspace ids include "production" and "dev"
        projects: The local state of each project in the workspace
    """

    can: Optional[MutableMapping[str, bool]] = None
    id: Optional[str] = None
    projects: Optional[Sequence["Project"]] = None

    def __init__(
        self,
        *,
        can: Optional[MutableMapping[str, bool]] = None,
        id: Optional[str] = None,
        projects: Optional[Sequence["Project"]] = None
    ):
        self.can = can
        self.id = id
        self.projects = projects


@attr.s(auto_attribs=True, init=False)
class WriteAlert(model.Model):
    """
        Dynamic writeable type for Alert removes:
    followed, followable, id, investigative_content_title, owner_display_name

        Attributes:
            comparison_type: This property informs the check what kind of comparison we are performing. Only certain condition types are valid for time series alerts. For details, refer to [Setting Alert Conditions](https://docs.looker.com/sharing-and-publishing/creating-alerts#setting_alert_conditions) Valid values are: "EQUAL_TO", "GREATER_THAN", "GREATER_THAN_OR_EQUAL_TO", "LESS_THAN", "LESS_THAN_OR_EQUAL_TO", "INCREASES_BY", "DECREASES_BY", "CHANGES_BY".
            cron: Vixie-Style crontab specification when to run. At minumum, it has to be longer than 15 minute intervals
            destinations: Array of destinations to send alerts to. Must be the same type of destination. Example `[{ "destination_type": "EMAIL", "email_address": "test@test.com" }]`
            field:
            owner_id: User id of alert owner
            threshold: Value of the alert threshold
            applied_dashboard_filters: Filters coming from the dashboard that are applied. Example `[{ "filter_title": "Name", "field_name": "distribution_centers.name", "filter_value": "Los Angeles CA" }]`
            custom_title: An optional, user-defined title for the alert
            dashboard_element_id: ID of the dashboard element associated with the alert. Refer to [dashboard_element()](#!/Dashboard/DashboardElement)
            description: An optional description for the alert. This supplements the title
            is_disabled: Whether or not the alert is disabled
            disabled_reason: Reason for disabling alert
            is_public: Whether or not the alert is public
            investigative_content_type: The type of the investigative content Valid values are: "dashboard".
            investigative_content_id: The ID of the investigative content. For dashboards, this will be the dashboard ID
            lookml_dashboard_id: ID of the LookML dashboard associated with the alert
            lookml_link_id: ID of the LookML dashboard element associated with the alert
            time_series_condition_state:
    """

    comparison_type: "ComparisonType"
    cron: str
    destinations: Sequence["AlertDestination"]
    field: "AlertField"
    owner_id: str
    threshold: float
    applied_dashboard_filters: Optional[Sequence["AlertAppliedDashboardFilter"]] = None
    custom_title: Optional[str] = None
    dashboard_element_id: Optional[str] = None
    description: Optional[str] = None
    is_disabled: Optional[bool] = None
    disabled_reason: Optional[str] = None
    is_public: Optional[bool] = None
    investigative_content_type: Optional["InvestigativeContentType"] = None
    investigative_content_id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    lookml_link_id: Optional[str] = None
    time_series_condition_state: Optional["AlertConditionState"] = None
    __annotations__ = {
        "comparison_type": ForwardRef("ComparisonType"),
        "cron": str,
        "destinations": Sequence["AlertDestination"],
        "field": ForwardRef("AlertField"),
        "owner_id": str,
        "threshold": float,
        "applied_dashboard_filters": Optional[Sequence["AlertAppliedDashboardFilter"]],
        "custom_title": Optional[str],
        "dashboard_element_id": Optional[str],
        "description": Optional[str],
        "is_disabled": Optional[bool],
        "disabled_reason": Optional[str],
        "is_public": Optional[bool],
        "investigative_content_type": Optional["InvestigativeContentType"],
        "investigative_content_id": Optional[str],
        "lookml_dashboard_id": Optional[str],
        "lookml_link_id": Optional[str],
        "time_series_condition_state": Optional["AlertConditionState"],
    }

    def __init__(
        self,
        *,
        comparison_type: "ComparisonType",
        cron: str,
        destinations: Sequence["AlertDestination"],
        field: "AlertField",
        owner_id: str,
        threshold: float,
        applied_dashboard_filters: Optional[
            Sequence["AlertAppliedDashboardFilter"]
        ] = None,
        custom_title: Optional[str] = None,
        dashboard_element_id: Optional[str] = None,
        description: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        disabled_reason: Optional[str] = None,
        is_public: Optional[bool] = None,
        investigative_content_type: Optional["InvestigativeContentType"] = None,
        investigative_content_id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        lookml_link_id: Optional[str] = None,
        time_series_condition_state: Optional["AlertConditionState"] = None
    ):
        self.comparison_type = comparison_type
        self.cron = cron
        self.destinations = destinations
        self.field = field
        self.owner_id = owner_id
        self.threshold = threshold
        self.applied_dashboard_filters = applied_dashboard_filters
        self.custom_title = custom_title
        self.dashboard_element_id = dashboard_element_id
        self.description = description
        self.is_disabled = is_disabled
        self.disabled_reason = disabled_reason
        self.is_public = is_public
        self.investigative_content_type = investigative_content_type
        self.investigative_content_id = investigative_content_id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.lookml_link_id = lookml_link_id
        self.time_series_condition_state = time_series_condition_state


@attr.s(auto_attribs=True, init=False)
class WriteApiSession(model.Model):
    """
        Dynamic writeable type for ApiSession removes:
    can, sudo_user_id

        Attributes:
            workspace_id: The id of active workspace for this session
    """

    workspace_id: Optional[str] = None

    def __init__(self, *, workspace_id: Optional[str] = None):
        self.workspace_id = workspace_id


@attr.s(auto_attribs=True, init=False)
class WriteBackupConfiguration(model.Model):
    """
        Dynamic writeable type for BackupConfiguration removes:
    can, url

        Attributes:
            type: Type of backup: looker-s3 or custom-s3
            custom_s3_bucket: Name of bucket for custom-s3 backups
            custom_s3_bucket_region: Name of region where the bucket is located
            custom_s3_key: (Write-Only) AWS S3 key used for custom-s3 backups
            custom_s3_secret: (Write-Only) AWS S3 secret used for custom-s3 backups
    """

    type: Optional[str] = None
    custom_s3_bucket: Optional[str] = None
    custom_s3_bucket_region: Optional[str] = None
    custom_s3_key: Optional[str] = None
    custom_s3_secret: Optional[str] = None

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        custom_s3_bucket: Optional[str] = None,
        custom_s3_bucket_region: Optional[str] = None,
        custom_s3_key: Optional[str] = None,
        custom_s3_secret: Optional[str] = None
    ):
        self.type = type
        self.custom_s3_bucket = custom_s3_bucket
        self.custom_s3_bucket_region = custom_s3_bucket_region
        self.custom_s3_key = custom_s3_key
        self.custom_s3_secret = custom_s3_secret


@attr.s(auto_attribs=True, init=False)
class WriteBoard(model.Model):
    """
        Dynamic writeable type for Board removes:
    can, content_metadata_id, created_at, board_sections, id, updated_at, user_id, primary_homepage

        Attributes:
            deleted_at: Date of board deletion
            description: Description of the board
            section_order: ids of the board sections in the order they should be displayed
            title: Title of the board
    """

    deleted_at: Optional[datetime.datetime] = None
    description: Optional[str] = None
    section_order: Optional[Sequence[str]] = None
    title: Optional[str] = None

    def __init__(
        self,
        *,
        deleted_at: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        section_order: Optional[Sequence[str]] = None,
        title: Optional[str] = None
    ):
        self.deleted_at = deleted_at
        self.description = description
        self.section_order = section_order
        self.title = title


@attr.s(auto_attribs=True, init=False)
class WriteBoardItem(model.Model):
    """
        Dynamic writeable type for BoardItem removes:
    can, content_created_by, content_favorite_id, content_metadata_id, content_updated_at, description, favorite_count, id, image_url, location, title, url, view_count, custom_image_url

        Attributes:
            custom_description: Custom description entered by the user, if present
            custom_title: Custom title entered by the user, if present
            custom_url: Custom url entered by the user, if present
            dashboard_id: Dashboard to base this item on
            board_section_id: Associated Board Section
            look_id: Look to base this item on
            lookml_dashboard_id: LookML Dashboard to base this item on
            order: An arbitrary integer representing the sort order within the section
            use_custom_description: Whether the custom description should be used instead of the content description, if the item is associated with content
            use_custom_title: Whether the custom title should be used instead of the content title, if the item is associated with content
            use_custom_url: Whether the custom url should be used instead of the content url, if the item is associated with content
            custom_image_data_base64: (Write-Only) base64 encoded image data
            use_custom_image: Whether the custom image should be used instead of the content image, if the item is associated with content
    """

    custom_description: Optional[str] = None
    custom_title: Optional[str] = None
    custom_url: Optional[str] = None
    dashboard_id: Optional[str] = None
    board_section_id: Optional[str] = None
    look_id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    order: Optional[int] = None
    use_custom_description: Optional[bool] = None
    use_custom_title: Optional[bool] = None
    use_custom_url: Optional[bool] = None
    custom_image_data_base64: Optional[str] = None
    use_custom_image: Optional[bool] = None

    def __init__(
        self,
        *,
        custom_description: Optional[str] = None,
        custom_title: Optional[str] = None,
        custom_url: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        board_section_id: Optional[str] = None,
        look_id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        order: Optional[int] = None,
        use_custom_description: Optional[bool] = None,
        use_custom_title: Optional[bool] = None,
        use_custom_url: Optional[bool] = None,
        custom_image_data_base64: Optional[str] = None,
        use_custom_image: Optional[bool] = None
    ):
        self.custom_description = custom_description
        self.custom_title = custom_title
        self.custom_url = custom_url
        self.dashboard_id = dashboard_id
        self.board_section_id = board_section_id
        self.look_id = look_id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.order = order
        self.use_custom_description = use_custom_description
        self.use_custom_title = use_custom_title
        self.use_custom_url = use_custom_url
        self.custom_image_data_base64 = custom_image_data_base64
        self.use_custom_image = use_custom_image


@attr.s(auto_attribs=True, init=False)
class WriteBoardSection(model.Model):
    """
        Dynamic writeable type for BoardSection removes:
    can, created_at, board_items, id, visible_item_order, updated_at

        Attributes:
            deleted_at: Time at which this section was deleted.
            description: Description of the content found in this section.
            board_id: Id reference to parent board
            item_order: ids of the board items in the order they should be displayed
            title: Name of row
    """

    deleted_at: Optional[datetime.datetime] = None
    description: Optional[str] = None
    board_id: Optional[str] = None
    item_order: Optional[Sequence[str]] = None
    title: Optional[str] = None

    def __init__(
        self,
        *,
        deleted_at: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        board_id: Optional[str] = None,
        item_order: Optional[Sequence[str]] = None,
        title: Optional[str] = None
    ):
        self.deleted_at = deleted_at
        self.description = description
        self.board_id = board_id
        self.item_order = item_order
        self.title = title


@attr.s(auto_attribs=True, init=False)
class WriteColorCollection(model.Model):
    """
        Dynamic writeable type for ColorCollection removes:
    id

        Attributes:
            label: Label of color collection
            categoricalPalettes: Array of categorical palette definitions
            sequentialPalettes: Array of discrete palette definitions
            divergingPalettes: Array of diverging palette definitions
    """

    label: Optional[str] = None
    categoricalPalettes: Optional[Sequence["DiscretePalette"]] = None
    sequentialPalettes: Optional[Sequence["ContinuousPalette"]] = None
    divergingPalettes: Optional[Sequence["ContinuousPalette"]] = None

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        categoricalPalettes: Optional[Sequence["DiscretePalette"]] = None,
        sequentialPalettes: Optional[Sequence["ContinuousPalette"]] = None,
        divergingPalettes: Optional[Sequence["ContinuousPalette"]] = None
    ):
        self.label = label
        self.categoricalPalettes = categoricalPalettes
        self.sequentialPalettes = sequentialPalettes
        self.divergingPalettes = divergingPalettes


@attr.s(auto_attribs=True, init=False)
class WriteContentFavorite(model.Model):
    """
        Dynamic writeable type for ContentFavorite removes:
    id, look_id, dashboard_id, board_id

        Attributes:
            user_id: User Id which owns this ContentFavorite
            content_metadata_id: Content Metadata Id associated with this ContentFavorite
            look: Dynamic writeable type for LookBasic removes:
    can, content_metadata_id, id, title
            dashboard: Dynamic writeable type for DashboardBase removes:
    can, content_favorite_id, content_metadata_id, description, hidden, id, model, query_timezone, readonly, refresh_interval, refresh_interval_to_i, title, user_id, slug, preferred_viewer
    """

    user_id: Optional[str] = None
    content_metadata_id: Optional[str] = None
    look: Optional["WriteLookBasic"] = None
    dashboard: Optional["WriteDashboardBase"] = None

    def __init__(
        self,
        *,
        user_id: Optional[str] = None,
        content_metadata_id: Optional[str] = None,
        look: Optional["WriteLookBasic"] = None,
        dashboard: Optional["WriteDashboardBase"] = None
    ):
        self.user_id = user_id
        self.content_metadata_id = content_metadata_id
        self.look = look
        self.dashboard = dashboard


@attr.s(auto_attribs=True, init=False)
class WriteContentMeta(model.Model):
    """
        Dynamic writeable type for ContentMeta removes:
    can, id, name, parent_id, dashboard_id, look_id, folder_id, content_type, inheriting_id, slug

        Attributes:
            inherits: Whether content inherits its access levels from parent
    """

    inherits: Optional[bool] = None

    def __init__(self, *, inherits: Optional[bool] = None):
        self.inherits = inherits


@attr.s(auto_attribs=True, init=False)
class WriteCreateDashboardFilter(model.Model):
    """
        Dynamic writeable type for CreateDashboardFilter removes:
    id, field

        Attributes:
            dashboard_id: Id of Dashboard
            name: Name of filter
            title: Title of filter
            type: Type of filter: one of date, number, string, or field
            default_value: Default value of filter
            model: Model of filter (required if type = field)
            explore: Explore of filter (required if type = field)
            dimension: Dimension of filter (required if type = field)
            row: Display order of this filter relative to other filters
            listens_to_filters: Array of listeners for faceted filters
            allow_multiple_values: Whether the filter allows multiple filter values (deprecated in the latest version of dashboards)
            required: Whether the filter requires a value to run the dashboard
            ui_config: The visual configuration for this filter. Used to set up how the UI for this filter should appear.
    """

    dashboard_id: str
    name: str
    title: str
    type: str
    default_value: Optional[str] = None
    model: Optional[str] = None
    explore: Optional[str] = None
    dimension: Optional[str] = None
    row: Optional[int] = None
    listens_to_filters: Optional[Sequence[str]] = None
    allow_multiple_values: Optional[bool] = None
    required: Optional[bool] = None
    ui_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        dashboard_id: str,
        name: str,
        title: str,
        type: str,
        default_value: Optional[str] = None,
        model: Optional[str] = None,
        explore: Optional[str] = None,
        dimension: Optional[str] = None,
        row: Optional[int] = None,
        listens_to_filters: Optional[Sequence[str]] = None,
        allow_multiple_values: Optional[bool] = None,
        required: Optional[bool] = None,
        ui_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.dashboard_id = dashboard_id
        self.name = name
        self.title = title
        self.type = type
        self.default_value = default_value
        self.model = model
        self.explore = explore
        self.dimension = dimension
        self.row = row
        self.listens_to_filters = listens_to_filters
        self.allow_multiple_values = allow_multiple_values
        self.required = required
        self.ui_config = ui_config


@attr.s(auto_attribs=True, init=False)
class WriteCreateQueryTask(model.Model):
    """
        Dynamic writeable type for CreateQueryTask removes:
    can

        Attributes:
            query_id: Id of query to run
            result_format: Desired async query result format. Valid values are: "inline_json", "json", "json_detail", "json_fe", "csv", "html", "md", "txt", "xlsx", "gsxml".
            source: Source of query task
            deferred: Create the task but defer execution
            look_id: Id of look associated with query.
            dashboard_id: Id of dashboard associated with query.
    """

    query_id: str
    result_format: "ResultFormat"
    source: Optional[str] = None
    deferred: Optional[bool] = None
    look_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    __annotations__ = {
        "query_id": str,
        "result_format": ForwardRef("ResultFormat"),
        "source": Optional[str],
        "deferred": Optional[bool],
        "look_id": Optional[str],
        "dashboard_id": Optional[str],
    }

    def __init__(
        self,
        *,
        query_id: str,
        result_format: "ResultFormat",
        source: Optional[str] = None,
        deferred: Optional[bool] = None,
        look_id: Optional[str] = None,
        dashboard_id: Optional[str] = None
    ):
        self.query_id = query_id
        self.result_format = result_format
        self.source = source
        self.deferred = deferred
        self.look_id = look_id
        self.dashboard_id = dashboard_id


@attr.s(auto_attribs=True, init=False)
class WriteCredentialsEmail(model.Model):
    """
        Dynamic writeable type for CredentialsEmail removes:
    can, created_at, is_disabled, logged_in_at, password_reset_url, type, url, user_url

        Attributes:
            email: EMail address used for user login
            forced_password_reset_at_next_login: Force the user to change their password upon their next login
    """

    email: Optional[str] = None
    forced_password_reset_at_next_login: Optional[bool] = None

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        forced_password_reset_at_next_login: Optional[bool] = None
    ):
        self.email = email
        self.forced_password_reset_at_next_login = forced_password_reset_at_next_login


@attr.s(auto_attribs=True, init=False)
class WriteDashboard(model.Model):
    """
        Dynamic writeable type for Dashboard removes:
    can, content_favorite_id, content_metadata_id, id, model, readonly, refresh_interval_to_i, user_id, created_at, dashboard_elements, dashboard_filters, dashboard_layouts, deleted_at, deleter_id, edit_uri, favorite_count, last_accessed_at, last_viewed_at, updated_at, last_updater_id, last_updater_name, user_name, view_count, url

        Attributes:
            description: Description
            hidden: Is Hidden
            query_timezone: Timezone in which the Dashboard will run by default.
            refresh_interval: Refresh Interval, as a time duration phrase like "2 hours 30 minutes". A number with no time units will be interpreted as whole seconds.
            folder: Dynamic writeable type for FolderBase removes:
    id, content_metadata_id, created_at, creator_id, child_count, external_id, is_embed, is_embed_shared_root, is_embed_users_root, is_personal, is_personal_descendant, is_shared_root, is_users_root, can
            title: Dashboard Title
            slug: Content Metadata Slug
            preferred_viewer: The preferred route for viewing this dashboard (ie: dashboards or dashboards-next)
            alert_sync_with_dashboard_filter_enabled: Enables alerts to keep in sync with dashboard filter changes
            background_color: Background color
            crossfilter_enabled: Enables crossfiltering in dashboards - only available in dashboards-next (beta)
            deleted: Whether or not a dashboard is 'soft' deleted.
            filters_bar_collapsed: Sets the default state of the filters bar to collapsed or open
            filters_location_top: Sets the default state of the filters location to top(true) or right(false)
            load_configuration: configuration option that governs how dashboard loading will happen.
            lookml_link_id: Links this dashboard to a particular LookML dashboard such that calling a **sync** operation on that LookML dashboard will update this dashboard to match.
            show_filters_bar: Show filters bar.  **Security Note:** This property only affects the *cosmetic* appearance of the dashboard, not a user's ability to access data. Hiding the filters bar does **NOT** prevent users from changing filters by other means. For information on how to set up secure data access control policies, see [Control User Access to Data](https://docs.looker.com/r/api/control-access)
            show_title: Show title
            folder_id: Id of folder
            text_tile_text_color: Color of text on text tiles
            tile_background_color: Tile background color
            tile_text_color: Tile text color
            title_color: Title color
            appearance:
    """

    description: Optional[str] = None
    hidden: Optional[bool] = None
    query_timezone: Optional[str] = None
    refresh_interval: Optional[str] = None
    folder: Optional["WriteFolderBase"] = None
    title: Optional[str] = None
    slug: Optional[str] = None
    preferred_viewer: Optional[str] = None
    alert_sync_with_dashboard_filter_enabled: Optional[bool] = None
    background_color: Optional[str] = None
    crossfilter_enabled: Optional[bool] = None
    deleted: Optional[bool] = None
    filters_bar_collapsed: Optional[bool] = None
    filters_location_top: Optional[bool] = None
    load_configuration: Optional[str] = None
    lookml_link_id: Optional[str] = None
    show_filters_bar: Optional[bool] = None
    show_title: Optional[bool] = None
    folder_id: Optional[str] = None
    text_tile_text_color: Optional[str] = None
    tile_background_color: Optional[str] = None
    tile_text_color: Optional[str] = None
    title_color: Optional[str] = None
    appearance: Optional["DashboardAppearance"] = None

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        hidden: Optional[bool] = None,
        query_timezone: Optional[str] = None,
        refresh_interval: Optional[str] = None,
        folder: Optional["WriteFolderBase"] = None,
        title: Optional[str] = None,
        slug: Optional[str] = None,
        preferred_viewer: Optional[str] = None,
        alert_sync_with_dashboard_filter_enabled: Optional[bool] = None,
        background_color: Optional[str] = None,
        crossfilter_enabled: Optional[bool] = None,
        deleted: Optional[bool] = None,
        filters_bar_collapsed: Optional[bool] = None,
        filters_location_top: Optional[bool] = None,
        load_configuration: Optional[str] = None,
        lookml_link_id: Optional[str] = None,
        show_filters_bar: Optional[bool] = None,
        show_title: Optional[bool] = None,
        folder_id: Optional[str] = None,
        text_tile_text_color: Optional[str] = None,
        tile_background_color: Optional[str] = None,
        tile_text_color: Optional[str] = None,
        title_color: Optional[str] = None,
        appearance: Optional["DashboardAppearance"] = None
    ):
        self.description = description
        self.hidden = hidden
        self.query_timezone = query_timezone
        self.refresh_interval = refresh_interval
        self.folder = folder
        self.title = title
        self.slug = slug
        self.preferred_viewer = preferred_viewer
        self.alert_sync_with_dashboard_filter_enabled = (
            alert_sync_with_dashboard_filter_enabled
        )
        self.background_color = background_color
        self.crossfilter_enabled = crossfilter_enabled
        self.deleted = deleted
        self.filters_bar_collapsed = filters_bar_collapsed
        self.filters_location_top = filters_location_top
        self.load_configuration = load_configuration
        self.lookml_link_id = lookml_link_id
        self.show_filters_bar = show_filters_bar
        self.show_title = show_title
        self.folder_id = folder_id
        self.text_tile_text_color = text_tile_text_color
        self.tile_background_color = tile_background_color
        self.tile_text_color = tile_text_color
        self.title_color = title_color
        self.appearance = appearance


@attr.s(auto_attribs=True, init=False)
class WriteDashboardBase(model.Model):
    """
        Dynamic writeable type for DashboardBase removes:
    can, content_favorite_id, content_metadata_id, description, hidden, id, model, query_timezone, readonly, refresh_interval, refresh_interval_to_i, title, user_id, slug, preferred_viewer

        Attributes:
            folder: Dynamic writeable type for FolderBase removes:
    id, content_metadata_id, created_at, creator_id, child_count, external_id, is_embed, is_embed_shared_root, is_embed_users_root, is_personal, is_personal_descendant, is_shared_root, is_users_root, can
    """

    folder: Optional["WriteFolderBase"] = None

    def __init__(self, *, folder: Optional["WriteFolderBase"] = None):
        self.folder = folder


@attr.s(auto_attribs=True, init=False)
class WriteDashboardElement(model.Model):
    """
        Dynamic writeable type for DashboardElement removes:
    can, body_text_as_html, edit_uri, id, lookml_link_id, note_text_as_html, refresh_interval_to_i, alert_count, title_text_as_html, subtitle_text_as_html, extension_id

        Attributes:
            body_text: Text tile body text
            dashboard_id: Id of Dashboard
            look: Dynamic writeable type for LookWithQuery removes:
    can, content_metadata_id, id, content_favorite_id, created_at, deleted_at, deleter_id, embed_url, excel_file_url, favorite_count, google_spreadsheet_formula, image_embed_url, last_accessed_at, last_updater_id, last_viewed_at, model, public_slug, public_url, short_url, updated_at, view_count, url
            look_id: Id Of Look
            merge_result_id: ID of merge result
            note_display: Note Display
            note_state: Note State
            note_text: Note Text
            query: Dynamic writeable type for Query removes:
    can, id, slug, share_url, expanded_share_url, url, has_table_calculations
            query_id: Id Of Query
            refresh_interval: Refresh Interval
            result_maker: Dynamic writeable type for ResultMakerWithIdVisConfigAndDynamicFields removes:
    id, dynamic_fields, filterables, sorts, merge_result_id, total, query_id, sql_query_id, vis_config
            result_maker_id: ID of the ResultMakerLookup entry.
            subtitle_text: Text tile subtitle text
            title: Title of dashboard element
            title_hidden: Whether title is hidden
            title_text: Text tile title
            type: Type
            rich_content_json: JSON with all the properties required for rich editor and buttons elements
    """

    body_text: Optional[str] = None
    dashboard_id: Optional[str] = None
    look: Optional["WriteLookWithQuery"] = None
    look_id: Optional[str] = None
    merge_result_id: Optional[str] = None
    note_display: Optional[str] = None
    note_state: Optional[str] = None
    note_text: Optional[str] = None
    query: Optional["WriteQuery"] = None
    query_id: Optional[str] = None
    refresh_interval: Optional[str] = None
    result_maker: Optional["WriteResultMakerWithIdVisConfigAndDynamicFields"] = None
    result_maker_id: Optional[str] = None
    subtitle_text: Optional[str] = None
    title: Optional[str] = None
    title_hidden: Optional[bool] = None
    title_text: Optional[str] = None
    type: Optional[str] = None
    rich_content_json: Optional[str] = None

    def __init__(
        self,
        *,
        body_text: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        look: Optional["WriteLookWithQuery"] = None,
        look_id: Optional[str] = None,
        merge_result_id: Optional[str] = None,
        note_display: Optional[str] = None,
        note_state: Optional[str] = None,
        note_text: Optional[str] = None,
        query: Optional["WriteQuery"] = None,
        query_id: Optional[str] = None,
        refresh_interval: Optional[str] = None,
        result_maker: Optional[
            "WriteResultMakerWithIdVisConfigAndDynamicFields"
        ] = None,
        result_maker_id: Optional[str] = None,
        subtitle_text: Optional[str] = None,
        title: Optional[str] = None,
        title_hidden: Optional[bool] = None,
        title_text: Optional[str] = None,
        type: Optional[str] = None,
        rich_content_json: Optional[str] = None
    ):
        self.body_text = body_text
        self.dashboard_id = dashboard_id
        self.look = look
        self.look_id = look_id
        self.merge_result_id = merge_result_id
        self.note_display = note_display
        self.note_state = note_state
        self.note_text = note_text
        self.query = query
        self.query_id = query_id
        self.refresh_interval = refresh_interval
        self.result_maker = result_maker
        self.result_maker_id = result_maker_id
        self.subtitle_text = subtitle_text
        self.title = title
        self.title_hidden = title_hidden
        self.title_text = title_text
        self.type = type
        self.rich_content_json = rich_content_json


@attr.s(auto_attribs=True, init=False)
class WriteDashboardFilter(model.Model):
    """
        Dynamic writeable type for DashboardFilter removes:
    can, id, dashboard_id, field

        Attributes:
            name: Name of filter
            title: Title of filter
            type: Type of filter: one of date, number, string, or field
            default_value: Default value of filter
            model: Model of filter (required if type = field)
            explore: Explore of filter (required if type = field)
            dimension: Dimension of filter (required if type = field)
            row: Display order of this filter relative to other filters
            listens_to_filters: Array of listeners for faceted filters
            allow_multiple_values: Whether the filter allows multiple filter values (deprecated in the latest version of dashboards)
            required: Whether the filter requires a value to run the dashboard
            ui_config: The visual configuration for this filter. Used to set up how the UI for this filter should appear.
    """

    name: Optional[str] = None
    title: Optional[str] = None
    type: Optional[str] = None
    default_value: Optional[str] = None
    model: Optional[str] = None
    explore: Optional[str] = None
    dimension: Optional[str] = None
    row: Optional[int] = None
    listens_to_filters: Optional[Sequence[str]] = None
    allow_multiple_values: Optional[bool] = None
    required: Optional[bool] = None
    ui_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        title: Optional[str] = None,
        type: Optional[str] = None,
        default_value: Optional[str] = None,
        model: Optional[str] = None,
        explore: Optional[str] = None,
        dimension: Optional[str] = None,
        row: Optional[int] = None,
        listens_to_filters: Optional[Sequence[str]] = None,
        allow_multiple_values: Optional[bool] = None,
        required: Optional[bool] = None,
        ui_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.name = name
        self.title = title
        self.type = type
        self.default_value = default_value
        self.model = model
        self.explore = explore
        self.dimension = dimension
        self.row = row
        self.listens_to_filters = listens_to_filters
        self.allow_multiple_values = allow_multiple_values
        self.required = required
        self.ui_config = ui_config


@attr.s(auto_attribs=True, init=False)
class WriteDashboardLayout(model.Model):
    """
        Dynamic writeable type for DashboardLayout removes:
    can, id, deleted, dashboard_title, dashboard_layout_components

        Attributes:
            dashboard_id: Id of Dashboard
            type: Type
            active: Is Active
            column_width: Column Width
            width: Width
    """

    dashboard_id: Optional[str] = None
    type: Optional[str] = None
    active: Optional[bool] = None
    column_width: Optional[int] = None
    width: Optional[int] = None

    def __init__(
        self,
        *,
        dashboard_id: Optional[str] = None,
        type: Optional[str] = None,
        active: Optional[bool] = None,
        column_width: Optional[int] = None,
        width: Optional[int] = None
    ):
        self.dashboard_id = dashboard_id
        self.type = type
        self.active = active
        self.column_width = column_width
        self.width = width


@attr.s(auto_attribs=True, init=False)
class WriteDashboardLayoutComponent(model.Model):
    """
        Dynamic writeable type for DashboardLayoutComponent removes:
    can, id, deleted, element_title, element_title_hidden, vis_type

        Attributes:
            dashboard_layout_id: Id of Dashboard Layout
            dashboard_element_id: Id Of Dashboard Element
            row: Row
            column: Column
            width: Width
            height: Height
    """

    dashboard_layout_id: Optional[str] = None
    dashboard_element_id: Optional[str] = None
    row: Optional[int] = None
    column: Optional[int] = None
    width: Optional[int] = None
    height: Optional[int] = None

    def __init__(
        self,
        *,
        dashboard_layout_id: Optional[str] = None,
        dashboard_element_id: Optional[str] = None,
        row: Optional[int] = None,
        column: Optional[int] = None,
        width: Optional[int] = None,
        height: Optional[int] = None
    ):
        self.dashboard_layout_id = dashboard_layout_id
        self.dashboard_element_id = dashboard_element_id
        self.row = row
        self.column = column
        self.width = width
        self.height = height


@attr.s(auto_attribs=True, init=False)
class WriteDashboardLookml(model.Model):
    """
        Dynamic writeable type for DashboardLookml removes:
    dashboard_id

        Attributes:
            folder_id: (Write-Only) Id of the folder
            lookml: lookml of UDD
    """

    folder_id: Optional[str] = None
    lookml: Optional[str] = None

    def __init__(
        self, *, folder_id: Optional[str] = None, lookml: Optional[str] = None
    ):
        self.folder_id = folder_id
        self.lookml = lookml


@attr.s(auto_attribs=True, init=False)
class WriteDatagroup(model.Model):
    """
        Dynamic writeable type for Datagroup removes:
    can, created_at, id, model_name, name, trigger_check_at, trigger_error, trigger_value

        Attributes:
            stale_before: UNIX timestamp before which cache entries are considered stale. Cannot be in the future.
            triggered_at: UNIX timestamp at which this entry became triggered. Cannot be in the future.
    """

    stale_before: Optional[int] = None
    triggered_at: Optional[int] = None

    def __init__(
        self, *, stale_before: Optional[int] = None, triggered_at: Optional[int] = None
    ):
        self.stale_before = stale_before
        self.triggered_at = triggered_at


@attr.s(auto_attribs=True, init=False)
class WriteDBConnection(model.Model):
    """
        Dynamic writeable type for DBConnection removes:
    can, dialect, snippets, pdts_enabled, uses_oauth, supports_data_studio_link, created_at, user_id, example, last_regen_at, last_reap_at, managed

        Attributes:
            name: Name of the connection. Also used as the unique identifier
            host: Host name/address of server
            port: Port number on server
            username: Username for server authentication
            password: (Write-Only) Password for server authentication
            certificate: (Write-Only) Base64 encoded Certificate body for server authentication (when appropriate for dialect).
            file_type: (Write-Only) Certificate keyfile type - .json or .p12
            database: Database name
            db_timezone: Time zone of database
            query_timezone: Timezone to use in queries
            schema: Scheme name
            max_connections: Maximum number of concurrent connection to use
            max_billing_gigabytes: Maximum size of query in GBs (BigQuery only, can be a user_attribute name)
            ssl: Use SSL/TLS when connecting to server
            verify_ssl: Verify the SSL
            tmp_db_name: Name of temporary database (if used)
            jdbc_additional_params: Additional params to add to JDBC connection string
            pool_timeout: Connection Pool Timeout, in seconds
            dialect_name: (Read/Write) SQL Dialect name
            user_db_credentials: (Limited access feature) Are per user db credentials enabled. Enabling will remove previously set username and password
            user_attribute_fields: Fields whose values map to user attribute names
            maintenance_cron: Cron string specifying when maintenance such as PDT trigger checks and drops should be performed
            sql_runner_precache_tables: Precache tables in the SQL Runner
            sql_writing_with_info_schema: Fetch Information Schema For SQL Writing
            after_connect_statements: SQL statements (semicolon separated) to issue after connecting to the database. Requires `custom_after_connect_statements` license feature
            pdt_context_override: Dynamic writeable type for DBConnectionOverride removes:
    has_password
            tunnel_id: The Id of the ssh tunnel this connection uses
            pdt_concurrency: Maximum number of threads to use to build PDTs in parallel
            disable_context_comment: When disable_context_comment is true comment will not be added to SQL
            oauth_application_id: An External OAuth Application to use for authenticating to the database
            always_retry_failed_builds: When true, error PDTs will be retried every regenerator cycle
            cost_estimate_enabled: When true, query cost estimate will be displayed in explore.
            pdt_api_control_enabled: PDT builds on this connection can be kicked off and cancelled via API.
    """

    name: Optional[str] = None
    host: Optional[str] = None
    port: Optional[str] = None
    username: Optional[str] = None
    password: Optional[str] = None
    certificate: Optional[str] = None
    file_type: Optional[str] = None
    database: Optional[str] = None
    db_timezone: Optional[str] = None
    query_timezone: Optional[str] = None
    schema: Optional[str] = None
    max_connections: Optional[int] = None
    max_billing_gigabytes: Optional[str] = None
    ssl: Optional[bool] = None
    verify_ssl: Optional[bool] = None
    tmp_db_name: Optional[str] = None
    jdbc_additional_params: Optional[str] = None
    pool_timeout: Optional[int] = None
    dialect_name: Optional[str] = None
    user_db_credentials: Optional[bool] = None
    user_attribute_fields: Optional[Sequence[str]] = None
    maintenance_cron: Optional[str] = None
    sql_runner_precache_tables: Optional[bool] = None
    sql_writing_with_info_schema: Optional[bool] = None
    after_connect_statements: Optional[str] = None
    pdt_context_override: Optional["WriteDBConnectionOverride"] = None
    tunnel_id: Optional[str] = None
    pdt_concurrency: Optional[int] = None
    disable_context_comment: Optional[bool] = None
    oauth_application_id: Optional[str] = None
    always_retry_failed_builds: Optional[bool] = None
    cost_estimate_enabled: Optional[bool] = None
    pdt_api_control_enabled: Optional[bool] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        host: Optional[str] = None,
        port: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        certificate: Optional[str] = None,
        file_type: Optional[str] = None,
        database: Optional[str] = None,
        db_timezone: Optional[str] = None,
        query_timezone: Optional[str] = None,
        schema: Optional[str] = None,
        max_connections: Optional[int] = None,
        max_billing_gigabytes: Optional[str] = None,
        ssl: Optional[bool] = None,
        verify_ssl: Optional[bool] = None,
        tmp_db_name: Optional[str] = None,
        jdbc_additional_params: Optional[str] = None,
        pool_timeout: Optional[int] = None,
        dialect_name: Optional[str] = None,
        user_db_credentials: Optional[bool] = None,
        user_attribute_fields: Optional[Sequence[str]] = None,
        maintenance_cron: Optional[str] = None,
        sql_runner_precache_tables: Optional[bool] = None,
        sql_writing_with_info_schema: Optional[bool] = None,
        after_connect_statements: Optional[str] = None,
        pdt_context_override: Optional["WriteDBConnectionOverride"] = None,
        tunnel_id: Optional[str] = None,
        pdt_concurrency: Optional[int] = None,
        disable_context_comment: Optional[bool] = None,
        oauth_application_id: Optional[str] = None,
        always_retry_failed_builds: Optional[bool] = None,
        cost_estimate_enabled: Optional[bool] = None,
        pdt_api_control_enabled: Optional[bool] = None
    ):
        self.name = name
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.certificate = certificate
        self.file_type = file_type
        self.database = database
        self.db_timezone = db_timezone
        self.query_timezone = query_timezone
        self.schema = schema
        self.max_connections = max_connections
        self.max_billing_gigabytes = max_billing_gigabytes
        self.ssl = ssl
        self.verify_ssl = verify_ssl
        self.tmp_db_name = tmp_db_name
        self.jdbc_additional_params = jdbc_additional_params
        self.pool_timeout = pool_timeout
        self.dialect_name = dialect_name
        self.user_db_credentials = user_db_credentials
        self.user_attribute_fields = user_attribute_fields
        self.maintenance_cron = maintenance_cron
        self.sql_runner_precache_tables = sql_runner_precache_tables
        self.sql_writing_with_info_schema = sql_writing_with_info_schema
        self.after_connect_statements = after_connect_statements
        self.pdt_context_override = pdt_context_override
        self.tunnel_id = tunnel_id
        self.pdt_concurrency = pdt_concurrency
        self.disable_context_comment = disable_context_comment
        self.oauth_application_id = oauth_application_id
        self.always_retry_failed_builds = always_retry_failed_builds
        self.cost_estimate_enabled = cost_estimate_enabled
        self.pdt_api_control_enabled = pdt_api_control_enabled


@attr.s(auto_attribs=True, init=False)
class WriteDBConnectionOverride(model.Model):
    """
        Dynamic writeable type for DBConnectionOverride removes:
    has_password

        Attributes:
            context: Context in which to override (`pdt` is the only allowed value)
            host: Host name/address of server
            port: Port number on server
            username: Username for server authentication
            password: (Write-Only) Password for server authentication
            certificate: (Write-Only) Base64 encoded Certificate body for server authentication (when appropriate for dialect).
            file_type: (Write-Only) Certificate keyfile type - .json or .p12
            database: Database name
            schema: Scheme name
            jdbc_additional_params: Additional params to add to JDBC connection string
            after_connect_statements: SQL statements (semicolon separated) to issue after connecting to the database. Requires `custom_after_connect_statements` license feature
    """

    context: Optional[str] = None
    host: Optional[str] = None
    port: Optional[str] = None
    username: Optional[str] = None
    password: Optional[str] = None
    certificate: Optional[str] = None
    file_type: Optional[str] = None
    database: Optional[str] = None
    schema: Optional[str] = None
    jdbc_additional_params: Optional[str] = None
    after_connect_statements: Optional[str] = None

    def __init__(
        self,
        *,
        context: Optional[str] = None,
        host: Optional[str] = None,
        port: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        certificate: Optional[str] = None,
        file_type: Optional[str] = None,
        database: Optional[str] = None,
        schema: Optional[str] = None,
        jdbc_additional_params: Optional[str] = None,
        after_connect_statements: Optional[str] = None
    ):
        self.context = context
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.certificate = certificate
        self.file_type = file_type
        self.database = database
        self.schema = schema
        self.jdbc_additional_params = jdbc_additional_params
        self.after_connect_statements = after_connect_statements


@attr.s(auto_attribs=True, init=False)
class WriteEmbedSecret(model.Model):
    """
        Dynamic writeable type for EmbedSecret removes:
    created_at, id, secret, user_id

        Attributes:
            algorithm: Signing algorithm to use with this secret. Either `hmac/sha-256`(default) or `hmac/sha-1`
            enabled: Is this secret currently enabled
    """

    algorithm: Optional[str] = None
    enabled: Optional[bool] = None

    def __init__(
        self, *, algorithm: Optional[str] = None, enabled: Optional[bool] = None
    ):
        self.algorithm = algorithm
        self.enabled = enabled


@attr.s(auto_attribs=True, init=False)
class WriteExternalOauthApplication(model.Model):
    """
        Dynamic writeable type for ExternalOauthApplication removes:
    can, id, created_at

        Attributes:
            name: The name of this application.  For Snowflake connections, this should be the name of the host database.
            client_id: The OAuth Client ID for this application
            client_secret: (Write-Only) The OAuth Client Secret for this application
            dialect_name: The database dialect for this application.
    """

    name: Optional[str] = None
    client_id: Optional[str] = None
    client_secret: Optional[str] = None
    dialect_name: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        dialect_name: Optional[str] = None
    ):
        self.name = name
        self.client_id = client_id
        self.client_secret = client_secret
        self.dialect_name = dialect_name


@attr.s(auto_attribs=True, init=False)
class WriteFolderBase(model.Model):
    """
        Dynamic writeable type for FolderBase removes:
    id, content_metadata_id, created_at, creator_id, child_count, external_id, is_embed, is_embed_shared_root, is_embed_users_root, is_personal, is_personal_descendant, is_shared_root, is_users_root, can

        Attributes:
            name: Unique Name
            parent_id: Id of Parent. If the parent id is null, this is a root-level entry
    """

    name: str
    parent_id: Optional[str] = None

    def __init__(self, *, name: str, parent_id: Optional[str] = None):
        self.name = name
        self.parent_id = parent_id


@attr.s(auto_attribs=True, init=False)
class WriteGitBranch(model.Model):
    """
        Dynamic writeable type for GitBranch removes:
    can, remote, remote_name, error, message, owner_name, readonly, personal, is_local, is_remote, is_production, ahead_count, behind_count, commit_at, remote_ref

        Attributes:
            name: The short name on the local. Updating `name` results in `git checkout <new_name>`
            ref: The resolved ref of this branch. Updating `ref` results in `git reset --hard <new_ref>``.
    """

    name: Optional[str] = None
    ref: Optional[str] = None

    def __init__(self, *, name: Optional[str] = None, ref: Optional[str] = None):
        self.name = name
        self.ref = ref


@attr.s(auto_attribs=True, init=False)
class WriteGroup(model.Model):
    """
        Dynamic writeable type for Group removes:
    can, contains_current_user, external_group_id, externally_managed, id, include_by_default, user_count

        Attributes:
            can_add_to_content_metadata: Group can be used in content access controls
            name: Name of group
    """

    can_add_to_content_metadata: Optional[bool] = None
    name: Optional[str] = None

    def __init__(
        self,
        *,
        can_add_to_content_metadata: Optional[bool] = None,
        name: Optional[str] = None
    ):
        self.can_add_to_content_metadata = can_add_to_content_metadata
        self.name = name


@attr.s(auto_attribs=True, init=False)
class WriteIntegration(model.Model):
    """
        Dynamic writeable type for Integration removes:
    can, id, integration_hub_id, label, description, supported_formats, supported_action_types, supported_formattings, supported_visualization_formattings, supported_download_settings, icon_url, uses_oauth, required_fields, delegate_oauth

        Attributes:
            enabled: Whether the integration is available to users.
            params: Array of params for the integration.
            installed_delegate_oauth_targets: Whether the integration is available to users.
    """

    enabled: Optional[bool] = None
    params: Optional[Sequence["IntegrationParam"]] = None
    installed_delegate_oauth_targets: Optional[Sequence[str]] = None

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        params: Optional[Sequence["IntegrationParam"]] = None,
        installed_delegate_oauth_targets: Optional[Sequence[str]] = None
    ):
        self.enabled = enabled
        self.params = params
        self.installed_delegate_oauth_targets = installed_delegate_oauth_targets


@attr.s(auto_attribs=True, init=False)
class WriteIntegrationHub(model.Model):
    """
        Dynamic writeable type for IntegrationHub removes:
    can, id, label, official, fetch_error_message, has_authorization_token, legal_agreement_signed, legal_agreement_required, legal_agreement_text

        Attributes:
            url: URL of the hub.
            authorization_token: (Write-Only) An authorization key that will be sent to the integration hub on every request.
    """

    url: Optional[str] = None
    authorization_token: Optional[str] = None

    def __init__(
        self, *, url: Optional[str] = None, authorization_token: Optional[str] = None
    ):
        self.url = url
        self.authorization_token = authorization_token


@attr.s(auto_attribs=True, init=False)
class WriteInternalHelpResources(model.Model):
    """
        Dynamic writeable type for InternalHelpResources removes:
    can

        Attributes:
            enabled: If true and internal help resources content is not blank then the link for internal help resources will be shown in the help menu and the content displayed within Looker
    """

    enabled: Optional[bool] = None

    def __init__(self, *, enabled: Optional[bool] = None):
        self.enabled = enabled


@attr.s(auto_attribs=True, init=False)
class WriteInternalHelpResourcesContent(model.Model):
    """
        Dynamic writeable type for InternalHelpResourcesContent removes:
    can

        Attributes:
            organization_name: Text to display in the help menu item which will display the internal help resources
            markdown_content: Content to be displayed in the internal help resources page/modal
    """

    organization_name: Optional[str] = None
    markdown_content: Optional[str] = None

    def __init__(
        self,
        *,
        organization_name: Optional[str] = None,
        markdown_content: Optional[str] = None
    ):
        self.organization_name = organization_name
        self.markdown_content = markdown_content


@attr.s(auto_attribs=True, init=False)
class WriteLDAPConfig(model.Model):
    """
        Dynamic writeable type for LDAPConfig removes:
    can, default_new_user_groups, default_new_user_roles, groups, has_auth_password, modified_at, modified_by, user_attributes, url

        Attributes:
            alternate_email_login_allowed: Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.
            auth_password: (Write-Only)  Password for the LDAP account used to access the LDAP server
            auth_requires_role: Users will not be allowed to login at all unless a role for them is found in LDAP if set to true
            auth_username: Distinguished name of LDAP account used to access the LDAP server
            connection_host: LDAP server hostname
            connection_port: LDAP host port
            connection_tls: Use Transport Layer Security
            connection_tls_no_verify: Do not verify peer when using TLS
            default_new_user_group_ids: (Write-Only)  Array of ids of groups that will be applied to new users the first time they login via LDAP
            default_new_user_role_ids: (Write-Only)  Array of ids of roles that will be applied to new users the first time they login via LDAP
            enabled: Enable/Disable LDAP authentication for the server
            force_no_page: Don't attempt to do LDAP search result paging (RFC 2696) even if the LDAP server claims to support it.
            groups_base_dn: Base dn for finding groups in LDAP searches
            groups_finder_type: Identifier for a strategy for how Looker will search for groups in the LDAP server
            groups_member_attribute: LDAP Group attribute that signifies the members of the groups. Most commonly 'member'
            groups_objectclasses: Optional comma-separated list of supported LDAP objectclass for groups when doing groups searches
            groups_user_attribute: LDAP Group attribute that signifies the user in a group. Most commonly 'dn'
            groups_with_role_ids: (Read/Write) Array of mappings between LDAP Groups and arrays of Looker Role ids
            merge_new_users_by_email: Merge first-time ldap login to existing user account by email addresses. When a user logs in for the first time via ldap this option will connect this user into their existing account by finding the account with a matching email address. Otherwise a new user account will be created for the user.
            set_roles_from_groups: Set user roles in Looker based on groups from LDAP
            test_ldap_password: (Write-Only)  Test LDAP user password. For ldap tests only.
            test_ldap_user: (Write-Only)  Test LDAP user login id. For ldap tests only.
            user_attribute_map_email: Name of user record attributes used to indicate email address field
            user_attribute_map_first_name: Name of user record attributes used to indicate first name
            user_attribute_map_last_name: Name of user record attributes used to indicate last name
            user_attribute_map_ldap_id: Name of user record attributes used to indicate unique record id
            user_attributes_with_ids: (Read/Write) Array of mappings between LDAP User Attributes and arrays of Looker User Attribute ids
            user_bind_base_dn: Distinguished name of LDAP node used as the base for user searches
            user_custom_filter: (Optional) Custom RFC-2254 filter clause for use in finding user during login. Combined via 'and' with the other generated filter clauses.
            user_id_attribute_names: Name(s) of user record attributes used for matching user login id (comma separated list)
            user_objectclass: (Optional) Name of user record objectclass used for finding user during login id
            allow_normal_group_membership: Allow LDAP auth'd users to be members of non-reflected Looker groups. If 'false', user will be removed from non-reflected groups on login.
            allow_roles_from_normal_groups: LDAP auth'd users will be able to inherit roles from non-reflected Looker groups.
            allow_direct_roles: Allows roles to be directly assigned to LDAP auth'd users.
    """

    alternate_email_login_allowed: Optional[bool] = None
    auth_password: Optional[str] = None
    auth_requires_role: Optional[bool] = None
    auth_username: Optional[str] = None
    connection_host: Optional[str] = None
    connection_port: Optional[str] = None
    connection_tls: Optional[bool] = None
    connection_tls_no_verify: Optional[bool] = None
    default_new_user_group_ids: Optional[Sequence[str]] = None
    default_new_user_role_ids: Optional[Sequence[str]] = None
    enabled: Optional[bool] = None
    force_no_page: Optional[bool] = None
    groups_base_dn: Optional[str] = None
    groups_finder_type: Optional[str] = None
    groups_member_attribute: Optional[str] = None
    groups_objectclasses: Optional[str] = None
    groups_user_attribute: Optional[str] = None
    groups_with_role_ids: Optional[Sequence["LDAPGroupWrite"]] = None
    merge_new_users_by_email: Optional[bool] = None
    set_roles_from_groups: Optional[bool] = None
    test_ldap_password: Optional[str] = None
    test_ldap_user: Optional[str] = None
    user_attribute_map_email: Optional[str] = None
    user_attribute_map_first_name: Optional[str] = None
    user_attribute_map_last_name: Optional[str] = None
    user_attribute_map_ldap_id: Optional[str] = None
    user_attributes_with_ids: Optional[Sequence["LDAPUserAttributeWrite"]] = None
    user_bind_base_dn: Optional[str] = None
    user_custom_filter: Optional[str] = None
    user_id_attribute_names: Optional[str] = None
    user_objectclass: Optional[str] = None
    allow_normal_group_membership: Optional[bool] = None
    allow_roles_from_normal_groups: Optional[bool] = None
    allow_direct_roles: Optional[bool] = None

    def __init__(
        self,
        *,
        alternate_email_login_allowed: Optional[bool] = None,
        auth_password: Optional[str] = None,
        auth_requires_role: Optional[bool] = None,
        auth_username: Optional[str] = None,
        connection_host: Optional[str] = None,
        connection_port: Optional[str] = None,
        connection_tls: Optional[bool] = None,
        connection_tls_no_verify: Optional[bool] = None,
        default_new_user_group_ids: Optional[Sequence[str]] = None,
        default_new_user_role_ids: Optional[Sequence[str]] = None,
        enabled: Optional[bool] = None,
        force_no_page: Optional[bool] = None,
        groups_base_dn: Optional[str] = None,
        groups_finder_type: Optional[str] = None,
        groups_member_attribute: Optional[str] = None,
        groups_objectclasses: Optional[str] = None,
        groups_user_attribute: Optional[str] = None,
        groups_with_role_ids: Optional[Sequence["LDAPGroupWrite"]] = None,
        merge_new_users_by_email: Optional[bool] = None,
        set_roles_from_groups: Optional[bool] = None,
        test_ldap_password: Optional[str] = None,
        test_ldap_user: Optional[str] = None,
        user_attribute_map_email: Optional[str] = None,
        user_attribute_map_first_name: Optional[str] = None,
        user_attribute_map_last_name: Optional[str] = None,
        user_attribute_map_ldap_id: Optional[str] = None,
        user_attributes_with_ids: Optional[Sequence["LDAPUserAttributeWrite"]] = None,
        user_bind_base_dn: Optional[str] = None,
        user_custom_filter: Optional[str] = None,
        user_id_attribute_names: Optional[str] = None,
        user_objectclass: Optional[str] = None,
        allow_normal_group_membership: Optional[bool] = None,
        allow_roles_from_normal_groups: Optional[bool] = None,
        allow_direct_roles: Optional[bool] = None
    ):
        self.alternate_email_login_allowed = alternate_email_login_allowed
        self.auth_password = auth_password
        self.auth_requires_role = auth_requires_role
        self.auth_username = auth_username
        self.connection_host = connection_host
        self.connection_port = connection_port
        self.connection_tls = connection_tls
        self.connection_tls_no_verify = connection_tls_no_verify
        self.default_new_user_group_ids = default_new_user_group_ids
        self.default_new_user_role_ids = default_new_user_role_ids
        self.enabled = enabled
        self.force_no_page = force_no_page
        self.groups_base_dn = groups_base_dn
        self.groups_finder_type = groups_finder_type
        self.groups_member_attribute = groups_member_attribute
        self.groups_objectclasses = groups_objectclasses
        self.groups_user_attribute = groups_user_attribute
        self.groups_with_role_ids = groups_with_role_ids
        self.merge_new_users_by_email = merge_new_users_by_email
        self.set_roles_from_groups = set_roles_from_groups
        self.test_ldap_password = test_ldap_password
        self.test_ldap_user = test_ldap_user
        self.user_attribute_map_email = user_attribute_map_email
        self.user_attribute_map_first_name = user_attribute_map_first_name
        self.user_attribute_map_last_name = user_attribute_map_last_name
        self.user_attribute_map_ldap_id = user_attribute_map_ldap_id
        self.user_attributes_with_ids = user_attributes_with_ids
        self.user_bind_base_dn = user_bind_base_dn
        self.user_custom_filter = user_custom_filter
        self.user_id_attribute_names = user_id_attribute_names
        self.user_objectclass = user_objectclass
        self.allow_normal_group_membership = allow_normal_group_membership
        self.allow_roles_from_normal_groups = allow_roles_from_normal_groups
        self.allow_direct_roles = allow_direct_roles


@attr.s(auto_attribs=True, init=False)
class WriteLegacyFeature(model.Model):
    """
        Dynamic writeable type for LegacyFeature removes:
    can, id, name, description, enabled, disallowed_as_of_version, disable_on_upgrade_to_version, end_of_life_version, documentation_url, approximate_disable_date, approximate_end_of_life_date, has_disabled_on_upgrade

        Attributes:
            enabled_locally: Whether this feature has been enabled by a user
    """

    enabled_locally: Optional[bool] = None

    def __init__(self, *, enabled_locally: Optional[bool] = None):
        self.enabled_locally = enabled_locally


@attr.s(auto_attribs=True, init=False)
class WriteLookBasic(model.Model):
    """
        Dynamic writeable type for LookBasic removes:
    can, content_metadata_id, id, title

        Attributes:
            user_id: User Id
    """

    user_id: Optional[str] = None

    def __init__(self, *, user_id: Optional[str] = None):
        self.user_id = user_id


@attr.s(auto_attribs=True, init=False)
class WriteLookmlModel(model.Model):
    """
        Dynamic writeable type for LookmlModel removes:
    can, explores, has_content, label

        Attributes:
            allowed_db_connection_names: Array of names of connections this model is allowed to use
            name: Name of the model. Also used as the unique identifier
            project_name: Name of project containing the model
            unlimited_db_connections: Is this model allowed to use all current and future connections
    """

    allowed_db_connection_names: Optional[Sequence[str]] = None
    name: Optional[str] = None
    project_name: Optional[str] = None
    unlimited_db_connections: Optional[bool] = None

    def __init__(
        self,
        *,
        allowed_db_connection_names: Optional[Sequence[str]] = None,
        name: Optional[str] = None,
        project_name: Optional[str] = None,
        unlimited_db_connections: Optional[bool] = None
    ):
        self.allowed_db_connection_names = allowed_db_connection_names
        self.name = name
        self.project_name = project_name
        self.unlimited_db_connections = unlimited_db_connections


@attr.s(auto_attribs=True, init=False)
class WriteLookWithQuery(model.Model):
    """
        Dynamic writeable type for LookWithQuery removes:
    can, content_metadata_id, id, content_favorite_id, created_at, deleted_at, deleter_id, embed_url, excel_file_url, favorite_count, google_spreadsheet_formula, image_embed_url, last_accessed_at, last_updater_id, last_viewed_at, model, public_slug, public_url, short_url, updated_at, view_count, url

        Attributes:
            title: Look Title
            user_id: User Id
            deleted: Whether or not a look is 'soft' deleted.
            description: Description
            is_run_on_load: auto-run query when Look viewed
            public: Is Public
            query_id: Query Id
            folder: Dynamic writeable type for FolderBase removes:
    id, content_metadata_id, created_at, creator_id, child_count, external_id, is_embed, is_embed_shared_root, is_embed_users_root, is_personal, is_personal_descendant, is_shared_root, is_users_root, can
            folder_id: Folder Id
            query: Dynamic writeable type for Query removes:
    can, id, slug, share_url, expanded_share_url, url, has_table_calculations
    """

    title: Optional[str] = None
    user_id: Optional[str] = None
    deleted: Optional[bool] = None
    description: Optional[str] = None
    is_run_on_load: Optional[bool] = None
    public: Optional[bool] = None
    query_id: Optional[str] = None
    folder: Optional["WriteFolderBase"] = None
    folder_id: Optional[str] = None
    query: Optional["WriteQuery"] = None

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        user_id: Optional[str] = None,
        deleted: Optional[bool] = None,
        description: Optional[str] = None,
        is_run_on_load: Optional[bool] = None,
        public: Optional[bool] = None,
        query_id: Optional[str] = None,
        folder: Optional["WriteFolderBase"] = None,
        folder_id: Optional[str] = None,
        query: Optional["WriteQuery"] = None
    ):
        self.title = title
        self.user_id = user_id
        self.deleted = deleted
        self.description = description
        self.is_run_on_load = is_run_on_load
        self.public = public
        self.query_id = query_id
        self.folder = folder
        self.folder_id = folder_id
        self.query = query


@attr.s(auto_attribs=True, init=False)
class WriteMergeQuery(model.Model):
    """
        Dynamic writeable type for MergeQuery removes:
    can, id, result_maker_id

        Attributes:
            column_limit: Column Limit
            dynamic_fields: Dynamic Fields
            pivots: Pivots
            sorts: Sorts
            source_queries: Source Queries defining the results to be merged.
            total: Total
            vis_config: Visualization Config
    """

    column_limit: Optional[str] = None
    dynamic_fields: Optional[str] = None
    pivots: Optional[Sequence[str]] = None
    sorts: Optional[Sequence[str]] = None
    source_queries: Optional[Sequence["MergeQuerySourceQuery"]] = None
    total: Optional[bool] = None
    vis_config: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        column_limit: Optional[str] = None,
        dynamic_fields: Optional[str] = None,
        pivots: Optional[Sequence[str]] = None,
        sorts: Optional[Sequence[str]] = None,
        source_queries: Optional[Sequence["MergeQuerySourceQuery"]] = None,
        total: Optional[bool] = None,
        vis_config: Optional[MutableMapping[str, Any]] = None
    ):
        self.column_limit = column_limit
        self.dynamic_fields = dynamic_fields
        self.pivots = pivots
        self.sorts = sorts
        self.source_queries = source_queries
        self.total = total
        self.vis_config = vis_config


@attr.s(auto_attribs=True, init=False)
class WriteMobileToken(model.Model):
    """
        Dynamic writeable type for MobileToken removes:
    id

        Attributes:
            device_token: Specifies the device token
            device_type: Specifies type of device. Valid values are: "android", "ios".
    """

    device_token: str
    device_type: "DeviceType"
    __annotations__ = {"device_token": str, "device_type": ForwardRef("DeviceType")}

    def __init__(self, *, device_token: str, device_type: "DeviceType"):
        self.device_token = device_token
        self.device_type = device_type


@attr.s(auto_attribs=True, init=False)
class WriteModelSet(model.Model):
    """
        Dynamic writeable type for ModelSet removes:
    can, all_access, built_in, id, url

        Attributes:
            models:
            name: Name of ModelSet
    """

    models: Optional[Sequence[str]] = None
    name: Optional[str] = None

    def __init__(
        self, *, models: Optional[Sequence[str]] = None, name: Optional[str] = None
    ):
        self.models = models
        self.name = name


@attr.s(auto_attribs=True, init=False)
class WriteOauthClientApp(model.Model):
    """
        Dynamic writeable type for OauthClientApp removes:
    can, client_guid, tokens_invalid_before, activated_users

        Attributes:
            redirect_uri: The uri with which this application will receive an auth code by browser redirect.
            display_name: The application's display name
            description: A description of the application that will be displayed to users
            enabled: When enabled is true, OAuth2 and API requests will be accepted from this app. When false, all requests from this app will be refused. Setting disabled invalidates existing tokens.
            group_id: If set, only Looker users who are members of this group can use this web app with Looker. If group_id is not set, any Looker user may use this app to access this Looker instance
    """

    redirect_uri: Optional[str] = None
    display_name: Optional[str] = None
    description: Optional[str] = None
    enabled: Optional[bool] = None
    group_id: Optional[str] = None

    def __init__(
        self,
        *,
        redirect_uri: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        enabled: Optional[bool] = None,
        group_id: Optional[str] = None
    ):
        self.redirect_uri = redirect_uri
        self.display_name = display_name
        self.description = description
        self.enabled = enabled
        self.group_id = group_id


@attr.s(auto_attribs=True, init=False)
class WriteOIDCConfig(model.Model):
    """
        Dynamic writeable type for OIDCConfig removes:
    can, default_new_user_groups, default_new_user_roles, groups, modified_at, modified_by, test_slug, user_attributes, url

        Attributes:
            alternate_email_login_allowed: Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.
            audience: OpenID Provider Audience
            auth_requires_role: Users will not be allowed to login at all unless a role for them is found in OIDC if set to true
            authorization_endpoint: OpenID Provider Authorization Url
            default_new_user_group_ids: (Write-Only) Array of ids of groups that will be applied to new users the first time they login via OIDC
            default_new_user_role_ids: (Write-Only) Array of ids of roles that will be applied to new users the first time they login via OIDC
            enabled: Enable/Disable OIDC authentication for the server
            groups_attribute: Name of user record attributes used to indicate groups. Used when 'groups_finder_type' is set to 'grouped_attribute_values'
            groups_with_role_ids: (Read/Write) Array of mappings between OIDC Groups and arrays of Looker Role ids
            identifier: Relying Party Identifier (provided by OpenID Provider)
            issuer: OpenID Provider Issuer
            new_user_migration_types: Merge first-time oidc login to existing user account by email addresses. When a user logs in for the first time via oidc this option will connect this user into their existing account by finding the account with a matching email address by testing the given types of credentials for existing users. Otherwise a new user account will be created for the user. This list (if provided) must be a comma separated list of string like 'email,ldap,google'
            scopes: Array of scopes to request.
            secret: (Write-Only) Relying Party Secret (provided by OpenID Provider)
            set_roles_from_groups: Set user roles in Looker based on groups from OIDC
            token_endpoint: OpenID Provider Token Url
            user_attribute_map_email: Name of user record attributes used to indicate email address field
            user_attribute_map_first_name: Name of user record attributes used to indicate first name
            user_attribute_map_last_name: Name of user record attributes used to indicate last name
            user_attributes_with_ids: (Read/Write) Array of mappings between OIDC User Attributes and arrays of Looker User Attribute ids
            userinfo_endpoint: OpenID Provider User Information Url
            allow_normal_group_membership: Allow OIDC auth'd users to be members of non-reflected Looker groups. If 'false', user will be removed from non-reflected groups on login.
            allow_roles_from_normal_groups: OIDC auth'd users will inherit roles from non-reflected Looker groups.
            allow_direct_roles: Allows roles to be directly assigned to OIDC auth'd users.
    """

    alternate_email_login_allowed: Optional[bool] = None
    audience: Optional[str] = None
    auth_requires_role: Optional[bool] = None
    authorization_endpoint: Optional[str] = None
    default_new_user_group_ids: Optional[Sequence[str]] = None
    default_new_user_role_ids: Optional[Sequence[str]] = None
    enabled: Optional[bool] = None
    groups_attribute: Optional[str] = None
    groups_with_role_ids: Optional[Sequence["OIDCGroupWrite"]] = None
    identifier: Optional[str] = None
    issuer: Optional[str] = None
    new_user_migration_types: Optional[str] = None
    scopes: Optional[Sequence[str]] = None
    secret: Optional[str] = None
    set_roles_from_groups: Optional[bool] = None
    token_endpoint: Optional[str] = None
    user_attribute_map_email: Optional[str] = None
    user_attribute_map_first_name: Optional[str] = None
    user_attribute_map_last_name: Optional[str] = None
    user_attributes_with_ids: Optional[Sequence["OIDCUserAttributeWrite"]] = None
    userinfo_endpoint: Optional[str] = None
    allow_normal_group_membership: Optional[bool] = None
    allow_roles_from_normal_groups: Optional[bool] = None
    allow_direct_roles: Optional[bool] = None

    def __init__(
        self,
        *,
        alternate_email_login_allowed: Optional[bool] = None,
        audience: Optional[str] = None,
        auth_requires_role: Optional[bool] = None,
        authorization_endpoint: Optional[str] = None,
        default_new_user_group_ids: Optional[Sequence[str]] = None,
        default_new_user_role_ids: Optional[Sequence[str]] = None,
        enabled: Optional[bool] = None,
        groups_attribute: Optional[str] = None,
        groups_with_role_ids: Optional[Sequence["OIDCGroupWrite"]] = None,
        identifier: Optional[str] = None,
        issuer: Optional[str] = None,
        new_user_migration_types: Optional[str] = None,
        scopes: Optional[Sequence[str]] = None,
        secret: Optional[str] = None,
        set_roles_from_groups: Optional[bool] = None,
        token_endpoint: Optional[str] = None,
        user_attribute_map_email: Optional[str] = None,
        user_attribute_map_first_name: Optional[str] = None,
        user_attribute_map_last_name: Optional[str] = None,
        user_attributes_with_ids: Optional[Sequence["OIDCUserAttributeWrite"]] = None,
        userinfo_endpoint: Optional[str] = None,
        allow_normal_group_membership: Optional[bool] = None,
        allow_roles_from_normal_groups: Optional[bool] = None,
        allow_direct_roles: Optional[bool] = None
    ):
        self.alternate_email_login_allowed = alternate_email_login_allowed
        self.audience = audience
        self.auth_requires_role = auth_requires_role
        self.authorization_endpoint = authorization_endpoint
        self.default_new_user_group_ids = default_new_user_group_ids
        self.default_new_user_role_ids = default_new_user_role_ids
        self.enabled = enabled
        self.groups_attribute = groups_attribute
        self.groups_with_role_ids = groups_with_role_ids
        self.identifier = identifier
        self.issuer = issuer
        self.new_user_migration_types = new_user_migration_types
        self.scopes = scopes
        self.secret = secret
        self.set_roles_from_groups = set_roles_from_groups
        self.token_endpoint = token_endpoint
        self.user_attribute_map_email = user_attribute_map_email
        self.user_attribute_map_first_name = user_attribute_map_first_name
        self.user_attribute_map_last_name = user_attribute_map_last_name
        self.user_attributes_with_ids = user_attributes_with_ids
        self.userinfo_endpoint = userinfo_endpoint
        self.allow_normal_group_membership = allow_normal_group_membership
        self.allow_roles_from_normal_groups = allow_roles_from_normal_groups
        self.allow_direct_roles = allow_direct_roles


@attr.s(auto_attribs=True, init=False)
class WritePasswordConfig(model.Model):
    """
        Dynamic writeable type for PasswordConfig removes:
    can

        Attributes:
            min_length: Minimum number of characters required for a new password.  Must be between 7 and 100
            require_numeric: Require at least one numeric character
            require_upperlower: Require at least one uppercase and one lowercase letter
            require_special: Require at least one special character
    """

    min_length: Optional[int] = None
    require_numeric: Optional[bool] = None
    require_upperlower: Optional[bool] = None
    require_special: Optional[bool] = None

    def __init__(
        self,
        *,
        min_length: Optional[int] = None,
        require_numeric: Optional[bool] = None,
        require_upperlower: Optional[bool] = None,
        require_special: Optional[bool] = None
    ):
        self.min_length = min_length
        self.require_numeric = require_numeric
        self.require_upperlower = require_upperlower
        self.require_special = require_special


@attr.s(auto_attribs=True, init=False)
class WritePermissionSet(model.Model):
    """
        Dynamic writeable type for PermissionSet removes:
    can, all_access, built_in, id, url

        Attributes:
            name: Name of PermissionSet
            permissions:
    """

    name: Optional[str] = None
    permissions: Optional[Sequence[str]] = None

    def __init__(
        self, *, name: Optional[str] = None, permissions: Optional[Sequence[str]] = None
    ):
        self.name = name
        self.permissions = permissions


@attr.s(auto_attribs=True, init=False)
class WritePrivatelabelConfiguration(model.Model):
    """
        Dynamic writeable type for PrivatelabelConfiguration removes:
    logo_url, favicon_url

        Attributes:
            logo_file: Customer logo image. Expected base64 encoded data (write-only)
            favicon_file: Custom favicon image. Expected base64 encoded data (write-only)
            default_title: Default page title
            show_help_menu: Boolean to toggle showing help menus
            show_docs: Boolean to toggle showing docs
            show_email_sub_options: Boolean to toggle showing email subscription options.
            allow_looker_mentions: Boolean to toggle mentions of Looker in emails
            allow_looker_links: Boolean to toggle links to Looker in emails
            custom_welcome_email_advanced: Allow subject line and email heading customization in customized emails”
            setup_mentions: Remove the word Looker from appearing in the account setup page
            alerts_logo: Remove Looker logo from Alerts
            alerts_links: Remove Looker links from Alerts
            folders_mentions: Remove Looker mentions in home folder page when you don’t have any items saved
    """

    logo_file: Optional[str] = None
    favicon_file: Optional[str] = None
    default_title: Optional[str] = None
    show_help_menu: Optional[bool] = None
    show_docs: Optional[bool] = None
    show_email_sub_options: Optional[bool] = None
    allow_looker_mentions: Optional[bool] = None
    allow_looker_links: Optional[bool] = None
    custom_welcome_email_advanced: Optional[bool] = None
    setup_mentions: Optional[bool] = None
    alerts_logo: Optional[bool] = None
    alerts_links: Optional[bool] = None
    folders_mentions: Optional[bool] = None

    def __init__(
        self,
        *,
        logo_file: Optional[str] = None,
        favicon_file: Optional[str] = None,
        default_title: Optional[str] = None,
        show_help_menu: Optional[bool] = None,
        show_docs: Optional[bool] = None,
        show_email_sub_options: Optional[bool] = None,
        allow_looker_mentions: Optional[bool] = None,
        allow_looker_links: Optional[bool] = None,
        custom_welcome_email_advanced: Optional[bool] = None,
        setup_mentions: Optional[bool] = None,
        alerts_logo: Optional[bool] = None,
        alerts_links: Optional[bool] = None,
        folders_mentions: Optional[bool] = None
    ):
        self.logo_file = logo_file
        self.favicon_file = favicon_file
        self.default_title = default_title
        self.show_help_menu = show_help_menu
        self.show_docs = show_docs
        self.show_email_sub_options = show_email_sub_options
        self.allow_looker_mentions = allow_looker_mentions
        self.allow_looker_links = allow_looker_links
        self.custom_welcome_email_advanced = custom_welcome_email_advanced
        self.setup_mentions = setup_mentions
        self.alerts_logo = alerts_logo
        self.alerts_links = alerts_links
        self.folders_mentions = folders_mentions


@attr.s(auto_attribs=True, init=False)
class WriteProject(model.Model):
    """
        Dynamic writeable type for Project removes:
    can, id, uses_git, is_example

        Attributes:
            name: Project display name
            git_remote_url: Git remote repository url
            git_username: Git username for HTTPS authentication. (For production only, if using user attributes.)
            git_password: (Write-Only) Git password for HTTPS authentication. (For production only, if using user attributes.)
            git_production_branch_name: Git production branch name. Defaults to master. Supported only in Looker 21.0 and higher.
            use_git_cookie_auth: If true, the project uses a git cookie for authentication.
            git_username_user_attribute: User attribute name for username in per-user HTTPS authentication.
            git_password_user_attribute: User attribute name for password in per-user HTTPS authentication.
            git_service_name: Name of the git service provider
            git_application_server_http_port: Port that HTTP(S) application server is running on (for PRs, file browsing, etc.)
            git_application_server_http_scheme: Scheme that is running on application server (for PRs, file browsing, etc.)
            deploy_secret: (Write-Only) Optional secret token with which to authenticate requests to the webhook deploy endpoint. If not set, endpoint is unauthenticated.
            unset_deploy_secret: (Write-Only) When true, unsets the deploy secret to allow unauthenticated access to the webhook deploy endpoint.
            pull_request_mode: The git pull request policy for this project. Valid values are: "off", "links", "recommended", "required".
            validation_required: Validation policy: If true, the project must pass validation checks before project changes can be committed to the git repository
            git_release_mgmt_enabled: If true, advanced git release management is enabled for this project
            allow_warnings: Validation policy: If true, the project can be committed with warnings when `validation_required` is true. (`allow_warnings` does nothing if `validation_required` is false).
            dependency_status: Status of dependencies in your manifest & lockfile
    """

    name: Optional[str] = None
    git_remote_url: Optional[str] = None
    git_username: Optional[str] = None
    git_password: Optional[str] = None
    git_production_branch_name: Optional[str] = None
    use_git_cookie_auth: Optional[bool] = None
    git_username_user_attribute: Optional[str] = None
    git_password_user_attribute: Optional[str] = None
    git_service_name: Optional[str] = None
    git_application_server_http_port: Optional[int] = None
    git_application_server_http_scheme: Optional[str] = None
    deploy_secret: Optional[str] = None
    unset_deploy_secret: Optional[bool] = None
    pull_request_mode: Optional["PullRequestMode"] = None
    validation_required: Optional[bool] = None
    git_release_mgmt_enabled: Optional[bool] = None
    allow_warnings: Optional[bool] = None
    dependency_status: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        git_remote_url: Optional[str] = None,
        git_username: Optional[str] = None,
        git_password: Optional[str] = None,
        git_production_branch_name: Optional[str] = None,
        use_git_cookie_auth: Optional[bool] = None,
        git_username_user_attribute: Optional[str] = None,
        git_password_user_attribute: Optional[str] = None,
        git_service_name: Optional[str] = None,
        git_application_server_http_port: Optional[int] = None,
        git_application_server_http_scheme: Optional[str] = None,
        deploy_secret: Optional[str] = None,
        unset_deploy_secret: Optional[bool] = None,
        pull_request_mode: Optional["PullRequestMode"] = None,
        validation_required: Optional[bool] = None,
        git_release_mgmt_enabled: Optional[bool] = None,
        allow_warnings: Optional[bool] = None,
        dependency_status: Optional[str] = None
    ):
        self.name = name
        self.git_remote_url = git_remote_url
        self.git_username = git_username
        self.git_password = git_password
        self.git_production_branch_name = git_production_branch_name
        self.use_git_cookie_auth = use_git_cookie_auth
        self.git_username_user_attribute = git_username_user_attribute
        self.git_password_user_attribute = git_password_user_attribute
        self.git_service_name = git_service_name
        self.git_application_server_http_port = git_application_server_http_port
        self.git_application_server_http_scheme = git_application_server_http_scheme
        self.deploy_secret = deploy_secret
        self.unset_deploy_secret = unset_deploy_secret
        self.pull_request_mode = pull_request_mode
        self.validation_required = validation_required
        self.git_release_mgmt_enabled = git_release_mgmt_enabled
        self.allow_warnings = allow_warnings
        self.dependency_status = dependency_status


@attr.s(auto_attribs=True, init=False)
class WriteQuery(model.Model):
    """
        Dynamic writeable type for Query removes:
    can, id, slug, share_url, expanded_share_url, url, has_table_calculations

        Attributes:
            model: Model
            view: Explore Name
            fields: Fields
            pivots: Pivots
            fill_fields: Fill Fields
            filters: Filters
            filter_expression: Filter Expression
            sorts: Sorting for the query results. Use the format `["view.field", ...]` to sort on fields in ascending order. Use the format `["view.field desc", ...]` to sort on fields in descending order. Use `["__UNSORTED__"]` (2 underscores before and after) to disable sorting entirely. Empty sorts `[]` will trigger a default sort.
            limit: Limit
            column_limit: Column Limit
            total: Total
            row_total: Raw Total
            subtotals: Fields on which to run subtotals
            vis_config: Visualization configuration properties. These properties are typically opaque and differ based on the type of visualization used. There is no specified set of allowed keys. The values can be any type supported by JSON. A "type" key with a string value is often present, and is used by Looker to determine which visualization to present. Visualizations ignore unknown vis_config properties.
            filter_config: The filter_config represents the state of the filter UI on the explore page for a given query. When running a query via the Looker UI, this parameter takes precedence over "filters". When creating a query or modifying an existing query, "filter_config" should be set to null. Setting it to any other value could cause unexpected filtering behavior. The format should be considered opaque.
            visible_ui_sections: Visible UI Sections
            dynamic_fields: Dynamic Fields
            client_id: Client Id: used to generate shortened explore URLs. If set by client, must be a unique 22 character alphanumeric string. Otherwise one will be generated.
            query_timezone: Query Timezone
    """

    model: str
    view: str
    fields: Optional[Sequence[str]] = None
    pivots: Optional[Sequence[str]] = None
    fill_fields: Optional[Sequence[str]] = None
    filters: Optional[MutableMapping[str, Any]] = None
    filter_expression: Optional[str] = None
    sorts: Optional[Sequence[str]] = None
    limit: Optional[str] = None
    column_limit: Optional[str] = None
    total: Optional[bool] = None
    row_total: Optional[str] = None
    subtotals: Optional[Sequence[str]] = None
    vis_config: Optional[MutableMapping[str, Any]] = None
    filter_config: Optional[MutableMapping[str, Any]] = None
    visible_ui_sections: Optional[str] = None
    dynamic_fields: Optional[str] = None
    client_id: Optional[str] = None
    query_timezone: Optional[str] = None

    def __init__(
        self,
        *,
        model: str,
        view: str,
        fields: Optional[Sequence[str]] = None,
        pivots: Optional[Sequence[str]] = None,
        fill_fields: Optional[Sequence[str]] = None,
        filters: Optional[MutableMapping[str, Any]] = None,
        filter_expression: Optional[str] = None,
        sorts: Optional[Sequence[str]] = None,
        limit: Optional[str] = None,
        column_limit: Optional[str] = None,
        total: Optional[bool] = None,
        row_total: Optional[str] = None,
        subtotals: Optional[Sequence[str]] = None,
        vis_config: Optional[MutableMapping[str, Any]] = None,
        filter_config: Optional[MutableMapping[str, Any]] = None,
        visible_ui_sections: Optional[str] = None,
        dynamic_fields: Optional[str] = None,
        client_id: Optional[str] = None,
        query_timezone: Optional[str] = None
    ):
        self.model = model
        self.view = view
        self.fields = fields
        self.pivots = pivots
        self.fill_fields = fill_fields
        self.filters = filters
        self.filter_expression = filter_expression
        self.sorts = sorts
        self.limit = limit
        self.column_limit = column_limit
        self.total = total
        self.row_total = row_total
        self.subtotals = subtotals
        self.vis_config = vis_config
        self.filter_config = filter_config
        self.visible_ui_sections = visible_ui_sections
        self.dynamic_fields = dynamic_fields
        self.client_id = client_id
        self.query_timezone = query_timezone


@attr.s(auto_attribs=True, init=False)
class WriteRepositoryCredential(model.Model):
    """
        Dynamic writeable type for RepositoryCredential removes:
    can, id, root_project_id, remote_url, is_configured

        Attributes:
            git_username: Git username for HTTPS authentication.
            git_password: (Write-Only) Git password for HTTPS authentication.
            ssh_public_key: Public deploy key for SSH authentication.
    """

    git_username: Optional[str] = None
    git_password: Optional[str] = None
    ssh_public_key: Optional[str] = None

    def __init__(
        self,
        *,
        git_username: Optional[str] = None,
        git_password: Optional[str] = None,
        ssh_public_key: Optional[str] = None
    ):
        self.git_username = git_username
        self.git_password = git_password
        self.ssh_public_key = ssh_public_key


@attr.s(auto_attribs=True, init=False)
class WriteResultMakerWithIdVisConfigAndDynamicFields(model.Model):
    """
        Dynamic writeable type for ResultMakerWithIdVisConfigAndDynamicFields removes:
    id, dynamic_fields, filterables, sorts, merge_result_id, total, query_id, sql_query_id, vis_config

        Attributes:
            query: Dynamic writeable type for Query removes:
    can, id, slug, share_url, expanded_share_url, url, has_table_calculations
    """

    query: Optional["WriteQuery"] = None

    def __init__(self, *, query: Optional["WriteQuery"] = None):
        self.query = query


@attr.s(auto_attribs=True, init=False)
class WriteRole(model.Model):
    """
        Dynamic writeable type for Role removes:
    can, id, url, users_url

        Attributes:
            name: Name of Role
            permission_set: Dynamic writeable type for PermissionSet removes:
    can, all_access, built_in, id, url
            permission_set_id: (Write-Only) Id of permission set
            model_set: Dynamic writeable type for ModelSet removes:
    can, all_access, built_in, id, url
            model_set_id: (Write-Only) Id of model set
    """

    name: Optional[str] = None
    permission_set: Optional["WritePermissionSet"] = None
    permission_set_id: Optional[str] = None
    model_set: Optional["WriteModelSet"] = None
    model_set_id: Optional[str] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        permission_set: Optional["WritePermissionSet"] = None,
        permission_set_id: Optional[str] = None,
        model_set: Optional["WriteModelSet"] = None,
        model_set_id: Optional[str] = None
    ):
        self.name = name
        self.permission_set = permission_set
        self.permission_set_id = permission_set_id
        self.model_set = model_set
        self.model_set_id = model_set_id


@attr.s(auto_attribs=True, init=False)
class WriteSamlConfig(model.Model):
    """
        Dynamic writeable type for SamlConfig removes:
    can, test_slug, modified_at, modified_by, default_new_user_roles, default_new_user_groups, groups, user_attributes, url

        Attributes:
            enabled: Enable/Disable Saml authentication for the server
            idp_cert: Identity Provider Certificate (provided by IdP)
            idp_url: Identity Provider Url (provided by IdP)
            idp_issuer: Identity Provider Issuer (provided by IdP)
            idp_audience: Identity Provider Audience (set in IdP config). Optional in Looker. Set this only if you want Looker to validate the audience value returned by the IdP.
            allowed_clock_drift: Count of seconds of clock drift to allow when validating timestamps of assertions.
            user_attribute_map_email: Name of user record attributes used to indicate email address field
            user_attribute_map_first_name: Name of user record attributes used to indicate first name
            user_attribute_map_last_name: Name of user record attributes used to indicate last name
            new_user_migration_types: Merge first-time saml login to existing user account by email addresses. When a user logs in for the first time via saml this option will connect this user into their existing account by finding the account with a matching email address by testing the given types of credentials for existing users. Otherwise a new user account will be created for the user. This list (if provided) must be a comma separated list of string like 'email,ldap,google'
            alternate_email_login_allowed: Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.
            default_new_user_role_ids: (Write-Only) Array of ids of roles that will be applied to new users the first time they login via Saml
            default_new_user_group_ids: (Write-Only) Array of ids of groups that will be applied to new users the first time they login via Saml
            set_roles_from_groups: Set user roles in Looker based on groups from Saml
            groups_attribute: Name of user record attributes used to indicate groups. Used when 'groups_finder_type' is set to 'grouped_attribute_values'
            groups_with_role_ids: (Read/Write) Array of mappings between Saml Groups and arrays of Looker Role ids
            auth_requires_role: Users will not be allowed to login at all unless a role for them is found in Saml if set to true
            user_attributes_with_ids: (Read/Write) Array of mappings between Saml User Attributes and arrays of Looker User Attribute ids
            groups_finder_type: Identifier for a strategy for how Looker will find groups in the SAML response. One of ['grouped_attribute_values', 'individual_attributes']
            groups_member_value: Value for group attribute used to indicate membership. Used when 'groups_finder_type' is set to 'individual_attributes'
            bypass_login_page: Bypass the login page when user authentication is required. Redirect to IdP immediately instead.
            allow_normal_group_membership: Allow SAML auth'd users to be members of non-reflected Looker groups. If 'false', user will be removed from non-reflected groups on login.
            allow_roles_from_normal_groups: SAML auth'd users will inherit roles from non-reflected Looker groups.
            allow_direct_roles: Allows roles to be directly assigned to SAML auth'd users.
    """

    enabled: Optional[bool] = None
    idp_cert: Optional[str] = None
    idp_url: Optional[str] = None
    idp_issuer: Optional[str] = None
    idp_audience: Optional[str] = None
    allowed_clock_drift: Optional[int] = None
    user_attribute_map_email: Optional[str] = None
    user_attribute_map_first_name: Optional[str] = None
    user_attribute_map_last_name: Optional[str] = None
    new_user_migration_types: Optional[str] = None
    alternate_email_login_allowed: Optional[bool] = None
    default_new_user_role_ids: Optional[Sequence[str]] = None
    default_new_user_group_ids: Optional[Sequence[str]] = None
    set_roles_from_groups: Optional[bool] = None
    groups_attribute: Optional[str] = None
    groups_with_role_ids: Optional[Sequence["SamlGroupWrite"]] = None
    auth_requires_role: Optional[bool] = None
    user_attributes_with_ids: Optional[Sequence["SamlUserAttributeWrite"]] = None
    groups_finder_type: Optional[str] = None
    groups_member_value: Optional[str] = None
    bypass_login_page: Optional[bool] = None
    allow_normal_group_membership: Optional[bool] = None
    allow_roles_from_normal_groups: Optional[bool] = None
    allow_direct_roles: Optional[bool] = None

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        idp_cert: Optional[str] = None,
        idp_url: Optional[str] = None,
        idp_issuer: Optional[str] = None,
        idp_audience: Optional[str] = None,
        allowed_clock_drift: Optional[int] = None,
        user_attribute_map_email: Optional[str] = None,
        user_attribute_map_first_name: Optional[str] = None,
        user_attribute_map_last_name: Optional[str] = None,
        new_user_migration_types: Optional[str] = None,
        alternate_email_login_allowed: Optional[bool] = None,
        default_new_user_role_ids: Optional[Sequence[str]] = None,
        default_new_user_group_ids: Optional[Sequence[str]] = None,
        set_roles_from_groups: Optional[bool] = None,
        groups_attribute: Optional[str] = None,
        groups_with_role_ids: Optional[Sequence["SamlGroupWrite"]] = None,
        auth_requires_role: Optional[bool] = None,
        user_attributes_with_ids: Optional[Sequence["SamlUserAttributeWrite"]] = None,
        groups_finder_type: Optional[str] = None,
        groups_member_value: Optional[str] = None,
        bypass_login_page: Optional[bool] = None,
        allow_normal_group_membership: Optional[bool] = None,
        allow_roles_from_normal_groups: Optional[bool] = None,
        allow_direct_roles: Optional[bool] = None
    ):
        self.enabled = enabled
        self.idp_cert = idp_cert
        self.idp_url = idp_url
        self.idp_issuer = idp_issuer
        self.idp_audience = idp_audience
        self.allowed_clock_drift = allowed_clock_drift
        self.user_attribute_map_email = user_attribute_map_email
        self.user_attribute_map_first_name = user_attribute_map_first_name
        self.user_attribute_map_last_name = user_attribute_map_last_name
        self.new_user_migration_types = new_user_migration_types
        self.alternate_email_login_allowed = alternate_email_login_allowed
        self.default_new_user_role_ids = default_new_user_role_ids
        self.default_new_user_group_ids = default_new_user_group_ids
        self.set_roles_from_groups = set_roles_from_groups
        self.groups_attribute = groups_attribute
        self.groups_with_role_ids = groups_with_role_ids
        self.auth_requires_role = auth_requires_role
        self.user_attributes_with_ids = user_attributes_with_ids
        self.groups_finder_type = groups_finder_type
        self.groups_member_value = groups_member_value
        self.bypass_login_page = bypass_login_page
        self.allow_normal_group_membership = allow_normal_group_membership
        self.allow_roles_from_normal_groups = allow_roles_from_normal_groups
        self.allow_direct_roles = allow_direct_roles


@attr.s(auto_attribs=True, init=False)
class WriteScheduledPlan(model.Model):
    """
        Dynamic writeable type for ScheduledPlan removes:
    id, created_at, updated_at, title, user, next_run_at, last_run_at, can

        Attributes:
            name: Name of this scheduled plan
            user_id: User Id which owns this scheduled plan
            run_as_recipient: Whether schedule is run as recipient (only applicable for email recipients)
            enabled: Whether the ScheduledPlan is enabled
            look_id: Id of a look
            dashboard_id: Id of a dashboard
            lookml_dashboard_id: Id of a LookML dashboard
            filters_string: Query string to run look or dashboard with
            dashboard_filters: (DEPRECATED) Alias for filters_string field
            require_results: Delivery should occur if running the dashboard or look returns results
            require_no_results: Delivery should occur if the dashboard look does not return results
            require_change: Delivery should occur if data have changed since the last run
            send_all_results: Will run an unlimited query and send all results.
            crontab: Vixie-Style crontab specification when to run
            datagroup: Name of a datagroup; if specified will run when datagroup triggered (can't be used with cron string)
            timezone: Timezone for interpreting the specified crontab (default is Looker instance timezone)
            query_id: Query id
            scheduled_plan_destination: Scheduled plan destinations
            run_once: Whether the plan in question should only be run once (usually for testing)
            include_links: Whether links back to Looker should be included in this ScheduledPlan
            pdf_paper_size: The size of paper the PDF should be formatted to fit. Valid values are: "letter", "legal", "tabloid", "a0", "a1", "a2", "a3", "a4", "a5".
            pdf_landscape: Whether the PDF should be formatted for landscape orientation
            embed: Whether this schedule is in an embed context or not
            color_theme: Color scheme of the dashboard if applicable
            long_tables: Whether or not to expand table vis to full length
            inline_table_width: The pixel width at which we render the inline table visualizations
    """

    name: Optional[str] = None
    user_id: Optional[str] = None
    run_as_recipient: Optional[bool] = None
    enabled: Optional[bool] = None
    look_id: Optional[str] = None
    dashboard_id: Optional[str] = None
    lookml_dashboard_id: Optional[str] = None
    filters_string: Optional[str] = None
    dashboard_filters: Optional[str] = None
    require_results: Optional[bool] = None
    require_no_results: Optional[bool] = None
    require_change: Optional[bool] = None
    send_all_results: Optional[bool] = None
    crontab: Optional[str] = None
    datagroup: Optional[str] = None
    timezone: Optional[str] = None
    query_id: Optional[str] = None
    scheduled_plan_destination: Optional[Sequence["ScheduledPlanDestination"]] = None
    run_once: Optional[bool] = None
    include_links: Optional[bool] = None
    pdf_paper_size: Optional[str] = None
    pdf_landscape: Optional[bool] = None
    embed: Optional[bool] = None
    color_theme: Optional[str] = None
    long_tables: Optional[bool] = None
    inline_table_width: Optional[int] = None

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        user_id: Optional[str] = None,
        run_as_recipient: Optional[bool] = None,
        enabled: Optional[bool] = None,
        look_id: Optional[str] = None,
        dashboard_id: Optional[str] = None,
        lookml_dashboard_id: Optional[str] = None,
        filters_string: Optional[str] = None,
        dashboard_filters: Optional[str] = None,
        require_results: Optional[bool] = None,
        require_no_results: Optional[bool] = None,
        require_change: Optional[bool] = None,
        send_all_results: Optional[bool] = None,
        crontab: Optional[str] = None,
        datagroup: Optional[str] = None,
        timezone: Optional[str] = None,
        query_id: Optional[str] = None,
        scheduled_plan_destination: Optional[
            Sequence["ScheduledPlanDestination"]
        ] = None,
        run_once: Optional[bool] = None,
        include_links: Optional[bool] = None,
        pdf_paper_size: Optional[str] = None,
        pdf_landscape: Optional[bool] = None,
        embed: Optional[bool] = None,
        color_theme: Optional[str] = None,
        long_tables: Optional[bool] = None,
        inline_table_width: Optional[int] = None
    ):
        self.name = name
        self.user_id = user_id
        self.run_as_recipient = run_as_recipient
        self.enabled = enabled
        self.look_id = look_id
        self.dashboard_id = dashboard_id
        self.lookml_dashboard_id = lookml_dashboard_id
        self.filters_string = filters_string
        self.dashboard_filters = dashboard_filters
        self.require_results = require_results
        self.require_no_results = require_no_results
        self.require_change = require_change
        self.send_all_results = send_all_results
        self.crontab = crontab
        self.datagroup = datagroup
        self.timezone = timezone
        self.query_id = query_id
        self.scheduled_plan_destination = scheduled_plan_destination
        self.run_once = run_once
        self.include_links = include_links
        self.pdf_paper_size = pdf_paper_size
        self.pdf_landscape = pdf_landscape
        self.embed = embed
        self.color_theme = color_theme
        self.long_tables = long_tables
        self.inline_table_width = inline_table_width


@attr.s(auto_attribs=True, init=False)
class WriteSessionConfig(model.Model):
    """
        Dynamic writeable type for SessionConfig removes:
    can

        Attributes:
            allow_persistent_sessions: Allow users to have persistent sessions when they login
            session_minutes: Number of minutes for user sessions.  Must be between 5 and 43200
            unlimited_sessions_per_user: Allow users to have an unbounded number of concurrent sessions (otherwise, users will be limited to only one session at a time).
            use_inactivity_based_logout: Enforce session logout for sessions that are inactive for 15 minutes.
            track_session_location: Track location of session when user logs in.
    """

    allow_persistent_sessions: Optional[bool] = None
    session_minutes: Optional[int] = None
    unlimited_sessions_per_user: Optional[bool] = None
    use_inactivity_based_logout: Optional[bool] = None
    track_session_location: Optional[bool] = None

    def __init__(
        self,
        *,
        allow_persistent_sessions: Optional[bool] = None,
        session_minutes: Optional[int] = None,
        unlimited_sessions_per_user: Optional[bool] = None,
        use_inactivity_based_logout: Optional[bool] = None,
        track_session_location: Optional[bool] = None
    ):
        self.allow_persistent_sessions = allow_persistent_sessions
        self.session_minutes = session_minutes
        self.unlimited_sessions_per_user = unlimited_sessions_per_user
        self.use_inactivity_based_logout = use_inactivity_based_logout
        self.track_session_location = track_session_location


@attr.s(auto_attribs=True, init=False)
class WriteSetting(model.Model):
    """
        Dynamic writeable type for Setting

        Attributes:
            extension_framework_enabled: Toggle extension framework on or off
            extension_load_url_enabled: (DEPRECATED) Toggle extension extension load url on or off. Do not use. This is temporary setting that will eventually become a noop and subsequently deleted.
            marketplace_auto_install_enabled: Toggle marketplace auto install on or off. Note that auto install only runs if marketplace is enabled.
            marketplace_enabled: Toggle marketplace on or off
            privatelabel_configuration: Dynamic writeable type for PrivatelabelConfiguration removes:
    logo_url, favicon_url
            custom_welcome_email:
            onboarding_enabled: Toggle onboarding on or off
    """

    extension_framework_enabled: Optional[bool] = None
    extension_load_url_enabled: Optional[bool] = None
    marketplace_auto_install_enabled: Optional[bool] = None
    marketplace_enabled: Optional[bool] = None
    privatelabel_configuration: Optional["WritePrivatelabelConfiguration"] = None
    custom_welcome_email: Optional["CustomWelcomeEmail"] = None
    onboarding_enabled: Optional[bool] = None

    def __init__(
        self,
        *,
        extension_framework_enabled: Optional[bool] = None,
        extension_load_url_enabled: Optional[bool] = None,
        marketplace_auto_install_enabled: Optional[bool] = None,
        marketplace_enabled: Optional[bool] = None,
        privatelabel_configuration: Optional["WritePrivatelabelConfiguration"] = None,
        custom_welcome_email: Optional["CustomWelcomeEmail"] = None,
        onboarding_enabled: Optional[bool] = None
    ):
        self.extension_framework_enabled = extension_framework_enabled
        self.extension_load_url_enabled = extension_load_url_enabled
        self.marketplace_auto_install_enabled = marketplace_auto_install_enabled
        self.marketplace_enabled = marketplace_enabled
        self.privatelabel_configuration = privatelabel_configuration
        self.custom_welcome_email = custom_welcome_email
        self.onboarding_enabled = onboarding_enabled


@attr.s(auto_attribs=True, init=False)
class WriteSshServer(model.Model):
    """
        Dynamic writeable type for SshServer removes:
    ssh_server_id, finger_print, sha_finger_print, public_key, status

        Attributes:
            ssh_server_name: The name to identify this SSH Server
            ssh_server_host: The hostname or ip address of the SSH Server
            ssh_server_port: The port to connect to on the SSH Server
            ssh_server_user: The username used to connect to the SSH Server
    """

    ssh_server_name: Optional[str] = None
    ssh_server_host: Optional[str] = None
    ssh_server_port: Optional[int] = None
    ssh_server_user: Optional[str] = None

    def __init__(
        self,
        *,
        ssh_server_name: Optional[str] = None,
        ssh_server_host: Optional[str] = None,
        ssh_server_port: Optional[int] = None,
        ssh_server_user: Optional[str] = None
    ):
        self.ssh_server_name = ssh_server_name
        self.ssh_server_host = ssh_server_host
        self.ssh_server_port = ssh_server_port
        self.ssh_server_user = ssh_server_user


@attr.s(auto_attribs=True, init=False)
class WriteSshTunnel(model.Model):
    """
        Dynamic writeable type for SshTunnel removes:
    tunnel_id, ssh_server_name, ssh_server_host, ssh_server_port, ssh_server_user, last_attempt, local_host_port, status

        Attributes:
            ssh_server_id: SSH Server ID
            database_host: Hostname or IP Address of the Database Server
            database_port: Port that the Database Server is listening on
    """

    ssh_server_id: Optional[str] = None
    database_host: Optional[str] = None
    database_port: Optional[int] = None

    def __init__(
        self,
        *,
        ssh_server_id: Optional[str] = None,
        database_host: Optional[str] = None,
        database_port: Optional[int] = None
    ):
        self.ssh_server_id = ssh_server_id
        self.database_host = database_host
        self.database_port = database_port


@attr.s(auto_attribs=True, init=False)
class WriteTheme(model.Model):
    """
        Dynamic writeable type for Theme removes:
    can, id

        Attributes:
            begin_at: Timestamp for when this theme becomes active. Null=always
            end_at: Timestamp for when this theme expires. Null=never
            name: Name of theme. Can only be alphanumeric and underscores.
            settings:
    """

    begin_at: Optional[datetime.datetime] = None
    end_at: Optional[datetime.datetime] = None
    name: Optional[str] = None
    settings: Optional["ThemeSettings"] = None

    def __init__(
        self,
        *,
        begin_at: Optional[datetime.datetime] = None,
        end_at: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        settings: Optional["ThemeSettings"] = None
    ):
        self.begin_at = begin_at
        self.end_at = end_at
        self.name = name
        self.settings = settings


@attr.s(auto_attribs=True, init=False)
class WriteUser(model.Model):
    """
        Dynamic writeable type for User removes:
    can, avatar_url, avatar_url_without_sizing, credentials_api3, credentials_embed, credentials_google, credentials_ldap, credentials_looker_openid, credentials_oidc, credentials_saml, credentials_totp, display_name, email, embed_group_space_id, group_ids, id, looker_versions, personal_folder_id, presumed_looker_employee, role_ids, sessions, verified_looker_employee, roles_externally_managed, allow_direct_roles, allow_normal_group_membership, allow_roles_from_normal_groups, embed_group_folder_id, url

        Attributes:
            credentials_email: Dynamic writeable type for CredentialsEmail removes:
    can, created_at, is_disabled, logged_in_at, password_reset_url, type, url, user_url
            first_name: First name
            home_folder_id: ID string for user's home folder
            is_disabled: Account has been disabled
            last_name: Last name
            locale: User's preferred locale. User locale takes precedence over Looker's system-wide default locale. Locale determines language of display strings and date and numeric formatting in API responses. Locale string must be a 2 letter language code or a combination of language code and region code: 'en' or 'en-US', for example.
            models_dir_validated: User's dev workspace has been checked for presence of applicable production projects
            ui_state: Per user dictionary of undocumented state information owned by the Looker UI.
    """

    credentials_email: Optional["WriteCredentialsEmail"] = None
    first_name: Optional[str] = None
    home_folder_id: Optional[str] = None
    is_disabled: Optional[bool] = None
    last_name: Optional[str] = None
    locale: Optional[str] = None
    models_dir_validated: Optional[bool] = None
    ui_state: Optional[MutableMapping[str, Any]] = None

    def __init__(
        self,
        *,
        credentials_email: Optional["WriteCredentialsEmail"] = None,
        first_name: Optional[str] = None,
        home_folder_id: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        last_name: Optional[str] = None,
        locale: Optional[str] = None,
        models_dir_validated: Optional[bool] = None,
        ui_state: Optional[MutableMapping[str, Any]] = None
    ):
        self.credentials_email = credentials_email
        self.first_name = first_name
        self.home_folder_id = home_folder_id
        self.is_disabled = is_disabled
        self.last_name = last_name
        self.locale = locale
        self.models_dir_validated = models_dir_validated
        self.ui_state = ui_state


@attr.s(auto_attribs=True, init=False)
class WriteUserAttribute(model.Model):
    """
        Dynamic writeable type for UserAttribute removes:
    can, id, is_system, is_permanent

        Attributes:
            name: Name of user attribute
            label: Human-friendly label for user attribute
            type: Type of user attribute ("string", "number", "datetime", "yesno", "zipcode")
            default_value: Default value for when no value is set on the user
            value_is_hidden: If true, users will not be able to view values of this attribute
            user_can_view: Non-admin users can see the values of their attributes and use them in filters
            user_can_edit: Users can change the value of this attribute for themselves
            hidden_value_domain_whitelist: Destinations to which a hidden attribute may be sent. Once set, cannot be edited.
    """

    name: str
    label: str
    type: str
    default_value: Optional[str] = None
    value_is_hidden: Optional[bool] = None
    user_can_view: Optional[bool] = None
    user_can_edit: Optional[bool] = None
    hidden_value_domain_whitelist: Optional[str] = None

    def __init__(
        self,
        *,
        name: str,
        label: str,
        type: str,
        default_value: Optional[str] = None,
        value_is_hidden: Optional[bool] = None,
        user_can_view: Optional[bool] = None,
        user_can_edit: Optional[bool] = None,
        hidden_value_domain_whitelist: Optional[str] = None
    ):
        self.name = name
        self.label = label
        self.type = type
        self.default_value = default_value
        self.value_is_hidden = value_is_hidden
        self.user_can_view = user_can_view
        self.user_can_edit = user_can_edit
        self.hidden_value_domain_whitelist = hidden_value_domain_whitelist


@attr.s(auto_attribs=True, init=False)
class WriteUserAttributeWithValue(model.Model):
    """
        Dynamic writeable type for UserAttributeWithValue removes:
    can, name, label, rank, user_id, user_can_edit, value_is_hidden, user_attribute_id, source, hidden_value_domain_whitelist

        Attributes:
            value: Value of attribute for user
    """

    value: Optional[str] = None

    def __init__(self, *, value: Optional[str] = None):
        self.value = value


@attr.s(auto_attribs=True, init=False)
class WriteWhitelabelConfiguration(model.Model):
    """
        Dynamic writeable type for WhitelabelConfiguration removes:
    id, logo_url, favicon_url

        Attributes:
            logo_file: Customer logo image. Expected base64 encoded data (write-only)
            favicon_file: Custom favicon image. Expected base64 encoded data (write-only)
            default_title: Default page title
            show_help_menu: Boolean to toggle showing help menus
            show_docs: Boolean to toggle showing docs
            show_email_sub_options: Boolean to toggle showing email subscription options.
            allow_looker_mentions: Boolean to toggle mentions of Looker in emails
            allow_looker_links: Boolean to toggle links to Looker in emails
            custom_welcome_email_advanced: Allow subject line and email heading customization in customized emails”
            setup_mentions: Remove the word Looker from appearing in the account setup page
            alerts_logo: Remove Looker logo from Alerts
            alerts_links: Remove Looker links from Alerts
            folders_mentions: Remove Looker mentions in home folder page when you don’t have any items saved
    """

    logo_file: Optional[str] = None
    favicon_file: Optional[str] = None
    default_title: Optional[str] = None
    show_help_menu: Optional[bool] = None
    show_docs: Optional[bool] = None
    show_email_sub_options: Optional[bool] = None
    allow_looker_mentions: Optional[bool] = None
    allow_looker_links: Optional[bool] = None
    custom_welcome_email_advanced: Optional[bool] = None
    setup_mentions: Optional[bool] = None
    alerts_logo: Optional[bool] = None
    alerts_links: Optional[bool] = None
    folders_mentions: Optional[bool] = None

    def __init__(
        self,
        *,
        logo_file: Optional[str] = None,
        favicon_file: Optional[str] = None,
        default_title: Optional[str] = None,
        show_help_menu: Optional[bool] = None,
        show_docs: Optional[bool] = None,
        show_email_sub_options: Optional[bool] = None,
        allow_looker_mentions: Optional[bool] = None,
        allow_looker_links: Optional[bool] = None,
        custom_welcome_email_advanced: Optional[bool] = None,
        setup_mentions: Optional[bool] = None,
        alerts_logo: Optional[bool] = None,
        alerts_links: Optional[bool] = None,
        folders_mentions: Optional[bool] = None
    ):
        self.logo_file = logo_file
        self.favicon_file = favicon_file
        self.default_title = default_title
        self.show_help_menu = show_help_menu
        self.show_docs = show_docs
        self.show_email_sub_options = show_email_sub_options
        self.allow_looker_mentions = allow_looker_mentions
        self.allow_looker_links = allow_looker_links
        self.custom_welcome_email_advanced = custom_welcome_email_advanced
        self.setup_mentions = setup_mentions
        self.alerts_logo = alerts_logo
        self.alerts_links = alerts_links
        self.folders_mentions = folders_mentions


import functools  # noqa:E402

forward_ref_structure_hook = functools.partial(
    sr.forward_ref_structure_hook, globals(), sr.converter40
)
sr.converter40.register_structure_hook_func(
    lambda t: t.__class__ is ForwardRef, forward_ref_structure_hook
)
translate_keys_structure_hook = functools.partial(
    sr.translate_keys_structure_hook, sr.converter40
)
sr.converter40.register_structure_hook(
    LookmlModelExploreJoins,  # type: ignore
    translate_keys_structure_hook,  # type:ignore
)
sr.converter40.register_structure_hook(
    SmtpSettings,  # type: ignore
    translate_keys_structure_hook,  # type:ignore
)
