# CALFEM for Python

## Documentation

[https://calfem-for-python.readthedocs.io/en/latest/](https://calfem-for-python.readthedocs.io/en/latest/)

## Manuals

Original manual: [manual.pdf](https://github.com/CALFEM/calfem-python/raw/master/manual.pdf)

Manual for with improved mesh: [manual-mesh-module.pdf](https://github.com/CALFEM/calfem-python/raw/master/manual-mesh-module.pdf)

## Background

The computer program CALFEM is written for the software MATLAB and is an interactive tool for learning the finite element method. CALFEM is an abbreviation
of ”Computer Aided Learning of the Finite Element Method” and been developed by the Division of Structural Mechanics at Lund University since the late 70’s.

## Why CALFEM for Python?

Unlike MATLAB, which have expensive licenses, Python is free to use and distribute both for personal and commercial use. This is the python version of CALFEM for scientific purposes/research.

## Installation

Install CALFEM for python using 
`pip install calfem-python`

## Dependencies

Mesh Generation Software: GMSH.
Install GMSH [here](http://gmsh.info/) and add to the PATH of your file or instead add contents of GMSH to the file folder.

## References

* Forsman, K, 2017. VisCon: Ett visualiseringsverktyg för tvådimensionell konsolidering i undervisningssammanhang - http://www.byggmek.lth.se/fileadmin/byggnadsmekanik/publications/tvsm5000/web5225.pdf 

* Edholm, A., 2013. Meshing and visualisation routines in the Python version of CALFEM.  - http://www.byggmek.lth.se/fileadmin/byggnadsmekanik/publications/tvsm5000/web5187.pdf 

* Ottosson, A., 2010. Implementation of CALFEM for Python - http://www.byggmek.lth.se/fileadmin/byggnadsmekanik/publications/tvsm5000/web5167.pdf 

* Eriksson, K, 2021. CALFEM Geometry Editor - An interactive geometry editor for CALFEM

* Åmand, A, 2022. Development of visualisation functions for CALFEM for Python


