import re
from .base import MarkerBase, MarkerWithEnd


class MarkerCommentBase(MarkerBase):
    pass


class CommentMarker(MarkerCommentBase):
    tag_head = "#"


class CommentBlockMarker(MarkerCommentBase, MarkerWithEnd):
    tag_head = "@#"

    def exec(self, env, command, marker_node, marker_set):
        return []


class CommentShebangMarker(MarkerCommentBase):
    tag_head = "#!"


class CommentConfigMarker(MarkerCommentBase):
    tag_head = "# config #"

    @classmethod
    def get_config_string(cls, content):
        match = re.search(f'(\n|^){cls.tag_head}', content)
        if match:
            begin = match.span()[-1]
            end = content.find('\n', begin)
            if end == -1:
                end = None
            return content[begin:end].strip()
