# AUTOGENERATED! DO NOT EDIT! File to edit: 99_test.ipynb (unless otherwise specified).

__all__ = ['test_grid_search_first_entries', 'test_grid_search_default_n', 'test_grid_search_default_load_test',
           'test_random_search_with_seed', 'test_random_search_default_n', 'test_random_search_default_load_test',
           'test_latin_hyper_cube_with_seed', 'test_latin_hyper_cube_default_n',
           'test_latin_hyper_cube_default_load_test', 'test_jittered_sampling_with_seed',
           'test_jittered_sampling_default_n', 'test_jittered_sampling_default_load_test',
           'test_multi_jittered_with_seed', 'test_multi_jittered_default_n', 'test_multi_jittered_default_load_test',
           'test_poisson_disk_with_seed', 'test_poisson_disk_default_n', 'test_poisson_disk_default_load_test']

# Comes from 00_core.ipynb, cell
def test_grid_search_first_entries():
    from .core import grid_search
    generator = grid_search(x_range=[0, 1], y_range=[0, 1])
    assert list(next(generator)) == [0.0, 1.0]
    assert list(next(generator)) == [1.0, 1.0]
    assert list(next(generator)) == [0.0, 0.0]
    assert list(next(generator)) == [1.0, 0.0]
    assert list(next(generator)) == [0.5, 1.0]


def test_grid_search_default_n():
    from .core import grid_search
    assert list(grid_search(x_range=[0, 1], y_range=[0, 1]))


def test_grid_search_default_load_test():
    from .core import grid_search
    from collections import deque

    deque(grid_search(x_range=[0, 1], y_range=[0, 1], n=1000), maxlen=0)
    assert True

# Comes from 00_core.ipynb, cell
def test_random_search_with_seed():
    from .core import random_search
    import numpy as np
    generator = random_search(x_range=[0, 1], y_range=[0, 1], seed=42)
    assert list(np.round(next(generator), 2)) == [0.77, 0.44]
    assert list(np.round(next(generator), 2)) == [0.86, 0.7]
    assert list(np.round(next(generator), 2)) == [0.09, 0.98]
    assert list(np.round(next(generator), 2)) == [0.76, 0.79]
    assert list(np.round(next(generator), 2)) == [0.13, 0.45]


def test_random_search_default_n():
    from .core import random_search
    assert list(random_search(x_range=[0, 1], y_range=[0, 1]))


def test_random_search_default_load_test():
    from .core import random_search
    from collections import deque

    deque(random_search(x_range=[0, 1], y_range=[0, 1], n=1000), maxlen=0)
    assert True

# Comes from 00_core.ipynb, cell
def test_latin_hyper_cube_with_seed():
    from .core import latin_hyper_cube
    import numpy as np
    generator = latin_hyper_cube(x_range=[0, 1], y_range=[0, 1], seed=42)
    assert list(np.round(next(generator), 2)) == [0.39, 0.43]
    assert list(np.round(next(generator), 2)) == [0.72, 0.85]
    assert list(np.round(next(generator), 2)) == [0.19, 0.16]
    assert list(np.round(next(generator), 2)) == [0.86, 0.51]
    assert list(np.round(next(generator), 2)) == [0.11, 0.  ]


def test_latin_hyper_cube_default_n():
    from .core import latin_hyper_cube
    assert list(latin_hyper_cube(x_range=[0, 1], y_range=[0, 1]))


def test_latin_hyper_cube_default_load_test():
    from .core import latin_hyper_cube
    from collections import deque

    deque(latin_hyper_cube(x_range=[0, 1], y_range=[0, 1], n=1000), maxlen=0)
    assert True

# Comes from 00_core.ipynb, cell
def test_jittered_sampling_with_seed():
    from .core import jittered_sampling
    import numpy as np
    generator = jittered_sampling(x_range=[0, 1], y_range=[0, 1], seed=42)
    assert list(np.round(next(generator), 2)) == [0.39, 0.33]
    assert list(np.round(next(generator), 2)) == [0.22, 0.52]
    assert list(np.round(next(generator), 2)) == [0.93, 0.01]
    assert list(np.round(next(generator), 2)) == [0.85, 0.92]
    assert list(np.round(next(generator), 2)) == [0.02, 0.15]


def test_jittered_sampling_default_n():
    from .core import jittered_sampling
    assert list(jittered_sampling(x_range=[0, 1], y_range=[0, 1]))


def test_jittered_sampling_default_load_test():
    from .core import jittered_sampling
    from collections import deque

    deque(jittered_sampling(x_range=[0, 1], y_range=[0, 1], n=1000), maxlen=0)
    assert True

# Comes from 00_core.ipynb, cell
def test_multi_jittered_with_seed():
    from .core import multi_jittered
    import numpy as np
    generator = multi_jittered(x_range=[0, 1], y_range=[0, 1], seed=42)
    assert list(np.round(next(generator), 2)) == [0.38, 0.75]
    assert list(np.round(next(generator), 2)) == [0.09, 0.81]
    assert list(np.round(next(generator), 2)) == [0.76, 0.94]
    assert list(np.round(next(generator), 2)) == [0.45, 0.43]
    assert list(np.round(next(generator), 2)) == [0.19, 0.51]


def test_multi_jittered_default_n():
    from .core import multi_jittered
    assert list(multi_jittered(x_range=[0, 1], y_range=[0, 1]))


def test_multi_jittered_default_load_test():
    from .core import multi_jittered
    from collections import deque

    deque(multi_jittered(x_range=[0, 1], y_range=[0, 1], n=1000), maxlen=0)
    assert True

# Comes from 00_core.ipynb, cell
def test_poisson_disk_with_seed():
    from .core import poisson_disk
    import numpy as np
    generator = poisson_disk(x_range=[0, 1], y_range=[0, 1], seed=42)
    assert list(np.round(next(generator), 2)) == [0.77, 0.65]
    assert list(np.round(next(generator), 2)) == [0.23, 0.0]
    assert list(np.round(next(generator), 2)) == [0.06, 0.95]
    assert list(np.round(next(generator), 2)) == [0.91, 0.08]
    assert list(np.round(next(generator), 2)) == [0.47, 0.43]


def test_poisson_disk_default_n():
    from .core import poisson_disk
    assert list(poisson_disk(x_range=[0, 1], y_range=[0, 1]))


def test_poisson_disk_default_load_test():
    from .core import poisson_disk
    from collections import deque

    deque(poisson_disk(x_range=[0, 1], y_range=[0, 1], n=1000), maxlen=0)
    assert True