
error_descriptions = {}
OK = 0
error_descriptions[OK] = 'all is OK'
ERROR_MEM = 1 # ERROR_MEM
error_descriptions[ERROR_MEM] = 'memory error'
ERROR_FILEOPEN = 2 # ERROR_FILEOPEN
error_descriptions[ERROR_FILEOPEN] = "can't open the file"
ERROR_DRIVER = 3
error_descriptions[ERROR_DRIVER] = "can't find a free/valid driver"
ERROR_BUFLOST = 4
error_descriptions[ERROR_BUFLOST] = 'the sample buffer was lost'
ERROR_HANDLE = 5
error_descriptions[ERROR_HANDLE] = 'invalid handle'
ERROR_FORMAT = 6
error_descriptions[ERROR_FORMAT] = 'unsupported sample format'
ERROR_POSITION = 7
error_descriptions[ERROR_POSITION] = 'invalid position'
ERROR_INIT = 8
error_descriptions[ERROR_INIT] = 'Init has not been successfully called'
ERROR_START = 9
error_descriptions[ERROR_START] = 'Start has not been successfully called'
ERROR_ALREADY = 14
error_descriptions[ERROR_ALREADY] = 'already initialized/paused/whatever'
ERROR_NOCHAN = 18
error_descriptions[ERROR_NOCHAN] = "can't get a free channel"
ERROR_ILLTYPE = 19
error_descriptions[ERROR_ILLTYPE] = 'an illegal type was specified'
ERROR_ILLPARAM = 20
error_descriptions[ERROR_ILLPARAM] = 'an illegal parameter was specified'
ERROR_NO3D = 21
error_descriptions[ERROR_NO3D] = 'no 3D support'
ERROR_NOEAX = 22
error_descriptions[ERROR_NOEAX] = 'no EAX support'
ERROR_DEVICE = 23
error_descriptions[ERROR_DEVICE] = 'illegal device number'
ERROR_NOPLAY = 24
error_descriptions[ERROR_NOPLAY] = 'not playing'
ERROR_FREQ = 25
error_descriptions[ERROR_FREQ] = 'illegal sample rate'
ERROR_NOTFILE = 27
error_descriptions[ERROR_NOTFILE] = 'the stream is not a file stream'
ERROR_NOHW = 29
error_descriptions[ERROR_NOHW] = 'no hardware voices available'
ERROR_EMPTY = 31
error_descriptions[ERROR_EMPTY] = 'the MOD music has no sequence data'
ERROR_NONET = 32
error_descriptions[ERROR_NONET] = 'no internet connection could be opened'
ERROR_CREATE = 33
error_descriptions[ERROR_CREATE] = "couldn't create the file"
ERROR_NOFX = 34
error_descriptions[ERROR_NOFX] = 'effects are not available'
ERROR_NOTAVAIL = 37
error_descriptions[ERROR_NOTAVAIL] = 'requested data is not available'
ERROR_DECODE = 38
error_descriptions[ERROR_DECODE] = 'the channel is a "decoding channel"'
ERROR_DX = 39
error_descriptions[ERROR_DX] = 'a sufficient DirectX version is not installed'
ERROR_TIMEOUT = 40
error_descriptions[ERROR_TIMEOUT] = 'connection timedout'
ERROR_FILEFORM = 41
error_descriptions[ERROR_FILEFORM] = 'unsupported file format'
ERROR_SPEAKER = 42
error_descriptions[ERROR_SPEAKER] = 'unavailable speaker'
ERROR_VERSION = 43
error_descriptions[ERROR_VERSION] = 'invalid BASS version (used by add-ons)'
ERROR_CODEC = 44
error_descriptions[ERROR_CODEC] = 'codec is not available/supported'
ERROR_ENDED = 45
error_descriptions[ERROR_ENDED] = 'the channel/file has ended'
ERROR_BUSY = 46
error_descriptions[ERROR_ENDED] = 'the device is busy'
ERROR_UNKNOWN = -1
error_descriptions[ERROR_UNKNOWN] = 'some other mystery problem'

def get_description(error_code = -1):
	return error_descriptions.get(error_code, 'unknown BASS error code ' + str(error_code))
