﻿EL_NAME_COL = 0
EL_NR_COL = 1
EL_WT_COL = 2

EL_DATA = {
    'H'   : ['HYDROGEN'         ,1     ,1.00783    ],
    'He'  : ['HELIUM'           ,2     ,4.0026     ],
    'Li'  : ['LITHIUM'          ,3     ,6.941      ],
    'Be'  : ['BERYLLIUM'        ,4     ,9.0122     ],
    'B'   : ['BORON'            ,5     ,10.811     ],
    'C'   : ['CARBON'           ,6     ,12.0107    ],
    'N'   : ['NITROGEN'         ,7     ,14.0067    ],
    'O'   : ['OXYGEN'           ,8     ,15.999491  ],
    'F'   : ['FLUORINE'         ,9     ,18.9984    ],
    'Ne'  : ['NEON'             ,10    ,20.1797    ],
    'Na'  : ['SODIUM'           ,11    ,22.9897    ],
    'Mg'  : ['MAGNESIUM'        ,12    ,24.305     ],
    'Al'  : ['ALUMINUM'         ,13    ,26.9815    ],
    'Si'  : ['SILICON'          ,14    ,28.0855    ],
    'P'   : ['PHOSPHORUS'       ,15    ,30.9738    ],
    'S'   : ['SULFUR'           ,16    ,32.065     ],
    'Cl'  : ['CHLORINE'         ,17    ,35.453     ],
    'Ar'  : ['ARGON'            ,18    ,39.948     ],
    'K'   : ['POTASSIUM'        ,19    ,39.0983    ],
    'Ca'  : ['CALCIUM'          ,20    ,40.078     ],
    'Sc'  : ['SCANDIUM'         ,21    ,44.9559    ],
    'Ti'  : ['TITANIUM'         ,22    ,47.867     ],
    'V'   : ['VANADIUM'         ,23    ,50.9415    ],
    'Cr'  : ['CHROMIUM'         ,24    ,51.9961    ],
    'Mn'  : ['MANGANESE'        ,25    ,54.938     ],
    'Fe'  : ['IRON'             ,26    ,55.845     ],
    'Co'  : ['COBALT'           ,27    ,58.9332    ],
    'Ni'  : ['NICKEL'           ,28    ,58.6934    ],
    'Cu'  : ['COPPER'           ,29    ,63.546     ],
    'Zn'  : ['ZINC'             ,30    ,65.39      ],
    'Ga'  : ['GALLIUM'          ,31    ,69.723     ],
    'Ge'  : ['GERMANIUM'        ,32    ,72.64      ],
    'As'  : ['ARSENIC'          ,33    ,74.9216    ],
    'Se'  : ['SELENIUM'         ,34    ,78.96      ],
    'Br'  : ['BROMINE'          ,35    ,79.904     ],
    'Kr'  : ['KRYPTON'          ,36    ,83.8       ],
    'Rb'  : ['RUBIDIUM'         ,37    ,85.4678    ],
    'Sr'  : ['STRONTIUM'        ,38    ,87.62      ],
    'Y'   : ['YTTRIUM'          ,39    ,88.9059    ],
    'Zr'  : ['ZIRCONIUM'        ,40    ,91.224     ],
    'Nb'  : ['NIOBIUM'          ,41    ,92.9064    ],
    'Mo'  : ['MOLYBDENUM'       ,42    ,95.94      ],
    'Tc'  : ['TECHNETIUM'       ,43    ,98         ],
    'Ru'  : ['RUTHENIUM'        ,44    ,101.07     ],
    'Rh'  : ['RHODIUM'          ,45    ,102.9055   ],
    'Pd'  : ['PALLADIUM'        ,46    ,106.42     ],
    'Ag'  : ['SILVER'           ,47    ,107.8682   ],
    'Cd'  : ['CADMIUM'          ,48    ,112.411    ],
    'In'  : ['INDIUM'           ,49    ,114.818    ],
    'Sn'  : ['TIN'              ,50    ,118.71     ],
    'Sb'  : ['ANTIMONY'         ,51    ,121.76     ],
    'Te'  : ['TELLURIUM'        ,52    ,127.6      ],
    'In'  : ['IODINE'           ,53    ,126.9045   ],
    'Xe'  : ['XENON'            ,54    ,131.293    ],
    'Cs'  : ['CESIUM'           ,55    ,132.9055   ],
    'Ba'  : ['BARIUM'           ,56    ,137.327    ],
    'La'  : ['LANTHANUM'        ,57    ,138.9055   ],
    'Ce'  : ['CERIUM'           ,58    ,140.116    ],
    'Pr'  : ['PRASEODYMIUM'     ,59    ,140.9077   ],
    'Nd'  : ['NEODYMIUM'        ,60    ,144.24     ],
    'Pm'  : ['PROMETHIUM'       ,61    ,145        ],
    'Sm'  : ['SAMARIUM'         ,62    ,150.36     ],
    'Eu'  : ['EUROPIUM'         ,63    ,151.964    ],
    'Gd'  : ['GADOLINIUM'       ,64    ,157.25     ],
    'Tb'  : ['TERBIUM'          ,65    ,158.9253   ],
    'Dy'  : ['DYSPROSIUM'       ,66    ,162.5      ],
    'Ho'  : ['HOLMIUM'          ,67    ,164.9303   ],
    'Er'  : ['ERBIUM'           ,68    ,167.259    ],
    'Tm'  : ['THULIUM'          ,69    ,168.9342   ],
    'Yb'  : ['YTTERBIUM'        ,70    ,173.04     ],
    'Lu'  : ['LUTETIUM'         ,71    ,174.967    ],
    'Hf'  : ['HAFNIUM'          ,72    ,178.49     ],
    'Ta'  : ['TANTALUM'         ,73    ,180.9479   ],
    'W'   : ['TUNGSTEN'         ,74    ,183.84     ],
    'Re'  : ['RHENIUM'          ,75    ,186.207    ],
    'Os'  : ['OSMIUM'           ,76    ,190.23     ],
    'Ir'  : ['IRIDIUM'          ,77    ,196.9665   ],
    'Pt'  : ['PLATINUM'         ,78    ,192.217    ],
    'Au'  : ['GOLD'             ,79    ,195.078    ],
    'Hg'  : ['MERCURY'          ,80    ,200.59     ],
    'Tl'  : ['THALLIUM'         ,81    ,204.3833   ],
    'Pb'  : ['LEAD'             ,82    ,207.2      ],
    'Bi'  : ['BISMUTH'          ,83    ,208.9804   ],
    'Po'  : ['POLONIUM'         ,84    ,209        ],
    'At'  : ['ASTATINE'         ,85    ,210        ],
    'Rn'  : ['RADON'            ,86    ,222        ],
    'Fr'  : ['FRANCIUM'         ,87    ,223        ],
    'Ra'  : ['RADIUM'           ,88    ,226        ],
    'Ac'  : ['ACTINIUM'         ,89    ,227        ],
    'Th'  : ['THORIUM'          ,90    ,232.0381   ],
    'Pa'  : ['PROTACTINIUM'     ,91    ,231.0359   ],
    'U'   : ['URANIUM'          ,92    ,238.0289   ],
    'Np'  : ['NEPTUNIUM'        ,93    ,237        ],
    'Pu'  : ['PLUTONIUM'        ,94    ,244        ],
    'Am'  : ['AMERICIUM'        ,95    ,243        ],
    'Cm'  : ['CURIUM'           ,96    ,247        ],
    'Bk'  : ['BERKELIUM'        ,97    ,247        ],
    'Cf'  : ['CALIFORNIUM'      ,98    ,251        ],
    'Es'  : ['EINSTEINIUM'      ,99    ,252        ],
    'Fm'  : ['FERMIUM'          ,100    ,257       ],
    'Md'  : ['MENDELEVIUM'      ,101    ,258       ],
    'No'  : ['NOBELIUM'         ,102    ,259       ],
    'Lr'  : ['LAWRENCIUM'       ,103    ,262       ],
    'Rf'  : ['RUTHERFORDIUM'    ,104    ,261       ],
    'Db'  : ['DUBNIUM'          ,105    ,262       ],
    'Sg'  : ['SEABORGIUM'       ,106    ,266       ],
    'Bh'  : ['BOHRIUM'          ,107    ,264       ],
    'Hs'  : ['HASSIUM'          ,108    ,277       ],
    'Mt'  : ['MEITNERIUM'       ,109    ,268       ],
    'Ds'  : ['DARMSTADTIUM'     ,110    ,261.9     ],
    'Rg'  : ['ROENTGENIUM'      ,111    ,271.8     ],
    'Cn'  : ['COPERNICIUM'      ,112    ,285       ],
    'Nh'  : ['NIHONIUM'         ,113    ,286       ],
    'Fl'  : ['FLEROVIUM'        ,114    ,289       ],
    'Mc'  : ['MOSCOVIUM'        ,115    ,288       ],
    'Lv'  : ['LIVERMORIUM'      ,116    ,293       ],
    'Ts'  : ['TENNESSINE'       ,117    ,260.9     ],
    'Og'  : ['OGANESSON'        ,118    ,294       ]
}


def get_el_wt_by_symbol(el):
    if len(el)>1:
        el = el[0].upper()+el[1:].lower()
    else:
        el = el.upper()
    try:
        if len(el) > 1:
            rDat = EL_DATA[el][EL_WT_COL]
        else:
            rDat = EL_DATA[el.upper()][EL_WT_COL]
    except:
        rDat= -1.0
    return rDat

def get_el_symbol_by_atomic_nr(el_atnr):
    rDat = ''
    for key,value in EL_DATA.items():
        if value[EL_NR_COL] == el_atnr:
            rDat = key
            break
    return rDat

def get_molwt_from_atom_types(atom_types):
    MolWt = 0.0
    for atom_symbol in atom_types:
        MolWt+=get_el_wt_by_symbol(atom_symbol)
    return MolWt