import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OpcProviderConfig {
    /**
    * The HTTP endpoint for OPC API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#endpoint OpcProvider#endpoint}
    */
    readonly endpoint?: string;
    /**
    * The OPC identity domain for API operations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#identity_domain OpcProvider#identity_domain}
    */
    readonly identityDomain: string;
    /**
    * Skip TLS Verification for self-signed certificates. Should only be used if absolutely required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#insecure OpcProvider#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * The HTTP endpoint for the Load Balancer Classic service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#lbaas_endpoint OpcProvider#lbaas_endpoint}
    */
    readonly lbaasEndpoint?: string;
    /**
    * Maximum number retries to wait for a successful response when operating on resources within OPC (defaults to 1)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#max_retries OpcProvider#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * The user password for OPC API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#password OpcProvider#password}
    */
    readonly password: string;
    /**
    * The HTTP endpoint for Oracle Storage operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#storage_endpoint OpcProvider#storage_endpoint}
    */
    readonly storageEndpoint?: string;
    /**
    * The Storage Service ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#storage_service_id OpcProvider#storage_service_id}
    */
    readonly storageServiceId?: string;
    /**
    * The user name for OPC API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#user OpcProvider#user}
    */
    readonly user: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc#alias OpcProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc opc}
*/
export declare class OpcProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "opc";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc opc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OpcProviderConfig
    */
    constructor(scope: Construct, id: string, config: OpcProviderConfig);
    private _endpoint?;
    get endpoint(): string | undefined;
    set endpoint(value: string | undefined);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _identityDomain?;
    get identityDomain(): string | undefined;
    set identityDomain(value: string | undefined);
    get identityDomainInput(): string | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable | undefined;
    set insecure(value: boolean | cdktf.IResolvable | undefined);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _lbaasEndpoint?;
    get lbaasEndpoint(): string | undefined;
    set lbaasEndpoint(value: string | undefined);
    resetLbaasEndpoint(): void;
    get lbaasEndpointInput(): string | undefined;
    private _maxRetries?;
    get maxRetries(): number | undefined;
    set maxRetries(value: number | undefined);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    get passwordInput(): string | undefined;
    private _storageEndpoint?;
    get storageEndpoint(): string | undefined;
    set storageEndpoint(value: string | undefined);
    resetStorageEndpoint(): void;
    get storageEndpointInput(): string | undefined;
    private _storageServiceId?;
    get storageServiceId(): string | undefined;
    set storageServiceId(value: string | undefined);
    resetStorageServiceId(): void;
    get storageServiceIdInput(): string | undefined;
    private _user?;
    get user(): string | undefined;
    set user(value: string | undefined);
    get userInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
