"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LbaasPolicy = exports.LbaasPolicyTrustedCertificatePolicyOutputReference = exports.lbaasPolicyTrustedCertificatePolicyToTerraform = exports.LbaasPolicySslNegotiationPolicyOutputReference = exports.lbaasPolicySslNegotiationPolicyToTerraform = exports.LbaasPolicySetRequestHeaderPolicyOutputReference = exports.lbaasPolicySetRequestHeaderPolicyToTerraform = exports.LbaasPolicyResourceAccessControlPolicyOutputReference = exports.lbaasPolicyResourceAccessControlPolicyToTerraform = exports.LbaasPolicyRedirectPolicyOutputReference = exports.lbaasPolicyRedirectPolicyToTerraform = exports.LbaasPolicyRateLimitingRequestPolicyOutputReference = exports.lbaasPolicyRateLimitingRequestPolicyToTerraform = exports.LbaasPolicyLoadBalancingMechanismPolicyOutputReference = exports.lbaasPolicyLoadBalancingMechanismPolicyToTerraform = exports.LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference = exports.lbaasPolicyLoadBalancerCookieStickinessPolicyToTerraform = exports.LbaasPolicyCloudgatePolicyOutputReference = exports.lbaasPolicyCloudgatePolicyToTerraform = exports.LbaasPolicyApplicationCookieStickinessPolicyOutputReference = exports.lbaasPolicyApplicationCookieStickinessPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function lbaasPolicyApplicationCookieStickinessPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cookie_name: cdktf.stringToTerraform(struct.cookieName),
    };
}
exports.lbaasPolicyApplicationCookieStickinessPolicyToTerraform = lbaasPolicyApplicationCookieStickinessPolicyToTerraform;
class LbaasPolicyApplicationCookieStickinessPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cookieName !== undefined) {
            hasAnyValues = true;
            internalValueResult.cookieName = this._cookieName;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cookieName = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cookieName = value.cookieName;
        }
    }
    get cookieName() {
        return this.getStringAttribute('cookie_name');
    }
    set cookieName(value) {
        this._cookieName = value;
    }
    // Temporarily expose input value. Use with caution.
    get cookieNameInput() {
        return this._cookieName;
    }
}
exports.LbaasPolicyApplicationCookieStickinessPolicyOutputReference = LbaasPolicyApplicationCookieStickinessPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
LbaasPolicyApplicationCookieStickinessPolicyOutputReference[_a] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyApplicationCookieStickinessPolicyOutputReference", version: "0.0.3" };
function lbaasPolicyCloudgatePolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cloudgate_application: cdktf.stringToTerraform(struct.cloudgateApplication),
        cloudgate_policy_name: cdktf.stringToTerraform(struct.cloudgatePolicyName),
        identity_service_instance_guid: cdktf.stringToTerraform(struct.identityServiceInstanceGuid),
        virtual_hostname_for_policy_attribution: cdktf.stringToTerraform(struct.virtualHostnameForPolicyAttribution),
    };
}
exports.lbaasPolicyCloudgatePolicyToTerraform = lbaasPolicyCloudgatePolicyToTerraform;
class LbaasPolicyCloudgatePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cloudgateApplication !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudgateApplication = this._cloudgateApplication;
        }
        if (this._cloudgatePolicyName !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudgatePolicyName = this._cloudgatePolicyName;
        }
        if (this._identityServiceInstanceGuid !== undefined) {
            hasAnyValues = true;
            internalValueResult.identityServiceInstanceGuid = this._identityServiceInstanceGuid;
        }
        if (this._virtualHostnameForPolicyAttribution !== undefined) {
            hasAnyValues = true;
            internalValueResult.virtualHostnameForPolicyAttribution = this._virtualHostnameForPolicyAttribution;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cloudgateApplication = undefined;
            this._cloudgatePolicyName = undefined;
            this._identityServiceInstanceGuid = undefined;
            this._virtualHostnameForPolicyAttribution = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cloudgateApplication = value.cloudgateApplication;
            this._cloudgatePolicyName = value.cloudgatePolicyName;
            this._identityServiceInstanceGuid = value.identityServiceInstanceGuid;
            this._virtualHostnameForPolicyAttribution = value.virtualHostnameForPolicyAttribution;
        }
    }
    get cloudgateApplication() {
        return this.getStringAttribute('cloudgate_application');
    }
    set cloudgateApplication(value) {
        this._cloudgateApplication = value;
    }
    resetCloudgateApplication() {
        this._cloudgateApplication = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudgateApplicationInput() {
        return this._cloudgateApplication;
    }
    get cloudgatePolicyName() {
        return this.getStringAttribute('cloudgate_policy_name');
    }
    set cloudgatePolicyName(value) {
        this._cloudgatePolicyName = value;
    }
    resetCloudgatePolicyName() {
        this._cloudgatePolicyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudgatePolicyNameInput() {
        return this._cloudgatePolicyName;
    }
    get identityServiceInstanceGuid() {
        return this.getStringAttribute('identity_service_instance_guid');
    }
    set identityServiceInstanceGuid(value) {
        this._identityServiceInstanceGuid = value;
    }
    resetIdentityServiceInstanceGuid() {
        this._identityServiceInstanceGuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identityServiceInstanceGuidInput() {
        return this._identityServiceInstanceGuid;
    }
    get virtualHostnameForPolicyAttribution() {
        return this.getStringAttribute('virtual_hostname_for_policy_attribution');
    }
    set virtualHostnameForPolicyAttribution(value) {
        this._virtualHostnameForPolicyAttribution = value;
    }
    // Temporarily expose input value. Use with caution.
    get virtualHostnameForPolicyAttributionInput() {
        return this._virtualHostnameForPolicyAttribution;
    }
}
exports.LbaasPolicyCloudgatePolicyOutputReference = LbaasPolicyCloudgatePolicyOutputReference;
_b = JSII_RTTI_SYMBOL_1;
LbaasPolicyCloudgatePolicyOutputReference[_b] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyCloudgatePolicyOutputReference", version: "0.0.3" };
function lbaasPolicyLoadBalancerCookieStickinessPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cookie_expiration_period: cdktf.numberToTerraform(struct.cookieExpirationPeriod),
    };
}
exports.lbaasPolicyLoadBalancerCookieStickinessPolicyToTerraform = lbaasPolicyLoadBalancerCookieStickinessPolicyToTerraform;
class LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cookieExpirationPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.cookieExpirationPeriod = this._cookieExpirationPeriod;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cookieExpirationPeriod = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cookieExpirationPeriod = value.cookieExpirationPeriod;
        }
    }
    get cookieExpirationPeriod() {
        return this.getNumberAttribute('cookie_expiration_period');
    }
    set cookieExpirationPeriod(value) {
        this._cookieExpirationPeriod = value;
    }
    // Temporarily expose input value. Use with caution.
    get cookieExpirationPeriodInput() {
        return this._cookieExpirationPeriod;
    }
}
exports.LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference = LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference[_c] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference", version: "0.0.3" };
function lbaasPolicyLoadBalancingMechanismPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        load_balancing_mechanism: cdktf.stringToTerraform(struct.loadBalancingMechanism),
    };
}
exports.lbaasPolicyLoadBalancingMechanismPolicyToTerraform = lbaasPolicyLoadBalancingMechanismPolicyToTerraform;
class LbaasPolicyLoadBalancingMechanismPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._loadBalancingMechanism !== undefined) {
            hasAnyValues = true;
            internalValueResult.loadBalancingMechanism = this._loadBalancingMechanism;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._loadBalancingMechanism = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._loadBalancingMechanism = value.loadBalancingMechanism;
        }
    }
    get loadBalancingMechanism() {
        return this.getStringAttribute('load_balancing_mechanism');
    }
    set loadBalancingMechanism(value) {
        this._loadBalancingMechanism = value;
    }
    // Temporarily expose input value. Use with caution.
    get loadBalancingMechanismInput() {
        return this._loadBalancingMechanism;
    }
}
exports.LbaasPolicyLoadBalancingMechanismPolicyOutputReference = LbaasPolicyLoadBalancingMechanismPolicyOutputReference;
_d = JSII_RTTI_SYMBOL_1;
LbaasPolicyLoadBalancingMechanismPolicyOutputReference[_d] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyLoadBalancingMechanismPolicyOutputReference", version: "0.0.3" };
function lbaasPolicyRateLimitingRequestPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        burst_size: cdktf.numberToTerraform(struct.burstSize),
        delay_excessive_requests: cdktf.booleanToTerraform(struct.delayExcessiveRequests),
        http_error_code: cdktf.numberToTerraform(struct.httpErrorCode),
        logging_level: cdktf.stringToTerraform(struct.loggingLevel),
        rate_limiting_criteria: cdktf.stringToTerraform(struct.rateLimitingCriteria),
        requests_per_second: cdktf.numberToTerraform(struct.requestsPerSecond),
        zone: cdktf.stringToTerraform(struct.zone),
        zone_memory_size: cdktf.numberToTerraform(struct.zoneMemorySize),
    };
}
exports.lbaasPolicyRateLimitingRequestPolicyToTerraform = lbaasPolicyRateLimitingRequestPolicyToTerraform;
class LbaasPolicyRateLimitingRequestPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._burstSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.burstSize = this._burstSize;
        }
        if (this._delayExcessiveRequests !== undefined) {
            hasAnyValues = true;
            internalValueResult.delayExcessiveRequests = this._delayExcessiveRequests;
        }
        if (this._httpErrorCode !== undefined) {
            hasAnyValues = true;
            internalValueResult.httpErrorCode = this._httpErrorCode;
        }
        if (this._loggingLevel !== undefined) {
            hasAnyValues = true;
            internalValueResult.loggingLevel = this._loggingLevel;
        }
        if (this._rateLimitingCriteria !== undefined) {
            hasAnyValues = true;
            internalValueResult.rateLimitingCriteria = this._rateLimitingCriteria;
        }
        if (this._requestsPerSecond !== undefined) {
            hasAnyValues = true;
            internalValueResult.requestsPerSecond = this._requestsPerSecond;
        }
        if (this._zone !== undefined) {
            hasAnyValues = true;
            internalValueResult.zone = this._zone;
        }
        if (this._zoneMemorySize !== undefined) {
            hasAnyValues = true;
            internalValueResult.zoneMemorySize = this._zoneMemorySize;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._burstSize = undefined;
            this._delayExcessiveRequests = undefined;
            this._httpErrorCode = undefined;
            this._loggingLevel = undefined;
            this._rateLimitingCriteria = undefined;
            this._requestsPerSecond = undefined;
            this._zone = undefined;
            this._zoneMemorySize = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._burstSize = value.burstSize;
            this._delayExcessiveRequests = value.delayExcessiveRequests;
            this._httpErrorCode = value.httpErrorCode;
            this._loggingLevel = value.loggingLevel;
            this._rateLimitingCriteria = value.rateLimitingCriteria;
            this._requestsPerSecond = value.requestsPerSecond;
            this._zone = value.zone;
            this._zoneMemorySize = value.zoneMemorySize;
        }
    }
    get burstSize() {
        return this.getNumberAttribute('burst_size');
    }
    set burstSize(value) {
        this._burstSize = value;
    }
    // Temporarily expose input value. Use with caution.
    get burstSizeInput() {
        return this._burstSize;
    }
    get delayExcessiveRequests() {
        return this.getBooleanAttribute('delay_excessive_requests');
    }
    set delayExcessiveRequests(value) {
        this._delayExcessiveRequests = value;
    }
    // Temporarily expose input value. Use with caution.
    get delayExcessiveRequestsInput() {
        return this._delayExcessiveRequests;
    }
    get httpErrorCode() {
        return this.getNumberAttribute('http_error_code');
    }
    set httpErrorCode(value) {
        this._httpErrorCode = value;
    }
    resetHttpErrorCode() {
        this._httpErrorCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpErrorCodeInput() {
        return this._httpErrorCode;
    }
    get loggingLevel() {
        return this.getStringAttribute('logging_level');
    }
    set loggingLevel(value) {
        this._loggingLevel = value;
    }
    resetLoggingLevel() {
        this._loggingLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loggingLevelInput() {
        return this._loggingLevel;
    }
    get rateLimitingCriteria() {
        return this.getStringAttribute('rate_limiting_criteria');
    }
    set rateLimitingCriteria(value) {
        this._rateLimitingCriteria = value;
    }
    resetRateLimitingCriteria() {
        this._rateLimitingCriteria = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rateLimitingCriteriaInput() {
        return this._rateLimitingCriteria;
    }
    get requestsPerSecond() {
        return this.getNumberAttribute('requests_per_second');
    }
    set requestsPerSecond(value) {
        this._requestsPerSecond = value;
    }
    // Temporarily expose input value. Use with caution.
    get requestsPerSecondInput() {
        return this._requestsPerSecond;
    }
    get zone() {
        return this.getStringAttribute('zone');
    }
    set zone(value) {
        this._zone = value;
    }
    // Temporarily expose input value. Use with caution.
    get zoneInput() {
        return this._zone;
    }
    get zoneMemorySize() {
        return this.getNumberAttribute('zone_memory_size');
    }
    set zoneMemorySize(value) {
        this._zoneMemorySize = value;
    }
    resetZoneMemorySize() {
        this._zoneMemorySize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zoneMemorySizeInput() {
        return this._zoneMemorySize;
    }
}
exports.LbaasPolicyRateLimitingRequestPolicyOutputReference = LbaasPolicyRateLimitingRequestPolicyOutputReference;
_e = JSII_RTTI_SYMBOL_1;
LbaasPolicyRateLimitingRequestPolicyOutputReference[_e] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyRateLimitingRequestPolicyOutputReference", version: "0.0.3" };
function lbaasPolicyRedirectPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        redirect_uri: cdktf.stringToTerraform(struct.redirectUri),
        response_code: cdktf.numberToTerraform(struct.responseCode),
    };
}
exports.lbaasPolicyRedirectPolicyToTerraform = lbaasPolicyRedirectPolicyToTerraform;
class LbaasPolicyRedirectPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._redirectUri !== undefined) {
            hasAnyValues = true;
            internalValueResult.redirectUri = this._redirectUri;
        }
        if (this._responseCode !== undefined) {
            hasAnyValues = true;
            internalValueResult.responseCode = this._responseCode;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._redirectUri = undefined;
            this._responseCode = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._redirectUri = value.redirectUri;
            this._responseCode = value.responseCode;
        }
    }
    get redirectUri() {
        return this.getStringAttribute('redirect_uri');
    }
    set redirectUri(value) {
        this._redirectUri = value;
    }
    // Temporarily expose input value. Use with caution.
    get redirectUriInput() {
        return this._redirectUri;
    }
    get responseCode() {
        return this.getNumberAttribute('response_code');
    }
    set responseCode(value) {
        this._responseCode = value;
    }
    // Temporarily expose input value. Use with caution.
    get responseCodeInput() {
        return this._responseCode;
    }
}
exports.LbaasPolicyRedirectPolicyOutputReference = LbaasPolicyRedirectPolicyOutputReference;
_f = JSII_RTTI_SYMBOL_1;
LbaasPolicyRedirectPolicyOutputReference[_f] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyRedirectPolicyOutputReference", version: "0.0.3" };
function lbaasPolicyResourceAccessControlPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        denied_clients: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.deniedClients),
        disposition: cdktf.stringToTerraform(struct.disposition),
        permitted_clients: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.permittedClients),
    };
}
exports.lbaasPolicyResourceAccessControlPolicyToTerraform = lbaasPolicyResourceAccessControlPolicyToTerraform;
class LbaasPolicyResourceAccessControlPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deniedClients !== undefined) {
            hasAnyValues = true;
            internalValueResult.deniedClients = this._deniedClients;
        }
        if (this._disposition !== undefined) {
            hasAnyValues = true;
            internalValueResult.disposition = this._disposition;
        }
        if (this._permittedClients !== undefined) {
            hasAnyValues = true;
            internalValueResult.permittedClients = this._permittedClients;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deniedClients = undefined;
            this._disposition = undefined;
            this._permittedClients = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deniedClients = value.deniedClients;
            this._disposition = value.disposition;
            this._permittedClients = value.permittedClients;
        }
    }
    get deniedClients() {
        return cdktf.Fn.tolist(this.getListAttribute('denied_clients'));
    }
    set deniedClients(value) {
        this._deniedClients = value;
    }
    resetDeniedClients() {
        this._deniedClients = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deniedClientsInput() {
        return this._deniedClients;
    }
    get disposition() {
        return this.getStringAttribute('disposition');
    }
    set disposition(value) {
        this._disposition = value;
    }
    // Temporarily expose input value. Use with caution.
    get dispositionInput() {
        return this._disposition;
    }
    get permittedClients() {
        return cdktf.Fn.tolist(this.getListAttribute('permitted_clients'));
    }
    set permittedClients(value) {
        this._permittedClients = value;
    }
    resetPermittedClients() {
        this._permittedClients = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get permittedClientsInput() {
        return this._permittedClients;
    }
}
exports.LbaasPolicyResourceAccessControlPolicyOutputReference = LbaasPolicyResourceAccessControlPolicyOutputReference;
_g = JSII_RTTI_SYMBOL_1;
LbaasPolicyResourceAccessControlPolicyOutputReference[_g] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyResourceAccessControlPolicyOutputReference", version: "0.0.3" };
function lbaasPolicySetRequestHeaderPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        action_when_header_exists: cdktf.stringToTerraform(struct.actionWhenHeaderExists),
        action_when_header_value_is: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.actionWhenHeaderValueIs),
        action_when_header_value_is_not: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.actionWhenHeaderValueIsNot),
        header_name: cdktf.stringToTerraform(struct.headerName),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.lbaasPolicySetRequestHeaderPolicyToTerraform = lbaasPolicySetRequestHeaderPolicyToTerraform;
class LbaasPolicySetRequestHeaderPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._actionWhenHeaderExists !== undefined) {
            hasAnyValues = true;
            internalValueResult.actionWhenHeaderExists = this._actionWhenHeaderExists;
        }
        if (this._actionWhenHeaderValueIs !== undefined) {
            hasAnyValues = true;
            internalValueResult.actionWhenHeaderValueIs = this._actionWhenHeaderValueIs;
        }
        if (this._actionWhenHeaderValueIsNot !== undefined) {
            hasAnyValues = true;
            internalValueResult.actionWhenHeaderValueIsNot = this._actionWhenHeaderValueIsNot;
        }
        if (this._headerName !== undefined) {
            hasAnyValues = true;
            internalValueResult.headerName = this._headerName;
        }
        if (this._value !== undefined) {
            hasAnyValues = true;
            internalValueResult.value = this._value;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._actionWhenHeaderExists = undefined;
            this._actionWhenHeaderValueIs = undefined;
            this._actionWhenHeaderValueIsNot = undefined;
            this._headerName = undefined;
            this._value = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._actionWhenHeaderExists = value.actionWhenHeaderExists;
            this._actionWhenHeaderValueIs = value.actionWhenHeaderValueIs;
            this._actionWhenHeaderValueIsNot = value.actionWhenHeaderValueIsNot;
            this._headerName = value.headerName;
            this._value = value.value;
        }
    }
    get actionWhenHeaderExists() {
        return this.getStringAttribute('action_when_header_exists');
    }
    set actionWhenHeaderExists(value) {
        this._actionWhenHeaderExists = value;
    }
    resetActionWhenHeaderExists() {
        this._actionWhenHeaderExists = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get actionWhenHeaderExistsInput() {
        return this._actionWhenHeaderExists;
    }
    get actionWhenHeaderValueIs() {
        return cdktf.Fn.tolist(this.getListAttribute('action_when_header_value_is'));
    }
    set actionWhenHeaderValueIs(value) {
        this._actionWhenHeaderValueIs = value;
    }
    resetActionWhenHeaderValueIs() {
        this._actionWhenHeaderValueIs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get actionWhenHeaderValueIsInput() {
        return this._actionWhenHeaderValueIs;
    }
    get actionWhenHeaderValueIsNot() {
        return cdktf.Fn.tolist(this.getListAttribute('action_when_header_value_is_not'));
    }
    set actionWhenHeaderValueIsNot(value) {
        this._actionWhenHeaderValueIsNot = value;
    }
    resetActionWhenHeaderValueIsNot() {
        this._actionWhenHeaderValueIsNot = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get actionWhenHeaderValueIsNotInput() {
        return this._actionWhenHeaderValueIsNot;
    }
    get headerName() {
        return this.getStringAttribute('header_name');
    }
    set headerName(value) {
        this._headerName = value;
    }
    // Temporarily expose input value. Use with caution.
    get headerNameInput() {
        return this._headerName;
    }
    get value() {
        return this.getStringAttribute('value');
    }
    set value(value) {
        this._value = value;
    }
    resetValue() {
        this._value = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get valueInput() {
        return this._value;
    }
}
exports.LbaasPolicySetRequestHeaderPolicyOutputReference = LbaasPolicySetRequestHeaderPolicyOutputReference;
_h = JSII_RTTI_SYMBOL_1;
LbaasPolicySetRequestHeaderPolicyOutputReference[_h] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicySetRequestHeaderPolicyOutputReference", version: "0.0.3" };
function lbaasPolicySslNegotiationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        port: cdktf.numberToTerraform(struct.port),
        server_order_preference: cdktf.stringToTerraform(struct.serverOrderPreference),
        ssl_ciphers: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.sslCiphers),
        ssl_protocol: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.sslProtocol),
    };
}
exports.lbaasPolicySslNegotiationPolicyToTerraform = lbaasPolicySslNegotiationPolicyToTerraform;
class LbaasPolicySslNegotiationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._serverOrderPreference !== undefined) {
            hasAnyValues = true;
            internalValueResult.serverOrderPreference = this._serverOrderPreference;
        }
        if (this._sslCiphers !== undefined) {
            hasAnyValues = true;
            internalValueResult.sslCiphers = this._sslCiphers;
        }
        if (this._sslProtocol !== undefined) {
            hasAnyValues = true;
            internalValueResult.sslProtocol = this._sslProtocol;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._port = undefined;
            this._serverOrderPreference = undefined;
            this._sslCiphers = undefined;
            this._sslProtocol = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._port = value.port;
            this._serverOrderPreference = value.serverOrderPreference;
            this._sslCiphers = value.sslCiphers;
            this._sslProtocol = value.sslProtocol;
        }
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get serverOrderPreference() {
        return this.getStringAttribute('server_order_preference');
    }
    set serverOrderPreference(value) {
        this._serverOrderPreference = value;
    }
    resetServerOrderPreference() {
        this._serverOrderPreference = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverOrderPreferenceInput() {
        return this._serverOrderPreference;
    }
    get sslCiphers() {
        return cdktf.Fn.tolist(this.getListAttribute('ssl_ciphers'));
    }
    set sslCiphers(value) {
        this._sslCiphers = value;
    }
    resetSslCiphers() {
        this._sslCiphers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslCiphersInput() {
        return this._sslCiphers;
    }
    get sslProtocol() {
        return cdktf.Fn.tolist(this.getListAttribute('ssl_protocol'));
    }
    set sslProtocol(value) {
        this._sslProtocol = value;
    }
    // Temporarily expose input value. Use with caution.
    get sslProtocolInput() {
        return this._sslProtocol;
    }
}
exports.LbaasPolicySslNegotiationPolicyOutputReference = LbaasPolicySslNegotiationPolicyOutputReference;
_j = JSII_RTTI_SYMBOL_1;
LbaasPolicySslNegotiationPolicyOutputReference[_j] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicySslNegotiationPolicyOutputReference", version: "0.0.3" };
function lbaasPolicyTrustedCertificatePolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        trusted_certificate: cdktf.stringToTerraform(struct.trustedCertificate),
    };
}
exports.lbaasPolicyTrustedCertificatePolicyToTerraform = lbaasPolicyTrustedCertificatePolicyToTerraform;
class LbaasPolicyTrustedCertificatePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._trustedCertificate !== undefined) {
            hasAnyValues = true;
            internalValueResult.trustedCertificate = this._trustedCertificate;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._trustedCertificate = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._trustedCertificate = value.trustedCertificate;
        }
    }
    get trustedCertificate() {
        return this.getStringAttribute('trusted_certificate');
    }
    set trustedCertificate(value) {
        this._trustedCertificate = value;
    }
    // Temporarily expose input value. Use with caution.
    get trustedCertificateInput() {
        return this._trustedCertificate;
    }
}
exports.LbaasPolicyTrustedCertificatePolicyOutputReference = LbaasPolicyTrustedCertificatePolicyOutputReference;
_k = JSII_RTTI_SYMBOL_1;
LbaasPolicyTrustedCertificatePolicyOutputReference[_k] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicyTrustedCertificatePolicyOutputReference", version: "0.0.3" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy opc_lbaas_policy}
*/
class LbaasPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy opc_lbaas_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbaasPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'opc_lbaas_policy',
            terraformGeneratorMetadata: {
                providerName: 'opc',
                providerVersion: '1.4.1',
                providerVersionConstraint: '~> 1.4'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // application_cookie_stickiness_policy - computed: false, optional: true, required: false
        this._applicationCookieStickinessPolicy = new LbaasPolicyApplicationCookieStickinessPolicyOutputReference(this, "application_cookie_stickiness_policy");
        // cloudgate_policy - computed: false, optional: true, required: false
        this._cloudgatePolicy = new LbaasPolicyCloudgatePolicyOutputReference(this, "cloudgate_policy");
        // load_balancer_cookie_stickiness_policy - computed: false, optional: true, required: false
        this._loadBalancerCookieStickinessPolicy = new LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference(this, "load_balancer_cookie_stickiness_policy");
        // load_balancing_mechanism_policy - computed: false, optional: true, required: false
        this._loadBalancingMechanismPolicy = new LbaasPolicyLoadBalancingMechanismPolicyOutputReference(this, "load_balancing_mechanism_policy");
        // rate_limiting_request_policy - computed: false, optional: true, required: false
        this._rateLimitingRequestPolicy = new LbaasPolicyRateLimitingRequestPolicyOutputReference(this, "rate_limiting_request_policy");
        // redirect_policy - computed: false, optional: true, required: false
        this._redirectPolicy = new LbaasPolicyRedirectPolicyOutputReference(this, "redirect_policy");
        // resource_access_control_policy - computed: false, optional: true, required: false
        this._resourceAccessControlPolicy = new LbaasPolicyResourceAccessControlPolicyOutputReference(this, "resource_access_control_policy");
        // set_request_header_policy - computed: false, optional: true, required: false
        this._setRequestHeaderPolicy = new LbaasPolicySetRequestHeaderPolicyOutputReference(this, "set_request_header_policy");
        // ssl_negotiation_policy - computed: false, optional: true, required: false
        this._sslNegotiationPolicy = new LbaasPolicySslNegotiationPolicyOutputReference(this, "ssl_negotiation_policy");
        // trusted_certificate_policy - computed: false, optional: true, required: false
        this._trustedCertificatePolicy = new LbaasPolicyTrustedCertificatePolicyOutputReference(this, "trusted_certificate_policy");
        this._id = config.id;
        this._loadBalancer = config.loadBalancer;
        this._name = config.name;
        this._applicationCookieStickinessPolicy.internalValue = config.applicationCookieStickinessPolicy;
        this._cloudgatePolicy.internalValue = config.cloudgatePolicy;
        this._loadBalancerCookieStickinessPolicy.internalValue = config.loadBalancerCookieStickinessPolicy;
        this._loadBalancingMechanismPolicy.internalValue = config.loadBalancingMechanismPolicy;
        this._rateLimitingRequestPolicy.internalValue = config.rateLimitingRequestPolicy;
        this._redirectPolicy.internalValue = config.redirectPolicy;
        this._resourceAccessControlPolicy.internalValue = config.resourceAccessControlPolicy;
        this._setRequestHeaderPolicy.internalValue = config.setRequestHeaderPolicy;
        this._sslNegotiationPolicy.internalValue = config.sslNegotiationPolicy;
        this._trustedCertificatePolicy.internalValue = config.trustedCertificatePolicy;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get loadBalancer() {
        return this.getStringAttribute('load_balancer');
    }
    set loadBalancer(value) {
        this._loadBalancer = value;
    }
    // Temporarily expose input value. Use with caution.
    get loadBalancerInput() {
        return this._loadBalancer;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // state - computed: true, optional: false, required: false
    get state() {
        return this.getBooleanAttribute('state');
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
    // uri - computed: true, optional: false, required: false
    get uri() {
        return this.getStringAttribute('uri');
    }
    get applicationCookieStickinessPolicy() {
        return this._applicationCookieStickinessPolicy;
    }
    putApplicationCookieStickinessPolicy(value) {
        this._applicationCookieStickinessPolicy.internalValue = value;
    }
    resetApplicationCookieStickinessPolicy() {
        this._applicationCookieStickinessPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get applicationCookieStickinessPolicyInput() {
        return this._applicationCookieStickinessPolicy.internalValue;
    }
    get cloudgatePolicy() {
        return this._cloudgatePolicy;
    }
    putCloudgatePolicy(value) {
        this._cloudgatePolicy.internalValue = value;
    }
    resetCloudgatePolicy() {
        this._cloudgatePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudgatePolicyInput() {
        return this._cloudgatePolicy.internalValue;
    }
    get loadBalancerCookieStickinessPolicy() {
        return this._loadBalancerCookieStickinessPolicy;
    }
    putLoadBalancerCookieStickinessPolicy(value) {
        this._loadBalancerCookieStickinessPolicy.internalValue = value;
    }
    resetLoadBalancerCookieStickinessPolicy() {
        this._loadBalancerCookieStickinessPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loadBalancerCookieStickinessPolicyInput() {
        return this._loadBalancerCookieStickinessPolicy.internalValue;
    }
    get loadBalancingMechanismPolicy() {
        return this._loadBalancingMechanismPolicy;
    }
    putLoadBalancingMechanismPolicy(value) {
        this._loadBalancingMechanismPolicy.internalValue = value;
    }
    resetLoadBalancingMechanismPolicy() {
        this._loadBalancingMechanismPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loadBalancingMechanismPolicyInput() {
        return this._loadBalancingMechanismPolicy.internalValue;
    }
    get rateLimitingRequestPolicy() {
        return this._rateLimitingRequestPolicy;
    }
    putRateLimitingRequestPolicy(value) {
        this._rateLimitingRequestPolicy.internalValue = value;
    }
    resetRateLimitingRequestPolicy() {
        this._rateLimitingRequestPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rateLimitingRequestPolicyInput() {
        return this._rateLimitingRequestPolicy.internalValue;
    }
    get redirectPolicy() {
        return this._redirectPolicy;
    }
    putRedirectPolicy(value) {
        this._redirectPolicy.internalValue = value;
    }
    resetRedirectPolicy() {
        this._redirectPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redirectPolicyInput() {
        return this._redirectPolicy.internalValue;
    }
    get resourceAccessControlPolicy() {
        return this._resourceAccessControlPolicy;
    }
    putResourceAccessControlPolicy(value) {
        this._resourceAccessControlPolicy.internalValue = value;
    }
    resetResourceAccessControlPolicy() {
        this._resourceAccessControlPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceAccessControlPolicyInput() {
        return this._resourceAccessControlPolicy.internalValue;
    }
    get setRequestHeaderPolicy() {
        return this._setRequestHeaderPolicy;
    }
    putSetRequestHeaderPolicy(value) {
        this._setRequestHeaderPolicy.internalValue = value;
    }
    resetSetRequestHeaderPolicy() {
        this._setRequestHeaderPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get setRequestHeaderPolicyInput() {
        return this._setRequestHeaderPolicy.internalValue;
    }
    get sslNegotiationPolicy() {
        return this._sslNegotiationPolicy;
    }
    putSslNegotiationPolicy(value) {
        this._sslNegotiationPolicy.internalValue = value;
    }
    resetSslNegotiationPolicy() {
        this._sslNegotiationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslNegotiationPolicyInput() {
        return this._sslNegotiationPolicy.internalValue;
    }
    get trustedCertificatePolicy() {
        return this._trustedCertificatePolicy;
    }
    putTrustedCertificatePolicy(value) {
        this._trustedCertificatePolicy.internalValue = value;
    }
    resetTrustedCertificatePolicy() {
        this._trustedCertificatePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trustedCertificatePolicyInput() {
        return this._trustedCertificatePolicy.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            load_balancer: cdktf.stringToTerraform(this._loadBalancer),
            name: cdktf.stringToTerraform(this._name),
            application_cookie_stickiness_policy: lbaasPolicyApplicationCookieStickinessPolicyToTerraform(this._applicationCookieStickinessPolicy.internalValue),
            cloudgate_policy: lbaasPolicyCloudgatePolicyToTerraform(this._cloudgatePolicy.internalValue),
            load_balancer_cookie_stickiness_policy: lbaasPolicyLoadBalancerCookieStickinessPolicyToTerraform(this._loadBalancerCookieStickinessPolicy.internalValue),
            load_balancing_mechanism_policy: lbaasPolicyLoadBalancingMechanismPolicyToTerraform(this._loadBalancingMechanismPolicy.internalValue),
            rate_limiting_request_policy: lbaasPolicyRateLimitingRequestPolicyToTerraform(this._rateLimitingRequestPolicy.internalValue),
            redirect_policy: lbaasPolicyRedirectPolicyToTerraform(this._redirectPolicy.internalValue),
            resource_access_control_policy: lbaasPolicyResourceAccessControlPolicyToTerraform(this._resourceAccessControlPolicy.internalValue),
            set_request_header_policy: lbaasPolicySetRequestHeaderPolicyToTerraform(this._setRequestHeaderPolicy.internalValue),
            ssl_negotiation_policy: lbaasPolicySslNegotiationPolicyToTerraform(this._sslNegotiationPolicy.internalValue),
            trusted_certificate_policy: lbaasPolicyTrustedCertificatePolicyToTerraform(this._trustedCertificatePolicy.internalValue),
        };
    }
}
exports.LbaasPolicy = LbaasPolicy;
_l = JSII_RTTI_SYMBOL_1;
LbaasPolicy[_l] = { fqn: "@cdktf/provider-opc.lbaasPolicy.LbaasPolicy", version: "0.0.3" };
// =================
// STATIC PROPERTIES
// =================
LbaasPolicy.tfResourceType = "opc_lbaas_policy";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvbGJhYXMtcG9saWN5L2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBd0YvQixTQUFnQix1REFBdUQsQ0FBQyxNQUFtSDtJQUN6TCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFVBQVUsQ0FBQztLQUN6RCxDQUFBO0FBQ0gsQ0FBQztBQVJELDBIQVFDO0FBRUQsTUFBYSwyREFBNEQsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUdsRzs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsV0FBVyxLQUFLLFNBQVMsRUFBRTtZQUNsQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1NBQ25EO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQStEO1FBQ3RGLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztTQUM5QjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1NBQ3JDO0lBQ0gsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQzs7QUEzQ0gsa0lBNENDOzs7QUFvQkQsU0FBZ0IscUNBQXFDLENBQUMsTUFBK0U7SUFDbkksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxxQkFBcUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLG9CQUFvQixDQUFDO1FBQzVFLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsbUJBQW1CLENBQUM7UUFDM0UsOEJBQThCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQywyQkFBMkIsQ0FBQztRQUM1Rix1Q0FBdUMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLG1DQUFtQyxDQUFDO0tBQzlHLENBQUE7QUFDSCxDQUFDO0FBWEQsc0ZBV0M7QUFFRCxNQUFhLHlDQUEwQyxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR2hGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxxQkFBcUIsS0FBSyxTQUFTLEVBQUU7WUFDNUMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUM7U0FDdkU7UUFDRCxJQUFJLElBQUksQ0FBQyxvQkFBb0IsS0FBSyxTQUFTLEVBQUU7WUFDM0MsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUM7U0FDckU7UUFDRCxJQUFJLElBQUksQ0FBQyw0QkFBNEIsS0FBSyxTQUFTLEVBQUU7WUFDbkQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywyQkFBMkIsR0FBRyxJQUFJLENBQUMsNEJBQTRCLENBQUM7U0FDckY7UUFDRCxJQUFJLElBQUksQ0FBQyxvQ0FBb0MsS0FBSyxTQUFTLEVBQUU7WUFDM0QsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxtQ0FBbUMsR0FBRyxJQUFJLENBQUMsb0NBQW9DLENBQUM7U0FDckc7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBNkM7UUFDcEUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxTQUFTLENBQUM7WUFDdkMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztZQUN0QyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsU0FBUyxDQUFDO1lBQzlDLElBQUksQ0FBQyxvQ0FBb0MsR0FBRyxTQUFTLENBQUM7U0FDdkQ7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7WUFDeEQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztZQUN0RCxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDLDJCQUEyQixDQUFDO1lBQ3RFLElBQUksQ0FBQyxvQ0FBb0MsR0FBRyxLQUFLLENBQUMsbUNBQW1DLENBQUM7U0FDdkY7SUFDSCxDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFhO1FBQzNDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNNLHlCQUF5QjtRQUM5QixJQUFJLENBQUMscUJBQXFCLEdBQUcsU0FBUyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUlELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUNELElBQVcsbUJBQW1CLENBQUMsS0FBYTtRQUMxQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFDTSx3QkFBd0I7UUFDN0IsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztJQUN4QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLDJCQUEyQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ25FLENBQUM7SUFDRCxJQUFXLDJCQUEyQixDQUFDLEtBQWE7UUFDbEQsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQztJQUM1QyxDQUFDO0lBQ00sZ0NBQWdDO1FBQ3JDLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxTQUFTLENBQUM7SUFDaEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdDQUFnQztRQUN6QyxPQUFPLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztJQUMzQyxDQUFDO0lBSUQsSUFBVyxtQ0FBbUM7UUFDNUMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMseUNBQXlDLENBQUMsQ0FBQztJQUM1RSxDQUFDO0lBQ0QsSUFBVyxtQ0FBbUMsQ0FBQyxLQUFhO1FBQzFELElBQUksQ0FBQyxvQ0FBb0MsR0FBRyxLQUFLLENBQUM7SUFDcEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdDQUF3QztRQUNqRCxPQUFPLElBQUksQ0FBQyxvQ0FBb0MsQ0FBQztJQUNuRCxDQUFDOztBQTdHSCw4RkE4R0M7OztBQVFELFNBQWdCLHdEQUF3RCxDQUFDLE1BQXFIO0lBQzVMLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsd0JBQXdCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxzQkFBc0IsQ0FBQztLQUNsRixDQUFBO0FBQ0gsQ0FBQztBQVJELDRIQVFDO0FBRUQsTUFBYSw0REFBNkQsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUduRzs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsdUJBQXVCLEtBQUssU0FBUyxFQUFFO1lBQzlDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsc0JBQXNCLEdBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDO1NBQzNFO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQWdFO1FBQ3ZGLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsdUJBQXVCLEdBQUcsU0FBUyxDQUFDO1NBQzFDO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLHNCQUFzQixDQUFDO1NBQzdEO0lBQ0gsQ0FBQztJQUlELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0QsQ0FBQztJQUNELElBQVcsc0JBQXNCLENBQUMsS0FBYTtRQUM3QyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsdUJBQXVCLENBQUM7SUFDdEMsQ0FBQzs7QUEzQ0gsb0lBNENDOzs7QUFRRCxTQUFnQixrREFBa0QsQ0FBQyxNQUF5RztJQUMxSyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLHdCQUF3QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsc0JBQXNCLENBQUM7S0FDbEYsQ0FBQTtBQUNILENBQUM7QUFSRCxnSEFRQztBQUVELE1BQWEsc0RBQXVELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHN0Y7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLHVCQUF1QixLQUFLLFNBQVMsRUFBRTtZQUM5QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHNCQUFzQixHQUFHLElBQUksQ0FBQyx1QkFBdUIsQ0FBQztTQUMzRTtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUEwRDtRQUNqRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLHVCQUF1QixHQUFHLFNBQVMsQ0FBQztTQUMxQzthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztTQUM3RDtJQUNILENBQUM7SUFJRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdELENBQUM7SUFDRCxJQUFXLHNCQUFzQixDQUFDLEtBQWE7UUFDN0MsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLHVCQUF1QixDQUFDO0lBQ3RDLENBQUM7O0FBM0NILHdIQTRDQzs7O0FBb0NELFNBQWdCLCtDQUErQyxDQUFDLE1BQW1HO0lBQ2pLLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsU0FBUyxDQUFDO1FBQ3RELHdCQUF3QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsc0JBQXNCLENBQUM7UUFDbEYsZUFBZSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsYUFBYSxDQUFDO1FBQy9ELGFBQWEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFlBQVksQ0FBQztRQUM1RCxzQkFBc0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLG9CQUFvQixDQUFDO1FBQzdFLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsaUJBQWlCLENBQUM7UUFDdkUsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsY0FBYyxDQUFDO0tBQ2xFLENBQUE7QUFDSCxDQUFDO0FBZkQsMEdBZUM7QUFFRCxNQUFhLG1EQUFvRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBRzFGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxVQUFVLEtBQUssU0FBUyxFQUFFO1lBQ2pDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7U0FDakQ7UUFDRCxJQUFJLElBQUksQ0FBQyx1QkFBdUIsS0FBSyxTQUFTLEVBQUU7WUFDOUMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxzQkFBc0IsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUM7U0FDM0U7UUFDRCxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssU0FBUyxFQUFFO1lBQ3JDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7U0FDekQ7UUFDRCxJQUFJLElBQUksQ0FBQyxhQUFhLEtBQUssU0FBUyxFQUFFO1lBQ3BDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7U0FDdkQ7UUFDRCxJQUFJLElBQUksQ0FBQyxxQkFBcUIsS0FBSyxTQUFTLEVBQUU7WUFDNUMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUM7U0FDdkU7UUFDRCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTLEVBQUU7WUFDekMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDakU7UUFDRCxJQUFJLElBQUksQ0FBQyxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQzVCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUM7U0FDdkM7UUFDRCxJQUFJLElBQUksQ0FBQyxlQUFlLEtBQUssU0FBUyxFQUFFO1lBQ3RDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDM0Q7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBdUQ7UUFDOUUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsU0FBUyxDQUFDO1lBQzVCLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxTQUFTLENBQUM7WUFDekMsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7WUFDaEMsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7WUFDL0IsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztZQUN2QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO1lBQ3BDLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO1NBQ2xDO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7WUFDbEMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztZQUM1RCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7WUFDMUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1lBQ3hDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7WUFDeEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztZQUNsRCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7WUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1NBQzdDO0lBQ0gsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDOUQsQ0FBQztJQUNELElBQVcsc0JBQXNCLENBQUMsS0FBa0M7UUFDbEUsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLHVCQUF1QixDQUFDO0lBQ3RDLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBYTtRQUNwQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQWE7UUFDbkMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUNNLGlCQUFpQjtRQUN0QixJQUFJLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUNqQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFhO1FBQzNDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNNLHlCQUF5QjtRQUM5QixJQUFJLENBQUMscUJBQXFCLEdBQUcsU0FBUyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBYTtRQUN4QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDOztBQTVMSCxrSEE2TEM7OztBQVlELFNBQWdCLG9DQUFvQyxDQUFDLE1BQTZFO0lBQ2hJLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsV0FBVyxDQUFDO1FBQzFELGFBQWEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFlBQVksQ0FBQztLQUM3RCxDQUFBO0FBQ0gsQ0FBQztBQVRELG9GQVNDO0FBRUQsTUFBYSx3Q0FBeUMsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUcvRTs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsWUFBWSxLQUFLLFNBQVMsRUFBRTtZQUNuQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1NBQ3JEO1FBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLFNBQVMsRUFBRTtZQUNwQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1NBQ3ZEO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQTRDO1FBQ25FLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztTQUNoQzthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1lBQ3RDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztTQUN6QztJQUNILENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBYTtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDOztBQTlESCw0RkErREM7OztBQWdCRCxTQUFnQixpREFBaUQsQ0FBQyxNQUF1RztJQUN2SyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLGNBQWMsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxNQUFPLENBQUMsYUFBYSxDQUFDO1FBQ3ZGLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFdBQVcsQ0FBQztRQUN6RCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxNQUFPLENBQUMsZ0JBQWdCLENBQUM7S0FDOUYsQ0FBQTtBQUNILENBQUM7QUFWRCw4R0FVQztBQUVELE1BQWEscURBQXNELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHNUY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLGNBQWMsS0FBSyxTQUFTLEVBQUU7WUFDckMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztTQUN6RDtRQUNELElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7WUFDbkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELElBQUksSUFBSSxDQUFDLGlCQUFpQixLQUFLLFNBQVMsRUFBRTtZQUN4QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztTQUMvRDtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUF5RDtRQUNoRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7WUFDaEMsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7WUFDOUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztTQUNwQzthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1lBQzFDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztZQUN0QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1NBQ2pEO0lBQ0gsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQWU7UUFDdEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUNNLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztJQUNsQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDckUsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBZTtRQUN6QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7O0FBdkZILHNIQXdGQzs7O0FBd0JELFNBQWdCLDRDQUE0QyxDQUFDLE1BQTZGO0lBQ3hKLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wseUJBQXlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxzQkFBc0IsQ0FBQztRQUNsRiwyQkFBMkIsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxNQUFPLENBQUMsdUJBQXVCLENBQUM7UUFDOUcsK0JBQStCLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLENBQUMsTUFBTyxDQUFDLDBCQUEwQixDQUFDO1FBQ3JILFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFVBQVUsQ0FBQztRQUN4RCxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxLQUFLLENBQUM7S0FDOUMsQ0FBQTtBQUNILENBQUM7QUFaRCxvR0FZQztBQUVELE1BQWEsZ0RBQWlELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHdkY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLHVCQUF1QixLQUFLLFNBQVMsRUFBRTtZQUM5QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHNCQUFzQixHQUFHLElBQUksQ0FBQyx1QkFBdUIsQ0FBQztTQUMzRTtRQUNELElBQUksSUFBSSxDQUFDLHdCQUF3QixLQUFLLFNBQVMsRUFBRTtZQUMvQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztTQUM3RTtRQUNELElBQUksSUFBSSxDQUFDLDJCQUEyQixLQUFLLFNBQVMsRUFBRTtZQUNsRCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLDBCQUEwQixHQUFHLElBQUksQ0FBQywyQkFBMkIsQ0FBQztTQUNuRjtRQUNELElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLEVBQUU7WUFDbEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztTQUNuRDtRQUNELElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxTQUFTLEVBQUU7WUFDN0IsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztTQUN6QztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUFvRDtRQUMzRSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLHVCQUF1QixHQUFHLFNBQVMsQ0FBQztZQUN6QyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsU0FBUyxDQUFDO1lBQzFDLElBQUksQ0FBQywyQkFBMkIsR0FBRyxTQUFTLENBQUM7WUFDN0MsSUFBSSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUM7WUFDN0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxTQUFTLENBQUM7U0FDekI7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsc0JBQXNCLENBQUM7WUFDNUQsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztZQUM5RCxJQUFJLENBQUMsMkJBQTJCLEdBQUcsS0FBSyxDQUFDLDBCQUEwQixDQUFDO1lBQ3BFLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztZQUNwQyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7U0FDM0I7SUFDSCxDQUFDO0lBSUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBQ0QsSUFBVyxzQkFBc0IsQ0FBQyxLQUFhO1FBQzdDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUM7SUFDdkMsQ0FBQztJQUNNLDJCQUEyQjtRQUNoQyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsU0FBUyxDQUFDO0lBQzNDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsdUJBQXVCLENBQUM7SUFDdEMsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sS0FBSyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLDZCQUE2QixDQUFDLENBQUMsQ0FBQztJQUMvRSxDQUFDO0lBQ0QsSUFBVyx1QkFBdUIsQ0FBQyxLQUFlO1FBQ2hELElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUM7SUFDeEMsQ0FBQztJQUNNLDRCQUE0QjtRQUNqQyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsU0FBUyxDQUFDO0lBQzVDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw0QkFBNEI7UUFDckMsT0FBTyxJQUFJLENBQUMsd0JBQXdCLENBQUM7SUFDdkMsQ0FBQztJQUlELElBQVcsMEJBQTBCO1FBQ25DLE9BQU8sS0FBSyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGlDQUFpQyxDQUFDLENBQUMsQ0FBQztJQUNuRixDQUFDO0lBQ0QsSUFBVywwQkFBMEIsQ0FBQyxLQUFlO1FBQ25ELElBQUksQ0FBQywyQkFBMkIsR0FBRyxLQUFLLENBQUM7SUFDM0MsQ0FBQztJQUNNLCtCQUErQjtRQUNwQyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsU0FBUyxDQUFDO0lBQy9DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywrQkFBK0I7UUFDeEMsT0FBTyxJQUFJLENBQUMsMkJBQTJCLENBQUM7SUFDMUMsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsS0FBSztRQUNkLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFDRCxJQUFXLEtBQUssQ0FBQyxLQUFhO1FBQzVCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBQ3RCLENBQUM7SUFDTSxVQUFVO1FBQ2YsSUFBSSxDQUFDLE1BQU0sR0FBRyxTQUFTLENBQUM7SUFDMUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7O0FBbklILDRHQW9JQzs7O0FBb0JELFNBQWdCLDBDQUEwQyxDQUFDLE1BQXlGO0lBQ2xKLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLHVCQUF1QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMscUJBQXFCLENBQUM7UUFDL0UsV0FBVyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDLE1BQU8sQ0FBQyxVQUFVLENBQUM7UUFDakYsWUFBWSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDLE1BQU8sQ0FBQyxXQUFXLENBQUM7S0FDcEYsQ0FBQTtBQUNILENBQUM7QUFYRCxnR0FXQztBQUVELE1BQWEsOENBQStDLFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHckY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDNUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2QztRQUNELElBQUksSUFBSSxDQUFDLHNCQUFzQixLQUFLLFNBQVMsRUFBRTtZQUM3QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztTQUN6RTtRQUNELElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLEVBQUU7WUFDbEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztTQUNuRDtRQUNELElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7WUFDbkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUFrRDtRQUN6RSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7WUFDdkIsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFNBQVMsQ0FBQztZQUN4QyxJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztZQUM3QixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztTQUMvQjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7WUFDMUQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1lBQ3BDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztTQUN2QztJQUNILENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUNELElBQVcscUJBQXFCLENBQUMsS0FBYTtRQUM1QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO0lBQ3RDLENBQUM7SUFDTSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFNBQVMsQ0FBQztJQUMxQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMEJBQTBCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3JDLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxLQUFLLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUMvRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBZTtRQUNuQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFlO1FBQ3BDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7O0FBMUdILHdHQTJHQzs7O0FBUUQsU0FBZ0IsOENBQThDLENBQUMsTUFBaUc7SUFDOUosSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxtQkFBbUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGtCQUFrQixDQUFDO0tBQ3pFLENBQUE7QUFDSCxDQUFDO0FBUkQsd0dBUUM7QUFFRCxNQUFhLGtEQUFtRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3pGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxtQkFBbUIsS0FBSyxTQUFTLEVBQUU7WUFDMUMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7U0FDbkU7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBc0Q7UUFDN0UsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7U0FDdEM7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7U0FDckQ7SUFDSCxDQUFDO0lBSUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFhO1FBQ3pDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDOztBQTNDSCxnSEE0Q0M7OztBQUVEOztFQUVFO0FBQ0YsTUFBYSxXQUFZLFNBQVEsS0FBSyxDQUFDLGlCQUFpQjtJQU90RCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZDs7Ozs7O01BTUU7SUFDRixZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUF5QjtRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLGtCQUFrQjtZQUN6QywwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLEtBQUs7Z0JBQ25CLGVBQWUsRUFBRSxPQUFPO2dCQUN4Qix5QkFBeUIsRUFBRSxRQUFRO2FBQ3BDO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLFlBQVksRUFBRSxNQUFNLENBQUMsWUFBWTtZQUNqQyxVQUFVLEVBQUUsTUFBTSxDQUFDLFVBQVU7WUFDN0IsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPO1NBQ3hCLENBQUMsQ0FBQztRQTZFTCwwRkFBMEY7UUFDbEYsdUNBQWtDLEdBQUcsSUFBSSwyREFBMkQsQ0FBQyxJQUFJLEVBQUUsc0NBQXNDLENBQUMsQ0FBQztRQWUzSixzRUFBc0U7UUFDOUQscUJBQWdCLEdBQUcsSUFBSSx5Q0FBeUMsQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQWVuRyw0RkFBNEY7UUFDcEYsd0NBQW1DLEdBQUcsSUFBSSw0REFBNEQsQ0FBQyxJQUFJLEVBQUUsd0NBQXdDLENBQUMsQ0FBQztRQWUvSixxRkFBcUY7UUFDN0Usa0NBQTZCLEdBQUcsSUFBSSxzREFBc0QsQ0FBQyxJQUFJLEVBQUUsaUNBQWlDLENBQUMsQ0FBQztRQWU1SSxrRkFBa0Y7UUFDMUUsK0JBQTBCLEdBQUcsSUFBSSxtREFBbUQsQ0FBQyxJQUFJLEVBQUUsOEJBQThCLENBQUMsQ0FBQztRQWVuSSxxRUFBcUU7UUFDN0Qsb0JBQWUsR0FBRyxJQUFJLHdDQUF3QyxDQUFDLElBQUksRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1FBZWhHLG9GQUFvRjtRQUM1RSxpQ0FBNEIsR0FBRyxJQUFJLHFEQUFxRCxDQUFDLElBQUksRUFBRSxnQ0FBZ0MsQ0FBQyxDQUFDO1FBZXpJLCtFQUErRTtRQUN2RSw0QkFBdUIsR0FBRyxJQUFJLGdEQUFnRCxDQUFDLElBQUksRUFBRSwyQkFBMkIsQ0FBQyxDQUFDO1FBZTFILDRFQUE0RTtRQUNwRSwwQkFBcUIsR0FBRyxJQUFJLDhDQUE4QyxDQUFDLElBQUksRUFBRSx3QkFBd0IsQ0FBQyxDQUFDO1FBZW5ILGdGQUFnRjtRQUN4RSw4QkFBeUIsR0FBRyxJQUFJLGtEQUFrRCxDQUFDLElBQUksRUFBRSw0QkFBNEIsQ0FBQyxDQUFDO1FBN043SCxJQUFJLENBQUMsR0FBRyxHQUFHLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFDckIsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsa0NBQWtDLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxpQ0FBaUMsQ0FBQztRQUNqRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDN0QsSUFBSSxDQUFDLG1DQUFtQyxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsa0NBQWtDLENBQUM7UUFDbkcsSUFBSSxDQUFDLDZCQUE2QixDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsNEJBQTRCLENBQUM7UUFDdkYsSUFBSSxDQUFDLDBCQUEwQixDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDakYsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUMzRCxJQUFJLENBQUMsNEJBQTRCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQywyQkFBMkIsQ0FBQztRQUNyRixJQUFJLENBQUMsdUJBQXVCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQztRQUMzRSxJQUFJLENBQUMscUJBQXFCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RSxJQUFJLENBQUMseUJBQXlCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQztJQUNqRixDQUFDO0lBUUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBYTtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFFRCwyREFBMkQ7SUFDM0QsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVELDBEQUEwRDtJQUMxRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQseURBQXlEO0lBQ3pELElBQVcsR0FBRztRQUNaLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFJRCxJQUFXLGlDQUFpQztRQUMxQyxPQUFPLElBQUksQ0FBQyxrQ0FBa0MsQ0FBQztJQUNqRCxDQUFDO0lBQ00sb0NBQW9DLENBQUMsS0FBbUQ7UUFDN0YsSUFBSSxDQUFDLGtDQUFrQyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDaEUsQ0FBQztJQUNNLHNDQUFzQztRQUMzQyxJQUFJLENBQUMsa0NBQWtDLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUNwRSxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsc0NBQXNDO1FBQy9DLE9BQU8sSUFBSSxDQUFDLGtDQUFrQyxDQUFDLGFBQWEsQ0FBQztJQUMvRCxDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFDTSxrQkFBa0IsQ0FBQyxLQUFpQztRQUN6RCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM5QyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2xELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLGtDQUFrQztRQUMzQyxPQUFPLElBQUksQ0FBQyxtQ0FBbUMsQ0FBQztJQUNsRCxDQUFDO0lBQ00scUNBQXFDLENBQUMsS0FBb0Q7UUFDL0YsSUFBSSxDQUFDLG1DQUFtQyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDakUsQ0FBQztJQUNNLHVDQUF1QztRQUM1QyxJQUFJLENBQUMsbUNBQW1DLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUNyRSxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUNBQXVDO1FBQ2hELE9BQU8sSUFBSSxDQUFDLG1DQUFtQyxDQUFDLGFBQWEsQ0FBQztJQUNoRSxDQUFDO0lBSUQsSUFBVyw0QkFBNEI7UUFDckMsT0FBTyxJQUFJLENBQUMsNkJBQTZCLENBQUM7SUFDNUMsQ0FBQztJQUNNLCtCQUErQixDQUFDLEtBQThDO1FBQ25GLElBQUksQ0FBQyw2QkFBNkIsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzNELENBQUM7SUFDTSxpQ0FBaUM7UUFDdEMsSUFBSSxDQUFDLDZCQUE2QixDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDL0QsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlDQUFpQztRQUMxQyxPQUFPLElBQUksQ0FBQyw2QkFBNkIsQ0FBQyxhQUFhLENBQUM7SUFDMUQsQ0FBQztJQUlELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFDTSw0QkFBNEIsQ0FBQyxLQUEyQztRQUM3RSxJQUFJLENBQUMsMEJBQTBCLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN4RCxDQUFDO0lBQ00sOEJBQThCO1FBQ25DLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQzVELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw4QkFBOEI7UUFDdkMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUMsYUFBYSxDQUFDO0lBQ3ZELENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFDTSxpQkFBaUIsQ0FBQyxLQUFnQztRQUN2RCxJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0MsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDO0lBQzVDLENBQUM7SUFJRCxJQUFXLDJCQUEyQjtRQUNwQyxPQUFPLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztJQUMzQyxDQUFDO0lBQ00sOEJBQThCLENBQUMsS0FBNkM7UUFDakYsSUFBSSxDQUFDLDRCQUE0QixDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDMUQsQ0FBQztJQUNNLGdDQUFnQztRQUNyQyxJQUFJLENBQUMsNEJBQTRCLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUM5RCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0NBQWdDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLDRCQUE0QixDQUFDLGFBQWEsQ0FBQztJQUN6RCxDQUFDO0lBSUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsdUJBQXVCLENBQUM7SUFDdEMsQ0FBQztJQUNNLHlCQUF5QixDQUFDLEtBQXdDO1FBQ3ZFLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3JELENBQUM7SUFDTSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDekQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDJCQUEyQjtRQUNwQyxPQUFPLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxhQUFhLENBQUM7SUFDcEQsQ0FBQztJQUlELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFDTSx1QkFBdUIsQ0FBQyxLQUFzQztRQUNuRSxJQUFJLENBQUMscUJBQXFCLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUNuRCxDQUFDO0lBQ00seUJBQXlCO1FBQzlCLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUMsYUFBYSxDQUFDO0lBQ2xELENBQUM7SUFJRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztJQUN4QyxDQUFDO0lBQ00sMkJBQTJCLENBQUMsS0FBMEM7UUFDM0UsSUFBSSxDQUFDLHlCQUF5QixDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDdkQsQ0FBQztJQUNNLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMseUJBQXlCLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMzRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNkJBQTZCO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDLGFBQWEsQ0FBQztJQUN0RCxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxFQUFFLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7WUFDckMsYUFBYSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDO1lBQzFELElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUN6QyxvQ0FBb0MsRUFBRSx1REFBdUQsQ0FBQyxJQUFJLENBQUMsa0NBQWtDLENBQUMsYUFBYSxDQUFDO1lBQ3BKLGdCQUFnQixFQUFFLHFDQUFxQyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUM7WUFDNUYsc0NBQXNDLEVBQUUsd0RBQXdELENBQUMsSUFBSSxDQUFDLG1DQUFtQyxDQUFDLGFBQWEsQ0FBQztZQUN4SiwrQkFBK0IsRUFBRSxrREFBa0QsQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUMsYUFBYSxDQUFDO1lBQ3JJLDRCQUE0QixFQUFFLCtDQUErQyxDQUFDLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxhQUFhLENBQUM7WUFDNUgsZUFBZSxFQUFFLG9DQUFvQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDO1lBQ3pGLDhCQUE4QixFQUFFLGlEQUFpRCxDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxhQUFhLENBQUM7WUFDbEkseUJBQXlCLEVBQUUsNENBQTRDLENBQUMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLGFBQWEsQ0FBQztZQUNuSCxzQkFBc0IsRUFBRSwwQ0FBMEMsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsYUFBYSxDQUFDO1lBQzVHLDBCQUEwQixFQUFFLDhDQUE4QyxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxhQUFhLENBQUM7U0FDekgsQ0FBQztJQUNKLENBQUM7O0FBbFNILGtDQW1TQzs7O0FBalNDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csMEJBQWMsR0FBRyxrQkFBa0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3lcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBMYmFhc1BvbGljeUNvbmZpZyBleHRlbmRzIGNka3RmLlRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjaWQgTGJhYXNQb2xpY3kjaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNsb2FkX2JhbGFuY2VyIExiYWFzUG9saWN5I2xvYWRfYmFsYW5jZXJ9XG4gICovXG4gIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjbmFtZSBMYmFhc1BvbGljeSNuYW1lfVxuICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIGFwcGxpY2F0aW9uX2Nvb2tpZV9zdGlja2luZXNzX3BvbGljeSBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNhcHBsaWNhdGlvbl9jb29raWVfc3RpY2tpbmVzc19wb2xpY3kgTGJhYXNQb2xpY3kjYXBwbGljYXRpb25fY29va2llX3N0aWNraW5lc3NfcG9saWN5fVxuICAqL1xuICByZWFkb25seSBhcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3k/OiBMYmFhc1BvbGljeUFwcGxpY2F0aW9uQ29va2llU3RpY2tpbmVzc1BvbGljeTtcbiAgLyoqXG4gICogY2xvdWRnYXRlX3BvbGljeSBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNjbG91ZGdhdGVfcG9saWN5IExiYWFzUG9saWN5I2Nsb3VkZ2F0ZV9wb2xpY3l9XG4gICovXG4gIHJlYWRvbmx5IGNsb3VkZ2F0ZVBvbGljeT86IExiYWFzUG9saWN5Q2xvdWRnYXRlUG9saWN5O1xuICAvKipcbiAgKiBsb2FkX2JhbGFuY2VyX2Nvb2tpZV9zdGlja2luZXNzX3BvbGljeSBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNsb2FkX2JhbGFuY2VyX2Nvb2tpZV9zdGlja2luZXNzX3BvbGljeSBMYmFhc1BvbGljeSNsb2FkX2JhbGFuY2VyX2Nvb2tpZV9zdGlja2luZXNzX3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgbG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeT86IExiYWFzUG9saWN5TG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeTtcbiAgLyoqXG4gICogbG9hZF9iYWxhbmNpbmdfbWVjaGFuaXNtX3BvbGljeSBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNsb2FkX2JhbGFuY2luZ19tZWNoYW5pc21fcG9saWN5IExiYWFzUG9saWN5I2xvYWRfYmFsYW5jaW5nX21lY2hhbmlzbV9wb2xpY3l9XG4gICovXG4gIHJlYWRvbmx5IGxvYWRCYWxhbmNpbmdNZWNoYW5pc21Qb2xpY3k/OiBMYmFhc1BvbGljeUxvYWRCYWxhbmNpbmdNZWNoYW5pc21Qb2xpY3k7XG4gIC8qKlxuICAqIHJhdGVfbGltaXRpbmdfcmVxdWVzdF9wb2xpY3kgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjcmF0ZV9saW1pdGluZ19yZXF1ZXN0X3BvbGljeSBMYmFhc1BvbGljeSNyYXRlX2xpbWl0aW5nX3JlcXVlc3RfcG9saWN5fVxuICAqL1xuICByZWFkb25seSByYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5PzogTGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5O1xuICAvKipcbiAgKiByZWRpcmVjdF9wb2xpY3kgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjcmVkaXJlY3RfcG9saWN5IExiYWFzUG9saWN5I3JlZGlyZWN0X3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgcmVkaXJlY3RQb2xpY3k/OiBMYmFhc1BvbGljeVJlZGlyZWN0UG9saWN5O1xuICAvKipcbiAgKiByZXNvdXJjZV9hY2Nlc3NfY29udHJvbF9wb2xpY3kgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjcmVzb3VyY2VfYWNjZXNzX2NvbnRyb2xfcG9saWN5IExiYWFzUG9saWN5I3Jlc291cmNlX2FjY2Vzc19jb250cm9sX3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5PzogTGJhYXNQb2xpY3lSZXNvdXJjZUFjY2Vzc0NvbnRyb2xQb2xpY3k7XG4gIC8qKlxuICAqIHNldF9yZXF1ZXN0X2hlYWRlcl9wb2xpY3kgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjc2V0X3JlcXVlc3RfaGVhZGVyX3BvbGljeSBMYmFhc1BvbGljeSNzZXRfcmVxdWVzdF9oZWFkZXJfcG9saWN5fVxuICAqL1xuICByZWFkb25seSBzZXRSZXF1ZXN0SGVhZGVyUG9saWN5PzogTGJhYXNQb2xpY3lTZXRSZXF1ZXN0SGVhZGVyUG9saWN5O1xuICAvKipcbiAgKiBzc2xfbmVnb3RpYXRpb25fcG9saWN5IGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I3NzbF9uZWdvdGlhdGlvbl9wb2xpY3kgTGJhYXNQb2xpY3kjc3NsX25lZ290aWF0aW9uX3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgc3NsTmVnb3RpYXRpb25Qb2xpY3k/OiBMYmFhc1BvbGljeVNzbE5lZ290aWF0aW9uUG9saWN5O1xuICAvKipcbiAgKiB0cnVzdGVkX2NlcnRpZmljYXRlX3BvbGljeSBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSN0cnVzdGVkX2NlcnRpZmljYXRlX3BvbGljeSBMYmFhc1BvbGljeSN0cnVzdGVkX2NlcnRpZmljYXRlX3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgdHJ1c3RlZENlcnRpZmljYXRlUG9saWN5PzogTGJhYXNQb2xpY3lUcnVzdGVkQ2VydGlmaWNhdGVQb2xpY3k7XG59XG5leHBvcnQgaW50ZXJmYWNlIExiYWFzUG9saWN5QXBwbGljYXRpb25Db29raWVTdGlja2luZXNzUG9saWN5IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I2Nvb2tpZV9uYW1lIExiYWFzUG9saWN5I2Nvb2tpZV9uYW1lfVxuICAqL1xuICByZWFkb25seSBjb29raWVOYW1lOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBsYmFhc1BvbGljeUFwcGxpY2F0aW9uQ29va2llU3RpY2tpbmVzc1BvbGljeVRvVGVycmFmb3JtKHN0cnVjdD86IExiYWFzUG9saWN5QXBwbGljYXRpb25Db29raWVTdGlja2luZXNzUG9saWN5T3V0cHV0UmVmZXJlbmNlIHwgTGJhYXNQb2xpY3lBcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3kpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgY29va2llX25hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuY29va2llTmFtZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIExiYWFzUG9saWN5QXBwbGljYXRpb25Db29raWVTdGlja2luZXNzUG9saWN5T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBMYmFhc1BvbGljeUFwcGxpY2F0aW9uQ29va2llU3RpY2tpbmVzc1BvbGljeSB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY29va2llTmFtZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5jb29raWVOYW1lID0gdGhpcy5fY29va2llTmFtZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IExiYWFzUG9saWN5QXBwbGljYXRpb25Db29raWVTdGlja2luZXNzUG9saWN5IHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fY29va2llTmFtZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fY29va2llTmFtZSA9IHZhbHVlLmNvb2tpZU5hbWU7XG4gICAgfVxuICB9XG5cbiAgLy8gY29va2llX25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfY29va2llTmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY29va2llTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Nvb2tpZV9uYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBjb29raWVOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jb29raWVOYW1lID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNvb2tpZU5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY29va2llTmFtZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBMYmFhc1BvbGljeUNsb3VkZ2F0ZVBvbGljeSB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNjbG91ZGdhdGVfYXBwbGljYXRpb24gTGJhYXNQb2xpY3kjY2xvdWRnYXRlX2FwcGxpY2F0aW9ufVxuICAqL1xuICByZWFkb25seSBjbG91ZGdhdGVBcHBsaWNhdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I2Nsb3VkZ2F0ZV9wb2xpY3lfbmFtZSBMYmFhc1BvbGljeSNjbG91ZGdhdGVfcG9saWN5X25hbWV9XG4gICovXG4gIHJlYWRvbmx5IGNsb3VkZ2F0ZVBvbGljeU5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNpZGVudGl0eV9zZXJ2aWNlX2luc3RhbmNlX2d1aWQgTGJhYXNQb2xpY3kjaWRlbnRpdHlfc2VydmljZV9pbnN0YW5jZV9ndWlkfVxuICAqL1xuICByZWFkb25seSBpZGVudGl0eVNlcnZpY2VJbnN0YW5jZUd1aWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSN2aXJ0dWFsX2hvc3RuYW1lX2Zvcl9wb2xpY3lfYXR0cmlidXRpb24gTGJhYXNQb2xpY3kjdmlydHVhbF9ob3N0bmFtZV9mb3JfcG9saWN5X2F0dHJpYnV0aW9ufVxuICAqL1xuICByZWFkb25seSB2aXJ0dWFsSG9zdG5hbWVGb3JQb2xpY3lBdHRyaWJ1dGlvbjogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbGJhYXNQb2xpY3lDbG91ZGdhdGVQb2xpY3lUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBMYmFhc1BvbGljeUNsb3VkZ2F0ZVBvbGljeU91dHB1dFJlZmVyZW5jZSB8IExiYWFzUG9saWN5Q2xvdWRnYXRlUG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGNsb3VkZ2F0ZV9hcHBsaWNhdGlvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5jbG91ZGdhdGVBcHBsaWNhdGlvbiksXG4gICAgY2xvdWRnYXRlX3BvbGljeV9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmNsb3VkZ2F0ZVBvbGljeU5hbWUpLFxuICAgIGlkZW50aXR5X3NlcnZpY2VfaW5zdGFuY2VfZ3VpZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5pZGVudGl0eVNlcnZpY2VJbnN0YW5jZUd1aWQpLFxuICAgIHZpcnR1YWxfaG9zdG5hbWVfZm9yX3BvbGljeV9hdHRyaWJ1dGlvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS52aXJ0dWFsSG9zdG5hbWVGb3JQb2xpY3lBdHRyaWJ1dGlvbiksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIExiYWFzUG9saWN5Q2xvdWRnYXRlUG9saWN5T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBMYmFhc1BvbGljeUNsb3VkZ2F0ZVBvbGljeSB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY2xvdWRnYXRlQXBwbGljYXRpb24gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2xvdWRnYXRlQXBwbGljYXRpb24gPSB0aGlzLl9jbG91ZGdhdGVBcHBsaWNhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2Nsb3VkZ2F0ZVBvbGljeU5hbWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2xvdWRnYXRlUG9saWN5TmFtZSA9IHRoaXMuX2Nsb3VkZ2F0ZVBvbGljeU5hbWU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9pZGVudGl0eVNlcnZpY2VJbnN0YW5jZUd1aWQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuaWRlbnRpdHlTZXJ2aWNlSW5zdGFuY2VHdWlkID0gdGhpcy5faWRlbnRpdHlTZXJ2aWNlSW5zdGFuY2VHdWlkO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdmlydHVhbEhvc3RuYW1lRm9yUG9saWN5QXR0cmlidXRpb24gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudmlydHVhbEhvc3RuYW1lRm9yUG9saWN5QXR0cmlidXRpb24gPSB0aGlzLl92aXJ0dWFsSG9zdG5hbWVGb3JQb2xpY3lBdHRyaWJ1dGlvbjtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IExiYWFzUG9saWN5Q2xvdWRnYXRlUG9saWN5IHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fY2xvdWRnYXRlQXBwbGljYXRpb24gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9jbG91ZGdhdGVQb2xpY3lOYW1lID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5faWRlbnRpdHlTZXJ2aWNlSW5zdGFuY2VHdWlkID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdmlydHVhbEhvc3RuYW1lRm9yUG9saWN5QXR0cmlidXRpb24gPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2Nsb3VkZ2F0ZUFwcGxpY2F0aW9uID0gdmFsdWUuY2xvdWRnYXRlQXBwbGljYXRpb247XG4gICAgICB0aGlzLl9jbG91ZGdhdGVQb2xpY3lOYW1lID0gdmFsdWUuY2xvdWRnYXRlUG9saWN5TmFtZTtcbiAgICAgIHRoaXMuX2lkZW50aXR5U2VydmljZUluc3RhbmNlR3VpZCA9IHZhbHVlLmlkZW50aXR5U2VydmljZUluc3RhbmNlR3VpZDtcbiAgICAgIHRoaXMuX3ZpcnR1YWxIb3N0bmFtZUZvclBvbGljeUF0dHJpYnV0aW9uID0gdmFsdWUudmlydHVhbEhvc3RuYW1lRm9yUG9saWN5QXR0cmlidXRpb247XG4gICAgfVxuICB9XG5cbiAgLy8gY2xvdWRnYXRlX2FwcGxpY2F0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Nsb3VkZ2F0ZUFwcGxpY2F0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjbG91ZGdhdGVBcHBsaWNhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Nsb3VkZ2F0ZV9hcHBsaWNhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2xvdWRnYXRlQXBwbGljYXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2Nsb3VkZ2F0ZUFwcGxpY2F0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q2xvdWRnYXRlQXBwbGljYXRpb24oKSB7XG4gICAgdGhpcy5fY2xvdWRnYXRlQXBwbGljYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNsb3VkZ2F0ZUFwcGxpY2F0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Nsb3VkZ2F0ZUFwcGxpY2F0aW9uO1xuICB9XG5cbiAgLy8gY2xvdWRnYXRlX3BvbGljeV9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Nsb3VkZ2F0ZVBvbGljeU5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNsb3VkZ2F0ZVBvbGljeU5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjbG91ZGdhdGVfcG9saWN5X25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNsb3VkZ2F0ZVBvbGljeU5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2Nsb3VkZ2F0ZVBvbGljeU5hbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDbG91ZGdhdGVQb2xpY3lOYW1lKCkge1xuICAgIHRoaXMuX2Nsb3VkZ2F0ZVBvbGljeU5hbWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNsb3VkZ2F0ZVBvbGljeU5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2xvdWRnYXRlUG9saWN5TmFtZTtcbiAgfVxuXG4gIC8vIGlkZW50aXR5X3NlcnZpY2VfaW5zdGFuY2VfZ3VpZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZGVudGl0eVNlcnZpY2VJbnN0YW5jZUd1aWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGlkZW50aXR5U2VydmljZUluc3RhbmNlR3VpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkZW50aXR5X3NlcnZpY2VfaW5zdGFuY2VfZ3VpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWRlbnRpdHlTZXJ2aWNlSW5zdGFuY2VHdWlkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9pZGVudGl0eVNlcnZpY2VJbnN0YW5jZUd1aWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZGVudGl0eVNlcnZpY2VJbnN0YW5jZUd1aWQoKSB7XG4gICAgdGhpcy5faWRlbnRpdHlTZXJ2aWNlSW5zdGFuY2VHdWlkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpZGVudGl0eVNlcnZpY2VJbnN0YW5jZUd1aWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWRlbnRpdHlTZXJ2aWNlSW5zdGFuY2VHdWlkO1xuICB9XG5cbiAgLy8gdmlydHVhbF9ob3N0bmFtZV9mb3JfcG9saWN5X2F0dHJpYnV0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3ZpcnR1YWxIb3N0bmFtZUZvclBvbGljeUF0dHJpYnV0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB2aXJ0dWFsSG9zdG5hbWVGb3JQb2xpY3lBdHRyaWJ1dGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3ZpcnR1YWxfaG9zdG5hbWVfZm9yX3BvbGljeV9hdHRyaWJ1dGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdmlydHVhbEhvc3RuYW1lRm9yUG9saWN5QXR0cmlidXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3ZpcnR1YWxIb3N0bmFtZUZvclBvbGljeUF0dHJpYnV0aW9uID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHZpcnR1YWxIb3N0bmFtZUZvclBvbGljeUF0dHJpYnV0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZpcnR1YWxIb3N0bmFtZUZvclBvbGljeUF0dHJpYnV0aW9uO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIExiYWFzUG9saWN5TG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeSB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNjb29raWVfZXhwaXJhdGlvbl9wZXJpb2QgTGJhYXNQb2xpY3kjY29va2llX2V4cGlyYXRpb25fcGVyaW9kfVxuICAqL1xuICByZWFkb25seSBjb29raWVFeHBpcmF0aW9uUGVyaW9kOiBudW1iZXI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBsYmFhc1BvbGljeUxvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3lUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBMYmFhc1BvbGljeUxvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3lPdXRwdXRSZWZlcmVuY2UgfCBMYmFhc1BvbGljeUxvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3kpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgY29va2llX2V4cGlyYXRpb25fcGVyaW9kOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmNvb2tpZUV4cGlyYXRpb25QZXJpb2QpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBMYmFhc1BvbGljeUxvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3lPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IExiYWFzUG9saWN5TG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeSB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY29va2llRXhwaXJhdGlvblBlcmlvZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5jb29raWVFeHBpcmF0aW9uUGVyaW9kID0gdGhpcy5fY29va2llRXhwaXJhdGlvblBlcmlvZDtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IExiYWFzUG9saWN5TG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeSB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2Nvb2tpZUV4cGlyYXRpb25QZXJpb2QgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2Nvb2tpZUV4cGlyYXRpb25QZXJpb2QgPSB2YWx1ZS5jb29raWVFeHBpcmF0aW9uUGVyaW9kO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNvb2tpZV9leHBpcmF0aW9uX3BlcmlvZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9jb29raWVFeHBpcmF0aW9uUGVyaW9kPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBjb29raWVFeHBpcmF0aW9uUGVyaW9kKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnY29va2llX2V4cGlyYXRpb25fcGVyaW9kJyk7XG4gIH1cbiAgcHVibGljIHNldCBjb29raWVFeHBpcmF0aW9uUGVyaW9kKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jb29raWVFeHBpcmF0aW9uUGVyaW9kID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNvb2tpZUV4cGlyYXRpb25QZXJpb2RJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY29va2llRXhwaXJhdGlvblBlcmlvZDtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBMYmFhc1BvbGljeUxvYWRCYWxhbmNpbmdNZWNoYW5pc21Qb2xpY3kge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjbG9hZF9iYWxhbmNpbmdfbWVjaGFuaXNtIExiYWFzUG9saWN5I2xvYWRfYmFsYW5jaW5nX21lY2hhbmlzbX1cbiAgKi9cbiAgcmVhZG9ubHkgbG9hZEJhbGFuY2luZ01lY2hhbmlzbTogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbGJhYXNQb2xpY3lMb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5VG9UZXJyYWZvcm0oc3RydWN0PzogTGJhYXNQb2xpY3lMb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5T3V0cHV0UmVmZXJlbmNlIHwgTGJhYXNQb2xpY3lMb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGxvYWRfYmFsYW5jaW5nX21lY2hhbmlzbTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5sb2FkQmFsYW5jaW5nTWVjaGFuaXNtKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgTGJhYXNQb2xpY3lMb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBMYmFhc1BvbGljeUxvYWRCYWxhbmNpbmdNZWNoYW5pc21Qb2xpY3kgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2xvYWRCYWxhbmNpbmdNZWNoYW5pc20gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQubG9hZEJhbGFuY2luZ01lY2hhbmlzbSA9IHRoaXMuX2xvYWRCYWxhbmNpbmdNZWNoYW5pc207XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBMYmFhc1BvbGljeUxvYWRCYWxhbmNpbmdNZWNoYW5pc21Qb2xpY3kgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9sb2FkQmFsYW5jaW5nTWVjaGFuaXNtID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9sb2FkQmFsYW5jaW5nTWVjaGFuaXNtID0gdmFsdWUubG9hZEJhbGFuY2luZ01lY2hhbmlzbTtcbiAgICB9XG4gIH1cblxuICAvLyBsb2FkX2JhbGFuY2luZ19tZWNoYW5pc20gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfbG9hZEJhbGFuY2luZ01lY2hhbmlzbT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbG9hZEJhbGFuY2luZ01lY2hhbmlzbSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2xvYWRfYmFsYW5jaW5nX21lY2hhbmlzbScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbG9hZEJhbGFuY2luZ01lY2hhbmlzbSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbG9hZEJhbGFuY2luZ01lY2hhbmlzbSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBsb2FkQmFsYW5jaW5nTWVjaGFuaXNtSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2xvYWRCYWxhbmNpbmdNZWNoYW5pc207XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgTGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I2J1cnN0X3NpemUgTGJhYXNQb2xpY3kjYnVyc3Rfc2l6ZX1cbiAgKi9cbiAgcmVhZG9ubHkgYnVyc3RTaXplOiBudW1iZXI7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNkZWxheV9leGNlc3NpdmVfcmVxdWVzdHMgTGJhYXNQb2xpY3kjZGVsYXlfZXhjZXNzaXZlX3JlcXVlc3RzfVxuICAqL1xuICByZWFkb25seSBkZWxheUV4Y2Vzc2l2ZVJlcXVlc3RzOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNodHRwX2Vycm9yX2NvZGUgTGJhYXNQb2xpY3kjaHR0cF9lcnJvcl9jb2RlfVxuICAqL1xuICByZWFkb25seSBodHRwRXJyb3JDb2RlPzogbnVtYmVyO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjbG9nZ2luZ19sZXZlbCBMYmFhc1BvbGljeSNsb2dnaW5nX2xldmVsfVxuICAqL1xuICByZWFkb25seSBsb2dnaW5nTGV2ZWw/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNyYXRlX2xpbWl0aW5nX2NyaXRlcmlhIExiYWFzUG9saWN5I3JhdGVfbGltaXRpbmdfY3JpdGVyaWF9XG4gICovXG4gIHJlYWRvbmx5IHJhdGVMaW1pdGluZ0NyaXRlcmlhPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjcmVxdWVzdHNfcGVyX3NlY29uZCBMYmFhc1BvbGljeSNyZXF1ZXN0c19wZXJfc2Vjb25kfVxuICAqL1xuICByZWFkb25seSByZXF1ZXN0c1BlclNlY29uZDogbnVtYmVyO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjem9uZSBMYmFhc1BvbGljeSN6b25lfVxuICAqL1xuICByZWFkb25seSB6b25lOiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSN6b25lX21lbW9yeV9zaXplIExiYWFzUG9saWN5I3pvbmVfbWVtb3J5X3NpemV9XG4gICovXG4gIHJlYWRvbmx5IHpvbmVNZW1vcnlTaXplPzogbnVtYmVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5VG9UZXJyYWZvcm0oc3RydWN0PzogTGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5T3V0cHV0UmVmZXJlbmNlIHwgTGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGJ1cnN0X3NpemU6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuYnVyc3RTaXplKSxcbiAgICBkZWxheV9leGNlc3NpdmVfcmVxdWVzdHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGF5RXhjZXNzaXZlUmVxdWVzdHMpLFxuICAgIGh0dHBfZXJyb3JfY29kZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5odHRwRXJyb3JDb2RlKSxcbiAgICBsb2dnaW5nX2xldmVsOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmxvZ2dpbmdMZXZlbCksXG4gICAgcmF0ZV9saW1pdGluZ19jcml0ZXJpYTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yYXRlTGltaXRpbmdDcml0ZXJpYSksXG4gICAgcmVxdWVzdHNfcGVyX3NlY29uZDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5yZXF1ZXN0c1BlclNlY29uZCksXG4gICAgem9uZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS56b25lKSxcbiAgICB6b25lX21lbW9yeV9zaXplOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLnpvbmVNZW1vcnlTaXplKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgTGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBMYmFhc1BvbGljeVJhdGVMaW1pdGluZ1JlcXVlc3RQb2xpY3kgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2J1cnN0U2l6ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5idXJzdFNpemUgPSB0aGlzLl9idXJzdFNpemU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9kZWxheUV4Y2Vzc2l2ZVJlcXVlc3RzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGF5RXhjZXNzaXZlUmVxdWVzdHMgPSB0aGlzLl9kZWxheUV4Y2Vzc2l2ZVJlcXVlc3RzO1xuICAgIH1cbiAgICBpZiAodGhpcy5faHR0cEVycm9yQ29kZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5odHRwRXJyb3JDb2RlID0gdGhpcy5faHR0cEVycm9yQ29kZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2xvZ2dpbmdMZXZlbCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5sb2dnaW5nTGV2ZWwgPSB0aGlzLl9sb2dnaW5nTGV2ZWw7XG4gICAgfVxuICAgIGlmICh0aGlzLl9yYXRlTGltaXRpbmdDcml0ZXJpYSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5yYXRlTGltaXRpbmdDcml0ZXJpYSA9IHRoaXMuX3JhdGVMaW1pdGluZ0NyaXRlcmlhO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVxdWVzdHNQZXJTZWNvbmQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVxdWVzdHNQZXJTZWNvbmQgPSB0aGlzLl9yZXF1ZXN0c1BlclNlY29uZDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3pvbmUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuem9uZSA9IHRoaXMuX3pvbmU7XG4gICAgfVxuICAgIGlmICh0aGlzLl96b25lTWVtb3J5U2l6ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC56b25lTWVtb3J5U2l6ZSA9IHRoaXMuX3pvbmVNZW1vcnlTaXplO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogTGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5IHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fYnVyc3RTaXplID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fZGVsYXlFeGNlc3NpdmVSZXF1ZXN0cyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2h0dHBFcnJvckNvZGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9sb2dnaW5nTGV2ZWwgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9yYXRlTGltaXRpbmdDcml0ZXJpYSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3JlcXVlc3RzUGVyU2Vjb25kID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fem9uZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3pvbmVNZW1vcnlTaXplID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9idXJzdFNpemUgPSB2YWx1ZS5idXJzdFNpemU7XG4gICAgICB0aGlzLl9kZWxheUV4Y2Vzc2l2ZVJlcXVlc3RzID0gdmFsdWUuZGVsYXlFeGNlc3NpdmVSZXF1ZXN0cztcbiAgICAgIHRoaXMuX2h0dHBFcnJvckNvZGUgPSB2YWx1ZS5odHRwRXJyb3JDb2RlO1xuICAgICAgdGhpcy5fbG9nZ2luZ0xldmVsID0gdmFsdWUubG9nZ2luZ0xldmVsO1xuICAgICAgdGhpcy5fcmF0ZUxpbWl0aW5nQ3JpdGVyaWEgPSB2YWx1ZS5yYXRlTGltaXRpbmdDcml0ZXJpYTtcbiAgICAgIHRoaXMuX3JlcXVlc3RzUGVyU2Vjb25kID0gdmFsdWUucmVxdWVzdHNQZXJTZWNvbmQ7XG4gICAgICB0aGlzLl96b25lID0gdmFsdWUuem9uZTtcbiAgICAgIHRoaXMuX3pvbmVNZW1vcnlTaXplID0gdmFsdWUuem9uZU1lbW9yeVNpemU7XG4gICAgfVxuICB9XG5cbiAgLy8gYnVyc3Rfc2l6ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9idXJzdFNpemU/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGJ1cnN0U2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2J1cnN0X3NpemUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGJ1cnN0U2l6ZSh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fYnVyc3RTaXplID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJ1cnN0U2l6ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9idXJzdFNpemU7XG4gIH1cblxuICAvLyBkZWxheV9leGNlc3NpdmVfcmVxdWVzdHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfZGVsYXlFeGNlc3NpdmVSZXF1ZXN0cz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZGVsYXlFeGNlc3NpdmVSZXF1ZXN0cygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdkZWxheV9leGNlc3NpdmVfcmVxdWVzdHMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGF5RXhjZXNzaXZlUmVxdWVzdHModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2RlbGF5RXhjZXNzaXZlUmVxdWVzdHMgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVsYXlFeGNlc3NpdmVSZXF1ZXN0c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxheUV4Y2Vzc2l2ZVJlcXVlc3RzO1xuICB9XG5cbiAgLy8gaHR0cF9lcnJvcl9jb2RlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2h0dHBFcnJvckNvZGU/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGh0dHBFcnJvckNvZGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdodHRwX2Vycm9yX2NvZGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGh0dHBFcnJvckNvZGUodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2h0dHBFcnJvckNvZGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRIdHRwRXJyb3JDb2RlKCkge1xuICAgIHRoaXMuX2h0dHBFcnJvckNvZGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGh0dHBFcnJvckNvZGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faHR0cEVycm9yQ29kZTtcbiAgfVxuXG4gIC8vIGxvZ2dpbmdfbGV2ZWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbG9nZ2luZ0xldmVsPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBsb2dnaW5nTGV2ZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdsb2dnaW5nX2xldmVsJyk7XG4gIH1cbiAgcHVibGljIHNldCBsb2dnaW5nTGV2ZWwodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2xvZ2dpbmdMZXZlbCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldExvZ2dpbmdMZXZlbCgpIHtcbiAgICB0aGlzLl9sb2dnaW5nTGV2ZWwgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGxvZ2dpbmdMZXZlbElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9sb2dnaW5nTGV2ZWw7XG4gIH1cblxuICAvLyByYXRlX2xpbWl0aW5nX2NyaXRlcmlhIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JhdGVMaW1pdGluZ0NyaXRlcmlhPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByYXRlTGltaXRpbmdDcml0ZXJpYSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JhdGVfbGltaXRpbmdfY3JpdGVyaWEnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJhdGVMaW1pdGluZ0NyaXRlcmlhKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yYXRlTGltaXRpbmdDcml0ZXJpYSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJhdGVMaW1pdGluZ0NyaXRlcmlhKCkge1xuICAgIHRoaXMuX3JhdGVMaW1pdGluZ0NyaXRlcmlhID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByYXRlTGltaXRpbmdDcml0ZXJpYUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yYXRlTGltaXRpbmdDcml0ZXJpYTtcbiAgfVxuXG4gIC8vIHJlcXVlc3RzX3Blcl9zZWNvbmQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcmVxdWVzdHNQZXJTZWNvbmQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHJlcXVlc3RzUGVyU2Vjb25kKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncmVxdWVzdHNfcGVyX3NlY29uZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWVzdHNQZXJTZWNvbmQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3JlcXVlc3RzUGVyU2Vjb25kID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcXVlc3RzUGVyU2Vjb25kSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcXVlc3RzUGVyU2Vjb25kO1xuICB9XG5cbiAgLy8gem9uZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF96b25lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB6b25lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnem9uZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgem9uZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fem9uZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB6b25lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3pvbmU7XG4gIH1cblxuICAvLyB6b25lX21lbW9yeV9zaXplIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3pvbmVNZW1vcnlTaXplPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCB6b25lTWVtb3J5U2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ3pvbmVfbWVtb3J5X3NpemUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHpvbmVNZW1vcnlTaXplKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl96b25lTWVtb3J5U2l6ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFpvbmVNZW1vcnlTaXplKCkge1xuICAgIHRoaXMuX3pvbmVNZW1vcnlTaXplID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB6b25lTWVtb3J5U2l6ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl96b25lTWVtb3J5U2l6ZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBMYmFhc1BvbGljeVJlZGlyZWN0UG9saWN5IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I3JlZGlyZWN0X3VyaSBMYmFhc1BvbGljeSNyZWRpcmVjdF91cml9XG4gICovXG4gIHJlYWRvbmx5IHJlZGlyZWN0VXJpOiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNyZXNwb25zZV9jb2RlIExiYWFzUG9saWN5I3Jlc3BvbnNlX2NvZGV9XG4gICovXG4gIHJlYWRvbmx5IHJlc3BvbnNlQ29kZTogbnVtYmVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbGJhYXNQb2xpY3lSZWRpcmVjdFBvbGljeVRvVGVycmFmb3JtKHN0cnVjdD86IExiYWFzUG9saWN5UmVkaXJlY3RQb2xpY3lPdXRwdXRSZWZlcmVuY2UgfCBMYmFhc1BvbGljeVJlZGlyZWN0UG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIHJlZGlyZWN0X3VyaTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yZWRpcmVjdFVyaSksXG4gICAgcmVzcG9uc2VfY29kZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5yZXNwb25zZUNvZGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBMYmFhc1BvbGljeVJlZGlyZWN0UG9saWN5T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBMYmFhc1BvbGljeVJlZGlyZWN0UG9saWN5IHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9yZWRpcmVjdFVyaSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5yZWRpcmVjdFVyaSA9IHRoaXMuX3JlZGlyZWN0VXJpO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVzcG9uc2VDb2RlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnJlc3BvbnNlQ29kZSA9IHRoaXMuX3Jlc3BvbnNlQ29kZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IExiYWFzUG9saWN5UmVkaXJlY3RQb2xpY3kgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9yZWRpcmVjdFVyaSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlQ29kZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fcmVkaXJlY3RVcmkgPSB2YWx1ZS5yZWRpcmVjdFVyaTtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlQ29kZSA9IHZhbHVlLnJlc3BvbnNlQ29kZTtcbiAgICB9XG4gIH1cblxuICAvLyByZWRpcmVjdF91cmkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcmVkaXJlY3RVcmk/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlZGlyZWN0VXJpKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVkaXJlY3RfdXJpJyk7XG4gIH1cbiAgcHVibGljIHNldCByZWRpcmVjdFVyaSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVkaXJlY3RVcmkgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVkaXJlY3RVcmlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVkaXJlY3RVcmk7XG4gIH1cblxuICAvLyByZXNwb25zZV9jb2RlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3Jlc3BvbnNlQ29kZT86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgcmVzcG9uc2VDb2RlKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncmVzcG9uc2VfY29kZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVzcG9uc2VDb2RlKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9yZXNwb25zZUNvZGUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVzcG9uc2VDb2RlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc3BvbnNlQ29kZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBMYmFhc1BvbGljeVJlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeSB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNkZW5pZWRfY2xpZW50cyBMYmFhc1BvbGljeSNkZW5pZWRfY2xpZW50c31cbiAgKi9cbiAgcmVhZG9ubHkgZGVuaWVkQ2xpZW50cz86IHN0cmluZ1tdO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjZGlzcG9zaXRpb24gTGJhYXNQb2xpY3kjZGlzcG9zaXRpb259XG4gICovXG4gIHJlYWRvbmx5IGRpc3Bvc2l0aW9uOiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNwZXJtaXR0ZWRfY2xpZW50cyBMYmFhc1BvbGljeSNwZXJtaXR0ZWRfY2xpZW50c31cbiAgKi9cbiAgcmVhZG9ubHkgcGVybWl0dGVkQ2xpZW50cz86IHN0cmluZ1tdO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbGJhYXNQb2xpY3lSZXNvdXJjZUFjY2Vzc0NvbnRyb2xQb2xpY3lUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBMYmFhc1BvbGljeVJlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeU91dHB1dFJlZmVyZW5jZSB8IExiYWFzUG9saWN5UmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGRlbmllZF9jbGllbnRzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkoc3RydWN0IS5kZW5pZWRDbGllbnRzKSxcbiAgICBkaXNwb3NpdGlvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5kaXNwb3NpdGlvbiksXG4gICAgcGVybWl0dGVkX2NsaWVudHM6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKShzdHJ1Y3QhLnBlcm1pdHRlZENsaWVudHMpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBMYmFhc1BvbGljeVJlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeU91dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogTGJhYXNQb2xpY3lSZXNvdXJjZUFjY2Vzc0NvbnRyb2xQb2xpY3kgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2RlbmllZENsaWVudHMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVuaWVkQ2xpZW50cyA9IHRoaXMuX2RlbmllZENsaWVudHM7XG4gICAgfVxuICAgIGlmICh0aGlzLl9kaXNwb3NpdGlvbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kaXNwb3NpdGlvbiA9IHRoaXMuX2Rpc3Bvc2l0aW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcGVybWl0dGVkQ2xpZW50cyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wZXJtaXR0ZWRDbGllbnRzID0gdGhpcy5fcGVybWl0dGVkQ2xpZW50cztcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IExiYWFzUG9saWN5UmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5IHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fZGVuaWVkQ2xpZW50cyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2Rpc3Bvc2l0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcGVybWl0dGVkQ2xpZW50cyA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fZGVuaWVkQ2xpZW50cyA9IHZhbHVlLmRlbmllZENsaWVudHM7XG4gICAgICB0aGlzLl9kaXNwb3NpdGlvbiA9IHZhbHVlLmRpc3Bvc2l0aW9uO1xuICAgICAgdGhpcy5fcGVybWl0dGVkQ2xpZW50cyA9IHZhbHVlLnBlcm1pdHRlZENsaWVudHM7XG4gICAgfVxuICB9XG5cbiAgLy8gZGVuaWVkX2NsaWVudHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVuaWVkQ2xpZW50cz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBkZW5pZWRDbGllbnRzKCkge1xuICAgIHJldHVybiBjZGt0Zi5Gbi50b2xpc3QodGhpcy5nZXRMaXN0QXR0cmlidXRlKCdkZW5pZWRfY2xpZW50cycpKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbmllZENsaWVudHModmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fZGVuaWVkQ2xpZW50cyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbmllZENsaWVudHMoKSB7XG4gICAgdGhpcy5fZGVuaWVkQ2xpZW50cyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVuaWVkQ2xpZW50c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZW5pZWRDbGllbnRzO1xuICB9XG5cbiAgLy8gZGlzcG9zaXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfZGlzcG9zaXRpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRpc3Bvc2l0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGlzcG9zaXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRpc3Bvc2l0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kaXNwb3NpdGlvbiA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkaXNwb3NpdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kaXNwb3NpdGlvbjtcbiAgfVxuXG4gIC8vIHBlcm1pdHRlZF9jbGllbnRzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Blcm1pdHRlZENsaWVudHM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgcGVybWl0dGVkQ2xpZW50cygpIHtcbiAgICByZXR1cm4gY2RrdGYuRm4udG9saXN0KHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgncGVybWl0dGVkX2NsaWVudHMnKSk7XG4gIH1cbiAgcHVibGljIHNldCBwZXJtaXR0ZWRDbGllbnRzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX3Blcm1pdHRlZENsaWVudHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQZXJtaXR0ZWRDbGllbnRzKCkge1xuICAgIHRoaXMuX3Blcm1pdHRlZENsaWVudHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBlcm1pdHRlZENsaWVudHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcGVybWl0dGVkQ2xpZW50cztcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBMYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3kge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjYWN0aW9uX3doZW5faGVhZGVyX2V4aXN0cyBMYmFhc1BvbGljeSNhY3Rpb25fd2hlbl9oZWFkZXJfZXhpc3RzfVxuICAqL1xuICByZWFkb25seSBhY3Rpb25XaGVuSGVhZGVyRXhpc3RzPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjYWN0aW9uX3doZW5faGVhZGVyX3ZhbHVlX2lzIExiYWFzUG9saWN5I2FjdGlvbl93aGVuX2hlYWRlcl92YWx1ZV9pc31cbiAgKi9cbiAgcmVhZG9ubHkgYWN0aW9uV2hlbkhlYWRlclZhbHVlSXM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I2FjdGlvbl93aGVuX2hlYWRlcl92YWx1ZV9pc19ub3QgTGJhYXNQb2xpY3kjYWN0aW9uX3doZW5faGVhZGVyX3ZhbHVlX2lzX25vdH1cbiAgKi9cbiAgcmVhZG9ubHkgYWN0aW9uV2hlbkhlYWRlclZhbHVlSXNOb3Q/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I2hlYWRlcl9uYW1lIExiYWFzUG9saWN5I2hlYWRlcl9uYW1lfVxuICAqL1xuICByZWFkb25seSBoZWFkZXJOYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSN2YWx1ZSBMYmFhc1BvbGljeSN2YWx1ZX1cbiAgKi9cbiAgcmVhZG9ubHkgdmFsdWU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBsYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3lUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBMYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3lPdXRwdXRSZWZlcmVuY2UgfCBMYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3kpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgYWN0aW9uX3doZW5faGVhZGVyX2V4aXN0czogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5hY3Rpb25XaGVuSGVhZGVyRXhpc3RzKSxcbiAgICBhY3Rpb25fd2hlbl9oZWFkZXJfdmFsdWVfaXM6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKShzdHJ1Y3QhLmFjdGlvbldoZW5IZWFkZXJWYWx1ZUlzKSxcbiAgICBhY3Rpb25fd2hlbl9oZWFkZXJfdmFsdWVfaXNfbm90OiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkoc3RydWN0IS5hY3Rpb25XaGVuSGVhZGVyVmFsdWVJc05vdCksXG4gICAgaGVhZGVyX25hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuaGVhZGVyTmFtZSksXG4gICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEudmFsdWUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBMYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3lPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IExiYWFzUG9saWN5U2V0UmVxdWVzdEhlYWRlclBvbGljeSB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fYWN0aW9uV2hlbkhlYWRlckV4aXN0cyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5hY3Rpb25XaGVuSGVhZGVyRXhpc3RzID0gdGhpcy5fYWN0aW9uV2hlbkhlYWRlckV4aXN0cztcbiAgICB9XG4gICAgaWYgKHRoaXMuX2FjdGlvbldoZW5IZWFkZXJWYWx1ZUlzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmFjdGlvbldoZW5IZWFkZXJWYWx1ZUlzID0gdGhpcy5fYWN0aW9uV2hlbkhlYWRlclZhbHVlSXM7XG4gICAgfVxuICAgIGlmICh0aGlzLl9hY3Rpb25XaGVuSGVhZGVyVmFsdWVJc05vdCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5hY3Rpb25XaGVuSGVhZGVyVmFsdWVJc05vdCA9IHRoaXMuX2FjdGlvbldoZW5IZWFkZXJWYWx1ZUlzTm90O1xuICAgIH1cbiAgICBpZiAodGhpcy5faGVhZGVyTmFtZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5oZWFkZXJOYW1lID0gdGhpcy5faGVhZGVyTmFtZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3ZhbHVlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnZhbHVlID0gdGhpcy5fdmFsdWU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBMYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3kgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9hY3Rpb25XaGVuSGVhZGVyRXhpc3RzID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fYWN0aW9uV2hlbkhlYWRlclZhbHVlSXMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9hY3Rpb25XaGVuSGVhZGVyVmFsdWVJc05vdCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2hlYWRlck5hbWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl92YWx1ZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fYWN0aW9uV2hlbkhlYWRlckV4aXN0cyA9IHZhbHVlLmFjdGlvbldoZW5IZWFkZXJFeGlzdHM7XG4gICAgICB0aGlzLl9hY3Rpb25XaGVuSGVhZGVyVmFsdWVJcyA9IHZhbHVlLmFjdGlvbldoZW5IZWFkZXJWYWx1ZUlzO1xuICAgICAgdGhpcy5fYWN0aW9uV2hlbkhlYWRlclZhbHVlSXNOb3QgPSB2YWx1ZS5hY3Rpb25XaGVuSGVhZGVyVmFsdWVJc05vdDtcbiAgICAgIHRoaXMuX2hlYWRlck5hbWUgPSB2YWx1ZS5oZWFkZXJOYW1lO1xuICAgICAgdGhpcy5fdmFsdWUgPSB2YWx1ZS52YWx1ZTtcbiAgICB9XG4gIH1cblxuICAvLyBhY3Rpb25fd2hlbl9oZWFkZXJfZXhpc3RzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FjdGlvbldoZW5IZWFkZXJFeGlzdHM/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGFjdGlvbldoZW5IZWFkZXJFeGlzdHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdhY3Rpb25fd2hlbl9oZWFkZXJfZXhpc3RzJyk7XG4gIH1cbiAgcHVibGljIHNldCBhY3Rpb25XaGVuSGVhZGVyRXhpc3RzKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9hY3Rpb25XaGVuSGVhZGVyRXhpc3RzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWN0aW9uV2hlbkhlYWRlckV4aXN0cygpIHtcbiAgICB0aGlzLl9hY3Rpb25XaGVuSGVhZGVyRXhpc3RzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhY3Rpb25XaGVuSGVhZGVyRXhpc3RzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjdGlvbldoZW5IZWFkZXJFeGlzdHM7XG4gIH1cblxuICAvLyBhY3Rpb25fd2hlbl9oZWFkZXJfdmFsdWVfaXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWN0aW9uV2hlbkhlYWRlclZhbHVlSXM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgYWN0aW9uV2hlbkhlYWRlclZhbHVlSXMoKSB7XG4gICAgcmV0dXJuIGNka3RmLkZuLnRvbGlzdCh0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ2FjdGlvbl93aGVuX2hlYWRlcl92YWx1ZV9pcycpKTtcbiAgfVxuICBwdWJsaWMgc2V0IGFjdGlvbldoZW5IZWFkZXJWYWx1ZUlzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX2FjdGlvbldoZW5IZWFkZXJWYWx1ZUlzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWN0aW9uV2hlbkhlYWRlclZhbHVlSXMoKSB7XG4gICAgdGhpcy5fYWN0aW9uV2hlbkhlYWRlclZhbHVlSXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFjdGlvbldoZW5IZWFkZXJWYWx1ZUlzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjdGlvbldoZW5IZWFkZXJWYWx1ZUlzO1xuICB9XG5cbiAgLy8gYWN0aW9uX3doZW5faGVhZGVyX3ZhbHVlX2lzX25vdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hY3Rpb25XaGVuSGVhZGVyVmFsdWVJc05vdD86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBhY3Rpb25XaGVuSGVhZGVyVmFsdWVJc05vdCgpIHtcbiAgICByZXR1cm4gY2RrdGYuRm4udG9saXN0KHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgnYWN0aW9uX3doZW5faGVhZGVyX3ZhbHVlX2lzX25vdCcpKTtcbiAgfVxuICBwdWJsaWMgc2V0IGFjdGlvbldoZW5IZWFkZXJWYWx1ZUlzTm90KHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX2FjdGlvbldoZW5IZWFkZXJWYWx1ZUlzTm90ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWN0aW9uV2hlbkhlYWRlclZhbHVlSXNOb3QoKSB7XG4gICAgdGhpcy5fYWN0aW9uV2hlbkhlYWRlclZhbHVlSXNOb3QgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFjdGlvbldoZW5IZWFkZXJWYWx1ZUlzTm90SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjdGlvbldoZW5IZWFkZXJWYWx1ZUlzTm90O1xuICB9XG5cbiAgLy8gaGVhZGVyX25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfaGVhZGVyTmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaGVhZGVyTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2hlYWRlcl9uYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBoZWFkZXJOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9oZWFkZXJOYW1lID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGhlYWRlck5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faGVhZGVyTmFtZTtcbiAgfVxuXG4gIC8vIHZhbHVlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3ZhbHVlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB2YWx1ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3ZhbHVlJyk7XG4gIH1cbiAgcHVibGljIHNldCB2YWx1ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRWYWx1ZSgpIHtcbiAgICB0aGlzLl92YWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdmFsdWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdmFsdWU7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgTGJhYXNQb2xpY3lTc2xOZWdvdGlhdGlvblBvbGljeSB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNwb3J0IExiYWFzUG9saWN5I3BvcnR9XG4gICovXG4gIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I3NlcnZlcl9vcmRlcl9wcmVmZXJlbmNlIExiYWFzUG9saWN5I3NlcnZlcl9vcmRlcl9wcmVmZXJlbmNlfVxuICAqL1xuICByZWFkb25seSBzZXJ2ZXJPcmRlclByZWZlcmVuY2U/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL29wYy9yL2xiYWFzX3BvbGljeSNzc2xfY2lwaGVycyBMYmFhc1BvbGljeSNzc2xfY2lwaGVyc31cbiAgKi9cbiAgcmVhZG9ubHkgc3NsQ2lwaGVycz86IHN0cmluZ1tdO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kjc3NsX3Byb3RvY29sIExiYWFzUG9saWN5I3NzbF9wcm90b2NvbH1cbiAgKi9cbiAgcmVhZG9ubHkgc3NsUHJvdG9jb2w6IHN0cmluZ1tdO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbGJhYXNQb2xpY3lTc2xOZWdvdGlhdGlvblBvbGljeVRvVGVycmFmb3JtKHN0cnVjdD86IExiYWFzUG9saWN5U3NsTmVnb3RpYXRpb25Qb2xpY3lPdXRwdXRSZWZlcmVuY2UgfCBMYmFhc1BvbGljeVNzbE5lZ290aWF0aW9uUG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIHBvcnQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEucG9ydCksXG4gICAgc2VydmVyX29yZGVyX3ByZWZlcmVuY2U6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuc2VydmVyT3JkZXJQcmVmZXJlbmNlKSxcbiAgICBzc2xfY2lwaGVyczogY2RrdGYubGlzdE1hcHBlcihjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSwgZmFsc2UpKHN0cnVjdCEuc3NsQ2lwaGVycyksXG4gICAgc3NsX3Byb3RvY29sOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkoc3RydWN0IS5zc2xQcm90b2NvbCksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIExiYWFzUG9saWN5U3NsTmVnb3RpYXRpb25Qb2xpY3lPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IExiYWFzUG9saWN5U3NsTmVnb3RpYXRpb25Qb2xpY3kgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX3BvcnQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucG9ydCA9IHRoaXMuX3BvcnQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9zZXJ2ZXJPcmRlclByZWZlcmVuY2UgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuc2VydmVyT3JkZXJQcmVmZXJlbmNlID0gdGhpcy5fc2VydmVyT3JkZXJQcmVmZXJlbmNlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fc3NsQ2lwaGVycyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5zc2xDaXBoZXJzID0gdGhpcy5fc3NsQ2lwaGVycztcbiAgICB9XG4gICAgaWYgKHRoaXMuX3NzbFByb3RvY29sICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnNzbFByb3RvY29sID0gdGhpcy5fc3NsUHJvdG9jb2w7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBMYmFhc1BvbGljeVNzbE5lZ290aWF0aW9uUG9saWN5IHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fcG9ydCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NlcnZlck9yZGVyUHJlZmVyZW5jZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NzbENpcGhlcnMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9zc2xQcm90b2NvbCA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fcG9ydCA9IHZhbHVlLnBvcnQ7XG4gICAgICB0aGlzLl9zZXJ2ZXJPcmRlclByZWZlcmVuY2UgPSB2YWx1ZS5zZXJ2ZXJPcmRlclByZWZlcmVuY2U7XG4gICAgICB0aGlzLl9zc2xDaXBoZXJzID0gdmFsdWUuc3NsQ2lwaGVycztcbiAgICAgIHRoaXMuX3NzbFByb3RvY29sID0gdmFsdWUuc3NsUHJvdG9jb2w7XG4gICAgfVxuICB9XG5cbiAgLy8gcG9ydCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9wb3J0PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncG9ydCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fcG9ydCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwb3J0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnQ7XG4gIH1cblxuICAvLyBzZXJ2ZXJfb3JkZXJfcHJlZmVyZW5jZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zZXJ2ZXJPcmRlclByZWZlcmVuY2U/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHNlcnZlck9yZGVyUHJlZmVyZW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NlcnZlcl9vcmRlcl9wcmVmZXJlbmNlJyk7XG4gIH1cbiAgcHVibGljIHNldCBzZXJ2ZXJPcmRlclByZWZlcmVuY2UodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3NlcnZlck9yZGVyUHJlZmVyZW5jZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNlcnZlck9yZGVyUHJlZmVyZW5jZSgpIHtcbiAgICB0aGlzLl9zZXJ2ZXJPcmRlclByZWZlcmVuY2UgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNlcnZlck9yZGVyUHJlZmVyZW5jZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zZXJ2ZXJPcmRlclByZWZlcmVuY2U7XG4gIH1cblxuICAvLyBzc2xfY2lwaGVycyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zc2xDaXBoZXJzPzogc3RyaW5nW107IFxuICBwdWJsaWMgZ2V0IHNzbENpcGhlcnMoKSB7XG4gICAgcmV0dXJuIGNka3RmLkZuLnRvbGlzdCh0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ3NzbF9jaXBoZXJzJykpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3NsQ2lwaGVycyh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9zc2xDaXBoZXJzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U3NsQ2lwaGVycygpIHtcbiAgICB0aGlzLl9zc2xDaXBoZXJzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzc2xDaXBoZXJzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NzbENpcGhlcnM7XG4gIH1cblxuICAvLyBzc2xfcHJvdG9jb2wgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfc3NsUHJvdG9jb2w/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgc3NsUHJvdG9jb2woKSB7XG4gICAgcmV0dXJuIGNka3RmLkZuLnRvbGlzdCh0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ3NzbF9wcm90b2NvbCcpKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNzbFByb3RvY29sKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX3NzbFByb3RvY29sID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNzbFByb3RvY29sSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NzbFByb3RvY29sO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIExiYWFzUG9saWN5VHJ1c3RlZENlcnRpZmljYXRlUG9saWN5IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5I3RydXN0ZWRfY2VydGlmaWNhdGUgTGJhYXNQb2xpY3kjdHJ1c3RlZF9jZXJ0aWZpY2F0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgdHJ1c3RlZENlcnRpZmljYXRlOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBsYmFhc1BvbGljeVRydXN0ZWRDZXJ0aWZpY2F0ZVBvbGljeVRvVGVycmFmb3JtKHN0cnVjdD86IExiYWFzUG9saWN5VHJ1c3RlZENlcnRpZmljYXRlUG9saWN5T3V0cHV0UmVmZXJlbmNlIHwgTGJhYXNQb2xpY3lUcnVzdGVkQ2VydGlmaWNhdGVQb2xpY3kpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgdHJ1c3RlZF9jZXJ0aWZpY2F0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS50cnVzdGVkQ2VydGlmaWNhdGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBMYmFhc1BvbGljeVRydXN0ZWRDZXJ0aWZpY2F0ZVBvbGljeU91dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogTGJhYXNQb2xpY3lUcnVzdGVkQ2VydGlmaWNhdGVQb2xpY3kgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX3RydXN0ZWRDZXJ0aWZpY2F0ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC50cnVzdGVkQ2VydGlmaWNhdGUgPSB0aGlzLl90cnVzdGVkQ2VydGlmaWNhdGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBMYmFhc1BvbGljeVRydXN0ZWRDZXJ0aWZpY2F0ZVBvbGljeSB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX3RydXN0ZWRDZXJ0aWZpY2F0ZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fdHJ1c3RlZENlcnRpZmljYXRlID0gdmFsdWUudHJ1c3RlZENlcnRpZmljYXRlO1xuICAgIH1cbiAgfVxuXG4gIC8vIHRydXN0ZWRfY2VydGlmaWNhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfdHJ1c3RlZENlcnRpZmljYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0cnVzdGVkQ2VydGlmaWNhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0cnVzdGVkX2NlcnRpZmljYXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCB0cnVzdGVkQ2VydGlmaWNhdGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3RydXN0ZWRDZXJ0aWZpY2F0ZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0cnVzdGVkQ2VydGlmaWNhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdHJ1c3RlZENlcnRpZmljYXRlO1xuICB9XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9vcGMvci9sYmFhc19wb2xpY3kgb3BjX2xiYWFzX3BvbGljeX1cbiovXG5leHBvcnQgY2xhc3MgTGJhYXNQb2xpY3kgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwib3BjX2xiYWFzX3BvbGljeVwiO1xuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgLyoqXG4gICogQ3JlYXRlIGEgbmV3IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvb3BjL3IvbGJhYXNfcG9saWN5IG9wY19sYmFhc19wb2xpY3l9IFJlc291cmNlXG4gICpcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpZCBUaGUgc2NvcGVkIGNvbnN0cnVjdCBJRC4gTXVzdCBiZSB1bmlxdWUgYW1vbmdzdCBzaWJsaW5ncyBpbiB0aGUgc2FtZSBzY29wZVxuICAqIEBwYXJhbSBvcHRpb25zIExiYWFzUG9saWN5Q29uZmlnXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IExiYWFzUG9saWN5Q29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdvcGNfbGJhYXNfcG9saWN5JyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ29wYycsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzEuNC4xJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDEuNCdcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZSxcbiAgICAgIHByb3Zpc2lvbmVyczogY29uZmlnLnByb3Zpc2lvbmVycyxcbiAgICAgIGNvbm5lY3Rpb246IGNvbmZpZy5jb25uZWN0aW9uLFxuICAgICAgZm9yRWFjaDogY29uZmlnLmZvckVhY2hcbiAgICB9KTtcbiAgICB0aGlzLl9pZCA9IGNvbmZpZy5pZDtcbiAgICB0aGlzLl9sb2FkQmFsYW5jZXIgPSBjb25maWcubG9hZEJhbGFuY2VyO1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl9hcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5hcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3k7XG4gICAgdGhpcy5fY2xvdWRnYXRlUG9saWN5LmludGVybmFsVmFsdWUgPSBjb25maWcuY2xvdWRnYXRlUG9saWN5O1xuICAgIHRoaXMuX2xvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5sb2FkQmFsYW5jZXJDb29raWVTdGlja2luZXNzUG9saWN5O1xuICAgIHRoaXMuX2xvYWRCYWxhbmNpbmdNZWNoYW5pc21Qb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5sb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5O1xuICAgIHRoaXMuX3JhdGVMaW1pdGluZ1JlcXVlc3RQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5yYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5O1xuICAgIHRoaXMuX3JlZGlyZWN0UG9saWN5LmludGVybmFsVmFsdWUgPSBjb25maWcucmVkaXJlY3RQb2xpY3k7XG4gICAgdGhpcy5fcmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5LmludGVybmFsVmFsdWUgPSBjb25maWcucmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5O1xuICAgIHRoaXMuX3NldFJlcXVlc3RIZWFkZXJQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5zZXRSZXF1ZXN0SGVhZGVyUG9saWN5O1xuICAgIHRoaXMuX3NzbE5lZ290aWF0aW9uUG9saWN5LmludGVybmFsVmFsdWUgPSBjb25maWcuc3NsTmVnb3RpYXRpb25Qb2xpY3k7XG4gICAgdGhpcy5fdHJ1c3RlZENlcnRpZmljYXRlUG9saWN5LmludGVybmFsVmFsdWUgPSBjb25maWcudHJ1c3RlZENlcnRpZmljYXRlUG9saWN5O1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZCgpIHtcbiAgICB0aGlzLl9pZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQ7XG4gIH1cblxuICAvLyBsb2FkX2JhbGFuY2VyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX2xvYWRCYWxhbmNlcj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbG9hZEJhbGFuY2VyKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbG9hZF9iYWxhbmNlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgbG9hZEJhbGFuY2VyKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9sb2FkQmFsYW5jZXIgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbG9hZEJhbGFuY2VySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2xvYWRCYWxhbmNlcjtcbiAgfVxuXG4gIC8vIG5hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfbmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX25hbWUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9uYW1lO1xuICB9XG5cbiAgLy8gc3RhdGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBzdGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdzdGF0ZScpO1xuICB9XG5cbiAgLy8gdHlwZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0eXBlJyk7XG4gIH1cblxuICAvLyB1cmkgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCB1cmkoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1cmknKTtcbiAgfVxuXG4gIC8vIGFwcGxpY2F0aW9uX2Nvb2tpZV9zdGlja2luZXNzX3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3kgPSBuZXcgTGJhYXNQb2xpY3lBcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3lPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJhcHBsaWNhdGlvbl9jb29raWVfc3RpY2tpbmVzc19wb2xpY3lcIik7XG4gIHB1YmxpYyBnZXQgYXBwbGljYXRpb25Db29raWVTdGlja2luZXNzUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLl9hcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3k7XG4gIH1cbiAgcHVibGljIHB1dEFwcGxpY2F0aW9uQ29va2llU3RpY2tpbmVzc1BvbGljeSh2YWx1ZTogTGJhYXNQb2xpY3lBcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3kpIHtcbiAgICB0aGlzLl9hcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEFwcGxpY2F0aW9uQ29va2llU3RpY2tpbmVzc1BvbGljeSgpIHtcbiAgICB0aGlzLl9hcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYXBwbGljYXRpb25Db29raWVTdGlja2luZXNzUG9saWN5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FwcGxpY2F0aW9uQ29va2llU3RpY2tpbmVzc1BvbGljeS5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gY2xvdWRnYXRlX3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jbG91ZGdhdGVQb2xpY3kgPSBuZXcgTGJhYXNQb2xpY3lDbG91ZGdhdGVQb2xpY3lPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJjbG91ZGdhdGVfcG9saWN5XCIpO1xuICBwdWJsaWMgZ2V0IGNsb3VkZ2F0ZVBvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2xvdWRnYXRlUG9saWN5O1xuICB9XG4gIHB1YmxpYyBwdXRDbG91ZGdhdGVQb2xpY3kodmFsdWU6IExiYWFzUG9saWN5Q2xvdWRnYXRlUG9saWN5KSB7XG4gICAgdGhpcy5fY2xvdWRnYXRlUG9saWN5LmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDbG91ZGdhdGVQb2xpY3koKSB7XG4gICAgdGhpcy5fY2xvdWRnYXRlUG9saWN5LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNsb3VkZ2F0ZVBvbGljeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jbG91ZGdhdGVQb2xpY3kuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIGxvYWRfYmFsYW5jZXJfY29va2llX3N0aWNraW5lc3NfcG9saWN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2xvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3kgPSBuZXcgTGJhYXNQb2xpY3lMb2FkQmFsYW5jZXJDb29raWVTdGlja2luZXNzUG9saWN5T3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwibG9hZF9iYWxhbmNlcl9jb29raWVfc3RpY2tpbmVzc19wb2xpY3lcIik7XG4gIHB1YmxpYyBnZXQgbG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy5fbG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeTtcbiAgfVxuICBwdWJsaWMgcHV0TG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeSh2YWx1ZTogTGJhYXNQb2xpY3lMb2FkQmFsYW5jZXJDb29raWVTdGlja2luZXNzUG9saWN5KSB7XG4gICAgdGhpcy5fbG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeS5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeSgpIHtcbiAgICB0aGlzLl9sb2FkQmFsYW5jZXJDb29raWVTdGlja2luZXNzUG9saWN5LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGxvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbG9hZEJhbGFuY2VyQ29va2llU3RpY2tpbmVzc1BvbGljeS5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gbG9hZF9iYWxhbmNpbmdfbWVjaGFuaXNtX3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9sb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5ID0gbmV3IExiYWFzUG9saWN5TG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeU91dHB1dFJlZmVyZW5jZSh0aGlzLCBcImxvYWRfYmFsYW5jaW5nX21lY2hhbmlzbV9wb2xpY3lcIik7XG4gIHB1YmxpYyBnZXQgbG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy5fbG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeTtcbiAgfVxuICBwdWJsaWMgcHV0TG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeSh2YWx1ZTogTGJhYXNQb2xpY3lMb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5KSB7XG4gICAgdGhpcy5fbG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeS5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeSgpIHtcbiAgICB0aGlzLl9sb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGxvYWRCYWxhbmNpbmdNZWNoYW5pc21Qb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeS5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gcmF0ZV9saW1pdGluZ19yZXF1ZXN0X3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5ID0gbmV3IExiYWFzUG9saWN5UmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeU91dHB1dFJlZmVyZW5jZSh0aGlzLCBcInJhdGVfbGltaXRpbmdfcmVxdWVzdF9wb2xpY3lcIik7XG4gIHB1YmxpYyBnZXQgcmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeTtcbiAgfVxuICBwdWJsaWMgcHV0UmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeSh2YWx1ZTogTGJhYXNQb2xpY3lSYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5KSB7XG4gICAgdGhpcy5fcmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeS5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeSgpIHtcbiAgICB0aGlzLl9yYXRlTGltaXRpbmdSZXF1ZXN0UG9saWN5LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJhdGVMaW1pdGluZ1JlcXVlc3RQb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeS5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gcmVkaXJlY3RfcG9saWN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlZGlyZWN0UG9saWN5ID0gbmV3IExiYWFzUG9saWN5UmVkaXJlY3RQb2xpY3lPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJyZWRpcmVjdF9wb2xpY3lcIik7XG4gIHB1YmxpYyBnZXQgcmVkaXJlY3RQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlZGlyZWN0UG9saWN5O1xuICB9XG4gIHB1YmxpYyBwdXRSZWRpcmVjdFBvbGljeSh2YWx1ZTogTGJhYXNQb2xpY3lSZWRpcmVjdFBvbGljeSkge1xuICAgIHRoaXMuX3JlZGlyZWN0UG9saWN5LmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZWRpcmVjdFBvbGljeSgpIHtcbiAgICB0aGlzLl9yZWRpcmVjdFBvbGljeS5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZWRpcmVjdFBvbGljeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZWRpcmVjdFBvbGljeS5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gcmVzb3VyY2VfYWNjZXNzX2NvbnRyb2xfcG9saWN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Jlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeSA9IG5ldyBMYmFhc1BvbGljeVJlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeU91dHB1dFJlZmVyZW5jZSh0aGlzLCBcInJlc291cmNlX2FjY2Vzc19jb250cm9sX3BvbGljeVwiKTtcbiAgcHVibGljIGdldCByZXNvdXJjZUFjY2Vzc0NvbnRyb2xQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeTtcbiAgfVxuICBwdWJsaWMgcHV0UmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5KHZhbHVlOiBMYmFhc1BvbGljeVJlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeSkge1xuICAgIHRoaXMuX3Jlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeS5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5KCkge1xuICAgIHRoaXMuX3Jlc291cmNlQWNjZXNzQ29udHJvbFBvbGljeS5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXNvdXJjZUFjY2Vzc0NvbnRyb2xQb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVzb3VyY2VBY2Nlc3NDb250cm9sUG9saWN5LmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBzZXRfcmVxdWVzdF9oZWFkZXJfcG9saWN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NldFJlcXVlc3RIZWFkZXJQb2xpY3kgPSBuZXcgTGJhYXNQb2xpY3lTZXRSZXF1ZXN0SGVhZGVyUG9saWN5T3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwic2V0X3JlcXVlc3RfaGVhZGVyX3BvbGljeVwiKTtcbiAgcHVibGljIGdldCBzZXRSZXF1ZXN0SGVhZGVyUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLl9zZXRSZXF1ZXN0SGVhZGVyUG9saWN5O1xuICB9XG4gIHB1YmxpYyBwdXRTZXRSZXF1ZXN0SGVhZGVyUG9saWN5KHZhbHVlOiBMYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3kpIHtcbiAgICB0aGlzLl9zZXRSZXF1ZXN0SGVhZGVyUG9saWN5LmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTZXRSZXF1ZXN0SGVhZGVyUG9saWN5KCkge1xuICAgIHRoaXMuX3NldFJlcXVlc3RIZWFkZXJQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc2V0UmVxdWVzdEhlYWRlclBvbGljeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zZXRSZXF1ZXN0SGVhZGVyUG9saWN5LmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBzc2xfbmVnb3RpYXRpb25fcG9saWN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NzbE5lZ290aWF0aW9uUG9saWN5ID0gbmV3IExiYWFzUG9saWN5U3NsTmVnb3RpYXRpb25Qb2xpY3lPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJzc2xfbmVnb3RpYXRpb25fcG9saWN5XCIpO1xuICBwdWJsaWMgZ2V0IHNzbE5lZ290aWF0aW9uUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLl9zc2xOZWdvdGlhdGlvblBvbGljeTtcbiAgfVxuICBwdWJsaWMgcHV0U3NsTmVnb3RpYXRpb25Qb2xpY3kodmFsdWU6IExiYWFzUG9saWN5U3NsTmVnb3RpYXRpb25Qb2xpY3kpIHtcbiAgICB0aGlzLl9zc2xOZWdvdGlhdGlvblBvbGljeS5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U3NsTmVnb3RpYXRpb25Qb2xpY3koKSB7XG4gICAgdGhpcy5fc3NsTmVnb3RpYXRpb25Qb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3NsTmVnb3RpYXRpb25Qb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3NsTmVnb3RpYXRpb25Qb2xpY3kuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIHRydXN0ZWRfY2VydGlmaWNhdGVfcG9saWN5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RydXN0ZWRDZXJ0aWZpY2F0ZVBvbGljeSA9IG5ldyBMYmFhc1BvbGljeVRydXN0ZWRDZXJ0aWZpY2F0ZVBvbGljeU91dHB1dFJlZmVyZW5jZSh0aGlzLCBcInRydXN0ZWRfY2VydGlmaWNhdGVfcG9saWN5XCIpO1xuICBwdWJsaWMgZ2V0IHRydXN0ZWRDZXJ0aWZpY2F0ZVBvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy5fdHJ1c3RlZENlcnRpZmljYXRlUG9saWN5O1xuICB9XG4gIHB1YmxpYyBwdXRUcnVzdGVkQ2VydGlmaWNhdGVQb2xpY3kodmFsdWU6IExiYWFzUG9saWN5VHJ1c3RlZENlcnRpZmljYXRlUG9saWN5KSB7XG4gICAgdGhpcy5fdHJ1c3RlZENlcnRpZmljYXRlUG9saWN5LmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUcnVzdGVkQ2VydGlmaWNhdGVQb2xpY3koKSB7XG4gICAgdGhpcy5fdHJ1c3RlZENlcnRpZmljYXRlUG9saWN5LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRydXN0ZWRDZXJ0aWZpY2F0ZVBvbGljeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90cnVzdGVkQ2VydGlmaWNhdGVQb2xpY3kuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2lkKSxcbiAgICAgIGxvYWRfYmFsYW5jZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2xvYWRCYWxhbmNlciksXG4gICAgICBuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9uYW1lKSxcbiAgICAgIGFwcGxpY2F0aW9uX2Nvb2tpZV9zdGlja2luZXNzX3BvbGljeTogbGJhYXNQb2xpY3lBcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3lUb1RlcnJhZm9ybSh0aGlzLl9hcHBsaWNhdGlvbkNvb2tpZVN0aWNraW5lc3NQb2xpY3kuaW50ZXJuYWxWYWx1ZSksXG4gICAgICBjbG91ZGdhdGVfcG9saWN5OiBsYmFhc1BvbGljeUNsb3VkZ2F0ZVBvbGljeVRvVGVycmFmb3JtKHRoaXMuX2Nsb3VkZ2F0ZVBvbGljeS5pbnRlcm5hbFZhbHVlKSxcbiAgICAgIGxvYWRfYmFsYW5jZXJfY29va2llX3N0aWNraW5lc3NfcG9saWN5OiBsYmFhc1BvbGljeUxvYWRCYWxhbmNlckNvb2tpZVN0aWNraW5lc3NQb2xpY3lUb1RlcnJhZm9ybSh0aGlzLl9sb2FkQmFsYW5jZXJDb29raWVTdGlja2luZXNzUG9saWN5LmludGVybmFsVmFsdWUpLFxuICAgICAgbG9hZF9iYWxhbmNpbmdfbWVjaGFuaXNtX3BvbGljeTogbGJhYXNQb2xpY3lMb2FkQmFsYW5jaW5nTWVjaGFuaXNtUG9saWN5VG9UZXJyYWZvcm0odGhpcy5fbG9hZEJhbGFuY2luZ01lY2hhbmlzbVBvbGljeS5pbnRlcm5hbFZhbHVlKSxcbiAgICAgIHJhdGVfbGltaXRpbmdfcmVxdWVzdF9wb2xpY3k6IGxiYWFzUG9saWN5UmF0ZUxpbWl0aW5nUmVxdWVzdFBvbGljeVRvVGVycmFmb3JtKHRoaXMuX3JhdGVMaW1pdGluZ1JlcXVlc3RQb2xpY3kuaW50ZXJuYWxWYWx1ZSksXG4gICAgICByZWRpcmVjdF9wb2xpY3k6IGxiYWFzUG9saWN5UmVkaXJlY3RQb2xpY3lUb1RlcnJhZm9ybSh0aGlzLl9yZWRpcmVjdFBvbGljeS5pbnRlcm5hbFZhbHVlKSxcbiAgICAgIHJlc291cmNlX2FjY2Vzc19jb250cm9sX3BvbGljeTogbGJhYXNQb2xpY3lSZXNvdXJjZUFjY2Vzc0NvbnRyb2xQb2xpY3lUb1RlcnJhZm9ybSh0aGlzLl9yZXNvdXJjZUFjY2Vzc0NvbnRyb2xQb2xpY3kuaW50ZXJuYWxWYWx1ZSksXG4gICAgICBzZXRfcmVxdWVzdF9oZWFkZXJfcG9saWN5OiBsYmFhc1BvbGljeVNldFJlcXVlc3RIZWFkZXJQb2xpY3lUb1RlcnJhZm9ybSh0aGlzLl9zZXRSZXF1ZXN0SGVhZGVyUG9saWN5LmludGVybmFsVmFsdWUpLFxuICAgICAgc3NsX25lZ290aWF0aW9uX3BvbGljeTogbGJhYXNQb2xpY3lTc2xOZWdvdGlhdGlvblBvbGljeVRvVGVycmFmb3JtKHRoaXMuX3NzbE5lZ290aWF0aW9uUG9saWN5LmludGVybmFsVmFsdWUpLFxuICAgICAgdHJ1c3RlZF9jZXJ0aWZpY2F0ZV9wb2xpY3k6IGxiYWFzUG9saWN5VHJ1c3RlZENlcnRpZmljYXRlUG9saWN5VG9UZXJyYWZvcm0odGhpcy5fdHJ1c3RlZENlcnRpZmljYXRlUG9saWN5LmludGVybmFsVmFsdWUpLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==