import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbaasPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#id LbaasPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#load_balancer LbaasPolicy#load_balancer}
    */
    readonly loadBalancer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#name LbaasPolicy#name}
    */
    readonly name: string;
    /**
    * application_cookie_stickiness_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#application_cookie_stickiness_policy LbaasPolicy#application_cookie_stickiness_policy}
    */
    readonly applicationCookieStickinessPolicy?: LbaasPolicyApplicationCookieStickinessPolicy;
    /**
    * cloudgate_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#cloudgate_policy LbaasPolicy#cloudgate_policy}
    */
    readonly cloudgatePolicy?: LbaasPolicyCloudgatePolicy;
    /**
    * load_balancer_cookie_stickiness_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#load_balancer_cookie_stickiness_policy LbaasPolicy#load_balancer_cookie_stickiness_policy}
    */
    readonly loadBalancerCookieStickinessPolicy?: LbaasPolicyLoadBalancerCookieStickinessPolicy;
    /**
    * load_balancing_mechanism_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#load_balancing_mechanism_policy LbaasPolicy#load_balancing_mechanism_policy}
    */
    readonly loadBalancingMechanismPolicy?: LbaasPolicyLoadBalancingMechanismPolicy;
    /**
    * rate_limiting_request_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#rate_limiting_request_policy LbaasPolicy#rate_limiting_request_policy}
    */
    readonly rateLimitingRequestPolicy?: LbaasPolicyRateLimitingRequestPolicy;
    /**
    * redirect_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#redirect_policy LbaasPolicy#redirect_policy}
    */
    readonly redirectPolicy?: LbaasPolicyRedirectPolicy;
    /**
    * resource_access_control_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#resource_access_control_policy LbaasPolicy#resource_access_control_policy}
    */
    readonly resourceAccessControlPolicy?: LbaasPolicyResourceAccessControlPolicy;
    /**
    * set_request_header_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#set_request_header_policy LbaasPolicy#set_request_header_policy}
    */
    readonly setRequestHeaderPolicy?: LbaasPolicySetRequestHeaderPolicy;
    /**
    * ssl_negotiation_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#ssl_negotiation_policy LbaasPolicy#ssl_negotiation_policy}
    */
    readonly sslNegotiationPolicy?: LbaasPolicySslNegotiationPolicy;
    /**
    * trusted_certificate_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#trusted_certificate_policy LbaasPolicy#trusted_certificate_policy}
    */
    readonly trustedCertificatePolicy?: LbaasPolicyTrustedCertificatePolicy;
}
export interface LbaasPolicyApplicationCookieStickinessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#cookie_name LbaasPolicy#cookie_name}
    */
    readonly cookieName: string;
}
export declare function lbaasPolicyApplicationCookieStickinessPolicyToTerraform(struct?: LbaasPolicyApplicationCookieStickinessPolicyOutputReference | LbaasPolicyApplicationCookieStickinessPolicy): any;
export declare class LbaasPolicyApplicationCookieStickinessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyApplicationCookieStickinessPolicy | undefined;
    set internalValue(value: LbaasPolicyApplicationCookieStickinessPolicy | undefined);
    private _cookieName?;
    get cookieName(): string;
    set cookieName(value: string);
    get cookieNameInput(): string | undefined;
}
export interface LbaasPolicyCloudgatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#cloudgate_application LbaasPolicy#cloudgate_application}
    */
    readonly cloudgateApplication?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#cloudgate_policy_name LbaasPolicy#cloudgate_policy_name}
    */
    readonly cloudgatePolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#identity_service_instance_guid LbaasPolicy#identity_service_instance_guid}
    */
    readonly identityServiceInstanceGuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#virtual_hostname_for_policy_attribution LbaasPolicy#virtual_hostname_for_policy_attribution}
    */
    readonly virtualHostnameForPolicyAttribution: string;
}
export declare function lbaasPolicyCloudgatePolicyToTerraform(struct?: LbaasPolicyCloudgatePolicyOutputReference | LbaasPolicyCloudgatePolicy): any;
export declare class LbaasPolicyCloudgatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyCloudgatePolicy | undefined;
    set internalValue(value: LbaasPolicyCloudgatePolicy | undefined);
    private _cloudgateApplication?;
    get cloudgateApplication(): string;
    set cloudgateApplication(value: string);
    resetCloudgateApplication(): void;
    get cloudgateApplicationInput(): string | undefined;
    private _cloudgatePolicyName?;
    get cloudgatePolicyName(): string;
    set cloudgatePolicyName(value: string);
    resetCloudgatePolicyName(): void;
    get cloudgatePolicyNameInput(): string | undefined;
    private _identityServiceInstanceGuid?;
    get identityServiceInstanceGuid(): string;
    set identityServiceInstanceGuid(value: string);
    resetIdentityServiceInstanceGuid(): void;
    get identityServiceInstanceGuidInput(): string | undefined;
    private _virtualHostnameForPolicyAttribution?;
    get virtualHostnameForPolicyAttribution(): string;
    set virtualHostnameForPolicyAttribution(value: string);
    get virtualHostnameForPolicyAttributionInput(): string | undefined;
}
export interface LbaasPolicyLoadBalancerCookieStickinessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#cookie_expiration_period LbaasPolicy#cookie_expiration_period}
    */
    readonly cookieExpirationPeriod: number;
}
export declare function lbaasPolicyLoadBalancerCookieStickinessPolicyToTerraform(struct?: LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference | LbaasPolicyLoadBalancerCookieStickinessPolicy): any;
export declare class LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyLoadBalancerCookieStickinessPolicy | undefined;
    set internalValue(value: LbaasPolicyLoadBalancerCookieStickinessPolicy | undefined);
    private _cookieExpirationPeriod?;
    get cookieExpirationPeriod(): number;
    set cookieExpirationPeriod(value: number);
    get cookieExpirationPeriodInput(): number | undefined;
}
export interface LbaasPolicyLoadBalancingMechanismPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#load_balancing_mechanism LbaasPolicy#load_balancing_mechanism}
    */
    readonly loadBalancingMechanism: string;
}
export declare function lbaasPolicyLoadBalancingMechanismPolicyToTerraform(struct?: LbaasPolicyLoadBalancingMechanismPolicyOutputReference | LbaasPolicyLoadBalancingMechanismPolicy): any;
export declare class LbaasPolicyLoadBalancingMechanismPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyLoadBalancingMechanismPolicy | undefined;
    set internalValue(value: LbaasPolicyLoadBalancingMechanismPolicy | undefined);
    private _loadBalancingMechanism?;
    get loadBalancingMechanism(): string;
    set loadBalancingMechanism(value: string);
    get loadBalancingMechanismInput(): string | undefined;
}
export interface LbaasPolicyRateLimitingRequestPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#burst_size LbaasPolicy#burst_size}
    */
    readonly burstSize: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#delay_excessive_requests LbaasPolicy#delay_excessive_requests}
    */
    readonly delayExcessiveRequests: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#http_error_code LbaasPolicy#http_error_code}
    */
    readonly httpErrorCode?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#logging_level LbaasPolicy#logging_level}
    */
    readonly loggingLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#rate_limiting_criteria LbaasPolicy#rate_limiting_criteria}
    */
    readonly rateLimitingCriteria?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#requests_per_second LbaasPolicy#requests_per_second}
    */
    readonly requestsPerSecond: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#zone LbaasPolicy#zone}
    */
    readonly zone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#zone_memory_size LbaasPolicy#zone_memory_size}
    */
    readonly zoneMemorySize?: number;
}
export declare function lbaasPolicyRateLimitingRequestPolicyToTerraform(struct?: LbaasPolicyRateLimitingRequestPolicyOutputReference | LbaasPolicyRateLimitingRequestPolicy): any;
export declare class LbaasPolicyRateLimitingRequestPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyRateLimitingRequestPolicy | undefined;
    set internalValue(value: LbaasPolicyRateLimitingRequestPolicy | undefined);
    private _burstSize?;
    get burstSize(): number;
    set burstSize(value: number);
    get burstSizeInput(): number | undefined;
    private _delayExcessiveRequests?;
    get delayExcessiveRequests(): boolean | cdktf.IResolvable;
    set delayExcessiveRequests(value: boolean | cdktf.IResolvable);
    get delayExcessiveRequestsInput(): boolean | cdktf.IResolvable | undefined;
    private _httpErrorCode?;
    get httpErrorCode(): number;
    set httpErrorCode(value: number);
    resetHttpErrorCode(): void;
    get httpErrorCodeInput(): number | undefined;
    private _loggingLevel?;
    get loggingLevel(): string;
    set loggingLevel(value: string);
    resetLoggingLevel(): void;
    get loggingLevelInput(): string | undefined;
    private _rateLimitingCriteria?;
    get rateLimitingCriteria(): string;
    set rateLimitingCriteria(value: string);
    resetRateLimitingCriteria(): void;
    get rateLimitingCriteriaInput(): string | undefined;
    private _requestsPerSecond?;
    get requestsPerSecond(): number;
    set requestsPerSecond(value: number);
    get requestsPerSecondInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _zoneMemorySize?;
    get zoneMemorySize(): number;
    set zoneMemorySize(value: number);
    resetZoneMemorySize(): void;
    get zoneMemorySizeInput(): number | undefined;
}
export interface LbaasPolicyRedirectPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#redirect_uri LbaasPolicy#redirect_uri}
    */
    readonly redirectUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#response_code LbaasPolicy#response_code}
    */
    readonly responseCode: number;
}
export declare function lbaasPolicyRedirectPolicyToTerraform(struct?: LbaasPolicyRedirectPolicyOutputReference | LbaasPolicyRedirectPolicy): any;
export declare class LbaasPolicyRedirectPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyRedirectPolicy | undefined;
    set internalValue(value: LbaasPolicyRedirectPolicy | undefined);
    private _redirectUri?;
    get redirectUri(): string;
    set redirectUri(value: string);
    get redirectUriInput(): string | undefined;
    private _responseCode?;
    get responseCode(): number;
    set responseCode(value: number);
    get responseCodeInput(): number | undefined;
}
export interface LbaasPolicyResourceAccessControlPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#denied_clients LbaasPolicy#denied_clients}
    */
    readonly deniedClients?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#disposition LbaasPolicy#disposition}
    */
    readonly disposition: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#permitted_clients LbaasPolicy#permitted_clients}
    */
    readonly permittedClients?: string[];
}
export declare function lbaasPolicyResourceAccessControlPolicyToTerraform(struct?: LbaasPolicyResourceAccessControlPolicyOutputReference | LbaasPolicyResourceAccessControlPolicy): any;
export declare class LbaasPolicyResourceAccessControlPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyResourceAccessControlPolicy | undefined;
    set internalValue(value: LbaasPolicyResourceAccessControlPolicy | undefined);
    private _deniedClients?;
    get deniedClients(): string[];
    set deniedClients(value: string[]);
    resetDeniedClients(): void;
    get deniedClientsInput(): string[] | undefined;
    private _disposition?;
    get disposition(): string;
    set disposition(value: string);
    get dispositionInput(): string | undefined;
    private _permittedClients?;
    get permittedClients(): string[];
    set permittedClients(value: string[]);
    resetPermittedClients(): void;
    get permittedClientsInput(): string[] | undefined;
}
export interface LbaasPolicySetRequestHeaderPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#action_when_header_exists LbaasPolicy#action_when_header_exists}
    */
    readonly actionWhenHeaderExists?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#action_when_header_value_is LbaasPolicy#action_when_header_value_is}
    */
    readonly actionWhenHeaderValueIs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#action_when_header_value_is_not LbaasPolicy#action_when_header_value_is_not}
    */
    readonly actionWhenHeaderValueIsNot?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#header_name LbaasPolicy#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#value LbaasPolicy#value}
    */
    readonly value?: string;
}
export declare function lbaasPolicySetRequestHeaderPolicyToTerraform(struct?: LbaasPolicySetRequestHeaderPolicyOutputReference | LbaasPolicySetRequestHeaderPolicy): any;
export declare class LbaasPolicySetRequestHeaderPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicySetRequestHeaderPolicy | undefined;
    set internalValue(value: LbaasPolicySetRequestHeaderPolicy | undefined);
    private _actionWhenHeaderExists?;
    get actionWhenHeaderExists(): string;
    set actionWhenHeaderExists(value: string);
    resetActionWhenHeaderExists(): void;
    get actionWhenHeaderExistsInput(): string | undefined;
    private _actionWhenHeaderValueIs?;
    get actionWhenHeaderValueIs(): string[];
    set actionWhenHeaderValueIs(value: string[]);
    resetActionWhenHeaderValueIs(): void;
    get actionWhenHeaderValueIsInput(): string[] | undefined;
    private _actionWhenHeaderValueIsNot?;
    get actionWhenHeaderValueIsNot(): string[];
    set actionWhenHeaderValueIsNot(value: string[]);
    resetActionWhenHeaderValueIsNot(): void;
    get actionWhenHeaderValueIsNotInput(): string[] | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface LbaasPolicySslNegotiationPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#port LbaasPolicy#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#server_order_preference LbaasPolicy#server_order_preference}
    */
    readonly serverOrderPreference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#ssl_ciphers LbaasPolicy#ssl_ciphers}
    */
    readonly sslCiphers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#ssl_protocol LbaasPolicy#ssl_protocol}
    */
    readonly sslProtocol: string[];
}
export declare function lbaasPolicySslNegotiationPolicyToTerraform(struct?: LbaasPolicySslNegotiationPolicyOutputReference | LbaasPolicySslNegotiationPolicy): any;
export declare class LbaasPolicySslNegotiationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicySslNegotiationPolicy | undefined;
    set internalValue(value: LbaasPolicySslNegotiationPolicy | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _serverOrderPreference?;
    get serverOrderPreference(): string;
    set serverOrderPreference(value: string);
    resetServerOrderPreference(): void;
    get serverOrderPreferenceInput(): string | undefined;
    private _sslCiphers?;
    get sslCiphers(): string[];
    set sslCiphers(value: string[]);
    resetSslCiphers(): void;
    get sslCiphersInput(): string[] | undefined;
    private _sslProtocol?;
    get sslProtocol(): string[];
    set sslProtocol(value: string[]);
    get sslProtocolInput(): string[] | undefined;
}
export interface LbaasPolicyTrustedCertificatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy#trusted_certificate LbaasPolicy#trusted_certificate}
    */
    readonly trustedCertificate: string;
}
export declare function lbaasPolicyTrustedCertificatePolicyToTerraform(struct?: LbaasPolicyTrustedCertificatePolicyOutputReference | LbaasPolicyTrustedCertificatePolicy): any;
export declare class LbaasPolicyTrustedCertificatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbaasPolicyTrustedCertificatePolicy | undefined;
    set internalValue(value: LbaasPolicyTrustedCertificatePolicy | undefined);
    private _trustedCertificate?;
    get trustedCertificate(): string;
    set trustedCertificate(value: string);
    get trustedCertificateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy opc_lbaas_policy}
*/
export declare class LbaasPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_lbaas_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/lbaas_policy opc_lbaas_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbaasPolicyConfig
    */
    constructor(scope: Construct, id: string, config: LbaasPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadBalancer?;
    get loadBalancer(): string;
    set loadBalancer(value: string);
    get loadBalancerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): cdktf.IResolvable;
    get type(): string;
    get uri(): string;
    private _applicationCookieStickinessPolicy;
    get applicationCookieStickinessPolicy(): LbaasPolicyApplicationCookieStickinessPolicyOutputReference;
    putApplicationCookieStickinessPolicy(value: LbaasPolicyApplicationCookieStickinessPolicy): void;
    resetApplicationCookieStickinessPolicy(): void;
    get applicationCookieStickinessPolicyInput(): LbaasPolicyApplicationCookieStickinessPolicy | undefined;
    private _cloudgatePolicy;
    get cloudgatePolicy(): LbaasPolicyCloudgatePolicyOutputReference;
    putCloudgatePolicy(value: LbaasPolicyCloudgatePolicy): void;
    resetCloudgatePolicy(): void;
    get cloudgatePolicyInput(): LbaasPolicyCloudgatePolicy | undefined;
    private _loadBalancerCookieStickinessPolicy;
    get loadBalancerCookieStickinessPolicy(): LbaasPolicyLoadBalancerCookieStickinessPolicyOutputReference;
    putLoadBalancerCookieStickinessPolicy(value: LbaasPolicyLoadBalancerCookieStickinessPolicy): void;
    resetLoadBalancerCookieStickinessPolicy(): void;
    get loadBalancerCookieStickinessPolicyInput(): LbaasPolicyLoadBalancerCookieStickinessPolicy | undefined;
    private _loadBalancingMechanismPolicy;
    get loadBalancingMechanismPolicy(): LbaasPolicyLoadBalancingMechanismPolicyOutputReference;
    putLoadBalancingMechanismPolicy(value: LbaasPolicyLoadBalancingMechanismPolicy): void;
    resetLoadBalancingMechanismPolicy(): void;
    get loadBalancingMechanismPolicyInput(): LbaasPolicyLoadBalancingMechanismPolicy | undefined;
    private _rateLimitingRequestPolicy;
    get rateLimitingRequestPolicy(): LbaasPolicyRateLimitingRequestPolicyOutputReference;
    putRateLimitingRequestPolicy(value: LbaasPolicyRateLimitingRequestPolicy): void;
    resetRateLimitingRequestPolicy(): void;
    get rateLimitingRequestPolicyInput(): LbaasPolicyRateLimitingRequestPolicy | undefined;
    private _redirectPolicy;
    get redirectPolicy(): LbaasPolicyRedirectPolicyOutputReference;
    putRedirectPolicy(value: LbaasPolicyRedirectPolicy): void;
    resetRedirectPolicy(): void;
    get redirectPolicyInput(): LbaasPolicyRedirectPolicy | undefined;
    private _resourceAccessControlPolicy;
    get resourceAccessControlPolicy(): LbaasPolicyResourceAccessControlPolicyOutputReference;
    putResourceAccessControlPolicy(value: LbaasPolicyResourceAccessControlPolicy): void;
    resetResourceAccessControlPolicy(): void;
    get resourceAccessControlPolicyInput(): LbaasPolicyResourceAccessControlPolicy | undefined;
    private _setRequestHeaderPolicy;
    get setRequestHeaderPolicy(): LbaasPolicySetRequestHeaderPolicyOutputReference;
    putSetRequestHeaderPolicy(value: LbaasPolicySetRequestHeaderPolicy): void;
    resetSetRequestHeaderPolicy(): void;
    get setRequestHeaderPolicyInput(): LbaasPolicySetRequestHeaderPolicy | undefined;
    private _sslNegotiationPolicy;
    get sslNegotiationPolicy(): LbaasPolicySslNegotiationPolicyOutputReference;
    putSslNegotiationPolicy(value: LbaasPolicySslNegotiationPolicy): void;
    resetSslNegotiationPolicy(): void;
    get sslNegotiationPolicyInput(): LbaasPolicySslNegotiationPolicy | undefined;
    private _trustedCertificatePolicy;
    get trustedCertificatePolicy(): LbaasPolicyTrustedCertificatePolicyOutputReference;
    putTrustedCertificatePolicy(value: LbaasPolicyTrustedCertificatePolicy): void;
    resetTrustedCertificatePolicy(): void;
    get trustedCertificatePolicyInput(): LbaasPolicyTrustedCertificatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
