
      block data atomic
c******************************************************************************
c  this routine contains atomic data ordered by atomic number            
c******************************************************************************

      implicit real*8 (a-h,o-z)
      include 'Atmos.com'
      include 'Quants.com'
c  
c  This routine contains the basic atomic data 
c
c  names = atomic symbols for the elements
      data names/'H ','He','Li','Be','B ','C ','N ','O ','F ','Ne',
     .           'Na','Mg','Al','Si','P ','S ','Cl','Ar','K ','Ca',
     .           'Sc','Ti','V ','Cr','Mn','Fe','Co','Ni','Cu','Zn',
     .           'Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y ','Zr',
     .           'Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn',
     .           'Sb','Te','I ','Xe','Cs','Ba','La','Ce','Pr','Nd',
     .           'Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb',
     .           'Lu','Hf','Ta','Wl','Re','Os','Ir','Pt','Au','Hg',
     .           'Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th',
     .           'Pa','U ','Np','Pu','Am'/                         
c
c  xabu = the set of current solar (when available) or meteorite       
c  abundances, scaled to log(h) = 12.00 .  The data are from Asplund
c  et al. (2009, Ann. Rev. Ast. Ap., 47, 481).
      data xsolar/
     * 12.00,10.93, 1.05, 1.38, 2.70, 8.43, 7.83, 8.69, 4.56, 7.93,    
     1  6.24, 7.60, 6.45, 7.51, 5.41, 7.12, 5.50, 6.40, 5.03, 6.34,     
     2  3.15, 4.95, 3.93, 5.64, 5.43, 7.50, 4.99, 6.22, 4.19, 4.56,     
     3  3.04, 3.65, 2.30, 3.34, 2.54, 3.25, 2.52, 2.87, 2.21, 2.58,    
     4  1.46, 1.88,-5.00, 1.75, 0.91, 1.57, 0.94, 1.71, 0.80, 2.04,     
     5  1.01, 2.18, 1.55, 2.24, 1.08, 2.18, 1.10, 1.58, 0.72, 1.42,     
     6 -5.00, 0.96, 0.52, 1.07, 0.30, 1.10, 0.48, 0.92, 0.10, 0.84,     
     7  0.10, 0.85,-0.12, 0.85, 0.26, 1.40, 1.38, 1.62, 0.92, 1.17,     
     8  0.90, 1.75, 0.65,-5.00,-5.00,-5.00,-5.00,-5.00,-5.00, 0.02,     
     9 -5.00,-0.54,-5.00,-5.00,-5.00/
c
c  xam = atomic mass (amu)
      data xam/                                                         
     * 1.008,4.003,6.941,9.012,10.81,12.01,14.01,16.00,19.00,20.18,     
     1 22.99,24.31,26.98,28.08,30.97,32.06,35.45,39.95,39.10,40.08,     
     2 44.96,47.90,50.94,52.00,54.94,55.85,58.93,58.71,63.55,65.37,     
     3 69.72,72.59,74.92,78.96,79.90,83.80,85.47,87.62,88.91,91.22,     
     4 92.91,95.94,98.91,101.1,102.9,106.4,107.9,112.4,114.8,118.7,     
     5 121.8,127.6,126.9,131.3,132.9,137.3,138.9,140.1,140.9,144.2,     
     6 145.0,150.4,152.0,157.3,158.9,162.5,164.9,167.3,168.9,173.0,     
     7 175.0,178.5,181.0,183.9,186.2,190.2,192.2,195.1,197.0,200.6,     
     8 204.4,207.2,209.0,210.0,210.0,222.0,223.0,226.0,227.0,232.0,     
     9 231.0,238.0,237.0,244.0,243.0/                                   
c    
c  xchi1 = first ionization potential (ev)   
c  data are mainly from I. S. Grigoriev & E. Z. Meilikhov 1997, Handbook of
c  Physical Quantities, CRC Press, Boca Raton, 516; supplemented
c  by the CRC, 1994 edition; updated from the NIST web site Dec. 2, 2000;
c  just for xchi1 I take the values from the NIST web site, which
c  essentially agree with the CRC values
      data xchi1/                                                       
     * 13.60,24.59,5.392,9.323,8.298,11.26,14.53,13.62,17.42,21.56,     
     1 5.139,7.646,5.986,8.152,10.49,10.36,12.97,15.76,4.340,6.113,     
     2 6.562,6.828,6.746,6.766,7.434,7.902,7.881,7.640,7.726,9.394,     
     3 5.999,7.899,9.789,9.752,11.81,14.00,4.177,5.695,6.217,6.634,     
     4 6.579,7.092, 7.28,7.361,7.459,8.337,7.576,8.994,5.786,7.344,     
     5 8.608,9.010,10.45,12.13,3.894,5.212,5.577,5.539,5.473,5.525,     
     6 5.582,5.644,5.670,6.150,5.864,5.939,6.022,6.108,6.184,6.254,     
     7 5.426,6.825,7.550,7.864,7.834,8.438,8.967,8.959,9.226,10.44,     
     8 6.108,7.417,7.286,8.414,  9.0,10.75,4.073,5.278, 5.17,6.307,     
     9  5.89,6.194,6.266,6.026,5.974/                                   
c
c  xchi2 = second ionization potential (ev)                              
c  a value of 30 in the chi data denotes an unknown value                
      data xchi2/                                                       
     * 50.00,54.42,75.64,18.21,25.16,24.38,29.60,35.12,34.97,40.96,
     * 47.29,15.04,18.83,16.35,19.77,23.34,23.81,27.63,31.63,11.87,
     * 12.80,13.58,14.66,16.50,15.64,16.19,17.08,18.17,20.29,17.96,
     * 20.52,15.94,18.59,21.16,21.81,24.36,27.29,11.03,12.22,13.13,
     * 14.32,16.16,15.26,16.76,18.08,19.43,21.49,16.91,18.87,14.63,
     * 16.53, 18.6,19.13,20.98,23.16,10.00, 11.1, 10.8, 10.6, 10.7,
     *  10.9, 11.1,11.24, 12.1, 11.5, 11.7, 11.8, 11.9, 12.1,12.18,
     *  13.9, 14.9, 16.2, 17.7, 16.6, 17.0,  30.,18.56, 20.5,18.76,
     * 20.43,15.03,16.70, 19.0,  30.,  30., 22.0,10.15,11.75, 11.9,
     *  12.0, 11.9,  30.,  30.,  30./
c
c  xchi3 = third ionization potential (ev)                              
c  a value of 60 in the chi data denotes an unknown value                
c  a valu of 99.99 denotes a very large value
      data xchi3/                                                       
     * 90.00,90.00,122.5,153.9,37.93,47.89,47.45,54.94,62.71,63.46,
     * 71.62,80.14,28.45,33.49,30.20,34.83,39.61,40.91,45.81,50.91,
     * 24.76,27.49,29.31, 31.0,33.67,30.65, 33.5, 35.3,36.84,39.72,
     * 30.73, 34.2, 28.4,30.82, 35.9,36.95, 39.2,42.88,20.53, 23.1,
     *  25.0, 27.2, 29.5, 28.5, 31.1, 32.9, 34.8,37.47, 28.0,30.50,
     * 25.32,27.96, 33.0, 31.0, 33.4, 35.8,19.18,20.20,21.62, 22.1,
     *  22.3, 23.4, 24.9, 20.6, 21.9, 22.8, 22.8, 22.7, 23.7,25.05,
     * 20.96, 23.3,  60.,  60.,  60.,  60.,  60.,  60.,  34., 34.2,
     * 29.85,31.94,25.56,  60.,  60.,  60.,  60.,  60.,  20., 18.3,
     *   60.,  20.,  60.,  60.,  60./
c
c  these partition function constants are from ATLAS9; not that those
c  data do not extend to the third ion (e.g. Ag IV) for elements
c  heavier than Ni, and they should be updated as needed.  Here I
c  simply put placeholder partition function data
      data ((nudata(l,m),l=1,6),m=  1, 20)/
     * 200020001, 200020011, 201620881, 231228281, 378953411,   10,      H  01
     * 100010001, 100010001, 100010001, 100010001, 100010001,   11,
     * 100010001, 100010001, 100010001, 100010001, 100010001,   12,
     * 100010001, 100010001, 100010001, 100010001, 100010001,   13,
     * 100010001, 100010011, 102111241, 145022061, 363059451,   20,      He 02
     * 200020001, 200020071, 208524971, 382669341, 128222452,   21,
     * 100010001, 100010001, 100010001, 100010001, 100010001,   22,
     * 100010001, 100010001, 100010001, 100010001, 100010001,   23,
     * 200020011, 201220481, 212922881, 258731081, 394251691,   30,      Li 03
     * 100010001, 100010201, 126225521,  67216512, 351165562,   31,
     * 200020001, 200020211, 227936571,  69610342, 137217102,   32,
     * 100010001, 100010001, 100010001, 100010001, 100010001,   33,     
     * 100010051, 104311441, 131615641, 190623681, 298037691,   40,      Be 04
     * 200120231, 211422771, 249627631, 309034911, 398545051,   41,
     * 100010001, 100010201, 126225521,  67216512, 351165562,   42,
     * 200020001, 200020011, 201220661, 223426161, 332644691,   43, 
     * 600060001, 600560281, 608761991, 637466191, 693973361,   50,      B  05
     * 100310831, 132016901, 214226411, 315736741, 419147071,   51,
     * 200721061, 233526401, 297533311, 369040481, 440747651,   52,
     * 100010001, 100010001, 100010001, 100010001, 100010001,   53/     
      data ((nudata(l,m),l=1,6),m= 21, 40)/
     * 893292271,  96110042, 105311262, 126315202, 196126432,   60,      C  06
     * 595060251, 620865751, 713280191,  95712292, 167623542,   61,
     * 105513201, 180324851, 341851341,  88416332, 296550722,   62,
     * 204922771, 262630421, 350941931, 494556971, 644872001,   63,
     * 403141851, 457051681, 594071181,  92913362, 203331152,   70,      N  07
     * 919899541, 107211512, 124914302, 182526232, 403762662,   71,
     * 596862721, 684177081,  88110342, 128317062, 239334312,   72,
     * 112816481, 240733751, 462068491, 116419932, 283736822,   73,
     * 874789691, 924795711,  99410492, 115213492, 169022242,   80,      O  08
     * 424151091, 622874781,  91312832, 221842502,  79914013,   81,
     *  95610702, 118113032, 149619922, 329761642, 101914173,   82,
     * 603567171, 775391141, 106612482, 143716252, 181420032,   83,
     * 575958511, 589859231, 595860671, 636470031, 815199581,   90,      F  09
     * 900296401, 102610802, 113912542, 152921152, 318348952,   91,
     * 469162651, 791295541, 121419552, 402686872, 154822203,   92,
     *  99511422, 129214572, 170523002, 320140922, 498458762,   93,
     * 100010001, 100010051, 105313051, 210239461,  74013022,  100,      Ne 10
     * 580158751, 591759741, 642687101, 159332652,  64111533,  101,
     *  93510272, 110411662, 127116062, 257647882,  75110223,  102,
     * 529774371,  94611322, 135816202, 188221442, 240626682,  103/
      data ((nudata(l,m),l=1,6),m= 41, 60)/
     * 200020001, 200320211, 207322131, 253031421, 417657451,  110,      Na 11
     * 100010001, 100010161, 119621261,  50711872, 246445382,  111,
     * 580158751, 591860351,  71813142, 321968812, 106014333,  112,
     *  96910772, 116012242, 130714232, 153916552, 177118872,  113,
     * 100010011, 101410621, 118414581, 204831781, 509479731,  120,      Mg 12
     * 200120051, 202921001, 226926901, 368457091,  92814872,  121,
     * 100010001, 100110611, 177455431, 176546012,  99718753,  122,
     * 579758751, 591459501, 600560591, 611461681, 622362781,  123,
     * 558857701, 583558761, 593260591, 635969541, 796790971,  130,      Al 13
     * 100310211, 110313021, 172828201,  55311252, 215637942,  131,
     * 200320201, 208622331, 250530971, 410251081, 611571211,  132,
     * 100010001, 100210881, 207436531, 523168101, 838999681,  133,
     * 825189211,  95210052, 106211532, 134317202, 237934082,  140,      Si 14
     * 563057761, 588160311, 631768671, 791097651, 127817282,  141,
     * 101110771, 126716471, 232438081,  71914052, 262045302,  142,
     * 200720521, 217224081, 284439171, 551370951,  86810262,  143,
     * 402643441, 496757481, 658274401, 833492941, 103511532,  150,      P  15
     * 874497931, 106011282, 119812802, 138415142, 164717802,  151,
     * 564058061, 604164611, 709579551,  90410172, 112912422,  152,
     * 100811411, 149720221, 280936121, 441552181, 602168241,  153/
      data ((nudata(l,m),l=1,6),m= 61, 80)/
     * 822887891, 930697831, 102610932, 121614492, 185124742,  160,     S  16
     * 443056011, 694982961,  96911522, 144218572, 227326892,  161,
     *  91610392, 113512242, 136416942, 233429882, 364242962,  162,
     * 560058861, 633871081,  82410062, 123314602, 168619132,  163,
     * 538155931, 571657911, 598067191,  89013782, 227737172,  170,     Cl 17
     * 873396771, 104411072, 118513532, 175525872, 406763932,  171,
     * 506569571,  87610522, 134421682, 439092662, 182132573,  172,
     *  95110872, 120013232, 154921252, 345149322, 641378942,  173,
     * 100010001, 100010051, 106913911, 240147261,  90716112,  180,     Ar 18
     * 550256831, 578158781, 636585461, 151530162,  58010303,  181,
     *  92110362, 112412002, 133216772, 254443722,  76512833,  182,
     * 582082081, 103112292, 149920212, 309750502, 720793642,  183,
     * 200020011, 200720361, 211923291, 280137141, 525575741,  190,     K  19
     * 100010001, 100110341, 135929551,  79119282, 405274892,  191,
     * 554657081, 581260301,  73012702, 285363872, 129023363,  192,
     *  96010862, 118413212, 180836632,  90321023, 416863253,  193,
     * 100110061, 104311741, 145919971, 294345051,  69010322,  200,     Ca 20
     * 205822781, 279234761, 427553061, 688994901, 136319772,  201,
     * 100010001, 100510821, 168744821, 130232522,  69012813,  202,
     * 555157161, 585662471,  82816862,  42510013, 168423663,  203/
      data ((nudata(l,m),l=1,6),m= 81,100)/
     * 924696691, 105212282, 151219062, 240530032, 368944512,  210,     Sc 21
     * 190424662, 297634542, 391743752, 482952832, 573761912,  211,
     * 976799291, 101110322, 105810882, 111911502, 118112122,  212,
     * 100010001, 100510821, 168744821, 130232522,  69012813,  213,
     * 181021172, 260333222, 430155582, 710089242, 110213293,  220,     Ti 22
     * 474659872, 721284672,  98211413, 134515623, 177919963,  221,
     * 228327012, 308134272, 381143862, 534563472, 734983512,  222,
     * 971498311,  99210032, 102610572, 108711172, 114711782,  223,
     * 272835172, 425851532, 632278322,  97212013, 146817723,  230,     V  23
     * 373954132, 743597002, 121414713, 173920143, 229225713,  231,
     * 323142642, 519660272, 679975352, 824789522,  96610363,  232,
     * 248329302, 324234952, 373439752, 421744582, 469949412,  233,
     * 717277611,  92911652, 152620872, 295141952, 550468122,  240,     Cr 24
     *  71611552, 205635512, 558281952, 115315823, 205625293,  241,
     * 280639822, 538369722,  87610823, 129115003, 170919183,  242,
     * 377150952, 616070292, 791788382,  97610683, 116012523,  243,
     * 600060321, 629270891,  86911302, 151020222, 267534752,  250,     Mn 25
     * 739594821, 139921212, 309342852, 567372412,  97112553,  251,
     *  98417472, 265535782, 454754842, 641973532, 828792212,  252,
     * 328847052, 586668342, 771785912,  94710343, 112112093,  253/
      data ((nudata(l,m),l=1,6),m=101,120)/
     * 197023222, 274433302, 416753952, 723799822, 139419053,  260,     Fe 26
     * 409453722, 686687452, 110213823, 174322233, 286437043,  261,
     * 262136422, 501167232,  87911303, 138916483, 190721673,  262,
     *  98723522, 420363072,  87011423, 145117913, 215925463,  263,
     * 199427202, 335740022, 474957182, 708090462, 118315403,  270,     Co 27
     * 279739202, 490858232, 684582472, 104713233, 159818733,  271,
     * 279836622, 461857562, 720693022, 124915873, 192522633,  272,
     * 262136422, 501167232,  87911303, 138916483, 190821673,  273,
     * 227027622, 306233052, 356839222, 446052912, 652382292,  280,     Ni 28
     * 108416342, 222428472, 353944332, 577378932, 110314303,  281,
     * 198724282, 293236452, 468362702,  86511123, 136016073,  282,
     * 279836622, 461857562, 720693022, 124915873, 192522633,  283,
     * 201620781, 231026761, 314737361, 450555381, 692386911,  290,     Cu 29
     * 109415761, 247938311,  58910042, 190937022,  68311693,  291,
     * 897195961, 107212972, 165021182, 260230862, 356940532,  292,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  293,
     * 100010001, 100410231, 108712611, 167124841, 388460411,  300,     Zn 30
     * 200020021, 201620761, 223726341, 351352061,  80812472,  301,
     * 100610471, 122617301, 300566361, 149924112, 332342352,  302,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  303/
      data ((nudata(l,m),l=1,6),m=121,140)/
     * 403245601, 493151431, 529654331, 559358091, 611065171,  310,     Ga 31
     *  99710051, 104511541, 135016501, 208226431, 321837921,  311,
     * 199820071, 204521391, 229124761, 266028451, 302932131,  312,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  313,
     * 502665261, 755183501, 901496201, 102410942, 117912812,  320,     Ge 32
     * 422848161, 512153401, 557458941, 636270361, 794489061,  321,
     * 100010261, 114613921, 175221251, 249828711, 324436181,  322,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  323,
     * 403143241, 491856701, 649173781, 840396751, 113013392,  330,     As 33
     * 593676641, 884697521, 105911572, 129515012, 180322212,  331,
     * 484470541,  91510972, 125614082, 157017612, 199722912,  332,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  333,
     * 630172361, 799686381, 919797221, 102810942, 117712832,  340,     Se 34
     * 438055511, 691582151,  94510732, 121413672, 152016732,  341,
     * 651982921,  94610382, 113212492, 139515462, 169718482,  342,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  343,
     * 437347431, 498951671, 538559501,  74710812, 169126672,  350,     Br 35
     * 705183611,  93510092, 111614162, 222932532, 427652992,  351,
     * 510869921,  87410312, 123116552, 236530712, 377744832,  352,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  353/
      data ((nudata(l,m),l=1,6),m=141,160)/
     * 100010001, 100010051, 105012781, 198535971,  65911422,  360,     Kr 36
     * 461049811, 522254261, 609088131, 168935052,  68612253,  361,
     * 759990901, 101911142, 129017782, 302856642,  99414333,  362,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  363,
     * 200020011, 200720361, 211523021, 269434141, 459163351,  370,     Rb 37
     * 100010001, 100110321, 129524961,  61014202, 291753192,  371,
     * 473650891, 533156051,  66810932, 232950852,  99915303,  372,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  373,
     * 100110041, 104111741, 146019721, 281941411, 607785251,  380,     Sr 38
     * 202621931, 255331271, 384347931, 624085761, 122417632,  381,
     * 100010001, 100110321, 129524961,  61014202, 291753192,  382,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  383,
     * 791587851, 100012192, 155119942, 254031782, 389946932,  390,     Y  39
     * 118217102, 220827002, 319036792, 416646512, 513256072,  391,
     *  92510012, 104710862, 112311612, 120212472, 132814282,  392,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  393,
     * 141320802, 291439702, 531170262,  92712273, 162521053,  400,     Zr 40
     * 354454352, 724689652, 107212643, 148517093, 193321573,  401,
     * 209727032, 324537052, 415446282, 510255752, 604965222,  402,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  403/
      data ((nudata(l,m),l=1,6),m=161,180)/
     * 256636022, 465759302, 749693962, 116514243, 171520333,  410,     Nb 41
     * 335157222,  84511463, 147718363, 221826083, 299933893,  411,
     * 223725352, 280830972, 340937362, 406844002, 473150632,  412,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  413,
     * 703972941,  82610822, 154822682, 327244912, 571469372,  420,     Mo 42
     *  75714552, 274347322, 718897632, 123414913, 174920063,  421,
     * 267645462, 669890262, 115514323, 173620673, 242528083,  422,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  423,
     *  90613732, 184823562, 291735332, 419949102, 565764332,  430,     Tc 43
     * 131318312, 227126932, 311735452, 397644072, 483852692,  431,
     * 204721673, 234725733, 284031463, 348738613, 426546943,  432,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  433,
     * 176824122, 318941082, 515263202, 761790472, 106112303,  440,     Ru 44
     * 221934642, 501968372,  88911173, 136316243, 189221613,  441,
     * 210622722, 241025422, 267928262, 297731272, 327834282,  442,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  443,
     * 148520202, 255230902, 364942462, 489656082, 638872352,  450,     Rh 45
     * 153421292, 288137912, 484660322, 720187062, 101011483,  451,
     * 254537212, 492362292, 770592182, 107312243, 137615273,  452,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  443/
      data ((nudata(l,m),l=1,6),m=181,200)/
     * 115919651, 320746011, 607576761,  95011642, 141817172,  460,     Pd 46
     * 755087211, 105913442, 173122222, 282034722, 412247732,  461,
     * 180223462, 289735212, 414247632, 538460052, 662672472,  462,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  463,
     * 200020001, 200220141, 206422141, 257633021, 455164681,  470,     Ag 47
     * 100810581, 125817401, 260641031,  66210072, 135316982,  471,
     * 795887491,  97711762, 156620252, 248329422, 340038582,  472,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  473,
     * 100010001, 100410241, 109212891, 176827421, 444268771,  480,     Cd 48
     * 200020021, 201720921, 233329881, 451475371, 127520782,  481,
     * 100310281, 114815371, 246138311, 519265531, 791492761,  482,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  483,
     * 252431921, 368440461, 433746521, 512259221, 723389021,  490,     In 49
     * 100110071, 104611651, 146118581, 225426511, 304734431,  491,
     * 200120111, 205021611, 243628031, 317035371, 390442701,  492,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  493,
     * 232637101, 488058571, 669074381, 816189091,  97210632,  500,     Sn 50
     * 286335941, 408144471, 479351961, 571862901, 686274341,  501,
     * 100010251, 114013811, 175321601, 256829751, 338337901,  502,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  503/
      data ((nudata(l,m),l=1,6),m=201,220)/
     * 404043481, 494656811, 646772781, 813490751, 101411372,  510,     Sb 51
     * 303147981, 618472951, 827392621, 103711702, 131214532,  511,
     * 313037601, 429347901, 536260591, 689477591, 862494881,  512,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  513,
     * 526258801, 657372351, 784284071, 897095741, 102711082,  520,     Te 52
     * 440855541, 686481251,  93810792, 125414792, 176321132,  521,
     * 349054751, 699883081,  96611302, 134216202, 197724212,  522,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  523,
     * 405342041, 438645621, 475751071, 587974491, 102214572,  530,     I  53
     * 568567471, 773485861,  94510362, 112712182, 130914002,  531,
     * 514269581,  86910562, 130716652, 215327742, 351843662,  532,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  533,
     * 100010001, 100010091, 109515351, 291060661, 119621482,  540,     Xe 54
     * 414844131, 465649111, 538464651,  87112232, 158019362,  541,
     * 615475101, 867797531, 112213462, 157618062, 203622662,  542,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  543,
     * 200020001, 201020501, 215623871, 283536181, 462756261,  550,     Cs 55
     * 100010001, 100310371, 119016501, 269146361,  77912412,  551,
     * 424445601, 481750061, 516953311, 549356551, 581759791,  552,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  553/
      data ((nudata(l,m),l=1,6),m=221,240)/
     * 101210791, 135119351, 282340571, 574580391, 111015062,  560,     Ba 56
     * 262638611, 504160621, 698579371,  91010692, 129115952,  561,
     * 100010001, 100310351, 118416321, 264945521,  76512182,  562,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  563,
     *  71111992, 172323592, 312540402, 510763182, 765791012,  570,     La 57
     * 204529582, 383647882, 582469262, 807992692, 104911723,  571,
     *  94712552, 148416582, 179819212, 203621522, 227424042,  572,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  573,
     * 295959132, 103515693, 215527593, 335939413, 449650223,  580,     Ce 58
     *  79718153, 289639443, 495159253, 686877533, 863794813,  581,
     * 298640242, 475053692, 596965912, 725379692, 872094692,  582,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  583,
     * 460693672, 158523823, 327242303, 519661563, 709379783,  590,     Pr 59
     * 455480232, 114014653, 178521013, 240927073, 299232633,  591,
     *  46410533, 183826893, 354443773, 518459633, 674375243,  592,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  593,
     * 139623042, 364860002,  96114603, 209828633, 373446973,  600,     Nd 60
     * 460493692, 158523823, 327142303, 519661563, 709279783,  601,
     * 455480232, 114014653, 178521013, 240927073, 299232633,  602,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  603/
      data ((nudata(l,m),l=1,6),m=241,260)/
     * 131720482, 280535692, 441254492, 676583972, 103412583,  610,     Pm 61
     * 139623042, 364860002,  96114603, 209828633, 373446973,  611,
     * 460493682, 158523823, 327142303, 519661563, 709279783,  612,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  613,
     *  92915672, 222431062, 444763802,  89612173, 159520253,  620,     Sm 62
     * 315059662,  97114563, 204627093, 342541693, 490556383,  621,
     * 269037812, 520270372,  91111273, 133915483, 172719093,  622,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  623,
     * 800080571, 851699301, 127617362, 240433032, 444958442,  630,     Eu 63
     * 125416052, 211828182, 375549622, 644381732, 101112213,  631,
     * 800080571, 851699301, 127617362, 240433032, 444958442,  632,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  633,
     * 240432982, 427555202, 708489962, 112613853, 167319843,  640,     Gd 64
     * 534793262, 139219123, 247730843, 371043333, 495055893,  641,
     * 364145232, 514756362, 604864112, 673870372, 732276072,  642,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  643,
     * 480767202,  89011393, 144118243, 230028753, 354142883,  650,     Yb 65
     * 480767192,  89011393, 144118243, 230028753, 354142883,  651,
     * 480767202,  89011393, 144118243, 230028753, 354142883,  652,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  653/
      data ((nudata(l,m),l=1,6),m=261,280)/
     * 343147532, 645887152, 115314793, 183322063, 257729373,  660,     Dy 66
     * 343147532, 645887142, 115314793, 183322063, 257729373,  661,
     * 343147532, 645887142, 115314793, 183322063, 257729373,  662,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  663,
     * 222635002, 542276772, 100312353, 145716713, 187020703,  670,     Ho 67
     * 222635002, 542276772, 100312353, 145716713, 187020703,  671,
     * 222635002, 542276772, 100312353, 145716713, 187020703,  672,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  673,
     * 133715382, 209130152, 429859382,  79410293, 129815983,  680,     Er 68
     * 265934782, 497877532, 120517733, 245032063, 400448073,  681,
     * 265934782, 497877532, 120517733, 245032063, 400448073,  682,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  683,
     * 800381111,  87510702, 147621462, 310343462, 585475982,  690,     Tm 69
     * 156718872, 279244452, 678196342, 128316243, 197823443,  691,
     *  93517192, 364666132, 103414613, 192624193, 293334613,  692,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  693,
     * 100010011, 101310651, 118613951, 169120661, 250629971,  700,     Yb 70
     * 200120901, 270345231,  81714042, 223533112, 461959862,  701,
     * 100312561, 250851931,  91914182, 198626022, 323638692,  702,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  703/
      data ((nudata(l,m),l=1,6),m=281,300)/
     * 514664441, 759086851,  99211442, 133315612, 182721252,  710,     Lu 71
     *-125924831, 438667801,  98714112, 199727872, 380850742,  711,
     * 323948621, 661297271, 158626482, 426865032,  93712843,  712,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  713,
     * 659294081, 128016962, 222528952, 372047062, 585171462,  720,     Hf 72
     *  99117882, 274638812, 520867322,  84410313, 123314453,  721,
     * 187427702, 343739872, 448049452, 539358282, 625266642,  722,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  723,
     *  65210892, 171325762, 373552252, 705192012, 116414343,  730,     Ta 73
     * 192837842, 600784802, 111113823, 165419233, 218524383,  731,
     *  99117872, 274638812, 520867312,  84410313, 123314453,  732,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  733,
     * 398981651, 130019172, 273438022, 516168382,  88411163,  740,     Wl 74
     * 131429482, 523279952, 111414623, 183422233, 262130233,  741,
     * 192837842, 600784792, 111113823, 165419233, 218524383,  742,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  743,
     * 600963001,  75910412, 150121572, 301940972, 539168952,  750,     Re 75
     *  73710852, 190731262, 464964142,  83810503, 127315053,  751,
     * 131429482, 523279952, 111414623, 183422233, 262130233,  752,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  753/
      data ((nudata(l,m),l=1,6),m=301,320)/
     * 110815502, 216829732, 398752322, 672484682, 104612673,  760,     Os 76
     * 168225972, 362046562, 566766422, 757484612,  93010103,  761,
     *  73710852, 190731262, 464964142,  83810503, 127315053,  762,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  763,
     * 129117892, 239430882, 388748292, 596173252,  89510843,  770,     Ir 77
     * 110815502, 216829732, 398752322, 672484682, 104612673,  771,
     * 168225972, 362046562, 566766422, 757484612,  93010103,  772,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  773,
     * 158918512, 207523002, 254328242, 316335762, 407246582,  780,     Pt 78
     *  98115462, 224930742, 401150612, 623475412,  89910583,  781,
     * 110815502, 216829732, 398752322, 672484682, 104612673,  782,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  783,
     * 203222611, 265731251, 364042301, 494958601, 702084731,  790,     Au 79
     * 120521331, 357753801,  75310062, 130516572, 206925452,  791,
     * 651780821, 108814772, 195925252, 316338622, 460853882,  792,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  793,
     * 100010001, 100110111, 105211851, 152122101, 341552811,  800,     Hg 80
     * 200320211, 210023021, 268834231, 480472341, 111416912,  801,
     * 104012871, 186129471, 458664151,  82410072, 119013732,  802,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  803/
      data ((nudata(l,m),l=1,6),m=321,340)/
     * 200420711, 222424271, 265429161, 325637371, 442853911,  810,     Tl 81
     * 100010021, 101910801, 121414641, 189525811, 358949721,  811,
     * 200020311, 216624611, 296337451, 489064791,  85711212,  812,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  813,
     * 103411711, 147819101, 244331781, 434862751,  93113762,  820,     Pb 82
     * 204122231, 248227841, 311535621, 429153941, 651976431,  821,
     * 100210131, 106812201, 154522671, 381665951,  95512512,  822,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  823,
     * 400140351, 416944121, 474851591, 564362181, 690477231,  830,     Bi 83
     * 106814451, 204427341, 350744811, 586879131, 108314772,  831,
     * 205523051, 264830231, 345439921, 469156001, 675281671,  832,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  833,
     * 500950661, 518153561, 559058941, 628968071, 748483501,  840,     Po 84
     * 443756241, 696282451,  95411012, 128615262, 182922012,  841,
     * 336953201, 682481011,  93810882, 127915272, 184622442,  842,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  843,
     * 402841621, 431544771, 463148311, 520059491, 734896851,  850,     At 85
     * 576168741, 788387631,  96910642, 116012552, 135014462,  851,
     * 490265341, 812797201, 116614322, 179622692, 285035302,  852,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  853/
      data ((nudata(l,m),l=1,6),m=341,360)/
     * 100010001, 100010031, 102311051, 133018071, 264539391,  860,     Rn 86
     * 402841621, 431544771, 463148311, 520059491, 734996851,  861,
     * 576168741, 788387631,  96910642, 116012552, 135014462,  862,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  863,
     * 200020011, 201220591, 218124481, 296538611, 488859141,  870,     Fr 87
     * 100010001, 100010031, 102311051, 133018071, 264539401,  871,
     * 421645151, 477449611, 511852711, 542455761, 572958821,  872,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  873,
     * 100010041, 105212131, 153220271, 270435641, 460258111,  880,     Ra 88
     * 201221791, 258131471, 381645781, 546365131, 777592781,  881,
     * 100010001, 100010031, 102311051, 133018071, 264539391,  882,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  883,
     * 510064491,  82710872, 142718412, 232328712, 348341572,  890,     Ac 89
     * 228951571,  88513232, 183324132, 305537492, 448152402,  891,
     * 723989131, 103511752, 130814352, 155416652, 177018682,  892,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  893,
     * 620099241, 162725772, 391457072,  80110833, 141818023,  900,     Th 90
     * 620099241, 162725772, 391457072,  80110833, 141818023,  901,
     * 620099251, 162725772, 391457072,  80110833, 141818023,  902,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  903/
      data ((nudata(l,m),l=1,6),m=361,380)/
     * 347877992, 129318323, 240730533, 380546863, 570368573,  910,     Pa 91
     * 347877992, 129318323, 240730533, 380546863, 570368573,  911,
     * 347777992, 129318323, 240730533, 380546863, 570368573,  912,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  913,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  920,     U  92
     * 209530092, 450866762,  96613623, 186524763, 318839893,  921,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  922,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  933,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  930,     Np 93
     * 209530092, 450866762,  96613623, 186524763, 318839893,  931,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  932,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  933,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  940,     Pu 94
     * 209530092, 450866762,  96613623, 186524763, 318839893,  941,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  942,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  943,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  950,     Am 95
     * 209530092, 450866762,  96613623, 186524763, 318839893,  951,
     * 209530092, 450866762,  96613623, 186524763, 318839893,  952,
     * 100010001, 100010001, 100010001, 100010001, 100010001,  953/

c  the *partflag* array signals that a species has a revised partition
c  function by having a non-zero value in the array position for that
c  species; the non-zero number then points to the correct data in
c  the *newpartdata* array of updated coefficients.  For example, 
c  partflag(24,2) = 01, meaning that Cr II has updated partition function
c  coefficients, which can be found in newpartdata(01,1,...,6)
      data ((partflag(l,m),m=1,4),l= 1,40)/
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Be 04
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    O  08
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Mg 12
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    S  16
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Ca 20
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 01,  0,  0,    Cr 24
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Ni 28
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Ge 32
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Kr 36
     . 02,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/    Zr 40
      data ((partflag(l,m),m=1,4),l=41,80)/
     .  0,  0,  0,  0,  0, 03,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Ru 44
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Cd 48
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Te 52
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Ba 56
     .  0,  0,  0,  0,  0,  0,  0,  0, 04, 05,  0,  0, 06, 07,  0,  0,    Nd 60
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,  0, 08,  0,  0,  0,    Gd 64
     . 09, 10, 22,  0, 11, 12, 23,  0,  0, 13, 24,  0, 14, 15, 25,  0,    Er 68
     .  0,  0,  0,  0, 16,  0,  0,  0,  0, 17,  0,  0,  0,  0,  0,  0,    Hf 72
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Os 76
     .  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/    Hg 80
      data ((partflag(l,m),m=1,4),l=81,95)/
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Po 84
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    Ra 88
     .  0,  0,  0,  0, 18, 19, 26,  0,  0,  0,  0,  0,  0, 20, 27,  0,    U  92
     .  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0                /

c  Cr II new partition function coefficients
      data (newpartdata(01,i),i=1,6)/   2.66384894d+3, -1.68227473d+3,
     .  4.22830259d+2, -5.28071678d+1,  3.27472214d+0, -8.05963460d-2/
c  Rb I new partition function coefficients
      data (newpartdata(02,i),i=1,6)/   5.03676283d+3, -3.16069504d+3,
     .  7.89175381d+2, -9.79501783d+1,  6.04047992d+0, -1.47981323d-1/
c  Mo II new partition function coefficients
      data (newpartdata(03,i),i=1,6)/   4.16034835d+3, -2.65480884d+3, 
     .  6.74631372d+2, -8.52665787d+1,  5.35745654d+0, -1.33793443d-1/
c  Pr I new partition function coefficients
      data (newpartdata(04,i),i=1,6)/  -3.04466224d+3,  1.88966140d+3,
     . -4.64804826d+2,  5.66502603d+1, -3.42059183d+0,  8.19184298d-2/
c  Pr II new partition function coefficients (modified June 25, 2008)
      data (newpartdata(05,i),i=1,6)/  -1.91609088d+3,  1.18545447d+3,
     . -2.90543602d+2,  3.52740316d+1, -2.12000090d+0,  5.04914504d-2/
c  Nd I new partition function coefficients
      data (newpartdata(06,i),i=1,6)/  -1.64889203d+3,  9.47177848d+2,
     . -2.12837179d+2,  2.33051095d+1, -1.23575686d+0,  2.52043511d-2/
c  Nd II new partition function coefficients
      data (newpartdata(07,i),i=1,6)/  -2.06698421d+2,  9.79972763d+1,
     . -1.55582617d+1,  7.28892861d-1,  3.56166693d-2, -2.95215536d-3/
c  Gd I new partition function coefficients
      data (newpartdata(08,i),i=1,6)/   1.83011048d+3, -1.19539486d+3,
     .  3.10632505d+2, -4.00859062d+1,  2.56842403d+0, -6.53128117d-2/
c  Tb I new partition function coefficients
      data (newpartdata(09,i),i=1,6)/   5.85584746d+2, -3.89743229d+2,
     .  1.03759088d+2, -1.37350828d+1,  9.03674535d-1, -2.35845042d-2/
c  Tb II new partition function coefficients
      data (newpartdata(10,i),i=1,6)/  -9.48002791d+2,  6.16808235d+2,
     . -1.58524150d+2,  2.01610509d+1, -1.26856460d+0,  3.16355813d-2/
c  Dy I new partition function coefficients
      data (newpartdata(11,i),i=1,6)/   3.53878819d+3, -2.31997287d+3,
     .  6.06023177d+2, -7.87382964d+1,  5.08456496d+0, -1.30426644d-1/
c  Dy II new partition function coefficients
      data (newpartdata(12,i),i=1,6)/   2.77061687d+3, -1.78523018d+3,
     .  4.58361896d+2, -5.85341812d+1,  3.71600397d+0, -9.37402524d-2/
c  Ho II new partition function coefficients
      data (newpartdata(13,i),i=1,6)/   1.34187596d+3, -8.52533583d+2,
     .  2.15784324d+2, -2.71271661d+1,  1.69281185d+0, -4.19020326d-2/
c  Er I new partition function coefficients
      data (newpartdata(14,i),i=1,6)/   2.02411710d+3, -1.35836078d+3,
     .  3.62878018d+2, -4.81385931d+1,  3.16795944d+0, -8.26308027d-2/
c  Er II new partition function coefficients
      data (newpartdata(15,i),i=1,6)/   1.62058945d+3, -1.06472504d+3,
     .  2.78625547d+2, -3.62193240d+1,  2.33715989d+0, -5.98219225d-2/
c  Yb I new partition function coefficients
      data (newpartdata(16,i),i=1,6)/   7.47839800d+3, -4.67427018d+3,
     .  1.16206341d+3, -1.43581759d+2,  8.81293038d+0, -2.14850223d-1/
c  Lu II new partition function coefficients
      data (newpartdata(17,i),i=1,6)/   2.44026764d+3, -1.59016793d+3,
     .  4.12298445d+2, -5.31395892d+1,  3.40232351d+0, -8.65004469d-2/
c  Th I new partition function coefficients
      data (newpartdata(18,i),i=1,6)/   4.76054139d+2, -3.25783548d+2,
     .  8.97134083d+1, -1.23483587d+1,  8.46088455d-1, -2.29570332d-2/
c  Th II new partition function coefficients
      data (newpartdata(19,i),i=1,6)/  -1.22179869d+3,  7.59698688d+2, 
     . -1.86944859d+2,  2.27591989d+1, -1.37021999d+0,  3.26865578d-2/
c  U II new partition function coefficients
      data (newpartdata(20,i),i=1,6)/  -2.76709404d+2,  1.30426239d+2,
     . -2.06221054d+1,  9.83307627d-1,  4.19297328d-2, -3.60428836d-3/
c  Eu III partition function coefficients (Irwin 1981)
      data (newpartdata(21,i),i=1,6)/  -2.02846263d+3,  1.24521575d+3,
     . -3.04725159d+2,  3.72010364d+1, -2.26584074d+0,  5.50893177d-2/
c  Tb III partition function coefficients (Irwin 1981)
      data (newpartdata(22,i),i=1,6)/   8.11558123d+2, -4.67434582d+2,
     .  1.07583056d+2, -1.23251149d+1,  7.02860514d-1, -1.59394115d-2/
c  Dy III partition function coefficients (Irwin 1981)
      data (newpartdata(23,i),i=1,6)/   1.30822682d+3, -7.46679156d+2,
     .  1.69716518d+2, -1.91592590d+1,  1.07376244d+0, -2.38653520d-2/
c  Ho III partition function coefficients (Irwin 1981)
      data (newpartdata(24,i),i=1,6)/   6.98122851d+3, -4.11418184d+3,
     .  9.66307217d+2, -1.13063284d+2,  6.59141456d+0, -1.53163679d-1/
c  Er III partition function coefficients (Irwin 1981)
      data (newpartdata(25,i),i=1,6)/   2.65562213d+3, -1.49666461d+3,
     .  3.34740125d+2, -3.70678109d+1,  2.02963822d+0, -4.38640816d-2/
c  Th III partition function coefficients (Irwin 1981)
      data (newpartdata(26,i),i=1,6)/   7.10076650d+3, -4.15762991d+3,
     .  9.69365844d+2, -1.12510812d+2,  6.50161887d+0, -1.49626283d-1/
c  U III partition function coefficients (Irwin 1981)
      data (newpartdata(27,i),i=1,6)/   5.18480529d+3, -3.02564444d+3,
     .  7.03396006d+2, -8.14028851d+1,  4.68959696d+0, -1.07563314d-1/
c  Ir II partition function coefficients (Irwin 1981)
      data (newpartdata(28,i),i=1,6)/   2.33935909d+2, -1.43786065d+2,
     .  3.57641903d+1, -4.45430703d+0,  2.77258541d-1, -6.86047013d-3/


      end

